/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.api.script;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class AfterDataSetFilled
extends ChartTestCase {
    private Chart cm = this.createChart();

    public static void main(String[] args) {
        new AfterDataSetFilled();
    }

    public AfterDataSetFilled() {
        this.bindGroupingData(this.cm);
    }

    private void bindGroupingData(Chart chart) {
        final Object[][] data = new Object[][]{{"x1", new Integer(1), "g1"}, {"x2", new Integer(2), "g2"}, {"x3", new Integer(3), "g1"}, {"x4", new Integer(4), "g3"}, {"x5", new Integer(5), "g2"}, {"x6", new Integer(6), "g1"}, {"x7", new Integer(7), "g3"}, {"x8", new Integer(8), "g2"}, {"x9", new Integer(9), "g2"}, {"x0", new Integer(0), "g2"}};
        try {
            Generator gr = Generator.instance();
            gr.bindData(new IDataRowExpressionEvaluator(){
                int idx = 0;

                public void close() {
                }

                public Object evaluate(String expression) {
                    if ("X".equals(expression)) {
                        return data[this.idx][0];
                    }
                    if ("Y".equals(expression)) {
                        return data[this.idx][1];
                    }
                    if ("G".equals(expression)) {
                        return data[this.idx][2];
                    }
                    return null;
                }

                public Object evaluateGlobal(String expression) {
                    return this.evaluate(expression);
                }

                public boolean first() {
                    this.idx = 0;
                    return true;
                }

                public boolean next() {
                    ++this.idx;
                    return this.idx < 9;
                }
            }, chart, new RunTimeContext());
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    private Chart createChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setScript("function afterDataSetFilled( series, idsp,Iicsc ){importPackage(Packages.java.lang); if (series.getLabel().isVisible() == true){System.out.println(\"ok\");} else{System.out.println(\"false\");}} ");
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        Series seCategory = SeriesImpl.create();
        Query xQ = QueryImpl.create((String)"G");
        seCategory.getDataDefinition().add((Object)xQ);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        sdX.setSorting(SortOption.ASCENDING_LITERAL);
        sdX.getGrouping().setEnabled(true);
        sdX.getGrouping().setGroupType(DataType.TEXT_LITERAL);
        sdX.getGrouping().setAggregateExpression("Sum");
        sdX.getGrouping().setGroupingInterval(0.0);
        LineSeries bs = (LineSeries)LineSeriesImpl.create();
        bs.getLabel().setVisible(true);
        Query yQ = QueryImpl.create((String)"Y");
        bs.getDataDefinition().add((Object)yQ);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update(0);
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

