/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetHandleAdapter;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.interfaces.IAbstractThemeModel;

public abstract class AbstractThemeHandle
extends ReportElementHandle
implements IAbstractThemeModel {
    public AbstractThemeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public final SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public final List<DesignElementHandle> getAllStyles() {
        AbstractTheme theme = (AbstractTheme)this.getElement();
        ArrayList<DesignElementHandle> styles = new ArrayList<DesignElementHandle>();
        List<StyleElement> styleList = theme.getAllStyles();
        for (StyleElement style : styleList) {
            styles.add(style.getHandle(this.module));
        }
        return styles;
    }

    public final StyleHandle findStyle(String name) {
        AbstractTheme theme = (AbstractTheme)this.getElement();
        StyleElement style = theme.findStyle(name);
        if (style != null) {
            return (StyleHandle)style.getHandle(this.module);
        }
        return null;
    }

    final String makeUniqueStyleName(String name) {
        assert (this != null);
        SlotHandle styles = this.getStyles();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < styles.getCount()) {
            StyleHandle style = (StyleHandle)styles.get(i);
            set.add(style.getName());
            ++i;
        }
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        if (propHandle != null) {
            Iterator iterator = propHandle.iterator();
            while (iterator.hasNext()) {
                IncludedCssStyleSheetHandle handle = (IncludedCssStyleSheetHandle)iterator.next();
                set.add(handle.getFileName());
            }
        }
        int index = 0;
        String baseName = name;
        while (set.contains(name)) {
            name = baseName + ++index;
        }
        return name;
    }

    @Override
    public final String getDisplayLabel(int level) {
        String displayLabel = super.getDisplayLabel(level);
        Module rootModule = this.getModule();
        if (rootModule instanceof Library) {
            displayLabel = StringUtil.buildQualifiedReference(((Library)rootModule).getNamespace(), displayLabel);
        }
        return displayLabel;
    }

    public final Iterator includeCssesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        return propHandle == null ? Collections.emptyList().iterator() : propHandle.iterator();
    }

    public List<CssStyleSheetHandle> getAllCssStyleSheets() {
        AbstractTheme theme = (AbstractTheme)this.getElement();
        ArrayList<CssStyleSheetHandle> allStyles = new ArrayList<CssStyleSheetHandle>();
        List<CssStyleSheet> csses = theme.getCsses();
        int i = 0;
        while (csses != null && i < csses.size()) {
            CssStyleSheet sheet = csses.get(i);
            allStyles.add(sheet.handle(this.getModule()));
            ++i;
        }
        return allStyles;
    }

    public void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(sheetHandle);
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        if (cssStruct == null) {
            return;
        }
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(cssStruct);
    }

    @Deprecated
    public void addCss(String fileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(fileName);
    }

    public void addCssByProerties(String fileName, String externalCssURI, boolean isUseExternalCss) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCssbyProperties(fileName, externalCssURI, isUseExternalCss);
    }

    public void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.dropCss(sheetHandle);
    }

    public boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canDropCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(sheetHandle);
    }

    @Deprecated
    public boolean canAddCssStyleSheet(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(fileName);
    }

    public boolean canAddCssStyleSheetByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheetByProperties(fileName, externalCssURI, useExternalCss);
    }

    public void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.reloadCss(sheetHandle);
    }

    @Deprecated
    public CssStyleSheetHandle findCssStyleSheetHandleByName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findCssStyleSheetHandleByFileName(fileName);
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findCssStyleSheetHandleByProperties(fileName, externalCssURI, useExternalCss);
    }

    @Deprecated
    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findIncludedCssStyleSheetHandleByFileName(fileName);
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findIncludedCssStyleSheetHandleByProperties(fileName, externalCssURI, useExternalCss);
    }

    @Deprecated
    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.renameCss(handle, newFileName);
    }

    public void renameCssByProperties(IncludedCssStyleSheetHandle handle, String newFileName, String externalCssURI, boolean useExternalCss) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.renameCssByProperties(handle, newFileName, externalCssURI, useExternalCss);
    }

    @Deprecated
    public boolean canRenameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canRenameCss(handle, newFileName);
    }

    public boolean canRenameCssByProperties(IncludedCssStyleSheetHandle handle, String newFileName, String externalCssURI, boolean useExternalCss) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canRenameCssByProperties(handle, newFileName, externalCssURI, useExternalCss);
    }
}

