/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.IOException;
import org.eclipse.birt.core.archive.RAOutputStream;

public class ByteArrayRAOutputStream
extends RAOutputStream {
    byte[] buffer;
    int length;
    int offset;
    private byte[] writeBuffer = new byte[8];

    public ByteArrayRAOutputStream() {
        this(1024);
    }

    public ByteArrayRAOutputStream(int size) {
        this.buffer = new byte[size];
        this.length = 0;
        this.offset = 0;
    }

    public long getOffset() throws IOException {
        return this.offset;
    }

    public long length() throws IOException {
        return this.length;
    }

    public void writeInt(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 24);
        this.writeBuffer[1] = (byte)(v >>> 16);
        this.writeBuffer[2] = (byte)(v >>> 8);
        this.writeBuffer[3] = (byte)(v >>> 0);
        this.write(this.writeBuffer, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.write(this.writeBuffer, 0, 8);
    }

    public void seek(long localPos) throws IOException {
        this.offset = (int)localPos;
        if (this.offset > this.buffer.length) {
            this.increase_buffer(this.offset);
        }
        if (this.offset > this.length) {
            this.length = this.offset;
        }
    }

    public void write(int b) throws IOException {
        this.increase_buffer(this.offset + 1);
        this.buffer[this.offset] = (byte)(b & 0xFF);
        ++this.offset;
        if (this.length < this.offset) {
            this.length = this.offset;
        }
    }

    public void write(byte[] buff, int off, int len) throws IOException {
        this.increase_buffer(this.offset + len);
        System.arraycopy(buff, off, this.buffer, this.offset, len);
        this.offset += len;
        if (this.length < this.offset) {
            this.length = this.offset;
        }
    }

    private void increase_buffer(int size) {
        if (size > this.buffer.length) {
            int new_size = (size / 1024 + 1) * 1024;
            byte[] new_buffer = new byte[new_size];
            System.arraycopy(this.buffer, 0, new_buffer, 0, this.length);
            this.buffer = new_buffer;
        }
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.length];
        System.arraycopy(this.buffer, 0, buf, 0, this.length);
        return buf;
    }
}

