/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.script.JSDimensionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSLevelAccessor
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private ICubeQueryDefinition cubeQueryDefn;
    private Map dims = new HashMap();

    public JSLevelAccessor(ICubeQueryDefinition defn, BirtCubeView cursor) throws OLAPException {
        this.cubeQueryDefn = defn;
        if (cursor.getPageEdgeView() != null && this.cubeQueryDefn.getEdge(3) != null) {
            this.populateDimensionObjects(this.cubeQueryDefn.getEdge(3).getDimensions(), cursor.getPageEdgeView().getEdgeCursor().getDimensionCursor().iterator());
        }
        if (cursor.getRowEdgeView() != null && this.cubeQueryDefn.getEdge(1) != null) {
            this.populateDimensionObjects(this.cubeQueryDefn.getEdge(1).getDimensions(), cursor.getRowEdgeView().getEdgeCursor().getDimensionCursor().iterator());
        }
        if (cursor.getColumnEdgeView() != null && this.cubeQueryDefn.getEdge(2) != null) {
            this.populateDimensionObjects(this.cubeQueryDefn.getEdge(2).getDimensions(), cursor.getColumnEdgeView().getEdgeCursor().getDimensionCursor().iterator());
        }
    }

    private void populateDimensionObjects(List dimList, Iterator cursors) throws OLAPException {
        int i = 0;
        while (i < dimList.size()) {
            IDimensionDefinition dimDefn = (IDimensionDefinition)dimList.get(i);
            IHierarchyDefinition hier = dimDefn.getHierarchy().get(0);
            ArrayList<String> levelNames = new ArrayList<String>();
            ArrayList dimCursors = new ArrayList();
            int j = 0;
            while (j < hier.getLevels().size()) {
                levelNames.add(hier.getLevels().get(j).getName());
                dimCursors.add(cursors.next());
                ++j;
            }
            this.dims.put(dimDefn.getName(), new JSDimensionObject(levelNames, dimCursors));
            ++i;
        }
    }

    public String getClassName() {
        return "JSDimensionObject";
    }

    public Object get(String name, Scriptable start) {
        if (!this.dims.containsKey(name)) {
            throw new RuntimeException((Throwable)((Object)new DataException("data.olap.dimensionNameNotFound", name)));
        }
        return this.dims.get(name);
    }
}

