/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class PreparedStatementTest
extends ConnectionTest {
    private PreparedStatement m_statement;

    @Before
    public void preparedStatementSetUp() throws Exception {
        String command = "select * from \"testtable\" where \"intColumn\" > ?";
        this.reprepareStatement(command);
    }

    @After
    public void preparedStatementTearDown() throws Exception {
        this.m_statement.close();
    }

    public final void testFindInParameter() throws DataException {
        try {
            this.m_statement.findInParameter("someParamName");
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotFindInParameter");
            Assert.assertEquals((Object)"No named Parameter supported.", (Object)ex.getCause().getMessage());
        }
    }

    public final void testSetParameterValueintObject0() throws DataException {
        this.m_statement.setParameterValue(1, (Object)new Integer(4));
        this.testParamExecute(2);
    }

    public final void testSetParameterValueintObject1() {
        try {
            this.m_statement.setParameterValue(2, (Object)new Integer(4));
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotSetStringParameter");
        }
    }

    public final void testSetParameterValueBooleanTrue() throws DataException {
        this.m_statement.setParameterValue(1, (Object)new Boolean("true"));
        this.testParamExecute(3);
    }

    public final void testSetParameterValueBooleanFalse() throws DataException {
        this.m_statement.setParameterValue(1, (Object)new Boolean("false"));
        this.testParamExecute(3);
    }

    public final void testSetParameterValueDoubleObject() throws DataException {
        String command = "select * from \"testtable\" where \"doubleColumn\" < ?";
        this.reprepareStatement(command);
        this.m_statement.setParameterValue(1, (Object)new Double(12.3636));
        this.testParamExecute(3);
    }

    public final void testSetParameterValueStringObject() throws DataException {
        String command = "select * from \"testtable\" where \"stringColumn\" between ? and ?";
        this.reprepareStatement(command);
        this.m_statement.setParameterValue(1, (Object)"blah blah blah");
        this.m_statement.setParameterValue(2, (Object)"seven zero six");
        this.testParamExecute(4);
    }

    public final void testSetParameterValueDateObject() throws DataException {
        String command = "select * from \"testtable\" where \"dateColumn\" < ?";
        this.reprepareStatement(command);
        this.m_statement.setParameterValue(1, (Object)Date.valueOf("1999-01-01"));
        this.testParamExecute(2);
    }

    public final void testSetParameterValueDecimalObject() throws DataException {
        String command = "select * from \"testtable\" where \"decimalColumn\" = ? OR \"decimalColumn\" = ?";
        this.reprepareStatement(command);
        this.m_statement.setParameterValue(1, (Object)new BigDecimal(10));
        this.m_statement.setParameterValue(2, (Object)new BigDecimal(10000));
        this.testParamExecute(3);
    }

    public final void testSetParameterNullValue() throws DataException {
        String command = "select * from \"testtable\" where \"stringColumn\" like ? ";
        this.reprepareStatement(command);
        boolean hasError = false;
        try {
            this.m_statement.setParameterValue(1, null);
            this.m_statement.execute();
        }
        catch (Exception e) {
            hasError = true;
        }
        Assert.assertFalse((boolean)hasError);
    }

    public final void testSetParameterNullValueForPrimitiveType() throws DataException {
        String command = "select * from \"testtable\" where \"doubleColumn\" < ?";
        PreparedStatement myStmt = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        boolean hasError = false;
        try {
            myStmt.setParameterValue(1, null);
        }
        catch (Exception e) {
            hasError = true;
        }
        myStmt.close();
        Assert.assertFalse((boolean)hasError);
    }

    private void testParamExecute(int rowsExpected) throws DataException {
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet result = this.m_statement.getResultSet(1);
        Assert.assertNotNull((Object)result);
        int count = 0;
        while (result.fetch() != null) {
            ++count;
        }
        Assert.assertEquals((long)rowsExpected, (long)count);
    }

    public final void testSetParameterValueInvalidParam() throws DataException {
        try {
            this.m_statement.setParameterValue("someParamName", (Object)new Integer(1));
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotSetStringParameter");
        }
    }

    public final void testClearParameterValues1() throws DataException {
        this.prepareForClearParameterTests();
        try {
            this.m_statement.execute();
            Assert.fail();
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotExecuteStatement");
        }
    }

    public final void testClearParameterValues2() throws DataException {
        this.prepareForClearParameterTests();
        this.m_statement.setParameterValue(1, (Object)new BigDecimal(600));
        this.m_statement.setParameterValue(2, (Object)new BigDecimal(10000));
        this.testParamExecute(2);
    }

    private void prepareForClearParameterTests() throws DataException {
        String command = "select * from \"testtable\" where \"decimalColumn\" = ? OR \"decimalColumn\" = ?";
        this.reprepareStatement(command);
        this.m_statement.setParameterValue(1, (Object)new BigDecimal(10));
        this.m_statement.setParameterValue(2, (Object)new BigDecimal(10000));
        this.testParamExecute(3);
        this.m_statement.clearParameterValues();
    }

    private void reprepareStatement(String queryText) throws DataException {
        if (this.m_statement != null) {
            this.m_statement.close();
        }
        this.m_statement = this.getConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
    }
}

