/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtDateTimeTest
extends TestCase {
    private Context cx;
    private Scriptable scope;
    private static final int CURRENT_YEAR = Calendar.getInstance().get(1);

    @Before
    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        this.scope.put("org.eclipse.birt.core.script.functionservice.context.functionBean", this.scope, (Object)new IScriptFunctionContext(){

            public Object findProperty(String name) {
                return null;
            }
        });
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    @Test
    public void testYear() {
        String script1 = "BirtDateTime.year(new Date(23,11,11))";
        BirtDateTimeTest.assertTrue((((Number)this.cx.evaluateString(this.scope, script1, "inline", 1, null)).intValue() == 1923 ? 1 : 0) != 0);
    }

    @Test
    public void testQuarter() {
        String script1 = "BirtDateTime.quarter(\"1905-10-11\")";
        String script2 = "BirtDateTime.quarter( new Date( 05,11,15))";
        String script3 = "BirtDateTime.quarter(\"1900-3-15\")";
        String script4 = "BirtDateTime.quarter( new Date( 0,11,15))";
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script1, "inline", 1, null)).intValue(), (int)4);
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script2, "inline", 1, null)).intValue(), (int)4);
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script3, "inline", 1, null)).intValue(), (int)1);
        BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, script4, "inline", 1, null)).intValue(), (int)4);
    }

    @Test
    public void testMonthDate() {
        String script1 = "BirtDateTime.month(new Date(75,0,15),1)";
        String script2 = "BirtDateTime.month( new Date( 105,11,15),1)";
        String script3 = "BirtDateTime.month(\"1900-3-15\",1)";
        String script4 = "BirtDateTime.month( new Date( 10,11,15),1)";
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)"1");
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (String)"12");
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script3, "inline", 1, null)), (String)"3");
        BirtDateTimeTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script4, "inline", 1, null)), (String)"12");
    }

    @Test
    public void testWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.week(new Date(2006, 0, 1) )", "BirtDateTime.week(new Date(2006, 0, 3) )", "BirtDateTime.week(new Date(2006, 0, 7) )", "BirtDateTime.week(new Date(2006, 0, 8) )", "BirtDateTime.week(new Date(2006, 0, 14))"};
        int[] values = new int[]{this.weekOfYear(2006, 0, 1), this.weekOfYear(2006, 0, 3), this.weekOfYear(2006, 0, 7), this.weekOfYear(2006, 0, 8), this.weekOfYear(2006, 0, 14)};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((String)("" + i), (int)values[i], (int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue());
            ++i;
        }
        ULocale oldDefault = ULocale.getDefault();
        ULocale.setDefault((ULocale)ULocale.FRANCE);
        scripts = new String[]{"BirtDateTime.week(new Date(2016, 0, 1) )", "BirtDateTime.week(new Date(2016, 0, 3) )", "BirtDateTime.week(new Date(2016, 0, 7) )"};
        values = new int[]{53, 53, 1};
        int i2 = 0;
        while (i2 < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i2], "inline", 1, null)).intValue(), (int)values[i2]);
            ++i2;
        }
        ULocale.setDefault((ULocale)ULocale.US);
        values = new int[]{1, 2, 2};
        i2 = 0;
        while (i2 < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i2], "inline", 1, null)).intValue(), (int)values[i2]);
            ++i2;
        }
        ULocale.setDefault((ULocale)oldDefault);
    }

    private int weekOfYear(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.get(3);
    }

    @Test
    public void testDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.day(new Date(2006, 0, 1) )", "BirtDateTime.day(new Date(2006, 0, 3) )", "BirtDateTime.day(new Date(1980, 0, 1, 0, 0, 10))", "BirtDateTime.day(new Date(1980, 3, 9, 11, 0, 0) )", "BirtDateTime.day(new Date(1980, 4, 9, 23, 0, 0) )"};
        int[] values = new int[]{this.dayOfMonth(2006, 0, 1), this.dayOfMonth(2006, 0, 3), this.dayOfMonth(1980, 0, 1), this.dayOfMonth(1980, 3, 9), this.dayOfMonth(1980, 4, 9)};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((String)("" + i), (int)values[i], (int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue());
            ++i;
        }
    }

    private int dayOfMonth(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month, day, 0, 0, 0);
        return calendar.get(5);
    }

    @Test
    public void testWeekDayDate() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.weekDay(new Date(2006, 0, 1), 1 )", "BirtDateTime.weekDay(new Date(2006, 0, 3), 1 )", "BirtDateTime.weekDay(new Date(2006, 0, 7), 1 )", "BirtDateTime.weekDay(new Date(2006, 0, 8), 1 )", "BirtDateTime.weekDay(new Date(1780, 0, 1, 0, 30))", "BirtDateTime.weekDay(new Date(1780, 0, 2, 0, 30))", "BirtDateTime.weekDay(new Date(1780, 0, 8, 0, 30))", "BirtDateTime.weekDay(new Date(1780, 0, 9, 0, 30))", "BirtDateTime.weekDay(new Date(2006, 0, 1), 2 )", "BirtDateTime.weekDay(new Date(2006, 0, 3), 2 )", "BirtDateTime.weekDay(new Date(2006, 0, 7), 2 )", "BirtDateTime.weekDay(new Date(2006, 0, 8), 2 )", "BirtDateTime.weekDay(new Date(1780, 0, 1, 0, 30), 2)", "BirtDateTime.weekDay(new Date(1780, 0, 2, 0, 30), 2)", "BirtDateTime.weekDay(new Date(1780, 0, 8, 0, 30), 2)", "BirtDateTime.weekDay(new Date(1780, 0, 9, 0, 30), 2)", "BirtDateTime.weekDay(new Date(2006, 0, 1), 3 )", "BirtDateTime.weekDay(new Date(2006, 0, 3), 3 )", "BirtDateTime.weekDay(new Date(2006, 0, 7), 3 )", "BirtDateTime.weekDay(new Date(2006, 0, 8), 3 )", "BirtDateTime.weekDay(new Date(1780, 0, 1, 0, 30), 3)", "BirtDateTime.weekDay(new Date(1780, 0, 2, 0, 30), 3)", "BirtDateTime.weekDay(new Date(1780, 0, 8, 0, 30), 3)", "BirtDateTime.weekDay(new Date(1780, 0, 9, 0, 30), 3)"};
        String[] values = new String[]{"1", "3", "7", "1", "7", "1", "7", "1", "7", "2", "6", "7", "6", "7", "6", "7", "6", "1", "5", "6", "5", "6", "5", "6"};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((String)("" + i), (Object)values[i], (Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null));
            ++i;
        }
    }

    @Test
    public void testToday() {
        Calendar c = Calendar.getInstance();
        c.clear();
        Date d = (Date)this.cx.evaluateString(this.scope, "BirtDateTime.today()", "inline", 1, null);
        c.setTime(d);
        System.out.println("year:" + c.get(1) + " month:" + c.get(2) + " day:" + c.get(5) + " hour:" + c.get(10));
    }

    @Test
    public void testNow() {
        Calendar c = Calendar.getInstance();
        c.clear();
        Date d = (Date)this.cx.evaluateString(this.scope, "BirtDateTime.now()", "inline", 1, null);
        c.setTime(d);
        System.out.println("year:" + c.get(1) + " month:" + c.get(2) + " day:" + c.get(5) + " hour:" + c.get(10) + " minute:" + c.get(12) + "second:" + c.get(13));
    }

    @Test
    public void testDiffYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(2007, 0, 15) )", "BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(2007, 11, 15) )", "BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(2007, 12, 15) )", "BirtDateTime.diffYear(new Date(2007, 10, 15),new Date(2005, 0, 15) )", "BirtDateTime.diffYear(new Date(2005, 10, 15),new Date(1793, 0, 15) )"};
        int[] values = new int[]{2, 2, 3, -2, -212};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testDiffMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffMonth(new Date(2005, 10, 15),new Date(2007, 0, 8) )", "BirtDateTime.diffMonth(new Date(2005, 10, 15),new Date(2007, 11, 15) )", "BirtDateTime.diffMonth(new Date(2005, 10, 15),new Date(2007, 12, 15) )", "BirtDateTime.diffMonth(new Date(2007, 10, 15),new Date(2005, 0, 1) )", "BirtDateTime.diffMonth(new Date(1910, 10, 15),new Date(1890, 0, 15) )"};
        int[] values = new int[]{14, 25, 26, -34, -250};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testDiffQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffQuarter(new Date(2005, 10, 15),new Date(2007, 0, 8) )", "BirtDateTime.diffQuarter(new Date(2005, 10, 15),new Date(2007, 11, 15) )", "BirtDateTime.diffQuarter(new Date(2005, 10, 15),new Date(2007, 12, 15) )", "BirtDateTime.diffQuarter(new Date(2007, 10, 15),new Date(2005, 0, 1) )", "BirtDateTime.diffQuarter(new Date(1910, 10, 15),new Date(1890, 0, 15) )"};
        int[] values = new int[]{5, 8, 9, -11, -83};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testDiffWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffWeek(new Date(1900, 0, 8),new Date(1900, 0, 6) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2006, 0, 7) )", "BirtDateTime.diffWeek(new Date(2006, 0, 1),new Date(2006, 0, 8) )", "BirtDateTime.diffWeek(new Date(1779, 11, 31),new Date(1780, 0, 1) )", "BirtDateTime.diffWeek(new Date(1780, 0, 1, 0, 30),new Date(1780, 0, 2, 0, 30) )", "BirtDateTime.diffWeek(new Date(1780, 0, 1, 0, 30),new Date(1780, 0, 8, 0, 30) )", "BirtDateTime.diffWeek(new Date(1780, 0, 1, 0, 30),new Date(1780, 0, 9, 0, 30) )"};
        int[] nArray = new int[9];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[4] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        int[] values = nArray;
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((String)("" + i), (int)values[i], (int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue());
            ++i;
        }
    }

    @Test
    public void testDiffDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffDay(new Date(1900, 0, 8),new Date(1900, 0, 6) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 1, 7) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 2, 7) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2006, 2, 8) )", "BirtDateTime.diffDay(new Date(2006, 0, 1),new Date(2007, 2, 8) )"};
        int[] values = new int[]{-2, -1, 2, 37, 65, 66, 431};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testDiffHour() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffHour(new Date(1900, 0, 8),new Date(1900, 0, 6) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 1, 7) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 2, 7,11,2,0) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2006, 2, 8,22,0,0) )", "BirtDateTime.diffHour(new Date(2006, 0, 1),new Date(2007, 2, 8) )"};
        int[] values = new int[]{-48, -24, 48, 888, 1571, 1606, 10344};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testDiffMinute() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffMinute(\"1930-1-8 12:1:1\",\"1930-1-8 12:2:58\" )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2005, 11, 31) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 1, 7) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 2, 7,11,2,0) )", "BirtDateTime.diffMinute(new Date(2006, 0, 1),new Date(2006, 2, 8,22,3,0) )", "BirtDateTime.diffMinute(\"1993-1-1\",new Date(1994, 2, 8) )"};
        int[] values = new int[]{1, -1440, 2880, 53280, 94262, 96363, 620640};
        int i = 0;
        while (i < values.length) {
            System.out.println(i);
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testDiffSecond() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.diffSecond(new Date(1900, 0, 8,12,1,1),new Date(1900, 0, 8,12,2,58) )", "BirtDateTime.diffSecond(new Date(1900, 0, 8,12,1,58),new Date(1900, 0, 8,12,2,1) )", "BirtDateTime.diffSecond(new Date(2006, 0, 1),new Date(2006, 0, 3) )", "BirtDateTime.diffSecond(new Date(2006, 0, 1),new Date(2006, 2, 8,22,3,0) )", "BirtDateTime.diffSecond(\"1993-1-1\",new Date(1994, 2, 8) )"};
        int[] values = new int[]{117, 3, 172800, 5781780, 37238400};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((int)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).intValue(), (int)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addYear(new Date(2005, 10, 15),10 )", "BirtDateTime.addYear(\"1910-11-15\",10 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2015, 10, 15);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1920, 10, 15);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d3};
        int i = 1;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addMonth(new Date(2005, 10, 15),10 )", "BirtDateTime.addMonth(\"1995-1-15\",10 )", "BirtDateTime.addMonth(\"1940-2-15\",11 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2006, 8, 15);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1941, 0, 15);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addQuarter(new Date(2005, 10, 15),2 )", "BirtDateTime.addQuarter(\"1995-1-15\",9 )", "BirtDateTime.addQuarter(\"1930-6-15\",11 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2006, 4, 15);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1997, 3, 15);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1933, 2, 15);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addWeek(new Date(2005, 10, 15),1 )", "BirtDateTime.addWeek(new Date(2006, 9, 15),3 )", "BirtDateTime.addWeek(\"1995-11-15\",2 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 29);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addDay(new Date(2005, 10, 15),7 )", "BirtDateTime.addDay(new Date(2006, 9, 15),21 )", "BirtDateTime.addDay(\"1995-11-15\",10 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 22);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 10, 5);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 25);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddHour() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addHour(new Date(2005, 10, 15),7*24 )", "BirtDateTime.addHour(new Date(2006, 9, 15),21*24 )", "BirtDateTime.addHour(\"1995-11-15\",10 )", "BirtDateTime.addHour(null,21*24 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 15);
        c.add(10, 168);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 9, 15);
        c.add(10, 504);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15);
        c.add(10, 10);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        c.add(10, 504);
        c.clear();
        Date[] dateArray = new Date[4];
        dateArray[0] = d1;
        dateArray[1] = d2;
        dateArray[2] = d3;
        Date[] values = dateArray;
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddMinute() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addMinute(new Date(2005, 10, 15),7*24*60 )", "BirtDateTime.addMinute(new Date(2006, 9, 15),21*24*60 )", "BirtDateTime.addMinute(\"1995-11-15\",10*60+10 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 15);
        c.add(12, 10080);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 9, 15);
        c.add(12, 30240);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15);
        c.add(12, 610);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testAddSecond() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.addSecond(new Date(2005, 10, 15),7*24*60*60 )", "BirtDateTime.addSecond(new Date(2006, 9, 15),21*24*60*60 )", "BirtDateTime.addSecond(\"1995-11-15\",(10*60+10)*60+9 )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 10, 15);
        c.add(13, 604800);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 9, 15);
        c.add(13, 1814400);
        Date d2 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(1995, 10, 15);
        c.add(13, 36609);
        Date d3 = new Date(c.getTimeInMillis());
        c.clear();
        Date[] values = new Date[]{d1, d2, d3};
        int i = 0;
        while (i < values.length) {
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfYear(new Date(2005, 10, 15) )", "BirtDateTime.firstDayOfYear(new Date(2006, 9, 15) )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 0, 1);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 0, 1);
        Date d2 = new Date(c.getTimeInMillis());
        Date[] values = new Date[]{d1, d2};
        int i = 0;
        while (i < values.length) {
            System.out.println(this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null));
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfQuarter(new Date(2005, 9, 15) )", "BirtDateTime.firstDayOfQuarter(new Date(2006, 8, 15) )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 9, 1);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 6, 1);
        Date d2 = new Date(c.getTimeInMillis());
        Date[] values = new Date[]{d1, d2};
        int i = 0;
        while (i < values.length) {
            System.out.println(this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null));
            System.out.println("result:" + String.valueOf(values[i]));
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfMonth(new Date(2005, 9, 15) )", "BirtDateTime.firstDayOfMonth(new Date(2006, 8, 15) )"};
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2005, 9, 1);
        Date d1 = new Date(c.getTimeInMillis());
        c.clear();
        c.set(2006, 8, 1);
        Date d2 = new Date(c.getTimeInMillis());
        Date[] values = new Date[]{d1, d2};
        int i = 0;
        while (i < values.length) {
            System.out.println(this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null));
            System.out.println("result:" + String.valueOf(values[i]));
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfWeek(new Date(2011, 7, 25) )", "BirtDateTime.firstDayOfWeek(new Date(2011, 7, 15) )"};
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getDefault());
        c.clear();
        c.setMinimalDaysInFirstWeek(1);
        c.set(2011, 7, 25);
        c.get(7);
        c.set(7, c.getFirstDayOfWeek());
        Date d1 = c.getTime();
        c.clear();
        c.setMinimalDaysInFirstWeek(1);
        c.set(2011, 7, 15);
        c.get(7);
        c.set(7, c.getFirstDayOfWeek());
        Date d2 = c.getTime();
        Date[] values = new Date[]{d1, d2};
        int i = 0;
        while (i < values.length) {
            System.out.println(this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null));
            System.out.println("result:" + String.valueOf(values[i]));
            BirtDateTimeTest.assertEquals((Object)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null), (Object)values[i]);
            ++i;
        }
    }

    @Test
    public void testDayOfWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.dayOfWeek(new Date(2015, 4, 1) )", "BirtDateTime.dayOfWeek(new Date(2015, 4, 2) )", "BirtDateTime.dayOfWeek(new Date(2015, 4, 3) )", "BirtDateTime.dayOfWeek(new Date(2015, 4, 4) )"};
        int[] values = new int[]{6, 7, 1, 2};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testDayOfYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.dayOfYear(new Date(2012, 0, 1) )", "BirtDateTime.dayOfYear(new Date(2012, 1, 29) )", "BirtDateTime.dayOfYear(new Date(2012, 11, 31) )", "BirtDateTime.dayOfYear(new Date(2015, 0, 1) )", "BirtDateTime.dayOfYear(new Date(2015, 1, 28) )", "BirtDateTime.dayOfYear(new Date(2015, 11, 31) )"};
        int[] values = new int[]{1, 60, 366, 1, 59, 365};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testWeekOfMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.weekOfMonth(new Date(2015, 4, 1) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 2) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 3) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 9) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 10) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 16) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 17) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 23) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 24) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 30) )", "BirtDateTime.weekOfMonth(new Date(2015, 4, 31) )"};
        int[] values = new int[]{this.weekOfMonth(2015, 4, 1), this.weekOfMonth(2015, 4, 2), this.weekOfMonth(2015, 4, 3), this.weekOfMonth(2015, 4, 9), this.weekOfMonth(2015, 4, 10), this.weekOfMonth(2015, 4, 16), this.weekOfMonth(2015, 4, 17), this.weekOfMonth(2015, 4, 23), this.weekOfMonth(2015, 4, 24), this.weekOfMonth(2015, 4, 30), this.weekOfMonth(2015, 4, 31)};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((Object)values[i], (Object)result);
            ++i;
        }
    }

    private int weekOfMonth(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.get(4);
    }

    @Test
    public void testFiscalYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.fiscalYear(new Date(2015, 6, 1), new Date(2012, 6, 1 ))", "BirtDateTime.fiscalYear(new Date(2015, 6, 1), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalYear(new Date(2015, 6, 12), new Date(2015, 9, 1 ))", "BirtDateTime.fiscalYear(new Date(2015, 7, 12), new Date(2015, 7, 1 ))", "BirtDateTime.fiscalYear(new Date(2015, 7, 12), new Date(2015, 0, 1 ))", "BirtDateTime.fiscalYear(new Date(2014, 5, 15))", "BirtDateTime.fiscalYear(new Date(2015, 6, 12))"};
        int[] values = new int[]{2016, 2016, 2015, 2016, 2015, 2014, 2016};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFiscalQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.fiscalQuarter(new Date(2015, 8, 15), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalQuarter(new Date(2015, 6, 12), new Date(2015, 7, 1 ))", "BirtDateTime.fiscalQuarter(new Date(2015, 0, 11), new Date(2015, 9, 1 ))", "BirtDateTime.fiscalQuarter(new Date(2015, 5, 15))", "BirtDateTime.fiscalQuarter(new Date(2015, 6, 12))", "BirtDateTime.fiscalQuarter(new Date(2015, 0, 11))"};
        int[] values = new int[]{1, 4, 2, 4, 1, 3};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFiscalMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.fiscalMonth(new Date(2015, 8, 15), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalMonth(new Date(2015, 6, 12), new Date(2015, 7, 1 ))", "BirtDateTime.fiscalMonth(new Date(2015, 0, 11), new Date(2015, 9, 1 ))", "BirtDateTime.fiscalMonth(new Date(2015, 5, 15))", "BirtDateTime.fiscalMonth(new Date(2015, 6, 12))", "BirtDateTime.fiscalMonth(new Date(2015, 0, 11))"};
        int[] values = new int[]{3, 12, 4, 12, 1, 7};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFiscalWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.fiscalWeek(new Date(2011, 6, 2), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalWeek(new Date(2011, 6, 3), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalWeek(new Date(2011, 5, 30), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalWeek(new Date(2011, 5, 25), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalWeek(new Date(2011, 11, 31), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalWeek(new Date(2012, 0, 1), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalWeek(new Date(2015, 0, 7))", "BirtDateTime.fiscalWeek(new Date(2015, 1, 1))", "BirtDateTime.fiscalWeek(new Date(2015, 6, 1))"};
        int[] values = new int[]{this.fiscalWeek(2011, 6, 2, 2015, 6, 1), this.fiscalWeek(2011, 6, 3, 2015, 6, 1), this.fiscalWeek(2011, 5, 30, 2015, 6, 1), this.fiscalWeek(2011, 5, 25, 2015, 6, 1), this.fiscalWeek(2011, 11, 31, 2015, 6, 1), this.fiscalWeek(2012, 0, 1, 2015, 6, 1), this.fiscalWeek(2015, 0, 7, 2015, 6, 1), this.fiscalWeek(2015, 1, 1, 2015, 6, 1), this.fiscalWeek(2015, 6, 1, 2015, 6, 1)};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
    }

    private int fiscalWeek(int year, int month, int day, int year2, int month2, int day2) {
        int fiscalYearStartWeek;
        int weekOfYear = this.weekOfYear(year, month, day);
        if (weekOfYear >= (fiscalYearStartWeek = this.weekOfYear(year, month2, day2))) {
            return weekOfYear - fiscalYearStartWeek + 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year - 1, 11, 31);
        while (calendar.get(3) == 1) {
            calendar.add(5, -1);
        }
        return calendar.get(3) - this.weekOfYear(year - 1, month2, day2) + weekOfYear + 1;
    }

    @Test
    public void testFiscalDay() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.fiscalDay(new Date(2015, 6, 15), new Date(2015, 6, 1 ))", "BirtDateTime.fiscalDay(new Date(2015, 6, 12), new Date(2015, 7, 1 ))", "BirtDateTime.fiscalDay(new Date(2015, 9, 11), new Date(2015, 9, 1 ))", "BirtDateTime.fiscalDay(new Date(2015, 0, 7))", "BirtDateTime.fiscalDay(new Date(2015, 1, 1))", "BirtDateTime.fiscalDay(new Date(2015, 6, 1))"};
        int[] values = new int[]{15, 346, 11, 191, 216, 1};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfFiscalYear() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfFiscalYear(2015)", "BirtDateTime.firstDayOfFiscalYear(new Date(2015, 5, 15))", "BirtDateTime.firstDayOfFiscalYear(2015, new Date(2014, 6, 1))", "BirtDateTime.firstDayOfFiscalYear(new Date(2015, 6, 15), new Date(2015, 6, 1 ))", "BirtDateTime.firstDayOfFiscalYear(new Date(2015, 5, 15), new Date(2014, 6, 1 ))", "BirtDateTime.firstDayOfFiscalYear(new Date(2015, 5, 15), new Date(2015, 6, 1 ))"};
        Calendar c = Calendar.getInstance();
        c.clear();
        Date[] values = new Date[]{this.date(c, 2014, 6, 1), this.date(c, 2014, 6, 1), this.date(c, 2014, 6, 1), this.date(c, 2015, 6, 1), this.date(c, 2014, 6, 1), this.date(c, 2014, 6, 1)};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfFiscalMonth() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfFiscalMonth(new Date(2015, 5, 15))", "BirtDateTime.firstDayOfFiscalMonth(4.0)", "BirtDateTime.firstDayOfFiscalMonth(new Date(2015, 5, 15), new Date(2015, 0, 1))", "BirtDateTime.firstDayOfFiscalMonth(2, new Date(2014, 6, 15))", "BirtDateTime.firstDayOfFiscalMonth(new Date(2015, 6, 15), new Date(2015, 6, 10 ))", "BirtDateTime.firstDayOfFiscalMonth(new Date(2015, 6, 9), new Date(2014, 6, 10 ))", "BirtDateTime.firstDayOfFiscalMonth(new Date(2014, 0, 1), new Date(2015, 0, 10 ))", "BirtDateTime.firstDayOfFiscalMonth(new Date(2014, 1, 1), new Date(2015, 0, 31 ))", "BirtDateTime.firstDayOfFiscalMonth(new Date(2014, 9, 10), new Date(2015, 6, 31 ))"};
        Calendar c = Calendar.getInstance();
        c.clear();
        Date[] values = new Date[]{this.date(c, 2015, 5, 1), this.date(c, CURRENT_YEAR, 9, 1), this.date(c, 2015, 5, 1), this.date(c, 2014, 7, 15), this.date(c, 2015, 6, 10), this.date(c, 2015, 5, 10), this.date(c, 2013, 11, 10), this.date(c, 2014, 0, 31), this.date(c, 2014, 8, 30)};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfFiscalQuarter() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfFiscalQuarter(new Date(2015, 5, 15))", "BirtDateTime.firstDayOfFiscalQuarter(2)", "BirtDateTime.firstDayOfFiscalQuarter(new Date(2015, 5, 15), new Date(2015, 0, 1))", "BirtDateTime.firstDayOfFiscalQuarter(3, new Date(2014, 6, 15))", "BirtDateTime.firstDayOfFiscalQuarter(new Date(2015, 6, 15), new Date(2015, 6, 10 ))", "BirtDateTime.firstDayOfFiscalQuarter(new Date(2015, 6, 9), new Date(2014, 6, 10 ))", "BirtDateTime.firstDayOfFiscalQuarter(new Date(2014, 0, 1), new Date(2015, 1, 10 ))", "BirtDateTime.firstDayOfFiscalMonth(new Date(2014, 9, 10), new Date(2015, 6, 31 ))"};
        Calendar c = Calendar.getInstance();
        c.clear();
        Date[] values = new Date[]{this.date(c, 2015, 3, 1), this.date(c, CURRENT_YEAR, 9, 1), this.date(c, 2015, 3, 1), this.date(c, 2015, 0, 15), this.date(c, 2015, 6, 10), this.date(c, 2015, 3, 10), this.date(c, 2013, 10, 10), this.date(c, 2014, 8, 30)};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
    }

    @Test
    public void testFirstDayOfFiscalWeek() throws BirtException {
        String[] scripts = new String[]{"BirtDateTime.firstDayOfFiscalWeek(new Date(2015, 5, 15))", "BirtDateTime.firstDayOfFiscalWeek(new Date(2015, 5, 15), new Date(2015, 0, 1))", "BirtDateTime.firstDayOfFiscalWeek(6, new Date(2015, 6, 15))", "BirtDateTime.firstDayOfFiscalWeek(new Date(2015, 5, 15), new Date(2015, 6, 10 ))"};
        Calendar c = Calendar.getInstance();
        c.clear();
        Date[] values = new Date[]{this.firstDayOfWeek(c, 2015, 5, 15), this.firstDayOfWeek(c, 2015, 5, 15), this.firstDayOfWeek(c, 2015, 7, 17), this.firstDayOfWeek(c, 2015, 5, 15)};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
    }

    private Date date(Calendar c, int year, int month, int day) {
        c.set(year, month, day);
        return c.getTime();
    }

    private Date firstDayOfWeek(Calendar c, int year, int month, int day) {
        Date date = new Date(year - 1900, month, day);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    @Test
    public void testFiscalYearStartDate() {
        String PROPERTY_FISCAL_YEAR_START_DATE = "FISCAL_YEAR_START_DATE";
        System.setProperty(PROPERTY_FISCAL_YEAR_START_DATE, "2000-10-01");
        String[] scripts = new String[]{"BirtDateTime.fiscalYear(new Date(2015, 6, 15))", "BirtDateTime.fiscalYear(new Date(2015, 8, 12))", "BirtDateTime.fiscalYear(new Date(2015, 9, 1))", "BirtDateTime.fiscalYear(new Date(2015, 10, 12))"};
        int[] values = new int[]{2015, 2015, 2016, 2016};
        int i = 0;
        while (i < values.length) {
            Object result = this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null);
            BirtDateTimeTest.assertEquals((String)String.valueOf(i), (Object)values[i], (Object)result);
            ++i;
        }
        System.clearProperty(PROPERTY_FISCAL_YEAR_START_DATE);
    }
}

