/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.btree.NodeFile;
import org.eclipse.birt.core.btree.NodeInputStream;
import org.eclipse.birt.core.btree.RAMBTreeFile;
import org.junit.Test;

public class NodeInputStreamTest
extends TestCase {
    @Test
    public void testInputStream() throws IOException {
        NodeFile file = this.createNodeFile();
        NodeInputStream in = new NodeInputStream(file, 0);
        DataInputStream input = new DataInputStream((InputStream)in);
        int i = 0;
        while (i < 1022) {
            int v = input.readInt();
            NodeInputStreamTest.assertEquals((int)i, (int)v);
            ++i;
        }
        long v = input.readLong();
        NodeInputStreamTest.assertEquals((String)Long.toHexString(1311768467139281697L), (String)Long.toHexString(v));
        int i2 = 0;
        while (i2 < 10) {
            String s = input.readUTF();
            NodeInputStreamTest.assertEquals((String)String.valueOf(i2), (String)s);
            ++i2;
        }
        int[] blocks = in.getUsedBlocks();
        NodeInputStreamTest.assertEquals((int)2, (int)blocks.length);
        NodeInputStreamTest.assertEquals((int)0, (int)blocks[0]);
        NodeInputStreamTest.assertEquals((int)1, (int)blocks[1]);
        in.close();
    }

    protected NodeFile createNodeFile() throws IOException {
        RAMBTreeFile file = new RAMBTreeFile();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        DataOutputStream out = new DataOutputStream(buffer);
        out.writeInt(1);
        int i = 0;
        while (i < 1022) {
            out.writeInt(i);
            ++i;
        }
        out.writeInt(305419896);
        file.writeBlock(0, buffer.toByteArray());
        buffer.reset();
        out = new DataOutputStream(buffer);
        out.writeInt(-1);
        out.writeInt(-2023406815);
        i = 0;
        while (i < 10) {
            out.writeUTF(String.valueOf(i));
            ++i;
        }
        file.writeBlock(1, buffer.toByteArray());
        return file;
    }
}

