/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.junit.Test;

public class ArchiveEntryInputStreamTest
extends TestCase {
    long STREAM_SIZE = 40960L;
    int TEST_COUNT = 1000;

    @Test
    public void testInputStream() throws IOException {
        long pos;
        int v;
        long pos2;
        ArchiveFile af = new ArchiveFile("temp", "rwt");
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
        writer.initialize();
        RAOutputStream out = writer.createRandomAccessStream("/test");
        int i = 0;
        while ((long)i < this.STREAM_SIZE) {
            out.write(i % 256);
            ++i;
        }
        out.close();
        writer.finish();
        ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
        reader.open();
        RAInputStream in = reader.getStream("/test");
        int i2 = 0;
        while (i2 < this.TEST_COUNT) {
            pos2 = (long)(Math.random() * (double)this.STREAM_SIZE);
            in.seek(pos2);
            ArchiveEntryInputStreamTest.assertEquals((long)(this.STREAM_SIZE - pos2), (long)in.available());
            v = in.read();
            ArchiveEntryInputStreamTest.assertEquals((int)this.goldenByte(pos2), (int)v);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.TEST_COUNT) {
            pos2 = (long)(Math.random() * (double)(this.STREAM_SIZE - 4L));
            in.seek(pos2);
            v = in.readInt();
            ArchiveEntryInputStreamTest.assertEquals((int)this.goldenInt(pos2), (int)v);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.TEST_COUNT) {
            pos2 = (long)(Math.random() * (double)(this.STREAM_SIZE - 8L));
            in.seek(pos2);
            long v2 = in.readLong();
            ArchiveEntryInputStreamTest.assertEquals((long)this.goldenLong(pos2), (long)v2);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.TEST_COUNT) {
            byte[] buffer = new byte[1023];
            pos = (long)(Math.random() * (double)(this.STREAM_SIZE - 1L));
            in.seek(pos);
            int readSize = in.read(buffer);
            this.checkBytes(buffer, readSize, pos);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.TEST_COUNT) {
            byte[] buffer = new byte[1023];
            pos = (long)(Math.random() * (double)(this.STREAM_SIZE - 1023L));
            in.seek(pos);
            in.readFully(buffer, 0, 1023);
            this.checkBytes(buffer, 1023, pos);
            ++i2;
        }
        reader.close();
        af.close();
    }

    private int goldenByte(long pos) {
        return (int)(pos % 256L);
    }

    private int goldenInt(long pos) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)((pos + (long)i) % 256L);
            ++i;
        }
        return ArchiveUtil.bytesToInteger((byte[])b);
    }

    private long goldenLong(long pos) {
        byte[] b = new byte[8];
        int i = 0;
        while (i < 8) {
            b[i] = (byte)((pos + (long)i) % 256L);
            ++i;
        }
        return ArchiveUtil.bytesToLong((byte[])b);
    }

    private void checkBytes(byte[] bytes, int size, long pos) {
        int i = 0;
        while (i < size) {
            if ((byte)((pos + (long)i) % 256L) != bytes[i]) {
                System.out.println(i);
            }
            ArchiveEntryInputStreamTest.assertEquals((byte)((byte)((pos + (long)i) % 256L)), (byte)bytes[i]);
            ++i;
        }
    }
}

