/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class XPathUtilTest
extends BaseTestCase {
    private static final String INPUT_FILE = "XPathUtilTest.xml";

    public void testGetXPath() throws Exception {
        this.openDesign(INPUT_FILE);
        SlotHandle tmpSlot = this.designHandle.getBody();
        XPathUtilTest.assertEquals((String)"/report/body", (String)XPathUtil.getXPath((Object)tmpSlot));
        tmpSlot = this.designHandle.findElement("My table1 nested label1").getContainerSlotHandle();
        XPathUtilTest.assertEquals((String)"/report/body/table[@id=\"10\"]/detail/row[@id=\"15\"]/cell[@id=\"17\"][@slotName=\"content\"]", (String)XPathUtil.getXPath((Object)tmpSlot));
        ListHandle list = (ListHandle)this.designHandle.findElement("My list1");
        XPathUtilTest.assertEquals((String)"/report/body/list[@id=\"21\"]/header", (String)XPathUtil.getXPath((Object)list.getHeader()));
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("images");
        XPathUtilTest.assertEquals((String)"/report/list-property[@name=\"images\"]", (String)XPathUtil.getXPath((Object)propHandle));
        propHandle = this.designHandle.findParameter("Param 1").getPropertyHandle("name");
        XPathUtilTest.assertEquals((String)"/report/parameters/scalar-parameter[@id=\"2\"]/@name", (String)XPathUtil.getXPath((Object)propHandle));
        propHandle = this.designHandle.findElement("My text1").getPropertyHandle("content");
        XPathUtilTest.assertEquals((String)"/report/body/text[@id=\"19\"]/text-property[@name=\"content\"]", (String)XPathUtil.getXPath((Object)propHandle));
        propHandle = this.designHandle.findElement("My text1").getPropertyHandle("contentID");
        XPathUtilTest.assertEquals((String)"/report/body/text[@id=\"19\"]/text-property[@name=\"content\"]/@key", (String)XPathUtil.getXPath((Object)propHandle));
        EmbeddedImageHandle image = (EmbeddedImageHandle)this.designHandle.imagesIterator().next();
        XPathUtilTest.assertEquals((String)"/report/list-property[@name=\"images\"]/structure[1]", (String)XPathUtil.getXPath((Object)image));
        OdaDataSetHandle tmpDataSet = (OdaDataSetHandle)this.designHandle.findDataSet("firstDataSet");
        XPathUtilTest.assertEquals((String)"/report/data-sets/oda-data-set[@id=\"7\"]", (String)XPathUtil.getXPath((Object)tmpDataSet));
        ExtendedItemHandle tmpMatrix = (ExtendedItemHandle)this.designHandle.findElement("matrix1");
        XPathUtilTest.assertEquals((String)"/report/body/extended-item[@id=\"20\"]", (String)XPathUtil.getXPath((Object)tmpMatrix));
        propHandle = tmpMatrix.getPropertyHandle("type");
        XPathUtilTest.assertNotNull((Object)propHandle);
        XPathUtilTest.assertEquals((String)"/report/body/extended-item[@id=\"20\"]/property[@name=\"type\"]", (String)XPathUtil.getXPath((Object)propHandle));
        XPathUtilTest.assertTrue((boolean)propHandle.equals(XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)XPathUtil.getXPath((Object)propHandle))));
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("firstDataSet");
        Iterator iter1 = dataSet.getCachedMetaDataHandle().getResultSet().iterator();
        ResultSetColumnHandle setColumn = (ResultSetColumnHandle)iter1.next();
        XPathUtilTest.assertEquals((String)"/report/data-sets/oda-data-set[@id=\"7\"]/structure[@name=\"cachedMetaData\"]/list-property[@name=\"resultSet\"]/structure[1]", (String)XPathUtil.getXPath((Object)setColumn));
        setColumn = (ResultSetColumnHandle)iter1.next();
        XPathUtilTest.assertEquals((String)"/report/data-sets/oda-data-set[@id=\"7\"]/structure[@name=\"cachedMetaData\"]/list-property[@name=\"resultSet\"]/structure[2]", (String)XPathUtil.getXPath((Object)setColumn));
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        propHandle = label1.getPropertyHandle("onPrepare");
        String path = XPathUtil.getXPath((Object)propHandle);
        XPathUtilTest.assertEquals((String)"/report/body/label[@id=\"24\"]/method[@name=\"onPrepare\"]", (String)path);
        ExtendedItemHandle tmpTable = (ExtendedItemHandle)this.designHandle.findElement("extensionTable");
        propHandle = tmpTable.getPropertyHandle("filter");
        FilterConditionElementHandle tmpFilter = (FilterConditionElementHandle)propHandle.get(0);
        XPathUtilTest.assertEquals((String)"/report/body/extended-item[@id=\"26\"]/property[@name=\"filter\"]/filter-condition-element", (String)XPathUtil.getXPath((Object)tmpFilter));
        propHandle = tmpFilter.getPropertyHandle("value1");
        path = XPathUtil.getXPath((Object)propHandle);
        XPathUtilTest.assertEquals((String)"/report/body/extended-item[@id=\"26\"]/property[@name=\"filter\"]/filter-condition-element/simple-property-list[@name=\"value1\"]", (String)path);
        path = XPathUtil.getXPath((Object)propHandle, (int)0);
        XPathUtilTest.assertEquals((String)"/report/body/extended-item[@id=\"26\"]/property[@name=\"filter\"]/filter-condition-element/simple-property-list[@name=\"value1\"]/value[1]", (String)path);
    }

    public void testGetInstance() throws Exception {
        this.openDesign(INPUT_FILE);
        Object retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof ReportDesignHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/parameters/scalar-parameter");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof ScalarParameterHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/image[@id=\"9\"]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof ImageHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/table/group/header/row");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof RowHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/table/group/header/row/");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof RowHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/table/group/header/row/*");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof RowHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/table/group/header/row[@slotName=\"cells\"]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof SlotHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/list[@id=\"21\"]/header]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof SlotHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/list-property[@name=\"images\"]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof PropertyHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/parameters/scalar-parameter[@id=\"2\"]/@name");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof PropertyHandle));
        XPathUtilTest.assertEquals((String)"name", (String)((PropertyHandle)retValue).getDefn().getName());
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/text[@id=\"19\"]/text-property[@name=\"content\"]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof PropertyHandle));
        XPathUtilTest.assertEquals((String)"content", (String)((PropertyHandle)retValue).getDefn().getName());
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/text[@id=\"19\"]/text-property[@name=\"content\"]/@key");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof PropertyHandle));
        XPathUtilTest.assertEquals((String)"contentID", (String)((PropertyHandle)retValue).getDefn().getName());
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/list-property[@name=\"images\"]/structure");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof EmbeddedImageHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/list-property[@name=\"images\"]/structure[1]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof EmbeddedImageHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/data-sets/oda-data-set/structure[@name=\"cachedMetaData\"]/list-property[@name=\"resultSet\"]/structure[1]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof ResultSetColumnHandle));
        ResultSetColumnHandle column = (ResultSetColumnHandle)retValue;
        XPathUtilTest.assertEquals((String)"name1", (String)column.getColumnName());
        XPathUtilTest.assertTrue((1 == column.getPosition() ? 1 : 0) != 0);
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/data-sets/oda-data-set/structure[@name=\"cachedMetaData\"]/list-property[@name=\"resultSet\"]/structure[2]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof ResultSetColumnHandle));
        column = (ResultSetColumnHandle)retValue;
        XPathUtilTest.assertEquals((String)"date1", (String)column.getColumnName());
        XPathUtilTest.assertTrue((2 == column.getPosition() ? 1 : 0) != 0);
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/data-sets/oda-data-set/structure[@name=\"cachedMetaData\"]/list-property[@name=\"resultSet\"]");
        XPathUtilTest.assertNull((Object)retValue);
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/data-sets/oda-data-set");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof OdaDataSetHandle));
        XPathUtilTest.assertNull((Object)XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"*/"));
        XPathUtilTest.assertNull((Object)XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/library"));
        XPathUtilTest.assertNull((Object)XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/*/body"));
        XPathUtilTest.assertNull((Object)XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/list-property[@name=\"images\"]/structure[3]"));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/label[@id=\"24\"]/method[@name=\"onPrepare\"]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof PropertyHandle));
        XPathUtilTest.assertEquals((Object)"\"prepare\"", (Object)((PropertyHandle)retValue).getValue());
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"<");
        XPathUtilTest.assertNull((Object)retValue);
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/extended-item[@id=\"26\"]/property[@name=\"filter\"]/filter-condition-element");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof FilterConditionElementHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/extended-item[@id=\"26\"]/property[@name=\"filter\"]/filter-condition-element/simple-property-list[@name=\"value1\"]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof PropertyHandle));
        retValue = XPathUtil.getInstance((ModuleHandle)this.designHandle, (String)"/report/body/extended-item[@id=\"26\"]/property[@name=\"filter\"]/filter-condition-element/simple-property-list[@name=\"value1\"]/value[1]");
        XPathUtilTest.assertTrue((boolean)(retValue instanceof Expression));
        XPathUtilTest.assertEquals((String)"value1 expression", (String)retValue.toString());
    }
}

