/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsEvent;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignElementTest
extends BaseTestCase {
    private final String DISPLAY_LABEL_FILE_NAME = "DesignElementTest_1.xml";
    private final String DISPLAY_TEXT_FILE_NAME = "DesignElementTest_2.xml";
    private final String DISPLAY_GRID_FILE_NAME = "DesignElementTest_3.xml";
    private final String DISPLAY_List_FILE_NAME = "DesignElementTest_4.xml";
    private final String DISPLAY_DATA_FILE_NAME = "DesignElementTest_5.xml";
    private final String DISPLAY_IMAGE_FILE_NAME = "DesignElementTest_6.xml";
    private final String DISPLAY_TABLE_FILE_NAME = "DesignElementTest_7.xml";
    private static final int LABEL = 0;
    private static final int TEXT = 1;
    private static final int GRID = 2;
    private static final int LIST = 3;
    private static final int DATA = 4;
    private static final int IMAGE = 5;
    private static final int TABLE = 6;
    private TextItem designElement = null;
    private MetaDataDictionary dd = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sessionHandle = engine.newSessionHandle(ULocale.ENGLISH);
        this.designElement = new TextItem();
        this.designElement.setName("element");
        this.designHandle = this.sessionHandle.createDesign("myDesign");
        this.design = (ReportDesign)this.designHandle.getModule();
        DesignElementTest.assertEquals((int)0, (int)this.design.getAllErrors().size());
        this.dd = MetaDataDictionary.getInstance();
    }

    public void testAddRemoveListener() throws Exception {
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
        MyActionListener listener = new MyActionListener();
        this.designElement.addListener((Listener)listener);
        DesignElementTest.assertTrue((boolean)CoreTestUtil.getListeners((DesignElement)this.designElement).contains(listener));
        this.designElement.removeListener((Listener)listener);
        DesignElementTest.assertFalse((boolean)CoreTestUtil.getListeners((DesignElement)this.designElement).contains(listener));
        this.designElement.removeListener((Listener)listener);
        DesignElementTest.assertFalse((boolean)CoreTestUtil.getListeners((DesignElement)this.designElement).contains(listener));
        this.designElement.clearListeners();
        listener = new MyActionListener();
        DesignElementHandle handle = this.designElement.getHandle((Module)this.design);
        handle.addListener((Listener)listener);
        this.designHandle.getBody().add(handle);
        DesignElementTest.assertEquals((int)1, (int)CoreTestUtil.getListeners((DesignElement)this.designElement).size());
        this.designHandle.getCommandStack().undo();
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
        this.designHandle.getCommandStack().redo();
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
        this.designHandle.getCommandStack().undo();
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
        handle.addListener((Listener)listener);
        this.designHandle.getBody().add(handle);
        handle.dropAndClear();
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
        this.designHandle.getCommandStack().undo();
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
        this.designHandle.getCommandStack().redo();
        DesignElementTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)this.designElement));
    }

    public void testBroadcast() throws ContentException, NameException, ExtendsException {
        TextItemHandle parent = this.designHandle.getElementFactory().newTextItem("parent");
        TextItemHandle grand = this.designHandle.getElementFactory().newTextItem("grand");
        this.designHandle.getComponents().add((DesignElementHandle)parent);
        this.designHandle.getComponents().add((DesignElementHandle)grand);
        this.designElement.setExtendsElement(parent.getElement());
        parent.setExtends((DesignElementHandle)grand);
        MyActionListener listener = new MyActionListener();
        MyActionListener parentListener = new MyActionListener();
        MyActionListener grandListener = new MyActionListener();
        this.designElement.addListener((Listener)listener);
        parent.addListener((Listener)parentListener);
        grand.addListener((Listener)grandListener);
        DesignElementTest.assertTrue((boolean)CoreTestUtil.getListeners((DesignElement)this.designElement).contains(listener));
        DesignElementTest.assertTrue((boolean)CoreTestUtil.getListeners((DesignElement)parent.getElement()).contains(parentListener));
        DesignElementTest.assertTrue((boolean)CoreTestUtil.getListeners((DesignElement)grand.getElement()).contains(grandListener));
        DesignElementTest.assertNull((Object)this.designElement.getProperty((Module)this.design, "displayName"));
        DesignElementTest.assertNull((Object)parent.getProperty("displayName"));
        DesignElementTest.assertNull((Object)grand.getProperty("displayName"));
        ExtendsEvent ev = new ExtendsEvent(grand.getElement());
        grand.getElement().broadcast((NotificationEvent)ev);
        DesignElementTest.assertTrue((boolean)listener.done);
        DesignElementTest.assertEquals((int)1, (int)listener.path);
        DesignElementTest.assertTrue((boolean)parentListener.done);
        DesignElementTest.assertEquals((int)1, (int)parentListener.path);
        DesignElementTest.assertTrue((boolean)grandListener.done);
        DesignElementTest.assertEquals((int)0, (int)grandListener.path);
    }

    public void testGetPropertyDefn() {
        UserPropertyDefn uDefn = new UserPropertyDefn();
        ElementPropertyDefn o = this.designElement.getPropertyDefn("displayName");
        DesignElementTest.assertTrue((o != null ? 1 : 0) != 0);
        o = this.designElement.getPropertyDefn("style");
        DesignElementTest.assertTrue((o != null ? 1 : 0) != 0);
        uDefn.setName("MyProperty");
        this.designElement.addUserPropertyDefn(uDefn);
        o = this.designElement.getPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
    }

    public void testGetProperty() throws SemanticException {
        DesignElementTest.assertNull((Object)this.designElement.getProperty((Module)this.design, "123"));
        this.designElement.setProperty("displayName", (Object)"Hello");
        Object o = this.designElement.getProperty((Module)this.design, "displayName");
        DesignElementTest.assertEquals((Object)"Hello", (Object)o);
        UserPropertyDefn uDefn = new UserPropertyDefn();
        uDefn.setName("MyProperty");
        uDefn.setType(this.dd.getPropertyType(0));
        this.designElement.addUserPropertyDefn(uDefn);
        this.designElement.setProperty((ElementPropertyDefn)uDefn, (Object)"user");
        o = this.designElement.getProperty((Module)this.design, "MyProperty");
        DesignElementTest.assertEquals((Object)"user", (Object)o);
        this.designElement.clearProperty("MyProperty");
        this.designElement.dropUserPropertyDefn(uDefn);
        TextItem parent = new TextItem();
        parent.setName("parent");
        parent.addUserPropertyDefn(uDefn);
        parent.setProperty((ElementPropertyDefn)uDefn, (Object)"userParent");
        o = parent.getProperty((Module)this.design, "MyProperty");
        DesignElementTest.assertEquals((Object)"userParent", (Object)o);
        o = this.designElement.getProperty((Module)this.design, "MyProperty");
        DesignElementTest.assertNull((Object)o);
        this.design.add((DesignElement)parent, 6);
        this.designElement.setExtendsElement((DesignElement)parent);
        o = this.designElement.getProperty((Module)this.design, "MyProperty");
        DesignElementTest.assertEquals((Object)"userParent", (Object)o);
        TextItem grand = new TextItem();
        grand.setName("grand");
        grand.setProperty("displayNameID", (Object)"English");
        o = parent.getProperty((Module)this.design, "displayNameID");
        DesignElementTest.assertNull((Object)o);
        o = this.designElement.getProperty((Module)this.design, "displayNameID");
        DesignElementTest.assertNull((Object)o);
        this.design.add((DesignElement)grand, 6);
        parent.setExtendsElement((DesignElement)grand);
        o = this.designElement.getProperty((Module)this.design, "displayNameID");
        DesignElementTest.assertEquals((Object)"English", (Object)o);
        o = parent.getProperty((Module)this.design, "displayNameID");
        DesignElementTest.assertEquals((Object)"English", (Object)o);
        Label label = new Label();
        Style style = new Style("My-Style");
        this.design.getSlot(0).add((DesignElement)style);
        style.setProperty("color", (Object)"red");
        o = style.getProperty((Module)this.design, "color");
        DesignElementTest.assertEquals((Object)"red", (Object)o);
        label.setStyle((StyleElement)style);
        o = label.getProperty((Module)this.design, "color");
        DesignElementTest.assertEquals((Object)"red", (Object)o);
        ElementFactory elemFactory = new ElementFactory((Module)this.design);
        SharedStyleHandle labelSelector = elemFactory.newStyle("label");
        labelSelector.setProperty("backgroundColor", (Object)"blue");
        this.designHandle.getStyles().add((DesignElementHandle)labelSelector);
        LabelHandle label1 = elemFactory.newLabel(null);
        DesignElementTest.assertEquals((String)"blue", (String)label1.getStringProperty("backgroundColor"));
        SharedStyleHandle tableDetailSelector = elemFactory.newStyle("table-detail");
        tableDetailSelector.setProperty("backgroundColor", (Object)"aqua");
        this.designHandle.getStyles().add((DesignElementHandle)tableDetailSelector);
        TableHandle table = elemFactory.newTableItem(null, 2, 1, 2, 1);
        RowHandle row = (RowHandle)table.getDetail().get(0);
        this.designHandle.getBody().add((DesignElementHandle)table);
        DesignElementTest.assertEquals((Object)"aqua", (Object)row.getProperty("backgroundColor"));
        DesignElementTest.assertNull((Object)table.getProperty("backgroundColor"));
        row = (RowHandle)table.getFooter().get(0);
        DesignElementTest.assertNull((Object)row.getProperty("backgroundColor"));
        SharedStyleHandle listDetailSelector = elemFactory.newStyle("list-detail");
        listDetailSelector.setProperty("backgroundColor", (Object)"yellow");
        this.designHandle.getStyles().add((DesignElementHandle)listDetailSelector);
        this.designHandle.getStyles().drop((DesignElementHandle)labelSelector);
        ListHandle list = elemFactory.newList(null);
        LabelHandle listLabel = elemFactory.newLabel(null);
        list.getDetail().add((DesignElementHandle)listLabel);
        this.designHandle.getBody().add((DesignElementHandle)list);
        DesignElementTest.assertEquals((Object)"yellow", (Object)listLabel.getProperty("backgroundColor"));
        DesignElementTest.assertNull((Object)list.getProperty("backgroundColor"));
        TableHandle parentTable = this.designHandle.getElementFactory().newTableItem("parent");
        this.designHandle.getComponents().add((DesignElementHandle)parentTable);
        parentTable.setProperty("backgroundColor", (Object)"red");
        TableHandle childTable = this.designHandle.getElementFactory().newTableItem("child");
        this.designHandle.getBody().add((DesignElementHandle)childTable);
        DesignElementTest.assertNull((Object)childTable.getProperty("backgroundColor"));
        childTable.setExtends((DesignElementHandle)parentTable);
        DesignElementTest.assertEquals((Object)"red", (Object)childTable.getProperty("backgroundColor"));
    }

    public void testGetLocalProperty() {
        ElementPropertyDefn prop = this.designElement.getPropertyDefn("displayName");
        this.designElement.setProperty("displayName", (Object)"Hello");
        Object o = this.designElement.getLocalProperty((Module)this.design, prop.getName());
        DesignElementTest.assertEquals((Object)"Hello", (Object)o);
    }

    public void testSetPropertyValue() {
        this.designElement.setProperty("displayName", (Object)"Hello");
        Object o = this.designElement.getLocalProperty((Module)this.design, "displayName");
        DesignElementTest.assertEquals((Object)"Hello", (Object)o);
        this.designElement.setProperty("displayName", (Object)"element");
        o = this.designElement.getLocalProperty((Module)this.design, "displayName");
        DesignElementTest.assertEquals((Object)"element", (Object)o);
    }

    public void testClearPropertyValue() {
        this.designElement.setProperty("displayName", (Object)"Hello");
        Object o = this.designElement.getLocalProperty((Module)this.design, "displayName");
        DesignElementTest.assertEquals((Object)"Hello", (Object)o);
        this.designElement.clearProperty("displayName");
        o = this.designElement.getLocalProperty((Module)this.design, "displayName");
        DesignElementTest.assertNull((Object)o);
    }

    public void testGetDefn() {
        this.dd = MetaDataDictionary.getInstance();
        IElementDefn o = this.designElement.getDefn();
        DesignElementTest.assertEquals((Object)this.dd.getElement(this.designElement.getElementName()), (Object)o);
    }

    public void testAddUserProperty() {
        UserPropertyDefn uDefn = new UserPropertyDefn();
        uDefn.setName("MyProperty");
        this.designElement.addUserPropertyDefn(uDefn);
        UserPropertyDefn o = this.designElement.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.dropUserPropertyDefn(uDefn);
        parent.addUserPropertyDefn(uDefn);
        this.designElement.setExtendsElement((DesignElement)parent);
        o = this.designElement.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
    }

    public void testDropUserProperty() {
        UserPropertyDefn uDefn = new UserPropertyDefn();
        uDefn.setName("MyProperty");
        this.designElement.addUserPropertyDefn(uDefn);
        UserPropertyDefn o = this.designElement.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
        this.designElement.dropUserPropertyDefn(uDefn);
        o = this.designElement.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertNull((Object)o);
    }

    public void testGetUserProperty() {
        UserPropertyDefn uDefn = new UserPropertyDefn();
        uDefn.setName("MyProperty");
        this.designElement.addUserPropertyDefn(uDefn);
        UserPropertyDefn o = this.designElement.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
        o = this.designElement.getLocalUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.dropUserPropertyDefn(uDefn);
        parent.addUserPropertyDefn(uDefn);
        this.designElement.setExtendsElement((DesignElement)parent);
        o = parent.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
        o = this.designElement.getUserPropertyDefn("MyProperty");
        DesignElementTest.assertEquals((Object)uDefn, (Object)o);
        o = this.designElement.getLocalUserPropertyDefn("MyProperty");
        DesignElementTest.assertNull((Object)o);
    }

    public void testGetDisplayName() {
        this.designElement.setProperty("displayName", (Object)"Hello");
        String o = this.designElement.getDisplayName();
        DesignElementTest.assertEquals((Object)"Hello", (Object)o);
    }

    public void testGetDisplayNameID() {
        this.designElement.setProperty("displayNameID", (Object)"111");
        String o = this.designElement.getDisplayNameID();
        DesignElementTest.assertEquals((Object)"111", (Object)o);
    }

    public void testAddDerived() {
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.setExtendsElement((DesignElement)parent);
        Object o = parent.getDescendents().get(0);
        DesignElementTest.assertEquals((Object)this.designElement, o);
        parent.dropDerived((DesignElement)this.designElement);
        DesignElementTest.assertFalse((boolean)parent.getDescendents().contains(this.designElement));
        CoreTestUtil.addDerived((DesignElement)parent, (DesignElement)this.designElement);
        DesignElementTest.assertTrue((boolean)parent.getDescendents().contains(this.designElement));
    }

    public void testDropDerived() {
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.setExtendsElement((DesignElement)parent);
        Object o = parent.getDescendents().get(0);
        DesignElementTest.assertEquals((Object)this.designElement, o);
        parent.dropDerived((DesignElement)this.designElement);
        DesignElementTest.assertFalse((boolean)parent.getDescendents().contains(this.designElement));
    }

    public void testSetExtends() {
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.setExtendsElement((DesignElement)parent);
        DesignElementTest.assertTrue((boolean)parent.getDescendents().contains(this.designElement));
    }

    public void testGetDescendents() {
        DesignElementTest.assertEquals((int)0, (int)this.designElement.getDescendents().size());
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.setExtendsElement((DesignElement)parent);
        DesignElementTest.assertTrue((boolean)parent.getDescendents().contains(this.designElement));
        TextItem grand = new TextItem();
        grand.setName("grand");
        parent.setExtendsElement((DesignElement)grand);
        DesignElementTest.assertTrue((boolean)grand.getDescendents().contains(parent));
        DesignElementTest.assertTrue((boolean)grand.getDescendents().contains(this.designElement));
        DesignElementTest.assertTrue((boolean)parent.getDescendents().contains(this.designElement));
        DesignElementTest.assertEquals((int)1, (int)parent.getDescendents().size());
        DesignElementTest.assertEquals((int)2, (int)grand.getDescendents().size());
        grand.dropDerived((DesignElement)parent);
        this.designElement.setExtendsElement((DesignElement)grand);
        DesignElementTest.assertTrue((boolean)grand.getDescendents().contains(this.designElement));
        DesignElementTest.assertFalse((boolean)parent.getDescendents().contains(this.designElement));
        DesignElementTest.assertEquals((int)0, (int)parent.getDescendents().size());
        DesignElementTest.assertEquals((int)1, (int)grand.getDescendents().size());
    }

    public void testGatherDescendents() {
        TextItem parent = new TextItem();
        parent.setName("parent");
        ArrayList list = new ArrayList();
        parent.gatherDescendents(list);
        DesignElementTest.assertFalse((boolean)list.contains(this.designElement));
        this.designElement.setExtendsElement((DesignElement)parent);
        parent.gatherDescendents(list);
        DesignElementTest.assertTrue((boolean)list.contains(this.designElement));
        TextItem grand = new TextItem();
        grand.setName("grand");
        parent.setExtendsElement((DesignElement)grand);
        list.clear();
        grand.gatherDescendents(list);
        DesignElementTest.assertTrue((boolean)list.contains(parent));
        DesignElementTest.assertTrue((boolean)list.contains(this.designElement));
        list.clear();
        parent.gatherDescendents(list);
        DesignElementTest.assertTrue((boolean)list.contains(this.designElement));
        this.designElement.setExtendsElement((DesignElement)grand);
        list.clear();
        grand.gatherDescendents(list);
        DesignElementTest.assertTrue((boolean)list.contains(this.designElement));
        list.clear();
        parent.gatherDescendents(list);
        DesignElementTest.assertFalse((boolean)list.contains(this.designElement));
    }

    public void testHasUserProperties() {
        DesignElementTest.assertFalse((boolean)this.designElement.hasUserProperties());
        UserPropertyDefn uDefn = new UserPropertyDefn();
        uDefn.setName("MyProperty");
        this.designElement.addUserPropertyDefn(uDefn);
        DesignElementTest.assertTrue((boolean)this.designElement.hasUserProperties());
        this.designElement.dropUserPropertyDefn(uDefn);
        DesignElementTest.assertFalse((boolean)this.designElement.hasUserProperties());
    }

    public void testHasLocalPropertyValues() {
        DesignElementTest.assertFalse((boolean)this.designElement.hasLocalPropertyValues());
        this.designElement.setProperty("displayName", (Object)"hello");
        DesignElementTest.assertTrue((boolean)this.designElement.hasLocalPropertyValues());
    }

    public void testGetUserProperties() {
        DesignElementTest.assertEquals((int)0, (int)this.designElement.getUserProperties().size());
        UserPropertyDefn uDefn = new UserPropertyDefn();
        uDefn.setName("property");
        this.designElement.addUserPropertyDefn(uDefn);
        List collection = this.designElement.getUserProperties();
        DesignElementTest.assertTrue((collection.size() == 1 ? 1 : 0) != 0);
        TextItem parent = new TextItem();
        parent.setName("parent");
        UserPropertyDefn defn = new UserPropertyDefn();
        defn.setName("parent property");
        parent.addUserPropertyDefn(defn);
        this.designElement.setExtendsElement((DesignElement)parent);
        List collect = this.designElement.getUserProperties();
        DesignElementTest.assertTrue((collect.size() == 2 ? 1 : 0) != 0);
    }

    public void testIsKindOf() {
        TextItem parent = new TextItem();
        parent.setName("parent");
        this.designElement.setExtendsElement((DesignElement)parent);
        DesignElementTest.assertTrue((boolean)this.designElement.isKindOf((DesignElement)parent));
        TextItem grand = new TextItem();
        grand.setName("grand");
        DesignElementTest.assertFalse((boolean)this.designElement.isKindOf((DesignElement)grand));
        parent.setExtendsElement((DesignElement)grand);
        DesignElementTest.assertTrue((boolean)this.designElement.isKindOf((DesignElement)grand));
    }

    public void testHasDerived() {
        TextItem parent = new TextItem();
        parent.setName("parent");
        DesignElementTest.assertFalse((boolean)parent.hasDerived());
        this.designElement.setExtendsElement((DesignElement)parent);
        DesignElementTest.assertTrue((boolean)parent.hasDerived());
    }

    public void testGetDoubleProperty() {
        DesignElementTest.assertNull((Object)this.designElement.getProperty((Module)this.design, "displayName"));
        double o = this.designElement.getFloatProperty((Module)this.design, "displayName");
        DesignElementTest.assertEquals((String)"0.0", (String)Double.toString(o));
        this.design.setProperty("refreshRate", (Object)new Integer(2));
        o = this.design.getFloatProperty((Module)this.design, "refreshRate");
        DesignElementTest.assertEquals((String)Double.toString(2.0), (String)Double.toString(o));
        ListGroup group = new ListGroup();
        group.setProperty("intervalRange", (Object)new Double(2.5));
        o = group.getFloatProperty((Module)this.design, "intervalRange");
        DesignElementTest.assertEquals((String)Double.toString(2.5), (String)Double.toString(o));
    }

    public void testLabelDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_1.xml", TEST_LOCALE);
        DesignElementTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        this.matchSituation(0, 0, "he", 0);
        this.matchSituation(0, 1, "label2", 0);
        this.matchSituation(0, 2, "label3", 0);
        this.matchSituation(0, 3, "Ant", 0);
        this.matchSituation(0, 4, null, 0);
        this.matchSituation(0, 5, null, 0);
        this.matchSituation(0, 0, "he", 1);
        this.matchSituation(0, 1, "label2", 1);
        this.matchSituation(0, 2, "label3", 1);
        this.matchSituation(0, 3, "Ant", 1);
        this.matchSituation(0, 4, "\u6807\u7b7e", 1);
        this.matchSituation(0, 5, "\u6807\u7b7e", 1);
        this.matchSituation(0, 0, "he", 2);
        this.matchSituation(0, 1, "label2", 2);
        this.matchSituation(0, 2, "label3", 2);
        this.matchSituation(0, 3, "Ant", 2);
        this.matchSituation(0, 4, "\u6807\u7b7e", 2);
        this.matchSituation(0, 5, "\u6807\u7b7e", 2);
        this.matchSituation(0, 6, "hexingjie(\"blue\")", 2);
        this.matchSituation(0, 7, "\u6807\u7b7e(\"blue\")", 2);
        this.matchSituation(0, 8, "\u6807\u7b7e(\"test asdf sadf sadf sdaf...\")", 2);
    }

    public void testTextDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_2.xml", TEST_LOCALE);
        DesignElementTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        this.matchSituation(1, 0, "he", 0);
        this.matchSituation(1, 1, "text2", 0);
        this.matchSituation(1, 2, "text3", 0);
        this.matchSituation(1, 3, "Ant", 0);
        this.matchSituation(1, 4, null, 0);
        this.matchSituation(1, 5, null, 0);
        this.matchSituation(1, 0, "he", 1);
        this.matchSituation(1, 1, "text2", 1);
        this.matchSituation(1, 2, "text3", 1);
        this.matchSituation(1, 3, "Ant", 1);
        this.matchSituation(1, 4, "\u6587\u672c", 1);
        this.matchSituation(1, 5, "\u6587\u672c", 1);
        this.matchSituation(1, 0, "he", 2);
        this.matchSituation(1, 1, "text2", 2);
        this.matchSituation(1, 2, "text3", 2);
        this.matchSituation(1, 3, "Ant", 2);
        this.matchSituation(1, 4, "\u6587\u672c", 2);
        this.matchSituation(1, 5, "\u6587\u672c", 2);
        this.matchSituation(1, 6, "hexingjie(\"This is a sample bit of plain...\")", 2);
        this.matchSituation(1, 7, "\u6587\u672c(\"hello,12345678910111213141adfa...\")", 2);
        this.matchSituation(1, 8, "\u6587\u672c(\"This is \")", 2);
        this.matchSituation(1, 9, "\u6587\u672c(\"a sample bit of plain...\")", 2);
    }

    public void testGridDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_3.xml", TEST_LOCALE);
        DesignElementTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        this.matchSituation(2, 0, "he", 0);
        this.matchSituation(2, 1, "grid2", 0);
        this.matchSituation(2, 2, "grid3", 0);
        this.matchSituation(2, 3, "Ant", 0);
        this.matchSituation(2, 4, null, 0);
        this.matchSituation(2, 5, null, 0);
        this.matchSituation(2, 0, "he", 1);
        this.matchSituation(2, 1, "grid2", 1);
        this.matchSituation(2, 2, "grid3", 1);
        this.matchSituation(2, 3, "Ant", 1);
        this.matchSituation(2, 4, "\u7f51\u683c", 1);
        this.matchSituation(2, 5, "\u7f51\u683c", 1);
        this.matchSituation(2, 0, "he(0 x 0)", 2);
        this.matchSituation(2, 1, "grid2(0 x 0)", 2);
        this.matchSituation(2, 2, "grid3(0 x 0)", 2);
        this.matchSituation(2, 3, "Ant(0 x 0)", 2);
        this.matchSituation(2, 4, "\u7f51\u683c(0 x 0)", 2);
        this.matchSituation(2, 5, "\u7f51\u683c(0 x 0)", 2);
        this.matchSituation(2, 6, "hexingjie(3 x 2)", 2);
        this.matchSituation(2, 7, "\u7f51\u683c(1 x 0)", 2);
    }

    public void testListDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_4.xml", TEST_LOCALE);
        this.matchSituation(3, 0, "he", 0);
        this.matchSituation(3, 1, "list2", 0);
        this.matchSituation(3, 2, "list3", 0);
        this.matchSituation(3, 3, "Ant", 0);
        this.matchSituation(3, 4, null, 0);
        this.matchSituation(3, 5, null, 0);
        this.matchSituation(3, 0, "he", 1);
        this.matchSituation(3, 1, "list2", 1);
        this.matchSituation(3, 2, "list3", 1);
        this.matchSituation(3, 3, "Ant", 1);
        this.matchSituation(3, 4, "\u5217\u8868", 1);
        this.matchSituation(3, 5, "\u5217\u8868", 1);
        this.matchSituation(3, 0, "he(firstDataSet)", 2);
        this.matchSituation(3, 1, "list2(firstDataSet)", 2);
        this.matchSituation(3, 2, "list3(firstDataSet)", 2);
        this.matchSituation(3, 3, "Ant(firstDataSet)", 2);
        this.matchSituation(3, 4, "\u5217\u8868(firstDataSet)", 2);
        this.matchSituation(3, 5, "\u5217\u8868(firstDataSet)", 2);
        this.matchSituation(3, 6, "hexingjie(firstDataSet)", 2);
        this.matchSituation(3, 7, "\u5217\u8868(secondDataSet)", 2);
        this.matchSituation(3, 8, "\u5217\u8868(test asdf sadf sadf sdaf...)", 2);
    }

    public void testDataDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_5.xml", TEST_LOCALE);
        DesignElementTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        this.matchSituation(4, 0, "he", 0);
        this.matchSituation(4, 1, "data2", 0);
        this.matchSituation(4, 2, "data3", 0);
        this.matchSituation(4, 3, "Ant", 0);
        this.matchSituation(4, 4, null, 0);
        this.matchSituation(4, 5, null, 0);
        this.matchSituation(4, 0, "he", 1);
        this.matchSituation(4, 1, "data2", 1);
        this.matchSituation(4, 2, "data3", 1);
        this.matchSituation(4, 3, "Ant", 1);
        this.matchSituation(4, 4, "\u6570\u636e", 1);
        this.matchSituation(4, 5, "\u6570\u636e", 1);
        this.matchSituation(4, 0, "he", 2);
        this.matchSituation(4, 1, "data2", 2);
        this.matchSituation(4, 2, "data3", 2);
        this.matchSituation(4, 3, "Ant", 2);
        this.matchSituation(4, 4, "\u6570\u636e", 2);
        this.matchSituation(4, 5, "\u6570\u636e", 2);
        this.matchSituation(4, 6, "hexingjie(haha)", 2);
        this.matchSituation(4, 7, "\u6570\u636e(testtest)", 2);
        this.matchSituation(4, 7, "\u6570\u636e(testtest)", 2);
        this.matchSituation(4, 8, "\u6570\u636e(test asdf sadf sadf sdaf...)", 2);
    }

    public void testImageDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_6.xml", TEST_LOCALE);
        this.matchSituation(5, 0, "he", 0);
        this.matchSituation(5, 1, "image2", 0);
        this.matchSituation(5, 2, "image3", 0);
        this.matchSituation(5, 3, "Ant", 0);
        this.matchSituation(5, 4, null, 0);
        this.matchSituation(5, 5, null, 0);
        this.matchSituation(5, 0, "he", 1);
        this.matchSituation(5, 1, "image2", 1);
        this.matchSituation(5, 2, "image3", 1);
        this.matchSituation(5, 3, "Ant", 1);
        this.matchSituation(5, 4, "\u56fe\u50cf", 1);
        this.matchSituation(5, 5, "\u56fe\u50cf", 1);
        this.matchSituation(5, 0, "he(Blue He)", 2);
        this.matchSituation(5, 1, "image2(Blue He)", 2);
        this.matchSituation(5, 2, "image3(Blue He)", 2);
        this.matchSituation(5, 3, "Ant(Blue He)", 2);
        this.matchSituation(5, 4, "\u56fe\u50cf(Blue He)", 2);
        this.matchSituation(5, 5, "\u56fe\u50cf(Blue He)", 2);
        this.matchSituation(5, 6, "hexingjie1(Blue He)", 2);
        this.matchSituation(5, 7, "hexingjie2(test image)", 2);
        this.matchSituation(5, 8, "\u56fe\u50cf(haha)", 2);
        this.matchSituation(5, 9, "\u56fe\u50cf(test asdf sadf sadf sdaf...)", 2);
        this.matchSituation(5, 10, "\u56fe\u50cf(test asdf sadf sadf...)", 2);
        this.matchSituation(5, 11, "\u56fe\u50cf(test asdf sadf...)", 2);
    }

    public void testTableDisplayLabel() throws Exception {
        this.openDesign("DesignElementTest_7.xml", TEST_LOCALE);
        this.matchSituation(6, 0, "he", 0);
        this.matchSituation(6, 1, "table2", 0);
        this.matchSituation(6, 2, "table3", 0);
        this.matchSituation(6, 3, "Ant", 0);
        this.matchSituation(6, 4, null, 0);
        this.matchSituation(6, 5, null, 0);
        this.matchSituation(6, 0, "he", 1);
        this.matchSituation(6, 1, "table2", 1);
        this.matchSituation(6, 2, "table3", 1);
        this.matchSituation(6, 3, "Ant", 1);
        this.matchSituation(6, 4, "\u8868\u683c", 1);
        this.matchSituation(6, 5, "\u8868\u683c", 1);
        this.matchSituation(6, 0, "he(firstDataSet)", 2);
        this.matchSituation(6, 1, "table2(firstDataSet)", 2);
        this.matchSituation(6, 2, "table3(firstDataSet)", 2);
        this.matchSituation(6, 3, "Ant(firstDataSet)", 2);
        this.matchSituation(6, 4, "\u8868\u683c(firstDataSet)", 2);
        this.matchSituation(6, 5, "\u8868\u683c(firstDataSet)", 2);
        this.matchSituation(6, 6, "hexingjie(firstDataSet)", 2);
        this.matchSituation(6, 7, "\u8868\u683c(secondDataSet)", 2);
        this.matchSituation(6, 7, "\u8868\u683c(secondDataSet)", 2);
        this.matchSituation(6, 7, "\u8868\u683c(secondDataSet)", 2);
        this.matchSituation(6, 8, "\u8868\u683c(asdf sadf asdfa...)", 2);
    }

    private void matchSituation(int type, int number, String exceptValue, int level) {
        SlotHandle slotHandle = this.designHandle.getBody();
        SlotHandle reportSlotHandle = ((FreeFormHandle)slotHandle.get(0)).getReportItems();
        String displayLabel = null;
        switch (type) {
            case 0: {
                LabelHandle lblHandle = (LabelHandle)reportSlotHandle.get(number);
                displayLabel = lblHandle.getDisplayLabel(level);
                break;
            }
            case 1: {
                TextItemHandle textHandle = (TextItemHandle)reportSlotHandle.get(number);
                displayLabel = textHandle.getDisplayLabel(level);
                break;
            }
            case 2: {
                GridHandle gridHandle = (GridHandle)reportSlotHandle.get(number);
                displayLabel = gridHandle.getDisplayLabel(level);
                break;
            }
            case 3: {
                ListHandle listHandle = (ListHandle)reportSlotHandle.get(number);
                displayLabel = listHandle.getDisplayLabel(level);
                break;
            }
            case 4: {
                DataItemHandle dataHandle = (DataItemHandle)reportSlotHandle.get(number);
                displayLabel = dataHandle.getDisplayLabel(level);
                break;
            }
            case 5: {
                ImageHandle imageHandle = (ImageHandle)reportSlotHandle.get(number);
                displayLabel = imageHandle.getDisplayLabel(level);
                break;
            }
            case 6: {
                TableHandle tableHandle = (TableHandle)reportSlotHandle.get(number);
                displayLabel = tableHandle.getDisplayLabel(level);
                break;
            }
        }
        DesignElementTest.assertEquals((String)exceptValue, displayLabel);
        slotHandle = null;
        reportSlotHandle = null;
    }

    public void testGetIntrinsicProperty() {
        TableItem table = new TableItem();
        Style style = new Style("MyStyle");
        table.setStyle((StyleElement)style);
        DesignElementTest.assertEquals(null, (Object)table.getProperty(null, "name"));
    }

    public void testID() throws SemanticException {
        this.setupDesign();
        DesignElementTest.assertEquals((long)this.design.getID(), (long)1L);
        DesignElementTest.assertNotNull((Object)this.design.getElementByID(1L));
        MetaDataDictionary.getInstance().enableElementID();
        this.setupDesign();
        DesignElementTest.assertTrue((this.design.getID() != 0L ? 1 : 0) != 0);
        DesignElementTest.assertEquals((Object)this.design.getElementByID(this.design.getID()), (Object)this.design);
        FreeFormHandle container1 = (FreeFormHandle)this.designHandle.getComponents().get(0);
        long container1ID = container1.getID();
        DesignElementTest.assertTrue((container1ID != 0L ? 1 : 0) != 0);
        DesignElementHandle handle = this.designHandle.getElementByID(container1ID);
        DesignElementTest.assertEquals((Object)handle, (Object)container1);
        this.designHandle.getComponents().dropAndClear((DesignElementHandle)container1);
        DesignElementTest.assertEquals((long)container1.getID(), (long)container1ID);
        DesignElementTest.assertNull((Object)this.designHandle.getElementByID(container1ID));
    }

    public void testElementRef() throws SemanticException {
        this.setupDesign();
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("Label 1");
        DataSetHandle dataSet1 = this.designHandle.findDataSet("Data Set 1");
        label1.setProperty("dataSet", (Object)dataSet1.getName());
        DesignElementTest.assertEquals((String)label1.getStringProperty("dataSet"), (String)dataSet1.getName());
        DesignElementTest.assertEquals((Object)label1.getElementProperty("dataSet"), (Object)dataSet1);
        dataSet1.setName("New Name");
        DesignElementTest.assertEquals((String)dataSet1.getName(), (String)"New Name");
        DesignElementTest.assertEquals((String)label1.getStringProperty("dataSet"), (String)dataSet1.getName());
        DesignElementTest.assertEquals((Object)label1.getElementProperty("dataSet"), (Object)dataSet1);
        DataSourceHandle dataSource1 = this.designHandle.findDataSource("Data Source 1");
        DataSource dataSource = (DataSource)dataSource1.getElement();
        DesignElementTest.assertEquals((int)1, (int)dataSource.getClientList().size());
        dataSet1.dropAndClear();
        DesignElementTest.assertEquals((int)0, (int)dataSource.getClientList().size());
        DesignElementTest.assertNull((Object)label1.getStringProperty("dataSet"));
        DesignElementTest.assertNull((Object)label1.getElementProperty("dataSet"));
        label1.setProperty("dataSet", (Object)"Data Set 1");
        DesignElementTest.assertEquals((String)label1.getStringProperty("dataSet"), (String)"Data Set 1");
        DesignElementTest.assertNull((Object)label1.getElementProperty("dataSet"));
        dataSet1 = this.designHandle.getElementFactory().newOdaDataSet("Data Set 1");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet1);
        dataSet1.setDataSource(dataSource1.getName());
        DesignElementTest.assertEquals((String)label1.getStringProperty("dataSet"), (String)"Data Set 1");
        DesignElementTest.assertEquals((Object)label1.getElementProperty("dataSet"), (Object)dataSet1);
        DesignElementTest.assertEquals((String)label1.getStringProperty("dataSet"), (String)dataSet1.getName());
        dataSet1.setName("New Name");
        DesignElementTest.assertEquals((Object)label1.getElementProperty("dataSet"), (Object)dataSet1);
        DesignElementTest.assertEquals((String)label1.getStringProperty("dataSet"), (String)dataSet1.getName());
        DesignElementTest.assertEquals((int)1, (int)dataSource.getClientList().size());
        dataSet1.dropAndClear();
        DesignElementTest.assertEquals((int)0, (int)dataSource.getClientList().size());
        DesignElementTest.assertNull((Object)label1.getDataSet());
        this.designHandle.getCommandStack().undo();
        DesignElementTest.assertEquals((Object)dataSet1, (Object)label1.getDataSet());
        DesignElementTest.assertEquals((int)1, (int)dataSource.getClientList().size());
        this.designHandle.getCommandStack().redo();
        DesignElementTest.assertNull((Object)label1.getDataSet());
        DesignElementTest.assertEquals((int)0, (int)dataSource.getClientList().size());
        dataSource1.dropAndClear();
    }

    public void testIsContentOf() throws SemanticException {
        this.setupDesign();
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("Label 1");
        DesignElementTest.assertTrue((boolean)label1.getElement().isContentOf(label1.getElement()));
        DesignElementTest.assertTrue((boolean)label1.getElement().isContentOf(this.designHandle.getElement()));
        DesignElementTest.assertFalse((boolean)this.designHandle.getElement().isContentOf(label1.getElement()));
    }

    private void setupDesign() throws SemanticException {
        this.createDesign(null);
        ElementFactory factory = this.designHandle.getElementFactory();
        FreeFormHandle container1 = factory.newFreeForm("Container 1");
        this.designHandle.getComponents().add((DesignElementHandle)container1);
        LabelHandle label1 = factory.newLabel("Label 1");
        container1.getReportItems().add((DesignElementHandle)label1);
        LabelHandle label2 = factory.newLabel("Label 2");
        container1.getReportItems().add((DesignElementHandle)label2);
        LabelHandle label3 = factory.newLabel("Label 3");
        container1.getReportItems().add((DesignElementHandle)label3);
        FreeFormHandle container2 = factory.newFreeForm("Container 2");
        this.designHandle.getBody().add((DesignElementHandle)container2);
        FreeFormHandle container3 = factory.newFreeForm("Container 3");
        this.designHandle.getBody().add((DesignElementHandle)container3);
        FreeFormHandle container4 = factory.newFreeForm(null);
        this.designHandle.getBody().add((DesignElementHandle)container4);
        SharedStyleHandle style1 = factory.newStyle("Style-1");
        this.designHandle.getStyles().add((DesignElementHandle)style1);
        SharedStyleHandle style2 = factory.newStyle("Style-2");
        this.designHandle.getStyles().add((DesignElementHandle)style2);
        SharedStyleHandle style3 = factory.newStyle("Style-3");
        this.designHandle.getStyles().add((DesignElementHandle)style3);
        OdaDataSourceHandle dataSource1 = factory.newOdaDataSource("Data Source 1");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource1);
        OdaDataSourceHandle dataSource2 = factory.newOdaDataSource("Data Source 2");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource2);
        OdaDataSetHandle dataSet1 = factory.newOdaDataSet("Data Set 1");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet1);
        dataSet1.setDataSource(dataSource1.getName());
        GraphicMasterPageHandle masterPage1 = factory.newGraphicMasterPage("My Page");
        this.designHandle.getMasterPages().add((DesignElementHandle)masterPage1);
        container1.setStyle(style2);
        label1.setStyle(style2);
        label1.setDataSet((DataSetHandle)dataSet1);
        this.design.setProperty("author", (Object)"Bob the Builder");
        this.design.setProperty("comments", (Object)"Sample design");
    }

    public void testElementIdentifier() throws Exception {
        this.createDesign();
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        DesignElementTest.assertEquals((String)"Label", (String)label.getElement().getIdentifier());
        this.designHandle.getBody().add((DesignElementHandle)label);
        DesignElementTest.assertEquals((String)"report.Body[0]", (String)label.getElement().getIdentifier());
        TableHandle table1 = this.designHandle.getElementFactory().newTableItem("table1", 3, 0, 3, 0);
        DesignElementTest.assertEquals((String)"Table(\"table1\")", (String)table1.getElement().getIdentifier());
        RowHandle row = (RowHandle)table1.getDetail().get(0);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        DesignElementTest.assertEquals((String)"Table(\"table1\").Detail[0].Cells[0]", (String)cell.getElement().getIdentifier());
        this.designHandle.getBody().add((DesignElementHandle)table1);
        DesignElementTest.assertEquals((String)"Table(\"table1\")", (String)table1.getElement().getIdentifier());
        DesignElementTest.assertEquals((String)"Table(\"table1\").Detail[0].Cells[0]", (String)cell.getElement().getIdentifier());
        TableHandle table2 = this.designHandle.getElementFactory().newTableItem(null, 3, 0, 3, 0);
        DesignElementTest.assertEquals((String)"Table", (String)table2.getElement().getIdentifier());
        row = (RowHandle)table2.getDetail().get(0);
        cell = (CellHandle)row.getCells().get(0);
        DesignElementTest.assertEquals((String)"Table.Detail[0].Cells[0]", (String)cell.getElement().getIdentifier());
        this.designHandle.getBody().add((DesignElementHandle)table2);
        DesignElementTest.assertEquals((String)"report.Body[2]", (String)table2.getElement().getIdentifier());
        DesignElementTest.assertEquals((String)"report.Body[2].Detail[0].Cells[0]", (String)cell.getElement().getIdentifier());
    }

    public void testExtendsValidatorAndResolve() throws Exception {
        this.openDesign("DesignElementTest_8.xml");
        DesignElementTest.assertNotNull((Object)this.designHandle);
        DesignElementTest.assertEquals((int)2, (int)this.designHandle.getErrorList().size());
        ErrorDetail error = (ErrorDetail)this.designHandle.getErrorList().get(0);
        DesignElementTest.assertEquals((String)"Error.InvalidParentException.PARENT_NOT_FOUND", (String)error.getErrorCode());
        error = (ErrorDetail)this.designHandle.getErrorList().get(1);
        DesignElementTest.assertEquals((String)"Error.InvalidParentException.PARENT_NOT_FOUND", (String)error.getErrorCode());
        this.designHandle.includeLibrary("Library_1.xml", "lib");
        ImageHandle libImage = (ImageHandle)this.designHandle.getLibrary("lib").findElement("libImage");
        ImageHandle designImage = (ImageHandle)this.designHandle.findElement("designImage");
        designImage.setExtendsName("lib.libImage");
        DesignElementTest.assertEquals((Object)libImage, (Object)designImage.getExtends());
    }

    public void testNameManager() throws Exception {
        this.openDesign("DesignElementTest_1.xml");
        DesignElementTest.assertNotNull((Object)this.designHandle);
        ScalarParameterHandle param = this.designHandle.getElementFactory().newScalarParameter(null);
        DesignElementTest.assertNotNull((Object)param.getName());
        DesignElementTest.assertEquals((Object)param.getElement(), (Object)((AbstractNameHelper)this.design.getNameHelper()).getCachedNameSpace("parameter").getElement(param.getName()));
        this.designHandle.getParameters().add((DesignElementHandle)param);
        DesignElementTest.assertNull((Object)((AbstractNameHelper)this.design.getNameHelper()).getCachedNameSpace("parameter").getElement(param.getName()));
    }

    public void testStyleLocalPropertyValues() throws Exception {
        this.openDesign("LocalStylePropertyValuesTest.xml");
        DesignElementHandle label1 = this.designHandle.findElement("NewLabel");
        DesignElementTest.assertTrue((boolean)label1.hasLocalProperties());
        DesignElementHandle label2 = this.designHandle.findElement("NewLabel1");
        DesignElementTest.assertFalse((boolean)label2.hasLocalProperties());
        DesignElementHandle extendedItem = this.designHandle.findElement("test-box-1");
        DesignElementTest.assertTrue((boolean)extendedItem.hasLocalProperties());
        extendedItem = this.designHandle.findElement("test-box-2");
        DesignElementTest.assertFalse((boolean)extendedItem.hasLocalProperties());
    }

    public void testSelectorDisplayLabel() throws Exception {
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        this.createDesign(TEST_LOCALE);
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("grid");
        DesignElementTest.assertEquals((String)"\u7f51\u683c", (String)style.getDisplayLabel());
        style = this.designHandle.getElementFactory().newStyle("table");
        DesignElementTest.assertEquals((String)"Table", (String)style.getDisplayLabel());
    }

    public void testPageBreakInsideInRow() throws Exception {
        this.createDesign();
        ElementFactory factory = this.designHandle.getElementFactory();
        TableHandle table = factory.newTableItem("testTalbe", 1);
        RowHandle row = (RowHandle)table.getHeader().get(0);
        DesignElementTest.assertEquals((String)"avoid", (String)row.getStringProperty("pageBreakInside"));
        TableGroupHandle groupHandle = factory.newTableGroup();
        row = factory.newTableRow();
        DesignElementTest.assertEquals((String)"auto", (String)row.getStringProperty("pageBreakInside"));
        groupHandle.getHeader().add((DesignElementHandle)row);
        DesignElementTest.assertEquals((String)"avoid", (String)row.getStringProperty("pageBreakInside"));
        GridHandle grid = factory.newGridItem("testGrid");
        row = factory.newTableRow();
        DesignElementTest.assertEquals((String)"auto", (String)row.getStringProperty("pageBreakInside"));
        grid.getRows().add((DesignElementHandle)row);
        DesignElementTest.assertEquals((String)"auto", (String)row.getStringProperty("pageBreakInside"));
    }

    class MyActionListener
    implements Listener {
        boolean done = false;
        int path = -1;

        MyActionListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.done = true;
            this.path = ev.getDeliveryPath();
        }
    }
}

