/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeFunctionFactory;
import org.junit.Test;
import testutil.BaseTestCase;

public class TrailingTest
extends BaseTestCase {
    @Test
    public void testTrailing1() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"year", (int)-3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing2() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)-3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing3() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"month", (int)-3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing4() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"week-of-month", (int)3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing5() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"day-of-year", (int)3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing6() throws IOException {
        int[] values = new int[]{2011, 1};
        String[] types = new String[]{"year", "quarter"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)3).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing7() throws IOException {
        int[] values = new int[]{2008, 2, 29};
        String[] types = new String[]{"year", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"year", (int)3).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing8() throws IOException {
        int[] values = new int[]{2008, 1};
        String[] types = new String[]{"year", "month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)1).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing9() throws IOException {
        int[] values = new int[]{2008, 1, 20};
        String[] types = new String[]{"year", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)-1).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing10() throws IOException {
        int[] values = new int[]{2008, 1, 2};
        String[] types = new String[]{"year", "quarter", "month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)-1).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing11() throws IOException {
        int[] values = new int[]{2008, 2, 20};
        String[] types = new String[]{"year", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)-1).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing12() throws IOException {
        int[] values = new int[]{2008, 1, 2, 20};
        String[] types = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)-1).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing13() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"month", (int)-3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 28));
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing14() throws IOException {
        int[] values = new int[]{2011, 3};
        String[] types = new String[]{"year", "quarter"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"year", (int)-1).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing15() throws IOException {
        int[] values = new int[]{2011};
        String[] types = new String[]{"year"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"year", (int)-3).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing16() throws IOException {
        int[] values = new int[]{2003};
        String[] types = new String[]{"year"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"day-of-year", (int)-120).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing17() throws IOException {
        int[] values = new int[]{2003};
        String[] types = new String[]{"year"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = TimeFunctionFactory.createTrailingFunction((String)"day-of-year", (int)120).getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing18() throws IOException {
        int[] values = new int[]{2011, 1, 1, 1};
        String[] types = new String[]{"year", "month", "week-of-month", "week-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"week-of-year", (int)-3);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 28));
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing19() throws IOException {
        int[] values = new int[]{2011, 12, 4, 52};
        String[] types = new String[]{"year", "month", "week-of-month", "week-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"week-of-year", (int)3);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing20() throws IOException {
        int[] values = new int[]{2010, 12, 5, 1};
        String[] types = new String[]{"year", "month", "week-of-month", "week-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"week-of-year", (int)3);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing21() throws IOException {
        int[] values = new int[]{2004, 1, 1, 1};
        String[] types = new String[]{"year", "quarter", "month", "week-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"quarter", (int)1);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    @Test
    public void testTrailing22() throws IOException {
        int[] values = new int[]{2004, 1};
        String[] types = new String[]{"year", "week-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createTrailingFunction((String)"year", (int)1);
        List timeMembers = periodsFunction.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    private void printMembers(List<TimeMember> timeMembers) {
        for (TimeMember timeMember : timeMembers) {
            String[] levelTypes = timeMember.getLevelType();
            int[] memberValues = timeMember.getMemberValue();
            int i = 0;
            while (i < levelTypes.length) {
                this.testPrint(levelTypes[i] + " ");
                ++i;
            }
            this.testPrintln("");
            i = 0;
            while (i < memberValues.length) {
                this.testPrint(memberValues[i] + " ");
                ++i;
            }
            this.testPrintln("");
        }
    }
}

