/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.junit.Assert;
import org.junit.Test;
import testutil.BaseTestCase;

public class ProgressiveViewingTest
extends BaseTestCase {
    @Test
    public void testProgressiveViewing1() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 0;
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("column1")).intValue(), (long)(++i));
        }
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 0;
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("column1")).intValue(), (long)(++i + 1));
        }
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing3() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        boolean i = false;
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("aggr")).intValue(), (long)10L);
            Assert.assertEquals((long)((Integer)ri1.getValue("column1")).intValue(), (long)11L);
        }
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing4() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        boolean i = false;
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("column1")).intValue(), (long)11L);
        }
        Assert.assertEquals((long)((Integer)ri1.getValue("aggr")).intValue(), (long)10L);
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing5() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("runningcount");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 1;
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("aggr")).intValue(), (long)i);
            ++i;
        }
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing6() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.setDataSetName("test");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.column1 != 5;"));
        qd.addFilter((IFilterDefinition)filter);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 0;
        while (ri1.next()) {
            int resultValue = (Integer)ri1.getValue("column1");
            if (resultValue == 6) {
                ++i;
            }
            int targetValue = ++i + 1;
            Assert.assertEquals((long)resultValue, (long)targetValue);
        }
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing7() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.aggr != 5;"));
        qd.addFilter((IFilterDefinition)filter);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("column1")).intValue(), (long)11L);
        }
        Assert.assertEquals((long)((Integer)ri1.getValue("aggr")).intValue(), (long)10L);
        dataEngine.shutdown();
    }

    @Test
    public void testProgressiveViewing8() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        Binding indirectAggregation = new Binding("column2", (IBaseExpression)new ScriptExpression("row[\"aggr\"]"));
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.addBinding((IBinding)indirectAggregation);
        qd.setDataSetName("test");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.column2 != 5;"));
        qd.addFilter((IFilterDefinition)filter);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            Assert.assertEquals((long)((Integer)ri1.getValue("column1")).intValue(), (long)11L);
        }
        Assert.assertEquals((long)((Integer)ri1.getValue("aggr")).intValue(), (long)10L);
        dataEngine.shutdown();
    }
}

