/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.util.ChartExpressionUtil;

public class ChartExpressionUtilTest
extends TestCase {
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testIsCubeBinding() {
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isCubeBinding("data[\"ab c\"]", false));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isCubeBinding("data[\"data\"]", false));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isCubeBinding("data[\"ab c\"]+100", false));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isCubeBinding("data[\"year\"]+\"Q\"+data[\"quarter\"]", false));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isCubeBinding("data[\"ab c\"]+100", true));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isCubeBinding("100+data[\"ab c\"]", true));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isCubeBinding("data[\"year\"]+\"Q\"+data[\"quarter\"]", true));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isCubeBinding("if(data[\"LastJan\"]!=null)\r\n(data[\"ThisMonth\"]-data[\"LastJan\"])/data[\"LastJan\"]\r\nelse \r\nnull", true));
    }

    public void testGetCubeBindingName() {
        ChartExpressionUtilTest.assertEquals((String)"ab c", (String)this.exprCodec.getCubeBindingName("data[\"ab c\"]", false));
        ChartExpressionUtilTest.assertEquals((String)"data", (String)this.exprCodec.getCubeBindingName("data[\"data\"]", false));
        ChartExpressionUtilTest.assertEquals(null, (String)this.exprCodec.getCubeBindingName("data[\"data\"] + 100", false));
        ChartExpressionUtilTest.assertEquals(null, (String)this.exprCodec.getCubeBindingName("data[\"year\"]+\"Q\"+data[\"quarter\"]", false));
        ChartExpressionUtilTest.assertEquals((String)"ab c", (String)this.exprCodec.getCubeBindingName("data[\"ab c\"]", true));
        ChartExpressionUtilTest.assertEquals((String)"ab c", (String)this.exprCodec.getCubeBindingName("data[\"ab c\"] + 100", true));
        ChartExpressionUtilTest.assertEquals((String)"ab c", (String)this.exprCodec.getCubeBindingName("100 * data[\"ab c\"] ", true));
        ChartExpressionUtilTest.assertEquals((String)"123", (String)this.exprCodec.getCubeBindingName("data[\"123\"] + data[\"ab c\"] ", true));
        ChartExpressionUtilTest.assertEquals((String)"123", (String)this.exprCodec.getCubeBindingName("data[\"12\"+\"3\"] ", true));
    }

    public void testGetCubeBindingNameList() {
        List names = this.exprCodec.getCubeBindingNameList("data[\"123\"] + data[\"ab c\"]");
        ChartExpressionUtilTest.assertEquals((int)2, (int)names.size());
        ChartExpressionUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        ChartExpressionUtilTest.assertEquals((String)"ab c", (String)((String)names.get(1)));
        names = this.exprCodec.getCubeBindingNameList("123");
        ChartExpressionUtilTest.assertEquals((int)0, (int)names.size());
        names = this.exprCodec.getCubeBindingNameList("data[\"123\"]");
        ChartExpressionUtilTest.assertEquals((int)1, (int)names.size());
        ChartExpressionUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        names = this.exprCodec.getCubeBindingNameList("data[\"123\"] + 100");
        ChartExpressionUtilTest.assertEquals((int)1, (int)names.size());
        ChartExpressionUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        names = this.exprCodec.getCubeBindingNameList("data[\"123\"] + data[\"ab c\"] + data[\"a\"]");
        ChartExpressionUtilTest.assertEquals((int)3, (int)names.size());
        ChartExpressionUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        ChartExpressionUtilTest.assertEquals((String)"ab c", (String)((String)names.get(1)));
        ChartExpressionUtilTest.assertEquals((String)"a", (String)((String)names.get(2)));
    }

    public void testIsDimensionExpresion() {
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isDimensionExpresion("dimension[\"abc\"][\"12 3\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isDimensionExpresion("dimension[\"a\"+\"bc\"][\"12 3\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isDimensionExpresion("dimension[\"abc\"][\"12 3\"]+2"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isDimensionExpresion("2+dimension[\"abc\"][\"12 3\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isDimensionExpresion("dimension[\"abc\"][12 3]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isDimensionExpresion("dimension[\"abc\"]"));
    }

    public void testGetLevelNameFromDimensionExpression() {
        String[] levels = this.exprCodec.getLevelNames("dimension[\"abc\"][\"12 3\"]");
        ChartExpressionUtilTest.assertEquals((String)"abc", (String)levels[0]);
        ChartExpressionUtilTest.assertEquals((String)"12 3", (String)levels[1]);
        levels = this.exprCodec.getLevelNames("dimension[\"a\"+\"bc\"][\"a\"+2*3+\"b\"]");
        ChartExpressionUtilTest.assertEquals((String)"abc", (String)levels[0]);
        ChartExpressionUtilTest.assertEquals((String)"a6b", (String)levels[1]);
        levels = this.exprCodec.getLevelNames("1+dimension[\"abc\"][\"12 3\"]");
        ChartExpressionUtilTest.assertNull((Object)levels);
    }

    public void testIsMeasureExpresion() {
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isMeasureExpresion("measure[\"12 3\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)this.exprCodec.isMeasureExpresion("measure[\"a\"+\"bc\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isMeasureExpresion("measure[\"12 3\"]+1"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isMeasureExpresion("1*measure[\"12 3\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isMeasureExpresion("measure[12 3]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)this.exprCodec.isMeasureExpresion("dimension[\"abc\"]"));
    }

    public void testGetMeasureName() {
        ChartExpressionUtilTest.assertEquals((String)"12 3", (String)this.exprCodec.getMeasureName("measure[\"12 3\"]"));
        ChartExpressionUtilTest.assertEquals((String)"abc", (String)this.exprCodec.getMeasureName("measure[\"a\"+\"bc\"]"));
        ChartExpressionUtilTest.assertNull((Object)this.exprCodec.getMeasureName("measure[\"abc\"+5]"));
    }

    public void testCheckStringInExpression() {
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)ChartExpressionUtil.checkStringInExpression((String)"data[\"year\"]+\"Q\"+data[\"quarter\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)ChartExpressionUtil.checkStringInExpression((String)"\"Q\"+data[\"quarter\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)true, (boolean)ChartExpressionUtil.checkStringInExpression((String)"data[\"quarter\"]+\"Q\""));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)ChartExpressionUtil.checkStringInExpression((String)"data[\"year\"]+data[\"quarter\"]"));
        ChartExpressionUtilTest.assertEquals((boolean)false, (boolean)ChartExpressionUtil.checkStringInExpression((String)"4+data[\"quarter\"]"));
    }

    public void testGetFullBindingName() {
        ChartExpressionUtilTest.assertEquals((String)"abc", (String)this.exprCodec.getFullBindingName("data[\"abc\"]"));
        ChartExpressionUtilTest.assertEquals((String)"data[abc] + 100", (String)this.exprCodec.getFullBindingName("data[\"abc\"] + 100"));
        ChartExpressionUtilTest.assertEquals((String)"abc", (String)this.exprCodec.getFullBindingName("row[\"abc\"]"));
        ChartExpressionUtilTest.assertEquals((String)"row[abc] + 100", (String)this.exprCodec.getFullBindingName("row[\"abc\"] + 100"));
        ChartExpressionUtilTest.assertEquals((String)"abc", (String)this.exprCodec.getFullBindingName("\"abc\""));
        ChartExpressionUtilTest.assertEquals((String)"100", (String)this.exprCodec.getFullBindingName("100"));
    }
}

