/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.script.ScriptContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ScriptableParametersTest
extends TestCase {
    ScriptContext context;
    Map params;

    @Before
    public void setUp() {
        this.context = new ScriptContext();
        this.params = new HashMap();
        this.addParameter("string", "abc", "STRING VALUE");
        this.context.setAttribute("params", (Object)this.params);
    }

    private void addParameter(String name, Object value, String displayText) {
        this.params.put(name, new ParameterAttribute(value, displayText));
    }

    @After
    public void tearDown() {
        this.context.close();
    }

    @Test
    public void testAssign() throws BirtException {
        this.eval("params['string'] = 'abcd'");
        ScriptableParametersTest.assertEquals((Object)"abcd", (Object)this.eval("params['string']"));
        this.eval("params['string'].value = 'abcde'");
        ScriptableParametersTest.assertEquals((Object)"abcde", (Object)this.eval("params['string']"));
        this.eval("params['string'].displayText = 'display'");
        ScriptableParametersTest.assertEquals((Object)"display", (Object)this.eval("params['string'].displayText"));
        this.eval("params['new param'] = 'abc'");
        ScriptableParametersTest.assertEquals((Object)"abc", (Object)this.eval("params['new param']"));
        this.eval("params['date'] = new Date()");
        Object date = this.eval("params['date'].value");
        ScriptableParametersTest.assertTrue((boolean)(date instanceof Date));
        this.eval("params['number'] = new Number(3)");
        Object num = this.eval("params['number'].value");
        ScriptableParametersTest.assertTrue((boolean)(num instanceof Double));
    }

    @Test
    public void testReterive() throws BirtException {
        try {
            this.eval("params['none exsit'] == null");
            ScriptableParametersTest.fail();
        }
        catch (BirtException e) {
            ScriptableParametersTest.assertTrue((boolean)true);
        }
        ScriptableParametersTest.assertEquals((Object)"abc", (Object)this.eval("params['string'].value"));
        ScriptableParametersTest.assertEquals((Object)"bbc", (Object)this.eval("params['string'].value.replace('a', 'b')"));
        ScriptableParametersTest.assertEquals((Object)"STRING VALUE", (Object)this.eval("params['string'].displayText"));
        ScriptableParametersTest.assertEquals((Object)"abc", (Object)this.eval("params['string']"));
        ScriptableParametersTest.assertEquals((Object)"bbc", (Object)this.eval("var value = params['string'];value.replace('a', 'b')"));
    }

    @Test
    public void testEval() throws BirtException {
        this.addParameter("jsDate", "", "");
        this.eval("params['jsDate']=new Date();");
        ScriptableParametersTest.assertTrue((boolean)(this.eval("params['jsDate'].getFullYear()") instanceof Number));
        ScriptableParametersTest.assertTrue((boolean)(this.eval("params['jsDate'].value.getFullYear()") instanceof Number));
        this.addParameter("jsString", "", "");
        this.eval("params['jsString']='testString';");
        ScriptableParametersTest.assertEquals((Object)new Integer(10), (Object)this.eval("params['jsString'].length"));
        ScriptableParametersTest.assertEquals((Object)new Integer(10), (Object)this.eval("params['jsString'].value.length"));
        this.addParameter("javaDate", new Date(2008, 3, 5), "");
        ScriptableParametersTest.assertEquals((Object)new Integer(2008), (Object)this.eval("params['javaDate'].getYear()"));
        ScriptableParametersTest.assertEquals((Object)new Integer(2008), (Object)this.eval("params['javaDate'].value.getYear()"));
    }

    private Object eval(String javascript) throws BirtException {
        ICompiledScript compiledScript = this.context.compile("javascript", "<inline>", 1, javascript);
        return this.context.evaluate(compiledScript);
    }
}

