/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;

public final class Regression_117699_swing
extends JPanel
implements ICallBackNotifier,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private boolean bNeedsGeneration = true;
    private GeneratedChartState gcs = null;
    private Chart cm = null;
    private IDeviceRenderer idr = null;
    private BufferedImage bi = null;
    private Map contextMap = new HashMap();

    public static void main(String[] args) {
        final Regression_117699_swing siv = new Regression_117699_swing();
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(2);
        jf.addComponentListener(siv);
        Container co = jf.getContentPane();
        co.setLayout(new BorderLayout());
        co.add((Component)siv, "Center");
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dApp = new Dimension(600, 400);
        jf.setSize(dApp);
        jf.setLocation((dScreen.width - dApp.width) / 2, (dScreen.height - dApp.height) / 2);
        jf.setTitle(siv.getClass().getName() + " [device=" + siv.idr.getClass().getName() + "]");
        Regression_117699_swing regression_117699_swing = siv;
        regression_117699_swing.getClass();
        ControlPanel cp = regression_117699_swing.new ControlPanel(siv);
        co.add((Component)cp, "South");
        siv.idr.setProperty("device.component", (Object)siv);
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                siv.idr.dispose();
            }
        });
        jf.setVisible(true);
    }

    Regression_117699_swing() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWING");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_117699_swing.URLRedirect_ScatterChart();
    }

    public void regenerateChart() {
        this.bNeedsGeneration = true;
        this.updateBuffer();
        this.repaint();
    }

    public void repaintChart() {
        this.repaint();
    }

    public Object peerInstance() {
        return this;
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    public Object putContext(Object key, Object value) {
        return this.contextMap.put(key, value);
    }

    public Object removeContext(Object key) {
        return this.contextMap.remove(key);
    }

    public void updateBuffer() {
        Dimension d = this.getSize();
        if (this.bi == null || this.bi.getWidth() != d.width || this.bi.getHeight() != d.height) {
            this.bi = new BufferedImage(d.width, d.height, 2);
        }
        Graphics2D g2d = (Graphics2D)this.bi.getGraphics();
        this.idr.setProperty("device.output.context", (Object)g2d);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.bNeedsGeneration) {
            this.bNeedsGeneration = false;
            try {
                this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            }
            catch (ChartException ex) {
                this.showException(g2d, (Exception)((Object)ex));
            }
        }
        try {
            try {
                gr.render(this.idr, this.gcs);
            }
            catch (ChartException rex) {
                this.showException(g2d, (Exception)((Object)rex));
                g2d.dispose();
            }
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.bi == null) {
            this.updateBuffer();
        }
        g.drawImage(this.bi, 0, 0, this);
    }

    private void showException(Graphics2D g2d, Exception ex) {
        String sWrappedException = ex.getClass().getName();
        Exception th = ex;
        while (ex.getCause() != null) {
            ex = (Exception)ex.getCause();
        }
        String sException = ex.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)th).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        StackTraceElement[] stea = ex.getStackTrace();
        Dimension d = this.getSize();
        Font fo = new Font("Monospaced", 1, 14);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(20, 20, d.width - 40, d.height - 40);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(20, 20, d.width - 40, d.height - 40);
        g2d.setClip(20, 20, d.width - 40, d.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        g2d.drawString("Exception:", x, y);
        g2d.setColor(Color.RED);
        g2d.drawString(sException, x += fm.stringWidth("Exception:") + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            g2d.setColor(Color.BLACK);
            g2d.drawString("Wrapped In:", x, y);
            g2d.setColor(Color.RED);
            g2d.drawString(sWrappedException, x += fm.stringWidth("Wrapped In:") + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        g2d.setColor(Color.BLACK);
        g2d.drawString("Message:", x, y += 10);
        g2d.setColor(Color.BLUE);
        g2d.drawString(sMessage, x += fm.stringWidth("Message:") + 5, y);
        x = 25;
        y += fm.getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawString("Trace:", x, y += 10);
        x = 40;
        y += fm.getHeight();
        g2d.setColor(Color.GREEN.darker());
        int i = 0;
        while (i < stea.length) {
            g2d.drawString(stea[i].getClassName() + ":" + stea[i].getMethodName() + "(...):" + stea[i].getLineNumber(), x, y);
            x = 40;
            y += fm.getHeight();
            ++i;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.bNeedsGeneration = true;
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void callback(Object event, Object source, CallBackValue value) {
        JOptionPane.showMessageDialog(this, value.getIdentifier());
    }

    public static Chart URLRedirect_ScatterChart() {
        ChartWithAxes cwaScatter = ChartWithAxesImpl.create();
        cwaScatter.getTitle().getLabel().getCaption().setValue("Numeric Scatter Chart");
        cwaScatter.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaScatter.getPlot().getClientArea().getOutline().setVisible(false);
        cwaScatter.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaScatter).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        xAxisPrimary.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        xAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaScatter).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Price Axis");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        yAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{-46.55, 25.32, 84.46, 125.95, 38.65, -54.32, 30.0});
        NumberDataSet dsNumericValues2 = NumberDataSetImpl.create((Object)new double[]{125.99, 352.95, -201.95, 299.95, -95.95, 65.95, 58.95});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsNumericValues1);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        ScatterSeries ss = (ScatterSeries)ScatterSeriesImpl.create();
        ss.setSeriesIdentifier((Object)"Unit Price");
        int i = 0;
        while (i < ss.getMarkers().size()) {
            ((Marker)ss.getMarkers().get(i)).setType(MarkerType.ICON_LITERAL);
            ((Marker)ss.getMarkers().get(i)).setFill((Fill)ImageImpl.create((String)" http://image2.sina.com.cn/igame/new/new011/ver4/icon_rich.GIF "));
            ++i;
        }
        DataPoint dp = ss.getDataPoint();
        dp.getComponents().clear();
        dp.setPrefix("(");
        dp.setSuffix(")");
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0.00")));
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0.00")));
        ss.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        ss.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ss.getLabel().setVisible(true);
        ss.setDataSet((DataSet)dsNumericValues2);
        Trigger triger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)URLValueImpl.create((String)"http://www.actuate.com", null, null, null, null)));
        ss.getTriggers().add((Object)triger);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLACK());
        sdY.getSeries().add((Object)ss);
        return cwaScatter;
    }

    private final class ControlPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final Regression_117699_swing siv;

        ControlPanel(Regression_117699_swing siv) {
            this.siv = siv;
            this.setLayout(new GridLayout(0, 1, 0, 0));
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout(0, 3, 3));
            this.add(jp);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Regression_117699_swing.this.cm = Regression_117699_swing.URLRedirect_ScatterChart();
            Regression_117699_swing.this.bNeedsGeneration = true;
            this.siv.updateBuffer();
            this.siv.repaint();
        }
    }
}

