/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public class Image {
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_GIF = 1;
    public static final int FORMAT_PNG = 2;
    public static final int FORMAT_BMP = 3;
    private static final String[] FORMAT_NAMES = new String[]{"JPEG", "GIF", "PNG", "BMP"};
    private static final String[] MIME_TYPE_STRINGS = new String[]{"image/jpeg", "image/gif", "image/png", "image/bmp"};
    private int width;
    private int height;
    private int format;
    private InputStream in;
    private DataInput dataIn;
    private int heightDpi;
    private int widthDpi;

    public boolean check() {
        this.format = -1;
        this.width = -1;
        this.height = -1;
        this.heightDpi = -1;
        this.widthDpi = -1;
        try {
            int byte1 = this.read() & 0xFF;
            int byte2 = this.read() & 0xFF;
            if (byte1 == 71 && byte2 == 73) {
                return this.checkGif();
            }
            if (byte1 == 137 && byte2 == 80) {
                return this.checkPng();
            }
            if (byte1 == 255 && byte2 == 216) {
                return this.checkJpeg();
            }
            if (byte1 == 66 && byte2 == 77) {
                return this.checkBmp();
            }
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean checkBmp() throws IOException {
        int physicalHeightDpi;
        byte[] array = new byte[44];
        if (this.read(array) != array.length) {
            return false;
        }
        this.width = Image.getIntLittleEndian(array, 16);
        this.height = Image.getIntLittleEndian(array, 20);
        if (this.width < 1 || this.height < 1) {
            return false;
        }
        int bitsPerPixel = Image.getShortLittleEndian(array, 26);
        if (bitsPerPixel != 1 && bitsPerPixel != 4 && bitsPerPixel != 8 && bitsPerPixel != 16 && bitsPerPixel != 24 && bitsPerPixel != 32) {
            return false;
        }
        int physicalWidthDpi = (int)((double)Image.getIntLittleEndian(array, 36) * 0.0254);
        if (physicalWidthDpi > 0) {
            this.setPhysicalWidthDpi(physicalWidthDpi);
        }
        if ((physicalHeightDpi = (int)((double)Image.getIntLittleEndian(array, 40) * 0.0254)) > 0) {
            this.setPhysicalHeightDpi(physicalHeightDpi);
        }
        this.format = 3;
        return true;
    }

    private boolean checkGif() throws IOException {
        int blockType;
        byte[] GIF_MAGIC_87A = new byte[]{70, 56, 55, 97};
        byte[] GIF_MAGIC_89A = new byte[]{70, 56, 57, 97};
        byte[] array = new byte[11];
        if (this.read(array) != array.length || !Image.equals(array, 0, GIF_MAGIC_89A, 0, 4) && !Image.equals(array, 0, GIF_MAGIC_87A, 0, 4)) {
            return false;
        }
        this.format = 1;
        this.width = Image.getShortLittleEndian(array, 4);
        this.height = Image.getShortLittleEndian(array, 6);
        int flags = array[8] & 0xFF;
        if ((flags & 0x80) != 0) {
            int tableSize = (1 << (flags & 7) + 1) * 3;
            this.skip(tableSize);
        }
        do {
            blockType = this.read();
            switch (blockType) {
                case 44: {
                    if (this.read(array, 0, 9) != 9) {
                        return false;
                    }
                    flags = array[8] & 0xFF;
                    int localBitsPerPixel = (flags & 7) + 1;
                    if ((flags & 0x80) != 0) {
                        this.skip((1 << localBitsPerPixel) * 3);
                    }
                    this.skip(1);
                }
                case 33: {
                    int n;
                    do {
                        if ((n = this.read()) > 0) {
                            this.skip(n);
                            continue;
                        }
                        if (n != -1) continue;
                        return false;
                    } while (n > 0);
                    break;
                }
                case 59: {
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (blockType != 59);
        return true;
    }

    private boolean checkJpeg() throws IOException {
        byte[] array = new byte[12];
        while (this.read(array, 0, 4) == 4) {
            int marker = Image.getShortBigEndian(array, 0);
            int size = Image.getShortBigEndian(array, 2);
            if ((marker & 0xFF00) != 65280) {
                return false;
            }
            if (marker == 65504) {
                if (size < 14) {
                    this.skip(size - 2);
                    continue;
                }
                if (this.read(array, 0, 12) != 12) {
                    return false;
                }
                byte[] byArray = new byte[5];
                byArray[0] = 74;
                byArray[1] = 70;
                byArray[2] = 73;
                byArray[3] = 70;
                byte[] APP0_ID = byArray;
                if (Image.equals(APP0_ID, 0, array, 0, 5)) {
                    int physicalWidthDpi = Image.getShortBigEndian(array, 8);
                    int physicalHeightDpi = Image.getShortBigEndian(array, 10);
                    if (array[7] == 1) {
                        this.setPhysicalWidthDpi(physicalWidthDpi);
                        this.setPhysicalHeightDpi(physicalHeightDpi);
                    } else if (array[7] == 2) {
                        this.setPhysicalWidthDpi((int)((float)physicalWidthDpi * 2.54f));
                        this.setPhysicalHeightDpi((int)((float)physicalHeightDpi * 2.54f));
                    }
                }
                this.skip(size - 14);
                continue;
            }
            if (marker >= 65472 && marker <= 65487 && marker != 65476 && marker != 65480) {
                if (this.read(array, 0, 6) != 6) {
                    return false;
                }
                this.format = 0;
                this.width = Image.getShortBigEndian(array, 3);
                this.height = Image.getShortBigEndian(array, 1);
                return true;
            }
            this.skip(size - 2);
        }
        return false;
    }

    private boolean checkPng() throws IOException {
        byte[] PNG_MAGIC = new byte[]{78, 71, 13, 10, 26, 10};
        byte[] array = new byte[27];
        if (this.read(array) != array.length || !Image.equals(array, 0, PNG_MAGIC, 0, 6)) {
            return false;
        }
        this.format = 2;
        this.width = Image.getIntBigEndian(array, 14);
        this.height = Image.getIntBigEndian(array, 18);
        return true;
    }

    private static boolean equals(byte[] a1, int offs1, byte[] a2, int offs2, int num) {
        while (num-- > 0) {
            if (a1[offs1++] == a2[offs2++]) continue;
            return false;
        }
        return true;
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        return this.format >= 0 && this.format < FORMAT_NAMES.length ? FORMAT_NAMES[this.format] : "?";
    }

    public int getHeight() {
        return this.height;
    }

    private static int getIntBigEndian(byte[] array, int offset) {
        return (array[offset] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | array[offset + 3] & 0xFF;
    }

    private static int getIntLittleEndian(byte[] array, int offset) {
        return (array[offset + 3] & 0xFF) << 24 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    public String getMimeType() {
        if (this.format >= 0 && this.format < MIME_TYPE_STRINGS.length) {
            return this.format == 0 ? "image/pjpeg" : MIME_TYPE_STRINGS[this.format];
        }
        return null;
    }

    public int getPhysicalHeightDpi() {
        return this.heightDpi;
    }

    public float getPhysicalHeightInch() {
        if (this.height > 0 && this.heightDpi > 0) {
            return (float)this.height / (float)this.heightDpi;
        }
        return -1.0f;
    }

    public int getPhysicalWidthDpi() {
        return this.widthDpi;
    }

    public float getPhysicalWidthInch() {
        if (this.width > 0 && this.widthDpi > 0) {
            return (float)this.width / (float)this.widthDpi;
        }
        return -1.0f;
    }

    private static int getShortBigEndian(byte[] a, int offs) {
        return (a[offs] & 0xFF) << 8 | a[offs + 1] & 0xFF;
    }

    private static int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    public int getWidth() {
        return this.width;
    }

    private int read() throws IOException {
        return this.in != null ? this.in.read() : (int)this.dataIn.readByte();
    }

    private int read(byte[] a) throws IOException {
        if (this.in != null) {
            return this.in.read(a);
        }
        this.dataIn.readFully(a);
        return a.length;
    }

    private int read(byte[] a, int offset, int num) throws IOException {
        if (this.in != null) {
            return this.in.read(a, offset, num);
        }
        this.dataIn.readFully(a, offset, num);
        return num;
    }

    public void setInput(DataInput din) {
        this.dataIn = din;
        this.in = null;
    }

    public void setInput(InputStream in) {
        this.in = in;
        this.dataIn = null;
    }

    private void setPhysicalHeightDpi(int physicalWidthDpi) {
        this.widthDpi = physicalWidthDpi;
    }

    private void setPhysicalWidthDpi(int physicalHeightDpi) {
        this.heightDpi = physicalHeightDpi;
    }

    private void skip(int num) throws IOException {
        while (num > 0) {
            long result;
            long l = result = this.in != null ? this.in.skip(num) : (long)this.dataIn.skipBytes(num);
            if (result > 0L) {
                num = (int)((long)num - result);
                continue;
            }
            result = this.in != null ? this.in.read() : (int)this.dataIn.readByte();
            if (result == -1L) {
                throw new IOException("Premature end of input.");
            }
            --num;
        }
    }
}

