/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.AbstractPropertyCommand;
import org.eclipse.birt.report.model.command.ContentElementCommand;
import org.eclipse.birt.report.model.command.ElementRefRecord;
import org.eclipse.birt.report.model.command.MemberRecord;
import org.eclipse.birt.report.model.command.MoveListItemRecord;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.PropertyListRecord;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.PropertyReplaceRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class ComplexPropertyCommand
extends AbstractPropertyCommand {
    public ComplexPropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    private IStructure addItem(StructureContext context, IStructure item) throws SemanticException {
        assert (context != null);
        this.checkAllowedOperation();
        if (item == null) {
            return null;
        }
        Structure struct = (Structure)item;
        if (struct.getContext() != null) {
            struct = (Structure)struct.copy();
        }
        StructureContextUtil.setupStructureContext(struct);
        ElementPropertyDefn propDefn = context.getElementProp();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (struct.isReferencable()) assert (!((ReferencableStructure)struct).hasReferences());
        this.checkListMemberRef(context);
        this.checkItem(context, struct);
        ArrayList list = context.getList(this.module);
        PropertyDefn memberDefn = context.getPropDefn();
        if (memberDefn != null) {
            this.element.checkStructureList(this.module, memberDefn, list, struct);
        } else {
            this.element.checkStructureList(this.module, propDefn, list, struct);
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddItem"));
        context = this.makeLocalCompositeValue(context);
        list = context.getList(this.module);
        if (list == null) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, context, list);
            stack.execute(memberRecord);
        }
        PropertyListRecord record = this.constructStructureRecord(context, struct, list.size());
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        stack.commit();
        return struct;
    }

    public Object addItem(StructureContext context, Object item) throws SemanticException {
        ElementRefValue refValue;
        SimpleRecord record;
        if (item instanceof IStructure) {
            return this.addItem(context, (IStructure)item);
        }
        assert (context != null);
        this.checkAllowedOperation();
        PropertyDefn memberDefn = context.getPropDefn();
        if (item == null && memberDefn.getTypeCode() == 16) {
            return null;
        }
        assert (!(item instanceof IStructure));
        PropertyDefn prop = context.getElementProp();
        this.assertExtendedElement(this.module, this.element, prop);
        if (memberDefn != null) {
            prop = memberDefn;
        }
        this.checkListProperty(prop);
        Object value = this.checkItem(prop, item);
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.addItem(context, value);
            return value;
        }
        ArrayList list = context.getList(this.module);
        if (prop.getTypeCode() == 20) {
            this.element.checkSimpleList(this.module, prop, list, value);
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddItem"));
        context = this.makeLocalCompositeValue(context);
        list = context.getList(this.module);
        if (list == null) {
            list = new ArrayList();
            if (context.getValueContainer() instanceof DesignElement) {
                record = new PropertyRecord(this.element, context.getElementProp(), list);
                stack.execute(record);
            } else {
                MemberRecord memberRecord = new MemberRecord(this.module, this.element, context, list);
                stack.execute(memberRecord);
            }
        }
        record = new PropertyListRecord(this.element, context.getElementProp(), list, value, list.size());
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), prop.getName(), true);
            stack.execute(refRecord);
        }
        stack.commit();
        return value;
    }

    public IStructure insertItem(StructureContext context, IStructure item, int posn) throws SemanticException {
        assert (context != null);
        this.checkAllowedOperation();
        if (item == null) {
            return null;
        }
        Structure struct = (Structure)item;
        if (struct.getContext() != null) {
            struct = (Structure)struct.copy();
        }
        ElementPropertyDefn propDefn = context.getElementProp();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(context);
        this.checkItem(context, struct);
        ArrayList list = context.getList(this.module);
        this.element.checkStructureList(this.module, context.getPropDefn(), list, struct);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.InsertItem"));
        context = this.makeLocalCompositeValue(context);
        list = context.getList(this.module);
        if (list == null) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, context, list);
            stack.execute(memberRecord);
        }
        if (posn < 0 || posn > list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        PropertyListRecord record = this.constructStructureRecord(context, struct, posn);
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        stack.commit();
        return struct;
    }

    public void removeItem(StructureContext context, int posn) throws SemanticException {
        assert (context != null);
        PropertyDefn propDefn = context.getElementProp();
        this.checkAllowedOperation();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        PropertyDefn memberDefn = context.getPropDefn();
        List list = null;
        if (memberDefn != null) {
            propDefn = memberDefn;
        }
        if (propDefn.getTypeCode() == 20) {
            list = context.getList(this.module);
        } else {
            this.checkListMemberRef(context);
            list = context.getList(this.module);
        }
        if (list == null) {
            throw new PropertyValueException(this.element, context.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        if (posn < 0 || posn >= list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.removeItem(context, posn);
            return;
        }
        this.doRemoveItem(context, posn);
    }

    public void removeItem(StructureContext context, IStructure structure) throws PropertyValueException {
        this.checkAllowedOperation();
        ElementPropertyDefn propDefn = context.getElementProp();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(context);
        List list = context.getList(this.module);
        if (list == null) {
            throw new PropertyValueException(this.element, context.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        int posn = this.getIndex(structure, list);
        if (posn == -1) {
            throw new PropertyValueException(this.element, context.getPropDefn().getName(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        this.doRemoveItem(context, posn);
    }

    private int getIndex(IStructure structure, List list) {
        int posn = -1;
        int index = -1;
        for (Object item : list) {
            ++index;
            if (!(item instanceof IStructure) || item != structure) continue;
            posn = index;
        }
        if (posn == -1) {
            posn = list.indexOf(structure);
        }
        return posn;
    }

    private void doRemoveItem(StructureContext memberContext, int posn) {
        ElementRefValue refValue;
        String label = CommandLabelFactory.getCommandLabel("Message.RemoveItem");
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(label);
        memberContext = this.makeLocalCompositeValue(memberContext);
        List list = memberContext.getList(this.module);
        assert (list != null);
        Structure struct = memberContext.getStructureAt(this.module, posn);
        if (struct != null) {
            if (struct.isReferencable()) {
                this.adjustReferenceClients((ReferencableStructure)struct);
            }
            this.adjustReferenceClients(struct, memberContext);
        }
        Object item = list.get(posn);
        PropertyListRecord record = null;
        record = struct != null ? new PropertyListRecord(this.element, struct.getContext(), posn) : new PropertyListRecord(this.element, memberContext.getElementProp(), list, posn);
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        if (item instanceof ElementRefValue && (refValue = (ElementRefValue)item).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), memberContext.getPropDefn().getName(), false);
            stack.execute(refRecord);
        }
        stack.commit();
    }

    public void replaceItem(StructureContext context, IStructure oldItem, IStructure newItem) throws SemanticException {
        assert (context != null);
        this.checkAllowedOperation();
        ElementPropertyDefn propDefn = context.getElementProp();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(context);
        List list = context.getList(this.module);
        if (list == null) {
            throw new PropertyValueException(this.element, context.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        Structure struct = (Structure)newItem;
        if (newItem != null) {
            if (struct.getContext() != null) {
                struct = (Structure)struct.copy();
            }
            this.checkItem(context, struct);
            this.element.checkStructureList(this.module, context.getPropDefn(), list, struct);
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ReplaceItem"));
        context = this.makeLocalCompositeValue(context);
        list = context.getList(this.module);
        assert (list != null);
        int index = this.getIndex(oldItem, list);
        if (index == -1) {
            throw new PropertyValueException(this.element, context.getPropDefn().getName(), (Object)oldItem, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        PropertyReplaceRecord record = new PropertyReplaceRecord(this.element, context, list, index, struct);
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        if (oldItem.isReferencable()) {
            this.adjustReferenceClients((ReferencableStructure)oldItem);
        }
        stack.commit();
    }

    public void removeAllItems(StructureContext context) throws SemanticException {
        this.checkAllowedOperation();
        this.checkListMemberRef(context);
        ElementPropertyDefn propDefn = context.getElementProp();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (context.getValueContainer() instanceof DesignElement) {
            PropertyCommand cmd = new PropertyCommand(this.module, this.element);
            cmd.setProperty(context.getElementProp(), null);
        } else {
            PropertyCommand cmd = new PropertyCommand(this.module, this.element);
            cmd.setMember(context, null);
        }
    }

    public void moveItem(StructureContext context, int oldPosn, int newPosn) throws PropertyValueException {
        assert (context != null);
        this.checkAllowedOperation();
        ElementPropertyDefn propDefn = context.getElementProp();
        assert (propDefn != null);
        this.checkListMemberRef(context);
        List list = context.getList(this.module);
        if (list == null) {
            throw new PropertyValueException(this.element, context.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.MoveItem");
        int adjustedNewPosn = ComplexPropertyCommand.checkAndAdjustPosition(oldPosn, newPosn, list.size());
        if (oldPosn == adjustedNewPosn) {
            return;
        }
        stack.startTrans(label);
        context = this.makeLocalCompositeValue(context);
        list = context.getList(this.module);
        assert (list != null);
        MoveListItemRecord record = new MoveListItemRecord(this.element, context, oldPosn, adjustedNewPosn);
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        stack.commit();
    }

    private void checkListProperty(PropertyDefn prop) throws PropertyValueException {
        if (prop.getTypeCode() != 20) {
            throw new PropertyValueException(this.element, prop, null, "Error.PropertyValueException.NOT_LIST_TYPE");
        }
    }

    protected void checkListMemberRef(StructureContext context) throws PropertyValueException {
        if (!context.isListRef()) {
            throw new PropertyValueException(this.element, context.getPropDefn(), null, "Error.PropertyValueException.NOT_LIST_TYPE");
        }
    }

    private void checkAllowedOperation() {
        if (this.element instanceof CssStyle) {
            throw new IllegalOperationException("Error.CssException.READONLY");
        }
    }

    private PropertyListRecord constructStructureRecord(StructureContext context, Structure struct, int posn) {
        Structure parentStruct = context.getStructure();
        PropertyDefn tmpPropDefn = context.getPropDefn();
        if (tmpPropDefn == null) {
            tmpPropDefn = context.getElementProp();
        }
        StructureContext tmpContext = null;
        tmpContext = parentStruct == null ? new StructureContext(this.element, (ElementPropertyDefn)tmpPropDefn, null) : new StructureContext(parentStruct, tmpPropDefn, null);
        PropertyListRecord record = new PropertyListRecord(this.element, tmpContext, struct, posn);
        return record;
    }
}

