/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IPreloadedResultIterator;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;

public class DataIterator
implements IDataIterator {
    protected static Logger logger = Logger.getLogger(DataIterator.class.getName());
    protected IExtractionResults results;
    protected IResultIterator iterator;
    protected int startRow = -1;
    protected int maxRows;
    protected int rowCount;
    private boolean beforeFirstRow = true;
    private boolean invalidStartRow = false;

    DataIterator(IExtractionResults results, IResultIterator iterator, int startRow, int maxRows) throws BirtException {
        this.results = results;
        this.iterator = iterator;
        this.startRow = startRow;
        this.maxRows = maxRows;
        this.rowCount = 0;
        this.beforeFirstRow = true;
        if (iterator instanceof IPreloadedResultIterator) {
            ((IPreloadedResultIterator)iterator).setMaxRows(maxRows);
            ((IPreloadedResultIterator)iterator).setStartingRow(startRow);
        }
        if (startRow > 0) {
            try {
                iterator.moveTo(startRow - 1);
            }
            catch (BirtException e) {
                logger.log(Level.WARNING, "The specified startRow value is out of range of the result set!", e);
                this.invalidStartRow = true;
            }
        }
    }

    @Override
    public IExtractionResults getQueryResults() {
        return this.results;
    }

    @Override
    public IResultMetaData getResultMetaData() throws BirtException {
        return this.results.getResultMetaData();
    }

    @Override
    public boolean next() throws BirtException {
        if (this.beforeFirstRow) {
            this.beforeFirstRow = false;
        }
        ++this.rowCount;
        if (this.invalidStartRow || this.maxRows >= 0 && this.rowCount > this.maxRows) {
            return false;
        }
        return this.iterator.next();
    }

    @Override
    public Object getValue(String columnName) throws BirtException {
        if (this.beforeFirstRow) {
            throw new EngineException("Error.ResultsetIteratorError");
        }
        return this.iterator.getValue(columnName);
    }

    @Override
    public Object getValue(int index) throws BirtException {
        if (this.beforeFirstRow) {
            throw new EngineException("Error.ResultsetIteratorError");
        }
        IResultMetaData metaData = this.getResultMetaData();
        String columnName = metaData.getColumnName(index);
        return this.iterator.getValue(columnName);
    }

    @Override
    public void close() {
        try {
            this.iterator.close();
        }
        catch (BirtException birtException) {
            // empty catch block
        }
    }

    @Override
    public boolean isEmpty() throws BirtException {
        return this.iterator.isEmpty();
    }

    @Override
    public IResultIterator getResultIterator() {
        return this.iterator;
    }
}

