/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.model.attribute.Bounds;

public class Rectangle {
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public double x;
    public double y;
    public double width;
    public double height;

    public Rectangle() {
    }

    public Rectangle(BoundingBox bb) {
        this.x = bb.getLeft();
        this.y = bb.getTop();
        this.height = bb.getHeight();
        this.width = bb.getWidth();
    }

    public Bounds getBounds() {
        return goFactory.createBounds(this.x, this.y, this.width, this.height);
    }

    public Rectangle(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public void setRect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void setRect(Rectangle r) {
        this.x = r.getX();
        this.y = r.getY();
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    public int outcode(double x, double y) {
        int out = 0;
        if (this.width <= 0.0) {
            out |= 5;
        } else if (x < this.x) {
            out |= 1;
        } else if (x > this.x + this.width) {
            out |= 4;
        }
        if (this.height <= 0.0) {
            out |= 0xA;
        } else if (y < this.y) {
            out |= 2;
        } else if (y > this.y + this.height) {
            out |= 8;
        }
        return out;
    }

    public Rectangle getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle createIntersection(Rectangle r) {
        Rectangle dest = new Rectangle();
        Rectangle.intersect(this, r, dest);
        return dest;
    }

    private static void intersect(Rectangle rectangle, Rectangle r, Rectangle dest) {
    }

    public Rectangle createUnion(Rectangle r) {
        Rectangle dest = new Rectangle();
        Rectangle.union(this, r, dest);
        return dest;
    }

    private static void union(Rectangle rectangle, Rectangle r, Rectangle dest) {
        double right = Math.max(rectangle.x + rectangle.width, r.x + r.width);
        double bottom = Math.max(rectangle.y + rectangle.height, r.y + r.height);
        dest.x = Math.min(rectangle.x, r.x);
        dest.y = Math.min(rectangle.y, r.y);
        dest.width = right - dest.x;
        dest.height = bottom - dest.y;
    }

    public static Rectangle union(Rectangle rect1, Rectangle rect2) {
        Rectangle rect = null;
        if (rect1 != null || rect2 != null) {
            rect = new Rectangle();
            if (rect1 != null) {
                rect.setRect(rect1);
                rect.union(rect2);
            } else {
                rect.setRect(rect2);
            }
        }
        return rect;
    }

    public void union(Rectangle rect) {
        if (rect != null) {
            Rectangle.union(this, rect, this);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
    }

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public boolean contains(Point lo) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        double x = this.getMinX();
        double y = this.getMinY();
        if (lo.getX() < x || lo.getY() < y) {
            return false;
        }
        return ((w += x) < x || w > lo.getX()) && ((h += y) < y || h > lo.getY());
    }
}

