/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.eclipse.birt.chart.device.DeviceAdapter;
import org.eclipse.birt.chart.device.FontUtil;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.ITextRenderer;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.ClipRenderEvent;
import org.eclipse.birt.chart.event.ImageRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.ImageSourceType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.PatternImage;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.InteractiveRenderer;
import org.eclipse.birt.chart.util.PatternImageUtil;
import org.eclipse.birt.chart.util.SecurityUtil;

public class G2dRendererBase
extends DeviceAdapter {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/g2d");
    protected IDisplayServer _ids;
    protected Graphics2D _g2d;
    protected InteractiveRenderer iv;
    protected ITextRenderer _tr = null;
    private final Map<LineAttributes, Stroke> _htLineStyles = new HashMap<LineAttributes, Stroke>();
    private static Set<String> sLocalFontFamilyNamesSet = new HashSet<String>();
    private static Map<String, String> sLogicFontNameMap;

    static {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        sLocalFontFamilyNamesSet = new HashSet<String>(Arrays.asList(fonts));
        sLogicFontNameMap = new HashMap<String, String>();
        sLogicFontNameMap.put("serif", "Serif");
        sLogicFontNameMap.put("sans-serif", "SansSerif");
        sLogicFontNameMap.put("monospace", "Monospaced");
    }

    protected static final Bounds normalizeBounds(Bounds bo) {
        if (bo.getHeight() < 0.0) {
            bo.setTop(bo.getTop() + bo.getHeight());
            bo.setHeight(-bo.getHeight());
        }
        if (bo.getWidth() < 0.0) {
            bo.setLeft(bo.getLeft() + bo.getWidth());
            bo.setWidth(-bo.getWidth());
        }
        return bo;
    }

    public static final int[][] getCoordinatesAsInts(Location[] la) {
        int n = la.length;
        int[] iaX = new int[n];
        int[] iaY = new int[n];
        int i = 0;
        while (i < n) {
            iaX[i] = (int)la[i].getX();
            iaY[i] = (int)la[i].getY();
            ++i;
        }
        return new int[][]{iaX, iaY};
    }

    public static final double[][] getCoordinates(Location[] la) {
        int n = la.length;
        double[] iaX = new double[n];
        double[] iaY = new double[n];
        int i = 0;
        while (i < n) {
            iaX[i] = la[i].getX();
            iaY[i] = la[i].getY();
            ++i;
        }
        return new double[][]{iaX, iaY};
    }

    public static Shape getPolygon2D(Location[] loa) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(loa[0].getX(), loa[0].getY());
        int i = 1;
        while (i < loa.length) {
            ((Path2D)path).lineTo(loa[i].getX(), loa[i].getY());
            ++i;
        }
        path.closePath();
        return path;
    }

    protected Shape getPolygon(Location[] loa) {
        int[][] i2a = G2dRendererBase.getCoordinatesAsInts(loa);
        return new Polygon(i2a[0], i2a[1], loa.length);
    }

    protected static final int toG2dArcType(int iArcStyle) {
        switch (iArcStyle) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public final Stroke getCachedStroke(LineAttributes lia) {
        if (lia == null) {
            return null;
        }
        Stroke s = this._htLineStyles.get(lia);
        if (s == null) {
            BasicStroke bs = null;
            int thickness = lia.getThickness();
            if (thickness == 0) {
                thickness = 1;
            }
            if (lia.getStyle().getValue() == 1) {
                float[] faStyle = new float[]{6 * thickness, 4 * thickness};
                bs = new BasicStroke(lia.getThickness(), 1, 1, 0.0f, faStyle, 0.0f);
            } else if (lia.getStyle().getValue() == 2) {
                float[] faStyle = new float[]{thickness, 4 * thickness};
                bs = new BasicStroke(lia.getThickness(), 1, 1, 0.0f, faStyle, 0.0f);
            } else if (lia.getStyle().getValue() == 3) {
                float[] faStyle = new float[]{6 * thickness, 4 * thickness, thickness, 4 * thickness};
                bs = new BasicStroke(lia.getThickness(), 1, 1, 0.0f, faStyle, 0.0f);
            } else if (lia.getStyle().getValue() == 0) {
                bs = new BasicStroke(lia.getThickness(), 2, 1);
            }
            if (bs != null) {
                this._htLineStyles.put(lia, bs);
            }
            return bs;
        }
        return s;
    }

    protected String convertFont(String fontFamily) {
        String localFont = sLogicFontNameMap.get(fontFamily);
        if (localFont == null) {
            localFont = fontFamily;
        }
        if (sLocalFontFamilyNamesSet.contains(localFont)) {
            return localFont.toLowerCase();
        }
        return FontUtil.getFontFamily((String)fontFamily);
    }

    protected void prepareGraphicsContext() {
        this._g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this._g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.getDisplayServer().setGraphicsContext((Object)this._g2d);
    }

    public void setProperty(String sProperty, Object oValue) {
        if (sProperty.equals("device.output.context")) {
            this._g2d = (Graphics2D)oValue;
            this.prepareGraphicsContext();
        } else if (sProperty.equals("device.resolution")) {
            this.getDisplayServer().setDpiResolution(((Integer)oValue).intValue());
        }
    }

    public Object getGraphicsContext() {
        return this._g2d;
    }

    public IDisplayServer getDisplayServer() {
        return this._ids;
    }

    public void setClip(ClipRenderEvent cre) {
        Location[] loa = cre.getVertices();
        if (loa == null) {
            this._g2d.setClip(null);
        } else {
            this._g2d.setClip(this.getPolygon(loa));
        }
    }

    public void drawImage(ImageRenderEvent ire) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)ire);
        }
        if (ire.getImage() == null || ire.getLocation() == null) {
            return;
        }
        java.awt.Image img = null;
        if (ire.getImage() instanceof EmbeddedImage) {
            try {
                byte[] data = Base64.getDecoder().decode(((EmbeddedImage)ire.getImage()).getData().getBytes());
                img = this.createImage(data);
            }
            catch (Exception ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
        }
        if (ire.getImage().getSource() != ImageSourceType.FILE && ire.getImage().getSource() != ImageSourceType.REPORT) {
            try {
                String sUrl = ire.getImage().getURL();
                img = (java.awt.Image)this._ids.loadImage(SecurityUtil.newURL((String)sUrl));
            }
            catch (ChartException ilex) {
                logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex)));
            }
            catch (MalformedURLException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)muex);
            }
        }
        if (img == null) {
            return;
        }
        Location loc = ire.getLocation();
        Position pos = ire.getPosition();
        if (pos == null) {
            pos = Position.INSIDE_LITERAL;
        }
        ImageObserver io = (ImageObserver)this._ids.getObserver();
        boolean bSizeSet = ire.getWidth() * ire.getHeight() > 0;
        int width = bSizeSet ? ire.getWidth() : img.getWidth(io);
        int height = bSizeSet ? ire.getHeight() : img.getHeight(io);
        int x = (int)loc.getX();
        int y = (int)loc.getY();
        switch (pos.getValue()) {
            case 4: 
            case 5: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 2: {
                x -= width;
                y -= height / 2;
                break;
            }
            case 3: {
                y -= height / 2;
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        this._g2d.drawImage(img, x, y, width, height, io);
    }

    public void drawLine(LineRenderEvent lre) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)lre);
        }
        LineAttributes lia = lre.getLineAttributes();
        if (!this.validateLineAttributes(lre.getSource(), lia) || lia.getColor() == null || lia.getColor().isSetTransparency() && lia.getColor().getTransparency() == 0) {
            return;
        }
        Location loStart = lre.getStart();
        Location loEnd = lre.getEnd();
        if (!this.checkValidLocation(loStart) || !this.checkValidLocation(loEnd)) {
            return;
        }
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor((Color)this._ids.getColor(lia.getColor()));
        this._g2d.draw(new Line2D.Double(loStart.getX(), loStart.getY(), loEnd.getX(), loEnd.getY()));
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    protected boolean checkValidLocation(Location lo) {
        return lo.getX() < 2.147483647E9 && lo.getX() > -2.147483648E9 && lo.getY() < 2.147483647E9 && lo.getY() > -2.147483648E9;
    }

    public void drawRectangle(RectangleRenderEvent rre) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)rre);
        }
        LineAttributes lia = rre.getOutline();
        if (!this.validateLineAttributes(rre.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), rre.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Bounds bo = G2dRendererBase.normalizeBounds(rre.getBounds());
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(new Rectangle2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth() - 1.0, bo.getHeight() - 1.0));
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillRectangle(RectangleRenderEvent rre) throws ChartException {
        Fill flBackground;
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)rre);
        }
        if (this.isFullTransparent(flBackground = this.validateMultipleFill(rre.getBackground()))) {
            return;
        }
        Bounds bo = G2dRendererBase.normalizeBounds(rre.getBounds());
        Rectangle2D.Double r2d = new Rectangle2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)flBackground;
            this._g2d.setColor((Color)this._ids.getColor(cd));
            this._g2d.fill(r2d);
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            this._g2d.fill(r2d);
        } else if (flBackground instanceof Image) {
            if (flBackground instanceof PatternImage) {
                this.fillWithPatternImage(new Area(r2d), flBackground);
                return;
            }
            java.awt.Image img = this.createImageFromModel(flBackground);
            if (img != null) {
                Shape shClip = this._g2d.getClip();
                Area ar2 = new Area(r2d);
                if (shClip != null) {
                    Area ar1 = new Area(shClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                img = this.scaleImage(img);
                Size szImage = this._ids.getSize((Object)img);
                int iXRepeat = (int)Math.ceil(r2d.width / szImage.getWidth());
                int iYRepeat = (int)Math.ceil(r2d.height / szImage.getHeight());
                ImageObserver io = (ImageObserver)this._ids.getObserver();
                int i = 0;
                while (i < iXRepeat) {
                    int j = 0;
                    while (j < iYRepeat) {
                        this._g2d.drawImage(img, (int)(r2d.x + (double)i * szImage.getWidth()), (int)(r2d.y + (double)j * szImage.getHeight()), io);
                        ++j;
                    }
                    ++i;
                }
                this._g2d.setClip(shClip);
            }
        }
    }

    public void drawPolygon(PolygonRenderEvent pre) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)pre);
        }
        LineAttributes lia = pre.getOutline();
        if (!this.validateLineAttributes(pre.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), pre.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Location[] la = pre.getPoints();
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(this.getPolygon(la));
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillPolygon(PolygonRenderEvent pre) throws ChartException {
        Fill flBackground;
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)pre);
        }
        if (this.isFullTransparent(flBackground = this.validateMultipleFill(pre.getBackground()))) {
            return;
        }
        Location[] loa = pre.getPoints();
        int[][] i2a = G2dRendererBase.getCoordinatesAsInts(loa);
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)flBackground;
            this._g2d.setColor((Color)this._ids.getColor(cd));
            this._g2d.fill(this.getPolygon(loa));
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            double dMinX = BaseRenderer.getX((Location[])loa, (int)2);
            double dMaxX = BaseRenderer.getX((Location[])loa, (int)1);
            double dMinY = BaseRenderer.getY((Location[])loa, (int)2);
            double dMaxY = BaseRenderer.getY((Location[])loa, (int)1);
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(dMinX, dMaxY);
                p2dEnd = new Point2D.Double(dMinX, dMinY);
            } else if (dAngleInDegrees == -90.0) {
                p2dStart = new Point2D.Double(dMinX, dMinY);
                p2dEnd = new Point2D.Double(dMinX, dMaxY);
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(dMinX, dMaxY);
                p2dEnd = new Point2D.Double(dMaxX, dMaxY - (dMaxX - dMinX) * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(dMinX, dMinY);
                p2dEnd = new Point2D.Double(dMaxX, dMinY + (dMaxX - dMinX) * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(dMinX, dMinY);
                p2dEnd = new Point2D.Double(dMaxX, dMinY);
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            this._g2d.fill(this.getPolygon(loa));
        } else if (flBackground instanceof Image) {
            Area ar2 = new Area(new Polygon(i2a[0], i2a[1], loa.length));
            if (flBackground instanceof PatternImage) {
                this.fillWithPatternImage(ar2, flBackground);
                return;
            }
            java.awt.Image img = this.createImageFromModel(flBackground);
            if (img != null) {
                Shape shClip = this._g2d.getClip();
                if (shClip != null) {
                    Area ar1 = new Area(shClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                double dMinX = BaseRenderer.getX((Location[])loa, (int)2);
                double dMaxX = BaseRenderer.getX((Location[])loa, (int)1);
                double dMinY = BaseRenderer.getY((Location[])loa, (int)2);
                double dMaxY = BaseRenderer.getY((Location[])loa, (int)1);
                Size szImage = this._ids.getSize((Object)img);
                int iXRepeat = (int)Math.ceil((dMaxX - dMinX) / szImage.getWidth());
                int iYRepeat = (int)Math.ceil((dMaxY - dMinY) / szImage.getHeight());
                ImageObserver io = (ImageObserver)this._ids.getObserver();
                int i = 0;
                while (i < iXRepeat) {
                    int j = 0;
                    while (j < iYRepeat) {
                        this._g2d.drawImage(img, (int)(dMinX + (double)i * szImage.getWidth()), (int)(dMinY + (double)j * szImage.getHeight()), io);
                        ++j;
                    }
                    ++i;
                }
                this._g2d.setClip(shClip);
            }
        }
    }

    public void drawArc(ArcRenderEvent are) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)are);
        }
        LineAttributes lia = are.getOutline();
        if (!this.validateLineAttributes(are.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), are.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius() || are.getInnerRadius() > 0.0 && are.getOuterRadius() <= 0.0) {
            Bounds rctOuter = this.getOuterRectangle(are);
            Bounds rctInner = this.getInnerRectangle(are);
            Arc2D.Double outerArc = new Arc2D.Double(rctOuter.getLeft(), rctOuter.getTop(), rctOuter.getWidth(), rctOuter.getHeight(), are.getStartAngle(), are.getAngleExtent(), 0);
            Arc2D.Double innerArc = new Arc2D.Double(rctInner.getLeft(), rctInner.getTop(), rctInner.getWidth(), rctInner.getHeight(), are.getStartAngle() + are.getAngleExtent(), -are.getAngleExtent(), 0);
            double startAngle = Math.toRadians(-are.getStartAngle());
            double stopAngle = Math.toRadians(-are.getStartAngle() - are.getAngleExtent());
            double xsOuter = rctOuter.getLeft() + (Math.cos(startAngle) * 0.5 + 0.5) * rctOuter.getWidth();
            double ysOuter = rctOuter.getTop() + (Math.sin(startAngle) * 0.5 + 0.5) * rctOuter.getHeight();
            double xeInner = rctInner.getLeft() + (Math.cos(stopAngle) * 0.5 + 0.5) * rctInner.getWidth();
            double yeInner = rctInner.getTop() + (Math.sin(stopAngle) * 0.5 + 0.5) * rctInner.getHeight();
            GeneralPath gp = new GeneralPath();
            gp.append(outerArc, false);
            gp.lineTo((float)xeInner, (float)yeInner);
            gp.append(innerArc, false);
            gp.lineTo((float)xsOuter, (float)ysOuter);
            Area area = new Area(gp);
            Shape prevClip = this._g2d.getClip();
            Area ar2 = new Area(area);
            if (prevClip != null) {
                Area ar1 = new Area(prevClip);
                ar2.intersect(ar1);
            }
            this._g2d.setClip(ar2);
            this._g2d.draw(area);
            this._g2d.setClip(prevClip);
        } else {
            this._g2d.draw(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), G2dRendererBase.toG2dArcType(are.getStyle())));
        }
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    protected Bounds getOuterRectangle(ArcRenderEvent are) {
        Bounds rctOuter;
        if (are.getOuterRadius() > 0.0) {
            double radio = are.getHeight() / are.getWidth();
            rctOuter = BoundsImpl.create((double)(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getOuterRadius()) / 2.0), (double)(are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getOuterRadius() * radio) / 2.0), (double)(2.0 * are.getOuterRadius()), (double)(2.0 * are.getOuterRadius() * radio));
        } else {
            rctOuter = BoundsImpl.create((double)are.getTopLeft().getX(), (double)are.getTopLeft().getY(), (double)are.getWidth(), (double)are.getHeight());
        }
        return rctOuter;
    }

    protected Bounds getInnerRectangle(ArcRenderEvent are) {
        Bounds rctInner;
        if (are.getInnerRadius() > 0.0) {
            double radio = are.getHeight() / are.getWidth();
            rctInner = BoundsImpl.create((double)(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0), (double)(are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius() * radio) / 2.0), (double)(2.0 * are.getInnerRadius()), (double)(2.0 * are.getInnerRadius() * radio));
        } else {
            rctInner = BoundsImpl.create((double)(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0), (double)(are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius()) / 2.0), (double)(2.0 * are.getInnerRadius()), (double)(2.0 * are.getInnerRadius()));
        }
        return rctInner;
    }

    public void fillArc(ArcRenderEvent are) throws ChartException {
        Fill flBackground;
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)are);
        }
        if (this.isFullTransparent(flBackground = this.validateMultipleFill(are.getBackground()))) {
            return;
        }
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cl = (ColorDefinition)flBackground;
            Color clrPrevious = this._g2d.getColor();
            Color currentColor = (Color)this._ids.getColor(cl);
            this._g2d.setColor(currentColor);
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius() || are.getInnerRadius() > 0.0 && are.getOuterRadius() <= 0.0) {
                Bounds rctOuter = this.getOuterRectangle(are);
                Bounds rctInner = this.getInnerRectangle(are);
                Arc2D.Double outerArc = new Arc2D.Double(rctOuter.getLeft(), rctOuter.getTop(), rctOuter.getWidth(), rctOuter.getHeight(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(rctInner.getLeft(), rctInner.getTop(), rctInner.getWidth(), rctInner.getHeight(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                Shape prevClip = this._g2d.getClip();
                Area ar2 = new Area(fArea);
                if (prevClip != null) {
                    Area ar1 = new Area(prevClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                this._g2d.fill(fArea);
                this._g2d.setClip(prevClip);
            } else {
                this._g2d.fill(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), G2dRendererBase.toG2dArcType(are.getStyle())));
            }
            this._g2d.setColor(clrPrevious);
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            Bounds bo = are.getBounds();
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            Paint pPrevious = this._g2d.getPaint();
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius() || are.getInnerRadius() > 0.0 && are.getOuterRadius() <= 0.0) {
                Bounds rctOuter = this.getOuterRectangle(are);
                Bounds rctInner = this.getInnerRectangle(are);
                Arc2D.Double outerArc = new Arc2D.Double(rctOuter.getLeft(), rctOuter.getTop(), rctOuter.getWidth(), rctOuter.getHeight(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(rctInner.getLeft(), rctInner.getTop(), rctInner.getWidth(), rctInner.getHeight(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                Shape prevClip = this._g2d.getClip();
                Area ar2 = new Area(fArea);
                if (prevClip != null) {
                    Area ar1 = new Area(prevClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                this._g2d.fill(fArea);
                this._g2d.setClip(prevClip);
            } else {
                this._g2d.fill(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), G2dRendererBase.toG2dArcType(are.getStyle())));
            }
            this._g2d.setPaint(pPrevious);
        } else if (flBackground instanceof Image) {
            Bounds bo = are.getBounds();
            Rectangle2D.Double r2d = new Rectangle2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
            Shape shPreviousClip = this._g2d.getClip();
            Area ar = null;
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius() || are.getInnerRadius() > 0.0 && are.getOuterRadius() <= 0.0) {
                Bounds rctOuter = this.getOuterRectangle(are);
                Bounds rctInner = this.getInnerRectangle(are);
                Arc2D.Double outerArc = new Arc2D.Double(rctOuter.getLeft(), rctOuter.getTop(), rctOuter.getWidth(), rctOuter.getHeight(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(rctInner.getLeft(), rctInner.getTop(), rctInner.getWidth(), rctInner.getHeight(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                if (shPreviousClip != null) {
                    Area ar1 = new Area(shPreviousClip);
                    fArea.intersect(ar1);
                }
                ar = fArea;
            } else {
                Arc2D.Double shArc = new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), G2dRendererBase.toG2dArcType(are.getStyle()));
                Area ar2 = new Area(shArc);
                if (shPreviousClip != null) {
                    Area ar1 = new Area(shPreviousClip);
                    ar2.intersect(ar1);
                }
                ar = ar2;
            }
            if (flBackground instanceof PatternImage) {
                this.fillWithPatternImage(new Area(ar), flBackground);
                return;
            }
            this._g2d.setClip(ar);
            java.awt.Image img = this.createImageFromModel(flBackground);
            if (img != null) {
                Size szImage = this._ids.getSize((Object)img);
                int iXRepeat = (int)Math.ceil(r2d.width / szImage.getWidth());
                int iYRepeat = (int)Math.ceil(r2d.height / szImage.getHeight());
                ImageObserver io = (ImageObserver)this._ids.getObserver();
                int i = 0;
                while (i < iXRepeat) {
                    int j = 0;
                    while (j < iYRepeat) {
                        this._g2d.drawImage(img, (int)(r2d.x + (double)i * szImage.getWidth()), (int)(r2d.y + (double)j * szImage.getHeight()), io);
                        ++j;
                    }
                    ++i;
                }
            }
            this._g2d.setClip(shPreviousClip);
        }
    }

    protected java.awt.Image createImage(byte[] data) {
        try {
            return ImageIO.read(new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            logger.log((Exception)e);
            return null;
        }
    }

    protected java.awt.Image createImageFromModel(Fill imageModel) throws ChartException {
        java.awt.Image img = null;
        if (imageModel instanceof EmbeddedImage) {
            try {
                byte[] data = Base64.getDecoder().decode(((EmbeddedImage)imageModel).getData().getBytes());
                img = this.createImage(data);
            }
            catch (Exception ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
        }
        if (imageModel instanceof PatternImage) {
            PatternImage pi = (PatternImage)imageModel;
            byte[] data = PatternImageUtil.createImageData((PatternImage)pi, (PatternImageUtil.ByteColorModel)PatternImageUtil.ByteColorModel.RGBA);
            BufferedImage bimg = new BufferedImage(8, 8, 6);
            img = bimg;
            WritableRaster raster = bimg.getRaster();
            raster.setDataElements(0, 0, 8, 8, data);
            bimg.flush();
        } else if (imageModel instanceof Image && ((Image)imageModel).getSource() == ImageSourceType.STATIC) {
            try {
                String sUrl = ((Image)imageModel).getURL();
                img = (java.awt.Image)this._ids.loadImage(SecurityUtil.newURL((String)sUrl));
            }
            catch (MalformedURLException | ChartException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, muex);
            }
        }
        return img;
    }

    private java.awt.Image scaleImage(java.awt.Image img) {
        if (this._ids.getDpiResolution() == 96) {
            return img;
        }
        double scale = (double)this._ids.getDpiResolution() / 96.0;
        int newWidth = (int)((double)img.getWidth((ImageObserver)this.getDisplayServer().getObserver()) * scale);
        int newHeight = (int)((double)img.getHeight((ImageObserver)this.getDisplayServer().getObserver()) * scale);
        return img.getScaledInstance(newWidth, newHeight, 1);
    }

    protected BufferedImage convertPatternImage(java.awt.Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return null;
    }

    protected void fillWithPatternImage(Shape shape, Fill fill) throws ChartException {
        java.awt.Image img = this.createImageFromModel(fill);
        BufferedImage bimg = this.convertPatternImage(img);
        if (bimg != null) {
            this._g2d.setPaint(new TexturePaint(bimg, new Rectangle(0, 0, bimg.getWidth(), bimg.getHeight())));
            this._g2d.fill(shape);
        }
    }

    public void drawArea(AreaRenderEvent are) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)are);
        }
        LineAttributes lia = are.getOutline();
        if (!this.validateLineAttributes(are.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), are.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < are.getElementCount()) {
            PrimitiveRenderEvent pre = are.getElement(i);
            if (pre instanceof ArcRenderEvent) {
                ArcRenderEvent acre = (ArcRenderEvent)pre;
                Arc2D.Double a2d = new Arc2D.Double(acre.getTopLeft().getX(), acre.getTopLeft().getY(), acre.getWidth(), acre.getHeight(), acre.getStartAngle(), acre.getAngleExtent(), G2dRendererBase.toG2dArcType(acre.getStyle()));
                gp.append(a2d, true);
            } else if (pre instanceof LineRenderEvent) {
                LineRenderEvent lre = (LineRenderEvent)pre;
                Line2D.Double l2d = new Line2D.Double(lre.getStart().getX(), lre.getStart().getY(), lre.getEnd().getX(), lre.getEnd().getY());
                gp.append(l2d, true);
            }
            ++i;
        }
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(gp);
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillArea(AreaRenderEvent are) throws ChartException {
        Fill flBackground;
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)are);
        }
        if (this.isFullTransparent(flBackground = this.validateMultipleFill(are.getBackground()))) {
            return;
        }
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < are.getElementCount()) {
            PrimitiveRenderEvent pre = are.getElement(i);
            if (pre instanceof ArcRenderEvent) {
                ArcRenderEvent acre = (ArcRenderEvent)pre;
                Arc2D.Double a2d = new Arc2D.Double(acre.getTopLeft().getX(), acre.getTopLeft().getY(), acre.getWidth(), acre.getHeight(), acre.getStartAngle(), acre.getAngleExtent(), G2dRendererBase.toG2dArcType(acre.getStyle()));
                gp.append(a2d, true);
            } else if (pre instanceof LineRenderEvent) {
                LineRenderEvent lre = (LineRenderEvent)pre;
                Line2D.Double l2d = new Line2D.Double(lre.getStart().getX(), lre.getStart().getY(), lre.getEnd().getX(), lre.getEnd().getY());
                gp.append(l2d, true);
            }
            ++i;
        }
        if (flBackground instanceof ColorDefinition) {
            this._g2d.setColor((Color)this._ids.getColor((ColorDefinition)flBackground));
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            Bounds bo = are.getBounds();
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
        } else {
            boolean cfr_ignored_0 = flBackground instanceof Image;
        }
        this._g2d.fill(gp);
    }

    public void drawOval(OvalRenderEvent ore) throws ChartException {
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)ore);
        }
        LineAttributes lia = ore.getOutline();
        if (!this.validateLineAttributes(ore.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), ore.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Bounds bo = ore.getBounds();
        Ellipse2D.Double e2d = new Ellipse2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(e2d);
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillOval(OvalRenderEvent ore) throws ChartException {
        Fill flBackground;
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)ore);
        }
        if (this.isFullTransparent(flBackground = this.validateMultipleFill(ore.getBackground()))) {
            return;
        }
        Bounds bo = ore.getBounds();
        Ellipse2D.Double e2d = new Ellipse2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)flBackground;
            this._g2d.setColor((Color)this._ids.getColor(cd));
            this._g2d.fill(e2d);
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            this._g2d.fill(e2d);
        } else if (flBackground instanceof Image) {
            Area ar2 = new Area(e2d);
            if (flBackground instanceof PatternImage) {
                this.fillWithPatternImage(ar2, flBackground);
                return;
            }
            java.awt.Image img = this.createImageFromModel(flBackground);
            if (img != null) {
                Shape shClip = this._g2d.getClip();
                if (shClip != null) {
                    Area ar1 = new Area(shClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                Size szImage = this._ids.getSize((Object)img);
                int iXRepeat = (int)Math.ceil(e2d.width / szImage.getWidth());
                int iYRepeat = (int)Math.ceil(e2d.height / szImage.getHeight());
                ImageObserver io = (ImageObserver)this._ids.getObserver();
                int i = 0;
                while (i < iXRepeat) {
                    int j = 0;
                    while (j < iYRepeat) {
                        this._g2d.drawImage(img, (int)(e2d.x + (double)i * szImage.getWidth()), (int)(e2d.y + (double)j * szImage.getHeight()), io);
                        ++j;
                    }
                    ++i;
                }
                this._g2d.setClip(shClip);
            }
        }
    }

    public void drawText(TextRenderEvent tre) throws ChartException {
        String fontName = this.convertFont(tre.getLabel().getCaption().getFont().getName());
        if (fontName != null) {
            tre.getLabel().getCaption().getFont().setName(fontName);
        }
        if (this.iv != null) {
            this.iv.modifyEvent((PrimitiveRenderEvent)tre);
        }
        if (!tre.getLabel().isVisible()) {
            return;
        }
        switch (tre.getAction()) {
            case 0: {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.missing.text.render.action", Messages.getResourceBundle(this.getULocale()));
            }
            case 1: {
                this._tr.renderShadowAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), tre.getLocation(), tre.getLabel());
                break;
            }
            case 2: {
                this._tr.renderTextAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), tre.getLocation(), tre.getLabel());
                break;
            }
            case 3: {
                this._tr.renderTextInBlock((IDeviceRenderer)this, tre.getBlockBounds(), tre.getBlockAlignment(), tre.getLabel());
            }
        }
    }

    public void applyTransformation(TransformationEvent tev) throws ChartException {
        switch (tev.getTransform()) {
            case 2: {
                this._g2d.translate(tev.getTranslateX(), tev.getTranslateY());
                break;
            }
            case 4: {
                this._g2d.rotate(tev.getRotation() * Math.PI / 180.0);
                break;
            }
            case 1: {
                this._g2d.scale(tev.getScale(), tev.getScale());
            }
        }
    }

    public void dispose() {
        if (this._ids != null) {
            this._ids.dispose();
            this._ids = null;
        }
        if (this._g2d != null) {
            this._g2d.dispose();
            this._g2d = null;
        }
    }
}

