/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.Objects;
import org.eclipse.birt.core.data.IDimLevel;

class DimLevel
implements IDimLevel {
    private String dimensionName;
    private String levelName;
    private String attrName;
    private String qualifiedName;

    public DimLevel(String dimensionName, String levelName) {
        this(dimensionName, levelName, null);
    }

    public DimLevel(String dimensionName, String levelName, String attrName) {
        this.dimensionName = dimensionName;
        this.levelName = levelName;
        this.attrName = attrName;
        this.setQualifiedName();
    }

    private void setQualifiedName() {
        this.qualifiedName = this.getAttrReference(this.dimensionName, this.levelName, this.attrName == null ? this.levelName : this.attrName);
    }

    private String getAttrReference(String dimName, String levelName, String attrName) {
        return dimName + "/" + levelName + "/" + attrName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public String getLevelName() {
        return this.levelName;
    }

    @Override
    public String getAttrName() {
        return this.attrName;
    }

    public int hashCode() {
        return Objects.hash(this.dimensionName, this.levelName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DimLevel)) {
            return false;
        }
        DimLevel other = (DimLevel)obj;
        if (!Objects.equals(this.dimensionName, other.dimensionName)) {
            return false;
        }
        return Objects.equals(this.levelName, other.levelName);
    }

    public String toString() {
        return this.qualifiedName;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof DimLevel)) {
            return -1;
        }
        DimLevel dimLevel = (DimLevel)obj;
        return this.toString().compareTo(dimLevel.toString());
    }
}

