/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.image.ImageDependenciesAnnotationHelper;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.RecordingCommandWithCustomUndo;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;

public class UpdateImageDependenciesPreCommitListener
extends ResourceSetListenerImpl {
    private static final String OWNED_STYLE_FEATURE_NAME = "ownedStyle";
    private final ImageDependenciesAnnotationHelper imageDependenciesAnnotationHelper;
    private Session session;

    public UpdateImageDependenciesPreCommitListener(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.session = dAnalysisSessionImpl;
        this.imageDependenciesAnnotationHelper = new ImageDependenciesAnnotationHelper(dAnalysisSessionImpl);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        if (this.session == null || !this.session.isOpen()) {
            return null;
        }
        final HashMap<DRepresentation, List<String>> diagramToNewImageDependency = new HashMap<DRepresentation, List<String>>();
        final HashMap<DRepresentation, List<String>> diagramToOldImageDependency = new HashMap<DRepresentation, List<String>>();
        List<Notification> notifications = this.filterNotifications(event.getNotifications());
        for (Notification notification : notifications) {
            EObject notifierEObject;
            String workspacePath;
            DRepresentation representation;
            DRepresentationElement dRepElement;
            Object newValue = notification.getNewValue();
            Object oldValue = notification.getOldValue();
            Set<EAttribute> richTextAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
            String featureName = "";
            if (notification.getFeature() instanceof ENamedElement) {
                featureName = ((ENamedElement)notification.getFeature()).getName();
            }
            if (this.imageDependenciesAnnotationHelper.isWorkspaceImageInstance(newValue)) {
                EObject eContainer = ((EObject)newValue).eContainer();
                if (!(eContainer instanceof DRepresentationElement) || !OWNED_STYLE_FEATURE_NAME.equals(featureName)) continue;
                dRepElement = (DRepresentationElement)eContainer;
                representation = SiriusUtil.findRepresentation(dRepElement);
                workspacePath = this.getWorkspacePath((EObject)newValue);
                if (workspacePath == null) continue;
                Optional<String> projectName2 = this.imageDependenciesAnnotationHelper.getProjectFromImagePath(workspacePath);
                if (representation == null || !projectName2.isPresent()) continue;
                this.addElementInMultiMap(diagramToNewImageDependency, representation, projectName2.get());
                continue;
            }
            if (this.imageDependenciesAnnotationHelper.isWorkspaceImageInstance(notification.getNotifier())) {
                String oldWorkspacePath;
                Optional<String> oldProjectName;
                notifierEObject = (EObject)notification.getNotifier();
                if (!(newValue instanceof String) || !(oldValue instanceof String) || !(notifierEObject.eContainer() instanceof DRepresentationElement) || !"workspacePath".equals(featureName)) continue;
                dRepElement = (DRepresentationElement)notifierEObject.eContainer();
                representation = SiriusUtil.findRepresentation(dRepElement);
                workspacePath = (String)newValue;
                Optional<String> newProjectName = this.imageDependenciesAnnotationHelper.getProjectFromImagePath(workspacePath);
                if (representation != null && newProjectName.isPresent()) {
                    this.addElementInMultiMap(diagramToNewImageDependency, representation, newProjectName.get());
                }
                if (newProjectName.equals(oldProjectName = this.imageDependenciesAnnotationHelper.getProjectFromImagePath(oldWorkspacePath = (String)oldValue)) || representation == null || !oldProjectName.isPresent()) continue;
                this.addElementInMultiMap(diagramToOldImageDependency, representation, oldProjectName.get());
                continue;
            }
            if (richTextAttributes.contains(notification.getFeature())) {
                EAttribute attr;
                notifierEObject = (EObject)notification.getNotifier();
                Object value = notifierEObject.eGet((EStructuralFeature)(attr = (EAttribute)notification.getFeature()));
                if (!(value instanceof String)) continue;
                String valueStr = (String)value;
                Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
                Matcher matcher = pattern.matcher(valueStr);
                while (matcher.find()) {
                    String workspacePath2 = matcher.group(1);
                    this.imageDependenciesAnnotationHelper.getProjectFromImagePath(workspacePath2).ifPresent(projectName -> this.addElementInMultiMap((Map<DRepresentation, List<String>>)diagramToNewImageDependency, null, (String)projectName));
                }
                continue;
            }
            if (!this.imageDependenciesAnnotationHelper.isWorkspaceImageInstance(oldValue)) continue;
            notifierEObject = (EObject)notification.getNotifier();
            EObject oldValueEObject = (EObject)oldValue;
            if (!(notifierEObject instanceof DRepresentationElement) || !OWNED_STYLE_FEATURE_NAME.equals(featureName)) continue;
            dRepElement = (DRepresentationElement)notifierEObject;
            DRepresentation representation2 = SiriusUtil.findRepresentation(dRepElement);
            String workspacePath3 = this.getWorkspacePath(oldValueEObject);
            Optional<String> projectName3 = this.imageDependenciesAnnotationHelper.getProjectFromImagePath(workspacePath3);
            if (representation2 == null || projectName3.isEmpty()) continue;
            this.addElementInMultiMap(diagramToOldImageDependency, representation2, projectName3.get());
        }
        RecordingCommandWithCustomUndo recordingCommand = new RecordingCommandWithCustomUndo(this.session.getTransactionalEditingDomain()){

            @Override
            protected void doExecute() {
                if (!diagramToNewImageDependency.isEmpty()) {
                    UpdateImageDependenciesPreCommitListener.this.imageDependenciesAnnotationHelper.addImageDependencyAnnotationDetails(diagramToNewImageDependency);
                }
                if (!diagramToOldImageDependency.isEmpty()) {
                    UpdateImageDependenciesPreCommitListener.this.imageDependenciesAnnotationHelper.removeImageDependencyAnnotationDetails(diagramToOldImageDependency);
                }
            }
        };
        return recordingCommand;
    }

    private List<Notification> filterNotifications(List<Notification> notifications) {
        Set<EAttribute> richTextAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
        List<Notification> filteredNotifications = notifications.stream().filter(notif -> notif.getNotifier() instanceof EObject).filter(notif -> {
            Object feature = notif.getFeature();
            boolean keepNotif = richTextAttributes.contains(feature);
            if (!keepNotif && feature instanceof EStructuralFeature) {
                String featureName = ((ENamedElement)feature).getName();
                keepNotif = OWNED_STYLE_FEATURE_NAME.equals(featureName);
                keepNotif = keepNotif || "workspacePath".equals(featureName);
            }
            return keepNotif;
        }).collect(Collectors.toList());
        if (!filteredNotifications.isEmpty()) {
            filteredNotifications = this.filterNotifRelatedToSessionResource(filteredNotifications);
        }
        return filteredNotifications;
    }

    private List<Notification> filterNotifRelatedToSessionResource(List<Notification> notifications) {
        Collection<Resource> semanticResources = this.session.getSemanticResources();
        EList controlledResources = Collections.emptyList();
        if (this.session instanceof DAnalysisSessionEObject) {
            controlledResources = ((DAnalysisSessionEObject)this.session).getControlledResources();
        }
        Set<Resource> allSessionResources = this.session.getAllSessionResources();
        Collection<Resource> srmResources = this.session.getSrmResources();
        List allResourcesAssociatedToTheSession = Stream.concat(Stream.concat(semanticResources.stream(), controlledResources.stream()), Stream.concat(srmResources.stream(), allSessionResources.stream())).collect(Collectors.toList());
        List<Notification> filteredNotifications = notifications.stream().filter(notification -> {
            Object notifier = notification.getNotifier();
            if (notifier instanceof EObject) {
                Resource eResource = ((EObject)notifier).eResource();
                return allResourcesAssociatedToTheSession.contains(eResource);
            }
            return false;
        }).collect(Collectors.toList());
        return filteredNotifications;
    }

    private String getWorkspacePath(EObject workspaceImage) {
        String workspacePath = "";
        EStructuralFeature eStructuralFeature = workspaceImage.eClass().getEStructuralFeature("workspacePath");
        if (eStructuralFeature != null) {
            workspacePath = (String)workspaceImage.eGet(eStructuralFeature);
        }
        return workspacePath;
    }

    private boolean addElementInMultiMap(Map<DRepresentation, List<String>> repToProjectNames, DRepresentation rep, String projectName) {
        List<String> list = repToProjectNames.get(rep);
        if (list == null) {
            list = new ArrayList<String>();
            repToProjectNames.put(rep, list);
        }
        return list.add(projectName);
    }
}

