/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.STCallableEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.util.STFunctionParseUtil;

public class STFunctionBodyEvaluator
extends STCallableEvaluator {
    private final STFunctionBody body;
    private STFunctionSource parseResult;

    public STFunctionBodyEvaluator(STFunctionBody body, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super((String)(parent != null ? parent.getName() + "." + parent.getName() : "body"), context, variables, parent);
        this.body = body;
    }

    public void prepare() throws EvaluatorException {
        if (this.parseResult == null) {
            ArrayList errors = new ArrayList();
            ArrayList warnings = new ArrayList();
            ArrayList infos = new ArrayList();
            this.parseResult = STFunctionParseUtil.parse((STFunctionBody)this.body, errors, warnings, infos);
            errors.forEach(arg_0 -> ((STFunctionBodyEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((STFunctionBodyEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((STFunctionBodyEvaluator)this).info(arg_0));
            if (this.getSourceElement() == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
            this.prepareCallableVariables((List<? extends STVarDeclarationBlock>)this.getSourceElement().getVarDeclarations(), "", this.getSourceElement().getReturnType());
        }
    }

    public void cleanup() {
        this.parseResult = null;
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        this.prepare();
        this.evaluateStructuredTextFunction(this.getSourceElement());
        this.trap(this.getSourceElement());
        if (this.getReturnVariable() != null) {
            return this.getReturnVariable().getValue();
        }
        return null;
    }

    protected void evaluateStructuredTextFunction(STFunction function) throws EvaluatorException, InterruptedException {
        this.evaluateCallableVariables((List<? extends STVarDeclarationBlock>)function.getVarDeclarations());
        try {
            this.evaluateStatementList((List<STStatement>)function.getCode());
        }
        catch (StructuredTextEvaluator.StructuredTextException structuredTextException) {
            // empty catch block
        }
    }

    protected static boolean isInput(STVarDeclarationBlock block) {
        return block instanceof STVarInputDeclarationBlock || block instanceof STVarInOutDeclarationBlock;
    }

    public STFunction getSourceElement() {
        if (this.parseResult != null && !this.parseResult.getFunctions().isEmpty()) {
            return (STFunction)this.parseResult.getFunctions().getFirst();
        }
        return null;
    }

    public Set<String> getDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return STFunctionParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }
}

