/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyFactory;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.AbstractChangeHierarchyOperation;

public class CreateLevelOperation
extends AbstractChangeHierarchyOperation {
    private final EObject parent;
    private final String name;
    private Level newLevel;

    public CreateLevelOperation(EObject parent, String name) {
        super("Create level");
        this.parent = parent;
        this.name = name;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.newLevel = HierarchyFactory.eINSTANCE.createLevel();
        this.newLevel.setName(this.name);
        this.insertNewLevel();
        CreateLevelOperation.saveHierarchy(this.parent, monitor);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.insertNewLevel();
        CreateLevelOperation.saveHierarchy(this.parent, monitor);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject eObject;
        EObject eObject2 = this.parent;
        if (eObject2 instanceof RootLevel) {
            RootLevel root = (RootLevel)eObject2;
            root.getLevels().remove((Object)this.newLevel);
        }
        if ((eObject = this.parent) instanceof Level) {
            Level level = (Level)eObject;
            level.getChildren().remove((Object)this.newLevel);
        }
        CreateLevelOperation.saveHierarchy(this.parent, monitor);
        return Status.OK_STATUS;
    }

    private void insertNewLevel() {
        EObject eObject;
        EObject eObject2 = this.parent;
        if (eObject2 instanceof RootLevel) {
            RootLevel root = (RootLevel)eObject2;
            root.getLevels().add((Object)this.newLevel);
        }
        if ((eObject = this.parent) instanceof Level) {
            Level level = (Level)eObject;
            level.getChildren().add((Object)this.newLevel);
        }
    }
}

