/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.validation.CancelableDiagnostician;
import org.eclipse.fordiac.ide.gef.validation.GraphicalValidationAnnotation;
import org.eclipse.fordiac.ide.gef.validation.VariableDiagnostician;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class ValidationJob
extends UIJob {
    private static final long DELAY = 500L;
    private final CommandStack commandStack;
    private final GraphicalAnnotationModel annotationModel;
    private final ValidationCommandStackEventListener commandStackEventListener = new ValidationCommandStackEventListener();
    private final BlockingQueue<EObject> queue = new LinkedBlockingQueue<EObject>();
    private boolean enabled = true;

    public ValidationJob(String name, CommandStack commandStack, GraphicalAnnotationModel annotationModel) {
        super(MessageFormat.format(Messages.ValidationJob_ValidationJobName, name));
        this.commandStack = commandStack;
        this.annotationModel = annotationModel;
        this.commandStackEventListener.install(commandStack);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        ArrayList queued = new ArrayList();
        this.queue.drainTo(queued);
        List filtered = EcoreUtil.filterDescendants(queued);
        try {
            VariableDiagnostician diagnostician = new VariableDiagnostician(ValidationJob.monitorFor(monitor));
            List<Diagnostic> diagnostics = filtered.stream().map(arg_0 -> ((CancelableDiagnostician)diagnostician).validate(arg_0)).toList();
            this.updateAnnotations(diagnostics, monitor);
        }
        catch (OperationCanceledException e) {
            this.queue.addAll(filtered);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        IProgressService progressService;
        if (PlatformUI.isWorkbenchRunning() && (progressService = PlatformUI.getWorkbench().getProgressService()) instanceof ProgressProvider) {
            ProgressProvider progressProvider = (ProgressProvider)progressService;
            return progressProvider.monitorFor(monitor);
        }
        return IProgressMonitor.nullSafe((IProgressMonitor)monitor);
    }

    protected void updateAnnotations(List<Diagnostic> diagnostics, IProgressMonitor monitor) {
        Set add = diagnostics.stream().map(Diagnostic::getChildren).flatMap(Collection::stream).map(GraphicalValidationAnnotation::forDiagnostic).flatMap(Optional::stream).collect(Collectors.toSet());
        Set remove = StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllContents(diagnostics.stream().map(FordiacMarkerHelper::getDiagnosticTarget).toList(), (boolean)true), 0), false).map(this.annotationModel::getAnnotations).flatMap(Collection::stream).filter(ValidationJob::isValidationAnnotation).filter(Predicate.not(add::contains)).collect(Collectors.toSet());
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.annotationModel.updateAnnotations(add, remove, Collections.emptySet());
    }

    protected static boolean isValidationAnnotation(GraphicalAnnotation annotation) {
        return "org.eclipse.fordiac.ide.model.ui.annotation.error".equals(annotation.getType()) || "org.eclipse.fordiac.ide.model.ui.annotation.warning".equals(annotation.getType()) || "org.eclipse.fordiac.ide.model.ui.annotation.info".equals(annotation.getType());
    }

    protected void elementsChanged(Collection<? extends EObject> elements) {
        if (this.enabled) {
            this.queue.addAll(elements);
            this.cancel();
            this.schedule(500L);
        }
    }

    protected void handleCommand(Command command) {
        if (command instanceof CompoundCommand) {
            CompoundCommand compoundCommand = (CompoundCommand)command;
            compoundCommand.getCommands().forEach(this::handleCommand);
        } else if (command instanceof ScopedCommand) {
            ScopedCommand scopedCommand = (ScopedCommand)command;
            this.elementsChanged(scopedCommand.getAffectedObjects());
        }
    }

    public void reset() {
        this.cancel();
        this.queue.clear();
        this.annotationModel.removeAnnotationIf(GraphicalValidationAnnotation.class::isInstance);
        this.annotationModel.reload();
    }

    public void dispose() {
        this.commandStackEventListener.uninstall(this.commandStack);
        this.enabled = false;
        this.queue.clear();
        this.cancel();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.reset();
        }
    }

    protected class ValidationCommandStackEventListener
    implements CommandStackEventListener {
        protected ValidationCommandStackEventListener() {
        }

        public void stackChanged(CommandStackEvent event) {
            if (event.isPostChangeEvent()) {
                switch (event.getDetail()) {
                    case 8: 
                    case 16: 
                    case 32: {
                        ValidationJob.this.handleCommand(event.getCommand());
                        break;
                    }
                    case 256: 
                    case 512: {
                        ValidationJob.this.reset();
                        break;
                    }
                }
            }
        }

        public void install(CommandStack commandStack) {
            commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        }

        public void uninstall(CommandStack commandStack) {
            commandStack.removeCommandStackEventListener((CommandStackEventListener)this);
        }
    }
}

