/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.router;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.handles.BendpointCreationHandle;
import org.eclipse.swt.graphics.Color;

public class LineSegmentHandle
extends BendpointCreationHandle {
    public LineSegmentHandle(ConnectionEditPart owner, int index) {
        super(owner, index);
        PointList points = ((Connection)owner.getFigure()).getPoints();
        Point pt1 = points.getPoint(index);
        Point pt2 = points.getPoint(index + 1);
        int handleSize = ((PolylineConnection)owner.getFigure()).getLineWidth() + 2;
        if (Math.abs(pt1.x - pt2.x) < Math.abs(pt1.y - pt2.y)) {
            this.setCursor(Cursors.SIZEWE);
            this.setPreferredSize(handleSize, Math.abs(pt1.y - pt2.y));
        } else {
            this.setCursor(Cursors.SIZENS);
            this.setPreferredSize(Math.abs(pt1.x - pt2.x), handleSize);
        }
    }

    protected Color getFillColor() {
        if (this.getOwner() != null && this.getOwner().getFigure() != null) {
            return this.getOwner().getFigure().getForegroundColor();
        }
        return super.getFillColor();
    }

    public void paintFigure(Graphics g) {
        g.setLineStyle(1);
        g.setLineWidth(2);
        g.setXORMode(false);
        g.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        int radius = 5;
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds()).shrink(1, 1);
        g.drawRoundRectangle(r, 5, 5);
    }
}

