/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fortelauncher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fordiac.ide.fortelauncher.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.widget.DirectoryChooserControl;
import org.eclipse.fordiac.ide.ui.widget.FileChooserControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class BuildForteTab
extends AbstractLaunchConfigurationTab {
    private static final String ATTR_BUILD_ARGUMENTS = "org.eclipse.fordiac.ide.fortebuilder.arguments";
    private FileChooserControl cmakeChooser;
    private DirectoryChooserControl buildLocationChooser;
    private Text argumentsField;

    public void createControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)parent);
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)comp);
        this.setControl((Control)comp);
        this.cmakeChooser = new FileChooserControl(comp, 0, Messages.BuildForteTab_CMakeLocation, true);
        this.cmakeChooser.addChooserValueChangedListener(newVal -> this.scheduleUpdateJob());
        this.buildLocationChooser = new DirectoryChooserControl(comp, 0, Messages.BuildForteTab_BuildDirectory, true);
        this.buildLocationChooser.addChooserValueChangedListener(newVal -> this.scheduleUpdateJob());
        this.createArguments(comp);
    }

    private void createArguments(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FortePreferencePage_Arguments);
        this.argumentsField = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 2).applyTo((Control)this.argumentsField);
        this.argumentsField.addModifyListener(ev -> this.scheduleUpdateJob());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.cmakeChooser.setValue(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", ""));
            this.buildLocationChooser.setValue(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", ""));
            this.argumentsField.setText(configuration.getAttribute(ATTR_BUILD_ARGUMENTS, ""));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", this.cmakeChooser.getValue());
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.buildLocationChooser.getValue());
        configuration.setAttribute(ATTR_BUILD_ARGUMENTS, this.argumentsField.getText());
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "--build . " + this.argumentsField.getText());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.cmakeChooser.getValue().isBlank()) {
            this.setErrorMessage(Messages.ForteLaunchTabError_NoCMakeExecutableSet);
            return false;
        }
        if (this.buildLocationChooser.getValue().isBlank()) {
            this.setErrorMessage(Messages.BuildForteTab_NoBuildDirectory);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.BuildForteTab_TabTitle;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION");
        configuration.removeAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY");
        configuration.removeAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS");
        configuration.removeAttribute(RefreshUtil.ATTR_REFRESH_SCOPE);
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE", "NONE");
        configuration.setAttribute("org.eclipse.debug.core.appendEnvironmentVariables", true);
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        configuration.setAttribute("org.eclipse.debug.core.ATTR_MERGE_OUTPUT", true);
        configuration.removeAttribute(ATTR_BUILD_ARGUMENTS);
    }
}

