/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.RemoveElementsFromGroup;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class AddElementsToSubAppCommand
extends Command
implements ScopedCommand {
    private final SubApp targetSubApp;
    private final List<FBNetworkElement> elementsToAdd = new ArrayList<FBNetworkElement>();
    private final Map<IInterfaceElement, IInterfaceElement> sourceToSubAppPin = new HashMap<IInterfaceElement, IInterfaceElement>();
    private final CompoundCommand unmappingCmds = new CompoundCommand();
    private final List<Connection> movedConns = new ArrayList<Connection>();
    private final CompoundCommand modifiedConns = new CompoundCommand();
    private final CompoundCommand changedSubAppIEs = new CompoundCommand();
    private final CompoundCommand setUniqueName = new CompoundCommand();
    private final CompoundCommand removeFromOtherGroups = new CompoundCommand();
    private final CompoundCommand setPositionCommands = new CompoundCommand();
    private Point moveDelta;

    public AddElementsToSubAppCommand(SubApp targetSubApp, List<?> selection) {
        this.targetSubApp = Objects.requireNonNull(targetSubApp);
        this.fillElementList(selection);
    }

    public AddElementsToSubAppCommand(SubApp targetSubApp, List<?> selection, Point moveDelta) {
        this(targetSubApp, selection);
        this.moveDelta = moveDelta;
    }

    public boolean canExecute() {
        return !this.targetSubApp.isTyped() && this.targetSubApp.getSubAppNetwork() != null && !this.elementsToAdd.isEmpty() && FBNetworkHelper.targetSubappIsInSameFbNetwork(this.elementsToAdd, (SubApp)this.targetSubApp);
    }

    public void execute() {
        this.collectElementsToRemoveFromGroup();
        this.unmappingCmds.execute();
        this.removeFromOtherGroups.execute();
        this.processElementsToAdd();
        this.modifiedConns.execute();
        ElementSelector.selectViewObjects(this.elementsToAdd);
    }

    public void redo() {
        this.unmappingCmds.redo();
        this.removeFromOtherGroups.redo();
        this.elementsToAdd.forEach(element -> AddElementsToSubAppCommand.addToNetwork((EList<FBNetworkElement>)this.targetSubApp.getSubAppNetwork().getNetworkElements(), element));
        this.movedConns.forEach(con -> this.targetSubApp.getSubAppNetwork().addConnection(con));
        this.changedSubAppIEs.redo();
        this.setPositionCommands.redo();
        this.setUniqueName.redo();
        this.modifiedConns.redo();
    }

    public void undo() {
        this.modifiedConns.undo();
        this.changedSubAppIEs.undo();
        this.setPositionCommands.undo();
        this.movedConns.forEach(con -> this.targetSubApp.getFbNetwork().addConnection(con));
        this.elementsToAdd.forEach(element -> AddElementsToSubAppCommand.addToNetwork((EList<FBNetworkElement>)this.targetSubApp.getFbNetwork().getNetworkElements(), element));
        this.setUniqueName.undo();
        this.removeFromOtherGroups.undo();
        this.unmappingCmds.undo();
        FBNetworkHelper.getBlockFBNetworkElementsFromList(this.elementsToAdd).forEach(BlockFBNetworkElement::checkConnections);
    }

    private void processElementsToAdd() {
        EList fbNetwork = this.targetSubApp.getSubAppNetwork().getNetworkElements();
        Position posOffset = this.getFBOffset();
        for (FBNetworkElement fbNetworkElement : this.elementsToAdd) {
            SetPositionCommand command = new SetPositionCommand((PositionableElement)fbNetworkElement, posOffset.getX(), posOffset.getY());
            command.execute();
            this.setPositionCommands.add((Command)command);
            AddElementsToSubAppCommand.addToNetwork((EList<FBNetworkElement>)fbNetwork, fbNetworkElement);
            this.checkElementConnections(fbNetworkElement);
            this.ensureUniqueName(fbNetworkElement);
        }
    }

    private static void addToNetwork(EList<FBNetworkElement> fbNetwork, FBNetworkElement element) {
        fbNetwork.add((Object)element);
        if (element instanceof Group) {
            Group group = (Group)element;
            group.getGroupElements().forEach(arg_0 -> fbNetwork.add(arg_0));
        }
    }

    private Position getFBOffset() {
        if (this.moveDelta != null) {
            return CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(-this.moveDelta.x, -this.moveDelta.y);
        }
        Position offset = FBNetworkHelper.getTopLeftCornerOfFBNetwork(this.elementsToAdd);
        offset.setX(-offset.getX());
        offset.setY(-offset.getY());
        return offset;
    }

    private void ensureUniqueName(FBNetworkElement element) {
        if (!NameRepository.isValidName((INamedElement)element, (String)element.getName())) {
            String uniqueName = NameRepository.createUniqueName((INamedElement)element, (String)element.getName());
            ChangeNameCommand cmd = ChangeNameCommand.forName((INamedElement)element, (String)uniqueName);
            cmd.execute();
            this.setUniqueName.add((Command)cmd);
        }
        if (element instanceof Group) {
            Group group = (Group)element;
            group.getGroupElements().forEach(this::ensureUniqueName);
        }
    }

    private void fillElementList(List<?> selection) {
        for (Object fbNetworkElement : selection) {
            EditPart ep;
            Object object;
            if (fbNetworkElement instanceof EditPart && (object = (ep = (EditPart)fbNetworkElement).getModel()) instanceof FBNetworkElement) {
                FBNetworkElement fbel = (FBNetworkElement)object;
                this.addElement(fbel);
                continue;
            }
            if (!(fbNetworkElement instanceof FBNetworkElement)) continue;
            FBNetworkElement fbel = (FBNetworkElement)fbNetworkElement;
            this.addElement(fbel);
        }
    }

    protected void addElement(FBNetworkElement element) {
        this.elementsToAdd.add(element);
        this.checkMapping(element);
    }

    private void checkMapping(FBNetworkElement element) {
        if (element.isMapped()) {
            this.unmappingCmds.add((Command)new UnmapCommand(element));
        }
        if (element instanceof Group) {
            Group group = (Group)element;
            group.getGroupElements().forEach(this::checkMapping);
        }
    }

    private void checkElementConnections(FBNetworkElement element) {
        FBNetworkElement fBNetworkElement = element;
        Objects.requireNonNull(fBNetworkElement);
        FBNetworkElement fBNetworkElement2 = fBNetworkElement;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockFBNetworkElement.class, Group.class}, (Object)fBNetworkElement2, 0)) {
            case 0: {
                BlockFBNetworkElement bfbEl = (BlockFBNetworkElement)fBNetworkElement2;
                this.checkBlockElementConnecitons(bfbEl);
                break;
            }
            case 1: {
                Group group = (Group)fBNetworkElement2;
                group.getGroupElements().forEach(this::checkElementConnections);
                break;
            }
        }
    }

    private void checkBlockElementConnecitons(BlockFBNetworkElement bfbEl) {
        for (IInterfaceElement ie : bfbEl.getInterface().getAllInterfaceElements()) {
            if (ie.isIsInput()) {
                for (Connection con : ie.getInputConnections()) {
                    this.checkConnection(con, con.getSource(), ie);
                }
                continue;
            }
            for (Connection con : ie.getOutputConnections()) {
                this.checkConnection(con, con.getDestination(), ie);
            }
        }
    }

    private void checkConnection(Connection con, IInterfaceElement opposite, IInterfaceElement ownIE) {
        if (opposite.getBlockFBNetworkElement() != null && this.isPartOfMove((FBNetworkElement)opposite.getBlockFBNetworkElement())) {
            this.moveConIntoSubApp(con);
        } else if (opposite.getBlockFBNetworkElement() != null && this.targetSubApp.equals(opposite.getBlockFBNetworkElement())) {
            this.moveInterfaceCrossingConIntoSubApp(con, opposite, ownIE);
        } else {
            this.handleModifyConnection(con, ownIE);
        }
    }

    private boolean isPartOfMove(FBNetworkElement elementToCheck) {
        if (this.elementsToAdd.contains(elementToCheck)) {
            return true;
        }
        return elementToCheck.isInGroup() && this.elementsToAdd.contains(elementToCheck.getGroup());
    }

    private void moveConIntoSubApp(Connection con) {
        this.targetSubApp.getSubAppNetwork().addConnection(con);
        this.movedConns.add(con);
    }

    private void moveInterfaceCrossingConIntoSubApp(Connection con, IInterfaceElement opposite, IInterfaceElement ownIE) {
        EList outCons;
        EList internalCons = opposite.isIsInput() ? opposite.getOutputConnections() : opposite.getInputConnections();
        EList eList = outCons = opposite.isIsInput() ? opposite.getInputConnections() : opposite.getOutputConnections();
        if (1 == outCons.size()) {
            this.modifiedConns.add((Command)new DeleteSubAppInterfaceElementCommand(opposite));
        } else {
            this.modifiedConns.add((Command)new DeleteConnectionCommand(con));
        }
        internalCons.forEach(intConn -> {
            AbstractConnectionCreateCommand cmd = AddElementsToSubAppCommand.getCreateConnectionCommand(this.targetSubApp.getSubAppNetwork(), opposite);
            cmd.setSource(opposite.isIsInput() ? ownIE : intConn.getSource());
            cmd.setDestination(opposite.isIsInput() ? intConn.getDestination() : ownIE);
            this.modifiedConns.add((Command)cmd);
        });
    }

    private void handleModifyConnection(Connection con, IInterfaceElement ie) {
        VarDeclaration destVar;
        IInterfaceElement iInterfaceElement;
        VarDeclaration sourceVar;
        IInterfaceElement subAppIE;
        boolean isNewPin;
        IInterfaceElement source = con.getSource();
        Optional<IInterfaceElement> reusablePin = this.targetSubApp.getInterface().getAllInterfaceElements().stream().filter(pin -> pin.getInputConnections().size() == 1).filter(pin -> ((Connection)pin.getInputConnections().get(0)).getSource().equals(source)).findFirst();
        boolean bl = isNewPin = !reusablePin.isPresent() && !this.sourceToSubAppPin.containsKey(source);
        if (reusablePin.isPresent()) {
            subAppIE = reusablePin.get();
        } else if (source instanceof VarDeclaration && (sourceVar = (VarDeclaration)source).isInOutVar() && (iInterfaceElement = con.getDestination()) instanceof VarDeclaration && (destVar = (VarDeclaration)iInterfaceElement).isInOutVar()) {
            if (this.sourceToSubAppPin.containsKey(sourceVar.getInOutVarOpposite())) {
                subAppIE = ((VarDeclaration)this.sourceToSubAppPin.get(sourceVar.getInOutVarOpposite())).getInOutVarOpposite();
                this.sourceToSubAppPin.putIfAbsent((IInterfaceElement)sourceVar, subAppIE);
            } else if (this.sourceToSubAppPin.containsKey(destVar.getInOutVarOpposite())) {
                subAppIE = ((VarDeclaration)this.sourceToSubAppPin.get(destVar.getInOutVarOpposite())).getInOutVarOpposite();
                this.sourceToSubAppPin.putIfAbsent((IInterfaceElement)sourceVar, subAppIE);
            } else {
                subAppIE = this.sourceToSubAppPin.computeIfAbsent(source, k -> this.createInterfaceElement(ie, source.getName()));
            }
            this.sourceToSubAppPin.putIfAbsent((IInterfaceElement)destVar, subAppIE);
        } else {
            subAppIE = this.sourceToSubAppPin.computeIfAbsent(source, k -> this.createInterfaceElement(ie, source.getName()));
        }
        this.createConnModificationCommands(con, subAppIE, isNewPin);
    }

    private IInterfaceElement createInterfaceElement(IInterfaceElement ie, String srcName) {
        VarDeclaration varDecl;
        boolean isInOut = ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).isInOutVar();
        CreateSubAppInterfaceElementCommand cmd = new CreateSubAppInterfaceElementCommand(ie.getType(), srcName, this.targetSubApp.getInterface(), ie.isIsInput(), isInOut, ArraySizeHelper.getArraySize((IInterfaceElement)ie), -1);
        cmd.execute();
        this.changedSubAppIEs.add((Command)cmd);
        return cmd.getCreatedElement();
    }

    private void createConnModificationCommands(Connection con, IInterfaceElement subAppIE, boolean isNewPin) {
        this.modifiedConns.add((Command)new DeleteConnectionCommand(con));
        if (isNewPin) {
            this.createSubAppPinConnection(this.targetSubApp.getFbNetwork(), subAppIE, con, false);
            this.createSubAppPinConnection(this.targetSubApp.getSubAppNetwork(), subAppIE, con, true);
        } else if (subAppIE.isIsInput()) {
            this.createSubAppPinConnection(this.targetSubApp.getSubAppNetwork(), subAppIE, con, true);
        } else {
            this.createSubAppPinConnection(this.targetSubApp.getFbNetwork(), subAppIE, con, false);
        }
    }

    private void createSubAppPinConnection(FBNetwork network, IInterfaceElement ie, Connection con, boolean isInsideSubApp) {
        AbstractConnectionCreateCommand cmd = AddElementsToSubAppCommand.getCreateConnectionCommand(network, ie);
        if (ie.isIsInput()) {
            cmd.setSource(isInsideSubApp ? ie : con.getSource());
            cmd.setDestination(isInsideSubApp ? con.getDestination() : ie);
        } else {
            cmd.setSource(isInsideSubApp ? con.getSource() : ie);
            cmd.setDestination(isInsideSubApp ? ie : con.getDestination());
        }
        this.modifiedConns.add((Command)cmd);
    }

    private static AbstractConnectionCreateCommand getCreateConnectionCommand(FBNetwork fbNetwork, IInterfaceElement subAppIE) {
        Object cmd = null;
        cmd = subAppIE instanceof Event ? new EventConnectionCreateCommand(fbNetwork) : (subAppIE instanceof AdapterDeclaration ? new AdapterConnectionCreateCommand(fbNetwork) : new DataConnectionCreateCommand(fbNetwork));
        return cmd;
    }

    private void collectElementsToRemoveFromGroup() {
        HashMap<Group, List> groupMap = new HashMap<Group, List>();
        this.elementsToAdd.stream().filter(FBNetworkElement::isInGroup).forEach(el -> {
            List entry = groupMap.computeIfAbsent(el.getGroup(), group -> new ArrayList());
            entry.add(el);
        });
        groupMap.forEach((group, list) -> this.removeFromOtherGroups.add((Command)new RemoveElementsFromGroup((Collection)list)));
    }

    public Set<EObject> getAffectedObjects() {
        return Set.of(this.targetSubApp);
    }

    public List<FBNetworkElement> getElements() {
        return this.elementsToAdd;
    }
}

