/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.ConflictNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchResourceNode;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.swt.graphics.Image;

public class BasicDifferenceGroupImpl
extends AdapterImpl
implements IDifferenceGroup {
    protected static final Function<EObject, Iterator<EObject>> E_ALL_CONTENTS = new Function<EObject, Iterator<EObject>>(){

        public Iterator<EObject> apply(EObject eObject) {
            return eObject.eAllContents();
        }
    };
    protected final Predicate<? super Diff> filter;
    protected final String name;
    protected final Image image;
    protected List<TreeNode> children;
    private final Comparison comparison;
    private final IDifferenceGroupExtender.Registry registry = EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupExtenderRegistry();
    private final ECrossReferenceAdapter crossReferenceAdapter;

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, ECrossReferenceAdapter crossReferenceAdapter) {
        this(comparison, filter, EMFCompareRCPUIMessages.getString("BasicDifferenceGroup.name"), EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"), crossReferenceAdapter);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, ECrossReferenceAdapter crossReferenceAdapter) {
        this(comparison, filter, name, EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"), crossReferenceAdapter);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, Image image, ECrossReferenceAdapter crossReferenceAdapter) {
        this.comparison = comparison;
        this.filter = filter;
        this.name = name;
        this.image = image;
        this.crossReferenceAdapter = crossReferenceAdapter;
    }

    protected final Comparison getComparison() {
        return this.comparison;
    }

    public boolean isAdapterForType(Object type) {
        return type == IDifferenceGroup.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledName() {
        ComposedStyledString ret = new ComposedStyledString();
        Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getChildren().iterator(), E_ALL_CONTENTS));
        Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
        boolean unresolvedDiffs = Iterators.any((Iterator)Iterators.filter((Iterator)eAllData, Diff.class), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        if (unresolvedDiffs) {
            ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        ret.append(this.getName());
        return ret;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public List<? extends TreeNode> getChildren() {
        if (this.children == null) {
            this.buildSubTree();
        }
        return this.children;
    }

    protected final void registerCrossReferenceAdapter(List<? extends Notifier> notifiers) {
        for (Notifier notifier : notifiers) {
            notifier.eAdapters().add((Object)this.crossReferenceAdapter);
        }
    }

    protected final void unregisterCrossReferenceAdapter(List<? extends Notifier> notifiers) {
        for (Notifier notifier : notifiers) {
            notifier.eAdapters().remove((Object)this.crossReferenceAdapter);
        }
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            this.unregisterCrossReferenceAdapter(this.children);
            this.children = null;
        }
    }

    public void buildSubTree() {
        this.children = this.createChildren();
        this.doBuildSubTrees();
        this.customize(this.children);
        this.registerCrossReferenceAdapter(this.children);
        this.setTarget((Notifier)this.comparison);
    }

    protected void doBuildSubTrees() {
        this.children.addAll(this.buildMatchTrees());
        this.children.addAll(this.buildMatchResourceTrees());
    }

    protected List<TreeNode> createChildren() {
        return Lists.newArrayList();
    }

    protected List<TreeNode> buildMatchTrees() {
        ArrayList<TreeNode> matchTrees = new ArrayList<TreeNode>();
        for (Match match : this.getComparison().getMatches()) {
            MatchNode matchNode = this.buildTree(match);
            if (matchNode == null) continue;
            matchTrees.add(matchNode);
        }
        return matchTrees;
    }

    protected MatchNode buildTree(Match match) {
        MatchNode result = null;
        MatchNode matchNode = this.createMatchNode(match);
        this.populateMatchNode(matchNode);
        if (!matchNode.getChildren().isEmpty()) {
            result = matchNode;
        }
        return result;
    }

    protected void populateMatchNode(MatchNode matchNode) {
        Match match = matchNode.getMatch();
        LinkedHashMultimap diffsBySubMatch = LinkedHashMultimap.create();
        for (Diff diff : Collections2.filter((Collection)match.getDifferences(), this.filter)) {
            if (!this.mustDisplayAsDirectChildOfMatch(diff)) continue;
            Match targetMatch = this.getTargetMatch(diff);
            if (match == targetMatch) {
                this.addDiffNode(matchNode, diff);
                continue;
            }
            if (match.getSubmatches().contains((Object)targetMatch)) {
                diffsBySubMatch.put((Object)targetMatch, (Object)diff);
                continue;
            }
            if (targetMatch == null) continue;
            MatchNode targetMatchNode = this.createMatchNode(targetMatch);
            matchNode.addSubMatchNode(targetMatchNode);
            this.addDiffNode(targetMatchNode, diff);
        }
        for (Match subMatch : match.getSubmatches()) {
            MatchNode subMatchNode = this.createMatchNode(subMatch);
            for (Diff subMatchDiff : diffsBySubMatch.get((Object)subMatch)) {
                this.addDiffNode(subMatchNode, subMatchDiff);
            }
            diffsBySubMatch.removeAll((Object)subMatch);
            this.populateMatchNode(subMatchNode);
            if (subMatchNode.getChildren().isEmpty()) continue;
            matchNode.addSubMatchNode(subMatchNode);
        }
    }

    protected Match getTargetMatch(Diff diff) {
        if (this.mustDisplayAsDirectChildOfMatch(diff)) {
            if (this.isContainmentRefChange(diff)) {
                Match valueMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue());
                return valueMatch;
            }
            if (this.isContainmentRefChange(diff.getPrimeRefining())) {
                Match valueMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff.getPrimeRefining()).getValue());
                return valueMatch;
            }
            return diff.getMatch();
        }
        return null;
    }

    protected boolean mustDisplayAsDirectChildOfMatch(Diff diff) {
        return diff.getRefines().isEmpty();
    }

    protected boolean isContainmentRefChange(Diff diff) {
        return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
    }

    protected List<TreeNode> buildMatchResourceTrees() {
        ArrayList<TreeNode> matchResourceTrees = new ArrayList<TreeNode>();
        if (this.getComparison().getMatchedResources().isEmpty()) {
            return matchResourceTrees;
        }
        Iterable attachmentChanges = Iterables.filter((Iterable)this.getComparison().getDifferences(), ResourceAttachmentChange.class);
        LinkedHashMultimap uriToRAC = LinkedHashMultimap.create();
        for (ResourceAttachmentChange attachmentChange : attachmentChanges) {
            uriToRAC.put((Object)attachmentChange.getResourceURI(), (Object)attachmentChange);
        }
        for (MatchResource matchResource : this.getComparison().getMatchedResources()) {
            Collection leftRAC = uriToRAC.get((Object)matchResource.getLeftURI());
            Collection rightRAC = uriToRAC.get((Object)matchResource.getRightURI());
            Collection originRAC = uriToRAC.get((Object)matchResource.getOriginURI());
            LinkedHashSet racForMatchResource = Sets.newLinkedHashSet();
            racForMatchResource.addAll(leftRAC);
            racForMatchResource.addAll(rightRAC);
            racForMatchResource.addAll(originRAC);
            MatchResourceNode matchNode = this.buildSubTree(matchResource, racForMatchResource);
            if (matchNode == null) continue;
            matchResourceTrees.add(matchNode);
        }
        return matchResourceTrees;
    }

    protected MatchResourceNode buildSubTree(MatchResource matchResource, Set<ResourceAttachmentChange> attachmentChanges) {
        MatchResourceNode matchResourceNode = this.createMatchResourceNode(matchResource);
        Collection filteredChanges = Collections2.filter(attachmentChanges, this.filter);
        for (ResourceAttachmentChange attachmentChange : filteredChanges) {
            DiffNode diffNode = this.createDiffNode((Diff)attachmentChange);
            matchResourceNode.addDiffNode(diffNode);
        }
        return matchResourceNode;
    }

    protected void addDiffNode(MatchNode matchNode, Diff diff) {
        if (!(diff instanceof ResourceAttachmentChange)) {
            DiffNode diffNode = this.createDiffNode(diff);
            this.handleRefiningDiffs(diffNode);
            matchNode.addDiffNode(diffNode);
        }
    }

    protected DiffNode createDiffNode(Diff diff) {
        DiffNode diffNode = new DiffNode(diff);
        diffNode.eAdapters().add((Object)this);
        return diffNode;
    }

    protected MatchNode createMatchNode(Match match) {
        MatchNode matchNode = new MatchNode(match);
        matchNode.eAdapters().add((Object)this);
        return matchNode;
    }

    protected ConflictNode createConflictNode(Conflict conflict) {
        ConflictNode conflictNode = new ConflictNode(conflict);
        conflictNode.eAdapters().add((Object)this);
        return conflictNode;
    }

    protected MatchResourceNode createMatchResourceNode(MatchResource matchResource) {
        MatchResourceNode matchResourceNode = new MatchResourceNode(matchResource);
        matchResourceNode.eAdapters().add((Object)this);
        return matchResourceNode;
    }

    protected void customize(List<? extends TreeNode> nodes) {
        for (TreeNode treeNode : nodes) {
            this.customize((List<? extends TreeNode>)treeNode.getChildren());
            this.customize(treeNode);
        }
    }

    protected void customize(TreeNode treeNode) {
        for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
            if (!ext.handle(treeNode)) continue;
            ext.addChildren(treeNode);
        }
    }

    protected void handleRefiningDiffs(DiffNode diffNode) {
        Diff diff = diffNode.getDiff();
        for (Diff refiningDiff : diff.getRefinedBy()) {
            DiffNode refinedDiffNode = this.createDiffNode(refiningDiff);
            diffNode.addRefinedDiffNode(refinedDiffNode);
            this.handleRefiningDiffs(refinedDiffNode);
        }
    }
}

