; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; xUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1250 -mattr=+real-true16 %s -o - | FileCheck -check-prefix=SDAG-REAL16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1250 -mattr=-real-true16 %s -o - | FileCheck -check-prefix=SDAG-FAKE16 %s
; xUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1250 -mattr=+real-true16 %s -o - | FileCheck -check-prefix=GISEL-REAL16 %s
; xUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1250 -mattr=-real-true16 %s -o - | FileCheck -check-prefix=GISEL-FAKE16 %s

; FIXME: t16 doesn't work at the moment because the store of s16 under t16 mode fails to select.
; FIXME: GlobalISel does not work with bf16

declare bfloat @llvm.amdgcn.tanh.bf16(bfloat) #0

define amdgpu_kernel void @tanh_bf16(ptr addrspace(1) %out, bfloat %src) #1 {
; SDAG-REAL16-LABEL: tanh_bf16:
; SDAG-REAL16:       ; %bb.0:
; SDAG-REAL16-NEXT:    s_load_b96 s[0:2], s[4:5], 0x0
; SDAG-REAL16-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-REAL16-NEXT:    s_wait_kmcnt 0x0
; SDAG-REAL16-NEXT:    v_tanh_bf16_e32 v0.l, s2
; SDAG-REAL16-NEXT:    flat_store_b16 v1, v0, s[0:1]
; SDAG-REAL16-NEXT:    s_endpgm
;
; SDAG-FAKE16-LABEL: tanh_bf16:
; SDAG-FAKE16:       ; %bb.0:
; SDAG-FAKE16-NEXT:    s_load_b96 s[0:2], s[4:5], 0x0
; SDAG-FAKE16-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; SDAG-FAKE16-NEXT:    v_tanh_bf16_e32 v0, s2
; SDAG-FAKE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; SDAG-FAKE16-NEXT:    s_endpgm
  %tanh = call bfloat @llvm.amdgcn.tanh.bf16(bfloat %src) #0
  store bfloat %tanh, ptr addrspace(1) %out, align 2
  ret void
}

define amdgpu_kernel void @tanh_bf16_constant_4(ptr addrspace(1) %out) #1 {
; SDAG-REAL16-LABEL: tanh_bf16_constant_4:
; SDAG-REAL16:       ; %bb.0:
; SDAG-REAL16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; SDAG-REAL16-NEXT:    v_tanh_bf16_e32 v0.l, 4.0
; SDAG-REAL16-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-REAL16-NEXT:    s_wait_kmcnt 0x0
; SDAG-REAL16-NEXT:    flat_store_b16 v1, v0, s[0:1]
; SDAG-REAL16-NEXT:    s_endpgm
;
; SDAG-FAKE16-LABEL: tanh_bf16_constant_4:
; SDAG-FAKE16:       ; %bb.0:
; SDAG-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; SDAG-FAKE16-NEXT:    v_tanh_bf16_e32 v0, 4.0
; SDAG-FAKE16-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; SDAG-FAKE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; SDAG-FAKE16-NEXT:    s_endpgm
  %tanh = call bfloat @llvm.amdgcn.tanh.bf16(bfloat 4.0) #0
  store bfloat %tanh, ptr addrspace(1) %out, align 2
  ret void
}

define amdgpu_kernel void @tanh_bf16_constant_100(ptr addrspace(1) %out) #1 {
; SDAG-REAL16-LABEL: tanh_bf16_constant_100:
; SDAG-REAL16:       ; %bb.0:
; SDAG-REAL16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; SDAG-REAL16-NEXT:    v_tanh_bf16_e32 v0.l, 0x42c8
; SDAG-REAL16-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-REAL16-NEXT:    s_wait_kmcnt 0x0
; SDAG-REAL16-NEXT:    flat_store_b16 v1, v0, s[0:1]
; SDAG-REAL16-NEXT:    s_endpgm
;
; SDAG-FAKE16-LABEL: tanh_bf16_constant_100:
; SDAG-FAKE16:       ; %bb.0:
; SDAG-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; SDAG-FAKE16-NEXT:    v_tanh_bf16_e32 v0, 0x42c8
; SDAG-FAKE16-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; SDAG-FAKE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; SDAG-FAKE16-NEXT:    s_endpgm
  %tanh = call bfloat @llvm.amdgcn.tanh.bf16(bfloat 100.0) #0
  store bfloat %tanh, ptr addrspace(1) %out, align 2
  ret void
}

define amdgpu_kernel void @tanh_undef_bf16(ptr addrspace(1) %out) #1 {
; SDAG-REAL16-LABEL: tanh_undef_bf16:
; SDAG-REAL16:       ; %bb.0:
; SDAG-REAL16-NEXT:    s_endpgm
;
; SDAG-FAKE16-LABEL: tanh_undef_bf16:
; SDAG-FAKE16:       ; %bb.0:
; SDAG-FAKE16-NEXT:    s_endpgm
  %tanh = call bfloat @llvm.amdgcn.tanh.bf16(bfloat undef)
  store bfloat %tanh, ptr addrspace(1) %out, align 2
  ret void
}

attributes #0 = { nounwind readnone }
attributes #1 = { nounwind }
