; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa -verify-machineinstrs < %s \
; RUN: | FileCheck -check-prefix=XTENSA %s
; RUN: llc -mtriple=xtensa -mattr=+mul32high,mul32 -verify-machineinstrs < %s \
; RUN: | FileCheck -check-prefix=XTENSA-MUL %s

define signext i32 @square(i32 %a) nounwind {
; XTENSA-LABEL: square:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI0_0
; XTENSA-NEXT:    or a3, a2, a2
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: square:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    mull a2, a2, a2
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, %a
  ret i32 %1
}

define signext i32 @mul(i32 %a, i32 %b) nounwind {
; XTENSA-LABEL: mul:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI1_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    mull a2, a2, a3
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, %b
  ret i32 %1
}

define signext i32 @mul_constant(i32 %a) nounwind {
; XTENSA-LABEL: mul_constant:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a3, 5
; XTENSA-NEXT:    l32r a8, .LCPI2_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul_constant:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 5
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 5
  ret i32 %1
}

define i32 @mul_pow2(i32 %a) nounwind {
; XTENSA-LABEL: mul_pow2:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    slli a2, a2, 3
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul_pow2:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    slli a2, a2, 3
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 8
  ret i32 %1
}

define i64 @mul64(i64 %a, i64 %b) nounwind {
; XTENSA-LABEL: mul64:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI4_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul64:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    mull a8, a2, a5
; XTENSA-MUL-NEXT:    muluh a9, a2, a4
; XTENSA-MUL-NEXT:    add a8, a9, a8
; XTENSA-MUL-NEXT:    mull a9, a3, a4
; XTENSA-MUL-NEXT:    add a3, a8, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a4
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, %b
  ret i64 %1
}

define i64 @mul64_constant(i64 %a) nounwind {
; XTENSA-LABEL: mul64_constant:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a4, 5
; XTENSA-NEXT:    movi a5, 0
; XTENSA-NEXT:    l32r a8, .LCPI5_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul64_constant:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 5
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, 5
  ret i64 %1
}

define i32 @mulhs(i32 %a, i32 %b) nounwind {
; XTENSA-LABEL: mulhs:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    or a4, a3, a3
; XTENSA-NEXT:    srai a3, a2, 31
; XTENSA-NEXT:    srai a5, a4, 31
; XTENSA-NEXT:    l32r a8, .LCPI6_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a2, a3, a3
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhs:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    mulsh a2, a2, a3
; XTENSA-MUL-NEXT:    ret
  %1 = sext i32 %a to i64
  %2 = sext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}

define i32 @mulhs_positive_constant(i32 %a) nounwind {
; XTENSA-LABEL: mulhs_positive_constant:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    srai a3, a2, 31
; XTENSA-NEXT:    movi a4, 5
; XTENSA-NEXT:    movi a5, 0
; XTENSA-NEXT:    l32r a8, .LCPI7_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a2, a3, a3
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhs_positive_constant:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 5
; XTENSA-MUL-NEXT:    mulsh a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = sext i32 %a to i64
  %2 = mul i64 %1, 5
  %3 = lshr i64 %2, 32
  %4 = trunc i64 %3 to i32
  ret i32 %4
}

define i32 @mulhs_negative_constant(i32 %a) nounwind {
; XTENSA-LABEL: mulhs_negative_constant:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    srai a3, a2, 31
; XTENSA-NEXT:    movi a4, -5
; XTENSA-NEXT:    movi a5, -1
; XTENSA-NEXT:    l32r a8, .LCPI8_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a2, a3, a3
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhs_negative_constant:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, -5
; XTENSA-MUL-NEXT:    mulsh a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = sext i32 %a to i64
  %2 = mul i64 %1, -5
  %3 = lshr i64 %2, 32
  %4 = trunc i64 %3 to i32
  ret i32 %4
}

define zeroext i32 @mulhu(i32 zeroext %a, i32 zeroext %b) nounwind {
; XTENSA-LABEL: mulhu:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    or a4, a3, a3
; XTENSA-NEXT:    movi a3, 0
; XTENSA-NEXT:    l32r a8, .LCPI9_0
; XTENSA-NEXT:    or a5, a3, a3
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a2, a3, a3
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhu:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    muluh a2, a2, a3
; XTENSA-MUL-NEXT:    ret
  %1 = zext i32 %a to i64
  %2 = zext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}

define i32 @mulhsu(i32 %a, i32 %b) nounwind {
; XTENSA-LABEL: mulhsu:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    or a4, a3, a3
; XTENSA-NEXT:    srai a5, a4, 31
; XTENSA-NEXT:    movi a3, 0
; XTENSA-NEXT:    l32r a8, .LCPI10_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a2, a3, a3
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhsu:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    muluh a8, a2, a3
; XTENSA-MUL-NEXT:    srai a9, a3, 31
; XTENSA-MUL-NEXT:    mull a9, a2, a9
; XTENSA-MUL-NEXT:    add a2, a8, a9
; XTENSA-MUL-NEXT:    ret
  %1 = zext i32 %a to i64
  %2 = sext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}

define i32 @mulhu_constant(i32 %a) nounwind {
; XTENSA-LABEL: mulhu_constant:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a4, 5
; XTENSA-NEXT:    movi a3, 0
; XTENSA-NEXT:    l32r a8, .LCPI11_0
; XTENSA-NEXT:    or a5, a3, a3
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a2, a3, a3
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhu_constant:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 5
; XTENSA-MUL-NEXT:    muluh a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = zext i32 %a to i64
  %2 = mul i64 %1, 5
  %3 = lshr i64 %2, 32
  %4 = trunc i64 %3 to i32
  ret i32 %4
}

define i32 @muli32_p65(i32 %a) nounwind {
; XTENSA-LABEL: muli32_p65:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a3, 65
; XTENSA-NEXT:    l32r a8, .LCPI12_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_p65:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 65
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 65
  ret i32 %1
}

define i32 @muli32_p63(i32 %a) nounwind {
; XTENSA-LABEL: muli32_p63:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a3, 63
; XTENSA-NEXT:    l32r a8, .LCPI13_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_p63:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 63
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 63
  ret i32 %1
}

define i64 @muli64_p65(i64 %a) nounwind {
; XTENSA-LABEL: muli64_p65:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a4, 65
; XTENSA-NEXT:    movi a5, 0
; XTENSA-NEXT:    l32r a8, .LCPI14_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_p65:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 65
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, 65
  ret i64 %1
}

define i64 @muli64_p63(i64 %a) nounwind {
; XTENSA-LABEL: muli64_p63:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a4, 63
; XTENSA-NEXT:    movi a5, 0
; XTENSA-NEXT:    l32r a8, .LCPI15_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_p63:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 63
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, 63
  ret i64 %1
}

define i32 @muli32_m63(i32 %a) nounwind {
; XTENSA-LABEL: muli32_m63:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a3, -63
; XTENSA-NEXT:    l32r a8, .LCPI16_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_m63:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, -63
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, -63
  ret i32 %1
}

define i32 @muli32_m65(i32 %a) nounwind {
; XTENSA-LABEL: muli32_m65:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a3, -65
; XTENSA-NEXT:    l32r a8, .LCPI17_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_m65:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, -65
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, -65
  ret i32 %1
}

define i64 @muli64_m63(i64 %a) nounwind {
; XTENSA-LABEL: muli64_m63:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a4, -63
; XTENSA-NEXT:    movi a5, -1
; XTENSA-NEXT:    l32r a8, .LCPI18_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_m63:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, -63
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    sub a10, a10, a2
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, -63
  ret i64 %1
}

define i64 @muli64_m65(i64 %a) nounwind {
; XTENSA-LABEL: muli64_m65:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a4, -65
; XTENSA-NEXT:    movi a5, -1
; XTENSA-NEXT:    l32r a8, .LCPI19_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_m65:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, -65
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    sub a10, a10, a2
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, -65
  ret i64 %1
}

define i32 @muli32_p384(i32 %a) nounwind {
; XTENSA-LABEL: muli32_p384:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a3, 384
; XTENSA-NEXT:    l32r a8, .LCPI20_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_p384:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    movi a8, 384
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 384
  ret i32 %1
}

define i32 @muli32_p12288(i32 %a) nounwind {
; XTENSA-LABEL: muli32_p12288:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a3, .LCPI21_0
; XTENSA-NEXT:    l32r a8, .LCPI21_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_p12288:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI21_0
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 12288
  ret i32 %1
}

define i32 @muli32_p4352(i32 %a) nounwind {
; XTENSA-LABEL: muli32_p4352:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a3, .LCPI22_0
; XTENSA-NEXT:    l32r a8, .LCPI22_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_p4352:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI22_0
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 4352
  ret i32 %1
}

define i32 @muli32_p3840(i32 %a) nounwind {
; XTENSA-LABEL: muli32_p3840:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a3, .LCPI23_0
; XTENSA-NEXT:    l32r a8, .LCPI23_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_p3840:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI23_0
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 3840
  ret i32 %1
}

define i32 @muli32_m3840(i32 %a) nounwind {
; XTENSA-LABEL: muli32_m3840:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a3, .LCPI24_0
; XTENSA-NEXT:    l32r a8, .LCPI24_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_m3840:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI24_0
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, -3840
  ret i32 %1
}

define i32 @muli32_m4352(i32 %a) nounwind {
; XTENSA-LABEL: muli32_m4352:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a3, .LCPI25_0
; XTENSA-NEXT:    l32r a8, .LCPI25_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli32_m4352:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI25_0
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, -4352
  ret i32 %1
}

define i64 @muli64_p4352(i64 %a) nounwind {
; XTENSA-LABEL: muli64_p4352:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a4, .LCPI26_0
; XTENSA-NEXT:    movi a5, 0
; XTENSA-NEXT:    l32r a8, .LCPI26_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_p4352:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI26_0
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, 4352
  ret i64 %1
}

define i64 @muli64_p3840(i64 %a) nounwind {
; XTENSA-LABEL: muli64_p3840:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a4, .LCPI27_0
; XTENSA-NEXT:    movi a5, 0
; XTENSA-NEXT:    l32r a8, .LCPI27_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_p3840:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI27_0
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, 3840
  ret i64 %1
}

define i64 @muli64_m4352(i64 %a) nounwind {
; XTENSA-LABEL: muli64_m4352:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a4, .LCPI28_0
; XTENSA-NEXT:    movi a5, -1
; XTENSA-NEXT:    l32r a8, .LCPI28_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_m4352:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI28_0
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    sub a10, a10, a2
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, -4352
  ret i64 %1
}

define i64 @muli64_m3840(i64 %a) nounwind {
; XTENSA-LABEL: muli64_m3840:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a4, .LCPI29_0
; XTENSA-NEXT:    movi a5, -1
; XTENSA-NEXT:    l32r a8, .LCPI29_1
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli64_m3840:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    l32r a8, .LCPI29_0
; XTENSA-MUL-NEXT:    mull a9, a3, a8
; XTENSA-MUL-NEXT:    muluh a10, a2, a8
; XTENSA-MUL-NEXT:    sub a10, a10, a2
; XTENSA-MUL-NEXT:    add a3, a10, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i64 %a, -3840
  ret i64 %1
}

define i128 @muli128_m3840(i128 %a) nounwind {
; XTENSA-LABEL: muli128_m3840:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -64
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 60 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a12, a1, 56 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a13, a1, 52 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a14, a1, 48 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a15, a1, 44 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a5, a1, 20 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a4, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    or a13, a3, a3
; XTENSA-NEXT:    l32r a15, .LCPI30_0
; XTENSA-NEXT:    movi a12, 0
; XTENSA-NEXT:    l32r a8, .LCPI30_1
; XTENSA-NEXT:    s32i a2, a1, 36 # 4-byte Folded Spill
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a4, a15, a15
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a2, a1, 28 # 4-byte Folded Spill
; XTENSA-NEXT:    or a14, a3, a3
; XTENSA-NEXT:    l32r a8, .LCPI30_2
; XTENSA-NEXT:    s32i a13, a1, 40 # 4-byte Folded Spill
; XTENSA-NEXT:    or a2, a13, a13
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    s32i a15, a1, 12 # 4-byte Folded Spill
; XTENSA-NEXT:    or a4, a15, a15
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    add a13, a2, a14
; XTENSA-NEXT:    movi a15, 1
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    bltu a13, a2, .LBB30_2
; XTENSA-NEXT:  # %bb.1:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB30_2:
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    s32i a8, a1, 32 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a14, -1
; XTENSA-NEXT:    l32r a8, .LCPI30_3
; XTENSA-NEXT:    l32i a2, a1, 36 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a4, a14, a14
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    add a9, a2, a13
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    s32i a9, a1, 24 # 4-byte Folded Spill
; XTENSA-NEXT:    bltu a9, a2, .LBB30_4
; XTENSA-NEXT:  # %bb.3:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB30_4:
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    l32i a9, a1, 32 # 4-byte Folded Reload
; XTENSA-NEXT:    add a13, a9, a8
; XTENSA-NEXT:    l32r a8, .LCPI30_4
; XTENSA-NEXT:    l32i a2, a1, 40 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a4, a14, a14
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a3, a1, 4 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a13, a1, 8 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a2, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    add a13, a2, a13
; XTENSA-NEXT:    l32r a8, .LCPI30_5
; XTENSA-NEXT:    l32i a2, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a3, a1, 20 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a4, a1, 12 # 4-byte Folded Reload
; XTENSA-NEXT:    or a5, a14, a14
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a2, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a3, a1, 20 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI30_6
; XTENSA-NEXT:    l32i a2, a1, 36 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a3, a1, 40 # 4-byte Folded Reload
; XTENSA-NEXT:    or a4, a14, a14
; XTENSA-NEXT:    or a5, a14, a14
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a8, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    add a9, a2, a8
; XTENSA-NEXT:    add a4, a13, a9
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    bltu a4, a13, .LBB30_6
; XTENSA-NEXT:  # %bb.5:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB30_6:
; XTENSA-NEXT:    or a10, a15, a15
; XTENSA-NEXT:    l32i a11, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    bltu a13, a11, .LBB30_8
; XTENSA-NEXT:  # %bb.7:
; XTENSA-NEXT:    or a10, a12, a12
; XTENSA-NEXT:  .LBB30_8:
; XTENSA-NEXT:    or a11, a15, a15
; XTENSA-NEXT:    l32i a7, a1, 32 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a6, a1, 8 # 4-byte Folded Reload
; XTENSA-NEXT:    bltu a6, a7, .LBB30_10
; XTENSA-NEXT:  # %bb.9:
; XTENSA-NEXT:    or a11, a12, a12
; XTENSA-NEXT:  .LBB30_10:
; XTENSA-NEXT:    l32i a7, a1, 4 # 4-byte Folded Reload
; XTENSA-NEXT:    add a11, a7, a11
; XTENSA-NEXT:    add a10, a11, a10
; XTENSA-NEXT:    bltu a9, a2, .LBB30_12
; XTENSA-NEXT:  # %bb.11:
; XTENSA-NEXT:    or a15, a12, a12
; XTENSA-NEXT:  .LBB30_12:
; XTENSA-NEXT:    l32i a9, a1, 20 # 4-byte Folded Reload
; XTENSA-NEXT:    add a9, a3, a9
; XTENSA-NEXT:    add a9, a9, a15
; XTENSA-NEXT:    add a9, a10, a9
; XTENSA-NEXT:    add a5, a9, a8
; XTENSA-NEXT:    l32i a2, a1, 28 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a3, a1, 24 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a15, a1, 44 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a14, a1, 48 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a13, a1, 52 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a12, a1, 56 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a0, a1, 60 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 64
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli128_m3840:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    addi a8, a1, -48
; XTENSA-MUL-NEXT:    or a1, a8, a8
; XTENSA-MUL-NEXT:    s32i a12, a1, 32 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a13, a1, 28 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a14, a1, 24 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a15, a1, 20 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a5, a1, 16 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    l32r a10, .LCPI30_0
; XTENSA-MUL-NEXT:    muluh a8, a2, a10
; XTENSA-MUL-NEXT:    mull a7, a3, a10
; XTENSA-MUL-NEXT:    add a8, a7, a8
; XTENSA-MUL-NEXT:    movi a5, 0
; XTENSA-MUL-NEXT:    movi a11, 1
; XTENSA-MUL-NEXT:    or a9, a11, a11
; XTENSA-MUL-NEXT:    bltu a8, a7, .LBB30_2
; XTENSA-MUL-NEXT:  # %bb.1:
; XTENSA-MUL-NEXT:    or a9, a5, a5
; XTENSA-MUL-NEXT:  .LBB30_2:
; XTENSA-MUL-NEXT:    muluh a7, a3, a10
; XTENSA-MUL-NEXT:    add a15, a7, a9
; XTENSA-MUL-NEXT:    sub a8, a8, a2
; XTENSA-MUL-NEXT:    neg a7, a2
; XTENSA-MUL-NEXT:    or a9, a11, a11
; XTENSA-MUL-NEXT:    s32i a8, a1, 12 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a7, a1, 8 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    bltu a8, a7, .LBB30_4
; XTENSA-MUL-NEXT:  # %bb.3:
; XTENSA-MUL-NEXT:    or a9, a5, a5
; XTENSA-MUL-NEXT:  .LBB30_4:
; XTENSA-MUL-NEXT:    movi a8, -1
; XTENSA-MUL-NEXT:    muluh a13, a2, a8
; XTENSA-MUL-NEXT:    add a9, a13, a9
; XTENSA-MUL-NEXT:    add a12, a15, a9
; XTENSA-MUL-NEXT:    sub a6, a12, a3
; XTENSA-MUL-NEXT:    mull a9, a4, a10
; XTENSA-MUL-NEXT:    sub a14, a9, a2
; XTENSA-MUL-NEXT:    add a9, a6, a14
; XTENSA-MUL-NEXT:    or a7, a11, a11
; XTENSA-MUL-NEXT:    s32i a9, a1, 4 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    bltu a9, a6, .LBB30_6
; XTENSA-MUL-NEXT:  # %bb.5:
; XTENSA-MUL-NEXT:    or a7, a5, a5
; XTENSA-MUL-NEXT:  .LBB30_6:
; XTENSA-MUL-NEXT:    s32i a7, a1, 0 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    neg a9, a3
; XTENSA-MUL-NEXT:    or a7, a11, a11
; XTENSA-MUL-NEXT:    bltu a6, a9, .LBB30_8
; XTENSA-MUL-NEXT:  # %bb.7:
; XTENSA-MUL-NEXT:    or a7, a5, a5
; XTENSA-MUL-NEXT:  .LBB30_8:
; XTENSA-MUL-NEXT:    or a6, a11, a11
; XTENSA-MUL-NEXT:    bltu a12, a15, .LBB30_10
; XTENSA-MUL-NEXT:  # %bb.9:
; XTENSA-MUL-NEXT:    or a6, a5, a5
; XTENSA-MUL-NEXT:  .LBB30_10:
; XTENSA-MUL-NEXT:    muluh a8, a3, a8
; XTENSA-MUL-NEXT:    add a8, a8, a6
; XTENSA-MUL-NEXT:    add a8, a8, a7
; XTENSA-MUL-NEXT:    l32i a9, a1, 16 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    mull a9, a9, a10
; XTENSA-MUL-NEXT:    muluh a7, a4, a10
; XTENSA-MUL-NEXT:    sub a7, a7, a4
; XTENSA-MUL-NEXT:    add a9, a7, a9
; XTENSA-MUL-NEXT:    sub a7, a13, a2
; XTENSA-MUL-NEXT:    sub a7, a7, a3
; XTENSA-MUL-NEXT:    add a7, a7, a9
; XTENSA-MUL-NEXT:    l32i a9, a1, 8 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    bltu a14, a9, .LBB30_12
; XTENSA-MUL-NEXT:  # %bb.11:
; XTENSA-MUL-NEXT:    or a11, a5, a5
; XTENSA-MUL-NEXT:  .LBB30_12:
; XTENSA-MUL-NEXT:    add a9, a7, a11
; XTENSA-MUL-NEXT:    add a8, a8, a9
; XTENSA-MUL-NEXT:    l32i a9, a1, 0 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    add a5, a8, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a10
; XTENSA-MUL-NEXT:    l32i a3, a1, 12 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a4, a1, 4 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a15, a1, 20 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a14, a1, 24 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a13, a1, 28 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a12, a1, 32 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    addi a8, a1, 48
; XTENSA-MUL-NEXT:    or a1, a8, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i128 %a, -3840
  ret i128 %1
}

define i128 @muli128_m63(i128 %a) nounwind {
; XTENSA-LABEL: muli128_m63:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -64
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 60 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a12, a1, 56 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a13, a1, 52 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a14, a1, 48 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a15, a1, 44 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a5, a1, 20 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a4, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    or a13, a3, a3
; XTENSA-NEXT:    movi a15, -63
; XTENSA-NEXT:    movi a12, 0
; XTENSA-NEXT:    l32r a8, .LCPI31_0
; XTENSA-NEXT:    s32i a2, a1, 36 # 4-byte Folded Spill
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a4, a15, a15
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a2, a1, 28 # 4-byte Folded Spill
; XTENSA-NEXT:    or a14, a3, a3
; XTENSA-NEXT:    l32r a8, .LCPI31_1
; XTENSA-NEXT:    s32i a13, a1, 40 # 4-byte Folded Spill
; XTENSA-NEXT:    or a2, a13, a13
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    s32i a15, a1, 12 # 4-byte Folded Spill
; XTENSA-NEXT:    or a4, a15, a15
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    add a13, a2, a14
; XTENSA-NEXT:    movi a15, 1
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    bltu a13, a2, .LBB31_2
; XTENSA-NEXT:  # %bb.1:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB31_2:
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    s32i a8, a1, 32 # 4-byte Folded Spill
; XTENSA-NEXT:    movi a14, -1
; XTENSA-NEXT:    l32r a8, .LCPI31_2
; XTENSA-NEXT:    l32i a2, a1, 36 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a4, a14, a14
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    add a9, a2, a13
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    s32i a9, a1, 24 # 4-byte Folded Spill
; XTENSA-NEXT:    bltu a9, a2, .LBB31_4
; XTENSA-NEXT:  # %bb.3:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB31_4:
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    l32i a9, a1, 32 # 4-byte Folded Reload
; XTENSA-NEXT:    add a13, a9, a8
; XTENSA-NEXT:    l32r a8, .LCPI31_3
; XTENSA-NEXT:    l32i a2, a1, 40 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a4, a14, a14
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a3, a1, 4 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a13, a1, 8 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a2, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    add a13, a2, a13
; XTENSA-NEXT:    l32r a8, .LCPI31_4
; XTENSA-NEXT:    l32i a2, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a3, a1, 20 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a4, a1, 12 # 4-byte Folded Reload
; XTENSA-NEXT:    or a5, a14, a14
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a2, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a3, a1, 20 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI31_5
; XTENSA-NEXT:    l32i a2, a1, 36 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a3, a1, 40 # 4-byte Folded Reload
; XTENSA-NEXT:    or a4, a14, a14
; XTENSA-NEXT:    or a5, a14, a14
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a8, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    add a9, a2, a8
; XTENSA-NEXT:    add a4, a13, a9
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    bltu a4, a13, .LBB31_6
; XTENSA-NEXT:  # %bb.5:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB31_6:
; XTENSA-NEXT:    or a10, a15, a15
; XTENSA-NEXT:    l32i a11, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    bltu a13, a11, .LBB31_8
; XTENSA-NEXT:  # %bb.7:
; XTENSA-NEXT:    or a10, a12, a12
; XTENSA-NEXT:  .LBB31_8:
; XTENSA-NEXT:    or a11, a15, a15
; XTENSA-NEXT:    l32i a7, a1, 32 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a6, a1, 8 # 4-byte Folded Reload
; XTENSA-NEXT:    bltu a6, a7, .LBB31_10
; XTENSA-NEXT:  # %bb.9:
; XTENSA-NEXT:    or a11, a12, a12
; XTENSA-NEXT:  .LBB31_10:
; XTENSA-NEXT:    l32i a7, a1, 4 # 4-byte Folded Reload
; XTENSA-NEXT:    add a11, a7, a11
; XTENSA-NEXT:    add a10, a11, a10
; XTENSA-NEXT:    bltu a9, a2, .LBB31_12
; XTENSA-NEXT:  # %bb.11:
; XTENSA-NEXT:    or a15, a12, a12
; XTENSA-NEXT:  .LBB31_12:
; XTENSA-NEXT:    l32i a9, a1, 20 # 4-byte Folded Reload
; XTENSA-NEXT:    add a9, a3, a9
; XTENSA-NEXT:    add a9, a9, a15
; XTENSA-NEXT:    add a9, a10, a9
; XTENSA-NEXT:    add a5, a9, a8
; XTENSA-NEXT:    l32i a2, a1, 28 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a3, a1, 24 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a15, a1, 44 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a14, a1, 48 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a13, a1, 52 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a12, a1, 56 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a0, a1, 60 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 64
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muli128_m63:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    addi a8, a1, -48
; XTENSA-MUL-NEXT:    or a1, a8, a8
; XTENSA-MUL-NEXT:    s32i a12, a1, 32 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a13, a1, 28 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a14, a1, 24 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a15, a1, 20 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a5, a1, 16 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    movi a10, -63
; XTENSA-MUL-NEXT:    muluh a8, a2, a10
; XTENSA-MUL-NEXT:    mull a7, a3, a10
; XTENSA-MUL-NEXT:    add a8, a7, a8
; XTENSA-MUL-NEXT:    movi a5, 0
; XTENSA-MUL-NEXT:    movi a11, 1
; XTENSA-MUL-NEXT:    or a9, a11, a11
; XTENSA-MUL-NEXT:    bltu a8, a7, .LBB31_2
; XTENSA-MUL-NEXT:  # %bb.1:
; XTENSA-MUL-NEXT:    or a9, a5, a5
; XTENSA-MUL-NEXT:  .LBB31_2:
; XTENSA-MUL-NEXT:    muluh a7, a3, a10
; XTENSA-MUL-NEXT:    add a15, a7, a9
; XTENSA-MUL-NEXT:    sub a8, a8, a2
; XTENSA-MUL-NEXT:    neg a7, a2
; XTENSA-MUL-NEXT:    or a9, a11, a11
; XTENSA-MUL-NEXT:    s32i a8, a1, 12 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a7, a1, 8 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    bltu a8, a7, .LBB31_4
; XTENSA-MUL-NEXT:  # %bb.3:
; XTENSA-MUL-NEXT:    or a9, a5, a5
; XTENSA-MUL-NEXT:  .LBB31_4:
; XTENSA-MUL-NEXT:    movi a8, -1
; XTENSA-MUL-NEXT:    muluh a13, a2, a8
; XTENSA-MUL-NEXT:    add a9, a13, a9
; XTENSA-MUL-NEXT:    add a12, a15, a9
; XTENSA-MUL-NEXT:    sub a6, a12, a3
; XTENSA-MUL-NEXT:    mull a9, a4, a10
; XTENSA-MUL-NEXT:    sub a14, a9, a2
; XTENSA-MUL-NEXT:    add a9, a6, a14
; XTENSA-MUL-NEXT:    or a7, a11, a11
; XTENSA-MUL-NEXT:    s32i a9, a1, 4 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    bltu a9, a6, .LBB31_6
; XTENSA-MUL-NEXT:  # %bb.5:
; XTENSA-MUL-NEXT:    or a7, a5, a5
; XTENSA-MUL-NEXT:  .LBB31_6:
; XTENSA-MUL-NEXT:    s32i a7, a1, 0 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    neg a9, a3
; XTENSA-MUL-NEXT:    or a7, a11, a11
; XTENSA-MUL-NEXT:    bltu a6, a9, .LBB31_8
; XTENSA-MUL-NEXT:  # %bb.7:
; XTENSA-MUL-NEXT:    or a7, a5, a5
; XTENSA-MUL-NEXT:  .LBB31_8:
; XTENSA-MUL-NEXT:    or a6, a11, a11
; XTENSA-MUL-NEXT:    bltu a12, a15, .LBB31_10
; XTENSA-MUL-NEXT:  # %bb.9:
; XTENSA-MUL-NEXT:    or a6, a5, a5
; XTENSA-MUL-NEXT:  .LBB31_10:
; XTENSA-MUL-NEXT:    muluh a8, a3, a8
; XTENSA-MUL-NEXT:    add a8, a8, a6
; XTENSA-MUL-NEXT:    add a8, a8, a7
; XTENSA-MUL-NEXT:    l32i a9, a1, 16 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    mull a9, a9, a10
; XTENSA-MUL-NEXT:    muluh a7, a4, a10
; XTENSA-MUL-NEXT:    sub a7, a7, a4
; XTENSA-MUL-NEXT:    add a9, a7, a9
; XTENSA-MUL-NEXT:    sub a7, a13, a2
; XTENSA-MUL-NEXT:    sub a7, a7, a3
; XTENSA-MUL-NEXT:    add a7, a7, a9
; XTENSA-MUL-NEXT:    l32i a9, a1, 8 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    bltu a14, a9, .LBB31_12
; XTENSA-MUL-NEXT:  # %bb.11:
; XTENSA-MUL-NEXT:    or a11, a5, a5
; XTENSA-MUL-NEXT:  .LBB31_12:
; XTENSA-MUL-NEXT:    add a9, a7, a11
; XTENSA-MUL-NEXT:    add a8, a8, a9
; XTENSA-MUL-NEXT:    l32i a9, a1, 0 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    add a5, a8, a9
; XTENSA-MUL-NEXT:    mull a2, a2, a10
; XTENSA-MUL-NEXT:    l32i a3, a1, 12 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a4, a1, 4 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a15, a1, 20 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a14, a1, 24 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a13, a1, 28 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a12, a1, 32 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    addi a8, a1, 48
; XTENSA-MUL-NEXT:    or a1, a8, a8
; XTENSA-MUL-NEXT:    ret
  %1 = mul i128 %a, -63
  ret i128 %1
}

define i64 @mulhsu_i64(i64 %a, i64 %b) nounwind {
; XTENSA-LABEL: mulhsu_i64:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -64
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 52 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a12, a1, 48 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a13, a1, 44 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a14, a1, 40 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a15, a1, 36 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a5, a1, 28 # 4-byte Folded Spill
; XTENSA-NEXT:    or a13, a4, a4
; XTENSA-NEXT:    or a15, a3, a3
; XTENSA-NEXT:    movi a12, 0
; XTENSA-NEXT:    l32r a8, .LCPI32_0
; XTENSA-NEXT:    s32i a2, a1, 32 # 4-byte Folded Spill
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a14, a3, a3
; XTENSA-NEXT:    l32r a8, .LCPI32_1
; XTENSA-NEXT:    s32i a15, a1, 20 # 4-byte Folded Spill
; XTENSA-NEXT:    or a2, a15, a15
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    s32i a13, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    or a4, a13, a13
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    add a14, a2, a14
; XTENSA-NEXT:    movi a15, 1
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    bltu a14, a2, .LBB32_2
; XTENSA-NEXT:  # %bb.1:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB32_2:
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    s32i a8, a1, 24 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI32_2
; XTENSA-NEXT:    l32i a2, a1, 32 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    l32i a4, a1, 28 # 4-byte Folded Reload
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    add a9, a2, a14
; XTENSA-NEXT:    or a8, a15, a15
; XTENSA-NEXT:    bltu a9, a2, .LBB32_4
; XTENSA-NEXT:  # %bb.3:
; XTENSA-NEXT:    or a8, a12, a12
; XTENSA-NEXT:  .LBB32_4:
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    l32i a9, a1, 24 # 4-byte Folded Reload
; XTENSA-NEXT:    add a14, a9, a8
; XTENSA-NEXT:    l32r a8, .LCPI32_3
; XTENSA-NEXT:    l32i a2, a1, 20 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a12, a12
; XTENSA-NEXT:    l32i a13, a1, 28 # 4-byte Folded Reload
; XTENSA-NEXT:    or a4, a13, a13
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a3, a1, 8 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a14, a1, 12 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a2, a1, 4 # 4-byte Folded Spill
; XTENSA-NEXT:    add a14, a2, a14
; XTENSA-NEXT:    l32r a8, .LCPI32_4
; XTENSA-NEXT:    l32i a2, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    or a3, a13, a13
; XTENSA-NEXT:    or a4, a12, a12
; XTENSA-NEXT:    or a5, a12, a12
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    s32i a2, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a3, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    srai a2, a13, 31
; XTENSA-NEXT:    l32r a8, .LCPI32_5
; XTENSA-NEXT:    or a3, a2, a2
; XTENSA-NEXT:    l32i a4, a1, 32 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a5, a1, 20 # 4-byte Folded Reload
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    or a8, a2, a2
; XTENSA-NEXT:    l32i a9, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    add a10, a8, a9
; XTENSA-NEXT:    add a2, a14, a10
; XTENSA-NEXT:    or a9, a15, a15
; XTENSA-NEXT:    bltu a2, a14, .LBB32_6
; XTENSA-NEXT:  # %bb.5:
; XTENSA-NEXT:    or a9, a12, a12
; XTENSA-NEXT:  .LBB32_6:
; XTENSA-NEXT:    or a11, a15, a15
; XTENSA-NEXT:    l32i a7, a1, 4 # 4-byte Folded Reload
; XTENSA-NEXT:    bltu a14, a7, .LBB32_8
; XTENSA-NEXT:  # %bb.7:
; XTENSA-NEXT:    or a11, a12, a12
; XTENSA-NEXT:  .LBB32_8:
; XTENSA-NEXT:    or a7, a15, a15
; XTENSA-NEXT:    l32i a6, a1, 24 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a5, a1, 12 # 4-byte Folded Reload
; XTENSA-NEXT:    bltu a5, a6, .LBB32_10
; XTENSA-NEXT:  # %bb.9:
; XTENSA-NEXT:    or a7, a12, a12
; XTENSA-NEXT:  .LBB32_10:
; XTENSA-NEXT:    l32i a6, a1, 8 # 4-byte Folded Reload
; XTENSA-NEXT:    add a7, a6, a7
; XTENSA-NEXT:    add a11, a7, a11
; XTENSA-NEXT:    bltu a10, a8, .LBB32_12
; XTENSA-NEXT:  # %bb.11:
; XTENSA-NEXT:    or a15, a12, a12
; XTENSA-NEXT:  .LBB32_12:
; XTENSA-NEXT:    l32i a8, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    add a8, a3, a8
; XTENSA-NEXT:    add a8, a8, a15
; XTENSA-NEXT:    add a8, a11, a8
; XTENSA-NEXT:    add a3, a8, a9
; XTENSA-NEXT:    l32i a15, a1, 36 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a14, a1, 40 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a13, a1, 44 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a12, a1, 48 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a0, a1, 52 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 64
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulhsu_i64:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    addi a8, a1, -16
; XTENSA-MUL-NEXT:    or a1, a8, a8
; XTENSA-MUL-NEXT:    s32i a12, a1, 12 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a13, a1, 8 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a14, a1, 4 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    s32i a15, a1, 0 # 4-byte Folded Spill
; XTENSA-MUL-NEXT:    muluh a8, a2, a4
; XTENSA-MUL-NEXT:    mull a7, a3, a4
; XTENSA-MUL-NEXT:    add a8, a7, a8
; XTENSA-MUL-NEXT:    movi a10, 0
; XTENSA-MUL-NEXT:    movi a9, 1
; XTENSA-MUL-NEXT:    or a11, a9, a9
; XTENSA-MUL-NEXT:    bltu a8, a7, .LBB32_2
; XTENSA-MUL-NEXT:  # %bb.1:
; XTENSA-MUL-NEXT:    or a11, a10, a10
; XTENSA-MUL-NEXT:  .LBB32_2:
; XTENSA-MUL-NEXT:    muluh a7, a3, a4
; XTENSA-MUL-NEXT:    add a11, a7, a11
; XTENSA-MUL-NEXT:    mull a7, a2, a5
; XTENSA-MUL-NEXT:    add a6, a7, a8
; XTENSA-MUL-NEXT:    or a8, a9, a9
; XTENSA-MUL-NEXT:    bltu a6, a7, .LBB32_4
; XTENSA-MUL-NEXT:  # %bb.3:
; XTENSA-MUL-NEXT:    or a8, a10, a10
; XTENSA-MUL-NEXT:  .LBB32_4:
; XTENSA-MUL-NEXT:    muluh a7, a2, a5
; XTENSA-MUL-NEXT:    add a8, a7, a8
; XTENSA-MUL-NEXT:    add a12, a11, a8
; XTENSA-MUL-NEXT:    mull a14, a3, a5
; XTENSA-MUL-NEXT:    add a15, a14, a12
; XTENSA-MUL-NEXT:    srai a6, a5, 31
; XTENSA-MUL-NEXT:    mull a7, a6, a2
; XTENSA-MUL-NEXT:    add a8, a15, a7
; XTENSA-MUL-NEXT:    or a4, a9, a9
; XTENSA-MUL-NEXT:    bgeu a8, a15, .LBB32_9
; XTENSA-MUL-NEXT:  # %bb.5:
; XTENSA-MUL-NEXT:    or a13, a9, a9
; XTENSA-MUL-NEXT:    bgeu a15, a14, .LBB32_10
; XTENSA-MUL-NEXT:  .LBB32_6:
; XTENSA-MUL-NEXT:    bltu a12, a11, .LBB32_8
; XTENSA-MUL-NEXT:  .LBB32_7:
; XTENSA-MUL-NEXT:    or a9, a10, a10
; XTENSA-MUL-NEXT:  .LBB32_8:
; XTENSA-MUL-NEXT:    muluh a10, a3, a5
; XTENSA-MUL-NEXT:    add a9, a10, a9
; XTENSA-MUL-NEXT:    add a9, a9, a13
; XTENSA-MUL-NEXT:    mull a10, a6, a3
; XTENSA-MUL-NEXT:    muluh a11, a6, a2
; XTENSA-MUL-NEXT:    add a10, a11, a10
; XTENSA-MUL-NEXT:    add a10, a10, a7
; XTENSA-MUL-NEXT:    add a9, a9, a10
; XTENSA-MUL-NEXT:    add a3, a9, a4
; XTENSA-MUL-NEXT:    or a2, a8, a8
; XTENSA-MUL-NEXT:    l32i a15, a1, 0 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a14, a1, 4 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a13, a1, 8 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    l32i a12, a1, 12 # 4-byte Folded Reload
; XTENSA-MUL-NEXT:    addi a8, a1, 16
; XTENSA-MUL-NEXT:    or a1, a8, a8
; XTENSA-MUL-NEXT:    ret
; XTENSA-MUL-NEXT:  .LBB32_9:
; XTENSA-MUL-NEXT:    or a4, a10, a10
; XTENSA-MUL-NEXT:    or a13, a9, a9
; XTENSA-MUL-NEXT:    bltu a15, a14, .LBB32_6
; XTENSA-MUL-NEXT:  .LBB32_10:
; XTENSA-MUL-NEXT:    or a13, a10, a10
; XTENSA-MUL-NEXT:    bgeu a12, a11, .LBB32_7
; XTENSA-MUL-NEXT:    j .LBB32_8
  %1 = zext i64 %a to i128
  %2 = sext i64 %b to i128
  %3 = mul i128 %1, %2
  %4 = lshr i128 %3, 64
  %5 = trunc i128 %4 to i64
  ret i64 %5
}

define i8 @muladd_demand(i8 %x, i8 %y) nounwind {
; XTENSA-LABEL: muladd_demand:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    slli a8, a2, 1
; XTENSA-NEXT:    sub a8, a3, a8
; XTENSA-NEXT:    movi a9, 15
; XTENSA-NEXT:    and a2, a8, a9
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muladd_demand:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    slli a8, a2, 1
; XTENSA-MUL-NEXT:    sub a8, a3, a8
; XTENSA-MUL-NEXT:    movi a9, 15
; XTENSA-MUL-NEXT:    and a2, a8, a9
; XTENSA-MUL-NEXT:    ret
  %m = mul i8 %x, 14
  %a = add i8 %y, %m
  %r = and i8 %a, 15
  ret i8 %r
}

define i8 @mulsub_demand(i8 %x, i8 %y) nounwind {
; XTENSA-LABEL: mulsub_demand:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addx2 a8, a2, a3
; XTENSA-NEXT:    movi a9, 15
; XTENSA-NEXT:    and a2, a8, a9
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulsub_demand:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    addx2 a8, a2, a3
; XTENSA-MUL-NEXT:    movi a9, 15
; XTENSA-MUL-NEXT:    and a2, a8, a9
; XTENSA-MUL-NEXT:    ret
  %m = mul i8 %x, 14
  %a = sub i8 %y, %m
  %r = and i8 %a, 15
  ret i8 %r
}

define i8 @muladd_demand_2(i8 %x, i8 %y) nounwind {
; XTENSA-LABEL: muladd_demand_2:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    slli a8, a2, 1
; XTENSA-NEXT:    sub a8, a3, a8
; XTENSA-NEXT:    movi a9, -16
; XTENSA-NEXT:    or a2, a8, a9
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: muladd_demand_2:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    slli a8, a2, 1
; XTENSA-MUL-NEXT:    sub a8, a3, a8
; XTENSA-MUL-NEXT:    movi a9, -16
; XTENSA-MUL-NEXT:    or a2, a8, a9
; XTENSA-MUL-NEXT:    ret
  %m = mul i8 %x, 14
  %a = add i8 %y, %m
  %r = or i8 %a, 240
  ret i8 %r
}

define i8 @mulsub_demand_2(i8 %x, i8 %y) nounwind {
; XTENSA-LABEL: mulsub_demand_2:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addx2 a8, a2, a3
; XTENSA-NEXT:    movi a9, -16
; XTENSA-NEXT:    or a2, a8, a9
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mulsub_demand_2:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    addx2 a8, a2, a3
; XTENSA-MUL-NEXT:    movi a9, -16
; XTENSA-MUL-NEXT:    or a2, a8, a9
; XTENSA-MUL-NEXT:    ret
  %m = mul i8 %x, 14
  %a = sub i8 %y, %m
  %r = or i8 %a, 240
  ret i8 %r
}

define signext i32 @mul_imm_2(i32 %a) nounwind {
; XTENSA-LABEL: mul_imm_2:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    slli a2, a2, 1
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul_imm_2:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    slli a2, a2, 1
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 2
  ret i32 %1
}

define signext i32 @mul_imm_1024(i32 %a) nounwind {
; XTENSA-LABEL: mul_imm_1024:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    slli a2, a2, 10
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul_imm_1024:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    slli a2, a2, 10
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 1024
  ret i32 %1
}

define signext i32 @mul_imm_16384(i32 %a) nounwind {
; XTENSA-LABEL: mul_imm_16384:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    slli a2, a2, 14
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul_imm_16384:
; XTENSA-MUL:       # %bb.0:
; XTENSA-MUL-NEXT:    slli a2, a2, 14
; XTENSA-MUL-NEXT:    ret
  %1 = mul i32 %a, 16384
  ret i32 %1
}

define <4 x i32> @mul_vec_splat_constant(<4 x i32> %a) {
; XTENSA-LABEL: mul_vec_splat_constant:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    slli a2, a2, 2
; XTENSA-NEXT:    slli a3, a3, 2
; XTENSA-NEXT:    slli a4, a4, 2
; XTENSA-NEXT:    slli a5, a5, 2
; XTENSA-NEXT:    ret
;
; XTENSA-MUL-LABEL: mul_vec_splat_constant:
; XTENSA-MUL:         .cfi_startproc
; XTENSA-MUL-NEXT:  # %bb.0:
; XTENSA-MUL-NEXT:    slli a2, a2, 2
; XTENSA-MUL-NEXT:    slli a3, a3, 2
; XTENSA-MUL-NEXT:    slli a4, a4, 2
; XTENSA-MUL-NEXT:    slli a5, a5, 2
; XTENSA-MUL-NEXT:    ret
  %mul = mul <4 x i32> %a, <i32 4, i32 4, i32 4, i32 4>
  ret <4 x i32> %mul
}
