; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa -mattr=+fp -verify-machineinstrs < %s | FileCheck -check-prefix=XTENSA %s

define float @fadd_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fadd_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %res = fadd float %a, %b
  ret float %res
}

define float @fsub_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fsub_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    sub.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %res = fsub float %a, %b
  ret float %res
}

define float @fmul_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fmul_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    mul.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %res = fmul float %a, %b
  ret float %res
}

define float @fdiv_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fdiv_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI3_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = fdiv float %a, %b
  ret float %res
}

declare float @llvm.sqrt.f32(float)

define float @fsqrt_s(float %a) nounwind {
; XTENSA-LABEL: fsqrt_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI4_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.sqrt.f32(float %a)
  ret float %res
}

declare float @llvm.fabs.f32(float)

define float @fabs_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fabs_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    abs.s f9, f8
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %fa = fadd float %a, %b
  %call_res = call float @llvm.fabs.f32(float %fa)
  %res = fadd float %call_res, %fa
  ret float %res
}

declare float @llvm.minnum.f32(float, float)

define float @fmin_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fmin_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI6_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.minnum.f32(float %a, float %b)
  ret float %res
}

declare float @llvm.maxnum.f32(float, float)

define float @fmax_s(float %a, float %b) nounwind {
; XTENSA-LABEL: fmax_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI7_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.maxnum.f32(float %a, float %b)
  ret float %res
}

declare float @llvm.fma.f32(float, float, float)

define float @fmadd_s(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fmadd_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    madd.s f10, f9, f8
; XTENSA-NEXT:    rfr a2, f10
; XTENSA-NEXT:    ret
  %res = call float @llvm.fma.f32(float %a, float %b, float %c)
  ret float %res
}

define float @fmsub_s(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fmsub_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI9_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a4
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    neg.s f8, f8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    wfr f10, a2
; XTENSA-NEXT:    madd.s f8, f10, f9
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %c_ = fadd float 0.0, %c ; avoid negation using xor
  %negc = fsub float -0.0, %c_
  %res = call float @llvm.fma.f32(float %a, float %b, float %negc)
  ret float %res
}

define float @fnmadd_s(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmadd_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI10_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    add.s f9, f9, f8
; XTENSA-NEXT:    neg.s f9, f9
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    add.s f8, f10, f8
; XTENSA-NEXT:    neg.s f8, f8
; XTENSA-NEXT:    wfr f10, a3
; XTENSA-NEXT:    madd.s f8, f9, f10
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %a_ = fadd float 0.0, %a
  %c_ = fadd float 0.0, %c
  %nega = fsub float -0.0, %a_
  %negc = fsub float -0.0, %c_
  %res = call float @llvm.fma.f32(float %nega, float %b, float %negc)
  ret float %res
}

define float @fnmadd_s_2(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmadd_s_2:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI11_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    add.s f9, f9, f8
; XTENSA-NEXT:    neg.s f9, f9
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    add.s f8, f10, f8
; XTENSA-NEXT:    neg.s f8, f8
; XTENSA-NEXT:    wfr f10, a2
; XTENSA-NEXT:    madd.s f8, f10, f9
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %b_ = fadd float 0.0, %b
  %c_ = fadd float 0.0, %c
  %negb = fsub float -0.0, %b_
  %negc = fsub float -0.0, %c_
  %res = call float @llvm.fma.f32(float %a, float %negb, float %negc)
  ret float %res
}

define float @fnmadd_s_3(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmadd_s_3:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    madd.s f10, f9, f8
; XTENSA-NEXT:    rfr a8, f10
; XTENSA-NEXT:    l32r a9, .LCPI12_0
; XTENSA-NEXT:    xor a2, a8, a9
; XTENSA-NEXT:    ret
  %res = call float @llvm.fma.f32(float %a, float %b, float %c)
  %neg = fneg float %res
  ret float %neg
}

define float @fnmadd_nsz(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmadd_nsz:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    madd.s f10, f9, f8
; XTENSA-NEXT:    rfr a8, f10
; XTENSA-NEXT:    l32r a9, .LCPI13_0
; XTENSA-NEXT:    xor a2, a8, a9
; XTENSA-NEXT:    ret
  %res = call nsz float @llvm.fma.f32(float %a, float %b, float %c)
  %neg = fneg nsz float %res
  ret float %neg
}

define float @fnmsub_s(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmsub_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI14_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    neg.s f8, f8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    madd.s f10, f8, f9
; XTENSA-NEXT:    rfr a2, f10
; XTENSA-NEXT:    ret
  %a_ = fadd float 0.0, %a
  %nega = fsub float -0.0, %a_
  %res = call float @llvm.fma.f32(float %nega, float %b, float %c)
  ret float %res
}

define float @fnmsub_s_2(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmsub_s_2:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI15_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    neg.s f8, f8
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    madd.s f10, f9, f8
; XTENSA-NEXT:    rfr a2, f10
; XTENSA-NEXT:    ret
  %b_ = fadd float 0.0, %b
  %negb = fsub float -0.0, %b_
  %res = call float @llvm.fma.f32(float %a, float %negb, float %c)
  ret float %res
}

define float @fmadd_s_contract(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fmadd_s_contract:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    wfr f8, a3
; XTENSA-NEXT:    wfr f9, a2
; XTENSA-NEXT:    mul.s f8, f9, f8
; XTENSA-NEXT:    wfr f9, a4
; XTENSA-NEXT:    add.s f8, f8, f9
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %fm = fmul contract float %a, %b
  %res = fadd contract float %fm, %c
  ret float %res
}

define float @fmsub_s_contract(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fmsub_s_contract:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI17_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a4
; XTENSA-NEXT:    add.s f8, f9, f8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    wfr f10, a2
; XTENSA-NEXT:    mul.s f9, f10, f9
; XTENSA-NEXT:    sub.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %c_ = fadd float 0.0, %c ; avoid negation using xor
  %fm = fmul contract float %a, %b
  %res = fsub contract float %fm, %c_
  ret float %res
}

define float @fnmadd_s_contract(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmadd_s_contract:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI18_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    add.s f9, f9, f8
; XTENSA-NEXT:    wfr f10, a2
; XTENSA-NEXT:    add.s f10, f10, f8
; XTENSA-NEXT:    mul.s f9, f10, f9
; XTENSA-NEXT:    neg.s f9, f9
; XTENSA-NEXT:    wfr f10, a4
; XTENSA-NEXT:    add.s f8, f10, f8
; XTENSA-NEXT:    sub.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %a_ = fadd float 0.0, %a ; avoid negation using xor
  %b_ = fadd float 0.0, %b ; avoid negation using xor
  %c_ = fadd float 0.0, %c ; avoid negation using xor
  %fm = fmul contract float %a_, %b_
  %fn = fneg float %fm
  %res = fsub contract float %fn, %c_
  ret float %res
}

define float @fnmsub_s_contract(float %a, float %b, float %c) nounwind {
; XTENSA-LABEL: fnmsub_s_contract:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI19_0
; XTENSA-NEXT:    wfr f8, a8
; XTENSA-NEXT:    wfr f9, a3
; XTENSA-NEXT:    add.s f9, f9, f8
; XTENSA-NEXT:    wfr f10, a2
; XTENSA-NEXT:    add.s f8, f10, f8
; XTENSA-NEXT:    mul.s f8, f8, f9
; XTENSA-NEXT:    wfr f9, a4
; XTENSA-NEXT:    sub.s f8, f9, f8
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
  %a_ = fadd float 0.0, %a ; avoid negation using xor
  %b_ = fadd float 0.0, %b ; avoid negation using xor
  %fm = fmul contract float %a_, %b_
  %res = fsub contract float %c, %fm
  ret float %res
}

declare float @llvm.powi.f32(float, i32)

define float @powi_f32(float %a, i32 %b) nounwind {
; XTENSA-LABEL: powi_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI20_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret

  %res = call float @llvm.powi.f32(float %a, i32 %b)
  ret float %res
}

declare float @llvm.sin.f32(float)

define float @sin_f32(float %a) nounwind {
; XTENSA-LABEL: sin_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI21_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.sin.f32(float %a)
  ret float %res
}

declare float @llvm.cos.f32(float)

define float @cos_f32(float %a) nounwind {
; XTENSA-LABEL: cos_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI22_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.cos.f32(float %a)
  ret float %res
}
declare float @llvm.exp.f32(float)

define float @exp_f32(float %a) nounwind {
; XTENSA-LABEL: exp_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI23_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.exp.f32(float %a)
  ret float %res
}

define float @log_f32(float %a) nounwind {
; XTENSA-LABEL: log_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI24_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.log.f32(float %a)
  ret float %res
}

declare float @llvm.log10.f32(float)

define float @log10_f32(float %a) nounwind {
; XTENSA-LABEL: log10_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI25_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.log10.f32(float %a)
  ret float %res
}

declare float @llvm.log2.f32(float)

define float @log2_f32(float %a) nounwind {
; XTENSA-LABEL: log2_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI26_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.log2.f32(float %a)
  ret float %res
}

declare float @llvm.floor.f32(float)

define float @floor_f32(float %a) nounwind {
; XTENSA-LABEL: floor_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI27_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.floor.f32(float %a)
  ret float %res
}

declare float @llvm.ceil.f32(float)

define float @ceil_f32(float %a) nounwind {
; XTENSA-LABEL: ceil_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI28_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.ceil.f32(float %a)
  ret float %res
}
declare float @llvm.rint.f32(float)

define float @rint_f32(float %a) nounwind {
; XTENSA-LABEL: rint_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI29_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.rint.f32(float %a)
  ret float %res
}

declare float @llvm.nearbyint.f32(float)

define float @nearbyint_f32(float %a) nounwind {
; XTENSA-LABEL: nearbyint_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI30_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.nearbyint.f32(float %a)
  ret float %res
}

declare float @llvm.round.f32(float)

define float @round_f32(float %a) nounwind {
; XTENSA-LABEL: round_f32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    s32i a0, a1, 0 # 4-byte Folded Spill
; XTENSA-NEXT:    l32r a8, .LCPI31_0
; XTENSA-NEXT:    callx0 a8
; XTENSA-NEXT:    l32i a0, a1, 0 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.round.f32(float %a)
  ret float %res
}

define float @fneg_s(float %a) nounwind {
; XTENSA-LABEL: fneg_s:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    l32r a8, .LCPI32_0
; XTENSA-NEXT:    and a2, a2, a8
; XTENSA-NEXT:    ret
  %res = call float @llvm.fabs.f32(float %a)
  ret float %res
}

define i32 @fptosi(float %f) {
; XTENSA-LABEL: fptosi:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    wfr f8, a2
; XTENSA-NEXT:    trunc.s a2, f8, 0
; XTENSA-NEXT:    ret
  %conv = fptosi float %f to i32
  ret i32 %conv
}

define i32 @fptoui(float %f) {
; XTENSA-LABEL: fptoui:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    wfr f8, a2
; XTENSA-NEXT:    utrunc.s a2, f8, 0
; XTENSA-NEXT:    ret
  %conv = fptoui float %f to i32
  ret i32 %conv
}

define float @copysign_f32(float %a, float %b) {
; XTENSA-LABEL: copysign_f32:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0: # %entry
; XTENSA-NEXT:    l32r a8, .LCPI35_0
; XTENSA-NEXT:    and a8, a3, a8
; XTENSA-NEXT:    l32r a9, .LCPI35_1
; XTENSA-NEXT:    and a9, a2, a9
; XTENSA-NEXT:    wfr f8, a9
; XTENSA-NEXT:    movi a9, 0
; XTENSA-NEXT:    beq a8, a9, .LBB35_2
; XTENSA-NEXT:  # %bb.1:
; XTENSA-NEXT:    neg.s f8, f8
; XTENSA-NEXT:  .LBB35_2: # %entry
; XTENSA-NEXT:    rfr a2, f8
; XTENSA-NEXT:    ret
entry:
  %c = call float @llvm.copysign.f32(float %a, float %b)
  ret float %c
}
