/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class PDCalGray
extends PDColorSpace {
    public static final String NAME = "CalGray";
    private COSArray array;
    private COSDictionary dictionary;

    public PDCalGray() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(this.dictionary);
    }

    public PDCalGray(COSArray gray) {
        this.array = gray;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    public int getNumberOfComponents() throws IOException {
        return 1;
    }

    public String getName() {
        return NAME;
    }

    protected ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public COSBase getCOSObject() {
        return this.array;
    }

    public float getGamma() {
        float retval = 1.0f;
        COSNumber gamma = (COSNumber)this.dictionary.getDictionaryObject(COSName.getPDFName("Gamma"));
        if (gamma != null) {
            retval = gamma.floatValue();
        }
        return retval;
    }

    public void setGamma(float value) {
        this.dictionary.setItem(COSName.getPDFName("Gamma"), (COSBase)new COSFloat(value));
    }

    public PDTristimulus getWhitepoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("WhitePoint"));
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.getPDFName("WhitePoint"), (COSBase)wp);
        }
        return new PDTristimulus(wp);
    }

    public void setWhitepoint(PDTristimulus wp) {
        COSBase wpArray = wp.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.getPDFName("WhitePoint"), wpArray);
        }
    }

    public PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("BlackPoint"));
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            this.dictionary.setItem(COSName.getPDFName("BlackPoint"), (COSBase)bp);
        }
        return new PDTristimulus(bp);
    }

    public void setBlackPoint(PDTristimulus bp) {
        COSBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getCOSObject();
        }
        this.dictionary.setItem(COSName.getPDFName("BlackPoint"), bpArray);
    }
}

