/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.chunk;

import java.util.ArrayList;
import java.util.List;
import opennlp.common.morph.MorphAnalyzer;
import opennlp.common.util.Pair;
import opennlp.maxent.ContextGenerator;

public class ChunkerContextGenerator
implements ContextGenerator {
    private MorphAnalyzer _manalyzer;
    private static final boolean DEBUG = false;

    public ChunkerContextGenerator() {
        this._manalyzer = null;
    }

    public ChunkerContextGenerator(MorphAnalyzer ma) {
        this._manalyzer = ma;
    }

    public String[] getContext(Object o) {
        boolean rare = false;
        boolean all = true;
        if (o instanceof Pair) {
            rare = (Boolean)((Pair)o).b;
            all = false;
            o = ((Pair)o).a;
        }
        Object[] data = (Object[])o;
        List ls = (List)data[0];
        List tags = (List)data[1];
        List labels = (List)data[2];
        int pos = (Integer)data[3];
        String labelprevprev = null;
        String labelprev = null;
        String prevprev = null;
        String prev = null;
        String lex = null;
        String nextnext = null;
        String next = null;
        String pptag = null;
        String ptag = null;
        String nntag = null;
        String ntag = null;
        lex = (String)ls.get(pos);
        String tag = (String)tags.get(pos);
        if (ls.size() > pos + 1) {
            next = (String)ls.get(pos + 1);
            ntag = (String)tags.get(pos + 1);
            if (ChunkerContextGenerator.isEOS((String)ls.get(pos + 1))) {
                nextnext = "*SE*";
            } else if (ls.size() > pos + 2) {
                nextnext = (String)ls.get(pos + 2);
                nntag = (String)tags.get(pos + 2);
            }
        } else if (ls.size() > 1) {
            next = "*SE*";
        }
        if (pos - 1 >= 0) {
            prev = (String)ls.get(pos - 1);
            labelprev = (String)labels.get(pos - 1);
            ptag = (String)tags.get(pos - 1);
            if (pos - 2 >= 0) {
                prevprev = (String)ls.get(pos - 2);
                labelprevprev = (String)labels.get(pos - 2);
                ptag = (String)tags.get(pos - 2);
            } else {
                prevprev = "*SB*";
            }
        } else if (ls.size() > 1) {
            prev = "*SB*";
        }
        ArrayList<String> e = new ArrayList<String>();
        if (!rare || all) {
            e.add("w=" + lex);
        }
        e.add("s=" + lex.length());
        e.add("t=" + tag);
        if (ntag != null) {
            e.add("nt=" + ntag);
        }
        if (ptag != null) {
            e.add("pt=" + ptag);
        }
        if (prev != null) {
            e.add("p=" + prev);
            if (labelprev != null) {
                e.add("l=" + labelprev);
            }
            if (prevprev != null && labelprevprev != null) {
                e.add("lp=" + labelprevprev);
            }
        }
        if (next != null) {
            e.add("n=" + next);
        }
        String[] context = new String[e.size()];
        e.toArray(context);
        return context;
    }

    private static final String filterEOS(String s) {
        if (s.length() != 1) {
            return s;
        }
        char c = s.charAt(0);
        if (c == '.' || c == '?' | c == '!') {
            return "*SE*";
        }
        return s;
    }

    private static final boolean isEOS(String s) {
        if (s.length() != 1) {
            return false;
        }
        char c = s.charAt(0);
        return c == '.' || c == '?' | c == '!';
    }

    public static void main(String[] args) {
        ChunkerContextGenerator chunkerContextGenerator = new ChunkerContextGenerator();
    }
}

