/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.parse;

import java.util.Iterator;
import java.util.List;
import opennlp.common.parse.RuleGroup;
import opennlp.common.synsem.Sign;
import opennlp.grok.expression.SignHash;

public class Chart {
    protected SignHash[][] _table;
    protected int _size;
    RuleGroup _rules;

    public Chart(int s, RuleGroup _R) {
        this._rules = _R;
        this._size = s;
        this._table = new SignHash[this._size][this._size];
    }

    public boolean insert(int x, int y, Sign w, Sign[] old) {
        if (this._table[x][y] == null) {
            this._table[x][y] = new SignHash();
        }
        int s = this._table[x][y].size();
        this._table[x][y].insert(w);
        return this._table[x][y].size() > s;
    }

    protected void insertEdge(int x, int y, Sign[] signs) {
        List results = this._rules.applyRules(signs);
        Iterator resultIt = results.iterator();
        while (resultIt.hasNext()) {
            this.insert(x, y, (Sign)resultIt.next(), signs);
        }
    }

    SignHash get(int x, int y) {
        if (this._table[x][y] == null) {
            this._table[x][y] = new SignHash();
        }
        return this._table[x][y];
    }

    void set(int x, int y, SignHash wh) {
        this._table[x][y] = wh;
    }

    protected void insertCell(int x, int y) {
        if (this._table[x][y] == null) {
            return;
        }
        SignHash a = this._table[x][y];
        Sign[] sign = new Sign[1];
        SignHash newHash = new SignHash();
        Iterator i = a.values().iterator();
        while (i.hasNext()) {
            sign[0] = (Sign)i.next();
            List results = this._rules.applyRules(sign);
            Iterator resultIt = results.iterator();
            while (resultIt.hasNext()) {
                newHash.insert((Sign)resultIt.next());
            }
        }
        Iterator i2 = newHash.values().iterator();
        while (i2.hasNext()) {
            this.insert(x, y, (Sign)i2.next(), sign);
        }
    }

    protected void insertCell(int x1, int y1, int x2, int y2, int x3, int y3) {
        if (this._table[x1][y1] == null) {
            return;
        }
        if (this._table[x2][y2] == null) {
            return;
        }
        SignHash a = this._table[x1][y1];
        SignHash b = this._table[x2][y2];
        Sign[] signs = new Sign[2];
        Iterator i = a.values().iterator();
        while (i.hasNext()) {
            signs[0] = (Sign)i.next();
            Iterator j = b.values().iterator();
            while (j.hasNext()) {
                signs[1] = (Sign)j.next();
                List results = this._rules.applyRules(signs);
                Iterator resultIt = results.iterator();
                while (resultIt.hasNext()) {
                    this.insert(x3, y3, (Sign)resultIt.next(), signs);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._size) {
            int j = 0;
            while (j < this._size) {
                sb.append(this.get(i, j).size()).append('\t');
                ++j;
            }
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public void printChart() {
        int p;
        int[] sizes = new int[this._size];
        int rows = 0;
        int i = 0;
        while (i < this._size) {
            int j = i;
            while (j < this._size) {
                if (this.get(i, j).size() > sizes[i]) {
                    sizes[i] = this.get(i, j).size();
                }
                ++j;
            }
            rows += sizes[i];
            ++i;
        }
        String[][] toprint = new String[rows][this._size];
        int maxwidth = 0;
        int i2 = 0;
        int row = 0;
        while (i2 < this._size) {
            int j = 0;
            while (j < this._size) {
                int s = 0;
                while (s < sizes[i2]) {
                    SignHash cell = this.get(i2, j);
                    if (cell.size() >= s + 1) {
                        toprint[row + s][j] = ((Sign)cell.values().toArray()[s]).getCategory().toString();
                        if (toprint[row + s][j].length() > maxwidth) {
                            maxwidth = toprint[row + s][j].length();
                        }
                    }
                    ++s;
                }
                ++j;
            }
            row += sizes[i2++];
        }
        int fullwidth = this._size * (maxwidth + 3) - 1;
        System.out.print("|");
        int p2 = 0;
        while (p2 < fullwidth) {
            System.out.print("-");
            ++p2;
        }
        System.out.print("| ");
        System.out.println();
        int i3 = 0;
        int entry = sizes[0];
        int e = 0;
        while (i3 < rows) {
            if (i3 == entry) {
                System.out.print("|");
                p = 0;
                while (p < fullwidth) {
                    System.out.print("-");
                    ++p;
                }
                System.out.print("|");
                System.out.println();
                entry += sizes[++e];
            }
            System.out.print("| ");
            int j = 0;
            while (j < this._size) {
                int pad = 1 + maxwidth;
                if (toprint[i3][j] != null) {
                    System.out.print(toprint[i3][j]);
                    pad -= toprint[i3][j].length();
                }
                int p3 = 0;
                while (p3 < pad) {
                    System.out.print(" ");
                    ++p3;
                }
                System.out.print("| ");
                ++j;
            }
            System.out.println();
            ++i3;
        }
        System.out.print("|");
        p = 0;
        while (p < fullwidth) {
            System.out.print("-");
            ++p;
        }
        System.out.print("| ");
        System.out.println();
    }
}

