/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.guide;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureModel;
import org.maltparser.core.feature.FeatureModelManager;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.feature.system.FeatureEngine;
import org.maltparser.core.plugin.PluginLoader;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.GuideException;
import org.maltparser.parser.guide.decision.BranchedDecisionModel;
import org.maltparser.parser.guide.decision.DecisionModel;
import org.maltparser.parser.guide.decision.OneDecisionModel;
import org.maltparser.parser.guide.decision.SeqDecisionModel;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.MultipleDecision;
import org.maltparser.parser.history.action.SingleDecision;
import org.maltparser.parser.history.container.TableContainer;

public class SingleGuide
implements ClassifierGuide {
    private DependencyParserConfig configuration;
    private GuideHistory history;
    private DecisionModel decisionModel = null;
    private ClassifierGuide.GuideMode guideMode;
    private FeatureModelManager featureModelManager;
    private FeatureModel featureModel;
    private String guideName;

    public SingleGuide(DependencyParserConfig configuration, GuideHistory history, ClassifierGuide.GuideMode guideMode) throws MaltChainedException {
        this.setConfiguration(configuration);
        this.setHistory(history);
        this.setGuideMode(guideMode);
        this.initFeatureModelManager();
        this.initHistory();
        this.initFeatureModel();
        this.featureModel.updateCardinality();
    }

    public void addInstance(GuideDecision decision) throws MaltChainedException {
        if (this.decisionModel == null) {
            if (decision instanceof SingleDecision) {
                this.initDecisionModel((SingleDecision)decision);
            } else if (decision instanceof MultipleDecision && decision.numberOfDecisions() > 0) {
                this.initDecisionModel(((MultipleDecision)decision).getSingleDecision(0));
            }
        }
        this.decisionModel.addInstance(decision);
    }

    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        if (this.decisionModel != null) {
            this.decisionModel.finalizeSentence(dependencyGraph);
        }
    }

    public void noMoreInstances() throws MaltChainedException {
        if (this.decisionModel != null) {
            this.decisionModel.noMoreInstances();
        } else {
            this.configuration.getConfigLogger().debug("The guide cannot create any models because there is no decision model. ");
        }
    }

    public void terminate() throws MaltChainedException {
        if (this.decisionModel != null) {
            this.decisionModel.terminate();
            this.decisionModel = null;
        }
    }

    public void predict(GuideDecision decision) throws MaltChainedException {
        if (this.decisionModel == null) {
            if (decision instanceof SingleDecision) {
                this.initDecisionModel((SingleDecision)decision);
            } else if (decision instanceof MultipleDecision && decision.numberOfDecisions() > 0) {
                this.initDecisionModel(((MultipleDecision)decision).getSingleDecision(0));
            }
        }
        this.decisionModel.predict(decision);
    }

    public FeatureVector predictExtract(GuideDecision decision) throws MaltChainedException {
        if (this.decisionModel == null) {
            if (decision instanceof SingleDecision) {
                this.initDecisionModel((SingleDecision)decision);
            } else if (decision instanceof MultipleDecision && decision.numberOfDecisions() > 0) {
                this.initDecisionModel(((MultipleDecision)decision).getSingleDecision(0));
            }
        }
        return this.decisionModel.predictExtract(decision);
    }

    public FeatureVector extract() throws MaltChainedException {
        return this.decisionModel.extract();
    }

    public boolean predictFromKBestList(GuideDecision decision) throws MaltChainedException {
        if (this.decisionModel != null) {
            return this.decisionModel.predictFromKBestList(decision);
        }
        throw new GuideException("The decision model cannot be found. ");
    }

    public DecisionModel getDecisionModel() {
        return this.decisionModel;
    }

    public DependencyParserConfig getConfiguration() {
        return this.configuration;
    }

    public GuideHistory getHistory() {
        return this.history;
    }

    public ClassifierGuide.GuideMode getGuideMode() {
        return this.guideMode;
    }

    public FeatureModelManager getFeatureModelManager() {
        return this.featureModelManager;
    }

    protected void setConfiguration(DependencyParserConfig configuration) {
        this.configuration = configuration;
    }

    protected void setHistory(GuideHistory actionHistory) {
        this.history = actionHistory;
    }

    protected void setGuideMode(ClassifierGuide.GuideMode guideMode) {
        this.guideMode = guideMode;
    }

    protected void initHistory() throws MaltChainedException {
        Class kBestListClass = null;
        int kBestSize = 1;
        if (this.guideMode == ClassifierGuide.GuideMode.CLASSIFY) {
            kBestListClass = (Class)this.getConfiguration().getOptionValue("guide", "kbest_type");
            kBestSize = (Integer)this.getConfiguration().getOptionValue("guide", "kbest");
        }
        this.history.setKBestListClass(kBestListClass);
        this.history.setKBestSize(kBestSize);
        this.history.setSeparator(this.getConfiguration().getOptionValue("guide", "classitem_separator").toString());
    }

    protected void initDecisionModel(SingleDecision decision) throws MaltChainedException {
        Class decisionModelClass = null;
        if (decision.getRelationToNextDecision() == TableContainer.RelationToNextDecision.SEQUANTIAL) {
            decisionModelClass = SeqDecisionModel.class;
        } else if (decision.getRelationToNextDecision() == TableContainer.RelationToNextDecision.BRANCHED) {
            decisionModelClass = BranchedDecisionModel.class;
        } else if (decision.getRelationToNextDecision() == TableContainer.RelationToNextDecision.NONE) {
            decisionModelClass = OneDecisionModel.class;
        }
        if (decisionModelClass == null) {
            throw new GuideException("Could not find an appropriate decision model for the relation to the next decision");
        }
        try {
            Class[] argTypes = new Class[]{ClassifierGuide.class, FeatureModel.class};
            Object[] arguments = new Object[]{this, this.featureModel};
            Constructor constructor = decisionModelClass.getConstructor(argTypes);
            this.decisionModel = (DecisionModel)constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InstantiationException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
        catch (IllegalAccessException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InvocationTargetException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
    }

    protected void initFeatureModelManager() throws MaltChainedException {
        FeatureEngine system = new FeatureEngine();
        system.load("/appdata/features/ParserFeatureSystem.xml");
        system.load(PluginLoader.instance());
        this.featureModelManager = new FeatureModelManager(system, this.getConfiguration().getConfigurationDir());
    }

    protected void initFeatureModel() throws MaltChainedException {
        String featureModelFileName = this.getConfiguration().getOptionValue("guide", "features").toString().trim();
        if (featureModelFileName.endsWith(".par")) {
            String markingStrategy = this.getConfiguration().getOptionValue("pproj", "marking_strategy").toString().trim();
            String coveredRoot = this.getConfiguration().getOptionValue("pproj", "covered_root").toString().trim();
            this.featureModelManager.loadParSpecification(featureModelFileName, markingStrategy, coveredRoot);
        } else {
            this.featureModelManager.loadSpecification(featureModelFileName);
        }
        if (this.getConfiguration().getConfigLogger().isInfoEnabled()) {
            this.getConfiguration().getConfigLogger().info("  Feature model        : " + featureModelFileName + "\n");
            if (this.getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
                this.getConfiguration().getConfigLogger().info("  Learner              : " + this.getConfiguration().getOptionValueString("guide", "learner").toString() + "\n");
            } else {
                this.getConfiguration().getConfigLogger().info("  Classifier           : " + this.getConfiguration().getOptionValueString("guide", "learner") + "\n");
            }
        }
        this.featureModel = this.getFeatureModelManager().getFeatureModel(this.getConfiguration().getOptionValue("guide", "features").toString(), 0, this.getConfiguration().getRegistry());
        if (this.getGuideMode() == ClassifierGuide.GuideMode.BATCH && this.getConfiguration().getConfigurationDir().getInfoFileWriter() != null) {
            try {
                this.getConfiguration().getConfigurationDir().getInfoFileWriter().write("\nFEATURE MODEL\n");
                this.getConfiguration().getConfigurationDir().getInfoFileWriter().write(this.featureModel.toString());
                this.getConfiguration().getConfigurationDir().getInfoFileWriter().flush();
            }
            catch (IOException e) {
                throw new GuideException("Could not write feature model specification to configuration information file. ", e);
            }
        }
    }

    public String getGuideName() {
        return this.guideName;
    }

    public void setGuideName(String guideName) {
        this.guideName = guideName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

