use 5.014;

use strict;
use warnings;
use routines;

use Test::Auto;
use Test::More;

=name

ore

=cut

=abstract

Sugar for Perl 5 one-liners

=cut

=synopsis

  BEGIN {
    $ENV{New_File_Temp} = 'ft';
  }

  use ore;

  $ft

=cut

=description

This package provides automatic object instantiation based on environment
variables. This package exists because I was bored and inspired by L<new>.

Simple command-line example with object instantiation:

  $ New_File_Temp=ft perl -More -e 'dd $ft'

  # "File::Temp"

Another simple command-line example returning a L<Data::Object::Space> object:

  $ Use_DBI=dbi perl -More -e 'dd $dbi->children'

  # [
  #   ...,
  #   bless(do{\(my $o = "DBI/DBD")}, "Data::Object::Space"),
  #   bless(do{\(my $o = "DBI/Profile")}, "Data::Object::Space"),
  #   bless(do{\(my $o = "DBI/ProfileData")}, "Data::Object::Space"),
  #   bless(do{\(my $o = "DBI/ProfileDumper")}, "Data::Object::Space"),
  #   ...,
  # ]

=cut

package main;

my $test = testauto(__FILE__);

my $subs = $test->standard;

$subs->synopsis(fun($tryable) {
  ok my $result = $tryable->result;
  ok $result->isa('File::Temp');

  $result
});

ok 1 and done_testing;
