#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Vectors._VectorInitialisationFromHDF5 import _VectorInitialisationFromHDF5
from xpdeint.Geometry.SplitUniformDimensionRepresentation import SplitUniformDimensionRepresentation
from xpdeint.Geometry.NonUniformDimensionRepresentation import NonUniformDimensionRepresentation

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1484975073.037241
__CHEETAH_genTimestamp__ = 'Sat Jan 21 16:04:33 2017'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-2.2.3/xpdeint/Vectors/VectorInitialisationFromHDF5.tmpl'
__CHEETAH_srcLastModified__ = 'Fri May 25 16:17:13 2012'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class VectorInitialisationFromHDF5(_VectorInitialisationFromHDF5):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(VectorInitialisationFromHDF5, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Vector initialisation from a HDF5 file at line 27, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''Vector initialisation from a HDF5 file''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def initialiseVector(self, **KWS):



        ## CHEETAH: generated from @def initialiseVector at line 29, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        basis = VFFSL(SL,"vector.initialBasis",True)
        field = VFFSL(SL,"vector.field",True)
        dimensionOffsets = {}
        # 
        initialisationCodeBlock = VFFSL(SL,"codeBlocks",True)['initialisation']
        write(u'''// HDF5 initialisation has three stages.
// 1. Initialise the vector to zero.
// 2. Execute any CDATA code if there is any.
// 3. Read data from the HDF5 file.

{
  // Stage 1 of initialisation
  bzero(_active_''')
        _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 43, col 17
        if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 43, col 17.
        write(u''', sizeof(''')
        _v = VFFSL(SL,"vector.type",True) # u'${vector.type}' on line 43, col 38
        if _v is not None: write(_filter(_v, rawExpr=u'${vector.type}')) # from line 43, col 38.
        write(u''') * ''')
        _v = VFFSL(SL,"vector.allocSize",True) # u'${vector.allocSize}' on line 43, col 56
        if _v is not None: write(_filter(_v, rawExpr=u'${vector.allocSize}')) # from line 43, col 56.
        write(u''');
''')
        if VFN(VFFSL(SL,"initialisationCodeBlock.codeString",True),"isspace",False)(): # generated from line 44, col 3
            write(u'''  // There is no stage 2
''')
        else: # generated from line 46, col 3
            vectorOverrides = []
            if VFFSL(SL,"vector.integratingComponents",True): # generated from line 48, col 5
                vectorOverrides.append(VFFSL(SL,"vector",True))
            write(u'''  // Stage 2 of initialisation
  ''')
            _v = VFN(VFFSL(SL,"initialisationCodeBlock",True),"loop",False)(self.insideInitialisationLoops, vectorOverrides=vectorOverrides) # u'${initialisationCodeBlock.loop(self.insideInitialisationLoops, vectorOverrides=vectorOverrides), autoIndent=True}' on line 52, col 3
            if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u'${initialisationCodeBlock.loop(self.insideInitialisationLoops, vectorOverrides=vectorOverrides), autoIndent=True}')) # from line 52, col 3.
        write(u'''}

htri_t result;
hid_t hdf5_file = H5Fopen("''')
        _v = VFFSL(SL,"filename",True) # u'${filename}' on line 57, col 28
        if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 57, col 28.
        write(u'''", H5F_ACC_RDONLY, H5P_DEFAULT);
if (hdf5_file < 0) {
  _LOG(_ERROR_LOG_LEVEL, "Unable to open input HDF5 file \'''')
        _v = VFFSL(SL,"filename",True) # u'${filename}' on line 59, col 59
        if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 59, col 59.
        write(u'''\'. Does it exist?\\n");
}
hid_t hdf5_parent = 0;
''')
        if VFFSL(SL,"groupName",True): # generated from line 62, col 3
            write(u'''if ((result = H5Lexists(hdf5_file, "''')
            _v = VFFSL(SL,"groupName",True) # u'${groupName}' on line 63, col 37
            if _v is not None: write(_filter(_v, rawExpr=u'${groupName}')) # from line 63, col 37.
            write(u'''", H5P_DEFAULT)) > 0) {
  hdf5_parent = H5Gopen(hdf5_file, "''')
            _v = VFFSL(SL,"groupName",True) # u'${groupName}' on line 64, col 37
            if _v is not None: write(_filter(_v, rawExpr=u'${groupName}')) # from line 64, col 37.
            write(u'''");
} else if (!result) {
  _LOG(_ERROR_LOG_LEVEL, "Unable to find group \'''')
            _v = VFFSL(SL,"groupName",True) # u'${groupName}' on line 66, col 49
            if _v is not None: write(_filter(_v, rawExpr=u'${groupName}')) # from line 66, col 49.
            write(u"""' in HDF5 file '""")
            _v = VFFSL(SL,"filename",True) # u'${filename}' on line 66, col 77
            if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 66, col 77.
            write(u'''\'.\\n");
} else {
  _LOG(_ERROR_LOG_LEVEL, "Unable to determine if group \'''')
            _v = VFFSL(SL,"groupName",True) # u'${groupName}' on line 68, col 57
            if _v is not None: write(_filter(_v, rawExpr=u'${groupName}')) # from line 68, col 57.
            write(u"""' exists in HDF5 file '""")
            _v = VFFSL(SL,"filename",True) # u'${filename}' on line 68, col 92
            if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 68, col 92.
            write(u'''\'. Is the file corrupt?\\n");
}
''')
        else: # generated from line 70, col 3
            write(u'''if ((result = H5Lexists(hdf5_file, "/1", H5P_DEFAULT)) > 0) {
  hdf5_parent = H5Gopen(hdf5_file, "/1");
} else if (!result) {
  hdf5_parent = hdf5_file;
} else {
  _LOG(_ERROR_LOG_LEVEL, "Unable to determine if group \'/1\' exists in HDF5 file \'''')
            _v = VFFSL(SL,"filename",True) # u'${filename}' on line 76, col 82
            if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 76, col 82.
            write(u'''\'. Is the file corrupt?\\n");
}
''')
        write(u'''
''')
        dimCount = len(field.dimensions)
        write(u'''hsize_t file_dims[''')
        _v = VFFSL(SL,"dimCount",True) # u'${dimCount}' on line 81, col 19
        if _v is not None: write(_filter(_v, rawExpr=u'${dimCount}')) # from line 81, col 19.
        write(u'''];

''')
        for dimNum, dim in enumerate(field.dimensions): # generated from line 83, col 3
            dimRep = dim.inBasis(VFFSL(SL,"vector.initialBasis",True))
            write(u'''hid_t dataset_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 85, col 15
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 85, col 15.
            write(u''';
if ((result = H5Lexists(hdf5_parent, "''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 86, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 86, col 39.
            write(u'''", H5P_DEFAULT))>0)
  dataset_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 87, col 11
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 87, col 11.
            write(u''' = H5Dopen(hdf5_parent, "''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 87, col 50
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 87, col 50.
            write(u'''");
else if (!result)
  _LOG(_ERROR_LOG_LEVEL, "Error: Unable to find dimension \'''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 89, col 60
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 89, col 60.
            write(u'''\' in HDF5 file.\\n");
else
  _LOG(_ERROR_LOG_LEVEL, "Error: Unable to determine if dimension \'''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 91, col 68
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 91, col 68.
            write(u'''\' exists in HDF5 file. Is the file corrupt?\\n");
hid_t dataspace_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 92, col 17
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 92, col 17.
            write(u''' = H5Dget_space(dataset_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 92, col 55
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 92, col 55.
            write(u''');
file_dims[''')
            _v = VFFSL(SL,"dimNum",True) # u'$dimNum' on line 93, col 11
            if _v is not None: write(_filter(_v, rawExpr=u'$dimNum')) # from line 93, col 11.
            write(u'''] = H5Sget_simple_extent_npoints(dataspace_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 93, col 61
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 93, col 61.
            write(u''');
''')
            _v = VFFSL(SL,"dimRep.type",True) # u'${dimRep.type}' on line 94, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.type}')) # from line 94, col 1.
            write(u'''* ''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 94, col 17
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 94, col 17.
            write(u'''_inputdata = (''')
            _v = VFFSL(SL,"dimRep.type",True) # u'${dimRep.type}' on line 94, col 45
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.type}')) # from line 94, col 45.
            write(u'''*)xmds_malloc(file_dims[''')
            _v = VFFSL(SL,"dimNum",True) # u'${dimNum}' on line 94, col 83
            if _v is not None: write(_filter(_v, rawExpr=u'${dimNum}')) # from line 94, col 83.
            write(u'''] * sizeof(''')
            _v = VFFSL(SL,"dimRep.type",True) # u'${dimRep.type}' on line 94, col 103
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.type}')) # from line 94, col 103.
            write(u'''));
''')
            dataType = {'real': 'H5T_NATIVE_REAL', 'long': 'H5T_NATIVE_LONG'}[VFFSL(SL,"dimRep.type",True)]
            write(u'''H5Dread(dataset_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 96, col 17
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 96, col 17.
            write(u''', ''')
            _v = VFFSL(SL,"dataType",True) # u'$dataType' on line 96, col 33
            if _v is not None: write(_filter(_v, rawExpr=u'$dataType')) # from line 96, col 33.
            write(u''', H5S_ALL, H5S_ALL, H5P_DEFAULT, ''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 96, col 75
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 96, col 75.
            write(u'''_inputdata);
''')
            if isinstance(dimRep, SplitUniformDimensionRepresentation): # generated from line 97, col 5
                dimArrayName = ''.join([str(VFFSL(SL,"dimRep.name",True)),u'_data'])
                _v = VFFSL(SL,"dimRep.type",True) # u'${dimRep.type}' on line 99, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.type}')) # from line 99, col 1.
                write(u'''* ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 99, col 17
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 99, col 17.
                write(u''' = (''')
                _v = VFFSL(SL,"dimRep.type",True) # u'${dimRep.type}' on line 99, col 36
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.type}')) # from line 99, col 36.
                write(u'''*)xmds_malloc(''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 99, col 64
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 99, col 64.
                write(u''' * sizeof(''')
                _v = VFFSL(SL,"dimRep.type",True) # u'${dimRep.type}' on line 99, col 97
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.type}')) # from line 99, col 97.
                write(u'''));
for (long _i0 = 0; _i0 < ''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 100, col 26
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 100, col 26.
                write(u'''; _i0++) {
  ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 101, col 3
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 101, col 3.
                write(u'''[_i0] = ''')
                _v = VFFSL(SL,"dimRep.arrayName",True) # u'${dimRep.arrayName}' on line 101, col 26
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.arrayName}')) # from line 101, col 26.
                write(u'''[(_i0 + (''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 101, col 54
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 101, col 54.
                write(u'''+1)/2) % ''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 101, col 86
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 101, col 86.
                write(u'''];
}
''')
            else: # generated from line 103, col 5
                dimArrayName = dimRep.arrayName
            if VFFSL(SL,"geometryMatchingMode",True) == 'strict' or isinstance(dimRep, NonUniformDimensionRepresentation): # generated from line 106, col 5
                write(u'''for (long _i0 = 0; _i0 < ''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 107, col 26
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 107, col 26.
                write(u'''-1; _i0++) {
  real step = ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 108, col 15
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 108, col 15.
                write(u'''[_i0+1] - ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 108, col 40
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 108, col 40.
                write(u'''[_i0];
  if (abs(''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 109, col 11
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 109, col 11.
                write(u'''[_i0] - ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 109, col 34
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 109, col 34.
                write(u'''_inputdata[_i0]) > 0.01 * step) {
    // _LOG will cause the simulation to exit
    _LOG(_ERROR_LOG_LEVEL, "Geometry matching mode is strict for dimension \'''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 111, col 77
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 111, col 77.
                write(u'''\'.\\n"
                           "This means that the coordinates must be the same as for the input grid.\\n"
                           "The problem was found at input_''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 113, col 60
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 113, col 60.
                write(u''': %e, simulation_''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 113, col 91
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 113, col 91.
                write(u''': %e, difference: %e\\n",
                           (real)''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 114, col 34
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 114, col 34.
                write(u'''_inputdata[_i0], (real)''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 114, col 71
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 114, col 71.
                write(u'''[_i0], (real)''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 114, col 99
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 114, col 99.
                write(u'''_inputdata[_i0] - ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 114, col 131
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 114, col 131.
                write(u'''[_i0]);
  }
}
''')
            else: # generated from line 117, col 5
                #  Here we implement any checks required for 'loose' geometryMatchingMode
                #  We know that the dimension is uniform, therefore we should first check the deltas.
                write(u'''// Check that the deltas are the same to within 0.1%
real ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 121, col 6
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 121, col 6.
                write(u'''_step = ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 121, col 28
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 121, col 28.
                write(u'''[1] - ''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 121, col 49
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 121, col 49.
                write(u'''[0];
real ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 122, col 6
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 122, col 6.
                write(u'''_inputdata_step = ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 122, col 38
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 122, col 38.
                write(u'''_inputdata[1] - ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 122, col 68
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 122, col 68.
                write(u'''_inputdata[0];
if (abs(''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 123, col 9
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 123, col 9.
                write(u'''_step - ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 123, col 31
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 123, col 31.
                write(u'''_inputdata_step) > 1e-3*''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 123, col 69
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 123, col 69.
                write(u'''_step) {
  // _LOG will cause the simulation to exit
  _LOG(_ERROR_LOG_LEVEL, "The step size in the \'''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 125, col 49
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 125, col 49.
                write(u'''\' dimension of the input data and simulation grid do not match.\\n"
                         "The step size in the \'''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 126, col 49
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 126, col 49.
                write(u'''\' dimension was %e, while the input data had step size %e.\\n",
                         (real)''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 127, col 32
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 127, col 32.
                write(u'''_step, (real)''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 127, col 59
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 127, col 59.
                write(u'''_inputdata_step);
}
// Check the input and simulation grids overlap
if ((''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 130, col 6
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 130, col 6.
                write(u'''[0] > ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 130, col 27
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 130, col 27.
                write(u'''_inputdata[file_dims[''')
                _v = VFFSL(SL,"dimNum",True) # u'${dimNum}' on line 130, col 62
                if _v is not None: write(_filter(_v, rawExpr=u'${dimNum}')) # from line 130, col 62.
                write(u''']-1]) || (''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 130, col 81
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 130, col 81.
                write(u'''[''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 130, col 97
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 130, col 97.
                write(u'''-1] < ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 130, col 126
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 130, col 126.
                write(u'''_inputdata[0])) {
  // _LOG will cause the simulation to exit
  _LOG(_ERROR_LOG_LEVEL, "The input and simulation grids do not overlap!\\n"
                         "The simulation grid runs from %e to %e, but the input grid runs from %e to %e.\\n",
                         (real)''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 134, col 32
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 134, col 32.
                write(u'''[0], (real)''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 134, col 58
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 134, col 58.
                write(u'''[''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 134, col 74
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 134, col 74.
                write(u'''-1],
                         (real)''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 135, col 32
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 135, col 32.
                write(u'''_inputdata[0], (real)''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 135, col 67
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 135, col 67.
                write(u'''_inputdata[file_dims[''')
                _v = VFFSL(SL,"dimNum",True) # u'${dimNum}' on line 135, col 102
                if _v is not None: write(_filter(_v, rawExpr=u'${dimNum}')) # from line 135, col 102.
                write(u''']-1]);
}
real ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 137, col 6
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 137, col 6.
                write(u'''_fileOffsetR = (''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 137, col 36
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 137, col 36.
                write(u'''_inputdata[0]-''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 137, col 64
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 137, col 64.
                write(u'''[0])/''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 137, col 84
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 137, col 84.
                write(u'''_step;
if (remainder(''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 138, col 15
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 138, col 15.
                write(u'''_inputdata[0]-''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 138, col 43
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 138, col 43.
                write(u'''[0], ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 138, col 63
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 138, col 63.
                write(u'''_step) > 0.01*''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 138, col 91
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 138, col 91.
                write(u'''_step) {
  _LOG(_ERROR_LOG_LEVEL, "The input and simulation grids do not overlap sufficiently!\\n"
                         "The calculated offset for the input grid from the simulation grid in the \'''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 140, col 101
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 140, col 101.
                write(u'''\' dimension is %f, and it should be integral!\\n",
                         (''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 141, col 27
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 141, col 27.
                write(u'''_inputdata[0]-''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 141, col 55
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 141, col 55.
                write(u'''[0])/''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 141, col 75
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 141, col 75.
                write(u'''_step);
}
long ''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 143, col 6
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 143, col 6.
                write(u'''_fileOffset = lround((''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 143, col 42
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 143, col 42.
                write(u'''_inputdata[0]-''')
                _v = VFFSL(SL,"dimArrayName",True) # u'${dimArrayName}' on line 143, col 70
                if _v is not None: write(_filter(_v, rawExpr=u'${dimArrayName}')) # from line 143, col 70.
                write(u'''[0])/''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 143, col 90
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 143, col 90.
                write(u'''_step);
''')
                dimensionOffsets[dimRep.name] = ''.join([str(VFFSL(SL,"dimRep.name",True)),u'_fileOffset'])
        write(u'''
''')
        processingDict = {'field': field, 'operation': 'read', 'basis': basis, 'dimensionOffsets': dimensionOffsets}
        variables = [{'vector': VFFSL(SL,"vector",True), 'arrayName': ''.join([u'_active_',str(VFFSL(SL,"vector.id",True))]), 'components': VFFSL(SL,"vector.components",True)}]
        write(u'''hid_t file_dataspace;
file_dataspace = H5Screate_simple(''')
        _v = VFFSL(SL,"len",False)(field.dimensions) # u'${len(field.dimensions)}' on line 151, col 35
        if _v is not None: write(_filter(_v, rawExpr=u'${len(field.dimensions)}')) # from line 151, col 35.
        write(u''', file_dims, NULL);
''')
        for variable in variables: # generated from line 152, col 3
            if VFFSL(SL,"variable.vector.type",True) == 'real': # generated from line 153, col 5
                variable['separatedComponents'] = list(enumerate(VFFSL(SL,"variable.components",True)))
            else: # generated from line 155, col 5
                components = []
                variable['separatedComponents'] = components
                for offset, componentName in enumerate(VFFSL(SL,"variable.components",True)): # generated from line 158, col 7
                    components.extend([(2*offset, componentName + 'R'), (2*offset+1, componentName + 'I')])
            write(u'''bool _variablesFound = false;
''')
            for offset, componentName in VFFSL(SL,"variable.separatedComponents",True): # generated from line 163, col 5
                write(u'''hid_t dataset_''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 164, col 15
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 164, col 15.
                write(u''' = 0;
if ((result = H5Lexists(hdf5_parent, "''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 165, col 39
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 165, col 39.
                write(u'''", H5P_DEFAULT))>0) {
  dataset_''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 166, col 11
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 166, col 11.
                write(u''' = H5Dopen(hdf5_parent, "''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 166, col 52
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 166, col 52.
                write(u'''");
  _variablesFound = true;
} else if (!result)
  _LOG(_WARNING_LOG_LEVEL, "Warning: Unable to find variable name \'''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 169, col 68
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 169, col 68.
                write(u'''\' in HDF5 file.\\n");
else
  _LOG(_WARNING_LOG_LEVEL, "Warning: Unable to determine if variable \'''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 171, col 71
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 171, col 71.
                write(u'''\' exists in HDF5 file. Is the file corrupt?\\n");
''')
        write(u'''
if (!_variablesFound) {
  // We haven\'t found anything. There\'s a problem with the input file.
  _LOG(_ERROR_LOG_LEVEL, "Error: None of the variables were found in the HDF5 file. Please check the file.\\n");
}
''')
        processingDict['variables'] = variables
        _v = VFFSL(SL,"processData",False)(processingDict) # u'${processData(processingDict)}' on line 180, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${processData(processingDict)}')) # from line 180, col 1.
        write(u'''

''')
        for variable in variables: # generated from line 183, col 3
            for offset, componentName in VFFSL(SL,"variable.separatedComponents",True): # generated from line 184, col 5
                write(u'''if (dataset_''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 185, col 13
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 185, col 13.
                write(u''') H5Dclose(dataset_''')
                _v = VFFSL(SL,"componentName",True) # u'${componentName}' on line 185, col 48
                if _v is not None: write(_filter(_v, rawExpr=u'${componentName}')) # from line 185, col 48.
                write(u''');
''')
        write(u'''H5Sclose(file_dataspace);

''')
        for dim in VFFSL(SL,"vector.field.dimensions",True): # generated from line 190, col 3
            dimRep = dim.inBasis(VFFSL(SL,"vector.initialBasis",True))
            if isinstance(dimRep, SplitUniformDimensionRepresentation): # generated from line 192, col 5
                write(u'''xmds_free(''')
                _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 193, col 11
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 193, col 11.
                write(u'''_data);
''')
            write(u'''xmds_free(''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 195, col 11
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 195, col 11.
            write(u'''_inputdata);
H5Sclose(dataspace_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 196, col 20
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 196, col 20.
            write(u''');
H5Dclose(dataset_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 197, col 18
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 197, col 18.
            write(u''');
''')
        write(u'''if (hdf5_parent != hdf5_file)
  H5Gclose(hdf5_parent);
H5Fclose(hdf5_file);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def insideInitialisationLoops(self, codeString, **KWS):



        ## CHEETAH: generated from @def insideInitialisationLoops($codeString) at line 205, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u"""// Stage 2 of initialisation

// The purpose of the following define is to give a (somewhat helpful) compile-time error
// if the user has attempted to use the propagation dimension variable in the initialisation
// block of a <vector> element. If they're trying to do this, what they really want is a 
// <computed_vector> instead.
#define """)
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 213, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 213, col 9.
        write(u''' Dont_use_propagation_dimension_''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 213, col 64
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 213, col 64.
        write(u'''_in_vector_element_CDATA_block___Use_a_computed_vector_instead

// ********** Initialisation code ***************
''')
        _v = VFFSL(SL,"codeString",True) # u'${codeString}' on line 216, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${codeString}')) # from line 216, col 1.
        write(u'''// **********************************************
#undef ''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 218, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 218, col 8.
        write(u'''
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # VectorInitialisationFromHDF5.tmpl
        # 
        # Created by Graham Dennis on 2009-01-29.
        # 
        # Copyright (c) 2009-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''




''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_VectorInitialisationFromHDF5= 'writeBody'

## END CLASS DEFINITION

if not hasattr(VectorInitialisationFromHDF5, '_initCheetahAttributes'):
    templateAPIClass = getattr(VectorInitialisationFromHDF5, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(VectorInitialisationFromHDF5)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=VectorInitialisationFromHDF5()).run()


