/* valablock.c generated by valac, the Vala compiler
 * generated from valablock.vala, do not modify */

/* valablock.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaBlockPrivate {
	gboolean _contains_jump_statement;
	gboolean _captured;
	ValaList* statement_list;
	ValaList* local_variables;
	ValaList* local_constants;
};


static gpointer vala_block_parent_class = NULL;
static ValaStatementIface * vala_block_vala_statement_parent_iface = NULL;

#define VALA_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BLOCK, ValaBlockPrivate))
static void vala_block_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_block_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_block_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_block_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen);
static void vala_block_finalize (ValaCodeNode * obj);


/**
 * Creates a new block.
 *
 * @param source_reference  reference to source code
 */
ValaBlock*
vala_block_construct (GType object_type,
                      ValaSourceReference* source_reference)
{
	ValaBlock* self = NULL;
	self = (ValaBlock*) vala_symbol_construct (object_type, NULL, source_reference, NULL);
	return self;
}


ValaBlock*
vala_block_new (ValaSourceReference* source_reference)
{
	return vala_block_construct (VALA_TYPE_BLOCK, source_reference);
}


/**
 * Append a statement to this block.
 *
 * @param stmt a statement
 */
void
vala_block_add_statement (ValaBlock* self,
                          ValaStatement* stmt)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) stmt, (ValaCodeNode*) self);
	_tmp0_ = self->priv->statement_list;
	vala_collection_add ((ValaCollection*) _tmp0_, stmt);
}


void
vala_block_insert_statement (ValaBlock* self,
                             gint index,
                             ValaStatement* stmt)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) stmt, (ValaCodeNode*) self);
	_tmp0_ = self->priv->statement_list;
	vala_list_insert (_tmp0_, index, stmt);
}


/**
 * Returns a copy of the list of statements.
 *
 * @return statement list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


ValaList*
vala_block_get_statements (ValaBlock* self)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_STATEMENT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _stmt_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _stmt_index = 0;
		_tmp2_ = self->priv->statement_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_stmt_list = _tmp3_;
		_tmp4_ = _stmt_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_stmt_size = _tmp6_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaStatementList* stmt_list = NULL;
			ValaStatement* _tmp13_;
			ValaStatementList* _tmp14_;
			ValaStatementList* _tmp15_;
			_tmp7_ = _stmt_index;
			_stmt_index = _tmp7_ + 1;
			_tmp8_ = _stmt_index;
			_tmp9_ = _stmt_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _stmt_list;
			_tmp11_ = _stmt_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			stmt = (ValaStatement*) _tmp12_;
			_tmp13_ = stmt;
			_tmp14_ = _vala_code_node_ref0 (VALA_IS_STATEMENT_LIST (_tmp13_) ? ((ValaStatementList*) _tmp13_) : NULL);
			stmt_list = _tmp14_;
			_tmp15_ = stmt_list;
			if (_tmp15_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_;
							ValaStatementList* _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							ValaArrayList* _tmp22_;
							ValaStatementList* _tmp23_;
							gint _tmp24_;
							ValaStatement* _tmp25_;
							ValaStatement* _tmp26_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = i;
								i = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = i;
							_tmp19_ = stmt_list;
							_tmp20_ = vala_statement_list_get_length (_tmp19_);
							_tmp21_ = _tmp20_;
							if (!(_tmp18_ < _tmp21_)) {
								break;
							}
							_tmp22_ = list;
							_tmp23_ = stmt_list;
							_tmp24_ = i;
							_tmp25_ = vala_statement_list_get (_tmp23_, _tmp24_);
							_tmp26_ = _tmp25_;
							vala_collection_add ((ValaCollection*) _tmp22_, _tmp26_);
							_vala_code_node_unref0 (_tmp26_);
						}
					}
				}
			} else {
				ValaArrayList* _tmp27_;
				ValaStatement* _tmp28_;
				_tmp27_ = list;
				_tmp28_ = stmt;
				vala_collection_add ((ValaCollection*) _tmp27_, _tmp28_);
			}
			_vala_code_node_unref0 (stmt_list);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
	result = (ValaList*) list;
	return result;
}


/**
 * Add a local variable to this block.
 *
 * @param local a variable declarator
 */
void
vala_block_add_local_variable (ValaBlock* self,
                               ValaLocalVariable* local)
{
	ValaSymbol* parent_block = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaList* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	parent_block = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSymbol* _tmp14_;
		gboolean _tmp15_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp5_ = parent_block;
		if (VALA_IS_BLOCK (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			_tmp6_ = parent_block;
			_tmp4_ = VALA_IS_METHOD (_tmp6_);
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			_tmp7_ = parent_block;
			_tmp3_ = VALA_IS_PROPERTY_ACCESSOR (_tmp7_);
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = parent_block;
		_tmp9_ = vala_symbol_get_scope (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) local);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_scope_lookup (_tmp10_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_ != NULL;
		_vala_code_node_unref0 (_tmp14_);
		if (_tmp15_) {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) local);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_name ((ValaSymbol*) local);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("Local variable `%s' conflicts with a local variable or constant declar" \
"ed in a parent scope", _tmp19_);
			_tmp21_ = _tmp20_;
			vala_report_error (_tmp17_, _tmp21_);
			_g_free0 (_tmp21_);
			break;
		}
		_tmp22_ = parent_block;
		_tmp23_ = vala_symbol_get_parent_symbol (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (_tmp24_);
		_vala_code_node_unref0 (parent_block);
		parent_block = _tmp25_;
	}
	_tmp26_ = self->priv->local_variables;
	vala_collection_add ((ValaCollection*) _tmp26_, local);
	_vala_code_node_unref0 (parent_block);
}


void
vala_block_remove_local_variable (ValaBlock* self,
                                  ValaLocalVariable* local)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->local_variables;
	vala_collection_remove ((ValaCollection*) _tmp0_, local);
}


/**
 * Returns a copy of the list of local variables.
 *
 * @return variable declarator list
 */
ValaList*
vala_block_get_local_variables (ValaBlock* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->local_variables;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void
vala_block_add_local_constant (ValaBlock* self,
                               ValaConstant* constant)
{
	ValaSymbol* parent_block = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaList* _tmp26_;
	ValaScope* _tmp27_;
	ValaScope* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	parent_block = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSymbol* _tmp14_;
		gboolean _tmp15_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp5_ = parent_block;
		if (VALA_IS_BLOCK (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			_tmp6_ = parent_block;
			_tmp4_ = VALA_IS_METHOD (_tmp6_);
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			_tmp7_ = parent_block;
			_tmp3_ = VALA_IS_PROPERTY_ACCESSOR (_tmp7_);
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = parent_block;
		_tmp9_ = vala_symbol_get_scope (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) constant);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_scope_lookup (_tmp10_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_ != NULL;
		_vala_code_node_unref0 (_tmp14_);
		if (_tmp15_) {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_name ((ValaSymbol*) constant);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("Local constant `%s' conflicts with a local variable or constant declar" \
"ed in a parent scope", _tmp19_);
			_tmp21_ = _tmp20_;
			vala_report_error (_tmp17_, _tmp21_);
			_g_free0 (_tmp21_);
			break;
		}
		_tmp22_ = parent_block;
		_tmp23_ = vala_symbol_get_parent_symbol (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (_tmp24_);
		_vala_code_node_unref0 (parent_block);
		parent_block = _tmp25_;
	}
	_tmp26_ = self->priv->local_constants;
	vala_collection_add ((ValaCollection*) _tmp26_, constant);
	_tmp27_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_symbol_get_name ((ValaSymbol*) constant);
	_tmp30_ = _tmp29_;
	vala_scope_add (_tmp28_, _tmp30_, (ValaSymbol*) constant);
	_vala_code_node_unref0 (parent_block);
}


static void
vala_block_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaBlock * self;
	self = (ValaBlock*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_block (visitor, self);
}


static void
vala_block_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaBlock * self;
	self = (ValaBlock*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _stmt_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _stmt_index = 0;
		_tmp0_ = self->priv->statement_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_stmt_list = _tmp1_;
		_tmp2_ = _stmt_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_stmt_size = _tmp4_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaStatement* _tmp11_;
			_tmp5_ = _stmt_index;
			_stmt_index = _tmp5_ + 1;
			_tmp6_ = _stmt_index;
			_tmp7_ = _stmt_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _stmt_list;
			_tmp9_ = _stmt_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			stmt = (ValaStatement*) _tmp10_;
			_tmp11_ = stmt;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
}


static gboolean
vala_block_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaBlock * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaBlock* old_insert_block = NULL;
	ValaSemanticAnalyzer* _tmp15_;
	ValaSemanticAnalyzer* _tmp16_;
	ValaBlock* _tmp17_;
	ValaBlock* _tmp18_;
	ValaSemanticAnalyzer* _tmp19_;
	ValaSemanticAnalyzer* _tmp20_;
	ValaSemanticAnalyzer* _tmp21_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaBlock* _tmp23_;
	ValaSemanticAnalyzer* _tmp71_;
	ValaSemanticAnalyzer* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaSemanticAnalyzer* _tmp74_;
	ValaSemanticAnalyzer* _tmp75_;
	ValaBlock* _tmp76_;
	ValaBlock* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	self = (ValaBlock*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_symbol (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_scope (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp9_);
	_tmp10_ = vala_code_context_get_analyzer (context);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_semantic_analyzer_get_current_symbol (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _vala_code_node_ref0 (_tmp13_);
	old_symbol = _tmp14_;
	_tmp15_ = vala_code_context_get_analyzer (context);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_->insert_block;
	_tmp18_ = _vala_code_node_ref0 (_tmp17_);
	old_insert_block = _tmp18_;
	_tmp19_ = vala_code_context_get_analyzer (context);
	_tmp20_ = _tmp19_;
	vala_semantic_analyzer_set_current_symbol (_tmp20_, (ValaSymbol*) self);
	_tmp21_ = vala_code_context_get_analyzer (context);
	_tmp22_ = _tmp21_;
	_tmp23_ = _vala_code_node_ref0 (self);
	_vala_code_node_unref0 (_tmp22_->insert_block);
	_tmp22_->insert_block = _tmp23_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint _tmp26_;
				ValaList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				ValaList* _tmp30_;
				gint _tmp31_;
				gpointer _tmp32_;
				ValaStatement* _tmp33_;
				gboolean _tmp34_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = i;
				_tmp27_ = self->priv->statement_list;
				_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				if (!(_tmp26_ < _tmp29_)) {
					break;
				}
				_tmp30_ = self->priv->statement_list;
				_tmp31_ = i;
				_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
				_tmp33_ = (ValaStatement*) _tmp32_;
				_tmp34_ = !vala_code_node_check ((ValaCodeNode*) _tmp33_, context);
				_vala_code_node_unref0 (_tmp33_);
				if (_tmp34_) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp35_;
		gint _local_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _local_index = 0;
		_tmp35_ = vala_block_get_local_variables (self);
		_local_list = _tmp35_;
		_tmp36_ = _local_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_local_size = _tmp38_;
		_local_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			ValaLocalVariable* local = NULL;
			ValaList* _tmp42_;
			gint _tmp43_;
			gpointer _tmp44_;
			ValaLocalVariable* _tmp45_;
			_tmp39_ = _local_index;
			_local_index = _tmp39_ + 1;
			_tmp40_ = _local_index;
			_tmp41_ = _local_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _local_list;
			_tmp43_ = _local_index;
			_tmp44_ = vala_list_get (_tmp42_, _tmp43_);
			local = (ValaLocalVariable*) _tmp44_;
			_tmp45_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp45_, FALSE);
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	{
		ValaList* _constant_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _constant_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _constant_index = 0;
		_tmp46_ = self->priv->local_constants;
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_constant_list = _tmp47_;
		_tmp48_ = _constant_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_constant_size = _tmp50_;
		_constant_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			ValaConstant* constant = NULL;
			ValaList* _tmp54_;
			gint _tmp55_;
			gpointer _tmp56_;
			ValaConstant* _tmp57_;
			_tmp51_ = _constant_index;
			_constant_index = _tmp51_ + 1;
			_tmp52_ = _constant_index;
			_tmp53_ = _constant_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _constant_list;
			_tmp55_ = _constant_index;
			_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
			constant = (ValaConstant*) _tmp56_;
			_tmp57_ = constant;
			vala_symbol_set_active ((ValaSymbol*) _tmp57_, FALSE);
			_vala_code_node_unref0 (constant);
		}
		_vala_iterable_unref0 (_constant_list);
	}
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp58_;
		gint _stmt_size = 0;
		ValaList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _stmt_index = 0;
		_tmp58_ = vala_block_get_statements (self);
		_stmt_list = _tmp58_;
		_tmp59_ = _stmt_list;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_stmt_size = _tmp61_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp65_;
			gint _tmp66_;
			gpointer _tmp67_;
			ValaStatement* _tmp68_;
			ValaList* _tmp69_;
			ValaList* _tmp70_;
			_tmp62_ = _stmt_index;
			_stmt_index = _tmp62_ + 1;
			_tmp63_ = _stmt_index;
			_tmp64_ = _stmt_size;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp65_ = _stmt_list;
			_tmp66_ = _stmt_index;
			_tmp67_ = vala_list_get (_tmp65_, _tmp66_);
			stmt = (ValaStatement*) _tmp67_;
			_tmp68_ = stmt;
			_tmp69_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp68_);
			_tmp70_ = _tmp69_;
			vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp70_);
			_vala_iterable_unref0 (_tmp70_);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
	_tmp71_ = vala_code_context_get_analyzer (context);
	_tmp72_ = _tmp71_;
	_tmp73_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp72_, _tmp73_);
	_tmp74_ = vala_code_context_get_analyzer (context);
	_tmp75_ = _tmp74_;
	_tmp76_ = old_insert_block;
	_tmp77_ = _vala_code_node_ref0 (_tmp76_);
	_vala_code_node_unref0 (_tmp75_->insert_block);
	_tmp75_->insert_block = _tmp77_;
	_tmp78_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp79_ = _tmp78_;
	result = !_tmp79_;
	_vala_code_node_unref0 (old_insert_block);
	_vala_code_node_unref0 (old_symbol);
	return result;
}


static void
vala_block_real_emit (ValaCodeNode* base,
                      ValaCodeGenerator* codegen)
{
	ValaBlock * self;
	self = (ValaBlock*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_block ((ValaCodeVisitor*) codegen, self);
}


void
vala_block_insert_before (ValaBlock* self,
                          ValaStatement* stmt,
                          ValaStatement* new_stmt)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (new_stmt != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaStatementList* stmt_list = NULL;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaStatement* _tmp9_;
				ValaStatementList* _tmp10_;
				ValaStatementList* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->statement_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->statement_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaStatement*) _tmp8_;
				_tmp10_ = VALA_IS_STATEMENT_LIST (_tmp9_) ? ((ValaStatementList*) _tmp9_) : NULL;
				if (_tmp10_ == NULL) {
					_vala_code_node_unref0 (_tmp9_);
				}
				stmt_list = _tmp10_;
				_tmp11_ = stmt_list;
				if (_tmp11_ != NULL) {
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								gint _tmp14_;
								ValaStatementList* _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								ValaStatementList* _tmp18_;
								gint _tmp19_;
								ValaStatement* _tmp20_;
								ValaStatement* _tmp21_;
								gboolean _tmp22_;
								if (!_tmp12_) {
									gint _tmp13_;
									_tmp13_ = j;
									j = _tmp13_ + 1;
								}
								_tmp12_ = FALSE;
								_tmp14_ = j;
								_tmp15_ = stmt_list;
								_tmp16_ = vala_statement_list_get_length (_tmp15_);
								_tmp17_ = _tmp16_;
								if (!(_tmp14_ < _tmp17_)) {
									break;
								}
								_tmp18_ = stmt_list;
								_tmp19_ = j;
								_tmp20_ = vala_statement_list_get (_tmp18_, _tmp19_);
								_tmp21_ = _tmp20_;
								_tmp22_ = _tmp21_ == stmt;
								_vala_code_node_unref0 (_tmp21_);
								if (_tmp22_) {
									ValaStatementList* _tmp23_;
									gint _tmp24_;
									_tmp23_ = stmt_list;
									_tmp24_ = j;
									vala_statement_list_insert (_tmp23_, _tmp24_, new_stmt);
									vala_code_node_set_parent_node ((ValaCodeNode*) new_stmt, (ValaCodeNode*) self);
									break;
								}
							}
						}
					}
				} else {
					ValaList* _tmp25_;
					gint _tmp26_;
					gpointer _tmp27_;
					ValaStatement* _tmp28_;
					gboolean _tmp29_;
					_tmp25_ = self->priv->statement_list;
					_tmp26_ = i;
					_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
					_tmp28_ = (ValaStatement*) _tmp27_;
					_tmp29_ = _tmp28_ == stmt;
					_vala_code_node_unref0 (_tmp28_);
					if (_tmp29_) {
						ValaSourceReference* _tmp30_;
						ValaSourceReference* _tmp31_;
						ValaStatementList* _tmp32_;
						ValaStatementList* _tmp33_;
						ValaStatementList* _tmp34_;
						ValaList* _tmp35_;
						gint _tmp36_;
						ValaStatementList* _tmp37_;
						_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp31_ = _tmp30_;
						_tmp32_ = vala_statement_list_new (_tmp31_);
						_vala_code_node_unref0 (stmt_list);
						stmt_list = _tmp32_;
						_tmp33_ = stmt_list;
						vala_statement_list_add (_tmp33_, new_stmt);
						_tmp34_ = stmt_list;
						vala_statement_list_add (_tmp34_, stmt);
						_tmp35_ = self->priv->statement_list;
						_tmp36_ = i;
						_tmp37_ = stmt_list;
						vala_list_set (_tmp35_, _tmp36_, (ValaStatement*) _tmp37_);
						vala_code_node_set_parent_node ((ValaCodeNode*) new_stmt, (ValaCodeNode*) self);
					}
				}
				_vala_code_node_unref0 (stmt_list);
			}
		}
	}
}


void
vala_block_replace_statement (ValaBlock* self,
                              ValaStatement* old_stmt,
                              ValaStatement* new_stmt)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_stmt != NULL);
	g_return_if_fail (new_stmt != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaStatementList* stmt_list = NULL;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaStatement* _tmp9_;
				ValaStatementList* _tmp10_;
				ValaStatementList* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->statement_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->statement_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaStatement*) _tmp8_;
				_tmp10_ = VALA_IS_STATEMENT_LIST (_tmp9_) ? ((ValaStatementList*) _tmp9_) : NULL;
				if (_tmp10_ == NULL) {
					_vala_code_node_unref0 (_tmp9_);
				}
				stmt_list = _tmp10_;
				_tmp11_ = stmt_list;
				if (_tmp11_ != NULL) {
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								gint _tmp14_;
								ValaStatementList* _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								ValaStatementList* _tmp18_;
								gint _tmp19_;
								ValaStatement* _tmp20_;
								ValaStatement* _tmp21_;
								gboolean _tmp22_;
								if (!_tmp12_) {
									gint _tmp13_;
									_tmp13_ = j;
									j = _tmp13_ + 1;
								}
								_tmp12_ = FALSE;
								_tmp14_ = j;
								_tmp15_ = stmt_list;
								_tmp16_ = vala_statement_list_get_length (_tmp15_);
								_tmp17_ = _tmp16_;
								if (!(_tmp14_ < _tmp17_)) {
									break;
								}
								_tmp18_ = stmt_list;
								_tmp19_ = j;
								_tmp20_ = vala_statement_list_get (_tmp18_, _tmp19_);
								_tmp21_ = _tmp20_;
								_tmp22_ = _tmp21_ == old_stmt;
								_vala_code_node_unref0 (_tmp21_);
								if (_tmp22_) {
									ValaStatementList* _tmp23_;
									gint _tmp24_;
									_tmp23_ = stmt_list;
									_tmp24_ = j;
									vala_statement_list_set (_tmp23_, _tmp24_, new_stmt);
									vala_code_node_set_parent_node ((ValaCodeNode*) new_stmt, (ValaCodeNode*) self);
									break;
								}
							}
						}
					}
				} else {
					ValaList* _tmp25_;
					gint _tmp26_;
					gpointer _tmp27_;
					ValaStatement* _tmp28_;
					gboolean _tmp29_;
					_tmp25_ = self->priv->statement_list;
					_tmp26_ = i;
					_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
					_tmp28_ = (ValaStatement*) _tmp27_;
					_tmp29_ = _tmp28_ == old_stmt;
					_vala_code_node_unref0 (_tmp28_);
					if (_tmp29_) {
						ValaList* _tmp30_;
						gint _tmp31_;
						_tmp30_ = self->priv->statement_list;
						_tmp31_ = i;
						vala_list_set (_tmp30_, _tmp31_, new_stmt);
						vala_code_node_set_parent_node ((ValaCodeNode*) new_stmt, (ValaCodeNode*) self);
						_vala_code_node_unref0 (stmt_list);
						break;
					}
				}
				_vala_code_node_unref0 (stmt_list);
			}
		}
	}
}


gboolean
vala_block_get_contains_jump_statement (ValaBlock* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_contains_jump_statement;
	result = _tmp0_;
	return result;
}


void
vala_block_set_contains_jump_statement (ValaBlock* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_contains_jump_statement = value;
}


gboolean
vala_block_get_captured (ValaBlock* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_block_set_captured (ValaBlock* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


static void
vala_block_class_init (ValaBlockClass * klass)
{
	vala_block_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_block_finalize;
	g_type_class_add_private (klass, sizeof (ValaBlockPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_block_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_block_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_block_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_block_real_emit;
}


static void
vala_block_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_block_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_block_instance_init (ValaBlock * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->priv = VALA_BLOCK_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_STATEMENT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->statement_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->local_variables = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->local_constants = (ValaList*) _tmp5_;
}


static void
vala_block_finalize (ValaCodeNode * obj)
{
	ValaBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BLOCK, ValaBlock);
	_vala_iterable_unref0 (self->priv->statement_list);
	_vala_iterable_unref0 (self->priv->local_variables);
	_vala_iterable_unref0 (self->priv->local_constants);
	VALA_CODE_NODE_CLASS (vala_block_parent_class)->finalize (obj);
}


/**
 * Represents a source code block.
 */
GType
vala_block_get_type (void)
{
	static volatile gsize vala_block_type_id__volatile = 0;
	if (g_once_init_enter (&vala_block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBlock), 0, (GInstanceInitFunc) vala_block_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_block_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_block_type_id;
		vala_block_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaBlock", &g_define_type_info, 0);
		g_type_add_interface_static (vala_block_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_block_type_id__volatile, vala_block_type_id);
	}
	return vala_block_type_id__volatile;
}



