/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef LANGUAGEFRAME_H
#define LANGUAGEFRAME_H

#include "ukccframe.h"
#include <QLabel>
#include <QIcon>
#include <QToolButton>

class LanguageFrame : public UkccFrame
{
    Q_OBJECT

public:
    LanguageFrame(QString showName, QWidget *parent = nullptr);
    ~LanguageFrame();
    void showSelectedIcon(bool flag);
    bool isSelection();
    QToolButton *createToolBtn();
    QString getShowName();
    void reloadIcon();

private:
    void mousePressEvent(QMouseEvent *e);

private:
    QLabel *nameLabel         = nullptr;
    QLabel *selectedIconLabel = nullptr;
    QIcon  selectIcon;

Q_SIGNALS:
    void clicked();
    void deleted();
};

#endif // LANGUAGEFRAME_H
