'\"
'\" Generated from file 'special\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Arjen Markus <arjenmarkus@users\&.sourceforge\&.net>
'\"
.TH "math::special" n 0\&.4 tcllib "Tcl Math Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
math::special \- Special mathematical functions
.SH SYNOPSIS
package require \fBTcl  ?8\&.5?\fR
.sp
package require \fBmath::special  ?0\&.5?\fR
.sp
\fB::math::special::eulerNumber\fR \fIindex\fR
.sp
\fB::math::special::bernoulliNumber\fR \fIindex\fR
.sp
\fB::math::special::Beta\fR \fIx\fR \fIy\fR
.sp
\fB::math::special::incBeta\fR \fIa\fR \fIb\fR \fIx\fR
.sp
\fB::math::special::regIncBeta\fR \fIa\fR \fIb\fR \fIx\fR
.sp
\fB::math::special::Gamma\fR \fIx\fR
.sp
\fB::math::special::digamma\fR \fIx\fR
.sp
\fB::math::special::erf\fR \fIx\fR
.sp
\fB::math::special::erfc\fR \fIx\fR
.sp
\fB::math::special::invnorm\fR \fIp\fR
.sp
\fB::math::special::J0\fR \fIx\fR
.sp
\fB::math::special::J1\fR \fIx\fR
.sp
\fB::math::special::Jn\fR \fIn\fR \fIx\fR
.sp
\fB::math::special::J1/2\fR \fIx\fR
.sp
\fB::math::special::J-1/2\fR \fIx\fR
.sp
\fB::math::special::I_n\fR \fIx\fR
.sp
\fB::math::special::cn\fR \fIu\fR \fIk\fR
.sp
\fB::math::special::dn\fR \fIu\fR \fIk\fR
.sp
\fB::math::special::sn\fR \fIu\fR \fIk\fR
.sp
\fB::math::special::elliptic_K\fR \fIk\fR
.sp
\fB::math::special::elliptic_E\fR \fIk\fR
.sp
\fB::math::special::exponential_Ei\fR \fIx\fR
.sp
\fB::math::special::exponential_En\fR \fIn\fR \fIx\fR
.sp
\fB::math::special::exponential_li\fR \fIx\fR
.sp
\fB::math::special::exponential_Ci\fR \fIx\fR
.sp
\fB::math::special::exponential_Si\fR \fIx\fR
.sp
\fB::math::special::exponential_Chi\fR \fIx\fR
.sp
\fB::math::special::exponential_Shi\fR \fIx\fR
.sp
\fB::math::special::fresnel_C\fR \fIx\fR
.sp
\fB::math::special::fresnel_S\fR \fIx\fR
.sp
\fB::math::special::sinc\fR \fIx\fR
.sp
\fB::math::special::legendre\fR \fIn\fR
.sp
\fB::math::special::chebyshev\fR \fIn\fR
.sp
\fB::math::special::laguerre\fR \fIalpha\fR \fIn\fR
.sp
\fB::math::special::hermite\fR \fIn\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package implements several so-called special functions, like
the Gamma function, the Bessel functions and such\&.
.PP
Each function is implemented by a procedure that bears its name (well,
in close approximation):
.IP \(bu
J0 for the zeroth-order Bessel function of the first kind
.IP \(bu
J1 for the first-order Bessel function of the first kind
.IP \(bu
Jn for the nth-order Bessel function of the first kind
.IP \(bu
J1/2 for the half-order Bessel function of the first kind
.IP \(bu
J-1/2 for the minus-half-order Bessel function of the first kind
.IP \(bu
I_n for the modified Bessel function of the first kind of order n
.IP \(bu
Gamma for the Gamma function, erf and erfc for the error function and
the complementary error function
.IP \(bu
fresnel_C and fresnel_S for the Fresnel integrals
.IP \(bu
elliptic_K and elliptic_E (complete elliptic integrals)
.IP \(bu
exponent_Ei and other functions related to the so-called exponential
integrals
.IP \(bu
legendre, hermite: some of the classical orthogonal polynomials\&.
.PP
.SH OVERVIEW
In the following table several characteristics of the functions in this
package are summarized: the domain for the argument, the values for the
parameters and error bounds\&.
.CS


Family       | Function    | Domain x    | Parameter   | Error bound
-------------+-------------+-------------+-------------+--------------
Bessel       | J0, J1,     | all of R    | n = integer |   < 1\&.0e-8
             | Jn          |             |             |  (|x|<20, n<20)
Bessel       | J1/2, J-1/2,|  x > 0      | n = integer |   exact
Bessel       | I_n         | all of R    | n = integer |   < 1\&.0e-6
             |             |             |             |
Elliptic     | cn          | 0 <= x <= 1 |     --      |   < 1\&.0e-10
functions    | dn          | 0 <= x <= 1 |     --      |   < 1\&.0e-10
             | sn          | 0 <= x <= 1 |     --      |   < 1\&.0e-10
Elliptic     | K           | 0 <= x < 1  |     --      |   < 1\&.0e-6
integrals    | E           | 0 <= x < 1  |     --      |   < 1\&.0e-6
             |             |             |             |
Error        | erf         |             |     --      |
functions    | erfc        |             |             |
             |             |             |             |
Inverse      | invnorm     | 0 < x < 1   |     --      |   < 1\&.2e-9
normal       |             |             |             |
distribution |             |             |             |
             |             |             |             |
Exponential  | Ei          |  x != 0     |     --      |   < 1\&.0e-10 (relative)
integrals    | En          |  x >  0     |     --      |   as Ei
             | li          |  x > 0      |     --      |   as Ei
             | Chi         |  x > 0      |     --      |   < 1\&.0e-8
             | Shi         |  x > 0      |     --      |   < 1\&.0e-8
             | Ci          |  x > 0      |     --      |   < 2\&.0e-4
             | Si          |  x > 0      |     --      |   < 2\&.0e-4
             |             |             |             |
Fresnel      | C           |  all of R   |     --      |   < 2\&.0e-3
integrals    | S           |  all of R   |     --      |   < 2\&.0e-3
             |             |             |             |
general      | Beta        | (see Gamma) |     --      |   < 1\&.0e-9
             | Gamma       |  x != 0,-1, |     --      |   < 1\&.0e-9
             |             |  -2, \&.\&.\&.    |             |
             | incBeta     |             |  a, b > 0   |   < 1\&.0e-9
             | regIncBeta  |             |  a, b > 0   |   < 1\&.0e-9
             | digamma     |  x != 0,-1  |             |   < 1\&.0e-9
             |             |  -2, \&.\&.\&.    |             |
             |             |             |             |
             | sinc        |  all of R   |     --      |   exact
             |             |             |             |
orthogonal   | Legendre    |  all of R   | n = 0,1,\&.\&.\&. |   exact
polynomials  | Chebyshev   |  all of R   | n = 0,1,\&.\&.\&. |   exact
             | Laguerre    |  all of R   | n = 0,1,\&.\&.\&. |   exact
             |             |             | alpha el\&. R |
             | Hermite     |  all of R   | n = 0,1,\&.\&.\&. |   exact

.CE
\fINote:\fR Some of the error bounds are estimated, as no
"formal" bounds were available with the implemented approximation
method, others hold for the auxiliary functions used for estimating
the primary functions\&.
.PP
The following well-known functions are currently missing from the package:
.IP \(bu
Bessel functions of the second kind (Y_n, K_n)
.IP \(bu
Bessel functions of arbitrary order (and hence the Airy functions)
.IP \(bu
Chebyshev polynomials of the second kind (U_n)
.IP \(bu
The incomplete gamma function
.PP
.SH PROCEDURES
The package defines the following public procedures:
.TP
\fB::math::special::eulerNumber\fR \fIindex\fR
Return the index'th Euler number (note: these are integer values)\&. As the
size of these numbers grows very fast, only a limited number are available\&.
.RS
.TP
int \fIindex\fR
Index of the number to be returned (should be between 0 and 54)
.RE
.sp
.TP
\fB::math::special::bernoulliNumber\fR \fIindex\fR
Return the index'th Bernoulli number\&. As the size of the numbers grows very fast,
only a limited number are available\&.
.RS
.TP
int \fIindex\fR
Index of the number to be returned (should be between 0 and 52)
.RE
.sp
.TP
\fB::math::special::Beta\fR \fIx\fR \fIy\fR
Compute the Beta function for arguments "x" and "y"
.RS
.TP
float \fIx\fR
First argument for the Beta function
.TP
float \fIy\fR
Second argument for the Beta function
.RE
.sp
.TP
\fB::math::special::incBeta\fR \fIa\fR \fIb\fR \fIx\fR
Compute the incomplete Beta function for argument "x" with parameters "a" and "b"
.RS
.TP
float \fIa\fR
First parameter for the incomplete Beta function, a > 0
.TP
float \fIb\fR
Second parameter for the incomplete Beta function, b > 0
.TP
float \fIx\fR
Argument for the incomplete Beta function
.RE
.sp
.TP
\fB::math::special::regIncBeta\fR \fIa\fR \fIb\fR \fIx\fR
Compute the regularized incomplete Beta function for argument "x" with parameters "a" and "b"
.RS
.TP
float \fIa\fR
First parameter for the incomplete Beta function, a > 0
.TP
float \fIb\fR
Second parameter for the incomplete Beta function, b > 0
.TP
float \fIx\fR
Argument for the regularized incomplete Beta function
.RE
.sp
.TP
\fB::math::special::Gamma\fR \fIx\fR
Compute the Gamma function for argument "x"
.RS
.TP
float \fIx\fR
Argument for the Gamma function
.RE
.sp
.TP
\fB::math::special::digamma\fR \fIx\fR
Compute the digamma function (psi) for argument "x"
.RS
.TP
float \fIx\fR
Argument for the digamma function
.RE
.sp
.TP
\fB::math::special::erf\fR \fIx\fR
Compute the error function for argument "x"
.RS
.TP
float \fIx\fR
Argument for the error function
.RE
.sp
.TP
\fB::math::special::erfc\fR \fIx\fR
Compute the complementary error function for argument "x"
.RS
.TP
float \fIx\fR
Argument for the complementary error function
.RE
.sp
.TP
\fB::math::special::invnorm\fR \fIp\fR
Compute the inverse of the normal distribution function for argument "p"
.RS
.TP
float \fIp\fR
Argument for the inverse normal distribution function
(p must be greater than 0 and lower than 1)
.RE
.sp
.TP
\fB::math::special::J0\fR \fIx\fR
Compute the zeroth-order Bessel function of the first kind for the
argument "x"
.RS
.TP
float \fIx\fR
Argument for the Bessel function
.RE
.TP
\fB::math::special::J1\fR \fIx\fR
Compute the first-order Bessel function of the first kind for the
argument "x"
.RS
.TP
float \fIx\fR
Argument for the Bessel function
.RE
.TP
\fB::math::special::Jn\fR \fIn\fR \fIx\fR
Compute the nth-order Bessel function of the first kind for the
argument "x"
.RS
.TP
integer \fIn\fR
Order of the Bessel function
.TP
float \fIx\fR
Argument for the Bessel function
.RE
.TP
\fB::math::special::J1/2\fR \fIx\fR
Compute the half-order Bessel function of the first kind for the
argument "x"
.RS
.TP
float \fIx\fR
Argument for the Bessel function
.RE
.TP
\fB::math::special::J-1/2\fR \fIx\fR
Compute the minus-half-order Bessel function of the first kind for the
argument "x"
.RS
.TP
float \fIx\fR
Argument for the Bessel function
.RE
.TP
\fB::math::special::I_n\fR \fIx\fR
Compute the modified Bessel function of the first kind of order n for
the argument "x"
.RS
.TP
int \fIx\fR
Positive integer order of the function
.TP
float \fIx\fR
Argument for the function
.RE
.TP
\fB::math::special::cn\fR \fIu\fR \fIk\fR
Compute the elliptic function \fIcn\fR for the argument "u" and
parameter "k"\&.
.RS
.TP
float \fIu\fR
Argument for the function
.TP
float \fIk\fR
Parameter
.RE
.TP
\fB::math::special::dn\fR \fIu\fR \fIk\fR
Compute the elliptic function \fIdn\fR for the argument "u" and
parameter "k"\&.
.RS
.TP
float \fIu\fR
Argument for the function
.TP
float \fIk\fR
Parameter
.RE
.TP
\fB::math::special::sn\fR \fIu\fR \fIk\fR
Compute the elliptic function \fIsn\fR for the argument "u" and
parameter "k"\&.
.RS
.TP
float \fIu\fR
Argument for the function
.TP
float \fIk\fR
Parameter
.RE
.TP
\fB::math::special::elliptic_K\fR \fIk\fR
Compute the complete elliptic integral of the first kind
for the argument "k"
.RS
.TP
float \fIk\fR
Argument for the function
.RE
.TP
\fB::math::special::elliptic_E\fR \fIk\fR
Compute the complete elliptic integral of the second kind
for the argument "k"
.RS
.TP
float \fIk\fR
Argument for the function
.RE
.TP
\fB::math::special::exponential_Ei\fR \fIx\fR
Compute the exponential integral of the second kind
for the argument "x"
.RS
.TP
float \fIx\fR
Argument for the function (x != 0)
.RE
.TP
\fB::math::special::exponential_En\fR \fIn\fR \fIx\fR
Compute the exponential integral of the first kind
for the argument "x" and order n
.RS
.TP
int \fIn\fR
Order of the integral (n >= 0)
.TP
float \fIx\fR
Argument for the function (x >= 0)
.RE
.TP
\fB::math::special::exponential_li\fR \fIx\fR
Compute the logarithmic integral for the argument "x"
.RS
.TP
float \fIx\fR
Argument for the function (x > 0)
.RE
.TP
\fB::math::special::exponential_Ci\fR \fIx\fR
Compute the cosine integral for the argument "x"
.RS
.TP
float \fIx\fR
Argument for the function (x > 0)
.RE
.TP
\fB::math::special::exponential_Si\fR \fIx\fR
Compute the sine integral for the argument "x"
.RS
.TP
float \fIx\fR
Argument for the function (x > 0)
.RE
.TP
\fB::math::special::exponential_Chi\fR \fIx\fR
Compute the hyperbolic cosine integral for the argument "x"
.RS
.TP
float \fIx\fR
Argument for the function (x > 0)
.RE
.TP
\fB::math::special::exponential_Shi\fR \fIx\fR
Compute the hyperbolic sine integral for the argument "x"
.RS
.TP
float \fIx\fR
Argument for the function (x > 0)
.RE
.TP
\fB::math::special::fresnel_C\fR \fIx\fR
Compute the Fresnel cosine integral for real argument x
.RS
.TP
float \fIx\fR
Argument for the function
.RE
.TP
\fB::math::special::fresnel_S\fR \fIx\fR
Compute the Fresnel sine integral for real argument x
.RS
.TP
float \fIx\fR
Argument for the function
.RE
.TP
\fB::math::special::sinc\fR \fIx\fR
Compute the sinc function for real argument x
.RS
.TP
float \fIx\fR
Argument for the function
.RE
.TP
\fB::math::special::legendre\fR \fIn\fR
Return the Legendre polynomial of degree n
(see \fBTHE ORTHOGONAL POLYNOMIALS\fR)
.RS
.TP
int \fIn\fR
Degree of the polynomial
.RE
.sp
.TP
\fB::math::special::chebyshev\fR \fIn\fR
Return the Chebyshev polynomial of degree n (of the first kind)
.RS
.TP
int \fIn\fR
Degree of the polynomial
.RE
.sp
.TP
\fB::math::special::laguerre\fR \fIalpha\fR \fIn\fR
Return the Laguerre polynomial of degree n with parameter alpha
.RS
.TP
float \fIalpha\fR
Parameter of the Laguerre polynomial
.TP
int \fIn\fR
Degree of the polynomial
.RE
.sp
.TP
\fB::math::special::hermite\fR \fIn\fR
Return the Hermite polynomial of degree n
.RS
.TP
int \fIn\fR
Degree of the polynomial
.RE
.sp
.PP
.SH "THE ORTHOGONAL POLYNOMIALS"
For dealing with the classical families of orthogonal polynomials, the
package relies on the \fImath::polynomials\fR package\&. To evaluate the
polynomial at some coordinate, use the \fIevalPolyn\fR command:
.CS


   set leg2 [::math::special::legendre 2]
   puts "Value at x=$x: [::math::polynomials::evalPolyn $leg2 $x]"

.CE
.PP
The return value from the \fIlegendre\fR and other commands is actually
the definition of the corresponding polynomial as used in that package\&.
.SH "REMARKS ON THE IMPLEMENTATION"
It should be noted, that the actual implementation of J0 and J1 depends
on straightforward Gaussian quadrature formulas\&. The (absolute) accuracy
of the results is of the order 1\&.0e-4 or better\&. The main reason to
implement them like that was that it was fast to do (the formulas are
simple) and the computations are fast too\&.
.PP
The implementation of J1/2 does not suffer from this: this function can
be expressed exactly in terms of elementary functions\&.
.PP
The functions J0 and J1 are the ones you will encounter most frequently
in practice\&.
.PP
The computation of I_n is based on Miller's algorithm for computing the
minimal function from recurrence relations\&.
.PP
The computation of the Gamma and Beta functions relies on the
combinatorics package, whereas that of the error functions relies on the
statistics package\&.
.PP
The computation of the complete elliptic integrals uses the AGM
algorithm\&.
.PP
Much information about these functions can be found in:
.PP
Abramowitz and Stegun: \fIHandbook of Mathematical Functions\fR
(Dover, ISBN 486-61272-4)
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fImath :: special\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
Bessel functions, error function, math, special functions
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2004 Arjen Markus <arjenmarkus@users\&.sourceforge\&.net>

.fi
