<?xml version='1.0' encoding="UTF-8"?>
<!-- Copyright (C) 2013 ApPeAL Group, Politecnico di Torino This file is 
	part of TraCI4J. TraCI4J is free software: you can redistribute it and/or 
	modify it under the terms of the GNU General Public License as published 
	by the Free Software Foundation, either version 3 of the License, or (at 
	your option) any later version. TraCI4J is distributed in the hope that it 
	will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
	of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General 
	Public License for more details. You should have received a copy of the GNU 
	General Public License along with TraCI4J. If not, see <http://www.gnu.org/licenses/>. -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<!--
BEGIN underscore-to-mixedCase conversion
see http://stackoverflow.com/a/2647656/327648 
 -->

<xsl:variable name="vLower" select="'abcdefghijklmnopqrstuvwxyz'"/>
<xsl:variable name="vUpper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

 <xsl:template name="underscoreToMixedCase">
  <xsl:param name="pText"/>

  <xsl:if test="$pText">
   <xsl:value-of select="substring($pText,1,1)"/>

   <xsl:value-of select="substring-before(substring(translate($pText, $vUpper, $vLower), 2), '_')"/>

   <xsl:call-template name="underscoreToMixedCase">
     <xsl:with-param name="pText"
       select="substring-after(substring($pText,2), '_')"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>

<!--
END underscore-to-mixedCase conversion
 -->


<xsl:param name="queries-file-name" />

<xsl:variable name="queries" select="document($queries-file-name)" />

<xsl:template match="/traciClass">

/*
    THIS FILE IS GENERATED AUTOMATICALLY. DO NOT EDIT: CHANGES WILL BE OVERWRITTEN.
    File generated by traciObject.xslt.
*/

/*   
    Copyright (C) 2013 ApPeAL Group, Politecnico di Torino

    This file is part of TraCI4J.

    TraCI4J is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TraCI4J is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TraCI4J.  If not, see &lt;http://www.gnu.org/licenses/&gt;.
*/


package it.polito.appeal.traci;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
<xsl:value-of select="javadoc"/>
*/
public class <xsl:value-of select="name"/> 
extends TraciObject&lt;<xsl:value-of select="name"/>.Variable&gt;
implements StepAdvanceListener
{

	/**
	 * Enumerates all the read queries. Each value can be used as an argument
	 * for {@link TraciObject#getReadQuery(Enum)}.
	 * 
	 * @author Enrico Gueli &amp;lt;enrico.gueli@polito.it&amp;gt;
	 */	
	public static enum Variable {
		<xsl:for-each select="readQueries/readQuery">
		/** 
		 * Query "<xsl:value-of select="name"/>"
		 * @see {@link #query<xsl:value-of select="name"/>}
		 */
		<xsl:value-of select="enum"/>,
		</xsl:for-each>
	}
	
	<xsl:for-each select="changeStateQueries/changeStateQuery">
	private final <xsl:value-of select="query"/> csqvar_<xsl:value-of select="name"/>;
	</xsl:for-each>
	
	<xsl:value-of select="name"/> (
		DataInputStream dis,
		DataOutputStream dos, 
		String id
		<xsl:for-each select="repos/repo">
			, Repository&lt;<xsl:apply-templates/>&gt; repo<xsl:apply-templates/>
		</xsl:for-each>
	) {
		super(id, Variable.class);

		/*
		 * initialization of read queries
		 */
		<xsl:for-each select="readQueries/readQuery">
		<xsl:variable name="query-class" select="query" />
		<xsl:variable name="query-data" select="$queries/queries/query[class=$query-class]" />
		addReadQuery(Variable.<xsl:value-of select="enum"/>, 
				new <xsl:value-of select="query"/> (dis, dos, 
				<xsl:value-of select="../../command"/>, 
				id, 
				<xsl:value-of select="const"/>
				<xsl:for-each select="$query-data/usedRepos/repo">
				, repo<xsl:apply-templates/>
				</xsl:for-each>
				
				));
		</xsl:for-each>

		/*
		 * initialization of change state queries
		 */
		<xsl:for-each select="changeStateQueries/changeStateQuery">
		csqvar_<xsl:value-of select="name"/> = new <xsl:value-of select="query"/>(dis, dos, id
		<xsl:if test="const">, <xsl:value-of select="../../changeStateCommand"/>, <xsl:value-of select="const"/></xsl:if>)
		<xsl:if test="affects">{
			@Override
			void pickResponses(java.util.Iterator&lt;it.polito.appeal.traci.protocol.ResponseContainer&gt; responseIterator)
					throws TraCIException {
				super.pickResponses(responseIterator);
				<xsl:for-each select="affects/affect">
				query<xsl:apply-templates/>().setObsolete();
				</xsl:for-each>
			}
		}</xsl:if>;
		</xsl:for-each>
	
	}
	
	<!-- CACHE CLEANER -->
	
	@Override
	public void nextStep(double step) {
		<xsl:for-each select="readQueries/readQuery[dynamic='true']">
		getReadQuery(Variable.<xsl:value-of select="enum"/>).setObsolete();
		</xsl:for-each>
	}
	
	
	<!-- QUERY GETTERS -->
	
	<xsl:for-each select="readQueries/readQuery">
	<xsl:variable name="getterReturnType">
		<xsl:choose>
			<xsl:when test="returnType!=''">ReadObjectVarQuery&lt;<xsl:value-of select="returnType"/>&gt;</xsl:when>
			<xsl:otherwise><xsl:value-of select="query"/></xsl:otherwise>		
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="javadocLinkReturnType">
		<xsl:choose>
			<xsl:when test="returnType!=''">ReadObjectVarQuery</xsl:when>
			<xsl:otherwise><xsl:value-of select="query"/></xsl:otherwise>		
		</xsl:choose>
	</xsl:variable>
	/**
	 * @return the instance of {@link <xsl:value-of select="$javadocLinkReturnType"/>} relative to this query.
	 */
	public <xsl:value-of select="$getterReturnType"/> query<xsl:value-of select="name" />() {
		return (<xsl:value-of select="query"/>) getReadQuery(Variable.<xsl:value-of select="enum"/>);
	}
	
	<xsl:if test="returnType!=''">
	<xsl:variable name="mixedCaseQueryName">
		<xsl:call-template name="underscoreToMixedCase">
			<xsl:with-param name="pText" select="concat(enum, '_')"/>
		</xsl:call-template>
	</xsl:variable>
	/**
	 * Executes an instance of {@link <xsl:value-of select="$javadocLinkReturnType"/>} relative to this query,
	 * and returns the corresponding value.
	 */
	public <xsl:value-of select="returnType"/> get<xsl:value-of select="$mixedCaseQueryName" />() throws IOException {
		return ((<xsl:value-of select="query"/>) getReadQuery(Variable.<xsl:value-of select="enum"/>)).get();
	}
	</xsl:if>
	
	</xsl:for-each>
	
	<!--  QUERY SETTERS -->
	
	<xsl:for-each select="changeStateQueries/changeStateQuery">
		<xsl:variable name="query-class" select="query" />
		<xsl:variable name="query-data" select="$queries/queries/query[class=$query-class]" />
	/**
	 * @return the instance of {@link <xsl:value-of select="query"/>} relative to this query.
	 */
	public <xsl:value-of select="query" /> query<xsl:value-of select="name"/>() {
		return csqvar_<xsl:value-of select="name"/>;
	}
	
	<xsl:variable name="valueType" select="$query-data/changeValueType"/>
	<xsl:if test="$valueType">
	<xsl:variable name="mixedCaseQueryName" select="concat(translate(substring(name, 1, 1), $vUpper, $vLower), substring(name,2))"/>
	/**
	 * Execute an instance of <xsl:value-of select="query"/> set to the given value.
	 * <br/>
	 * This setter method is equivalent to query<xsl:value-of select="name"/>().setValue(value).run().
	 */
	public void <xsl:value-of select="$mixedCaseQueryName"/>(<xsl:value-of select="$valueType"/> value) throws IOException {
		<xsl:value-of select="query"/> q = csqvar_<xsl:value-of select="name"/>;
		q.setValue(value);
		q.run();
	}
	</xsl:if>
	</xsl:for-each>
}

</xsl:template>
 
</xsl:stylesheet>