/*
 * Decompiled with CFR 0.152.
 */
package ari.ucidy;

import ari.ucidy.UCD;
import ari.ucidy.UCDSyntax;
import java.util.Objects;

public class UCDWord {
    protected static final String NAMESPACE_SEP = ":";
    protected static final String IVOA_NAMESPACE = "ivoa";
    public static final String REGEXP_UCD_ATOM = "[a-zA-Z0-9][a-zA-Z0-9\\-_]*";
    public static final String REGEXP_UCD_WORD = "([a-zA-Z0-9][a-zA-Z0-9\\-_]*:)?[a-zA-Z0-9][a-zA-Z0-9\\-_]*(\\.[a-zA-Z0-9][a-zA-Z0-9\\-_]*)*";
    public final UCDSyntax syntaxCode;
    public final String rawWord;
    public final String namespace;
    public final String word;
    public final String description;
    public final boolean valid;
    public final boolean recognised;
    public final boolean recommended;
    public final UCDWord[] closest;
    public final UCD suggestedReplacement;

    public UCDWord(UCDSyntax syntax, String word, String description, boolean recommended) throws NullPointerException {
        if (word == null) {
            throw new NullPointerException("Missing UCD word!");
        }
        this.syntaxCode = syntax;
        this.rawWord = word;
        this.description = description;
        this.suggestedReplacement = null;
        int indSep = this.rawWord.indexOf(NAMESPACE_SEP);
        if (indSep > 0) {
            this.namespace = this.rawWord.substring(0, indSep);
            this.word = this.rawWord.substring(indSep + 1);
        } else {
            this.namespace = null;
            this.word = this.rawWord;
        }
        this.valid = this.rawWord.matches(REGEXP_UCD_WORD);
        this.recognised = this.valid && this.syntaxCode != null;
        this.recommended = recommended && this.recognised && (this.namespace == null || this.namespace.equalsIgnoreCase(IVOA_NAMESPACE));
        this.closest = null;
    }

    public UCDWord(String word) throws NullPointerException {
        this(word, null);
    }

    protected UCDWord(String word, UCDWord[] closestMatches) throws NullPointerException {
        if (word == null) {
            throw new NullPointerException("Missing UCD word!");
        }
        this.syntaxCode = null;
        this.rawWord = word;
        this.description = null;
        this.suggestedReplacement = null;
        int indSep = this.rawWord.indexOf(NAMESPACE_SEP);
        if (indSep > 0) {
            this.namespace = this.rawWord.substring(0, indSep);
            this.word = this.rawWord.substring(indSep + 1);
        } else {
            this.namespace = null;
            this.word = this.rawWord;
        }
        this.valid = this.rawWord.matches(REGEXP_UCD_WORD);
        this.recognised = false;
        this.recommended = false;
        this.closest = closestMatches != null && closestMatches.length == 0 ? null : closestMatches;
    }

    protected UCDWord(String word, UCD suggestedReplacement, UCDSyntax syntax, String description) throws NullPointerException, IllegalArgumentException {
        if (word == null) {
            throw new NullPointerException("Missing UCD word!");
        }
        if (suggestedReplacement == null) {
            throw new NullPointerException("Missing UCD replacement for the given deprecated UCD word (\"" + word + "\")!");
        }
        if (!suggestedReplacement.isAllRecognised()) {
            throw new IllegalArgumentException("Incorrect UCD replacement for the given deprecated UCD word (\"" + word + "\"): \"" + suggestedReplacement + "\"! It must be fully valid and recognised.");
        }
        this.syntaxCode = syntax;
        this.rawWord = word;
        this.description = description == null || description.trim().length() <= 0 ? null : description.trim();
        this.suggestedReplacement = suggestedReplacement;
        int indSep = this.rawWord.indexOf(NAMESPACE_SEP);
        if (indSep > 0) {
            this.namespace = this.rawWord.substring(0, indSep);
            this.word = this.rawWord.substring(indSep + 1);
        } else {
            this.namespace = null;
            this.word = this.rawWord;
        }
        this.valid = this.rawWord.matches(REGEXP_UCD_WORD);
        this.recognised = false;
        this.recommended = false;
        this.closest = null;
    }

    public final boolean isDeprecated() {
        return this.suggestedReplacement != null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UCDWord) {
            UCDWord anotherWord = (UCDWord)obj;
            if (this.word.equalsIgnoreCase(anotherWord.word)) {
                return (this.namespace == null || this.namespace.equalsIgnoreCase(IVOA_NAMESPACE)) && (anotherWord.namespace == null || anotherWord.namespace.equalsIgnoreCase(IVOA_NAMESPACE)) || this.namespace != null && anotherWord.namespace != null && this.namespace.equalsIgnoreCase(anotherWord.namespace);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.namespace == null ? Objects.hash(IVOA_NAMESPACE, this.word.toLowerCase()) : Objects.hash(this.namespace.toLowerCase(), this.word.toLowerCase());
    }

    public String toString() {
        return this.rawWord;
    }
}

