// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - INRIA - Serge Steer <serge.steer@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- Non-regression test for bug 3810 -->
//
// <-- CLI SHELL MODE -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/3810
//
// <-- Short Description -->
// Insertion in string array and polynomial array may be very slow

T=[];
N=[ (5:9)*10000 (1:9)*100000];
for n=N
  clear t
  timer();t(1:n)="foo";T=[T timer()];
end
//check for quasi linear evolution of T(n)
abc=T/[N.^2;N;ones(N)];
if abc(1)/norm(abc(2:3))>1d-3 then pause,end

T=[];
for n=N
  clear t
  timer();t(2,1:n)="foo";T=[T timer()];
end
//check for quasi linear evolution of T(n)
abc=T/[N.^2;N;ones(N)];
if abc(1)/norm(abc(2:3))>1d-3 then pause,end

T=[];
for n=N
  clear t
  timer();t(1:n,3)="foo";T=[T timer()];
end
//check for quasi linear evolution of T(n)
abc=T/[N.^2;N;ones(N)];
if abc(1)/norm(abc(2:3))>1d-3 then pause,end

T=[];
N=[ (5:9)*10000 (1:9)*100000];
for n=N
  clear t
  timer();t(n)="foo";T=[T timer()];
end
//check for quasi linear evolution of T(n)
abc=T/[N.^2;N;ones(N)];
if abc(1)/norm(abc(2:3))>1d-3 then pause,end

T=[];
for n=N
  clear t
  timer();t(2,n)="foo";T=[T timer()];
end
//check for quasi linear evolution of T(n)
abc=T/[N.^2;N;ones(N)];
if abc(1)/norm(abc(2:3))>1d-3 then pause,end

T=[];
for n=N
  clear t
  timer();t(n,3)="foo";T=[T timer()];
end
//check for quasi linear evolution of T(n)
abc=T/[N.^2;N;ones(N)];
if abc(1)/norm(abc(2:3))>1d-3 then pause,end
