% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itis_hierarchy.R
\name{itis_hierarchy}
\alias{itis_hierarchy}
\title{ITIS hierarchy}
\usage{
itis_hierarchy(tsn, what = "full", ...)
}
\arguments{
\item{tsn}{One or more TSN's (taxonomic serial number). Required.}

\item{what}{One of full (full hierarchy), up (immediate upstream), or down
(immediate downstream)}

\item{...}{Further arguments passed on to \code{\link[ritis:hierarchy]{ritis::hierarchy_full()}}
\code{\link[ritis:hierarchy]{ritis::hierarchy_up()}} or \code{\link[ritis:hierarchy]{ritis::hierarchy_down()}}}
}
\description{
Get hierarchies from TSN values, full, upstream only, or
immediate downstream only
}
\details{
Note that \code{\link[=itis_downstream]{itis_downstream()}} gets taxa downstream to a
particular rank, while this function only gets immediate names downstream.
}
\examples{
\dontrun{
# Get full hierarchy
itis_hierarchy(tsn=180543)

# Get hierarchy upstream
itis_hierarchy(tsn=180543, "up")

# Get hierarchy downstream
itis_hierarchy(tsn=180543, "down")

# Many tsn's
itis_hierarchy(tsn=c(180543,41074,36616))
}
}
\seealso{
\code{\link[=itis_downstream]{itis_downstream()}}
}
