## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = rlang::is_installed("modeldata")
)

## ----setup--------------------------------------------------------------------
library(rsample)

## ----message=FALSE------------------------------------------------------------
library(dplyr)

## -----------------------------------------------------------------------------
data(ames, package = "modeldata")
head(ames, 2)

## -----------------------------------------------------------------------------
data(Chicago, package = "modeldata")
head(Chicago, 2)

## -----------------------------------------------------------------------------
head(Orange, 2)

## -----------------------------------------------------------------------------
set.seed(123)

## -----------------------------------------------------------------------------
initial_split(ames)

## -----------------------------------------------------------------------------
initial_split(ames, prop = 0.8)

## -----------------------------------------------------------------------------
resample <- initial_split(ames, prop = 0.6)

head(training(resample), 2)
head(testing(resample), 2)

## -----------------------------------------------------------------------------
vfold_cv(ames, v = 2)

## -----------------------------------------------------------------------------
vfold_cv(ames, v = 2, repeats = 2)

## -----------------------------------------------------------------------------
mc_cv(ames, prop = 0.8, times = 2)

## -----------------------------------------------------------------------------
bootstraps(ames, times = 2)

## -----------------------------------------------------------------------------
three_way_split <- initial_validation_split(ames, prop = c(0.6, 0.2))
three_way_split

## -----------------------------------------------------------------------------
validation_set(three_way_split)

## -----------------------------------------------------------------------------
vfold_cv(ames, v = 2, strata = Sale_Price)

## -----------------------------------------------------------------------------
vfold_cv(ames, v = 2, strata = Sale_Price, breaks = 100)

## -----------------------------------------------------------------------------
resample <- group_initial_split(Orange, group = Tree)

unique(training(resample)$Tree)
unique(testing(resample)$Tree)

## -----------------------------------------------------------------------------
set.seed(1)
group_bootstraps(ames, Neighborhood, times = 2)

## -----------------------------------------------------------------------------
group_vfold_cv(ames, Neighborhood, balance = "observations", v = 2)

## -----------------------------------------------------------------------------
initial_time_split(Chicago)

initial_validation_time_split(Chicago)

## -----------------------------------------------------------------------------
sliding_window(Chicago) %>%
  head(2)

## -----------------------------------------------------------------------------
sliding_index(Chicago, date) %>%
  head(2)

## -----------------------------------------------------------------------------
sliding_period(Chicago, date, "year") %>%
  head(2)

## -----------------------------------------------------------------------------
rolling_origin(Chicago) %>%
  head(2)

