% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createContrast.R
\name{createContrast}
\alias{createContrast}
\alias{createContrast.character}
\alias{createContrast.lm}
\alias{createContrast.gls}
\alias{createContrast.lme}
\alias{createContrast.lvmfit}
\alias{createContrast.list}
\alias{createContrast.mmm}
\title{Create Contrast matrix}
\usage{
createContrast(object, ...)

\method{createContrast}{character}(
  object,
  name.param,
  diff.first = FALSE,
  add.rowname = TRUE,
  rowname.rhs = TRUE,
  ...
)

\method{createContrast}{lm}(object, par, add.variance, ...)

\method{createContrast}{gls}(object, par, add.variance, ...)

\method{createContrast}{lme}(object, par, add.variance, ...)

\method{createContrast}{lvmfit}(object, par = NULL, var.test = NULL, ...)

\method{createContrast}{list}(object, par = NULL, add.variance = NULL, var.test = NULL, ...)

\method{createContrast}{mmm}(object, par = NULL, add.variance = NULL, var.test = NULL, ...)
}
\arguments{
\item{object}{a \code{ls.lvmfit} object.}

\item{...}{[internal] Only used by the generic method.}

\item{name.param}{[internal] the names of all the model coefficients.}

\item{diff.first}{[logical] should the contrasts between the first and any of the other coefficients define the null hypotheses.}

\item{add.rowname}{[internal] should a name be defined for each hypothesis.}

\item{rowname.rhs}{should the right hand side of the null hypothesis be added to the name.}

\item{par}{[vector of characters] expression defining the linear hypotheses to be tested. See the examples section.}

\item{add.variance}{[logical] should the variance coefficients be considered as model coefficients?
Required for lm, gls, and lme models.}

\item{var.test}{[character] a regular expression that is used to identify the coefficients to be tested using \code{grep}. Each coefficient will be tested in a separate hypothesis. When this argument is used, the argument \code{par} is disregarded.}
}
\value{
A list containing
\itemize{
\item{contrast} [matrix] a contrast matrix corresponding to the left hand side of the linear hypotheses.
\item{null} [vector] the right hand side of the linear hypotheses.
\item{Q} [integer] the rank of the contrast matrix.
\item{ls.contrast} [list, optional] the contrast matrix corresponding to each submodel.
Only present when the \code{argument} object is a list of models.
}
}
\description{
Returns a contrast matrix corresponding an object.
The contrast matrix will contains the hypotheses in rows and the model coefficients in columns.
}
\details{
One can initialize an empty contrast matrix setting the argument\code{par} to \code{character(0)}. \cr \cr

When using \code{multcomp::glht} one should set the argument \code{add.variance} to \code{FALSE}. \cr
When using \code{lavaSearch2::glht2} one should set the argument \code{add.variance} to \code{TRUE}.
}
\examples{
## Simulate data
mSim <- lvm(X ~ Age + Treatment,
            Y ~ Gender + Treatment,
            c(Z1,Z2,Z3) ~ eta, eta ~ treatment,
            Age[40:5]~1)
latent(mSim) <- ~eta
categorical(mSim, labels = c("placebo","SSRI")) <- ~Treatment
categorical(mSim, labels = c("male","female")) <- ~Gender
n <- 1e2
set.seed(10)
df.data <- lava::sim(mSim,n)

## Estimate separate models
lmX <- lava::estimate(lvm(X ~ -1 + Age + Treatment), data = df.data)
lmY <- lava::estimate(lvm(Y ~ -1 + Gender + Treatment), data = df.data)
lvmZ <- lava::estimate(lvm(c(Z1,Z2,Z3) ~ -1 + 1*eta, eta ~ -1 + Treatment), 
                 data = df.data)

## Contrast matrix for a given model
createContrast(lmX, par = "X~Age")
createContrast(lmX, par = c("X~Age=0","X~Age+5*X~TreatmentSSRI=0"))
createContrast(lmX, par = character(0))

## Contrast matrix for the join model
ls.lvm <- list(X = lmX, Y = lmY, Z = lvmZ)
createContrast(ls.lvm, var.test = "Treatment", add.variance = FALSE)
createContrast(ls.lvm, par = character(0), add.variance = FALSE)

## Contrast for multigroup models
m <- lava::lvm(Y~Age+Treatment)
e <- lava::estimate(list(m,m), data = split(df.data, df.data$Gender))
print(coef(e))
createContrast(e, par = "Y~TreatmentSSRI@1 - Y~TreatmentSSRI@2 = 0")
createContrast(e, par = "Y~TreatmentSSRI@2 - Y~TreatmentSSRI@1 = 0")
}
\concept{small sample inference}
