% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable-method.R
\name{xtable.emmGrid}
\alias{xtable.emmGrid}
\alias{xtable.summary_emm}
\alias{print.xtable_emm}
\title{Using \code{xtable} for EMMs}
\usage{
\method{xtable}{emmGrid}(x, caption = NULL, label = NULL, align = NULL,
  digits = 4, display = NULL, auto = FALSE, ...)

\method{xtable}{summary_emm}(x, caption = NULL, label = NULL,
  align = NULL, digits = 4, display = NULL, auto = FALSE, ...)

\method{print}{xtable_emm}(x, type = getOption("xtable.type", "latex"),
  include.rownames = FALSE, sanitize.message.function = footnotesize, ...)
}
\arguments{
\item{x}{Object of class \code{emmGrid}}

\item{caption}{Passed to \code{\link[xtable]{xtableList}}}

\item{label}{Passed to \code{xtableList}}

\item{align}{Passed to \code{xtableList}}

\item{digits}{Passed to \code{xtableList}}

\item{display}{Passed to \code{xtableList}}

\item{auto}{Passed to \code{xtableList}}

\item{...}{Arguments passed to \code{\link{summary.emmGrid}}}

\item{type}{Passed to \code{\link[xtable]{print.xtable}}}

\item{include.rownames}{Passed to \code{print.xtable}}

\item{sanitize.message.function}{Passed to \code{print.xtable}}
}
\value{
The \code{xtable} methods return an \code{xtable_emm}
object, for which its print method is \code{print.xtable_emm} .
}
\description{
These methods provide support for the \pkg{xtable} package, enabling 
polished presentations of tabular output from \code{\link{emmeans}}
and other functions.
}
\details{
The methods actually use \code{\link[xtable]{xtableList}},
because of its ability to display messages such as those for P-value
adjustments. These methods return an object of class \code{"xtable_emm"} --
an extension of \code{"xtableList"}. Unlike other \code{xtable} methods, the
number of digits defaults to 4; and degrees of freedom and \emph{t} ratios
are always formatted independently of \code{digits}. The \code{print} method
uses \code{\link[xtable:xtableList]{print.xtableList}}, and any \code{\dots} arguments are
passed there.
}
\examples{
if(requireNamespace("xtable"))
    emm_example("xtable")
    # Use emm_example("xtable", list = TRUE) # to just list the code
}
