% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.glmGamPoi}
\alias{residuals.glmGamPoi}
\title{Extract Residuals of Gamma Poisson Model}
\usage{
\method{residuals}{glmGamPoi}(
  object,
  type = c("deviance", "pearson", "randomized_quantile", "working", "response"),
  ...
)
}
\arguments{
\item{object}{a fit of type \code{glmGamPoi}. It is usually produced with a call to
\code{glm_gp()}.}

\item{type}{the type of residual that is calculated. See details for more information.
Default: \code{"deviance"}.}

\item{...}{currently ignored.}
}
\value{
a matrix with the same size as \code{fit$data}. If \code{fit$data} contains a \code{DelayedArray} than the
result will be a \code{DelayedArray} as well.
}
\description{
Extract Residuals of Gamma Poisson Model
}
\details{
This method can calculate a range of different residuals:
\describe{
\item{deviance}{The deviance for the Gamma-Poisson model is
\deqn{dev = 2 * (1/theta * log((1 + m * theta) / (1 + y * theta)) - y log((m + y * theta) / (y + y * m * theta)))}
and the residual accordingly is
\deqn{res = sign(y - m) sqrt(dev).}
}
\item{pearson}{The Pearson residual is \eqn{res = (y - m) / sqrt(m + m^2 * theta)}}
\item{randomized_quantile}{The randomized quantile residual was originally developed
by Dunn & Smyth, 1995. Please see that publication or \code{\link[statmod:qresiduals]{statmod::qresiduals()}} for more
information.}
\item{working}{The working residuals are \eqn{res = (y - m) / m}.}
\item{response}{The response residuals are \eqn{res = y - m}}
}
}
\seealso{
\code{\link[=glm_gp]{glm_gp()}} and `stats::residuals.glm()
}
