# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=8.0.0 --output=unicodedb_8_0_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '8.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x0c ABOVE RIGHT'
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x03 AN'
'\x05 AND '
'\n AND ARROW'
'\x0f AND COLD SWEAT'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x06 ARROW'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\t ASTERISK'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x05 BACK'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x05 BOAT'
'\x12 BRIGHTNESS SYMBOL'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\x07 CER-WA'
'\n CHARACTER'
'\x06 CHART'
'\x07 CHIKI '
'\x05 CHWV'
'\x07 CIRCLE'
'\n CONJOINED'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING ESH2'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\t DRACHMAS'
'\x07 ENGINE'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x06 FINAL'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\t HITTING '
'\x05 HOOK'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ICON'
'\x05 ILUT'
'\x03 IN'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x04 KEY'
'\x02 L'
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x08 MAKSURA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x06 MURDA'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\x0b OF HYGIEIA'
'\r OF THE HORNS'
'\x05 OPEN'
'\x07 OPEN-O'
'\r OPPOSING KUR'
'\x04 ORE'
'\x04 OUT'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
'\x12 OVER HI TIMES ASH'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x16 OVER STAMPED ENVELOPE'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DA'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GAL'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\x10 PLUS KAK PLUS A'
'\x0c PLUS KASKAL'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x12 PLUS PAP PLUS LU3'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\t PLUS SAG'
'\x11 PLUS SHA3 PLUS A'
'\t PLUS SHU'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x07 PLUS U'
'\t PLUS ZA7'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x07 POMMEE'
'\x04 POT'
'\x0c PUNCTUATION'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x0c RING LITTLE'
'\x08 ROTUNDA'
'\x06 RULER'
'\x02 S'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x07 SECANT'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIDE'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x12 THROUGH DESCENDER'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES BAD'
'\x10 TIMES DISH TENU'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\t TIMES HA'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x0b TIMES TAK4'
'\x08 TIMES U'
'\t TIMES UD'
'\x07 TO BAR'
'\x05 TONE'
'\x06 TONE-'
'\x0f TOUCHING INDEX'
'\x08 TTUDDAG'
'\x02 U'
'\x04 U U'
'\r VARIANT FORM'
'\x04 WEB'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE MIDDLE TILDE'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x0b WITH FLASH'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\r WITH JEGOGAN'
'\x0e WITH LONG LEG'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\x0f WITH RIGHT LEG'
'\n WITH RING'
'\x12 WITH SMILING EYES'
'\x11 WITH SOUND WAVES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x0b WITHIN DOT'
'\x07 WOLOSO'
'\x0b WRIST FLEX'
'\x02 X'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\t-LOW TONE'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x06-PIEUP'
'\n-POINTING '
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x08-X BELOW'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x080 BRONZE'
'\x050 DOO'
'\x050 DWO'
'\x030 E'
'\x0b0 FOOTSTOOL'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\x040 KO'
'\t0 LONG LE'
'\x040 MA'
'\x050 MAN'
'\x060 NGGI'
'\x060 NGGO'
'\x040 NI'
'\x060 NYON'
'\x060 NYUN'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x040 SA'
'\x070 SPEAR'
'\x030 U'
'\x030 W'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 YE'
'\x040 ZO'
'\x030-0'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x031 A'
'\x071 ARROW'
'\x041 BA'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DO'
'\x041 DU'
'\x051 DWE'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x061 GOLD'
'\x041 HA'
'\x081 HELMET'
'\x061 HORN'
'\x041 IN'
'\x041 KI'
'\x041 KU'
'\n1 LONG MBE'
'\x061 NDEE'
'\x031 O'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 PO'
'\x041 QI'
'\x041 RA'
'\x041 SA'
'\x041 SI'
'\x041 SU'
'\x051 TEE'
'\x051 TWO'
'\x041 VU'
'\x061 WINE'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-0'
'\x031-2'
'\x051-VAS'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0217'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x032 B'
'\x042 BU'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\x072 PLUS '
'\n2 PLUS ASH'
'\x052 POO'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x052 SEE'
'\x042 SO'
'\x042 TI'
'\x042 VI'
'\x042 WO'
'\x072 WOMAN'
'\x032 Y'
'\x042 YA'
'\x032-0'
'\x052-VAS'
'\x0220'
'\x0320B'
'\x0221'
'\x0222'
'\x0224'
'\t247 DIPTE'
'\x03253'
'\x0726 EYYY'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 PA'
'\t3 PLUS AN'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x043 TA'
'\x053 VEE'
'\x053 WEI'
'\x073 WHEEL'
'\x043 YU'
'\x033-0'
'\x053-VAS'
'\x0230'
'\x03305'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0233'
'\x0234'
'\x0236'
'\x0238'
'\x0239'
'\x014'
'\x034 A'
'\x054 ABB'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x044 KE'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x044 NE'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x044 TE'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WA'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x044 ZE'
'\x034-0'
'\x054-VAS'
'\x0240'
'\x0242'
'\x0248'
'\x0249'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AN'
'\x045 AU'
'\t5 BATHTUB'
'\x045 BB'
'\t5 CYPERUS'
'\x045 DE'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 JU'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x065 MERI'
'\x045 MO'
'\x055 NDU'
'\x075 NGGEE'
'\x045 NU'
'\x045 OO'
'\x045 TE'
'\x045 TO'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WE'
'\x045 WO'
'\x065 WOOL'
'\x035-0'
'\x055-VAS'
'\x0250'
'\x0253'
'\x0255'
'\x03550'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x046 JE'
'\x046 JO'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x046 NA'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 TA2'
'\x066 TREE'
'\x056 WEE'
'\x046 WU'
'\x036-0'
'\x056-VAS'
'\x0262'
'\x03620'
'\x0264'
'\x036D7'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 DI'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x047 JA'
'\x057 JEE'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 VO'
'\x047 ZA'
'\x057-VAS'
'\x0270'
'\x0271'
'\x0272'
'\x0372C'
'\x0279'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x038 A'
'\x048 BO'
'\x048 DU'
'\x038 E'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x038 I'
'\x048 JI'
'\x038 K'
'\x088 KANAKO'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x058 NWA'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 SI'
'\x049 SO'
'\x049 TA'
'\x049 TO'
'\x049 TU'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x04904A'
'\x0291'
'\x0292'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A HAAM'
'\x06A MFON'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\tA PLUS NA'
'\x08A SIGN A'
'\nA TANG LAI'
'\x07A WITH '
'\rA WITH STROKE'
'\x05A YUE'
'\x04A-HA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x03AAF'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\x03AB2'
'\nAB2 TIMES '
'\x03ABA'
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\x06ABOVE '
'\x0eABOVE REVERSE '
'\x03AC '
'\x13ACCENT ATNAH HAFUKH'
'\rACCOMMODATION'
'\x03ACE'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x02AE'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x0eAFETY SCISSORS'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x06AGOGUE'
'\tAGOLITIC '
'\x04AGON'
'\x08AGRAPHOS'
'\x02AH'
'\x08AH WITH '
'\x04AHAD'
'\x08AHAPRANA'
'\x05AHMI '
'\x02AI'
'\x0fAI LAING DIGIT '
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\x02AJ'
'\x06AJANI '
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x03AK4'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x05ALLOT'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x05ALPHA'
'\x08ALTERNAT'
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x08AM WITH '
'\x04AMBA'
'\x07AME DIE'
'\tAME WITH '
'\x03AMI'
'\x04AMLA'
'\x04AMMA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\x04AN X'
'\x03AN2'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x0fAND FEMALE SIGN'
'\x12AND LOW RIGHT RING'
'\x18AND MALE AND FEMALE SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\nANDHI MARK'
'\nANDRABINDU'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANG CITI '
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x08ANI SIGN'
'\x04ANJI'
'\x08ANS SIGN'
'\x0fANS-SERIF ARROW'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x03AR '
'\x04ARA3'
'\x04ARAE'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDNESS'
'\nARFUL FACE'
'\x05ARGE '
'\x03ARK'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x03ARL'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x08ARRIVING'
'\x05ARROW'
'\x06ARROW '
'\x12ARROW SHAFT WIDTH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x0eARSI YEH WITH '
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x05ASAL '
'\x04ASAT'
'\x17ASCENDING MUSICAL NOTES'
'\x03ASE'
'\x03ASH'
'\x16ASH AMPERSAND ORNAMENT'
'\x04ASH2'
'\x06ASHGAB'
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATAKANA '
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x14ATIN CAPITAL LETTER '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x07AUGHTS '
'\x03AUJ'
'\x04AULA'
'\x07AULDRON'
'\x03AUM'
'\x07AUNTLET'
'\x03AUS'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x0eAVY CHECK MARK'
'\x02AW'
'\x05AWAY '
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x03AYD'
'\nAYER BEADS'
'\x06AYEROK'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x03BAD'
'\x03BAG'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x03BAL'
'\x05BALAG'
'\x04BALL'
'\rBALLPOINT PEN'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rBASAN LETTER '
'\tBASE UNIT'
'\x04BASH'
'\x08BATAEAN '
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x03BEL'
'\x05BELOW'
'\x05BENDE'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x08BEVERAGE'
'\x06BGBIEE'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x03BIN'
'\x07BINING '
'\x0cBINING MARK '
'\x05BISAH'
'\x06BISCUS'
'\tBITE LIPS'
'\x0fBJOINED LETTER '
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\nBLACK FLAG'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\x04BLOW'
'\x0cBLOWING FACE'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x11BOTTOM HALF BLACK'
'\x15BOTTOM U-SHAPED ARROW'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x19BREVE WITH INVERTED BREVE'
'\x0cBREVE-MACRON'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x04BSET'
'\x03BSP'
'\nBSTRUCTION'
'\x02BU'
'\x03BU '
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C CLEF'
'\x06C SIGN'
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x04CAKE'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x04CANO'
'\x07CAP TEN'
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x05CECAK'
'\x05CECEK'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x06CER-WA'
'\x05CEREK'
'\x0eCERTAINTY SIGN'
'\x04CESS'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x06CHAMKO'
'\x14CHARACTER INTRODUCER'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHERY'
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x05CHIME'
'\x0bCHING CHICK'
'\x06CHIRET'
'\x03CHO'
'\x05CHOOI'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x03CHU'
'\x06CHURCH'
'\x04CHWA'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x04CIM '
'\x05CING '
'\x06CIRCLE'
'$CIRCLE CONTAINING BLACK SMALL CIRCLE'
'\rCIRCLE INSIDE'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\rCITATION MARK'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x05CKING'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x1bCOMBINING CANDRABINDU ABOVE'
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\tCONJOINED'
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x16CONSONANT SIGN MEDIAL '
'\x11CONSONANT SIGN PA'
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x07CROSSED'
'\x0cCROSSED-TAIL'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GABA'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x15CRUCIFORM NUMBER FOUR'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x06CTOPUS'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x04CURL'
'\x08CURLICUE'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x04D HA'
'\x0bD MIDDLE UP'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x0eD-UP NEWSPAPER'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DA2'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\tDATE MARK'
'\x04DBAG'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDDA'
'\x05DDING'
'\x02DE'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x07DHALATH'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\tDIAERESIS'
'\rDIAERESIZED U'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\rDIC MARK SIGN'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x08DIM GUNU'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x04DIUM'
'\x05DIUM '
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x1fDMINTON RACQUET AND SHUTTLECOCK'
'\x10DMISSION TICKETS'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x10DOTTED CRESCENTS'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\nDOUBLE BAR'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\rDOUBLE MUCAAD'
'\x0bDOUBLE RING'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x04DOWN'
'\x05DOWN '
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x03DUG'
'\x0cDUG TIMES NI'
'\tDUN3 GUNU'
'\x0eDUN3 GUNU GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\tE AT LEFT'
'\x05E GEE'
'\x07E GLASS'
'\x06E HOOK'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\x10E PLUS GAN2 TENU'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E0'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x04EACE'
'\x03EAD'
'\x07EAD ORE'
'\x05EAGLE'
'\x04EANS'
'\nEARLY FORM'
'\x0bEARS OF JOY'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EATH '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'\x08ED BRICK'
'\x07ED FACE'
'\x06ED ICE'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x0eED PARAGRAPHOS'
'\x07ED RICE'
'\tEDESTRIAN'
'\nEDESTRIANS'
'\x06EDIAL '
'\x05EDIC '
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x04EEM '
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x15EFT HORIZONTAL SECANT'
'\x15EFT-POINTING TRIANGLE'
'\x14EFTWARDS ARROW WITH '
'\x0fEFTWARDS ARROWS'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\x06EIGHTY'
'\x16EIGHTY ON BLACK SQUARE'
'\x03EIN'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x03ELF'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x03ELT'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0bEN STRAIGHT'
'\x0bEN TWELFTHS'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x04ENCH'
'\nENCH FRIES'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\nENGER SHIP'
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x03EOW'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\tER BUBBLE'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\tERMOMETER'
'\x05ERN W'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x06ERTED '
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x08ESCENDER'
'\x0fESEL LOCOMOTIVE'
'\x1dESENTATION FORM FOR VERTICAL '
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x02ET'
'\x03ET '
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\nEVANAGARI '
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\rEVEN TWELFTHS'
'\x06EVENTY'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x06EXAGON'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x06EXHALE'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EYK'
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\rF WITH STROKE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x06FAMILY'
'\x04FAST'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FEUQ'
'\x06FF OF '
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIER '
'\x05FIFTY'
'\x06FIFTY '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\tFINAL NGA'
'\tFINAL NUN'
'\x08FINAL TH'
'\x07FINAL Y'
'\x08FINGER C'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x0cFIVE HUNDRED'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x15FLATTENED PARENTHESIS'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLICT'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\nFLUTTERING'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x08FOR STOP'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\nFOUR BELOW'
'\tFOUR BENT'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x08FROM BAR'
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT RERENGGAN'
'\x13FT-POINTING FLEURON'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x18GAF WITH INVERTED STROKE'
'\x03GAG'
'\x03GAH'
'\x03GAI'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x03GAR'
'\x08GARITIC '
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x05GAZE-'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x06GERINE'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x0bGGAGE CLAIM'
'\x05GGER '
'\nGGING FACE'
'\x12GGLY VERTICAL LINE'
'\nGGRAVATION'
'\x02GH'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x04GIDA'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GIR2'
'\x04GISH'
'\x12GISH CROSSING GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'!GOLIAN LETTER MANCHU ALI GALI LHA'
'\x0bGONEK ABOVE'
'\x04GONG'
'\x03GOU'
'\x02GR'
'\x07GRADUAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0bGREEK CROSS'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x0eGUNU TIMES ASH'
'\x03GUR'
'\x05GVANG'
'#GVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x02GW'
'\x02GY'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x03HAB'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x05HALA '
'\x04HALF'
'\x05HALF '
'\x11HALF BLACK CIRCLE'
'\x08HALF GUR'
'\tHALF NOTE'
'\x0fHALF RING ABOVE'
'\tHALF SIGN'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMEDH'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x0cHAND FORMAT '
'\tHAND SIGN'
'\x17HAND TELEPHONE RECEIVER'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\tHARD SIGN'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x03HEA'
'\x04HEAD'
'\x05HEAD '
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x08HEAVY YA'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x12HEN WITH DIAERESIS'
'\x04HENG'
'\x03HER'
'\x06HERMES'
'\nHERMOMETER'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x07HEXAGON'
'\x16HEXIFORM LONG ANUSVARA'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\rHI TIMES ASH2'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x04HIGH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x03HII'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x05HIMEL'
'\x03HIN'
'\rHINESE TONE Y'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x05HIRTY'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x08HITTING '
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOM'
'\x04HOM '
'\x03HOO'
'\x04HOOK'
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x06HORT A'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\rHOUGHT BUBBLE'
'\x08HOULDER '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
' HREE DOTS POINTING UPWARDS BELOW'
'\x0cHREE FINGERS'
'\tHREE FOR '
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x05HROOM'
'\x04HSHU'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x02HU'
'\x04HUB2'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\nHUNGARIAN '
'\x03HUR'
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\x02HW'
'\x03HWA'
'\tHWA WITH '
'\x04HWAH'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x06I GUNU'
'\x06I HOOK'
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES BAD'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x02I0'
'\x03IAB'
'\rIAERESIS-RING'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x06IAMOND'
'\x07IAMOND '
'\x0eIAMOND CENTRED'
'\x04IAN '
'\x0bIAN LETTER '
'\x0eIAN RUPEE SIGN'
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IAUDA'
'\x06IB YAM'
'\x02IC'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x12ICKET BAT AND BALL'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\x06IFIED '
'\x07IFIED E'
'\x04IFTY'
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\nIGATING RA'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x06IGGLES'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\rIGHT TWELFTHS'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\tIGHTH ASH'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\tIGN NUKTA'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x1bIN BUSINESS SUIT LEVITATING'
'\x0cIN MIDDLE UP'
'\tIN SQUARE'
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\tING LANES'
'\nING LITTLE'
'\x07ING OF '
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x06INHALE'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x06INKING'
'\x07INNABAR'
'\nINOCULAR O'
'\x0eINOLOGICAL DOT'
'\x03INS'
'\x06INSHIP'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x08INVERTED'
'\tINVERTED '
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INY '
'\x04INYA'
'\x03ION'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x05IRACY'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x05IRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x06IRCLES'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x05IRCUT'
'\x04IRED'
'\x03IRL'
'\x04IRON'
'\x08IRPLANE '
'\x0cIRST SUBUNIT'
'\x04IRTY'
'\x02IS'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\rISH LIRA SIGN'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x11ITALIC LETTER ESS'
'\x15ITALIC SMALL DOTLESS '
'\x04ITAR'
'\x0bITARY MEDAL'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\x05ITLO '
'\tITRA SIGN'
'\x04ITSA'
'\x07ITTING '
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE SLOW SIGN'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\nIXTHS DISH'
'\x04IXTY'
'\x14IXTY ON BLACK SQUARE'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x03IYO'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x03JOA'
'\x06JOINED'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\nJONG TILE '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x07K WITH '
'\x02K-'
'\x05K-020'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x03KAM'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x03KAU'
'\x06KAVYKA'
'\x06KAYAH '
'\x05KBALL'
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x05KESH2'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x07KHA YAT'
'\x04KHAH'
'\x07KHAMTI '
'\x14KHAMTI REDUPLICATION'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x07KIEVAN '
'\x06KILLER'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING FACE'
'\x04KINI'
'\rKISIM5 TIMES '
'\x0fKISIM5 TIMES BI'
'\x04KISS'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x0bKTIESELSKAB'
'\x05KTOP '
'\x02KU'
'\x03KU3'
'\x03KUE'
'\x03KUG'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x06KY WAY'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x03LAA'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x0bLACK CIRCLE'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x0bLACKLETTER '
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x03LAH'
'\x03LAI'
'\x07LAK-050'
'\x03LAL'
'\x03LAM'
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\nLANE MERGE'
'\x1aLANTED SOUTH ARROW WITH HO'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\tLARGEMENT'
'\x03LAS'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x08LATION X'
'\x15LATTENED OPEN A ABOVE'
'\x03LAU'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x0bLCE TSA CAN'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\tLD TAMIL '
'\x04LDE '
'\x04LDER'
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
'\nLEFT-HAND '
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x17LEFT-SHADED WHITE ARROW'
'\x12LEFT-STEM TONE BAR'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\x03LEI'
'\nLEK ATTAK '
'\x06LENDAR'
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x05LENIS'
'\x04LEPH'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x06LETTER'
'\x07LETTER '
'\tLETTER KH'
'\x0bLETTER LLLA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x02LF'
'\x03LF '
'\x07LF FACE'
'\x03LFA'
'\x04LFER'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\nLIMITATION'
'\x04LINE'
'\x05LINE '
'\x0eLINE EXTENSION'
'\x0bLINE FILLER'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x04LIPS'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x08LL MOON '
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x03LLE'
'\x07LLEYBUS'
'\x06LLHORN'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x07LLOWING'
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOAN '
'\x05LOBE '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x04LONG'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG FINAL'
'\nLONG OVER '
'\tLONG TIP '
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x16LOW PARAPHRASE BRACKET'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x08LOW TONE'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x02LT'
'\tLTERNATE '
'\nLTERNATE U'
'\x0bLTERNATE YA'
'\nLTIC CROSS'
'\x06LTILLO'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x0cLU PLUS ESH2'
'\x0bLU PLUS IGI'
'\x03LU3'
'\x03LUB'
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x05LWAY '
'\x02LX'
'\x02LY'
'\x04LY H'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x08M SYMBOL'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'#MALL ARABIC LETTER TAH AND TWO DOTS'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x06MALL F'
'\x0cMALL LETTER '
'\x15MALL Q WITH HOOK TAIL'
'\x0cMALL SECTION'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAQ'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\nMARK ABOVE'
'\tMARK CIM '
'\x0eMARK LOWER DOT'
'\rMARKS CHAPTER'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x03MAY'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\tMBOL FOR '
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\nME PLUS EN'
'\x08MEASURE '
'\x04MED '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x05MENOE'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x0bMIC LETTER '
'\x03MID'
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE HOOK'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\nMILLE SIGN'
'\x08MILLIONS'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\rMINDER RIBBON'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\x05MISRA'
'\x03MIT'
'\x04MIZE'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'\x10MODIFIER LETTER '
'"MODIFIER LETTER LABIALIZATION MARK'
'\rMODIFIER MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\x0bMONOCULAR O'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x03MPL'
'\x05MROCK'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x02MU'
'\x04MUAS'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x08MULTIPLE'
'\x15MULTIPLE MEASURE REST'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x12N VIEWING CEREMONY'
'\x07N WITH '
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x03NAH'
'\x04NAKE'
'\nNAKE BELOW'
'\x04NAM2'
'\x04NANT'
'\x03NAP'
'\x03NAR'
'\x0cNARROW SHAFT'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x03NAU'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x05NCORA'
'\x02ND'
'\x03ND '
'\x0bND OF PIECE'
'\x0bND TWO DOTS'
'\x03ND-'
'\x08NDA FACE'
'\nNDA PA NJI'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x03NE '
'\x07NE FEED'
'\x06NE OF '
'\x04NED '
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x04NEMA'
'\x05NENOE'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x0bNEUTRAL YER'
'\x03NEY'
'\x07NFINITY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x03NG '
'\x08NG ABOVE'
'\x0bNG LEFT LEG'
'\x11NG STROKE OVERLAY'
'\x14NG WITH CROSSED-TAIL'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\x0bNGER BUBBLE'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x05NGUE '
'\x02NI'
'\x08NI ABOVE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x0bNIKOLSBURG '
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x06NINETY'
'\x05NING '
'\tNING MOOD'
'\rNING MOVEMENT'
'\tNING SIGN'
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x06NNADA '
'\x03NNI'
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\x0bNOON GHUNNA'
'\nNOON WITH '
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x04NOSE'
'\x05NOTCH'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x04NOWC'
'\x08NOWLEDGE'
'\x06NOWMAN'
'\x08NRES TOS'
'\x04NRUA'
'\tNS-SERIF '
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x05NTAIN'
'\x18NTED NORTH ARROW WITH HO'
'\tNTESSENCE'
'\x05NTHA '
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x05NTXIV'
'\x02NU'
'\x03NUB'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x03NYA'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x05O BOX'
'\tO HUNDRED'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x07OCALIC '
'\x08OCALIC M'
'\x07OCATION'
'\tOCCLUSION'
'\x06OCENCE'
'\x08OCK SALT'
'\x05OCKET'
'\x0bOCOLATE BAR'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\tOENICIAN '
'\x03OF '
'\x0bOF ENVELOPE'
'\x0bOF MASHFAAT'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x07OGICAL '
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\rOHIBITED SIGN'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x1eOJI MODIFIER FITZPATRICK TYPE-'
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\x05OKARA'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x07OLAPUK '
'\x03OLD'
'\x04OLD '
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x10OLD WHITE CIRCLE'
'\x05OLDER'
'\x0bOLDING BACK'
'\x06OLIDUS'
'\x04OLIN'
'\x03OLL'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x03OM '
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\x08OMANIAN '
'\tOMBINING '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x0eOMING ENVELOPE'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x07ON FACE'
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\rONAL COMPUTER'
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\x14ONE MARK SGAW KAREN '
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x03ONG'
'\x04ONG '
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\tONG GRAVE'
'\x05ONG S'
'\x0bONG S WITH '
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x10ONJOINING MACRON'
'\tONSONANT '
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x03OPH'
'\x05OPLET'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\x06ORPION'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x04ORTY'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x07OTATION'
'\x0eOTHERS CIRCLED'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x08OTPRINTS'
'\x0cOTTOM HALF O'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x13OUR DOT PUNCTUATION'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\tOURA SIGN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\nOUT HANDLE'
'\x07OUT HUB'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\tOUTH WIND'
'\nOUTHERN TA'
'\x04OVAL'
'\x15OVAL WITH OVAL INSIDE'
'\x05OVER '
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\tOVER LONG'
'\tOVER MUSH'
'\x16OVER NU11 BUR OVER BUR'
'\x08OVER NUN'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SAG'
'\x08OVER SHE'
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x03OWN'
'\rOWN POINTING '
'\x15OWN-POINTING TRIANGLE'
'\x03OX '
'\x07OX BACK'
'\x02OY'
'\x07OYSTICK'
'\x03OZE'
'\x06OZENGE'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\tP ELAMITE'
'\x11P ON BLACK SQUARE'
'\x07P PIEET'
'\nP STREAMER'
'\x0cP TACK ABOVE'
'\x07P WITH '
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x05PARAQ'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x0cPE CARTRIDGE'
'\x11PE WITH DESCENDER'
'\x06PEAKS '
'\x0cPEECH BUBBLE'
'\x04PEEI'
'\x04PEEP'
'\x03PEN'
'\x04PEN '
'\x05PEN E'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x06PEPPER'
'\x03PER'
'\x04PER '
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x18PERSET PRECEDING SOLIDUS'
'\x08PERSIAN '
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x04PHAB'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\x06PICKET'
'\x07PICTURE'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUG'
'\x04PLUM'
'\x05PLUS '
'\nPLUS ERIN2'
'\x14PLUS GISH TIMES TAK4'
'\x08PLUS LAL'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x18POINTING DOWNWARDS ABOVE'
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\nPOLICE CAR'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\x0ePPED MIDDLE UP'
'\nPPING BAGS'
'\tPPOINTED '
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x08PRESSION'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x05PTIC '
'\x05PTIVE'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x08PUSHPIKA'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x06PWATCH'
'\x01Q'
'\x07Q WITH '
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIG'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\tQUADCOLON'
'\x0fQUADRUPLE ARROW'
'\x13QUADRUPLE CRESCENTS'
' QUALS SIGN ABOVE LEFTWARDS ARROW'
'\x05QUARE'
'\x06QUARE '
'\x06QUARED'
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x0cQUARTER SIGN'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\tQUEEN OF '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\tR COASTER'
'\x06R FACE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x03R S'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x02R0'
'\x02R2'
'\x07R2 GUNU'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x05RADA '
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
' RAISED HAND WITH FINGERS SPLAYED'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x08RAL FACE'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x04RAN '
'\x0cRANCHING OUT'
'\rRANGE DIAMOND'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x14RANSPOSITION BRACKET'
'\x07RARIETY'
'\x05RASHA'
'\x03RAT'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x08RAUGHTS '
'\x06RAVEL-'
'\x03RAY'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD DISK'
'\x07RD FACE'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\nRDHACANDRA'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x08RECEIVER'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\nRED CIRCLE'
'\nRED DRAGON'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x13REE-QUARTER CIRCLE '
'\x05REEK '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x05RELAA'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x03REN'
'\x06RENGTH'
'\x04REPA'
'\x10REPETITION MARK-'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x08REVERSE '
'\x0fREVERSE SOLIDUS'
'\tREVERSED '
'\x0fREVERSED OPEN E'
'\x0eREVERSED-SCHWA'
'\x04RFER'
'\x02RG'
'\nRGE CIRCLE'
'\nRGE SQUARE'
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x0cRIAGE RETURN'
'\x0cRIAL TRAMWAY'
'\x07RIANGLE'
'\x12RIANGLE ARROWHEADS'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x17RIGHT HORIZONTAL SECANT'
'\x14RIGHT POINTING INDEX'
'\x0fRIGHT RERENGGAN'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'\x0bRIGHT-HAND '
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x14RIGHT-POINTING ANGLE'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x06RIKRIK'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\nRING BELOW'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\nRING THUMB'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x07RINKLES'
'\tRIPLE DOT'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x07RIPPLE '
'\x05RIPT '
'\x06RIPT G'
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x03RK '
'\rRK SUNGLASSES'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x06RLICUE'
'\x03RMT'
'\x0cRMUKHI SIGN '
'\x05RNED '
'\x02RO'
'\x03RO '
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\x06ROCKET'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROITIC '
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x0cROLLING EYES'
'\x03ROM'
'\x03RON'
'\x1bRONOMICAL SYMBOL FOR URANUS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x04ROSH'
'\x04ROSS'
'\x0eROSS ON SHIELD'
'\x08ROSSED O'
'\x0bROSSED-TAIL'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\rRPENTRY PLANE'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\rRRIAGE SYMBOL'
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\nRROW WITH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x04RSO-'
'\x02RT'
'\x06RT OF '
'\rRTABLE STEREO'
'\tRTER MARK'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x05RUMP-'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x07S BELOW'
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\x02S0'
'\x02SA'
'\x07SA VAH '
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAD'
'\x03SAG'
'\x03SAH'
'\x03SAL'
'\rSAL PLUS TUG2'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x03SAM'
'\x10SAMARITAN SOURCE'
'\x06SANDAL'
'\x07SANDHI '
'\x04SANG'
'\x07SANGAN '
'\x10SANS-SERIF ARROW'
'\x03SAR'
'\x05SARGA'
'\x05SASAK'
'\x03SAU'
'\x03SAW'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x08SCRIPT X'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\tSEMICOLON'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x07SEVENTH'
'\x02SH'
'\x13SH PLUS HU PLUS ASH'
'\tSH SYMBOL'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\tSHAB CEEB'
'\x04SHAD'
'\x06SHADDA'
'\x04SHAE'
'\x07SHAKING'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x12SHAN REDUPLICATION'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x07SHESHIG'
'\x0eSHESHIG TIMES '
'\x05SHGAB'
'\x03SHI'
'\x07SHIFT T'
'\x05SHIMA'
'\x04SHIN'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x0bSHOGI PIECE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x08SHORT ER'
'\x0fSHORT OVER LONG'
'\x0fSHORT RIGHT LEG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x05SHTIN'
'\x04SHU2'
'\x10SHU2 PLUS KASKAL'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\nSIDEWAYS I'
'\x14SIDEWAYS NOON GHUNNA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x11SIGN O WITH CROSS'
'\x07SIGN UD'
'\x03SII'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x13SLANTED NORTH ARROW'
'\x05SLASH'
'\x05SMALL'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\rSMALL LETTERS'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\x02SO'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x06SOUTH '
'\x0eSOUTH ARABIAN '
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x05SPINE'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x04SQUE'
'\x08SQUEEZED'
'\x0cSQUIQUADRATE'
'\x02SS'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x0fSSICAL BUILDING'
'\x04SSOM'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x07STATERS'
'\tSTEBASKET'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x04STLE'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x0bSTORIC SITE'
'\x03STR'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x18STROKE THROUGH DESCENDER'
'\x0eSTRONG ISOLATE'
'\nSTRUCTION '
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x13SUBSTITUTION MARKER'
'\x04SUCK'
'\x06SUCKED'
'\x04SUKU'
'\x06SULAR '
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x03SUU'
'\x07SVARITA'
'\x0bSVASTI SIGN'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x0bT SEPARATOR'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x05TAGON'
'\x06TAGRAM'
'\x03TAH'
'\x17TAH WITH TWO DOTS ABOVE'
'\nTAI LAING '
'\x0fTAI LAING TONE-'
'\x08TAI LUE '
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x06TARGET'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAW'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\x06TEDUNG'
'\x03TEE'
'\x05TEGEH'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENSE'
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x07THIEUTH'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0fTHREE DISH TENU'
'\x10THREE DOTS ABOVE'
'\x0eTHREE POINTED '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x03THW'
'\x02TI'
'\x06TICAL '
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES KUR'
'\tTIMES NA2'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\tTIN CROSS'
'\x05TING '
'\nTING HEART'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x07TLESS J'
'\x05TMAAU'
'\x05TNESS'
'\x02TO'
'\x06TO BAR'
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x03TOM'
'\x0bTONAL MARK '
'\x04TONE'
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x05TONE-'
'\x06TONGUE'
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x05TRACK'
'\x0cTRAGRAM FOR '
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x03TRE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x03TRI'
'\x0bTRIAN CAMEL'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x05TROKE'
'\x05TROL '
'!TRONG CENTRALIZATION STROKE BELOW'
'\x03TSA'
'\x03TSE'
'\x05TSEEB'
'\x02TT'
'\x03TTE'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x03TUJ'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\x05TURN '
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x13TURNED SECTION MARK'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x05U U U'
'\x07U WITH '
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x02U0'
'\x02U2'
'\nU2 PLUS BA'
'\x02U3'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x03UAM'
'\nUAM TSHOOJ'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB '
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x04UBLE'
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x10UBLE PARENTHESIS'
'\x06UBLE R'
'\x0fUBLE RING BELOW'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x05UDAAT'
'\x06UDATTA'
'\x08UDAWADI '
'\x0fUDIO MICROPHONE'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x02UG'
'\x03UG2'
'\x06UGGAGE'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x04UHUR'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x05ULAR '
'\x07ULATION'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x05UMPET'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x04UND '
'\x05UNDER'
'\x06UNDER '
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x03UNO'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\x18UP WITH EXCLAMATION MARK'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\x08UPLOYAN '
'\rUPONDIUS SIGN'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\x06UR OF '
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URL'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x11URNED DAMMA BELOW'
'\x08UROPEAN '
'\x03URT'
'\x03URU'
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US TENT'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\x06USHPIN'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x02UT'
'\x04UTAE'
'\x05UTEUX'
'\x04UTH '
'\x0bUTH CORNERS'
'\nUTH OR SPY'
'\x05UTIES'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02V0'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\x07VANESE '
'\x07VAPOURS'
'\x07VARIANT'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\x08VE SASAK'
'\tVE THUMB '
'\x03VE-'
'\x04VEDE'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\tVELOPMENT'
'\x07VEMENT-'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\x06VERLAP'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x17VERTICAL BAR WITH QUILL'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x08VESSEL B'
'\x07VESTAN '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x03VIN'
'\x04VINE'
'\tVINE LEAF'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC L'
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x0eVONIC ASTERISK'
'\x03VOP'
'\x0cVORCE SYMBOL'
'\x04VOS '
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\nW OR MODEL'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x03WAN'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x0bWE PALAUNG '
'\x18WELVE POINTED BLACK STAR'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x05WFISH'
'\x02WG'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x0cWHITE SQUARE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\nWHOLE NOTE'
'\x02WI'
'\x05WIANG'
'\x04WIDE'
'\x05WIDTH'
'\x11WIGGLY LINE BELOW'
'\x07WIGNYAN'
'\x06WINDOW'
'\x05WINDU'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x0eWITH LEFT HOOK'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\x0cWITH STROKE '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WM'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\nWO FINGERS'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\nWO-HEADED '
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\x06WRENCH'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x02X '
'\nX POINTED '
'\x07X WITH '
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x16XCLAMATION MARK SYMBOL'
'\x02XE'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x04XEYN'
'\x02XG'
'\tXHAUSTION'
'\nXHEEJ CEEV'
'\x02XI'
'\x06XIMIZE'
'\x05XING '
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x15XTRA SHORT VOWEL MARK'
'\x05XTRA-'
'\x03XWG'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x08Y SMALL '
'\x0eY SMALL SQUARE'
'\nY THOUSAND'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x03YAN'
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\x06YIN-DO'
'\nYING CARD '
'\rYING ENVELOPE'
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x05YIZET'
'\x08YLLABLE '
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x04YODH'
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x02YP'
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x06YRENE '
'\x08YRILLIC '
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\tZIR SASAK'
'\x04ZIZ2'
'\x02ZO'
'\x03ZOA'
'\x03ZOO'
'\nZU OVER ZU'
'\x08ZWARAKAY'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68804,
 -54631,
 -1,
 132652,
 48923,
 -1,
 198179,
 98568,
 -1,
 263553,
 175478,
 -1,
 327930,
 224175,
 -1,
 393401,
 268454,
 74167,
 458852,
 354385,
 -1,
 524324,
 398734,
 -1,
 589846,
 463215,
 75009,
 720895,
 526845,
 -1,
 720910,
 638747,
 -1,
 -65524,
 698393,
 75019,
 -65523,
 734392,
 75018,
 -1,
 790914,
 75017,
 983057,
 701573,
 -1,
 -65520,
 933038,
 75016,
 -1,
 991402,
 75015,
 -65518,
 945117,
 75014,
 -65517,
 1141591,
 75013,
 -65516,
 1195099,
 75012,
 -65515,
 1254783,
 75011,
 -1,
 1319589,
 75010,
 1507362,
 529546,
 75021,
 1638399,
 1444349,
 -1,
 1638427,
 1556251,
 -1,
 -65510,
 1615897,
 75030,
 -1,
 1651896,
 75029,
 1835037,
 1596829,
 75024,
 -1,
 1770302,
 75025,
 -65506,
 1813536,
 75028,
 -65505,
 1938522,
 75027,
 -65504,
 1999386,
 75026,
 -65503,
 2051427,
 75023,
 -1,
 2112565,
 75022,
 -65501,
 1446844,
 75020,
 -1,
 2232401,
 75008,
 2424889,
 463813,
 -1,
 2490415,
 2364357,
 -1,
 2555950,
 2430959,
 74993,
 2686975,
 2492925,
 -1,
 2687019,
 2593846,
 -1,
 -65494,
 2659392,
 74997,
 -1,
 2717376,
 74996,
 -65492,
 2670502,
 74998,
 -65491,
 2842013,
 74995,
 -1,
 2904414,
 74994,
 -1,
 2494555,
 74992,
 3145780,
 2430959,
 -1,
 -65487,
 3085465,
 75006,
 -65486,
 3150503,
 75005,
 -65485,
 3215746,
 75004,
 -1,
 3280722,
 75003,
 3473463,
 3085465,
 -1,
 -65482,
 3413598,
 75000,
 -1,
 3477330,
 74999,
 -65480,
 3413989,
 75002,
 -1,
 3610393,
 75001,
 3801160,
 2363218,
 -1,
 3866685,
 3741502,
 -1,
 -65476,
 3805417,
 74974,
 -1,
 3870546,
 74973,
 4063296,
 3806361,
 -1,
 -65473,
 4001883,
 74970,
 -1,
 4067154,
 74969,
 4259907,
 4002178,
 -1,
 -65470,
 4199577,
 74967,
 -1,
 4264027,
 74966,
 -65468,
 4200597,
 74975,
 -65467,
 4396841,
 74972,
 -65466,
 4462160,
 74971,
 -65465,
 4527010,
 74968,
 -1,
 4591691,
 74965,
 4784212,
 3740034,
 -1,
 4849741,
 4723074,
 -1,
 -65461,
 4790078,
 74982,
 -65460,
 4854937,
 74981,
 -1,
 4919122,
 74980,
 5111888,
 4789646,
 -1,
 -65457,
 5051790,
 74985,
 -1,
 5117081,
 74984,
 5308499,
 5050459,
 -1,
 -65454,
 5249007,
 74979,
 -1,
 5312338,
 74978,
 -1,
 5247935,
 74983,
 5570653,
 4723367,
 -1,
 5636185,
 5510085,
 -1,
 -65449,
 5576510,
 74988,
 -65448,
 5641822,
 74987,
 -1,
 5706407,
 74986,
 5898332,
 5576510,
 -1,
 -65445,
 5837765,
 74990,
 -1,
 5903015,
 74989,
 -1,
 5838986,
 74991,
 6160480,
 5510750,
 -1,
 -65441,
 6100109,
 75032,
 -1,
 6165124,
 75031,
 6357091,
 6099035,
 -1,
 -65438,
 6296711,
 74977,
 -1,
 6362018,
 74976,
 -1,
 6296950,
 75007,
 6619315,
 413027,
 -1,
 6684845,
 6563108,
 74168,
 6815743,
 6619136,
 -1,
 6815916,
 6732204,
 -1,
 6881392,
 6756518,
 74169,
 6946925,
 6817489,
 -1,
 -65429,
 6909083,
 74172,
 -65428,
 6966798,
 74171,
 -1,
 7025997,
 74170,
 -65426,
 6925120,
 74175,
 -65425,
 7175994,
 74174,
 -1,
 7236527,
 74173,
 7405687,
 6864667,
 74213,
 7471220,
 7341777,
 -1,
 -65421,
 7454514,
 74215,
 -1,
 7477414,
 74214,
 -65419,
 7449366,
 74218,
 -65418,
 7615672,
 74217,
 -1,
 7672353,
 74216,
 7864448,
 7383205,
 -1,
 7929983,
 7819768,
 -1,
 7995515,
 7913379,
 74207,
 -1,
 7931876,
 74208,
 8126590,
 7955762,
 -1,
 -65411,
 8107756,
 74206,
 -1,
 8165209,
 74205,
 -1,
 8076604,
 74204,
 -1,
 7914018,
 74209,
 8454279,
 7825437,
 -1,
 8519813,
 8437531,
 -1,
 8585348,
 8481711,
 74194,
 -1,
 8521506,
 74195,
 -1,
 8524455,
 74193,
 8847359,
 8477251,
 74191,
 -1,
 8748858,
 74192,
 8913037,
 8408340,
 -1,
 8978570,
 8896787,
 74182,
 -1,
 8914712,
 74183,
 9109644,
 8919206,
 74180,
 -1,
 9083983,
 74181,
 -1,
 9067075,
 74632,
 9306258,
 8874927,
 -1,
 9371792,
 9289499,
 74198,
 -1,
 9333679,
 74199,
 -65391,
 9331859,
 74197,
 -1,
 9444343,
 74196,
 9633944,
 9263683,
 -1,
 9699479,
 9598732,
 74188,
 9830399,
 9635537,
 -1,
 -65386,
 9729700,
 74190,
 -1,
 9785870,
 74189,
 -1,
 9654235,
 74187,
 10027165,
 9614469,
 -1,
 10092700,
 9967782,
 -1,
 -65381,
 10053740,
 74211,
 -1,
 10112276,
 74210,
 -1,
 10042632,
 74212,
 10354849,
 9991948,
 -1,
 10420384,
 10304686,
 74200,
 -1,
 10356485,
 74201,
 -1,
 10405364,
 74202,
 10616997,
 10310136,
 -1,
 10682532,
 10557606,
 74184,
 -1,
 10644399,
 74185,
 -1,
 10640027,
 74186,
 10879144,
 10560804,
 -1,
 -65369,
 10836547,
 74177,
 -1,
 10885844,
 74176,
 -65367,
 10868251,
 74964,
 -65366,
 11042968,
 74203,
 -65365,
 11092362,
 74179,
 -1,
 11154884,
 74178,
 -1,
 6795504,
 74219,
 11468799,
 6659151,
 74220,
 11534335,
 11337728,
 -1,
 11534513,
 11450843,
 74221,
 -1,
 11470831,
 74222,
 11730943,
 11489677,
 74223,
 -1,
 11601401,
 74224,
 11796662,
 6584076,
 74228,
 11927551,
 11733625,
 74229,
 -1,
 11798453,
 74230,
 11993272,
 11758511,
 74226,
 -1,
 11930244,
 74227,
 -1,
 11950484,
 74225,
 12189942,
 376603,
 74235,
 12255465,
 12128642,
 74237,
 12386303,
 12189696,
 -1,
 12386530,
 12301445,
 -1,
 12452065,
 12344978,
 -1,
 12517572,
 12412957,
 -1,
 12583107,
 12458708,
 -1,
 12648642,
 12522151,
 74246,
 -1,
 12584672,
 74247,
 -1,
 12587394,
 74245,
 -1,
 12540483,
 74248,
 12910793,
 12495013,
 -1,
 12976328,
 12868163,
 -1,
 -65337,
 12937313,
 74255,
 -1,
 12977888,
 74254,
 -1,
 12933563,
 74635,
 13238477,
 12862667,
 74240,
 13369343,
 13172736,
 -1,
 -65332,
 13285100,
 74241,
 -1,
 13342585,
 74634,
 13500624,
 13218949,
 -1,
 -65329,
 13484412,
 74256,
 -1,
 13507877,
 75038,
 13697234,
 13472818,
 75036,
 -1,
 13633433,
 75037,
 13828309,
 13664058,
 -1,
 -65324,
 13811483,
 74253,
 -1,
 13843630,
 74252,
 14024920,
 13790173,
 -1,
 -65321,
 13979003,
 74250,
 -1,
 14026464,
 74249,
 14221531,
 13980152,
 -1,
 -65318,
 14178959,
 74243,
 -1,
 14228807,
 75035,
 -65316,
 14187045,
 74251,
 -65315,
 14376546,
 74244,
 -65314,
 14437863,
 74242,
 -65313,
 14497786,
 75034,
 -65312,
 14558591,
 74239,
 -1,
 14622023,
 74238,
 -1,
 12403449,
 74257,
 14876902,
 12363941,
 -1,
 14942437,
 14832937,
 74261,
 -1,
 14879237,
 74633,
 -1,
 14916460,
 74260,
 -65305,
 14847119,
 74259,
 -65304,
 15094162,
 75033,
 -1,
 15151980,
 74258,
 15335663,
 12209602,
 74263,
 15466495,
 15269888,
 -1,
 15466734,
 15369662,
 -1,
 -65299,
 15452161,
 74264,
 -1,
 15505677,
 74265,
 -1,
 15445038,
 74266,
 15728882,
 15300364,
 74269,
 15859711,
 15664654,
 74270,
 -1,
 15729450,
 74271,
 -65293,
 15690671,
 74268,
 -65292,
 15880696,
 74267,
 -65291,
 15930023,
 74262,
 -1,
 15993349,
 74236,
 16252927,
 12147267,
 74231,
 -65288,
 16165654,
 74234,
 -65287,
 16219431,
 74233,
 -1,
 16280495,
 74232,
 16449977,
 281876,
 -1,
 16515448,
 16390310,
 73909,
 16580964,
 16454018,
 73911,
 16711679,
 16515072,
 -1,
 16712035,
 16628140,
 -1,
 16777482,
 16665876,
 -1,
 16843014,
 16717990,
 74939,
 16908549,
 16817231,
 73932,
 17039359,
 16844497,
 -1,
 -65276,
 16941208,
 74941,
 -1,
 16987911,
 74940,
 -1,
 16875400,
 73931,
 17301503,
 16800323,
 73933,
 17301769,
 17175493,
 73934,
 -1,
 17237720,
 73935,
 -1,
 17276085,
 73936,
 17498389,
 16717990,
 -1,
 17563918,
 17476374,
 73917,
 17694719,
 17502594,
 74618,
 -1,
 17565454,
 73918,
 17760530,
 17499857,
 -1,
 -65264,
 17718685,
 73914,
 -65263,
 17781262,
 73913,
 -1,
 17839437,
 73912,
 18022676,
 17727290,
 73916,
 -1,
 17958706,
 74617,
 -1,
 17966397,
 73915,
 18219296,
 17475749,
 -1,
 18284828,
 18174456,
 -1,
 18350362,
 18242115,
 -1,
 -65255,
 18315020,
 74951,
 -1,
 18363576,
 73959,
 18612223,
 18300078,
 73957,
 -1,
 18483193,
 73958,
 18678047,
 18225318,
 -1,
 -65250,
 18652239,
 73956,
 -1,
 18705327,
 73955,
 -1,
 18661922,
 73960,
 18940203,
 18166968,
 -1,
 19005734,
 18923291,
 -1,
 19071269,
 18959655,
 -1,
 -65244,
 19032332,
 74937,
 -1,
 19094945,
 74936,
 -1,
 19014948,
 73926,
 19333418,
 18963011,
 73924,
 19464191,
 19298062,
 -1,
 -65239,
 19380699,
 73925,
 -1,
 19419533,
 74935,
 -1,
 19273894,
 73923,
 19661108,
 18901021,
 -1,
 19726639,
 19644187,
 -1,
 -65234,
 19705067,
 74943,
 -1,
 19731285,
 73948,
 19923249,
 19684336,
 73946,
 -1,
 19859299,
 73947,
 20119551,
 19863718,
 -1,
 -65229,
 20033164,
 73945,
 -1,
 20080669,
 73944,
 20250941,
 19616248,
 -1,
 20316475,
 20191398,
 -1,
 20382008,
 20278191,
 73938,
 -1,
 20318042,
 73939,
 20578303,
 20317905,
 -1,
 -65222,
 20477607,
 73937,
 -1,
 20519078,
 74942,
 -65220,
 20299785,
 73941,
 -1,
 20666980,
 73940,
 20840772,
 20217658,
 -1,
 20906306,
 20790446,
 74948,
 21037055,
 20842193,
 -1,
 -65215,
 20926424,
 74950,
 -1,
 20987293,
 74949,
 21233663,
 20890219,
 73952,
 -1,
 21104190,
 73953,
 21299530,
 20790446,
 -1,
 21365063,
 21266234,
 73929,
 -1,
 21301824,
 73930,
 21496137,
 21326767,
 73927,
 -1,
 21432154,
 73928,
 -1,
 21471422,
 74938,
 21692753,
 21243172,
 -1,
 21758287,
 21633190,
 -1,
 -65203,
 21732478,
 73920,
 -65202,
 21779405,
 74934,
 -1,
 21836984,
 73919,
 22085631,
 21742880,
 73921,
 -1,
 21956524,
 73922,
 22151510,
 21654447,
 -1,
 22217045,
 22091942,
 73949,
 22347775,
 22181644,
 74944,
 -1,
 22219385,
 74945,
 -1,
 22200716,
 74946,
 22479193,
 22134555,
 73962,
 22609919,
 22426808,
 73963,
 -1,
 22480636,
 73964,
 22675805,
 22443788,
 -1,
 -65189,
 22660596,
 74947,
 -65188,
 22698563,
 73951,
 -1,
 22756641,
 73950,
 22937952,
 22633027,
 -1,
 -65185,
 22915865,
 73943,
 -1,
 22958043,
 73942,
 -65183,
 22926859,
 74952,
 -65182,
 23115157,
 73961,
 -1,
 23171964,
 73954,
 -1,
 16683247,
 73965,
 23396714,
 16547642,
 73974,
 23527423,
 23335298,
 73975,
 23592959,
 23396352,
 -1,
 -65176,
 23508716,
 73976,
 -65175,
 23564536,
 73977,
 -1,
 23606046,
 73978,
 23789933,
 23358383,
 73970,
 -65172,
 23731808,
 73972,
 -1,
 23790351,
 73971,
 23986545,
 23733593,
 73966,
 24117247,
 23920640,
 -1,
 -65168,
 24028940,
 74953,
 -1,
 24064784,
 73967,
 24248691,
 23960655,
 73979,
 -1,
 24187559,
 73980,
 24379765,
 24196280,
 73968,
 -1,
 24315246,
 73969,
 -65162,
 24357769,
 73981,
 -65161,
 24475404,
 73973,
 -1,
 24511294,
 73910,
 24707481,
 16472643,
 73984,
 24772995,
 24681551,
 -1,
 24838529,
 24711847,
 73994,
 24969215,
 24775165,
 -1,
 -65155,
 24875900,
 73999,
 -65154,
 24934068,
 73998,
 -65153,
 24993181,
 73997,
 -65152,
 25054695,
 73996,
 -1,
 25106664,
 73995,
 25362431,
 24777090,
 73992,
 -1,
 25232190,
 73993,
 25428366,
 24750245,
 -1,
 25493901,
 25383416,
 74001,
 25624575,
 25427968,
 -1,
 25624972,
 25539717,
 -1,
 25690507,
 25583250,
 -1,
 -65143,
 25671061,
 74004,
 -65142,
 25710640,
 74955,
 -1,
 25765247,
 74003,
 -1,
 25641721,
 74005,
 -1,
 25572165,
 74002,
 -1,
 25435463,
 74000,
 26149266,
 25367493,
 73988,
 26279935,
 26083328,
 -1,
 -65135,
 26185986,
 73989,
 -1,
 26227512,
 73990,
 26411415,
 26083328,
 -1,
 26476950,
 26393004,
 -1,
 -65131,
 26459931,
 73986,
 -1,
 26492078,
 73985,
 -1,
 26424108,
 73987,
 -65128,
 26365204,
 74620,
 -1,
 26687404,
 73991,
 26870195,
 24690459,
 74006,
 26935715,
 26808706,
 74008,
 27066367,
 26869760,
 -1,
 27066786,
 26982828,
 -1,
 27132319,
 27027650,
 74009,
 -1,
 27069019,
 74010,
 -65120,
 27109723,
 74012,
 -65119,
 27231541,
 74011,
 -1,
 27286945,
 74956,
 -1,
 27021709,
 74013,
 27525546,
 26883256,
 74014,
 27656191,
 27459584,
 -1,
 27656616,
 27572652,
 -1,
 -65113,
 27618167,
 74016,
 -1,
 27662579,
 74015,
 -65111,
 27629412,
 74957,
 -1,
 27824395,
 74017,
 27984303,
 27499599,
 74021,
 28049838,
 27967259,
 -1,
 -65107,
 28027670,
 74024,
 -1,
 28081978,
 74023,
 -1,
 27989598,
 74022,
 28311985,
 27948812,
 74019,
 -1,
 28248719,
 74020,
 -65102,
 28273583,
 74018,
 -1,
 28377677,
 74007,
 28639231,
 26819758,
 -1,
 28639672,
 28552416,
 73982,
 28770303,
 28576253,
 -1,
 -65097,
 28688155,
 74954,
 -1,
 28732279,
 73983,
 -1,
 28578433,
 74619,
 28967488,
 16410653,
 -1,
 29032998,
 28907686,
 74071,
 29098511,
 28969469,
 -1,
 29163979,
 29052180,
 -1,
 29229507,
 29121091,
 74087,
 29295042,
 29207318,
 74624,
 29425663,
 29229056,
 -1,
 -65087,
 29333389,
 74089,
 -1,
 29373253,
 74090,
 -1,
 29269162,
 74088,
 29622728,
 29169830,
 74082,
 29688262,
 29596751,
 74085,
 -1,
 29624264,
 74086,
 -65081,
 29654920,
 74084,
 -1,
 29780911,
 74083,
 30015487,
 29605659,
 74091,
 -65078,
 29924544,
 74092,
 -1,
 29963448,
 74625,
 30147030,
 29141157,
 -1,
 30212562,
 30102008,
 -1,
 30278095,
 30195483,
 74115,
 -1,
 30239663,
 74629,
 -65072,
 30235632,
 74114,
 -65071,
 30358702,
 74113,
 -1,
 30415014,
 74112,
 30605780,
 30152870,
 74110,
 -1,
 30579791,
 74111,
 -65067,
 30589340,
 74117,
 -1,
 30694573,
 74116,
 30867934,
 30129947,
 74119,
 30933465,
 30841935,
 74963,
 -1,
 30871938,
 74631,
 -65062,
 30911254,
 74123,
 -65061,
 31030971,
 74122,
 -65060,
 31077560,
 74121,
 -65059,
 31134082,
 74120,
 -1,
 31197930,
 74962,
 31392230,
 30832396,
 -1,
 31457764,
 31341742,
 74100,
 31588351,
 31393489,
 -1,
 -65054,
 31503912,
 74103,
 -65053,
 31543256,
 74102,
 -1,
 31603742,
 74101,
 31850495,
 31414851,
 74104,
 -1,
 31721357,
 74105,
 31916525,
 31332518,
 74072,
 31982058,
 31894294,
 -1,
 -65047,
 31920807,
 74623,
 -1,
 31986050,
 74075,
 32178668,
 31929528,
 74073,
 -1,
 32114512,
 74074,
 -1,
 32146466,
 74622,
 32375284,
 31860004,
 -1,
 32440818,
 32315558,
 -1,
 -65040,
 32414799,
 74078,
 -65039,
 32468040,
 74077,
 -1,
 32519352,
 74076,
 -65037,
 32423707,
 74960,
 -1,
 32660035,
 74079,
 32834041,
 32335901,
 -1,
 32899575,
 32791107,
 74096,
 -1,
 32847032,
 74097,
 33095679,
 32839846,
 74961,
 -1,
 32991261,
 74095,
 33161725,
 32795567,
 -1,
 33227260,
 33144603,
 74099,
 -1,
 33191692,
 74627,
 -1,
 33184323,
 74098,
 33423872,
 33141893,
 -1,
 -65025,
 33406747,
 74630,
 -1,
 33431722,
 74118,
 33620483,
 33395494,
 -1,
 -65022,
 33577539,
 74108,
 -1,
 33626278,
 74628,
 33817094,
 33587002,
 -1,
 -65019,
 33800811,
 74107,
 -1,
 33832110,
 74106,
 34013705,
 33774147,
 -1,
 -65016,
 33978124,
 74094,
 -1,
 34033624,
 74093,
 34210316,
 33963182,
 -1,
 -65013,
 34188109,
 74081,
 -1,
 34251919,
 74080,
 -65011,
 34199007,
 74124,
 -65010,
 34383889,
 74109,
 -1,
 34428303,
 74626,
 34603541,
 29045944,
 -1,
 34669074,
 34542745,
 74131,
 -1,
 34604513,
 74132,
 -65005,
 34608069,
 74130,
 -65004,
 34738855,
 74129,
 -1,
 34804098,
 74128,
 34996761,
 34582156,
 74140,
 35127295,
 34930688,
 -1,
 -65000,
 35033405,
 74142,
 -1,
 35089490,
 74141,
 35258909,
 34958255,
 74135,
 35389439,
 35192832,
 -1,
 -64996,
 35305907,
 74136,
 -1,
 35337055,
 74137,
 35521056,
 35223308,
 -1,
 -64993,
 35460037,
 74139,
 -1,
 35524994,
 74138,
 35717666,
 35481629,
 74133,
 -1,
 35654235,
 74134,
 35848740,
 35656066,
 74125,
 -1,
 35783258,
 74126,
 -64987,
 35820341,
 74607,
 -1,
 35923236,
 74127,
 36110898,
 29015835,
 74154,
 36176425,
 36084815,
 74163,
 -1,
 36111680,
 74164,
 36307499,
 36137903,
 74160,
 -1,
 36242238,
 74161,
 36438573,
 36246469,
 74157,
 -1,
 36375279,
 74158,
 -64978,
 36416742,
 74165,
 -64977,
 36536122,
 74162,
 -64976,
 36574814,
 74159,
 -64975,
 36639399,
 74156,
 -1,
 36701592,
 74155,
 36897342,
 36067907,
 74144,
 36962872,
 36874405,
 -1,
 37028406,
 36920933,
 74152,
 -1,
 36963820,
 74153,
 -64969,
 36983288,
 74151,
 -1,
 37100871,
 74150,
 37290556,
 36899325,
 -1,
 37356091,
 37273371,
 74146,
 -1,
 37303480,
 74147,
 -1,
 37299583,
 74145,
 -64963,
 37257018,
 74149,
 -1,
 37500088,
 74148,
 -64961,
 36884874,
 74166,
 -1,
 37635275,
 74143,
 37814969,
 28944549,
 -1,
 37880449,
 37769720,
 -1,
 37945947,
 37837379,
 -1,
 38011473,
 37910284,
 74438,
 38141951,
 37947901,
 -1,
 38142535,
 38034845,
 74444,
 -1,
 38077246,
 74445,
 38273610,
 38085924,
 -1,
 -64951,
 38257181,
 74441,
 -1,
 38280519,
 74440,
 -64949,
 38250839,
 74449,
 -64948,
 38436475,
 74448,
 -64947,
 38500044,
 74447,
 -64946,
 38562683,
 74446,
 -64945,
 38620686,
 74443,
 -64944,
 38680510,
 74442,
 -1,
 38738086,
 74439,
 38928981,
 37985359,
 74451,
 39059455,
 38862848,
 -1,
 -64940,
 38975212,
 74452,
 -1,
 39031291,
 74453,
 39191129,
 38876344,
 74435,
 39321599,
 39127549,
 -1,
 -64936,
 39214690,
 74437,
 -1,
 39262374,
 74436,
 -64934,
 39171335,
 74454,
 -1,
 39420467,
 74450,
 39584362,
 37886118,
 74413,
 39649894,
 39522983,
 74414,
 39780351,
 39586301,
 -1,
 39780960,
 39698203,
 74421,
 -1,
 39716568,
 74422,
 -64927,
 39763375,
 74420,
 -64926,
 39890150,
 74419,
 -64925,
 39944344,
 74418,
 -64924,
 39997483,
 74417,
 -64923,
 40052095,
 74416,
 -1,
 40114342,
 74415,
 40305256,
 39589262,
 74423,
 -1,
 40241529,
 75057,
 -64919,
 40279210,
 74425,
 -1,
 40379730,
 74424,
 40567418,
 39533742,
 74426,
 40632949,
 40501248,
 -1,
 40698480,
 40605523,
 -1,
 -64914,
 40675799,
 75061,
 -64913,
 40730566,
 75060,
 -1,
 40786366,
 75059,
 40960628,
 40669682,
 75058,
 41091071,
 40894464,
 -1,
 -64909,
 41006361,
 74429,
 -1,
 41045379,
 74428,
 -1,
 40917435,
 74427,
 41288312,
 40610582,
 74432,
 -64905,
 41249951,
 74434,
 -1,
 41292162,
 74433,
 -64903,
 41254714,
 74431,
 -1,
 41438560,
 74430,
 41680895,
 40550171,
 74455,
 41681535,
 41554306,
 74457,
 41811967,
 41617105,
 -1,
 -64898,
 41696672,
 75063,
 -1,
 41761860,
 75062,
 -64896,
 41626188,
 74458,
 -1,
 41878990,
 74456,
 42074791,
 37820582,
 74387,
 42140323,
 42028308,
 74389,
 42270719,
 42074112,
 -1,
 42271391,
 42187180,
 -1,
 42336907,
 42254107,
 -1,
 -64889,
 42314518,
 74406,
 -64888,
 42376271,
 74405,
 -64887,
 42432268,
 74404,
 -64886,
 42476836,
 74403,
 -1,
 42537346,
 74402,
 42730128,
 42313893,
 -1,
 42795663,
 42684920,
 -1,
 -64882,
 42753008,
 74400,
 -1,
 42810586,
 75055,
 -1,
 42736967,
 74399,
 43057811,
 42710279,
 -1,
 -64878,
 43018348,
 75056,
 -1,
 43066660,
 74401,
 43254422,
 43018269,
 -1,
 -64875,
 43238688,
 74395,
 -1,
 43261207,
 74394,
 43451032,
 43203614,
 74391,
 -1,
 43394340,
 74392,
 -64871,
 43418933,
 74398,
 -64870,
 43547526,
 74397,
 -64869,
 43611856,
 74396,
 -64868,
 43670945,
 74646,
 -64867,
 43733518,
 74393,
 -64866,
 43794826,
 75054,
 -1,
 43849894,
 74390,
 44040865,
 42226061,
 74408,
 -1,
 43977297,
 75053,
 -64862,
 44012009,
 74407,
 -1,
 44139855,
 74388,
 44303013,
 42101679,
 74409,
 -1,
 44237803,
 74410,
 -64858,
 44276815,
 74412,
 -1,
 44401114,
 74411,
 44565168,
 42057499,
 74466,
 44630698,
 44538959,
 74473,
 -1,
 44570607,
 74474,
 44761772,
 44594956,
 74471,
 -1,
 44704421,
 74472,
 44892846,
 44709048,
 74468,
 -1,
 44831106,
 74469,
 -64849,
 44849669,
 74470,
 -1,
 44959369,
 74467,
 45219839,
 44522051,
 74459,
 45220532,
 45108500,
 74461,
 45350911,
 45159365,
 74462,
 -1,
 45221474,
 74463,
 45417143,
 45154304,
 -1,
 -64842,
 45398516,
 75064,
 -1,
 45437325,
 74460,
 -64840,
 45378537,
 74465,
 -1,
 45574238,
 74464,
 45744939,
 37762232,
 -1,
 45810420,
 45727515,
 73850,
 45875940,
 45763860,
 73857,
 45941475,
 45812221,
 -1,
 46006979,
 45902767,
 -1,
 46072514,
 45947046,
 -1,
 46138049,
 46036748,
 74911,
 -1,
 46074489,
 74912,
 -1,
 46098516,
 74910,
 -1,
 46055823,
 74913,
 46400201,
 45967389,
 -1,
 46465736,
 46382875,
 -1,
 46531271,
 46443750,
 74908,
 -1,
 46466883,
 74909,
 -1,
 46505039,
 74907,
 -1,
 46408396,
 74906,
 46793422,
 46353684,
 -1,
 46858957,
 46750275,
 74900,
 -64820,
 46836502,
 74902,
 -1,
 46898349,
 74901,
 -1,
 46799014,
 74899,
 47121106,
 46757644,
 -1,
 -64816,
 47077955,
 74916,
 -64815,
 47137925,
 74915,
 -1,
 47194789,
 74914,
 47383254,
 47061158,
 -1,
 47448789,
 47360790,
 74894,
 -1,
 47382859,
 74895,
 -1,
 47416354,
 74893,
 47645401,
 47360165,
 -1,
 -64808,
 47602248,
 74920,
 -1,
 47666238,
 74919,
 47842012,
 47600120,
 -1,
 -64805,
 47798851,
 74904,
 -1,
 47847590,
 74903,
 48038623,
 47789240,
 -1,
 -64802,
 48022123,
 74897,
 -1,
 48062152,
 74896,
 -64800,
 48010853,
 74918,
 -64799,
 48202266,
 74917,
 -64798,
 48258465,
 74905,
 -1,
 48317482,
 74898,
 -1,
 45924627,
 73858,
 48562921,
 45842234,
 73860,
 48628456,
 48501415,
 73861,
 48758783,
 48563006,
 73862,
 -1,
 48628542,
 73863,
 -1,
 48567237,
 73864,
 48890606,
 48506148,
 73854,
 48956141,
 48826877,
 -1,
 -64788,
 48933867,
 74614,
 -1,
 48973003,
 73855,
 -1,
 48894338,
 73856,
 49218290,
 48824320,
 -1,
 -64784,
 49196078,
 73853,
 -64783,
 49254611,
 73851,
 -1,
 49303949,
 73852,
 -64781,
 49192106,
 73865,
 -1,
 49435128,
 73859,
 49611550,
 45750438,
 73813,
 49677080,
 49564948,
 73814,
 49742615,
 49610752,
 -1,
 49808150,
 49703547,
 -1,
 49873662,
 49761556,
 -1,
 49939195,
 49830467,
 73821,
 -1,
 49913002,
 73822,
 50070269,
 49879206,
 73819,
 -1,
 50005878,
 73820,
 -1,
 50053395,
 73823,
 50266883,
 49834927,
 -1,
 50332418,
 50249499,
 73829,
 -64767,
 50296588,
 73831,
 -1,
 50333569,
 73830,
 -1,
 50272422,
 73828,
 50594568,
 50249499,
 -1,
 50660103,
 50532889,
 -1,
 -64762,
 50624912,
 74611,
 -1,
 50679846,
 73836,
 -1,
 50637590,
 73837,
 50922250,
 50553795,
 73825,
 -1,
 50857837,
 73826,
 51053325,
 50865444,
 -1,
 -64756,
 51010115,
 73818,
 -1,
 51060087,
 73817,
 51249936,
 50993318,
 -1,
 -64753,
 51214602,
 73816,
 -1,
 51251062,
 73815,
 -64751,
 51230101,
 73835,
 -64750,
 51424513,
 73834,
 -64749,
 51483725,
 73833,
 -64748,
 51544216,
 73832,
 -64747,
 51603650,
 73827,
 -1,
 51663374,
 73824,
 -1,
 49789373,
 74889,
 -1,
 49681063,
 74612,
 51970844,
 49650767,
 73839,
 52101119,
 51910822,
 -1,
 -64741,
 51975109,
 73841,
 -1,
 52040359,
 73840,
 -64739,
 51934988,
 73838,
 -1,
 52169370,
 74888,
 52428799,
 49568323,
 73842,
 52429606,
 52328204,
 73844,
 52495140,
 52365821,
 -1,
 -64734,
 52477798,
 74891,
 -64733,
 52538347,
 73845,
 -1,
 52583837,
 74890,
 52822015,
 52433282,
 73846,
 -1,
 52693679,
 74892,
 52888360,
 52407062,
 73849,
 -1,
 52824026,
 74613,
 53019434,
 52854586,
 73847,
 -1,
 52954042,
 73848,
 -1,
 52962596,
 73843,
 53216155,
 45727515,
 74507,
 53281641,
 53189711,
 74536,
 53347154,
 53264155,
 74551,
 53412688,
 53283325,
 -1,
 53478197,
 53366036,
 -1,
 53543732,
 53418150,
 74556,
 -64718,
 53517391,
 74559,
 -64717,
 53575560,
 74558,
 -1,
 53636015,
 74557,
 -1,
 53526299,
 74560,
 53871417,
 53460763,
 -1,
 -64713,
 53848089,
 74574,
 -64712,
 53884088,
 74573,
 -1,
 53937944,
 74572,
 54133566,
 53832623,
 -1,
 54199101,
 54116123,
 -1,
 -64708,
 54163212,
 74566,
 -1,
 54203047,
 75072,
 -1,
 54140190,
 75071,
 54461250,
 54090307,
 -1,
 -64704,
 54438678,
 74564,
 -64703,
 54490892,
 74563,
 -1,
 54546392,
 74562,
 54723397,
 54438053,
 -1,
 -64700,
 54680759,
 74570,
 -1,
 54744126,
 74569,
 54920008,
 54670520,
 -1,
 -64697,
 54903403,
 74555,
 -1,
 54927537,
 75070,
 55116618,
 54859942,
 74552,
 -1,
 55094341,
 74553,
 -64693,
 55098734,
 74571,
 -64692,
 55219068,
 74568,
 -64691,
 55278766,
 74567,
 -64690,
 55339585,
 74565,
 -64689,
 55398926,
 74561,
 -1,
 55453138,
 74554,
 55705599,
 53359942,
 74575,
 -1,
 55577254,
 74576,
 55772003,
 53285250,
 74539,
 55902207,
 55705600,
 -1,
 55903074,
 55818668,
 -1,
 55968603,
 55885595,
 -1,
 56034138,
 55906690,
 74545,
 56164351,
 55969489,
 -1,
 -64679,
 56043436,
 74547,
 -1,
 56107685,
 74546,
 -1,
 55981240,
 75069,
 56361824,
 55908518,
 -1,
 56427359,
 56297169,
 -1,
 -64674,
 56393616,
 74541,
 -1,
 56447502,
 74540,
 -1,
 56388527,
 74542,
 -64671,
 56329525,
 74544,
 -1,
 56644110,
 74543,
 -1,
 55861915,
 75068,
 56886117,
 55728707,
 74549,
 -1,
 56824487,
 74550,
 57017192,
 56819712,
 -1,
 -64665,
 56994862,
 74538,
 -1,
 57029536,
 74537,
 -1,
 56955845,
 74548,
 57279349,
 53245708,
 74525,
 57344880,
 57215485,
 -1,
 57410413,
 57309721,
 74648,
 -1,
 57345770,
 74527,
 -64658,
 57392923,
 74529,
 -64657,
 57518933,
 74528,
 -1,
 57568332,
 74526,
 57738100,
 57328162,
 74531,
 57868287,
 57674237,
 -1,
 -64653,
 57774972,
 74533,
 -1,
 57829644,
 74532,
 -1,
 57681902,
 74530,
 58065793,
 57226424,
 74515,
 58131328,
 57999360,
 -1,
 58196860,
 58112428,
 -1,
 58262394,
 58179387,
 74519,
 -1,
 58196798,
 74520,
 -64645,
 58227590,
 74518,
 -1,
 58336639,
 74517,
 58524542,
 58174510,
 74522,
 -1,
 58460677,
 74523,
 -64641,
 58485627,
 74516,
 -1,
 58610061,
 74521,
 -1,
 58114425,
 74524,
 58852234,
 58043158,
 74577,
 58917767,
 58788349,
 -1,
 58983301,
 58878804,
 74579,
 -1,
 58956879,
 74580,
 -64634,
 58963349,
 74581,
 -1,
 59054246,
 74578,
 -64632,
 58904990,
 74582,
 -64631,
 59228775,
 74584,
 -1,
 59249026,
 74583,
 59442066,
 58785792,
 -1,
 59507599,
 59413054,
 -1,
 -64627,
 59490123,
 74512,
 -64626,
 59552708,
 74511,
 -1,
 59609997,
 74510,
 59769745,
 59490075,
 74649,
 -1,
 59706087,
 74509,
 -1,
 59724153,
 74508,
 59966358,
 59430085,
 -1,
 60031893,
 59904679,
 74586,
 -1,
 59968107,
 74587,
 -1,
 60014363,
 74588,
 60228504,
 59932474,
 74534,
 -1,
 60162878,
 74535,
 -64615,
 60210592,
 74585,
 -64614,
 60302628,
 74514,
 -1,
 60363138,
 74513,
 60556283,
 53182266,
 -1,
 60621768,
 60512835,
 74316,
 60687297,
 60587834,
 74639,
 60752832,
 60634467,
 74322,
 60882943,
 60688893,
 -1,
 60883877,
 60800795,
 75050,
 -64606,
 60861206,
 74335,
 -64605,
 60925977,
 75052,
 -64604,
 60953121,
 74334,
 -1,
 61016067,
 75051,
 61211562,
 60861419,
 74330,
 61341695,
 61146840,
 -1,
 61342633,
 61254422,
 74332,
 -1,
 61277920,
 74333,
 -1,
 61276227,
 74331,
 61539248,
 61164820,
 -1,
 61604782,
 61521691,
 -1,
 -64595,
 61565871,
 75044,
 -1,
 61617336,
 74326,
 61865983,
 61561411,
 74642,
 -1,
 61778710,
 75043,
 61932468,
 61479078,
 -1,
 61998003,
 61909782,
 74324,
 -1,
 61933280,
 74325,
 -1,
 61964090,
 74323,
 62194615,
 61898554,
 -1,
 -64586,
 62177899,
 74329,
 -1,
 62209198,
 74328,
 62391226,
 62158604,
 -1,
 -64583,
 62340395,
 74327,
 -1,
 62399141,
 75048,
 -64581,
 62362701,
 75049,
 -64580,
 62549139,
 75047,
 -64579,
 62613944,
 75046,
 -64578,
 62674310,
 75045,
 -64577,
 62732208,
 75042,
 -1,
 62793112,
 74641,
 -1,
 60692463,
 74640,
 63046597,
 60651276,
 74319,
 63176703,
 62982710,
 -1,
 -64572,
 63085677,
 74321,
 -1,
 63143816,
 74320,
 -64570,
 63023439,
 74336,
 -64569,
 63246722,
 74318,
 -1,
 63310369,
 74317,
 63505385,
 60604187,
 74337,
 63570916,
 63471418,
 74339,
 63636441,
 63555226,
 74349,
 63766527,
 63569920,
 -1,
 63767511,
 63641981,
 -1,
 -64562,
 63750051,
 74359,
 -64561,
 63810998,
 74358,
 -64560,
 63864984,
 74357,
 -64559,
 63925213,
 74356,
 -64558,
 63989930,
 74355,
 -64557,
 64052641,
 74354,
 -64556,
 64115065,
 74353,
 -64555,
 64175168,
 74352,
 -64554,
 64235436,
 74351,
 -1,
 64299717,
 74350,
 64552959,
 63728265,
 74360,
 -1,
 64424679,
 74361,
 64684031,
 63569920,
 -1,
 64685024,
 64580734,
 -1,
 64750557,
 64661847,
 74342,
 -1,
 64685640,
 74343,
 -64546,
 64734708,
 74344,
 -64545,
 64846224,
 74341,
 -1,
 64900622,
 74340,
 65078242,
 64631687,
 74347,
 -1,
 65012733,
 74348,
 -64541,
 65058540,
 74345,
 -1,
 65180090,
 74346,
 65404927,
 63508833,
 74338,
 65470463,
 65273856,
 -1,
 -64537,
 65386220,
 983256,
 -64536,
 65447692,
 74643,
 -1,
 65507747,
 983257,
 65668085,
 63445158,
 74302,
 65733616,
 65621347,
 74304,
 65799151,
 65667072,
 -1,
 -64531,
 65780197,
 74306,
 -64530,
 65834140,
 74307,
 -1,
 65888923,
 74305,
 -1,
 65772623,
 74308,
 66126835,
 65697548,
 74310,
 -64526,
 66064770,
 74311,
 -1,
 66127072,
 74309,
 -64524,
 66065349,
 74638,
 -1,
 66261378,
 74303,
 66519039,
 65617070,
 74312,
 66584575,
 66387968,
 -1,
 66585594,
 66501036,
 -1,
 -64519,
 66568467,
 74314,
 -1,
 66590886,
 74313,
 -1,
 66563118,
 74315,
 66847826,
 60496038,
 73728,
 66913304,
 66790692,
 73738,
 66978832,
 66846720,
 -1,
 67044367,
 66959788,
 -1,
 67109890,
 67021590,
 -1,
 -64511,
 67092387,
 74881,
 -1,
 67126471,
 73747,
 67306500,
 67077429,
 74608,
 -1,
 67242361,
 74880,
 67437575,
 67263043,
 -1,
 -64506,
 67402926,
 73745,
 -1,
 67456987,
 73744,
 67634186,
 67390819,
 -1,
 -64503,
 67600264,
 73742,
 -1,
 67660719,
 73741,
 -64501,
 67616571,
 73748,
 -64500,
 67791948,
 73746,
 -64499,
 67850766,
 73743,
 -64498,
 67910737,
 73740,
 -1,
 67969728,
 73739,
 -1,
 66998669,
 73749,
 68288511,
 66916738,
 73750,
 68354047,
 68159997,
 -1,
 -64493,
 68269461,
 73755,
 -64492,
 68332373,
 73754,
 -64491,
 68385317,
 73753,
 -64490,
 68439527,
 73752,
 -64489,
 68494748,
 73751,
 -1,
 68556966,
 74609,
 68748325,
 66874287,
 73760,
 68813859,
 68684285,
 -1,
 68879389,
 68773917,
 -1,
 -64484,
 68835907,
 73766,
 -1,
 68885240,
 73765,
 -64482,
 68863476,
 73768,
 -64481,
 69053419,
 73767,
 -64480,
 69095950,
 73764,
 -64479,
 69161003,
 73763,
 -64478,
 69220281,
 73762,
 -1,
 69279047,
 73761,
 -64476,
 68764480,
 73770,
 -1,
 69410473,
 73769,
 69600305,
 68724901,
 -1,
 69665840,
 69554680,
 73784,
 69731374,
 69599232,
 -1,
 69796908,
 69701824,
 -1,
 69862443,
 69767351,
 73788,
 -1,
 69796382,
 73789,
 -1,
 69844346,
 73787,
 -64467,
 69785058,
 73785,
 -1,
 70019228,
 73786,
 -64465,
 69684603,
 73791,
 -1,
 70128002,
 73790,
 -1,
 69606766,
 73783,
 70386746,
 69536253,
 -1,
 -64461,
 70363471,
 73736,
 -64460,
 70418173,
 73735,
 -64459,
 70478963,
 73734,
 -64458,
 70540701,
 73733,
 -64457,
 70603278,
 73732,
 -64456,
 70667751,
 73731,
 -64455,
 70722943,
 73730,
 -1,
 70785190,
 73729,
 70976578,
 70352698,
 73773,
 71042113,
 70909952,
 -1,
 71107647,
 71014274,
 -1,
 -64450,
 71086320,
 73777,
 -1,
 71142497,
 73776,
 -64448,
 71088282,
 73775,
 -1,
 71274671,
 73774,
 -1,
 71019499,
 73778,
 71500870,
 70949967,
 -1,
 71566405,
 71441108,
 73780,
 -1,
 71502457,
 73781,
 -1,
 71526552,
 73782,
 71763018,
 71465226,
 73771,
 71892991,
 71698941,
 -1,
 -64439,
 71805931,
 73772,
 -1,
 71854943,
 74610,
 72025166,
 71723037,
 73757,
 72155135,
 71961085,
 -1,
 -64435,
 72068194,
 73759,
 -1,
 72107050,
 73758,
 72287312,
 71972024,
 73756,
 -1,
 72223274,
 74882,
 -64431,
 72259249,
 73779,
 -1,
 72356226,
 73737,
 72549529,
 66796718,
 73866,
 72615033,
 72537444,
 73889,
 72744959,
 72548352,
 -1,
 72746096,
 72661420,
 -1,
 72811611,
 72706991,
 -1,
 72877145,
 72751270,
 73903,
 -1,
 72838065,
 73904,
 -64422,
 72859419,
 73906,
 -1,
 72964675,
 73905,
 73139295,
 72751270,
 73890,
 73204830,
 73074531,
 73891,
 -1,
 73140868,
 73892,
 -1,
 73170746,
 73893,
 73401443,
 73099293,
 -1,
 73466978,
 73343692,
 73900,
 -1,
 73402651,
 73901,
 -1,
 73449393,
 73902,
 73663590,
 73383707,
 -1,
 -64411,
 73610424,
 73908,
 -1,
 73666946,
 73907,
 73860201,
 73640101,
 -1,
 -64408,
 73842459,
 74933,
 -1,
 73880638,
 74616,
 74056811,
 73814542,
 73897,
 -1,
 73990974,
 73898,
 74187885,
 74005585,
 73895,
 -1,
 74122046,
 73896,
 -64402,
 74145185,
 73899,
 -64401,
 74273145,
 74615,
 -1,
 74327423,
 73894,
 74579967,
 72723510,
 -1,
 74581107,
 74480153,
 74930,
 -1,
 74557605,
 74931,
 74712181,
 74542045,
 74928,
 -1,
 74673071,
 74929,
 -64394,
 74691431,
 74932,
 -64393,
 74800545,
 74927,
 -64392,
 74864006,
 74926,
 -1,
 74916517,
 74925,
 75105412,
 72552834,
 73869,
 75235327,
 75041277,
 -1,
 75236478,
 75147429,
 -1,
 -64387,
 75191358,
 73874,
 -1,
 75242823,
 73873,
 -64385,
 75218715,
 73875,
 -64384,
 75404338,
 74922,
 -64383,
 75463558,
 73872,
 -64382,
 75524983,
 74921,
 -64381,
 75582990,
 73871,
 -1,
 75634902,
 73870,
 75826317,
 75071290,
 73879,
 75956223,
 75759616,
 -1,
 75957386,
 75872684,
 -1,
 76022921,
 75910626,
 73880,
 -1,
 75958649,
 73881,
 -1,
 75987481,
 73882,
 -64373,
 75935984,
 73885,
 -64372,
 76188791,
 73884,
 -1,
 76231428,
 73883,
 76416145,
 75799631,
 -1,
 76481680,
 76373772,
 73887,
 -1,
 76418527,
 74923,
 -1,
 76431754,
 73886,
 76678291,
 76393293,
 73888,
 -1,
 76612158,
 74924,
 76809366,
 76611584,
 -1,
 -64363,
 76790225,
 73867,
 -1,
 76845275,
 73868,
 -64361,
 76770223,
 73878,
 -64360,
 76959778,
 73877,
 -1,
 77019070,
 73876,
 77202629,
 72529029,
 -1,
 77268145,
 77142182,
 74475,
 77333668,
 77221140,
 74483,
 77463551,
 77269501,
 -1,
 77464736,
 77376278,
 -1,
 -64353,
 77446939,
 74487,
 -1,
 77479086,
 74486,
 -64351,
 77447443,
 74489,
 -64350,
 77643125,
 74488,
 -64349,
 77681017,
 74485,
 -1,
 77735852,
 74484,
 77923498,
 77266944,
 -1,
 77989032,
 77904300,
 -1,
 -64345,
 77953926,
 74478,
 -1,
 78009734,
 74477,
 -64343,
 77943181,
 74479,
 -1,
 78127878,
 74476,
 78316718,
 77866276,
 74480,
 78446591,
 78249984,
 -1,
 -64339,
 78360816,
 74482,
 -1,
 78418450,
 74481,
 78578864,
 78276716,
 74490,
 -1,
 78514110,
 75065,
 -1,
 78552143,
 74491,
 78775482,
 77250331,
 74501,
 78841014,
 78739212,
 74504,
 78970879,
 78776829,
 -1,
 -64331,
 78886974,
 75067,
 -1,
 78925287,
 75066,
 79103160,
 78814287,
 74505,
 -1,
 79038098,
 74506,
 -64327,
 79063069,
 74503,
 -1,
 79187290,
 74502,
 79365315,
 78731843,
 74494,
 79430848,
 79338575,
 74497,
 79560703,
 79364096,
 -1,
 79561919,
 79467061,
 74499,
 -1,
 79495951,
 74500,
 -1,
 79542772,
 74498,
 -64319,
 79391663,
 74496,
 -64318,
 79696258,
 74647,
 -1,
 79759737,
 74495,
 80019455,
 79314094,
 74492,
 -1,
 79889214,
 74493,
 80086255,
 77166348,
 -1,
 80151776,
 80068379,
 74284,
 80217307,
 80128790,
 74290,
 80282835,
 80150528,
 -1,
 80348366,
 80253337,
 74294,
 80478207,
 80284157,
 -1,
 -64308,
 80373954,
 75041,
 -64307,
 80432483,
 75040,
 -1,
 80484606,
 74295,
 80676050,
 80329132,
 -1,
 -64304,
 80663765,
 74293,
 -64303,
 80702327,
 74292,
 -1,
 80746662,
 74291,
 -1,
 80622457,
 74296,
 81068031,
 80220839,
 74297,
 81133567,
 80936960,
 -1,
 81134810,
 81050028,
 -1,
 81200344,
 81074342,
 74298,
 -1,
 81135347,
 74299,
 -64295,
 81188053,
 74637,
 -1,
 81278727,
 74300,
 -1,
 81088909,
 74301,
 81528029,
 80170260,
 74286,
 -1,
 81462078,
 74287,
 -64290,
 81502655,
 74289,
 -64289,
 81626177,
 74288,
 -1,
 81659445,
 74285,
 81855721,
 80091302,
 74272,
 81921251,
 81832726,
 74278,
 -1,
 81858946,
 74279,
 82052326,
 81854464,
 -1,
 -64283,
 82033140,
 74273,
 -1,
 82071949,
 74274,
 -64281,
 82025551,
 74277,
 -64280,
 82203128,
 74276,
 -1,
 82252162,
 74275,
 82445548,
 81812035,
 74282,
 -64277,
 82411322,
 74283,
 -1,
 82446347,
 75039,
 82706431,
 82394286,
 74280,
 82771967,
 82618533,
 74281,
 -1,
 82661880,
 74636,
 82838798,
 80028964,
 -1,
 82904318,
 82778278,
 73792,
 82969846,
 82858957,
 73795,
 83099647,
 82905597,
 -1,
 -64268,
 83023061,
 74886,
 -64267,
 83067418,
 74885,
 -1,
 83106169,
 74884,
 83297529,
 82930607,
 73796,
 -64264,
 83237876,
 73798,
 -1,
 83297624,
 73797,
 83494139,
 83270735,
 73799,
 -1,
 83433802,
 73800,
 83625213,
 83440824,
 73793,
 -1,
 83560976,
 74883,
 -1,
 83578205,
 73794,
 83821833,
 82886427,
 73805,
 83887365,
 83755008,
 -1,
 83952900,
 83857610,
 -1,
 -64254,
 83935851,
 73807,
 -64253,
 83999175,
 74887,
 -1,
 84023670,
 73806,
 -1,
 83899128,
 73808,
 84280583,
 83860559,
 73811,
 -1,
 84218242,
 73812,
 84475903,
 84244168,
 73809,
 -1,
 84346210,
 73810,
 84606975,
 83778115,
 73801,
 84672511,
 84478461,
 -1,
 -64244,
 84565409,
 73804,
 -64243,
 84626958,
 73803,
 -1,
 84678822,
 73802,
 84870443,
 82792952,
 -1,
 84935963,
 84826691,
 74029,
 85065727,
 84871677,
 -1,
 85067028,
 84943525,
 74030,
 -64237,
 85004674,
 74031,
 -1,
 85067141,
 74959,
 -64235,
 85049115,
 74038,
 -64234,
 85240811,
 74037,
 -64233,
 85296437,
 74036,
 -64232,
 85355096,
 74035,
 -64231,
 85413247,
 74034,
 -64230,
 85473274,
 74033,
 -1,
 85534079,
 74032,
 85722405,
 84918043,
 74039,
 85787939,
 85665082,
 74040,
 85917695,
 85723645,
 -1,
 -64225,
 85836051,
 74045,
 -64224,
 85881769,
 74044,
 -64223,
 85944588,
 74043,
 -64222,
 86004355,
 74042,
 -1,
 86056617,
 74041,
 -64220,
 85764886,
 74621,
 -1,
 86207450,
 74046,
 86441983,
 85661862,
 74025,
 86443306,
 86310912,
 -1,
 86508841,
 86423276,
 74026,
 -1,
 86442814,
 74958,
 -1,
 86462861,
 74027,
 -1,
 86404015,
 74028,
 86771014,
 84826691,
 74047,
 86836531,
 86734604,
 74062,
 86902066,
 86769664,
 -1,
 -64209,
 86882804,
 74063,
 -64208,
 86946032,
 74066,
 -64207,
 87002243,
 74065,
 -1,
 87044947,
 74064,
 -1,
 86859464,
 74067,
 87295290,
 86789396,
 74053,
 87425023,
 87251523,
 74054,
 87490559,
 87293952,
 -1,
 -64201,
 87400927,
 74056,
 -64200,
 87462170,
 74057,
 -64199,
 87511437,
 74058,
 -1,
 87570307,
 74055,
 87754045,
 87255983,
 74059,
 -64196,
 87691650,
 74061,
 -1,
 87755328,
 74060,
 87950657,
 87701420,
 74050,
 88080383,
 87885250,
 -1,
 -64192,
 87994608,
 74052,
 -1,
 88025676,
 74051,
 -64190,
 87927574,
 74070,
 -64189,
 88185935,
 74069,
 -64188,
 88244026,
 74068,
 -64187,
 88286500,
 74049,
 -1,
 88342530,
 74048,
 88540516,
 86741798,
 -1,
 88606046,
 88496707,
 74367,
 88671573,
 88539136,
 -1,
 88737108,
 88652204,
 -1,
 88802636,
 88719131,
 74375,
 -1,
 88740226,
 74376,
 88933710,
 88758851,
 74373,
 -1,
 88876324,
 74374,
 89064785,
 88876324,
 -1,
 -64176,
 89046811,
 74371,
 -1,
 89086531,
 74370,
 89261395,
 89004198,
 74368,
 -1,
 89204004,
 74369,
 -1,
 89210030,
 74372,
 -1,
 88683412,
 74377,
 89587711,
 88644687,
 -1,
 89589085,
 89480365,
 74378,
 89718783,
 89522176,
 -1,
 89720156,
 89635244,
 -1,
 -64166,
 89707733,
 74381,
 -64165,
 89768211,
 74380,
 -1,
 89811147,
 74379,
 -1,
 89689258,
 74382,
 -1,
 89526658,
 74645,
 90113378,
 88545446,
 74362,
 -64160,
 90084134,
 74365,
 -64159,
 90144570,
 74364,
 -1,
 90191032,
 74363,
 90439679,
 90064075,
 74366,
 -1,
 90308920,
 74644,
 90506620,
 88528069,
 -1,
 90572141,
 90488603,
 74602,
 90637674,
 90510489,
 74603,
 90767359,
 90573309,
 -1,
 -64151,
 90683465,
 75075,
 -1,
 90708134,
 74604,
 -64149,
 90601228,
 74606,
 -64148,
 90843724,
 74605,
 -1,
 90900144,
 75074,
 91096436,
 90528323,
 74595,
 91161968,
 91039012,
 74598,
 -1,
 91095976,
 74599,
 -64143,
 91149522,
 74601,
 -64142,
 91245844,
 74600,
 -64141,
 91296423,
 74597,
 -1,
 91358887,
 74596,
 91555195,
 91035814,
 74589,
 91620728,
 91488256,
 -1,
 -64137,
 91600620,
 74590,
 -1,
 91664641,
 74591,
 -64135,
 91586334,
 74593,
 -64134,
 91770132,
 74592,
 -1,
 91821662,
 75073,
 -1,
 91504029,
 74594,
 92143615,
 90479695,
 -1,
 92145023,
 92018854,
 74383,
 -1,
 92087588,
 74384,
 -64128,
 92127003,
 74386,
 -1,
 92232259,
 74385,
 92407324,
 230695,
 -1,
 92472746,
 92358606,
 -1,
 92538264,
 92442476,
 -1,
 92603785,
 92522302,
 74812,
 92669320,
 92536832,
 -1,
 -64121,
 92611876,
 74815,
 -1,
 92674214,
 74814,
 -1,
 92607429,
 74813,
 92931469,
 92546340,
 -1,
 92997004,
 92872373,
 74834,
 -1,
 92932847,
 74835,
 -1,
 92980675,
 74808,
 93193615,
 92913435,
 74767,
 -1,
 93129455,
 74857,
 93324690,
 93170644,
 -1,
 -64111,
 93306651,
 74800,
 -1,
 93327746,
 74790,
 93521301,
 93277949,
 -1,
 -64108,
 93503259,
 74785,
 -1,
 93524354,
 74776,
 93717911,
 93463205,
 74754,
 -1,
 93653369,
 74828,
 -1,
 93665274,
 74761,
 93978623,
 92497367,
 -1,
 93980062,
 93890725,
 -1,
 94045597,
 93934537,
 -1,
 -64100,
 94027547,
 74801,
 -1,
 94048642,
 74791,
 -1,
 94004909,
 74844,
 94307746,
 93922596,
 -1,
 94373281,
 94248629,
 74836,
 -1,
 94309103,
 74837,
 -1,
 94356931,
 74809,
 94569892,
 94289691,
 74768,
 -1,
 94505711,
 74858,
 94700967,
 94523133,
 -1,
 -64090,
 94682907,
 74786,
 -1,
 94704002,
 74777,
 94897577,
 94642853,
 74755,
 -1,
 94833017,
 74829,
 -1,
 94844922,
 74762,
 95094222,
 92451973,
 -1,
 95159742,
 95049952,
 -1,
 95225265,
 95136724,
 -1,
 95290799,
 95207195,
 74798,
 -1,
 95226607,
 74799,
 95485951,
 95228290,
 74788,
 -1,
 95357679,
 74789,
 95552949,
 95167780,
 -1,
 95618484,
 95536579,
 74806,
 -1,
 95554287,
 74807,
 -1,
 95559349,
 74833,
 95815096,
 95536903,
 -1,
 -64073,
 95752830,
 74811,
 -1,
 95818092,
 74810,
 96011707,
 95768317,
 -1,
 -64070,
 95993627,
 74784,
 -1,
 96014722,
 74775,
 96208317,
 95953573,
 74753,
 -1,
 96143737,
 74827,
 -1,
 96155642,
 74760,
 96468991,
 95145934,
 -1,
 96470466,
 96385011,
 -1,
 -64063,
 96454374,
 74846,
 -1,
 96483322,
 74843,
 96667077,
 96447444,
 -1,
 -64060,
 96648987,
 74797,
 -1,
 96670082,
 74787,
 96863688,
 96620285,
 -1,
 -64057,
 96845595,
 74783,
 -1,
 96866690,
 74774,
 97060299,
 96806180,
 -1,
 -64054,
 97043907,
 74805,
 -1,
 97066677,
 74832,
 97256909,
 97002149,
 74752,
 -1,
 97192313,
 74826,
 -1,
 97207504,
 74841,
 97453543,
 95070373,
 -1,
 97519067,
 97404403,
 -1,
 97584597,
 97503020,
 -1,
 97650132,
 97517568,
 -1,
 -64045,
 97592612,
 74819,
 -1,
 97654950,
 74818,
 -1,
 97587879,
 74817,
 97912279,
 97566491,
 74770,
 -1,
 97848047,
 74860,
 -64040,
 97889241,
 74793,
 -64039,
 97996546,
 74779,
 -64038,
 98056186,
 74764,
 -1,
 98116261,
 74757,
 98305508,
 97478266,
 -1,
 98371038,
 98287387,
 74769,
 -1,
 98306799,
 74859,
 98502112,
 98312869,
 74756,
 -1,
 98437497,
 74830,
 -64031,
 98486005,
 74816,
 -64030,
 98610137,
 74792,
 -64029,
 98651906,
 74778,
 -1,
 98711546,
 74763,
 98959359,
 98259922,
 -1,
 -64026,
 98860206,
 74803,
 -1,
 98908154,
 74802,
 99091965,
 97420734,
 -1,
 99157498,
 99057819,
 -1,
 99223020,
 99137502,
 -1,
 -64021,
 99206886,
 74845,
 -1,
 99235834,
 74842,
 99419631,
 99195784,
 -1,
 -64018,
 99373473,
 74851,
 -1,
 99426981,
 74848,
 99616242,
 99372797,
 -1,
 -64015,
 99598107,
 74782,
 -1,
 99619202,
 74773,
 99812853,
 99564718,
 -1,
 -64012,
 99789807,
 74840,
 -1,
 99835266,
 74847,
 100009464,
 99755300,
 -1,
 -64009,
 99993027,
 74804,
 -1,
 100015797,
 74831,
 -64007,
 99986405,
 74796,
 -1,
 100160170,
 74852,
 100401151,
 99118601,
 -1,
 -64004,
 100314735,
 74849,
 -1,
 100375424,
 74850,
 100533772,
 99058202,
 -1,
 100599305,
 100499611,
 -1,
 100664835,
 100583192,
 74822,
 -63999,
 100602821,
 74824,
 -63998,
 100668071,
 74823,
 -1,
 100728834,
 74825,
 100926981,
 100646683,
 74772,
 -1,
 100862703,
 74862,
 -63994,
 100903897,
 74795,
 -63993,
 101011202,
 74781,
 -63992,
 101070842,
 74766,
 -1,
 101130917,
 74759,
 101384191,
 100552695,
 -1,
 -63989,
 101285038,
 74838,
 -1,
 101336263,
 74839,
 101580799,
 100482222,
 -1,
 101582358,
 101473581,
 -1,
 101647888,
 101566289,
 74820,
 -1,
 101585575,
 74821,
 101778962,
 101629723,
 74771,
 -1,
 101714671,
 74861,
 -63981,
 101755865,
 74794,
 -63980,
 101863170,
 74780,
 -63979,
 101922810,
 74765,
 -1,
 101982885,
 74758,
 102236159,
 101543093,
 -1,
 102237722,
 102123470,
 -1,
 -63975,
 102206920,
 74855,
 -1,
 102259859,
 74856,
 -63973,
 102219513,
 74854,
 -1,
 102402604,
 74853,
 102629375,
 92379738,
 -1,
 102630945,
 102512451,
 -1,
 -63969,
 102612121,
 74867,
 -63968,
 102669072,
 74868,
 -1,
 102707294,
 74866,
 -63966,
 102615159,
 74865,
 -1,
 102860854,
 74864,
 103024168,
 171087,
 -1,
 103089703,
 102997071,
 -1,
 -63962,
 103076487,
 127835,
 -1,
 103105037,
 128177,
 -1,
 103053060,
 10160,
 103351851,
 103002501,
 -1,
 -63958,
 103319858,
 128707,
 -1,
 103358715,
 127854,
 -1,
 103322431,
 9982,
 103614532,
 99774,
 -1,
 103679804,
 103577356,
 -1,
 103745339,
 103622642,
 -1,
 103810675,
 103688857,
 -1,
 103876209,
 103797932,
 -1,
 103941733,
 103838078,
 -1,
 104007226,
 103890094,
 -1,
 104072757,
 103983269,
 11757,
 -1,
 104009533,
 11765,
 -63946,
 104045647,
 11756,
 -63945,
 104169274,
 11753,
 -63944,
 104232716,
 11752,
 -63943,
 104295343,
 11751,
 -1,
 104351694,
 42654,
 104531520,
 103963203,
 42613,
 104597055,
 104500847,
 -1,
 -63939,
 104545454,
 42655,
 -63938,
 104605650,
 11775,
 -1,
 104667302,
 11772,
 -1,
 104545454,
 11767,
 104924741,
 104518274,
 -1,
 -63934,
 104906523,
 11771,
 -63933,
 104946243,
 42614,
 -63932,
 105006191,
 42617,
 -1,
 105063183,
 11770,
 105252426,
 104900773,
 -1,
 105317961,
 105206264,
 -1,
 -63928,
 105262375,
 11763,
 -1,
 105322662,
 11762,
 -1,
 105285398,
 42618,
 105580109,
 105239749,
 -1,
 -63924,
 105534526,
 11748,
 -1,
 105594030,
 11749,
 105776719,
 105561883,
 42615,
 -1,
 105737009,
 42612,
 105907794,
 105755781,
 -1,
 -63919,
 105884212,
 11760,
 -1,
 105921710,
 11758,
 106104404,
 105874878,
 11754,
 -1,
 106068701,
 42619,
 106235478,
 106058254,
 11759,
 -1,
 106209018,
 42616,
 106366553,
 106181816,
 -1,
 -63912,
 106325884,
 11768,
 -1,
 106380462,
 11747,
 106563164,
 106308900,
 -1,
 -63909,
 106519728,
 11774,
 -1,
 106577070,
 11744,
 -63907,
 106547070,
 11745,
 -63906,
 106730755,
 11755,
 -63905,
 106790336,
 11769,
 -63904,
 106853331,
 11773,
 -63903,
 106915951,
 11750,
 -63902,
 106975062,
 11746,
 -63901,
 107039199,
 11764,
 -63900,
 107097420,
 11761,
 -1,
 107157670,
 11766,
 107349611,
 103920773,
 -1,
 107415145,
 107308461,
 -1,
 -63896,
 107389598,
 65071,
 -1,
 107441978,
 65070,
 -63894,
 107370664,
 42610,
 -1,
 107561369,
 42608,
 107742830,
 107320102,
 -1,
 -63891,
 107710490,
 1159,
 -1,
 107750672,
 42621,
 -63889,
 107727624,
 42607,
 -63888,
 107899223,
 42620,
 -1,
 107960804,
 42609,
 108199935,
 103844561,
 65062,
 -1,
 108069231,
 65069,
 108267182,
 103771055,
 -1,
 108332703,
 108209078,
 -1,
 108398233,
 108310325,
 -1,
 108463740,
 108337318,
 -1,
 -63880,
 108447389,
 7638,
 -63879,
 108496318,
 7637,
 -63878,
 108557883,
 7655,
 -63877,
 108608686,
 7636,
 -1,
 108661671,
 7666,
 108856959,
 108424111,
 7645,
 -63874,
 108825219,
 7653,
 -1,
 108858355,
 7660,
 109053570,
 108838764,
 -1,
 -63871,
 109015745,
 7664,
 -1,
 109066018,
 7668,
 109250180,
 109029541,
 7652,
 -1,
 109194783,
 7658,
 109381255,
 109222993,
 -1,
 -63866,
 109356854,
 7651,
 -1,
 109389538,
 7626,
 109577866,
 109348321,
 -1,
 -63863,
 109540033,
 7661,
 -1,
 109590306,
 7667,
 109774476,
 109529038,
 7659,
 -1,
 109735364,
 7635,
 109905551,
 109722798,
 -1,
 -63858,
 109885267,
 7641,
 -1,
 109947670,
 7663,
 110102161,
 109847844,
 7656,
 -1,
 110052603,
 7657,
 -63854,
 110089413,
 7654,
 -63853,
 110217998,
 7665,
 -63852,
 110269222,
 7662,
 -63851,
 110329658,
 7648,
 -63850,
 110389277,
 7644,
 -63849,
 110453305,
 7640,
 -63848,
 110513428,
 7642,
 -1,
 110570142,
 7639,
 110821375,
 108360128,
 -1,
 -63845,
 110730319,
 7650,
 -63844,
 110788410,
 7649,
 -63843,
 110851852,
 7647,
 -63842,
 110914479,
 7646,
 -1,
 110972180,
 7643,
 111150760,
 108281817,
 -1,
 111216295,
 111083520,
 -1,
 111281830,
 111157732,
 -1,
 111347365,
 111236174,
 -1,
 -63836,
 111290082,
 852,
 -1,
 111352293,
 7678,
 -1,
 111280495,
 8430,
 -1,
 111235773,
 849,
 -1,
 111201261,
 8429,
 111740589,
 111107245,
 -1,
 111806124,
 111682586,
 -1,
 -63829,
 111780521,
 65064,
 -1,
 111832900,
 65063,
 -1,
 111761820,
 6841,
 -1,
 111708766,
 8427,
 112133851,
 108213432,
 -1,
 112199367,
 112084451,
 -1,
 112264894,
 112146330,
 -1,
 112330420,
 112243845,
 -1,
 -63821,
 112316363,
 43234,
 -1,
 112351451,
 43235,
 112527031,
 112306341,
 -1,
 -63818,
 112486007,
 43238,
 -1,
 112543214,
 43239,
 112723642,
 112478158,
 -1,
 -63815,
 112693096,
 43236,
 -1,
 112747987,
 43237,
 -63813,
 112711038,
 43232,
 -63812,
 112888248,
 43233,
 -63811,
 112951899,
 43241,
 -1,
 113000558,
 43240,
 113182406,
 112226686,
 -1,
 -63808,
 113166673,
 43248,
 -63807,
 113229595,
 43243,
 -63806,
 113286339,
 43247,
 -63805,
 113349500,
 43246,
 -63804,
 113409936,
 43245,
 -63803,
 113469551,
 43244,
 -1,
 113514662,
 43242,
 -1,
 113159548,
 43249,
 113772250,
 112166334,
 -1,
 113837780,
 113754172,
 -1,
 113903315,
 113770496,
 -1,
 113968844,
 113866635,
 862,
 -1,
 113901935,
 863,
 114099918,
 113912241,
 861,
 -1,
 114033007,
 860,
 -63793,
 114074794,
 858,
 -63792,
 114201748,
 6844,
 -63791,
 114265082,
 6840,
 -63790,
 114320046,
 7676,
 -1,
 114372324,
 7629,
 -1,
 113849550,
 6832,
 114624217,
 113816709,
 -1,
 114689752,
 114603610,
 -1,
 -63785,
 114643205,
 7616,
 -1,
 114694843,
 7617,
 -1,
 114622476,
 856,
 -1,
 114610089,
 6835,
 -1,
 113728195,
 6833,
 115082998,
 112087217,
 -1,
 115148529,
 115021990,
 -1,
 115214062,
 115115165,
 -1,
 115279592,
 115160986,
 -1,
 115345122,
 115258501,
 -1,
 -63775,
 115331019,
 70504,
 -1,
 115366107,
 70505,
 115541733,
 115296206,
 -1,
 -63772,
 115511144,
 70506,
 -1,
 115566035,
 70507,
 -63770,
 115529086,
 70502,
 -63769,
 115715647,
 70508,
 -1,
 115771832,
 70503,
 115998719,
 115241342,
 -1,
 -63766,
 115919185,
 70515,
 -63765,
 115970940,
 70516,
 -63764,
 116031376,
 70514,
 -63763,
 116090991,
 70513,
 -1,
 116136102,
 70512,
 116391935,
 115197879,
 -1,
 -63760,
 116291467,
 7621,
 -1,
 116333256,
 7624,
 116588543,
 115097439,
 -1,
 116590325,
 116503685,
 -1,
 -63756,
 116565382,
 119362,
 -1,
 116606233,
 119363,
 -1,
 116561319,
 119364,
 116852483,
 115057285,
 -1,
 116918018,
 116785152,
 -1,
 116983553,
 116859364,
 -1,
 117049088,
 116937806,
 -1,
 117114623,
 116988070,
 -1,
 117180158,
 117080099,
 -1,
 -63747,
 117162863,
 854,
 -1,
 117193420,
 7679,
 -1,
 117123446,
 848,
 -1,
 117057250,
 853,
 -1,
 116982127,
 8431,
 -1,
 116937405,
 855,
 -1,
 116902893,
 8428,
 117704460,
 116819390,
 -1,
 117769994,
 117665313,
 -1,
 -63738,
 117757260,
 66424,
 -63737,
 117812653,
 66426,
 -63736,
 117866774,
 66425,
 -63735,
 117913725,
 66423,
 -1,
 117972649,
 66422,
 -63733,
 117740882,
 6839,
 -1,
 118116508,
 7630,
 118294294,
 117667723,
 -1,
 118359826,
 118226944,
 -1,
 118425360,
 118334110,
 65061,
 -1,
 118358383,
 65068,
 118620159,
 118386490,
 65060,
 -1,
 118489455,
 65067,
 118751231,
 118296043,
 -1,
 -63724,
 118640895,
 7622,
 -63723,
 118696369,
 7628,
 -1,
 118758069,
 7620,
 118949662,
 118233254,
 -1,
 119015194,
 118927874,
 -1,
 -63719,
 118957794,
 857,
 -1,
 119020005,
 8432,
 119211805,
 118961306,
 -1,
 -63716,
 119175051,
 7623,
 -1,
 119230738,
 7625,
 -1,
 119174271,
 7677,
 119473954,
 118931227,
 -1,
 -63712,
 119449770,
 7634,
 -63711,
 119512148,
 7633,
 -1,
 119575396,
 7669,
 119736103,
 119452805,
 -1,
 119801638,
 119692832,
 -1,
 -63707,
 119775913,
 65066,
 -1,
 119828292,
 65065,
 -1,
 119776569,
 6836,
 120063787,
 119711909,
 -1,
 -63703,
 120047155,
 7619,
 -63702,
 120110336,
 6842,
 -1,
 120160187,
 7618,
 120325935,
 120034439,
 -1,
 -63699,
 120296006,
 6846,
 -63698,
 120334050,
 6845,
 -1,
 120396261,
 6843,
 120588082,
 120313324,
 -1,
 -63695,
 120530658,
 7631,
 -1,
 120592869,
 859,
 120784693,
 120574366,
 -1,
 -63692,
 120721225,
 6837,
 -1,
 120783215,
 851,
 120981304,
 120740419,
 -1,
 -63689,
 120957106,
 7632,
 -1,
 121012601,
 6834,
 -63687,
 120966659,
 6838,
 -63686,
 121129156,
 850,
 -1,
 121186769,
 7627,
 -1,
 103717228,
 128476,
 121440272,
 103651811,
 -1,
 121505678,
 121415845,
 -1,
 121571204,
 121469055,
 -1,
 121636694,
 121537982,
 11423,
 121702229,
 121597445,
 -1,
 121767759,
 121647599,
 -1,
 121833287,
 121721336,
 -1,
 121898821,
 121772198,
 11471,
 -1,
 121877637,
 11477,
 -63674,
 121867572,
 11469,
 -1,
 121978979,
 11475,
 122160970,
 121809686,
 -1,
 -63671,
 122117737,
 11483,
 -1,
 122175587,
 11461,
 -63669,
 122129276,
 11455,
 -63668,
 122310140,
 11479,
 -63667,
 122373319,
 11463,
 -63666,
 122435629,
 11481,
 -1,
 122494100,
 11445,
 122748927,
 121734369,
 -1,
 122750803,
 122650426,
 -1,
 -63662,
 122737611,
 11489,
 -1,
 122769368,
 11487,
 -63660,
 122735631,
 11491,
 -1,
 122924119,
 11485,
 -1,
 121671409,
 11441,
 123144029,
 121582776,
 -1,
 123209564,
 123099882,
 -1,
 -63655,
 123175450,
 11451,
 -63654,
 123234525,
 11449,
 -63653,
 123295704,
 11467,
 -1,
 123346325,
 11443,
 -1,
 123149708,
 11399,
 123602788,
 123089480,
 -1,
 123668323,
 123589763,
 -1,
 -63648,
 123644926,
 11500,
 -63647,
 123699738,
 11453,
 -63646,
 123751932,
 11502,
 -1,
 123813994,
 11447,
 -1,
 123637241,
 11459,
 124061544,
 123578533,
 -1,
 -63642,
 124030705,
 11403,
 -63641,
 124083817,
 11429,
 -1,
 124133016,
 11457,
 124323692,
 124020765,
 -1,
 -63638,
 124300545,
 11421,
 -63637,
 124343686,
 11437,
 -1,
 124395586,
 11413,
 124585839,
 124302469,
 -1,
 -63634,
 124540227,
 11409,
 -1,
 124593208,
 11431,
 124782450,
 124556070,
 -1,
 -63631,
 124759297,
 11439,
 -1,
 124803651,
 11425,
 124979061,
 124742575,
 -1,
 -63628,
 124920926,
 11415,
 -1,
 124980982,
 11473,
 125175672,
 124917926,
 -1,
 -63625,
 125137430,
 11393,
 -1,
 125200942,
 11465,
 -63623,
 125162828,
 11405,
 -63622,
 125356385,
 11395,
 -63621,
 125419444,
 11433,
 -63620,
 125478455,
 11427,
 -63619,
 125534746,
 11419,
 -63618,
 125598598,
 11417,
 -63617,
 125655908,
 11411,
 -63616,
 125719572,
 11407,
 -63615,
 125783516,
 11397,
 -63614,
 125847841,
 11435,
 -63613,
 125911146,
 11401,
 -1,
 125970657,
 11507,
 126222335,
 121558042,
 -1,
 126224264,
 126134437,
 -1,
 -63609,
 126203407,
 11495,
 -1,
 126244450,
 11498,
 126420875,
 126183453,
 -1,
 -63606,
 126375305,
 11497,
 -1,
 126426208,
 11492,
 -63604,
 126400008,
 11496,
 -63603,
 126588520,
 11494,
 -1,
 126647181,
 11493,
 126814170,
 121449113,
 -1,
 126879701,
 126754915,
 -1,
 126945191,
 126846398,
 11422,
 127010726,
 126905861,
 -1,
 127076256,
 126956015,
 -1,
 127141784,
 127029752,
 -1,
 127207318,
 127080614,
 11470,
 -1,
 127186053,
 11476,
 -63593,
 127175988,
 11468,
 -1,
 127287395,
 11474,
 127469467,
 127118102,
 -1,
 -63590,
 127426153,
 11482,
 -1,
 127484003,
 11460,
 -63588,
 127437692,
 11454,
 -63587,
 127618556,
 11478,
 -63586,
 127681735,
 11462,
 -63585,
 127744045,
 11480,
 -1,
 127802516,
 11444,
 128057343,
 127042785,
 -1,
 128059300,
 127958842,
 -1,
 -63581,
 128046027,
 11488,
 -1,
 128077784,
 11486,
 -63579,
 128044047,
 11490,
 -1,
 128232535,
 11484,
 -1,
 126979825,
 11440,
 128452526,
 126891192,
 -1,
 128518061,
 128408298,
 -1,
 -63574,
 128483866,
 11450,
 -63573,
 128542941,
 11448,
 -63572,
 128604120,
 11466,
 -1,
 128654741,
 11442,
 -1,
 128458124,
 11398,
 128911285,
 128397896,
 -1,
 128976820,
 128898179,
 -1,
 -63567,
 128953342,
 11499,
 -63566,
 129008154,
 11452,
 -63565,
 129060348,
 11501,
 -1,
 129122410,
 11446,
 -1,
 128945657,
 11458,
 129370041,
 128886949,
 -1,
 -63561,
 129339121,
 11402,
 -63560,
 129392233,
 11428,
 -1,
 129441432,
 11456,
 129632189,
 129329181,
 -1,
 -63557,
 129608961,
 11420,
 -63556,
 129652102,
 11436,
 -1,
 129704002,
 11412,
 129894336,
 129610885,
 -1,
 -63553,
 129848643,
 11408,
 -1,
 129901624,
 11430,
 130090947,
 129864486,
 -1,
 -63550,
 130067713,
 11438,
 -1,
 130112067,
 11424,
 130287558,
 130050991,
 -1,
 -63547,
 130229342,
 11414,
 -1,
 130289398,
 11472,
 130484169,
 130226342,
 -1,
 -63544,
 130445846,
 11392,
 -1,
 130509358,
 11464,
 -63542,
 130471244,
 11404,
 -63541,
 130664801,
 11394,
 -63540,
 130727860,
 11432,
 -63539,
 130786871,
 11426,
 -63538,
 130843162,
 11418,
 -63537,
 130907014,
 11416,
 -63536,
 130964324,
 11410,
 -63535,
 131027988,
 11406,
 -63534,
 131091932,
 11396,
 -63533,
 131156257,
 11434,
 -63532,
 131219562,
 11400,
 -1,
 131279073,
 11506,
 131530751,
 126847208,
 -1,
 131532761,
 131444914,
 -1,
 -63528,
 131494229,
 11505,
 -1,
 131539666,
 11504,
 -1,
 131498525,
 11503,
 131794951,
 126763812,
 -1,
 131860473,
 131761401,
 -1,
 131925988,
 131839109,
 -1,
 131991520,
 131910414,
 -1,
 -63521,
 131958214,
 66292,
 -1,
 132006644,
 66283,
 132188131,
 131944952,
 -1,
 -63518,
 132161587,
 66293,
 -1,
 132211821,
 66284,
 -1,
 132137354,
 66282,
 132450283,
 131901605,
 -1,
 132515816,
 132408951,
 -1,
 -63513,
 132497156,
 66287,
 -1,
 132514657,
 66296,
 132775935,
 132466158,
 -1,
 -63510,
 132693764,
 66288,
 -1,
 132711265,
 66297,
 132909042,
 132401102,
 -1,
 132974575,
 132875710,
 -1,
 -63506,
 132957475,
 66294,
 -1,
 133015565,
 66285,
 133234687,
 132930115,
 -1,
 -63503,
 133154701,
 66295,
 -1,
 133188859,
 66286,
 133367797,
 132874843,
 -1,
 -63500,
 133349124,
 66290,
 -1,
 133366625,
 66299,
 133564408,
 133316718,
 -1,
 -63497,
 133550722,
 66289,
 -1,
 133563233,
 66298,
 -1,
 133532125,
 66291,
 133826566,
 131807130,
 -1,
 133892093,
 133805189,
 -1,
 -63492,
 133877707,
 66274,
 -1,
 133912795,
 66275,
 134088704,
 133867685,
 -1,
 -63489,
 134047351,
 66278,
 -1,
 134104558,
 66279,
 134285315,
 134039502,
 -1,
 -63486,
 134254440,
 66276,
 -1,
 134309331,
 66277,
 -63484,
 134252984,
 66273,
 -63483,
 134447707,
 66281,
 -1,
 134496366,
 66280,
 -1,
 133806120,
 66272,
 134744076,
 131762256,
 -1,
 -63479,
 134727731,
 11516,
 -63478,
 134766586,
 11515,
 -63477,
 134827267,
 11513,
 -1,
 134887381,
 11514,
 135071759,
 134694862,
 -1,
 -63474,
 135053826,
 11518,
 -1,
 135109861,
 11517,
 -1,
 135036382,
 11519,
 135333934,
 121421595,
 -1,
 135399468,
 135300275,
 -1,
 135464991,
 135381784,
 -1,
 135530518,
 135443589,
 -1,
 -63467,
 135516107,
 119649,
 -1,
 135551195,
 119650,
 135727129,
 135506085,
 -1,
 -63464,
 135685751,
 119653,
 -1,
 135742958,
 119654,
 135923740,
 135677902,
 -1,
 -63461,
 135892840,
 119651,
 -1,
 135947731,
 119652,
 -63459,
 135891384,
 119648,
 -63458,
 136086107,
 119656,
 -1,
 136134766,
 119655,
 136380415,
 135444180,
 -1,
 136382499,
 136295557,
 -1,
 -63454,
 136368075,
 119658,
 -1,
 136403163,
 119659,
 136579110,
 136358053,
 -1,
 -63451,
 136537719,
 119662,
 -1,
 136594926,
 119663,
 136775721,
 136529870,
 -1,
 -63448,
 136744808,
 119660,
 -1,
 136799699,
 119661,
 -63446,
 136743352,
 119657,
 -63445,
 136938075,
 119665,
 -1,
 136986734,
 119664,
 -63443,
 135370495,
 128145,
 -1,
 137112831,
 128715,
 137300026,
 135298874,
 -1,
 137365555,
 137250766,
 -1,
 -63439,
 137348586,
 128533,
 -63438,
 137400156,
 128534,
 -1,
 137446731,
 127882,
 137627702,
 137346298,
 -1,
 -63435,
 137603800,
 983186,
 -1,
 137652943,
 127899,
 137824313,
 137605959,
 -1,
 -63432,
 137810231,
 128119,
 -1,
 137866609,
 128679,
 -1,
 137807854,
 127978,
 138086463,
 137267148,
 -1,
 138151998,
 138041923,
 -1,
 -63427,
 138117523,
 127859,
 -1,
 138165422,
 127850,
 -1,
 138100499,
 127834,
 138414145,
 138070798,
 128004,
 -1,
 138347234,
 128046,
 -63422,
 138376291,
 128165,
 -63421,
 138496268,
 9904,
 -1,
 138555289,
 127864,
 138742159,
 103567864,
 -1,
 138807575,
 138680486,
 -1,
 138873011,
 138770190,
 -1,
 138938506,
 138834302,
 -1,
 139003988,
 138889550,
 -1,
 139069515,
 138968890,
 43590,
 -1,
 139021588,
 43586,
 -63412,
 139055746,
 43592,
 -63411,
 139179141,
 43589,
 -63410,
 139243822,
 43595,
 -63409,
 139304015,
 43593,
 -63408,
 139367206,
 43591,
 -63407,
 139422639,
 43594,
 -63406,
 139487261,
 43584,
 -63405,
 139545876,
 43585,
 -1,
 139603196,
 43588,
 139790430,
 138968890,
 -1,
 139855961,
 139743736,
 -1,
 -63401,
 139837782,
 43536,
 -63400,
 139880212,
 43538,
 -1,
 139925670,
 43537,
 140118108,
 139808020,
 -1,
 -63397,
 140099926,
 43530,
 -1,
 140122278,
 43531,
 -63395,
 140099926,
 43543,
 -1,
 140253350,
 43544,
 140445794,
 139760422,
 -1,
 -63392,
 140415868,
 43547,
 -63391,
 140464654,
 43548,
 -1,
 140515494,
 43546,
 140707942,
 140391608,
 -1,
 -63388,
 140661262,
 43542,
 -63387,
 140719430,
 43545,
 -1,
 140777638,
 43541,
 140970090,
 140649764,
 -1,
 -63384,
 140923406,
 43550,
 -63383,
 140977497,
 43553,
 -1,
 141039782,
 43549,
 141232237,
 140948613,
 -1,
 -63380,
 141185550,
 43540,
 -1,
 141236390,
 43539,
 141428848,
 141207717,
 -1,
 -63377,
 141404464,
 43558,
 -1,
 141432998,
 43559,
 141625459,
 141391628,
 -1,
 -63374,
 141607254,
 43551,
 -1,
 141629606,
 43552,
 141822070,
 141584413,
 -1,
 -63371,
 141775374,
 43527,
 -1,
 141826214,
 43526,
 142018681,
 141780726,
 -1,
 -63368,
 141971982,
 43535,
 -1,
 142022822,
 43534,
 142215292,
 141970708,
 -1,
 -63365,
 142168590,
 43529,
 -1,
 142219430,
 43528,
 142411903,
 142159100,
 -1,
 -63362,
 142365198,
 43533,
 -1,
 142416038,
 43532,
 142608513,
 142350502,
 43520,
 -1,
 142563907,
 43524,
 -63358,
 142594779,
 43554,
 -63357,
 142722739,
 43557,
 -63356,
 142786331,
 43522,
 -63355,
 142843075,
 43555,
 -63354,
 142902718,
 43525,
 -63353,
 142961629,
 43556,
 -63352,
 143022659,
 43521,
 -63351,
 143086094,
 43560,
 -1,
 143146158,
 43523,
 143329430,
 138922650,
 -1,
 143394959,
 143268006,
 -1,
 -63347,
 143376155,
 43569,
 -63346,
 143415875,
 43568,
 -1,
 143464614,
 43561,
 143657105,
 143376155,
 43565,
 -1,
 143604910,
 43570,
 143788179,
 143623614,
 43567,
 -1,
 143735982,
 43566,
 143919253,
 143743555,
 43562,
 -1,
 143874627,
 43563,
 -1,
 143868003,
 43564,
 144115876,
 143275930,
 -1,
 144181402,
 144094341,
 -1,
 -63335,
 144166859,
 43602,
 -1,
 144201947,
 43603,
 144378013,
 144156837,
 -1,
 -63332,
 144336503,
 43606,
 -1,
 144393710,
 43607,
 144574624,
 144328654,
 -1,
 -63329,
 144543592,
 43604,
 -1,
 144598483,
 43605,
 -63327,
 144561534,
 43600,
 -63326,
 144738744,
 43601,
 -63325,
 144802395,
 43609,
 -1,
 144851054,
 43608,
 145033389,
 144060722,
 -1,
 145098921,
 144984398,
 -1,
 -63321,
 145064339,
 43587,
 -63320,
 145127180,
 43596,
 -1,
 145183224,
 43597,
 -63318,
 145085147,
 43571,
 -63317,
 145345358,
 43574,
 -63316,
 145398979,
 43572,
 -1,
 145451997,
 43573,
 145686527,
 145005084,
 -1,
 145688753,
 145568952,
 -1,
 -63312,
 145657595,
 43614,
 -1,
 145694521,
 43613,
 -63310,
 145669333,
 43615,
 -1,
 145862815,
 43612,
 146016525,
 138832580,
 -1,
 146082021,
 145977726,
 -1,
 146147515,
 146060421,
 -1,
 146213049,
 146125957,
 -1,
 -63304,
 146166307,
 69906,
 -1,
 146217300,
 69905,
 -63302,
 146166307,
 69911,
 -1,
 146348372,
 69910,
 146540736,
 146112314,
 -1,
 -63299,
 146526942,
 69904,
 -63298,
 146571170,
 69909,
 -63297,
 146623846,
 69899,
 -1,
 146676052,
 69914,
 146868422,
 146486456,
 -1,
 146933956,
 146814136,
 -1,
 -63293,
 146887203,
 69908,
 -1,
 146938196,
 69907,
 -63291,
 146887203,
 69913,
 -1,
 147069268,
 69912,
 147261641,
 146854530,
 -1,
 -63288,
 147247838,
 69920,
 -1,
 147265876,
 69921,
 147458252,
 147231526,
 -1,
 -63285,
 147411491,
 69916,
 -1,
 147462484,
 69915,
 147654863,
 147417117,
 -1,
 -63282,
 147608099,
 69896,
 -1,
 147659092,
 69895,
 147851474,
 147613430,
 -1,
 -63279,
 147804707,
 69903,
 -1,
 147855700,
 69902,
 148048085,
 147803412,
 -1,
 -63276,
 148001315,
 69898,
 -1,
 148052308,
 69897,
 148244696,
 147991193,
 -1,
 -63273,
 148197923,
 69901,
 -1,
 148248916,
 69900,
 148441307,
 148186404,
 -1,
 -63270,
 148394531,
 69918,
 -1,
 148445524,
 69917,
 -63268,
 148425553,
 69924,
 -63267,
 148619035,
 69893,
 -63266,
 148678976,
 69925,
 -63265,
 148741338,
 69922,
 -63264,
 148797285,
 69919,
 -63263,
 148859885,
 69923,
 -63262,
 148920899,
 69892,
 -63261,
 148984355,
 69926,
 -63260,
 149044398,
 69894,
 -1,
 149100884,
 69891,
 149293302,
 146027704,
 -1,
 149358836,
 149249450,
 -1,
 149424362,
 149337221,
 -1,
 -63255,
 149409739,
 69944,
 -1,
 149444827,
 69945,
 149620973,
 149399717,
 -1,
 -63252,
 149579383,
 69948,
 -1,
 149636590,
 69949,
 149817584,
 149571534,
 -1,
 -63249,
 149786472,
 69946,
 -1,
 149841363,
 69947,
 -63247,
 149804414,
 69942,
 -63246,
 149981624,
 69943,
 -63245,
 150045275,
 69951,
 -1,
 150093934,
 69950,
 -63243,
 149327611,
 69954,
 -1,
 150216505,
 69953,
 150407427,
 149276317,
 -1,
 150472962,
 150377126,
 -1,
 150538491,
 150411430,
 69927,
 -63238,
 150519579,
 69935,
 -1,
 150559299,
 69933,
 150735101,
 150519579,
 69930,
 -1,
 150716187,
 69931,
 150866175,
 150701502,
 69934,
 -1,
 150821443,
 69936,
 150997249,
 150821443,
 69928,
 -1,
 150952515,
 69929,
 -1,
 150944942,
 69932,
 -1,
 150430681,
 69939,
 151259401,
 150382757,
 -1,
 151324936,
 151215553,
 -1,
 -63226,
 151308689,
 69890,
 -63225,
 151333722,
 69888,
 -1,
 151396402,
 69889,
 -1,
 151273152,
 69952,
 -63222,
 151231485,
 69955,
 -63221,
 151619034,
 69937,
 -63220,
 151680879,
 69940,
 -1,
 151725130,
 69938,
 151914774,
 145988687,
 -1,
 151980306,
 151893244,
 -1,
 152045841,
 151962885,
 128200,
 -1,
 151978205,
 128185,
 -1,
 151993294,
 128201,
 152305663,
 151919268,
 983058,
 152371199,
 152174592,
 -1,
 -63211,
 152293005,
 983139,
 -1,
 152349431,
 983136,
 -1,
 151871975,
 9939,
 152570247,
 138755246,
 -1,
 152635777,
 152542287,
 -1,
 152701310,
 152602614,
 -1,
 152766845,
 152678197,
 -1,
 152832301,
 152745093,
 -1,
 152897827,
 152807589,
 -1,
 -63202,
 152880797,
 43960,
 -63201,
 152944411,
 43959,
 -63200,
 152995262,
 43958,
 -63199,
 153049667,
 43957,
 -63198,
 153107630,
 43956,
 -1,
 153163942,
 43955,
 153356586,
 152857519,
 -1,
 -63195,
 153339549,
 43954,
 -63194,
 153403163,
 43953,
 -63193,
 153454014,
 43952,
 -63192,
 153508419,
 43951,
 -63191,
 153566382,
 43950,
 -1,
 153622694,
 43949,
 -63189,
 153311811,
 43944,
 -63188,
 153762990,
 43942,
 -1,
 153819302,
 43940,
 154011956,
 152807589,
 43933,
 -63185,
 153994909,
 43938,
 -63184,
 154058523,
 43937,
 -63183,
 154109374,
 43936,
 -63182,
 154163779,
 43935,
 -63181,
 154221742,
 43934,
 -1,
 154278054,
 43932,
 154470716,
 153976634,
 -1,
 154536247,
 154409126,
 43918,
 -1,
 154489336,
 43920,
 -63176,
 154519197,
 43925,
 -63175,
 154648347,
 43924,
 -63174,
 154699198,
 43923,
 -63173,
 154753603,
 43922,
 -1,
 154811566,
 43921,
 154995012,
 154423800,
 -1,
 -63170,
 154977949,
 43906,
 -63169,
 155041563,
 43905,
 -63168,
 155092414,
 43904,
 -63167,
 155156368,
 43919,
 -63166,
 155212355,
 43903,
 -63165,
 155270318,
 43902,
 -1,
 155326630,
 43901,
 155519308,
 154940600,
 -1,
 -63162,
 155502237,
 43947,
 -63161,
 155565851,
 43946,
 -63160,
 155616702,
 43945,
 -63159,
 155675613,
 43948,
 -63158,
 155736643,
 43943,
 -63157,
 155794606,
 43941,
 -1,
 155850918,
 43939,
 156043603,
 155505282,
 -1,
 -63154,
 156026525,
 5116,
 -63153,
 156090139,
 5115,
 -63152,
 156140990,
 5114,
 -63151,
 156195395,
 5113,
 -63150,
 156253358,
 5112,
 -1,
 156309670,
 43967,
 156502362,
 156027662,
 -1,
 -63147,
 156485277,
 43966,
 -63146,
 156548891,
 43965,
 -63145,
 156599742,
 43964,
 -63144,
 156654147,
 43963,
 -63143,
 156712110,
 43962,
 -1,
 156768422,
 43961,
 156961121,
 156474121,
 -1,
 -63140,
 156944029,
 43931,
 -63139,
 157007643,
 43930,
 -63138,
 157058494,
 43929,
 -63137,
 157112899,
 43928,
 -63136,
 157170862,
 43927,
 -1,
 157227174,
 43926,
 157419880,
 156923660,
 -1,
 -63133,
 157402781,
 5117,
 -63132,
 157466395,
 43917,
 -63131,
 157517246,
 43916,
 -63130,
 157571651,
 43915,
 -63129,
 157629614,
 43914,
 -1,
 157685926,
 43913,
 157878639,
 157379503,
 -1,
 -63126,
 157861533,
 43912,
 -63125,
 157925147,
 43911,
 -63124,
 157975998,
 43910,
 -63123,
 158030403,
 43909,
 -63122,
 158088366,
 43908,
 -1,
 158144678,
 43907,
 158337398,
 157830420,
 -1,
 -63119,
 158320285,
 43900,
 -63118,
 158383899,
 43899,
 -63117,
 158434750,
 43898,
 -63116,
 158489155,
 43897,
 -63115,
 158547118,
 43896,
 -1,
 158603430,
 43894,
 -63113,
 158320285,
 43893,
 -63112,
 158777115,
 43892,
 -63111,
 158827966,
 43891,
 -63110,
 158885999,
 43895,
 -63109,
 158947907,
 43890,
 -63108,
 159005870,
 43889,
 -1,
 159062182,
 43888,
 -1,
 152727964,
 5109,
 159383551,
 152673359,
 -1,
 -63104,
 159306386,
 127800,
 -1,
 159341673,
 127826,
 159517060,
 152583342,
 -1,
 -63101,
 159492667,
 129472,
 -1,
 159556823,
 128227,
 -63099,
 159494724,
 127792,
 -63098,
 159685608,
 127937,
 -1,
 159723379,
 128638,
 159910284,
 152525379,
 -1,
 -63095,
 159884957,
 9911,
 -63094,
 159946662,
 128063,
 -63093,
 160001619,
 128696,
 -1,
 160051054,
 128020,
 -63091,
 159892827,
 9962,
 -63090,
 160212427,
 127876,
 -1,
 160269943,
 127851,
 160434844,
 138680486,
 -1,
 160500231,
 160399162,
 983098,
 160565761,
 160439065,
 -1,
 160631202,
 160531902,
 -1,
 160696737,
 160589711,
 -1,
 160762266,
 160661306,
 6361,
 160890879,
 160746254,
 -1,
 160893336,
 160794046,
 6347,
 -1,
 160859582,
 6349,
 161087487,
 160848451,
 6343,
 -1,
 160979523,
 6345,
 161155484,
 160737445,
 6362,
 -1,
 161108472,
 6363,
 -63075,
 161133701,
 6357,
 -63074,
 161256230,
 6356,
 -63073,
 161314572,
 6360,
 -63072,
 161376285,
 6358,
 -1,
 161426073,
 6359,
 -1,
 160682626,
 6320,
 161679795,
 160615182,
 -1,
 161745325,
 161647373,
 -1,
 161810860,
 161724663,
 -1,
 161876391,
 161777086,
 5754,
 -1,
 161842622,
 5755,
 162007465,
 161831491,
 5752,
 -1,
 161962563,
 5753,
 162138539,
 161945766,
 5756,
 -1,
 162076838,
 5757,
 -1,
 162086730,
 5751,
 -1,
 161761641,
 5758,
 162400690,
 161694938,
 -1,
 162466225,
 162336287,
 -1,
 -63056,
 162433792,
 6369,
 -1,
 162470228,
 6370,
 -1,
 162415674,
 6365,
 -1,
 162342117,
 6323,
 162793920,
 161654949,
 -1,
 162859451,
 162735333,
 6335,
 162988031,
 162817189,
 -1,
 162990521,
 162900758,
 -1,
 -63048,
 162974817,
 6378,
 -1,
 163023616,
 6379,
 -63046,
 162949141,
 6385,
 -1,
 163141512,
 6380,
 163318207,
 162812408,
 -1,
 -63043,
 163303742,
 6338,
 -63042,
 163353322,
 6336,
 -1,
 163390693,
 6337,
 -1,
 163287786,
 6334,
 163645900,
 162772101,
 -1,
 163711429,
 163624787,
 -1,
 -63037,
 163695713,
 6373,
 -63036,
 163744512,
 6374,
 -1,
 163780948,
 6375,
 163973576,
 163672612,
 -1,
 -63033,
 163957857,
 6376,
 -1,
 164006656,
 6377,
 164170187,
 163928599,
 -1,
 -63030,
 164117678,
 6371,
 -1,
 164173990,
 6372,
 -1,
 164111589,
 6327,
 164432342,
 163617871,
 -1,
 164497876,
 164416270,
 -1,
 164563408,
 164464062,
 6353,
 -1,
 164529598,
 6354,
 164694482,
 164518467,
 6351,
 -1,
 164649539,
 6352,
 -63021,
 164642634,
 6350,
 -1,
 164763814,
 6355,
 -63019,
 164439269,
 6341,
 -1,
 164892199,
 6368,
 165087710,
 164396858,
 -1,
 165153244,
 165071630,
 -1,
 165218778,
 165119422,
 6346,
 -1,
 165184958,
 6348,
 165412863,
 165173827,
 6342,
 -1,
 165304899,
 6344,
 -63011,
 165122794,
 6331,
 -1,
 165422309,
 6332,
 165612008,
 165030864,
 -1,
 165677540,
 165563668,
 -1,
 165743075,
 165661454,
 -1,
 -63006,
 165723931,
 6381,
 -1,
 165746854,
 6384,
 -1,
 165681492,
 6383,
 166005223,
 165623385,
 -1,
 -63002,
 165983667,
 6389,
 -1,
 166018276,
 6382,
 -1,
 165963801,
 6386,
 166267372,
 165581606,
 -1,
 -62998,
 166252862,
 6326,
 -62997,
 166302442,
 6324,
 -1,
 166339813,
 6325,
 166529521,
 166208804,
 -1,
 166595056,
 166477444,
 -1,
 -62993,
 166566991,
 6388,
 -1,
 166620079,
 6387,
 -1,
 166554673,
 5759,
 166857204,
 166515330,
 -1,
 -62989,
 166826730,
 6339,
 -1,
 166864101,
 6340,
 167053815,
 166815773,
 -1,
 -62986,
 167038021,
 6329,
 -1,
 167060709,
 6328,
 167250426,
 167004494,
 -1,
 -62983,
 167227236,
 6366,
 -1,
 167288132,
 6367,
 167447037,
 167188646,
 -1,
 -62980,
 167432834,
 6321,
 -1,
 167453925,
 6322,
 -62978,
 167410086,
 6330,
 -62977,
 167603682,
 6333,
 -62976,
 167664188,
 5120,
 -1,
 167722580,
 6364,
 167905796,
 160509086,
 983097,
 -62973,
 167865787,
 128473,
 -1,
 167903723,
 983170,
 168165375,
 167851192,
 -1,
 -62970,
 168088194,
 127852,
 -1,
 168128098,
 128367,
 168299075,
 160472143,
 -1,
 168364603,
 168254231,
 -1,
 168430095,
 168345371,
 66226,
 168558591,
 168410907,
 66239,
 168624127,
 168476443,
 66212,
 -62963,
 168541979,
 66235,
 -62962,
 168563367,
 66256,
 -1,
 168628610,
 66248,
 168823317,
 168405157,
 66224,
 168888850,
 168801413,
 66242,
 -1,
 168825218,
 66243,
 169019924,
 168841720,
 66222,
 -1,
 168956290,
 66223,
 -1,
 168994981,
 66232,
 169216538,
 168785676,
 66218,
 169345023,
 169157924,
 66250,
 -62952,
 169219013,
 66253,
 -62951,
 169284263,
 66252,
 -1,
 169349506,
 66251,
 169544222,
 169180986,
 66229,
 -62948,
 169508666,
 66227,
 -62947,
 169561364,
 66244,
 -1,
 169620664,
 66238,
 169806369,
 169522309,
 66221,
 169934847,
 169784453,
 66247,
 -1,
 169808258,
 66230,
 170002980,
 169765807,
 66211,
 170131455,
 169948344,
 66214,
 -1,
 170004866,
 66254,
 170199590,
 169974863,
 66213,
 -1,
 170171471,
 66249,
 170330664,
 170169126,
 66231,
 -1,
 170267010,
 66209,
 170461738,
 170289181,
 66236,
 -1,
 170398082,
 66237,
 170592812,
 170416707,
 66233,
 -1,
 170547779,
 66245,
 170723886,
 170544404,
 66240,
 -1,
 170660226,
 66241,
 170854960,
 170671278,
 66234,
 -1,
 170791298,
 66255,
 170986034,
 170800312,
 66210,
 -1,
 170922370,
 66220,
 171117109,
 170928833,
 -1,
 -62924,
 171054018,
 66246,
 -1,
 171118962,
 66225,
 171313719,
 171055270,
 66208,
 -1,
 171250050,
 66215,
 -62920,
 171299230,
 66228,
 -62919,
 171416232,
 66216,
 -62918,
 171476414,
 66219,
 -1,
 171517220,
 66217,
 171706943,
 168309946,
 -1,
 171772478,
 171663208,
 128199,
 -1,
 171704978,
 128450,
 -1,
 171723063,
 128451,
 -62912,
 171680226,
 983073,
 -62911,
 171938649,
 127887,
 -62910,
 172003358,
 127904,
 -1,
 172034269,
 9936,
 172231311,
 168280309,
 -1,
 172296846,
 172192126,
 -1,
 172362321,
 172239513,
 -1,
 172427851,
 172315128,
 -1,
 172493385,
 172365990,
 66873,
 -1,
 172471429,
 66902,
 -62902,
 172462826,
 66889,
 -1,
 172579395,
 66890,
 172755534,
 172413659,
 -1,
 -62899,
 172741250,
 66891,
 -1,
 172804878,
 66911,
 173015039,
 172693670,
 -1,
 -62896,
 172938309,
 66912,
 -1,
 172989519,
 66882,
 173148759,
 172337317,
 -1,
 173214294,
 173101560,
 -1,
 173279829,
 173152422,
 66877,
 -1,
 173238301,
 66896,
 -1,
 173249258,
 66909,
 -1,
 173164490,
 66906,
 173541981,
 173094072,
 -1,
 173607515,
 173528261,
 -1,
 -62886,
 173593420,
 66895,
 -1,
 173614309,
 66901,
 -62884,
 173593382,
 66881,
 -1,
 173744911,
 66867,
 173935202,
 173528261,
 -1,
 174000737,
 173887992,
 -1,
 -62880,
 173956607,
 66871,
 -1,
 174004390,
 66875,
 -1,
 173941078,
 66869,
 174262886,
 173913221,
 -1,
 -62876,
 174248780,
 66899,
 -62875,
 174286451,
 66908,
 -1,
 174334565,
 66872,
 174525034,
 174217795,
 -1,
 -62872,
 174509950,
 66910,
 -62871,
 174563011,
 66876,
 -1,
 174622094,
 66879,
 174787181,
 174510722,
 -1,
 -62868,
 174756508,
 66874,
 -1,
 174793985,
 66913,
 174983792,
 174758582,
 -1,
 -62865,
 174969474,
 66887,
 -1,
 175021135,
 66893,
 175180403,
 174953254,
 -1,
 -62862,
 175138419,
 66914,
 -1,
 175194506,
 66903,
 175377014,
 175139759,
 -1,
 -62859,
 175363079,
 66885,
 -1,
 175382185,
 66878,
 175573625,
 175335453,
 -1,
 -62856,
 175531632,
 66915,
 -1,
 175579306,
 66884,
 175770236,
 175531766,
 -1,
 -62853,
 175724759,
 66883,
 -1,
 175777052,
 66897,
 175966847,
 175721748,
 -1,
 -62850,
 175922786,
 66866,
 -1,
 175986037,
 66904,
 176163458,
 175914158,
 -1,
 -62847,
 176149573,
 66870,
 -1,
 176170276,
 66868,
 176360069,
 176101542,
 -1,
 -62844,
 176327891,
 66888,
 -1,
 176387679,
 66864,
 -62842,
 176345618,
 66880,
 -62841,
 176539980,
 66907,
 -62840,
 176594517,
 66905,
 -62839,
 176654646,
 66898,
 -62838,
 176718788,
 66894,
 -62837,
 176781574,
 66892,
 -62836,
 176838010,
 66886,
 -62835,
 176900194,
 66900,
 -1,
 176957227,
 66865,
 -1,
 172240674,
 66927,
 177212052,
 172209285,
 128008,
 177340415,
 177144546,
 128049,
 177405951,
 177212168,
 -1,
 -62829,
 177328509,
 128572,
 -1,
 177387085,
 128569,
 177539736,
 177174284,
 -1,
 177605271,
 177488857,
 128247,
 -1,
 177540160,
 128248,
 -1,
 177575605,
 127957,
 -62823,
 177517119,
 9963,
 -62822,
 177772238,
 11839,
 -62821,
 177828143,
 128197,
 -1,
 177877997,
 127797,
 178064272,
 160420482,
 -1,
 178129739,
 178037882,
 -1,
 178195187,
 178106165,
 -1,
 178260652,
 178140344,
 -1,
 178326182,
 178246853,
 -1,
 178391716,
 178312389,
 -1,
 -62813,
 178345022,
 1323,
 -1,
 178404526,
 42633,
 -62811,
 178375777,
 42627,
 -1,
 178536755,
 42563,
 178719401,
 178294516,
 -1,
 -62808,
 178685374,
 42649,
 -1,
 178748841,
 42605,
 -62806,
 178703457,
 42625,
 -62805,
 178874236,
 42569,
 -1,
 178924876,
 1325,
 179112627,
 178238597,
 -1,
 179178160,
 179087525,
 -1,
 -62801,
 179162209,
 42639,
 -1,
 179218996,
 42641,
 -62799,
 179162209,
 42637,
 -62798,
 179322213,
 42635,
 -1,
 179383628,
 42643,
 179571388,
 179087525,
 -1,
 179636921,
 179537681,
 -1,
 179702456,
 179584174,
 -1,
 -62793,
 179664652,
 42599,
 -1,
 179727279,
 42597,
 -1,
 179648008,
 42595,
 180027391,
 179589624,
 -1,
 -62789,
 179948641,
 42647,
 -1,
 179982865,
 1319,
 180161219,
 179543119,
 -1,
 180226754,
 180110947,
 -1,
 -62785,
 180213084,
 1297,
 -62784,
 180278453,
 42581,
 -62783,
 180337958,
 42593,
 -1,
 180370597,
 42565,
 -1,
 180179470,
 1303,
 180619979,
 180108462,
 -1,
 180685512,
 180579261,
 -1,
 -62778,
 180648923,
 1313,
 -62777,
 180705164,
 1299,
 -1,
 180762267,
 1327,
 181010431,
 180649833,
 -1,
 -62774,
 180911067,
 1315,
 -1,
 180973446,
 1321,
 181144273,
 180577139,
 -1,
 181209808,
 181099652,
 -1,
 -62770,
 181195583,
 42579,
 -62769,
 181219298,
 42589,
 -1,
 181278886,
 42583,
 -1,
 181147814,
 42567,
 181537493,
 181129858,
 -1,
 -62765,
 181501754,
 42591,
 -62764,
 181552243,
 42577,
 -1,
 181607214,
 1305,
 181799642,
 181490168,
 -1,
 181865177,
 181737756,
 -1,
 -62760,
 181842662,
 1279,
 -1,
 181884812,
 1277,
 -1,
 181849185,
 42645,
 182127326,
 181742233,
 -1,
 -62756,
 182101751,
 42651,
 -62755,
 182154544,
 42585,
 -1,
 182201676,
 42631,
 182389474,
 182068516,
 -1,
 -62752,
 182363714,
 42573,
 -62751,
 182415670,
 42587,
 -1,
 182477261,
 42603,
 182651621,
 182375621,
 -1,
 -62748,
 182606381,
 42629,
 -1,
 182665590,
 42561,
 182848232,
 182620966,
 -1,
 -62745,
 182795591,
 1317,
 -1,
 182853143,
 1231,
 183044843,
 182812068,
 -1,
 -62742,
 182997202,
 42571,
 -1,
 183055362,
 42601,
 183241454,
 182996826,
 -1,
 -62739,
 183218933,
 1275,
 -1,
 183252635,
 1271,
 -62737,
 183225441,
 1309,
 -62736,
 183409334,
 1307,
 -62735,
 183468393,
 42575,
 -62734,
 183530023,
 1301,
 -1,
 183573949,
 1311,
 183765830,
 178138009,
 -1,
 183831297,
 183710904,
 -1,
 183896827,
 183817413,
 -1,
 183962361,
 183882949,
 -1,
 -62728,
 183915582,
 1322,
 -1,
 183975086,
 42632,
 -62726,
 183946337,
 42626,
 -1,
 184107315,
 42562,
 184290046,
 183865076,
 -1,
 -62723,
 184255934,
 42648,
 -1,
 184319401,
 42604,
 -62721,
 184274017,
 42624,
 -62720,
 184444796,
 42568,
 -1,
 184495436,
 1324,
 184683272,
 183809157,
 -1,
 184748805,
 184658085,
 -1,
 -62716,
 184732769,
 42638,
 -1,
 184789556,
 42640,
 -62714,
 184732769,
 42636,
 -62713,
 184892773,
 42634,
 -1,
 184954188,
 42642,
 185142033,
 184658085,
 -1,
 185207566,
 185108241,
 -1,
 185273101,
 185154734,
 -1,
 -62708,
 185235212,
 42598,
 -1,
 185297839,
 42596,
 -1,
 185218568,
 42594,
 185597951,
 185160184,
 -1,
 -62704,
 185519201,
 42646,
 -1,
 185553425,
 1318,
 185731864,
 185113679,
 -1,
 185797399,
 185681507,
 -1,
 -62700,
 185783644,
 1296,
 -62699,
 185849013,
 42580,
 -62698,
 185908518,
 42592,
 -1,
 185941157,
 42564,
 -1,
 185750030,
 1302,
 186190624,
 185679022,
 -1,
 186256157,
 186149821,
 -1,
 -62693,
 186219483,
 1312,
 -62692,
 186275724,
 1298,
 -1,
 186332827,
 1326,
 186580991,
 186220393,
 -1,
 -62689,
 186481627,
 1314,
 -1,
 186544006,
 1320,
 186714918,
 186147699,
 -1,
 186780453,
 186670212,
 -1,
 -62685,
 186766143,
 42578,
 -62684,
 186789858,
 42588,
 -1,
 186849446,
 42582,
 -1,
 186718374,
 42566,
 187108138,
 186700418,
 -1,
 -62680,
 187072314,
 42590,
 -62679,
 187122803,
 42576,
 -1,
 187177774,
 1304,
 187370287,
 187060728,
 -1,
 187435822,
 187308316,
 -1,
 -62675,
 187413222,
 1278,
 -1,
 187455372,
 1276,
 -1,
 187419745,
 42644,
 187697971,
 187312793,
 -1,
 -62671,
 187672311,
 42650,
 -62670,
 187725104,
 42584,
 -1,
 187772236,
 42630,
 187960119,
 187639076,
 -1,
 -62667,
 187934274,
 42572,
 -62666,
 187986230,
 42586,
 -1,
 188047821,
 42602,
 188222266,
 187946181,
 -1,
 -62663,
 188176941,
 42628,
 -1,
 188236150,
 42560,
 188418877,
 188186020,
 -1,
 -62660,
 188371154,
 42570,
 -1,
 188429314,
 42600,
 188615488,
 188370778,
 -1,
 -62657,
 188592885,
 1274,
 -1,
 188626587,
 1270,
 -62655,
 188599393,
 1308,
 -62654,
 188783286,
 1306,
 -62653,
 188847379,
 1316,
 -62652,
 188907881,
 42574,
 -62651,
 188969511,
 1300,
 -1,
 189013437,
 1310,
 189205321,
 183726462,
 -1,
 -62648,
 189181692,
 7467,
 -1,
 189234825,
 42606,
 -62646,
 189175022,
 42623,
 -1,
 189360471,
 42622,
 189533071,
 178100621,
 -1,
 189598546,
 189510789,
 -1,
 -62642,
 189579035,
 67633,
 -62641,
 189629886,
 67632,
 -62640,
 189684291,
 67631,
 -62639,
 189742254,
 67630,
 -1,
 189798566,
 67629,
 189991768,
 189573285,
 -1,
 -62636,
 189972251,
 67628,
 -62635,
 190023102,
 67627,
 -62634,
 190077507,
 67626,
 -62633,
 190135470,
 67625,
 -1,
 190191782,
 67624,
 190384990,
 189963343,
 -1,
 -62630,
 190365467,
 67623,
 -62629,
 190416318,
 67622,
 -62628,
 190470723,
 67621,
 -62627,
 190528686,
 67620,
 -1,
 190584998,
 67619,
 190778212,
 190354214,
 -1,
 -62624,
 190758683,
 67618,
 -62623,
 190809534,
 67617,
 -62622,
 190863939,
 67616,
 -62621,
 190921902,
 67615,
 -1,
 190978214,
 67614,
 191171434,
 190742330,
 -1,
 -62618,
 191151899,
 67613,
 -62617,
 191202750,
 67612,
 -62616,
 191257155,
 67611,
 -62615,
 191315118,
 67610,
 -1,
 191371430,
 67609,
 191564656,
 191133452,
 -1,
 -62612,
 191545115,
 67608,
 -62611,
 191595966,
 67607,
 -62610,
 191650371,
 67606,
 -62609,
 191708334,
 67605,
 -1,
 191764646,
 67604,
 191957878,
 191523759,
 -1,
 -62606,
 191938331,
 67603,
 -62605,
 191989182,
 67602,
 -62604,
 192043587,
 67601,
 -62603,
 192101550,
 67600,
 -1,
 192157862,
 67599,
 192351100,
 191916061,
 -1,
 -62600,
 192331547,
 67598,
 -62599,
 192382398,
 67597,
 -62598,
 192436803,
 67596,
 -62597,
 192494766,
 67595,
 -1,
 192551078,
 67594,
 192744321,
 192334606,
 -1,
 -62594,
 192710078,
 67637,
 -62593,
 192764483,
 67636,
 -62592,
 192822446,
 67635,
 -1,
 192878758,
 67634,
 193072004,
 192730309,
 -1,
 -62589,
 193037758,
 67647,
 -1,
 193075366,
 67644,
 193268615,
 193057182,
 -1,
 -62586,
 193215662,
 67640,
 -1,
 193271974,
 67639,
 193465226,
 193226486,
 -1,
 -62583,
 193430974,
 67592,
 -1,
 193468582,
 67589,
 -62581,
 193445659,
 67588,
 -62580,
 193627582,
 67587,
 -62579,
 193681987,
 67586,
 -62578,
 193739950,
 67585,
 -1,
 193796262,
 67584,
 -1,
 189476788,
 127744,
 194055215,
 178022311,
 -1,
 194120714,
 193999074,
 -1,
 194186147,
 194063001,
 -1,
 -62572,
 194136014,
 64207,
 -62571,
 194198702,
 64206,
 -62570,
 194262200,
 64205,
 -62569,
 194325145,
 64204,
 -62568,
 194389284,
 64203,
 -62567,
 194451622,
 64202,
 -62566,
 194516975,
 64201,
 -62565,
 194582334,
 64200,
 -62564,
 194647646,
 64199,
 -62563,
 194712974,
 64198,
 -62562,
 194778265,
 64197,
 -62561,
 194843589,
 64196,
 -62560,
 194908839,
 64195,
 -62559,
 194974082,
 64194,
 -62558,
 195039323,
 64193,
 -1,
 195104594,
 64192,
 195300276,
 194127140,
 -1,
 -62555,
 195250126,
 64191,
 -62554,
 195312814,
 64190,
 -62553,
 195376312,
 64189,
 -62552,
 195439257,
 64188,
 -62551,
 195503396,
 64187,
 -62550,
 195565734,
 64186,
 -62549,
 195631087,
 64185,
 -62548,
 195696446,
 64184,
 -62547,
 195761758,
 64183,
 -62546,
 195827086,
 64182,
 -62545,
 195892377,
 64181,
 -62544,
 195957701,
 64180,
 -62543,
 196022951,
 64179,
 -62542,
 196088194,
 64178,
 -62541,
 196153435,
 64177,
 -1,
 196218706,
 64176,
 196414405,
 195238054,
 -1,
 -62538,
 196364238,
 64175,
 -62537,
 196426926,
 64174,
 -62536,
 196490424,
 64173,
 -62535,
 196553369,
 64172,
 -62534,
 196617508,
 64171,
 -62533,
 196679846,
 64170,
 -62532,
 196745199,
 64169,
 -62531,
 196810558,
 64168,
 -62530,
 196875870,
 64167,
 -62529,
 196941198,
 64166,
 -62528,
 197006489,
 64165,
 -62527,
 197071813,
 64164,
 -62526,
 197137063,
 64163,
 -62525,
 197202306,
 64162,
 -62524,
 197267547,
 64161,
 -1,
 197332818,
 64160,
 197528534,
 196351983,
 -1,
 -62521,
 197478350,
 64159,
 -62520,
 197541038,
 64158,
 -62519,
 197604536,
 64157,
 -62518,
 197667481,
 64156,
 -62517,
 197731620,
 64155,
 -62516,
 197793958,
 64154,
 -62515,
 197859311,
 64153,
 -62514,
 197924670,
 64152,
 -62513,
 197989982,
 64151,
 -62512,
 198055310,
 64150,
 -62511,
 198120601,
 64149,
 -62510,
 198185925,
 64148,
 -62509,
 198251175,
 64147,
 -62508,
 198316418,
 64146,
 -62507,
 198381659,
 64145,
 -1,
 198446930,
 64144,
 198642663,
 197465918,
 -1,
 -62504,
 198592462,
 64143,
 -62503,
 198655150,
 64142,
 -62502,
 198718648,
 64141,
 -62501,
 198781593,
 64140,
 -62500,
 198845732,
 64139,
 -62499,
 198908070,
 64138,
 -62498,
 198973423,
 64137,
 -62497,
 199038782,
 64136,
 -62496,
 199104094,
 64135,
 -62495,
 199169422,
 64134,
 -62494,
 199234713,
 64133,
 -62493,
 199300037,
 64132,
 -62492,
 199365287,
 64131,
 -62491,
 199430530,
 64130,
 -62490,
 199495771,
 64129,
 -1,
 199561042,
 64128,
 199756792,
 198579806,
 -1,
 -62487,
 199706574,
 64127,
 -62486,
 199769262,
 64126,
 -62485,
 199832760,
 64125,
 -62484,
 199895705,
 64124,
 -62483,
 199959844,
 64123,
 -62482,
 200022182,
 64122,
 -62481,
 200087535,
 64121,
 -62480,
 200152894,
 64120,
 -62479,
 200218206,
 64119,
 -62478,
 200283534,
 64118,
 -62477,
 200348825,
 64117,
 -62476,
 200414149,
 64116,
 -62475,
 200479399,
 64115,
 -62474,
 200544642,
 64114,
 -62473,
 200609883,
 64113,
 -1,
 200675154,
 64112,
 200870915,
 199701688,
 -1,
 -62470,
 200808431,
 64217,
 -62469,
 200873790,
 64216,
 -62468,
 200939102,
 64215,
 -62467,
 201004430,
 64214,
 -62466,
 201069721,
 64213,
 -62465,
 201135045,
 64212,
 -62464,
 201200295,
 64211,
 -62463,
 201265538,
 64210,
 -62462,
 201330779,
 64209,
 -1,
 201396050,
 64208,
 201591815,
 200807822,
 -1,
 -62459,
 201536696,
 64109,
 -62458,
 201599641,
 64108,
 -1,
 201663780,
 64107,
 201916415,
 201527682,
 -1,
 -62455,
 201803726,
 64047,
 -1,
 201866414,
 64046,
 202113023,
 194097901,
 -1,
 202116121,
 202002936,
 12752,
 202181653,
 202101957,
 12757,
 202247185,
 202167493,
 12741,
 202312720,
 202233029,
 12750,
 -1,
 202263828,
 12769,
 -1,
 202281766,
 12747,
 202509331,
 202230542,
 12749,
 -1,
 202460436,
 12744,
 -62444,
 202486917,
 12746,
 -1,
 202591508,
 12742,
 202771479,
 202150694,
 12743,
 -1,
 202755330,
 12748,
 -62440,
 202756724,
 12768,
 -1,
 202853652,
 12758,
 203033635,
 202090661,
 12753,
 203099165,
 203019461,
 12759,
 -62436,
 203084997,
 12766,
 -1,
 203148546,
 12745,
 203295776,
 203082510,
 12740,
 -62433,
 203281605,
 12760,
 -1,
 203312404,
 12767,
 -62431,
 203273349,
 12761,
 -62430,
 203461414,
 12755,
 -1,
 203509012,
 12762,
 203688999,
 203002662,
 12754,
 -62427,
 203674821,
 12764,
 -62426,
 203705620,
 12770,
 -1,
 203764920,
 12763,
 203951145,
 203666565,
 12736,
 -1,
 203915066,
 12765,
 -62422,
 203936279,
 12738,
 -62421,
 204066050,
 12737,
 -62420,
 204118696,
 12771,
 -62419,
 204177210,
 12751,
 -62418,
 204223672,
 12756,
 -1,
 204286597,
 12739,
 204475512,
 194014127,
 -1,
 204541039,
 204441022,
 -1,
 204606563,
 204484423,
 -1,
 204672092,
 204538600,
 -1,
 204737601,
 204649605,
 -1,
 204803131,
 204720910,
 -1,
 204868664,
 204768702,
 -1,
 -62409,
 204803905,
 128349,
 -1,
 204866793,
 128337,
 205127679,
 204816704,
 -1,
 -62406,
 205000513,
 128359,
 -1,
 205063401,
 128347,
 205261886,
 204757211,
 -1,
 -62403,
 205197121,
 128350,
 -1,
 205260009,
 128338,
 205520895,
 205209994,
 -1,
 -62400,
 205393729,
 128357,
 -1,
 205456617,
 128345,
 205655112,
 204712101,
 -1,
 205720645,
 205612663,
 -1,
 -62396,
 205655873,
 128353,
 -1,
 205718761,
 128341,
 205979647,
 205669870,
 -1,
 -62393,
 205852481,
 128354,
 -1,
 205915369,
 128342,
 206113871,
 205604814,
 -1,
 206179404,
 206081896,
 -1,
 -62389,
 206114625,
 128351,
 -1,
 206177513,
 128339,
 206438399,
 206136787,
 -1,
 -62386,
 206311233,
 128352,
 -1,
 206374121,
 128340,
 206572630,
 206060718,
 -1,
 206638163,
 206533098,
 -1,
 -62382,
 206573377,
 128358,
 -1,
 206636265,
 128346,
 206897151,
 206593320,
 -1,
 -62379,
 206769985,
 128355,
 -1,
 206832873,
 128343,
 207031385,
 206539192,
 -1,
 -62376,
 206966593,
 128348,
 -1,
 207029481,
 128336,
 207290367,
 206996059,
 -1,
 -62373,
 207163201,
 128356,
 -1,
 207226089,
 128344,
 207486975,
 204656214,
 -1,
 207490145,
 207397509,
 -1,
 207555680,
 207473578,
 128257,
 -1,
 207489868,
 128258,
 -1,
 207487112,
 128472,
 -62366,
 207469671,
 11118,
 -1,
 207698815,
 128259,
 207883370,
 204581492,
 -1,
 207948903,
 207845340,
 -1,
 -62362,
 207920463,
 128235,
 -1,
 207975970,
 128234,
 -62360,
 207929928,
 127746,
 -62359,
 208106668,
 128272,
 -1,
 208152865,
 128213,
 208404479,
 207864086,
 -1,
 -62356,
 208321324,
 127786,
 -62355,
 208383983,
 127784,
 -62354,
 208444727,
 127783,
 -1,
 208499474,
 127785,
 208669813,
 204478630,
 -1,
 208735347,
 208640224,
 -1,
 -62350,
 208691330,
 128079,
 -1,
 208749462,
 127916,
 -62348,
 208712048,
 127963,
 -1,
 208895567,
 128385,
 209125375,
 208624195,
 -1,
 -62345,
 209032438,
 128203,
 -1,
 209093356,
 127867,
 209259685,
 204429891,
 -1,
 209325218,
 209231558,
 -1,
 209390753,
 209284846,
 -1,
 209456265,
 209345091,
 -1,
 209521797,
 209401469,
 -1,
 209587328,
 209479709,
 -1,
 -62337,
 209555104,
 12871,
 -1,
 209608540,
 12869,
 209783939,
 209524902,
 -1,
 -62334,
 209730693,
 127568,
 -1,
 209792068,
 127569,
 -62332,
 209758720,
 12870,
 -1,
 209951732,
 12868,
 210111624,
 209499585,
 -1,
 -62329,
 210082895,
 127276,
 -1,
 210119321,
 127275,
 -1,
 210076033,
 128712,
 210373781,
 209421561,
 -1,
 210439310,
 210351237,
 -1,
 -62324,
 210422927,
 12873,
 -62323,
 210458298,
 12874,
 -1,
 210518458,
 12872,
 210701457,
 210413733,
 -1,
 -62320,
 210659005,
 12877,
 -1,
 210716214,
 12878,
 210898068,
 210651086,
 -1,
 -62317,
 210865613,
 12875,
 -1,
 210918552,
 12876,
 -1,
 210845877,
 12879,
 211160218,
 210315929,
 -1,
 211225753,
 211134179,
 -1,
 -62312,
 211181766,
 9938,
 -1,
 211224629,
 128320,
 -1,
 211170488,
 127277,
 211487901,
 211118843,
 -1,
 -62308,
 211445775,
 12925,
 -1,
 211496235,
 12924,
 -62306,
 211472798,
 11198,
 -62305,
 211669403,
 127278,
 -62304,
 211702699,
 12926,
 -1,
 211757338,
 11199,
 -1,
 209372642,
 127914,
 212012196,
 209305363,
 127961,
 -1,
 211943746,
 127750,
 -1,
 211976465,
 127910,
 212208829,
 209230927,
 983074,
 212274355,
 212174270,
 -1,
 212339889,
 212250926,
 -1,
 212405420,
 212287183,
 -1,
 -62294,
 212382730,
 9876,
 -62293,
 212435168,
 127370,
 -1,
 212486706,
 127884,
 212667568,
 212336640,
 -1,
 212733103,
 212637810,
 128322,
 -1,
 212667468,
 128321,
 -1,
 212695319,
 10060,
 -1,
 212623558,
 9932,
 -62286,
 212324222,
 128081,
 -1,
 212938819,
 128010,
 213126328,
 212259458,
 -1,
 213191863,
 213082174,
 -1,
 -62282,
 213141542,
 128546,
 -1,
 213199849,
 128575,
 -1,
 213168556,
 128302,
 213454011,
 213073070,
 -1,
 -62278,
 213428725,
 127769,
 -1,
 213465087,
 128179,
 -62276,
 213408682,
 127951,
 -1,
 213588342,
 129408,
 213781697,
 212155566,
 -1,
 -62273,
 213754106,
 9907,
 -62272,
 213808771,
 128328,
 -1,
 213858074,
 8373,
 -62270,
 213757185,
 983187,
 -62269,
 213995587,
 983200,
 -1,
 214052092,
 983171,
 214242625,
 43173,
 -1,
 214307178,
 214194755,
 983080,
 214372513,
 214257767,
 -1,
 214438048,
 214356327,
 -1,
 214502974,
 214389240,
 -1,
 214568497,
 214440102,
 -1,
 214634032,
 214532159,
 -1,
 214699417,
 214583246,
 -1,
 214764917,
 214656230,
 121091,
 214892543,
 214695936,
 -1,
 214895916,
 214785896,
 120832,
 215023615,
 214827008,
 -1,
 215026942,
 214924224,
 120846,
 215154687,
 214958080,
 -1,
 215157989,
 215034521,
 -1,
 215223521,
 215124664,
 120853,
 215351295,
 215154688,
 -1,
 215354587,
 215267535,
 -1,
 215420122,
 215330074,
 120877,
 215547903,
 215351296,
 -1,
 -62247,
 215429399,
 120878,
 -1,
 215492334,
 120879,
 -1,
 215370544,
 120884,
 215747805,
 215307921,
 120857,
 -1,
 215681496,
 120882,
 215878879,
 215692338,
 120856,
 -1,
 215812534,
 120885,
 -62240,
 215841743,
 120855,
 -1,
 215965557,
 120854,
 216203263,
 215197411,
 -1,
 216206564,
 216088268,
 120858,
 -1,
 216140248,
 120883,
 -1,
 216138803,
 121001,
 216403185,
 215136457,
 120862,
 216530943,
 216334336,
 -1,
 216534251,
 216410777,
 -1,
 -62231,
 216515676,
 120872,
 -62230,
 216566465,
 120893,
 -1,
 216622070,
 120873,
 216796398,
 216486392,
 -1,
 -62227,
 216763168,
 120874,
 -1,
 216817975,
 120875,
 216993008,
 216735663,
 120895,
 -1,
 216925523,
 120894,
 -1,
 216934126,
 120866,
 217189623,
 216374351,
 -1,
 217255158,
 217145402,
 120966,
 217382911,
 217186304,
 -1,
 -62219,
 217264407,
 120972,
 -1,
 217327342,
 120971,
 -1,
 217193662,
 120849,
 217582841,
 217142929,
 120850,
 -1,
 217516296,
 120867,
 217713915,
 217523950,
 120848,
 -1,
 217647588,
 120865,
 -62212,
 217695211,
 120871,
 -62211,
 217821868,
 120864,
 -1,
 217871290,
 120996,
 218041629,
 215005391,
 -1,
 218107145,
 218017050,
 121052,
 218234879,
 218038272,
 -1,
 218238213,
 218151119,
 -1,
 -62205,
 218183482,
 121054,
 -62204,
 218247447,
 121055,
 -1,
 218310382,
 121056,
 218500360,
 218193774,
 -1,
 -62201,
 218453636,
 121059,
 -1,
 218506990,
 121057,
 -1,
 218442037,
 121058,
 218762515,
 218049177,
 -1,
 218828049,
 218742555,
 -1,
 218893584,
 218799183,
 -1,
 218959119,
 218875821,
 -1,
 -62194,
 218940108,
 121066,
 -1,
 218980850,
 121064,
 -1,
 218919507,
 121063,
 -1,
 218863849,
 120887,
 219348991,
 218784735,
 121067,
 -1,
 219231472,
 120892,
 219417879,
 218716044,
 121062,
 219545599,
 219365099,
 -1,
 -62186,
 219464530,
 120881,
 -1,
 219502225,
 120899,
 219680026,
 219368248,
 -1,
 -62183,
 219656822,
 121060,
 -1,
 219686638,
 121061,
 219938815,
 219619254,
 -1,
 -62180,
 219844699,
 120890,
 -1,
 219897579,
 120891,
 220073250,
 217994897,
 120843,
 220200959,
 220004352,
 -1,
 220204321,
 220101702,
 120852,
 -1,
 220137944,
 120870,
 -1,
 220165480,
 120844,
 220400934,
 220054402,
 120851,
 220528639,
 220334510,
 -1,
 -62171,
 220441882,
 120868,
 -1,
 220475671,
 120869,
 220663081,
 220372047,
 -1,
 -62168,
 220618960,
 121018,
 -1,
 220667056,
 120841,
 220859691,
 220604142,
 120838,
 -1,
 220792344,
 120861,
 -1,
 220804146,
 120842,
 221056323,
 214874313,
 121077,
 221183999,
 220987392,
 -1,
 221187381,
 221102802,
 -1,
 221252914,
 221164677,
 -1,
 -62159,
 221237324,
 121086,
 -1,
 221272392,
 121088,
 -62157,
 221213641,
 120979,
 -62156,
 221405045,
 120840,
 -1,
 221465552,
 121089,
 221646138,
 221128520,
 -1,
 221711672,
 221601664,
 121083,
 -1,
 221645107,
 120876,
 -62151,
 221684917,
 121085,
 -1,
 221805543,
 121084,
 221973822,
 221621535,
 -1,
 -62148,
 221919034,
 121079,
 -62147,
 221982999,
 121080,
 -1,
 222045934,
 121081,
 222235969,
 221941929,
 -1,
 -62144,
 222215906,
 121087,
 -1,
 222252048,
 121090,
 -62142,
 222188759,
 121078,
 -1,
 222382896,
 121082,
 222563673,
 221019079,
 -1,
 222629201,
 222542031,
 -1,
 222694730,
 222571161,
 -1,
 222760265,
 222651389,
 -1,
 -62136,
 222741330,
 120888,
 -1,
 222779025,
 120889,
 -1,
 222741602,
 120886,
 223022415,
 222633910,
 -1,
 223087950,
 222990416,
 -1,
 -62131,
 223069010,
 120896,
 -1,
 223097571,
 120897,
 -1,
 223043557,
 120898,
 -62128,
 222983098,
 121035,
 -1,
 223303593,
 120880,
 223481171,
 222610258,
 121030,
 -1,
 223414744,
 121033,
 223612246,
 223452239,
 -1,
 -62123,
 223568080,
 121037,
 -1,
 223616176,
 121032,
 -62121,
 223572922,
 121036,
 -62120,
 223754934,
 121028,
 -1,
 223815411,
 120860,
 224005480,
 222524353,
 -1,
 224071008,
 223951542,
 120974,
 224198655,
 224002048,
 -1,
 224202079,
 224109932,
 -1,
 -62114,
 224178806,
 120975,
 -1,
 224212093,
 120976,
 -1,
 224169568,
 120977,
 224464227,
 224048261,
 -1,
 -62110,
 224431912,
 120985,
 -1,
 224483793,
 120986,
 224660837,
 224419688,
 120992,
 -1,
 224594343,
 120988,
 -62106,
 224641874,
 120978,
 -62105,
 224763260,
 120983,
 -1,
 224798446,
 120984,
 224988531,
 223978649,
 -1,
 225054061,
 224951232,
 121012,
 225181695,
 224985088,
 -1,
 -62100,
 225090955,
 121014,
 -1,
 225128727,
 121013,
 -62098,
 225035090,
 121006,
 -62097,
 225294537,
 121016,
 -62096,
 225353084,
 121007,
 -62095,
 225407930,
 121008,
 -62094,
 225468264,
 121015,
 -1,
 225524406,
 121003,
 -62092,
 224941271,
 121092,
 -1,
 225659892,
 120906,
 225902591,
 214723956,
 120922,
 225968127,
 225771520,
 -1,
 225971591,
 225855438,
 -1,
 226037121,
 225928678,
 120908,
 226164735,
 225968128,
 -1,
 226168190,
 226055825,
 120919,
 226295807,
 226099200,
 -1,
 -62083,
 226212068,
 120920,
 -1,
 226263860,
 120921,
 -62081,
 226146518,
 120914,
 -62080,
 226380660,
 120910,
 -1,
 226436846,
 120912,
 226689023,
 226004879,
 120900,
 226754559,
 226557952,
 -1,
 226758021,
 226636055,
 120903,
 -1,
 226691329,
 120904,
 -62074,
 226711185,
 120902,
 -1,
 226830062,
 120901,
 227020173,
 225947843,
 -1,
 227085707,
 226962594,
 120930,
 227213311,
 227019224,
 120931,
 -1,
 227082614,
 120932,
 -62068,
 227046330,
 120933,
 -1,
 227237844,
 120929,
 227413396,
 226972887,
 120924,
 227540991,
 227344384,
 -1,
 227544467,
 227428847,
 120909,
 227672063,
 227475456,
 -1,
 -62062,
 227560308,
 120911,
 -1,
 227616494,
 120913,
 -1,
 227522788,
 120926,
 227872152,
 227391695,
 -1,
 -62058,
 227847450,
 120925,
 -62057,
 227887920,
 120928,
 -1,
 227944174,
 120927,
 -1,
 227813234,
 120923,
 228199893,
 214641305,
 -1,
 228265396,
 228179739,
 -1,
 228330927,
 228234022,
 120941,
 228458495,
 228261888,
 -1,
 228461987,
 228363188,
 120940,
 228589567,
 228392960,
 -1,
 228593058,
 228505807,
 -1,
 -62047,
 228568346,
 120942,
 -1,
 228608816,
 120946,
 -1,
 228557620,
 120944,
 228855208,
 228417384,
 120834,
 228982783,
 228786176,
 -1,
 228986279,
 228899017,
 121068,
 -1,
 228918578,
 121069,
 -1,
 228959413,
 121024,
 229182891,
 228833487,
 -1,
 -62038,
 229158170,
 120943,
 -1,
 229198640,
 120947,
 229379501,
 229132783,
 120915,
 -1,
 229311794,
 120916,
 -62034,
 229344052,
 120945,
 -1,
 229473267,
 121040,
 229703679,
 228304409,
 120949,
 229769215,
 229572608,
 -1,
 -62030,
 229673908,
 120948,
 -62029,
 229735459,
 121039,
 -1,
 229793696,
 121020,
 229969355,
 228221919,
 120950,
 230096895,
 229900288,
 -1,
 230100419,
 229990248,
 120833,
 230227967,
 230031360,
 -1,
 230231488,
 230128576,
 120847,
 230359039,
 230162432,
 -1,
 230362557,
 230240978,
 -1,
 -62020,
 230309580,
 120859,
 -1,
 230360115,
 121002,
 -62018,
 230340809,
 120863,
 -62017,
 230532244,
 120967,
 -1,
 230585274,
 120997,
 -62015,
 230204597,
 121019,
 -62014,
 230708868,
 120845,
 -1,
 230762222,
 120839,
 230952391,
 230063047,
 -1,
 231017926,
 230925493,
 121038,
 -1,
 230949238,
 121045,
 -1,
 230998866,
 121031,
 231214538,
 230912961,
 -1,
 -62007,
 231195474,
 120980,
 -1,
 231235432,
 120993,
 -1,
 231187637,
 121009,
 231538687,
 229928414,
 120934,
 231604223,
 231407616,
 -1,
 231607760,
 231520463,
 -1,
 -62001,
 231583002,
 120935,
 -1,
 231623472,
 120937,
 231804370,
 231570438,
 121046,
 -1,
 231737546,
 121047,
 -61997,
 231768884,
 120936,
 -61996,
 231890869,
 121065,
 -1,
 231951325,
 120905,
 232132109,
 228151800,
 -1,
 232197631,
 232087858,
 120957,
 232325119,
 232128512,
 -1,
 232328679,
 232218472,
 120836,
 232456191,
 232259584,
 -1,
 232459745,
 232372425,
 121072,
 232587263,
 232390656,
 -1,
 232590815,
 232499365,
 -1,
 -61986,
 232552491,
 121073,
 -1,
 232610827,
 121053,
 -61984,
 232557492,
 121070,
 -1,
 232746221,
 121071,
 232918501,
 232422343,
 -1,
 232984036,
 232891540,
 120968,
 -1,
 232915475,
 120973,
 -1,
 232944570,
 120998,
 -61978,
 232891573,
 121025,
 -1,
 233133713,
 121051,
 233311725,
 232295348,
 120955,
 233439231,
 233242624,
 -1,
 233442796,
 233355471,
 -1,
 -61973,
 233418010,
 120959,
 -1,
 233458480,
 120956,
 -1,
 233407284,
 120961,
 233704946,
 233272250,
 120970,
 233832447,
 233635840,
 -1,
 233836017,
 233725800,
 120994,
 -1,
 233769383,
 120989,
 -1,
 233814217,
 120987,
 234032630,
 233683151,
 -1,
 234098165,
 234007834,
 120960,
 -1,
 234031822,
 120963,
 -1,
 234039134,
 120964,
 234294776,
 234005652,
 120999,
 -1,
 234226340,
 121004,
 234425850,
 234257344,
 121029,
 -1,
 234358904,
 121041,
 234556925,
 234375118,
 -1,
 -61956,
 234524571,
 120907,
 -1,
 234579449,
 120917,
 -61954,
 234532529,
 120958,
 -1,
 234718004,
 120962,
 234946559,
 232164124,
 120939,
 235012095,
 234815488,
 -1,
 235015687,
 234912711,
 -1,
 235081222,
 234988737,
 121050,
 235208703,
 235012096,
 -1,
 -61947,
 235114553,
 121048,
 -1,
 235167432,
 121049,
 -1,
 235059401,
 121034,
 235408907,
 234971021,
 -1,
 -61943,
 235389644,
 121023,
 -61942,
 235442233,
 121021,
 -1,
 235495112,
 121022,
 -61940,
 235382022,
 121017,
 -1,
 235615294,
 120938,
 235802150,
 232071081,
 120965,
 235929599,
 235732992,
 -1,
 235933210,
 235822952,
 120837,
 236060671,
 235864064,
 -1,
 236064277,
 235976905,
 121076,
 236191743,
 235995136,
 -1,
 -61932,
 236097593,
 121074,
 -1,
 236150472,
 121075,
 236326423,
 236037301,
 121027,
 -1,
 236258643,
 121026,
 236519423,
 236288967,
 -1,
 -61927,
 236430484,
 120969,
 -1,
 236483514,
 121000,
 236654111,
 235893697,
 -1,
 236719646,
 236609384,
 120995,
 236847103,
 236652997,
 120991,
 -1,
 236717395,
 120990,
 -1,
 236700498,
 120982,
 236981795,
 236616691,
 121044,
 237109247,
 236912640,
 -1,
 -61918,
 237015097,
 121042,
 -1,
 237067976,
 121043,
 237305855,
 236954777,
 -1,
 -61915,
 237204410,
 121011,
 -1,
 237255393,
 121005,
 237502463,
 235769998,
 120951,
 237567999,
 237371392,
 -1,
 237571627,
 237484239,
 -1,
 -61910,
 237546778,
 120952,
 -1,
 237587248,
 120954,
 -61908,
 237544629,
 121010,
 -61907,
 237732660,
 120953,
 -61906,
 237794249,
 120981,
 -61905,
 237854568,
 120835,
 -1,
 237914607,
 120918,
 -1,
 214590403,
 121451,
 238223359,
 214515133,
 121343,
 238288895,
 238092288,
 -1,
 238292541,
 238190079,
 -1,
 238358076,
 238226923,
 -1,
 238423609,
 238340968,
 -1,
 -61897,
 238401940,
 121346,
 -61896,
 238465654,
 121345,
 -1,
 238498928,
 121348,
 238747647,
 238373499,
 -1,
 -61893,
 238662262,
 121347,
 -1,
 238695536,
 121349,
 -1,
 238289419,
 121350,
 -1,
 238265483,
 121344,
 239013752,
 214465864,
 -1,
 239079250,
 238995430,
 -1,
 239144633,
 239061864,
 -1,
 239210084,
 239086233,
 -1,
 239275610,
 239191495,
 -1,
 239341143,
 239206400,
 -1,
 239406669,
 239292920,
 -1,
 239472202,
 239345109,
 -1,
 239537736,
 239430893,
 121230,
 -1,
 239513989,
 121231,
 -61879,
 239513265,
 121228,
 -1,
 239630936,
 121229,
 239861759,
 239429058,
 -1,
 -61876,
 239750279,
 121254,
 -1,
 239807903,
 121261,
 239996498,
 239377288,
 -1,
 240062032,
 239955181,
 121226,
 -1,
 240038277,
 121227,
 -61871,
 240037553,
 121224,
 -1,
 240155224,
 121225,
 240386047,
 239974227,
 -1,
 240389718,
 240296022,
 -1,
 -61867,
 240365233,
 121232,
 -1,
 240417368,
 121233,
 -1,
 240337357,
 121247,
 240713727,
 239285474,
 -1,
 -61863,
 240627377,
 121248,
 -1,
 240679512,
 121249,
 240848479,
 239242633,
 -1,
 -61860,
 240823985,
 121147,
 -61859,
 240887587,
 121150,
 -61858,
 240941656,
 121148,
 -1,
 241003757,
 121149,
 241176163,
 240800965,
 -1,
 -61855,
 241151665,
 121151,
 -61854,
 241203800,
 121152,
 -1,
 241265901,
 121153,
 -1,
 241149667,
 121139,
 241503865,
 239192846,
 -1,
 241569398,
 241443993,
 -1,
 241634927,
 241513590,
 -1,
 241700459,
 241614012,
 -1,
 -61847,
 241675953,
 121244,
 -61846,
 241728088,
 121245,
 -1,
 241790189,
 121246,
 242024447,
 241645999,
 -1,
 -61843,
 241938097,
 121241,
 -61842,
 241990232,
 121242,
 -1,
 242052333,
 121243,
 242224755,
 241579853,
 -1,
 -61839,
 242200241,
 121268,
 -61838,
 242252376,
 121269,
 -1,
 242314477,
 121270,
 242548735,
 242177760,
 -1,
 -61835,
 242437255,
 121257,
 -1,
 242494879,
 121264,
 242745343,
 241542558,
 -1,
 -61832,
 242658774,
 121325,
 -1,
 242694568,
 121326,
 242880130,
 241477797,
 -1,
 242945665,
 242835790,
 -1,
 243011200,
 242922111,
 -1,
 243076734,
 242969837,
 121132,
 -1,
 243052933,
 121133,
 -61825,
 243052209,
 121130,
 -1,
 243169880,
 121131,
 -1,
 242995548,
 121134,
 -1,
 242897516,
 121253,
 243469962,
 242840863,
 -1,
 243535493,
 243445425,
 121237,
 -1,
 243466908,
 121240,
 243666568,
 243488480,
 -1,
 -61817,
 243616903,
 121256,
 -1,
 243674527,
 121263,
 -61815,
 243628632,
 121238,
 -1,
 243821805,
 121239,
 243994259,
 243410212,
 -1,
 244059791,
 243962590,
 -1,
 -61811,
 244035249,
 121154,
 -61810,
 244087384,
 121155,
 -1,
 244149485,
 121156,
 244383743,
 244007455,
 -1,
 -61807,
 244297393,
 121144,
 -61806,
 244349528,
 121145,
 -1,
 244411629,
 121146,
 244584090,
 243947990,
 -1,
 244649623,
 244537056,
 -1,
 -61802,
 244599943,
 121255,
 -1,
 244657567,
 121262,
 -61800,
 244625073,
 121234,
 -61799,
 244808280,
 121235,
 -1,
 244870381,
 121236,
 245042847,
 244563132,
 -1,
 245108381,
 244981304,
 121142,
 -1,
 245042643,
 121143,
 -61794,
 245092700,
 121141,
 -1,
 245215881,
 121140,
 245370532,
 244988335,
 -1,
 245436066,
 245308984,
 121137,
 -1,
 245370323,
 121138,
 -61789,
 245420380,
 121136,
 -1,
 245543542,
 121135,
 245698219,
 245309786,
 -1,
 245763752,
 245673655,
 -1,
 -61785,
 245738966,
 121315,
 -1,
 245774760,
 121317,
 246022143,
 245725791,
 -1,
 -61782,
 245935574,
 121316,
 -1,
 245971368,
 121318,
 246156975,
 245683692,
 -1,
 -61779,
 246132401,
 121157,
 -61778,
 246184536,
 121158,
 -1,
 246246637,
 121159,
 246419123,
 246125861,
 -1,
 -61775,
 246394545,
 121160,
 -61774,
 246446680,
 121161,
 -1,
 246508781,
 121162,
 246681272,
 246368634,
 -1,
 246746807,
 246637598,
 -1,
 -61770,
 246722006,
 121329,
 -1,
 246757800,
 121330,
 -1,
 246713068,
 121128,
 -1,
 246638398,
 121448,
 247074609,
 239094395,
 -1,
 247140046,
 247016089,
 -1,
 247205576,
 247121356,
 -1,
 247271107,
 247158496,
 -1,
 247336640,
 247220852,
 -1,
 -61761,
 247312049,
 121286,
 -1,
 247360749,
 121287,
 247595007,
 247278741,
 -1,
 -61758,
 247508657,
 121271,
 -1,
 247557357,
 121272,
 247729861,
 247229677,
 121303,
 -1,
 247705989,
 121304,
 -61754,
 247705265,
 121301,
 -61753,
 247822936,
 121302,
 -1,
 247869556,
 121305,
 248057548,
 247172489,
 -1,
 -61750,
 248032945,
 121204,
 -61749,
 248085080,
 121205,
 -1,
 248147181,
 121206,
 -61747,
 248030947,
 121198,
 -1,
 248272064,
 121207,
 248450782,
 247122702,
 -1,
 248516315,
 248390809,
 -1,
 248581847,
 248469216,
 -1,
 248647380,
 248531572,
 -1,
 -61741,
 248622769,
 121296,
 -1,
 248671469,
 121297,
 248905727,
 248589461,
 -1,
 -61738,
 248819377,
 121281,
 -1,
 248868077,
 121282,
 249040602,
 248555685,
 -1,
 -61735,
 249003958,
 121308,
 -1,
 249067563,
 121309,
 -1,
 248999149,
 121310,
 249364479,
 248489393,
 -1,
 -61731,
 249277910,
 121327,
 -1,
 249313704,
 121328,
 249499375,
 248411423,
 -1,
 249564910,
 249452256,
 -1,
 249630439,
 249514612,
 -1,
 249695972,
 249605815,
 -1,
 -61725,
 249671126,
 121292,
 -1,
 249706920,
 121294,
 249954303,
 249654515,
 -1,
 -61722,
 249867734,
 121293,
 -1,
 249903528,
 121295,
 250150911,
 249572501,
 -1,
 250154731,
 250064567,
 -1,
 -61718,
 250129878,
 121277,
 -1,
 250165672,
 121279,
 250413055,
 250113267,
 -1,
 -61715,
 250326486,
 121278,
 -1,
 250362280,
 121280,
 -1,
 249540273,
 121307,
 250613503,
 249453014,
 -1,
 250679038,
 250566368,
 -1,
 250744567,
 250628724,
 -1,
 250810101,
 250723516,
 -1,
 -61708,
 250785658,
 121290,
 -1,
 250834236,
 121291,
 -61706,
 250785576,
 121288,
 -1,
 250965242,
 121289,
 251199487,
 250686613,
 -1,
 251203323,
 251113143,
 -1,
 -61702,
 251182261,
 121275,
 -1,
 251214248,
 121273,
 251461631,
 251161843,
 -1,
 -61699,
 251378869,
 121276,
 -1,
 251410856,
 121274,
 -1,
 250654385,
 121306,
 251662088,
 250587301,
 -1,
 251727623,
 251617614,
 -1,
 251793158,
 251703935,
 -1,
 251858692,
 251751661,
 121191,
 -1,
 251834757,
 121192,
 -61691,
 251834033,
 121189,
 -1,
 251951704,
 121190,
 -1,
 251777372,
 121193,
 -1,
 251679347,
 121314,
 252251922,
 251601254,
 -1,
 252317452,
 252227255,
 -1,
 -61685,
 252292566,
 121319,
 -1,
 252328360,
 121322,
 252514063,
 252279391,
 -1,
 -61682,
 252489174,
 121320,
 -1,
 252524968,
 121323,
 252772351,
 252472563,
 -1,
 -61679,
 252685782,
 121321,
 -1,
 252721576,
 121324,
 252907288,
 252230844,
 -1,
 252972822,
 252845636,
 -1,
 -61675,
 252957020,
 121202,
 -1,
 253001215,
 121201,
 -61673,
 252957020,
 121200,
 -1,
 253145737,
 121199,
 253300509,
 252852655,
 -1,
 253366043,
 253238840,
 121196,
 -1,
 253300179,
 121197,
 -61668,
 253350236,
 121195,
 -1,
 253473398,
 121194,
 253628195,
 253240612,
 -1,
 253693730,
 253596382,
 -1,
 -61664,
 253669041,
 121208,
 -61663,
 253721176,
 121209,
 -1,
 253783277,
 121210,
 -1,
 253641243,
 121203,
 254021415,
 253613548,
 -1,
 -61659,
 253996721,
 121211,
 -61658,
 254048856,
 121212,
 -1,
 254110957,
 121213,
 254283563,
 253990181,
 -1,
 -61655,
 254258865,
 121214,
 -61654,
 254311000,
 121215,
 -1,
 254373101,
 121216,
 254545712,
 254232954,
 -1,
 254611247,
 254501926,
 -1,
 -61650,
 254586326,
 121331,
 -1,
 254622120,
 121332,
 -1,
 254577388,
 121129,
 -1,
 254502718,
 121449,
 254938951,
 247019331,
 -1,
 255004477,
 254879560,
 -1,
 255070008,
 254983029,
 -1,
 255135542,
 255028461,
 121187,
 -1,
 255111557,
 121188,
 -61641,
 255110833,
 121185,
 -1,
 255228504,
 121186,
 255459327,
 255010001,
 -1,
 255463227,
 255356141,
 121183,
 -1,
 255439237,
 121184,
 -61636,
 255438513,
 121181,
 -1,
 255556184,
 121182,
 255725378,
 254983029,
 -1,
 255790912,
 255683821,
 121179,
 -1,
 255766917,
 121180,
 -61631,
 255766193,
 121177,
 -1,
 255883864,
 121178,
 256114687,
 255665361,
 -1,
 256118597,
 256011501,
 121175,
 -1,
 256094597,
 121176,
 -61626,
 256093873,
 121173,
 -1,
 256211544,
 121174,
 256442367,
 254891658,
 -1,
 256446288,
 256361301,
 -1,
 256511823,
 256391867,
 -1,
 256577357,
 256450116,
 -1,
 -61620,
 256552625,
 121126,
 -1,
 256601325,
 121125,
 -61618,
 256552625,
 121122,
 -1,
 256732397,
 121121,
 -1,
 256486124,
 121123,
 -61615,
 256421157,
 121127,
 -1,
 256916256,
 121124,
 257163263,
 239060560,
 -1,
 257167199,
 257067961,
 -1,
 257232728,
 257138656,
 121418,
 257359871,
 257163264,
 -1,
 -61609,
 257282887,
 121420,
 -1,
 257347913,
 121419,
 257494876,
 257200270,
 121415,
 257622015,
 257425408,
 -1,
 -61605,
 257545031,
 121417,
 -1,
 257610057,
 121416,
 -61603,
 257478985,
 121414,
 -61602,
 257706800,
 121413,
 -1,
 257764949,
 121412,
 257953637,
 257108633,
 -1,
 258019172,
 257914153,
 -1,
 -61598,
 257982808,
 121403,
 -61597,
 258034480,
 121404,
 -1,
 258093462,
 121405,
 -1,
 257985936,
 121430,
 258346857,
 257930976,
 121424,
 258473983,
 258277376,
 -1,
 -61592,
 258388904,
 121426,
 -1,
 258427696,
 121425,
 258609005,
 258322357,
 121406,
 258736127,
 258539520,
 -1,
 -61588,
 258658633,
 121407,
 -1,
 258706356,
 121408,
 258871153,
 258566809,
 121421,
 258998271,
 258801664,
 -1,
 -61584,
 258920777,
 121423,
 -1,
 258951984,
 121422,
 259133301,
 258821266,
 121409,
 259260415,
 259063808,
 -1,
 -61580,
 259182921,
 121410,
 -1,
 259230644,
 121411,
 259457023,
 259117394,
 -1,
 -61577,
 259370454,
 121431,
 -1,
 259406248,
 121432,
 259592119,
 238990469,
 -1,
 259657620,
 259563164,
 -1,
 259723145,
 259640168,
 -1,
 259788676,
 259696428,
 -1,
 259854208,
 259771240,
 -1,
 -61570,
 259829206,
 121163,
 -61569,
 259865000,
 121164,
 -1,
 259923512,
 121165,
 260177919,
 259803771,
 -1,
 -61566,
 260091350,
 121166,
 -61565,
 260127144,
 121167,
 -1,
 260185656,
 121168,
 260378504,
 259727753,
 -1,
 -61562,
 260357301,
 121172,
 -61561,
 260419030,
 121170,
 -1,
 260454824,
 121171,
 -1,
 260352897,
 121169,
 260767743,
 259672699,
 -1,
 260771731,
 260679468,
 -1,
 260837263,
 260754280,
 -1,
 -61555,
 260812246,
 121220,
 -61554,
 260848040,
 121221,
 -1,
 260906552,
 121222,
 261160959,
 260786811,
 -1,
 -61551,
 261074390,
 121217,
 -61550,
 261110184,
 121218,
 -1,
 261168696,
 121219,
 -1,
 260746113,
 121223,
 261427113,
 259622334,
 -1,
 261492640,
 261390868,
 -1,
 261558169,
 261470763,
 -1,
 -61544,
 261536603,
 121436,
 -1,
 261564241,
 121435,
 261754780,
 261500073,
 -1,
 -61541,
 261730841,
 121439,
 -1,
 261775865,
 121440,
 -61539,
 261730854,
 121433,
 -61538,
 261914120,
 121438,
 -61537,
 261976646,
 121434,
 -1,
 262038022,
 121437,
 262213540,
 261472519,
 -1,
 -61534,
 262188502,
 121093,
 -61533,
 262241943,
 121094,
 -1,
 262285120,
 121095,
 262537215,
 262186940,
 -1,
 262541224,
 262458216,
 -1,
 -61529,
 262517403,
 121458,
 -1,
 262550660,
 121459,
 -1,
 262490776,
 121460,
 262864895,
 261373102,
 -1,
 262868915,
 262751503,
 121441,
 262995967,
 262799360,
 -1,
 262999985,
 262900025,
 -1,
 263065519,
 262978274,
 121443,
 -1,
 262997165,
 121444,
 263258111,
 263025543,
 121445,
 -1,
 263128237,
 121446,
 -61518,
 262962687,
 121442,
 -1,
 263268372,
 121447,
 263520255,
 262833174,
 -1,
 -61515,
 263420864,
 121390,
 -61514,
 263484776,
 121391,
 -1,
 263542245,
 121389,
 263720938,
 259562575,
 -1,
 263786470,
 263687768,
 -1,
 263851989,
 263720427,
 -1,
 263917512,
 263834472,
 -1,
 263983039,
 263892438,
 121250,
 264110079,
 263914317,
 -1,
 -61506,
 263998599,
 121258,
 -1,
 264056223,
 121265,
 264245187,
 263928232,
 121251,
 264372223,
 264176461,
 -1,
 -61502,
 264260743,
 121259,
 -1,
 264318367,
 121266,
 264568831,
 264183343,
 -1,
 264572871,
 264462514,
 -1,
 -61498,
 264522887,
 121260,
 -1,
 264580511,
 121267,
 -1,
 264518830,
 121252,
 264896511,
 263867003,
 -1,
 264900557,
 264809942,
 121311,
 265027583,
 264831821,
 -1,
 -61492,
 264915566,
 121298,
 -1,
 264973453,
 121283,
 265162705,
 264845736,
 121312,
 265289727,
 265093965,
 -1,
 -61488,
 265177710,
 121299,
 -1,
 265235597,
 121284,
 265486335,
 265100856,
 121313,
 265551871,
 265356109,
 -1,
 -61484,
 265439854,
 121300,
 -1,
 265497741,
 121285,
 265748479,
 263783586,
 -1,
 265752542,
 265621595,
 -1,
 -61480,
 265688462,
 121519,
 -61479,
 265753753,
 121518,
 -61478,
 265819077,
 121517,
 -61477,
 265884327,
 121516,
 -61476,
 265949570,
 121515,
 -61475,
 266014811,
 121514,
 -1,
 266080082,
 121513,
 -61473,
 265689071,
 121512,
 -61472,
 266213182,
 121511,
 -61471,
 266278494,
 121510,
 -61470,
 266343822,
 121509,
 -61469,
 266409113,
 121508,
 -61468,
 266474437,
 121507,
 -61467,
 266539687,
 121506,
 -1,
 266604930,
 121505,
 266862591,
 263766021,
 -1,
 -61464,
 266776022,
 121105,
 -61463,
 266829463,
 121106,
 -1,
 266872640,
 121107,
 267063316,
 263666862,
 -1,
 267128850,
 267047760,
 -1,
 267194363,
 267079230,
 -1,
 267259893,
 267176808,
 -1,
 267325426,
 267235958,
 121377,
 267452415,
 267255808,
 -1,
 -61455,
 267336104,
 121378,
 -1,
 267394616,
 121379,
 267649023,
 267266713,
 -1,
 -61452,
 267568594,
 121383,
 -1,
 267609147,
 121385,
 267845631,
 267209339,
 -1,
 267849722,
 267760246,
 121380,
 267976703,
 267780096,
 -1,
 -61447,
 267860392,
 121381,
 -1,
 267918904,
 121382,
 -1,
 267793533,
 121384,
 268177413,
 267167911,
 -1,
 268242943,
 268160504,
 -1,
 -61442,
 268206745,
 121372,
 -1,
 268240178,
 121370,
 268439554,
 268194450,
 -1,
 -61439,
 268405684,
 121369,
 -1,
 268447682,
 121371,
 -61437,
 268415256,
 121365,
 -61436,
 268602292,
 121364,
 -1,
 268644290,
 121366,
 268832777,
 268135767,
 -1,
 -61433,
 268813138,
 121374,
 -61432,
 268847818,
 121376,
 -1,
 268909238,
 121375,
 269094925,
 268773878,
 -1,
 -61429,
 269075282,
 121354,
 -61428,
 269123928,
 121355,
 -1,
 269171382,
 121356,
 269418495,
 269025280,
 -1,
 269422609,
 269297818,
 -1,
 -61424,
 269397462,
 121367,
 -1,
 269450903,
 121368,
 -1,
 269405759,
 121373,
 -61421,
 267112919,
 121452,
 -1,
 269623852,
 121392,
 269815857,
 267021231,
 -1,
 269881381,
 269769283,
 -1,
 269946912,
 269842861,
 -1,
 270012447,
 269906253,
 -1,
 -61415,
 269948510,
 121469,
 -61414,
 270013838,
 121468,
 -61413,
 270079129,
 121467,
 -61412,
 270144453,
 121466,
 -61411,
 270209703,
 121465,
 -61410,
 270274946,
 121464,
 -1,
 270340187,
 121463,
 -1,
 269955176,
 121462,
 270663679,
 269914918,
 -1,
 270667812,
 270532608,
 -1,
 -61405,
 270648468,
 121429,
 -1,
 270693905,
 121428,
 -1,
 270641400,
 121427,
 270991359,
 269846095,
 -1,
 270995502,
 270860288,
 -1,
 271061034,
 270947390,
 -1,
 -61399,
 271015208,
 121473,
 -1,
 271063767,
 121476,
 -61397,
 271044093,
 121474,
 -61396,
 271235892,
 121477,
 -61395,
 271282972,
 121478,
 -1,
 271333009,
 121475,
 271581183,
 270929387,
 -1,
 -61392,
 271502223,
 121471,
 -1,
 271534727,
 121472,
 271716430,
 269764558,
 -1,
 271781949,
 271674287,
 -1,
 271847484,
 271735717,
 -1,
 271913017,
 271820965,
 -1,
 271978552,
 271874096,
 -1,
 -61385,
 271953366,
 121116,
 -1,
 272006807,
 121118,
 -1,
 271926127,
 121119,
 272302079,
 271871219,
 -1,
 -61381,
 272215510,
 121115,
 -1,
 272268951,
 121117,
 -1,
 271813458,
 121456,
 272502853,
 271735363,
 -1,
 272568388,
 272462832,
 -1,
 -61376,
 272504206,
 121503,
 -61375,
 272569497,
 121502,
 -61374,
 272634821,
 121501,
 -61373,
 272700071,
 121500,
 -1,
 272765314,
 121499,
 -1,
 272531952,
 121470,
 273027145,
 272469283,
 -1,
 -61369,
 273011017,
 121363,
 -61368,
 273056088,
 121361,
 -1,
 273101206,
 121362,
 273289293,
 272964139,
 -1,
 273354828,
 273269662,
 121352,
 -1,
 273287668,
 121353,
 -1,
 273304391,
 121351,
 -1,
 273269250,
 121480,
 273616998,
 271689893,
 -1,
 273682521,
 273587168,
 -1,
 273748053,
 273655973,
 -1,
 273813588,
 273709104,
 -1,
 -61357,
 273788374,
 121111,
 -1,
 273841815,
 121113,
 -1,
 273761135,
 121114,
 274075736,
 273706227,
 -1,
 -61353,
 274050518,
 121110,
 -1,
 274103959,
 121112,
 -1,
 274025046,
 121120,
 274337885,
 273661090,
 -1,
 -61349,
 274312662,
 121099,
 -61348,
 274366103,
 121100,
 -1,
 274409280,
 121101,
 274600034,
 274290839,
 -1,
 274665569,
 274552480,
 -1,
 -61344,
 274641049,
 121453,
 -1,
 274700466,
 121454,
 -1,
 274643353,
 121457,
 274927717,
 274580847,
 -1,
 -61340,
 274904177,
 121108,
 -1,
 274933568,
 121109,
 -1,
 274874723,
 121481,
 275189882,
 273560760,
 -1,
 275255412,
 275174472,
 -1,
 275320940,
 275228837,
 -1,
 275386475,
 275275452,
 121339,
 -1,
 275316790,
 121340,
 -1,
 275346792,
 121336,
 275583087,
 275259908,
 -1,
 -61330,
 275558065,
 121333,
 -1,
 275606765,
 121334,
 -61328,
 275560160,
 121337,
 -61327,
 275751065,
 121338,
 -61326,
 275796148,
 121342,
 -61325,
 275859565,
 121335,
 -1,
 275924640,
 121341,
 276168703,
 275226445,
 -1,
 276172920,
 276070752,
 -1,
 -61321,
 276153170,
 121360,
 -1,
 276183734,
 121357,
 -61319,
 276153235,
 121359,
 -1,
 276314879,
 121358,
 276500610,
 275152698,
 -1,
 276566145,
 276467173,
 -1,
 276631679,
 276548366,
 -1,
 -61314,
 276604209,
 121395,
 -1,
 276651293,
 121396,
 -61312,
 276595032,
 121393,
 -1,
 276771222,
 121394,
 -1,
 276512437,
 121450,
 277024906,
 276441753,
 -1,
 277090439,
 276976848,
 -1,
 -61307,
 277066664,
 121388,
 -61306,
 277125632,
 121386,
 -1,
 277184856,
 121387,
 277413887,
 277054910,
 -1,
 -61303,
 277314838,
 121479,
 -1,
 277378239,
 121482,
 277549202,
 276965786,
 -1,
 277614735,
 277530104,
 -1,
 -61299,
 277589462,
 121102,
 -61298,
 277642903,
 121103,
 -1,
 277686080,
 121104,
 277938175,
 277560938,
 -1,
 -61295,
 277832043,
 121401,
 -1,
 277890812,
 121402,
 278073497,
 277486754,
 -1,
 278139030,
 278049699,
 -1,
 -61291,
 278094015,
 121398,
 -1,
 278137062,
 121400,
 278396927,
 278079649,
 -1,
 -61288,
 278290659,
 121397,
 -1,
 278333670,
 121399,
 278532253,
 278024440,
 -1,
 -61285,
 278506966,
 121096,
 -61284,
 278560407,
 121097,
 -1,
 278603584,
 121098,
 -61282,
 278514547,
 121455,
 -61281,
 278774897,
 121461,
 -1,
 278828198,
 121483,
 -1,
 214369572,
 129304,
 279056681,
 214316216,
 -1,
 279122206,
 279000829,
 -1,
 279187686,
 279081342,
 -1,
 279253166,
 279164037,
 -1,
 279318695,
 279236733,
 71129,
 -1,
 279272003,
 71130,
 279449770,
 279295109,
 -1,
 -61271,
 279400974,
 71065,
 -1,
 279451814,
 71064,
 279646381,
 279400952,
 -1,
 -61268,
 279617599,
 71128,
 -1,
 279648422,
 71070,
 -1,
 279582886,
 71069,
 279908533,
 279234205,
 -1,
 279974068,
 279873086,
 -1,
 280039602,
 279944271,
 71046,
 -1,
 280009807,
 71047,
 280231935,
 279997359,
 71048,
 -1,
 280128431,
 71049,
 -1,
 279910566,
 71082,
 280367290,
 279845030,
 71040,
 -61257,
 280346395,
 71053,
 -61256,
 280393324,
 71131,
 -61255,
 280451651,
 71051,
 -1,
 280500390,
 71041,
 280694975,
 280330042,
 -1,
 -61252,
 280679131,
 71063,
 -61251,
 280723344,
 71068,
 -61250,
 280776035,
 71058,
 -1,
 280828070,
 71073,
 281022661,
 280638648,
 -1,
 281088195,
 280966328,
 -1,
 -61246,
 281039374,
 71067,
 -1,
 281090214,
 71066,
 -61244,
 281039374,
 71072,
 -1,
 281221286,
 71071,
 281415881,
 280996005,
 -1,
 -61241,
 281389360,
 71084,
 -61240,
 281432590,
 71083,
 -1,
 281483430,
 71085,
 281678027,
 281394971,
 71044,
 -1,
 281657115,
 71045,
 281809102,
 281645862,
 -1,
 -61235,
 281760270,
 71075,
 -1,
 281811110,
 71074,
 282005713,
 281765917,
 -1,
 -61232,
 281956878,
 71055,
 -1,
 282007718,
 71054,
 282202324,
 281962230,
 -1,
 -61229,
 282153486,
 71062,
 -1,
 282204326,
 71061,
 282398934,
 282155587,
 71042,
 -1,
 282352195,
 71043,
 282530009,
 282348820,
 -1,
 -61224,
 282481166,
 71057,
 -1,
 282532006,
 71056,
 282726620,
 282471065,
 -1,
 -61221,
 282677774,
 71060,
 -1,
 282728614,
 71059,
 282923231,
 282666276,
 -1,
 -61218,
 282874382,
 71077,
 -1,
 282925222,
 71076,
 -61216,
 282907355,
 71079,
 -61215,
 283090115,
 71080,
 -61214,
 283149758,
 71052,
 -61213,
 283211618,
 71078,
 -61212,
 283274205,
 71081,
 -61211,
 283333134,
 71086,
 -1,
 283393198,
 71050,
 283578631,
 279160997,
 -1,
 283644159,
 283524270,
 -1,
 283709692,
 283587522,
 -1,
 283775226,
 283692641,
 -1,
 283840751,
 283753467,
 -1,
 283906286,
 283784803,
 -1,
 -61203,
 283885453,
 71114,
 -1,
 283916629,
 71115,
 -1,
 283875047,
 71122,
 284168435,
 283811506,
 -1,
 -61199,
 284146884,
 71118,
 -61198,
 284178961,
 71117,
 -1,
 284242586,
 71116,
 284430583,
 284110551,
 -1,
 -61195,
 284409555,
 71126,
 -61194,
 284466855,
 71125,
 -1,
 284511168,
 71127,
 -61192,
 284404421,
 71124,
 -61191,
 284662570,
 71123,
 -1,
 284703249,
 71121,
 284950527,
 283720311,
 71119,
 -1,
 284822837,
 71120,
 285081599,
 283677822,
 -1,
 -61186,
 284965022,
 71108,
 -1,
 285025746,
 71109,
 285278207,
 283598273,
 -1,
 285282563,
 285198673,
 -1,
 -61182,
 285256155,
 71102,
 -1,
 285318645,
 71103,
 -61180,
 285256978,
 71105,
 -61179,
 285443311,
 71104,
 -61178,
 285485914,
 71100,
 -1,
 285548594,
 71101,
 285741334,
 283560602,
 -1,
 285806862,
 285677734,
 -1,
 285872395,
 285767276,
 71132,
 -1,
 285851419,
 71133,
 -61172,
 285851419,
 71099,
 -61171,
 285956675,
 71097,
 -1,
 286005414,
 71087,
 286200080,
 285788641,
 71092,
 -1,
 286170191,
 71093,
 286331154,
 286179099,
 71090,
 -1,
 286310171,
 71091,
 286462228,
 286284355,
 71088,
 -1,
 286415427,
 71089,
 -61163,
 286426558,
 71098,
 -1,
 286538926,
 71096,
 286724378,
 285712590,
 -1,
 -61160,
 286659239,
 71112,
 -61159,
 286724482,
 71111,
 -1,
 286789723,
 71110,
 286986525,
 286667960,
 -1,
 -61156,
 286953211,
 71107,
 -1,
 286990137,
 71106,
 -1,
 286933555,
 71113,
 287309823,
 279070388,
 -1,
 287314212,
 287231237,
 -1,
 -61151,
 287294404,
 128414,
 -61150,
 287351553,
 128409,
 -61149,
 287403920,
 128408,
 -1,
 287456012,
 128415,
 287703039,
 287254574,
 -1,
 -61146,
 287622084,
 128416,
 -61145,
 287679233,
 128411,
 -61144,
 287731600,
 128410,
 -1,
 287783692,
 128417,
 287969638,
 279019322,
 -1,
 288035164,
 287920775,
 -1,
 288100681,
 287973572,
 -1,
 288166204,
 288064761,
 -1,
 288231729,
 288142469,
 -1,
 -61137,
 288214153,
 70123,
 -61136,
 288249524,
 70124,
 -1,
 288309642,
 70122,
 288493876,
 288204965,
 -1,
 -61133,
 288450232,
 70127,
 -1,
 288507439,
 70128,
 288690487,
 288459196,
 -1,
 -61130,
 288667659,
 70132,
 -1,
 288709084,
 70131,
 288887098,
 288638926,
 -1,
 -61127,
 288853448,
 70125,
 -1,
 288906387,
 70126,
 -61125,
 288850562,
 70130,
 -1,
 289030318,
 70129,
 289275903,
 288110490,
 -1,
 289280320,
 289191045,
 -1,
 -61121,
 289263563,
 70114,
 -1,
 289298651,
 70115,
 289476931,
 289253541,
 -1,
 -61118,
 289433207,
 70118,
 -1,
 289490414,
 70119,
 289673542,
 289425358,
 -1,
 -61115,
 289640296,
 70116,
 -1,
 289695187,
 70117,
 -61113,
 289638840,
 70113,
 -61112,
 289833563,
 70121,
 -1,
 289882222,
 70120,
 290066775,
 288060334,
 -1,
 290132301,
 290043013,
 -1,
 -61108,
 290115531,
 3560,
 -1,
 290150619,
 3561,
 290328912,
 290105509,
 -1,
 -61105,
 290285175,
 3564,
 -1,
 290342382,
 3565,
 290525523,
 290277326,
 -1,
 -61102,
 290492264,
 3562,
 -1,
 290547155,
 3563,
 -61100,
 290510206,
 3558,
 -61099,
 290687416,
 3559,
 -61098,
 290751067,
 3567,
 -1,
 290799726,
 3566,
 291045375,
 290009394,
 -1,
 291049819,
 290954319,
 -1,
 -61094,
 290997035,
 983923,
 -1,
 291052841,
 983922,
 -1,
 291033911,
 983921,
 291373055,
 287985750,
 -1,
 291377507,
 291241984,
 -1,
 291443041,
 291351631,
 -1,
 -61088,
 291426251,
 983154,
 -1,
 291461339,
 983157,
 -61086,
 291393755,
 983182,
 -1,
 291581234,
 983184,
 291831807,
 291311374,
 -1,
 -61083,
 291705511,
 983158,
 -1,
 291770754,
 983155,
 291967337,
 287953315,
 -1,
 -61080,
 291942857,
 128303,
 -1,
 292001466,
 128973,
 -1,
 291926571,
 128510,
 292229701,
 214258168,
 -1,
 292295212,
 292165798,
 -1,
 292360683,
 292265206,
 -1,
 292426157,
 292319614,
 -1,
 292491637,
 292406941,
 -1,
 292557172,
 292455998,
 -1,
 292622706,
 292527183,
 70025,
 -1,
 292592719,
 70026,
 292814847,
 292580271,
 70027,
 -1,
 292711343,
 70028,
 -1,
 292493478,
 70062,
 292950395,
 292467845,
 -1,
 293015929,
 292926597,
 -1,
 -61064,
 292966926,
 70044,
 -1,
 293017766,
 70043,
 -61062,
 292966926,
 70049,
 -1,
 293148838,
 70048,
 293343616,
 292912954,
 -1,
 -61059,
 293327579,
 70042,
 -61058,
 293371792,
 70047,
 -61057,
 293424483,
 70037,
 -1,
 293476518,
 70052,
 293671302,
 293287096,
 -1,
 293736836,
 293614776,
 -1,
 -61053,
 293687822,
 70046,
 -1,
 293738662,
 70045,
 -61051,
 293687822,
 70051,
 -1,
 293869734,
 70050,
 294064522,
 293607590,
 70019,
 -61048,
 294043419,
 70032,
 -61047,
 294083139,
 70030,
 -1,
 294131878,
 70020,
 294326670,
 294037669,
 -1,
 -61044,
 294299952,
 70064,
 -61043,
 294343182,
 70063,
 -1,
 294394022,
 70065,
 294588816,
 294305563,
 70023,
 -1,
 294567707,
 70024,
 294719891,
 294556454,
 -1,
 -61038,
 294670862,
 70054,
 -1,
 294721702,
 70053,
 294916502,
 294677423,
 -1,
 -61035,
 294874077,
 70061,
 -1,
 294918310,
 70060,
 295113113,
 294873117,
 -1,
 -61032,
 295064078,
 70034,
 -1,
 295114918,
 70033,
 295309724,
 295069430,
 -1,
 -61029,
 295260686,
 70041,
 -1,
 295311526,
 70040,
 295506334,
 295262787,
 70021,
 -1,
 295459395,
 70022,
 295637409,
 295456020,
 -1,
 -61024,
 295588366,
 70036,
 -1,
 295639206,
 70035,
 295834020,
 295578265,
 -1,
 -61021,
 295784974,
 70039,
 -1,
 295835814,
 70038,
 296030631,
 295773476,
 -1,
 -61018,
 295981582,
 70056,
 -1,
 296032422,
 70055,
 -61016,
 296014555,
 70058,
 -61015,
 296197315,
 70059,
 -61014,
 296256958,
 70031,
 -61013,
 296318818,
 70057,
 -61012,
 296374798,
 70066,
 -1,
 296434862,
 70029,
 296620479,
 292407913,
 -1,
 296686014,
 296594806,
 -1,
 296751540,
 296667598,
 -1,
 296817074,
 296721487,
 70072,
 -1,
 296787023,
 70073,
 297009151,
 296774575,
 70074,
 -1,
 296905647,
 70075,
 297079224,
 296687782,
 -1,
 -61002,
 297058075,
 70079,
 -61001,
 297097795,
 70077,
 -1,
 297146534,
 70067,
 297341370,
 297058075,
 70070,
 -1,
 297320219,
 70071,
 297472444,
 297294403,
 70068,
 -1,
 297425475,
 70069,
 -60995,
 297436606,
 70078,
 -1,
 297548974,
 70076,
 -1,
 296648077,
 70091,
 297800147,
 296593573,
 -1,
 297865676,
 297754049,
 -1,
 297931204,
 297847121,
 -1,
 -60989,
 297904603,
 70018,
 -1,
 297967093,
 70080,
 298127815,
 297867430,
 -1,
 -60986,
 298108598,
 70081,
 -1,
 298157374,
 70017,
 -60984,
 298107961,
 70083,
 -60983,
 298298642,
 70107,
 -60982,
 298353903,
 70090,
 -60981,
 298411927,
 70082,
 -1,
 298462042,
 70016,
 298652113,
 297811118,
 -1,
 298717648,
 298595278,
 -1,
 -60977,
 298652034,
 70111,
 -1,
 298717275,
 70110,
 -1,
 298685558,
 70088,
 -60974,
 298632830,
 70093,
 -1,
 298917710,
 70089,
 299110884,
 297743544,
 -1,
 299176418,
 299064746,
 -1,
 299241944,
 299152517,
 -1,
 -60969,
 299225035,
 70098,
 -1,
 299260123,
 70099,
 299438555,
 299215013,
 -1,
 -60966,
 299394679,
 70102,
 -1,
 299451886,
 70103,
 299635166,
 299386830,
 -1,
 -60963,
 299601768,
 70100,
 -1,
 299656659,
 70101,
 -60961,
 299619710,
 70096,
 -60960,
 299796920,
 70097,
 -60959,
 299860571,
 70105,
 -1,
 299909230,
 70104,
 -60957,
 299142907,
 70086,
 -1,
 300031801,
 70085,
 300224999,
 299056302,
 -1,
 -60954,
 300208728,
 70092,
 -1,
 300247252,
 70106,
 -60952,
 300189888,
 70084,
 -60951,
 300373097,
 70108,
 -60950,
 300429744,
 70109,
 -1,
 300489148,
 70087,
 300683819,
 292341405,
 -1,
 300749354,
 300636951,
 -1,
 300814839,
 300685478,
 -1,
 300880369,
 300784719,
 -1,
 -60944,
 300850851,
 66684,
 -1,
 300891310,
 66680,
 -60942,
 300862561,
 66679,
 -60941,
 301050646,
 66664,
 -60940,
 301097923,
 66682,
 -60939,
 301158904,
 66669,
 -60938,
 301223554,
 66673,
 -1,
 301283437,
 66665,
 301470206,
 300778942,
 -1,
 -60935,
 301450818,
 66668,
 -60934,
 301505615,
 66681,
 -60933,
 301568757,
 66677,
 -60932,
 301629242,
 66666,
 -60931,
 301686271,
 66678,
 -1,
 301735191,
 66676,
 301928964,
 301415598,
 -1,
 301994498,
 301865126,
 -1,
 -60927,
 301970565,
 66672,
 -1,
 302029903,
 66685,
 -60925,
 301967197,
 66683,
 -1,
 302141192,
 66663,
 302322185,
 301905029,
 -1,
 302387720,
 302273016,
 -1,
 -60921,
 302341412,
 66644,
 -1,
 302401479,
 66654,
 -1,
 302353930,
 66641,
 302649869,
 302275139,
 -1,
 -60917,
 302598094,
 66662,
 -60916,
 302656608,
 66674,
 -1,
 302718633,
 66686,
 302912016,
 302633808,
 -1,
 -60913,
 302893838,
 66687,
 -1,
 302913702,
 66648,
 303108627,
 302895051,
 -1,
 -60910,
 303073314,
 66667,
 -1,
 303119534,
 66658,
 303305238,
 303081637,
 -1,
 -60907,
 303285611,
 66646,
 -1,
 303334846,
 66645,
 303501849,
 303265548,
 -1,
 -60904,
 303455864,
 66661,
 -1,
 303513182,
 66656,
 303698460,
 303452664,
 -1,
 -60901,
 303678186,
 66649,
 -1,
 303700280,
 66659,
 -60899,
 303683095,
 66655,
 -60898,
 303876703,
 66653,
 -60897,
 303940434,
 66675,
 -60896,
 303998541,
 66670,
 -60895,
 304059710,
 66640,
 -60894,
 304121141,
 66671,
 -60893,
 304182458,
 66660,
 -60892,
 304245316,
 66642,
 -60891,
 304310268,
 66657,
 -60890,
 304369078,
 66652,
 -60889,
 304433318,
 66643,
 -60888,
 304494118,
 66651,
 -60887,
 304557592,
 66647,
 -1,
 304621487,
 66650,
 -1,
 300695268,
 127847,
 -1,
 300645955,
 9752,
 304943676,
 292259262,
 -1,
 305009209,
 304916417,
 -1,
 305074739,
 304960290,
 -1,
 -60880,
 305054723,
 113827,
 -60879,
 305099174,
 113824,
 -60878,
 305150778,
 113826,
 -1,
 305213890,
 113825,
 305402424,
 305004544,
 -1,
 305467959,
 305341732,
 -1,
 -60874,
 305414813,
 11103,
 -1,
 305470089,
 11087,
 -1,
 305442455,
 11086,
 -1,
 305343222,
 127856,
 -60870,
 304991397,
 128703,
 -60869,
 305764600,
 128717,
 -1,
 305827448,
 127776,
 305992259,
 304896579,
 -1,
 306057792,
 305941688,
 -1,
 -60865,
 306024505,
 983075,
 -1,
 306077384,
 983078,
 -60863,
 306025254,
 128674,
 -60862,
 306218185,
 9961,
 -1,
 306266340,
 128737,
 -60860,
 305975938,
 983197,
 -1,
 306397094,
 128017,
 306582284,
 292165798,
 -1,
 306647730,
 306562377,
 -1,
 306713225,
 306606462,
 -1,
 306778703,
 306693789,
 -1,
 306844238,
 306742846,
 -1,
 306909772,
 306814031,
 43144,
 -1,
 306879567,
 43145,
 307101695,
 306867119,
 43146,
 -1,
 306998191,
 43147,
 -1,
 306780326,
 43182,
 307237461,
 306754693,
 -1,
 307302995,
 307213445,
 -1,
 -60846,
 307253774,
 43165,
 -1,
 307304614,
 43164,
 -60844,
 307253774,
 43170,
 -1,
 307435686,
 43169,
 307630682,
 307199802,
 -1,
 -60841,
 307614427,
 43163,
 -60840,
 307658640,
 43168,
 -60839,
 307711331,
 43158,
 -1,
 307763366,
 43173,
 307958368,
 307573944,
 -1,
 308023902,
 307901624,
 -1,
 -60835,
 307974670,
 43167,
 -1,
 308025510,
 43166,
 -60833,
 307974670,
 43172,
 -1,
 308156582,
 43171,
 308351588,
 307894438,
 43138,
 -60830,
 308330267,
 43153,
 -60829,
 308369987,
 43150,
 -1,
 308418726,
 43139,
 308613736,
 308324517,
 -1,
 -60826,
 308586800,
 43184,
 -60825,
 308630030,
 43183,
 -1,
 308680870,
 43185,
 308875882,
 308592411,
 43142,
 -1,
 308854555,
 43143,
 309006957,
 308843302,
 -1,
 -60820,
 308957710,
 43175,
 -1,
 309008550,
 43174,
 309203567,
 308970942,
 43151,
 -1,
 309167550,
 43152,
 309334642,
 309160879,
 -1,
 -60815,
 309291997,
 43187,
 -1,
 309336230,
 43181,
 309531253,
 309291037,
 -1,
 -60812,
 309481998,
 43155,
 -1,
 309532838,
 43154,
 309727864,
 309487350,
 -1,
 -60809,
 309678606,
 43162,
 -1,
 309729446,
 43161,
 309924474,
 309680707,
 43140,
 -1,
 309877315,
 43141,
 310055549,
 309873940,
 -1,
 -60804,
 310006286,
 43157,
 -1,
 310057126,
 43156,
 310252159,
 310000814,
 43148,
 -1,
 310197422,
 43149,
 310383234,
 310192793,
 -1,
 -60799,
 310333966,
 43160,
 -1,
 310384806,
 43159,
 310579845,
 310322468,
 -1,
 -60796,
 310530574,
 43177,
 -1,
 310581414,
 43176,
 -60794,
 310563547,
 43179,
 -60793,
 310746307,
 43180,
 -60792,
 310802274,
 43178,
 -1,
 310858254,
 43186,
 311038619,
 306694810,
 -1,
 311104143,
 311019982,
 -1,
 311169677,
 311073871,
 43194,
 -1,
 311139407,
 43195,
 311361535,
 311126959,
 43196,
 -1,
 311258031,
 43197,
 311431827,
 311040166,
 -1,
 -60783,
 311410459,
 43203,
 -60782,
 311450179,
 43200,
 -1,
 311498918,
 43189,
 311693973,
 311410459,
 43192,
 -1,
 311672603,
 43193,
 311825047,
 311657918,
 43201,
 -1,
 311788990,
 43202,
 311956121,
 311777859,
 43190,
 -1,
 311908931,
 43191,
 312147967,
 311901358,
 43198,
 -1,
 312032430,
 43199,
 312218284,
 310981816,
 -1,
 312283818,
 312171946,
 -1,
 312349344,
 312259717,
 -1,
 -60769,
 312332235,
 43218,
 -1,
 312367323,
 43219,
 312545955,
 312322213,
 -1,
 -60766,
 312501879,
 43222,
 -1,
 312559086,
 43223,
 312742566,
 312494030,
 -1,
 -60763,
 312708968,
 43220,
 -1,
 312763859,
 43221,
 -60761,
 312726910,
 43216,
 -60760,
 312904120,
 43217,
 -60759,
 312967771,
 43225,
 -1,
 313016430,
 43224,
 -60757,
 312250107,
 43215,
 -1,
 313139001,
 43214,
 313332401,
 312192374,
 -1,
 313397936,
 313313617,
 -1,
 -60753,
 313371099,
 43137,
 -1,
 313433589,
 43204,
 -1,
 313335858,
 43136,
 -1,
 313274712,
 43188,
 313725696,
 306608398,
 -1,
 313791182,
 313684350,
 -1,
 313856696,
 313767045,
 -1,
 -60746,
 313829700,
 2065,
 -60745,
 313877779,
 2056,
 -1,
 313923927,
 2069,
 314118844,
 313809475,
 -1,
 -60742,
 314102402,
 2052,
 -60741,
 314160261,
 2055,
 -1,
 314212154,
 2063,
 314380991,
 314091685,
 -1,
 -60738,
 314335531,
 2062,
 -1,
 314397449,
 2068,
 314577602,
 314320164,
 -1,
 -60735,
 314533139,
 2049,
 -1,
 314579284,
 2053,
 -60733,
 314561892,
 2054,
 -60732,
 314758333,
 2057,
 -60731,
 314811789,
 2067,
 -60730,
 314874914,
 2066,
 -60729,
 314934581,
 2061,
 -60728,
 314997930,
 2060,
 -60727,
 315059190,
 2059,
 -60726,
 315123859,
 2058,
 -60725,
 315182540,
 2050,
 -60724,
 315246881,
 2064,
 -60723,
 315307402,
 2051,
 -1,
 315366770,
 2048,
 315560672,
 313772698,
 -1,
 315626197,
 315520210,
 -1,
 315691730,
 315562150,
 2082,
 -1,
 315627686,
 2079,
 -60717,
 315670299,
 2086,
 -60716,
 315775555,
 2089,
 -1,
 315833518,
 2076,
 316019416,
 315590078,
 2091,
 316145663,
 316000297,
 2081,
 -1,
 316020902,
 2078,
 316216027,
 315992229,
 -1,
 -60710,
 316195275,
 2092,
 -1,
 316233811,
 2085,
 316412637,
 316151974,
 2083,
 -1,
 316348582,
 2080,
 -60706,
 316391195,
 2087,
 -60705,
 316496451,
 2090,
 -1,
 316554414,
 2077,
 316740339,
 315529756,
 -1,
 316805864,
 316676262,
 -1,
 316871397,
 316768058,
 -1,
 -60700,
 316833702,
 2110,
 -1,
 316886704,
 2098,
 -60698,
 316848759,
 2100,
 -60697,
 317040131,
 2108,
 -1,
 317082799,
 2097,
 317264619,
 316789957,
 -1,
 -60694,
 317219774,
 2104,
 -1,
 317266737,
 2106,
 317461230,
 317237413,
 -1,
 -60691,
 317425401,
 2109,
 -1,
 317478653,
 2101,
 -60689,
 317439536,
 2107,
 -60688,
 317627122,
 2105,
 -60687,
 317686044,
 2096,
 -60686,
 317749991,
 2103,
 -1,
 317793912,
 2099,
 317985535,
 316700428,
 -1,
 318051067,
 317923634,
 -1,
 318116599,
 318004936,
 2070,
 -1,
 318049779,
 2071,
 -60680,
 318080599,
 2072,
 -60679,
 318210332,
 2093,
 -60678,
 318260017,
 2075,
 -1,
 318322031,
 2073,
 318570495,
 318015175,
 -1,
 -60675,
 318483612,
 2084,
 -60674,
 318528067,
 2088,
 -1,
 318587697,
 2074,
 -1,
 317921687,
 2102,
 318837511,
 313689063,
 -1,
 318903046,
 318788755,
 -1,
 318968581,
 318847407,
 -1,
 -60668,
 318946767,
 128630,
 -1,
 318976196,
 128631,
 -1,
 318928241,
 128632,
 -1,
 318857844,
 128634,
 319296265,
 318813847,
 128752,
 -1,
 319226091,
 128225,
 -60662,
 319279679,
 127927,
 -60661,
 319383923,
 127862,
 -1,
 319446548,
 9973,
 319624092,
 306551647,
 -1,
 319689603,
 319567034,
 -1,
 319755083,
 319629977,
 -1,
 319820617,
 319711147,
 -1,
 319886116,
 319755417,
 -1,
 319951637,
 319820162,
 -1,
 -60653,
 319887135,
 127545,
 -60652,
 319952019,
 127516,
 -1,
 320016764,
 127520,
 320213784,
 319887343,
 -1,
 -60649,
 320148125,
 127511,
 -1,
 320213369,
 127509,
 320410395,
 320148421,
 -1,
 -60646,
 320345026,
 127525,
 -1,
 320409681,
 127540,
 320607006,
 320344743,
 -1,
 -60643,
 320555036,
 127534,
 -1,
 320613441,
 127506,
 -60641,
 320555039,
 127517,
 -60640,
 320747042,
 127532,
 -60639,
 320808270,
 127505,
 -60638,
 320870379,
 127524,
 -60637,
 320935306,
 127546,
 -1,
 320999797,
 127518,
 321196853,
 319821198,
 -1,
 321262377,
 321130882,
 -1,
 -60633,
 321198232,
 127527,
 -60632,
 321262960,
 127537,
 -1,
 321328272,
 127504,
 321524524,
 321197849,
 -1,
 -60629,
 321460207,
 127542,
 -1,
 321525566,
 127543,
 321721135,
 321459353,
 -1,
 -60626,
 321660211,
 127519,
 -1,
 321722527,
 127515,
 321917746,
 321655463,
 -1,
 -60623,
 321852787,
 127528,
 -1,
 321917006,
 127535,
 -60621,
 321865752,
 127526,
 -60620,
 322059692,
 127541,
 -1,
 322115155,
 127513,
 322310973,
 321132126,
 -1,
 322376505,
 322245785,
 -1,
 -60616,
 322311094,
 127544,
 -1,
 322376063,
 127522,
 -60614,
 322319678,
 127521,
 -60613,
 322509136,
 127539,
 -60612,
 322574491,
 127538,
 -1,
 322638180,
 127514,
 322835268,
 322245782,
 -1,
 322900801,
 322768722,
 -1,
 -60608,
 322836463,
 127530,
 -1,
 322899794,
 127529,
 -60606,
 322836813,
 127512,
 -60605,
 323033064,
 127508,
 -1,
 323097248,
 127533,
 323294024,
 322770750,
 -1,
 -60602,
 323237186,
 127536,
 -60601,
 323300042,
 127523,
 -1,
 323360930,
 127510,
 -1,
 323229837,
 127531,
 -60598,
 319785784,
 127378,
 -1,
 323578799,
 127377,
 323752810,
 319712175,
 -1,
 323818343,
 323691452,
 -1,
 -60594,
 323802309,
 127305,
 -60593,
 323867266,
 127304,
 -60592,
 323932574,
 127303,
 -60591,
 323996430,
 127302,
 -60590,
 324060829,
 127301,
 -60589,
 324124443,
 127300,
 -60588,
 324187269,
 127299,
 -60587,
 324249765,
 127298,
 -60586,
 324312143,
 127297,
 -60585,
 324377256,
 127296,
 -60584,
 324440870,
 127295,
 -60583,
 324502974,
 127294,
 -60582,
 324566842,
 127293,
 -60581,
 324630284,
 127292,
 -60580,
 324692911,
 127291,
 -60579,
 324757533,
 127290,
 -60578,
 324822774,
 127289,
 -60577,
 324885059,
 127288,
 -60576,
 324948472,
 127287,
 -60575,
 325012756,
 127286,
 -60574,
 325076942,
 127285,
 -60573,
 325139630,
 127284,
 -60572,
 325203128,
 127283,
 -60571,
 325266073,
 127282,
 -60570,
 325330212,
 127281,
 -1,
 325392550,
 127280,
 325648383,
 323782436,
 -1,
 -60567,
 325553363,
 10191,
 -1,
 325590731,
 10190,
 325784431,
 323725477,
 -1,
 -60564,
 325757093,
 127309,
 -60563,
 325815778,
 127384,
 -60562,
 325858488,
 127308,
 -1,
 325918297,
 9949,
 326112117,
 325740573,
 -1,
 326177652,
 326050601,
 -1,
 -60558,
 326150448,
 127490,
 -60557,
 326200038,
 127489,
 -1,
 326252040,
 127507,
 -1,
 326125511,
 9919,
 326505336,
 326074170,
 -1,
 -60553,
 326454548,
 127382,
 -1,
 326518449,
 127381,
 326701947,
 326453198,
 -1,
 -60550,
 326672431,
 127379,
 -1,
 326733691,
 11820,
 -60548,
 326683737,
 127311,
 -60547,
 326879989,
 127386,
 -60546,
 326943755,
 127385,
 -60545,
 326998317,
 127310,
 -60544,
 327059404,
 127383,
 -60543,
 327122706,
 127307,
 -60542,
 327179248,
 127380,
 -1,
 327244308,
 127306,
 327483391,
 319619072,
 -1,
 327488393,
 327405153,
 -1,
 -60538,
 327468197,
 11028,
 -60537,
 327531241,
 11026,
 -60536,
 327579122,
 11029,
 -1,
 327625030,
 11027,
 327816079,
 327431352,
 -1,
 327881614,
 327776012,
 13175,
 328007679,
 327811072,
 -1,
 -60531,
 327921904,
 13176,
 -1,
 327955452,
 13177,
 -1,
 327837430,
 127376,
 328209298,
 327766520,
 -1,
 -60527,
 328164300,
 127488,
 -1,
 328224020,
 13004,
 328405909,
 328154286,
 -1,
 -60524,
 328386205,
 13006,
 -1,
 328442253,
 13005,
 -60522,
 328386207,
 13278,
 -60521,
 328578554,
 128918,
 -60520,
 328636575,
 11216,
 -60519,
 328689104,
 13178,
 -60518,
 328748482,
 13311,
 -60517,
 328813438,
 9974,
 -1,
 328865997,
 13279,
 329061389,
 319602459,
 -1,
 329126918,
 329023290,
 -1,
 329192447,
 329070008,
 -1,
 329257933,
 329150846,
 -1,
 329323428,
 329219898,
 -1,
 -60510,
 329306843,
 7057,
 -60509,
 329338211,
 7053,
 -1,
 329390246,
 7060,
 329585577,
 329271246,
 -1,
 329651112,
 329539344,
 -1,
 -60505,
 329611020,
 7103,
 -1,
 329672733,
 7102,
 -1,
 329586854,
 7062,
 329913260,
 329558181,
 -1,
 -60501,
 329896667,
 7087,
 -1,
 329914534,
 7070,
 330109871,
 329882703,
 -1,
 -60498,
 330057045,
 7099,
 -1,
 330111142,
 7067,
 330306482,
 330066863,
 -1,
 -60495,
 330253653,
 7100,
 -1,
 330307750,
 7068,
 330503093,
 330262557,
 -1,
 -60492,
 330453518,
 7086,
 -1,
 330504358,
 7050,
 330699703,
 330448046,
 7048,
 -1,
 330678043,
 7049,
 330830778,
 330638628,
 -1,
 -60487,
 330781198,
 7101,
 -1,
 330832038,
 7064,
 331027388,
 330766502,
 7043,
 -1,
 330972334,
 7046,
 -60483,
 331011285,
 7056,
 -60482,
 331141851,
 7066,
 -60481,
 331207098,
 7071,
 -60480,
 331270990,
 7069,
 -60479,
 331335347,
 7063,
 -60478,
 331398939,
 7045,
 -60477,
 331461895,
 7058,
 -60476,
 331520694,
 7051,
 -60475,
 331584380,
 7061,
 -60474,
 331646398,
 7047,
 -60473,
 331708258,
 7065,
 -60472,
 331769620,
 7055,
 -60471,
 331831875,
 7044,
 -60470,
 331895310,
 7072,
 -60469,
 331959651,
 7052,
 -60468,
 332019014,
 7059,
 -1,
 332081863,
 7054,
 332272603,
 329201562,
 -1,
 332338129,
 332248197,
 -1,
 -60464,
 332320715,
 7090,
 -1,
 332355803,
 7091,
 332534740,
 332310693,
 -1,
 -60461,
 332490359,
 7094,
 -1,
 332547566,
 7095,
 332731351,
 332482510,
 -1,
 -60458,
 332697448,
 7092,
 -1,
 332752339,
 7093,
 -60456,
 332715390,
 7088,
 -60455,
 332892600,
 7089,
 -60454,
 332956251,
 7097,
 -1,
 333004910,
 7096,
 333190117,
 332241449,
 -1,
 333255647,
 333157158,
 -1,
 -60450,
 333235606,
 7362,
 -1,
 333258686,
 7361,
 -60448,
 333231064,
 7360,
 -60447,
 333410782,
 7364,
 -60446,
 333473906,
 7365,
 -60445,
 333526360,
 7366,
 -60444,
 333589243,
 7363,
 -1,
 333653340,
 7367,
 333845485,
 333171366,
 -1,
 333911020,
 333807418,
 -1,
 -60440,
 333894840,
 7077,
 -60439,
 333940908,
 7079,
 -60438,
 333991885,
 7076,
 -60437,
 334054794,
 7081,
 -1,
 334109493,
 7078,
 -1,
 333871921,
 7080,
 334369782,
 333819254,
 -1,
 334435317,
 334336892,
 -1,
 334500852,
 334397242,
 -1,
 334566387,
 334449940,
 -1,
 -60430,
 334548560,
 7042,
 -1,
 334589414,
 7041,
 -1,
 334549853,
 7040,
 -1,
 334460777,
 7082,
 -1,
 334416266,
 7083,
 334959614,
 334311812,
 -1,
 335025146,
 334932414,
 -1,
 -60423,
 335006542,
 7085,
 -1,
 335050594,
 7084,
 335221757,
 334988646,
 -1,
 -60420,
 335175163,
 7075,
 -1,
 335224130,
 7074,
 -1,
 335183058,
 7073,
 -1,
 334898320,
 7098,
 335549441,
 329164161,
 127749,
 -1,
 335480357,
 127748,
 335680516,
 335478784,
 -1,
 -60413,
 335662711,
 127774,
 -1,
 335685329,
 9925,
 -60411,
 335653627,
 127751,
 -1,
 335825589,
 127803,
 336008201,
 329099429,
 -1,
 -60408,
 335975812,
 128671,
 -1,
 336024966,
 127843,
 336204811,
 335947044,
 983102,
 -1,
 336179767,
 983101,
 -60404,
 336175496,
 127940,
 -1,
 336303625,
 10185,
 336467032,
 329024958,
 983077,
 336532538,
 336436430,
 -1,
 336598060,
 336490878,
 -1,
 336663572,
 336559930,
 -1,
 -60398,
 336646882,
 69857,
 -60397,
 336678330,
 69847,
 -1,
 336731200,
 69849,
 336925719,
 336623458,
 -1,
 -60394,
 336876024,
 69846,
 -1,
 336936110,
 69864,
 337122330,
 336870574,
 -1,
 -60391,
 337072632,
 69863,
 -1,
 337133625,
 69859,
 -60389,
 337105634,
 69852,
 -60388,
 337299134,
 69850,
 -60387,
 337363340,
 69861,
 -60386,
 337425749,
 69841,
 -60385,
 337488211,
 69840,
 -60384,
 337550626,
 69853,
 -60383,
 337613762,
 69851,
 -60382,
 337676144,
 69862,
 -60381,
 337734795,
 69848,
 -60380,
 337799347,
 69855,
 -60379,
 337864480,
 69856,
 -60378,
 337927655,
 69860,
 -60377,
 337990207,
 69854,
 -60376,
 338054586,
 69845,
 -60375,
 338113910,
 69844,
 -60374,
 338176754,
 69843,
 -60373,
 338240903,
 69842,
 -1,
 338304064,
 69858,
 338558975,
 336541594,
 -1,
 338564144,
 338474117,
 -1,
 -60369,
 338546635,
 69874,
 -1,
 338581723,
 69875,
 338760755,
 338536613,
 -1,
 -60366,
 338716279,
 69878,
 -1,
 338773486,
 69879,
 338957366,
 338708430,
 -1,
 -60363,
 338923368,
 69876,
 -1,
 338978259,
 69877,
 -60361,
 338941310,
 69872,
 -60360,
 339118520,
 69873,
 -60359,
 339182171,
 69881,
 -1,
 339230830,
 69880,
 339416143,
 336512592,
 -1,
 339481669,
 339397801,
 -1,
 339547200,
 339449831,
 -1,
 -60354,
 339528064,
 128601,
 -60353,
 339570391,
 128593,
 -1,
 339618337,
 128609,
 339809346,
 339524689,
 11113,
 -1,
 339741369,
 11129,
 -60349,
 339791116,
 11011,
 -60348,
 339913158,
 129111,
 -1,
 339945525,
 11019,
 340197375,
 339426818,
 -1,
 340202570,
 340105191,
 -1,
 -60344,
 340183424,
 128603,
 -60343,
 340225751,
 128595,
 -1,
 340273697,
 128611,
 340464716,
 340180049,
 11112,
 -1,
 340396729,
 11128,
 -60339,
 340446476,
 11010,
 -60338,
 340568518,
 129110,
 -1,
 340600885,
 11018,
 340792401,
 339374681,
 128618,
 -1,
 340722554,
 128619,
 340923476,
 340741304,
 -1,
 -60333,
 340896777,
 128428,
 -1,
 340941714,
 127846,
 -60331,
 340895909,
 983181,
 -60330,
 341084545,
 128284,
 -60329,
 341135864,
 983043,
 -1,
 341191754,
 9917,
 341382312,
 336450178,
 -1,
 341447829,
 341341505,
 -1,
 341513350,
 341406078,
 -1,
 341578849,
 341488773,
 -1,
 341644383,
 341554309,
 -1,
 -60322,
 341607870,
 43024,
 -1,
 341661486,
 43025,
 -60320,
 341607870,
 43028,
 -1,
 341792558,
 43029,
 341972071,
 341521592,
 -1,
 342037605,
 341914808,
 -1,
 -60316,
 342001086,
 43026,
 -1,
 342054702,
 43027,
 -60314,
 342001086,
 43030,
 -1,
 342185774,
 43031,
 342365290,
 341941327,
 -1,
 -60311,
 342337079,
 43040,
 -1,
 342394302,
 43038,
 342561901,
 342332198,
 -1,
 -60308,
 342525374,
 43033,
 -1,
 342578990,
 43034,
 342758512,
 342517789,
 -1,
 -60305,
 342721982,
 43015,
 -1,
 342775598,
 43016,
 342955123,
 342714102,
 -1,
 -60302,
 342918590,
 43022,
 -1,
 342972206,
 43023,
 343151734,
 342904084,
 -1,
 -60299,
 343115198,
 43017,
 -1,
 343168814,
 43018,
 343348345,
 343091865,
 -1,
 -60296,
 343311806,
 43020,
 -1,
 343365422,
 43021,
 343544956,
 343287076,
 -1,
 -60293,
 343508414,
 43035,
 -1,
 343562030,
 43036,
 -60291,
 343523099,
 43011,
 -60290,
 343715828,
 43041,
 -60289,
 343770558,
 43013,
 -60288,
 343835425,
 43032,
 -60287,
 343899464,
 43037,
 -60286,
 343962772,
 43039,
 -60285,
 344021571,
 43009,
 -60284,
 344086318,
 43042,
 -60283,
 344145070,
 43012,
 -1,
 344201382,
 43008,
 344396940,
 341494426,
 -1,
 -60280,
 344375067,
 43045,
 -60279,
 344427264,
 43047,
 -60278,
 344480323,
 43044,
 -60277,
 344538286,
 43046,
 -1,
 344594598,
 43043,
 344790161,
 344364990,
 -1,
 -60274,
 344724421,
 43051,
 -60273,
 344789671,
 43050,
 -60272,
 344854914,
 43049,
 -1,
 344920155,
 43048,
 345178111,
 344763766,
 -1,
 -60269,
 345068546,
 43014,
 -60268,
 345128078,
 43010,
 -1,
 345186354,
 43019,
 345380002,
 341418463,
 -1,
 345445537,
 345315841,
 -1,
 345511072,
 345403774,
 -1,
 345576604,
 345485322,
 -1,
 -60262,
 345560537,
 1869,
 -60261,
 345598496,
 1870,
 -1,
 345655433,
 1871,
 345899007,
 345544226,
 -1,
 -60258,
 345788239,
 1838,
 -60257,
 345847541,
 1839,
 -1,
 345909158,
 1837,
 -1,
 345486195,
 983202,
 -1,
 345407974,
 128137,
 346231973,
 345341754,
 983094,
 -60252,
 346172920,
 983093,
 -1,
 346233889,
 128333,
 346488831,
 346192371,
 -1,
 -60249,
 346401177,
 8527,
 -1,
 346454342,
 128325,
 346625228,
 341357701,
 983189,
 346690746,
 346560678,
 -1,
 346756274,
 346662852,
 -1,
 346821806,
 346728613,
 -1,
 -60243,
 346799273,
 983180,
 -1,
 346833154,
 983132,
 -60241,
 346797897,
 983044,
 -60240,
 346986935,
 983175,
 -60239,
 347034721,
 983042,
 -1,
 347099500,
 983174,
 347280565,
 346731653,
 -1,
 -60236,
 347259239,
 128509,
 -1,
 347300710,
 128649,
 347477176,
 347228369,
 -1,
 -60233,
 347428114,
 9882,
 -1,
 347478901,
 9877,
 -60231,
 347438623,
 128387,
 -1,
 347617305,
 127967,
 347804865,
 346659919,
 -1,
 347870400,
 347740326,
 -1,
 347935935,
 347823400,
 -1,
 -60226,
 347898175,
 9188,
 -1,
 347932814,
 128207,
 -1,
 347917388,
 127827,
 -1,
 347824401,
 983188,
 348263622,
 347749550,
 -1,
 348329157,
 348200544,
 -1,
 -60220,
 348282956,
 127836,
 -1,
 348324923,
 128642,
 -1,
 348291901,
 11836,
 348591305,
 348227006,
 -1,
 -60216,
 348560033,
 9201,
 -1,
 348598090,
 128480,
 -60214,
 348574110,
 983045,
 -60213,
 348766517,
 127897,
 -1,
 348825765,
 983169,
 348984554,
 346592038,
 983117,
 349050074,
 348929198,
 -1,
 349115606,
 348986647,
 -1,
 349181140,
 349062031,
 128264,
 349306879,
 349113096,
 -1,
 -60206,
 349223048,
 128266,
 -60205,
 349276701,
 128265,
 -1,
 349317920,
 128263,
 -60203,
 349134993,
 128483,
 -1,
 349441704,
 128586,
 349639897,
 349060270,
 -1,
 -60200,
 349582832,
 128676,
 -1,
 349646091,
 128172,
 -1,
 349614037,
 8375,
 349902049,
 349002307,
 -1,
 349967583,
 349871573,
 -1,
 -60195,
 349940739,
 128026,
 -60194,
 349995952,
 128466,
 -1,
 350038785,
 128467,
 350289919,
 349910679,
 128375,
 -1,
 350161661,
 128376,
 350360806,
 349837478,
 983176,
 350426341,
 350332437,
 -1,
 -60188,
 350380200,
 128150,
 -1,
 350438533,
 10024,
 -1,
 350375780,
 127837,
 350688489,
 350324158,
 -1,
 -60184,
 350668402,
 128051,
 -1,
 350726147,
 127941,
 -1,
 350645599,
 128166,
 350950660,
 348944140,
 -1,
 351016190,
 350902851,
 -1,
 351081725,
 350974832,
 -1,
 351147258,
 351029291,
 -1,
 351212787,
 351112202,
 128515,
 351338495,
 351141959,
 -1,
 -60175,
 351254843,
 128518,
 -60174,
 351317947,
 128516,
 -1,
 351350867,
 128517,
 351540471,
 351162872,
 -1,
 -60171,
 351505815,
 128520,
 -60170,
 351550955,
 128525,
 -1,
 351608339,
 128519,
 351862783,
 351512741,
 -1,
 -60167,
 351781636,
 128526,
 -1,
 351829107,
 128522,
 352059391,
 351087602,
 -1,
 -60164,
 351964170,
 128570,
 -1,
 352015482,
 128571,
 -1,
 351053322,
 128527,
 352261379,
 350952945,
 -1,
 -60160,
 352239255,
 68411,
 -60159,
 352292078,
 128312,
 -60158,
 352331961,
 128313,
 -1,
 352394407,
 128745,
 -1,
 352225287,
 128684,
 352654616,
 350907311,
 -1,
 352720141,
 352599214,
 -1,
 352785676,
 352666401,
 -1,
 352851211,
 352739390,
 -1,
 -60151,
 352826434,
 128164,
 -60150,
 352864294,
 128564,
 -1,
 352918041,
 128716,
 -1,
 352834204,
 128554,
 -1,
 352765537,
 128373,
 353244434,
 352672323,
 -1,
 353309969,
 353193926,
 -1,
 -60144,
 353284040,
 128578,
 -1,
 353324193,
 128577,
 -1,
 353250407,
 127829,
 353572119,
 353179814,
 -1,
 353637654,
 353535098,
 -1,
 -60139,
 353609187,
 11100,
 -1,
 353667042,
 11098,
 -1,
 353618490,
 42611,
 -1,
 353537549,
 127920,
 353965346,
 352594585,
 -1,
 354030877,
 353934415,
 -1,
 -60133,
 353994906,
 128220,
 -60132,
 354050978,
 128624,
 -1,
 354107283,
 128437,
 354293023,
 353982393,
 127979,
 -1,
 354224290,
 127890,
 -60128,
 354258332,
 129410,
 -60127,
 354376259,
 983185,
 -1,
 354426290,
 9878,
 354620715,
 353909934,
 -1,
 354686246,
 354565294,
 -1,
 -60123,
 354629686,
 127793,
 -1,
 354684584,
 128584,
 -60121,
 354669138,
 9913,
 -60120,
 354858219,
 983168,
 -60119,
 354922785,
 9916,
 -60118,
 354974969,
 9914,
 -1,
 355017487,
 128186,
 355210547,
 354582330,
 -1,
 355276080,
 355177038,
 -1,
 -60114,
 355236051,
 9924,
 -60113,
 355281113,
 127938,
 -1,
 355336644,
 127956,
 355598335,
 355211430,
 -1,
 -60110,
 355494256,
 128013,
 -1,
 355556863,
 128012,
 355734839,
 355191566,
 -1,
 -60107,
 355713774,
 8275,
 -60106,
 355753650,
 127946,
 -1,
 355803817,
 128629,
 355996987,
 355707045,
 -1,
 -60103,
 355932326,
 983133,
 -60102,
 355996327,
 983159,
 -1,
 356061570,
 983156,
 356259136,
 355952669,
 -1,
 356324671,
 356211267,
 -1,
 -60098,
 356270991,
 9975,
 -1,
 356319409,
 127935,
 -1,
 356303358,
 128128,
 -1,
 356208255,
 983183,
 356654167,
 214199215,
 -1,
 356718743,
 356604483,
 -1,
 356784094,
 356679482,
 -1,
 356849627,
 356727982,
 -1,
 356915159,
 356786349,
 -1,
 356980435,
 356849928,
 -1,
 357045671,
 356918564,
 -1,
 357111192,
 356978514,
 -1,
 357176664,
 357044610,
 -1,
 357242189,
 357110146,
 67090,
 -60084,
 357201676,
 67092,
 -1,
 357255118,
 67091,
 357438800,
 357175387,
 67087,
 -60081,
 357398284,
 67089,
 -1,
 357451726,
 67088,
 357635410,
 357372583,
 67093,
 -1,
 357594892,
 67094,
 -60077,
 357570543,
 67100,
 -60076,
 357701438,
 67098,
 -60075,
 357766750,
 67097,
 -60074,
 357832078,
 67096,
 -60073,
 357897157,
 67095,
 -1,
 357961554,
 67086,
 358159714,
 357110937,
 -1,
 -60070,
 358094831,
 67123,
 -60069,
 358160190,
 67122,
 -60068,
 358225502,
 67121,
 -60067,
 358290830,
 67120,
 -60066,
 358356121,
 67119,
 -60065,
 358421445,
 67118,
 -60064,
 358486695,
 67117,
 -60063,
 358551643,
 67116,
 -1,
 358616914,
 67115,
 358815084,
 358092626,
 -1,
 -60060,
 358750191,
 67080,
 -60059,
 358815550,
 67079,
 -60058,
 358880862,
 67078,
 -60057,
 358946190,
 67077,
 -60056,
 359011481,
 67076,
 -60055,
 359076805,
 67075,
 -60054,
 359142055,
 67074,
 -60053,
 359207298,
 67073,
 -1,
 359272539,
 67072,
 359470453,
 358749125,
 -1,
 -60050,
 359405551,
 67114,
 -60049,
 359470910,
 67113,
 -60048,
 359536222,
 67112,
 -60047,
 359601550,
 67111,
 -60046,
 359666841,
 67110,
 -60045,
 359732165,
 67109,
 -60044,
 359796827,
 67108,
 -1,
 359862098,
 67107,
 360060285,
 359405150,
 -1,
 -60041,
 359995375,
 67136,
 -60040,
 360060734,
 67135,
 -60039,
 360126046,
 67134,
 -60038,
 360191374,
 67133,
 -60037,
 360256453,
 67132,
 -60036,
 360321703,
 67131,
 -1,
 360386386,
 67130,
 360584580,
 359995198,
 -1,
 -60033,
 360519262,
 67142,
 -60032,
 360584590,
 67141,
 -60031,
 360649881,
 67140,
 -60030,
 360714626,
 67139,
 -60029,
 360779867,
 67138,
 -1,
 360845138,
 67137,
 361043339,
 360519054,
 -1,
 -60026,
 360978415,
 67129,
 -60025,
 361043550,
 67128,
 -60024,
 361108878,
 67127,
 -60023,
 361174169,
 67126,
 -60022,
 361238619,
 67125,
 -1,
 361303890,
 67124,
 361502098,
 360977063,
 -1,
 -60019,
 361437167,
 67106,
 -60018,
 361502526,
 67105,
 -60017,
 361567838,
 67104,
 -60016,
 361632709,
 67103,
 -60015,
 361697371,
 67102,
 -1,
 361762642,
 67101,
 362020863,
 361435227,
 -1,
 -60012,
 361895518,
 67085,
 -60011,
 361960846,
 67084,
 -60010,
 362025639,
 67083,
 -60009,
 362090587,
 67082,
 -1,
 362155858,
 67081,
 362414079,
 357044315,
 -1,
 362419613,
 362287490,
 -1,
 -60005,
 362353319,
 67148,
 -60004,
 362418562,
 67147,
 -1,
 362483538,
 67145,
 362681760,
 362354494,
 -1,
 -60001,
 362616638,
 67155,
 -1,
 362680146,
 67154,
 362878371,
 362615721,
 -1,
 -59998,
 362816804,
 67150,
 -1,
 362879142,
 67149,
 -59996,
 362813586,
 67156,
 -59995,
 363009820,
 67153,
 -59994,
 363075159,
 67152,
 -1,
 363139442,
 67144,
 363337218,
 356979865,
 -1,
 363402675,
 363271998,
 -1,
 -59990,
 363337711,
 67324,
 -59989,
 363403070,
 67323,
 -59988,
 363468382,
 67322,
 -59987,
 363533710,
 67321,
 -59986,
 363599001,
 67320,
 -59985,
 363664325,
 67319,
 -59984,
 363729575,
 67318,
 -59983,
 363794818,
 67317,
 -59982,
 363860059,
 67316,
 -1,
 363925330,
 67315,
 364123582,
 363337310,
 -1,
 -59979,
 364058607,
 67314,
 -59978,
 364123966,
 67313,
 -59977,
 364189278,
 67312,
 -59976,
 364254606,
 67311,
 -59975,
 364319897,
 67310,
 -59974,
 364385221,
 67309,
 -59973,
 364450471,
 67308,
 -59972,
 364515714,
 67307,
 -59971,
 364580955,
 67306,
 -1,
 364646226,
 67305,
 364844488,
 364057753,
 -1,
 -59968,
 364779503,
 67298,
 -59967,
 364844638,
 67297,
 -59966,
 364909966,
 67296,
 -59965,
 364975257,
 67295,
 -59964,
 365040581,
 67294,
 -59963,
 365105831,
 67293,
 -59962,
 365171074,
 67292,
 -59961,
 365236315,
 67291,
 -1,
 365301586,
 67290,
 365499858,
 364778151,
 -1,
 -59958,
 365434863,
 67282,
 -59957,
 365500222,
 67281,
 -59956,
 365565534,
 67280,
 -59955,
 365630862,
 67279,
 -59954,
 365696153,
 67278,
 -59953,
 365761477,
 67277,
 -59952,
 365826434,
 67276,
 -59951,
 365891675,
 67275,
 -1,
 365956946,
 67274,
 366155228,
 365433218,
 -1,
 -59948,
 366090223,
 67273,
 -59947,
 366155582,
 67272,
 -59946,
 366220894,
 67271,
 -59945,
 366286222,
 67270,
 -59944,
 366351513,
 67269,
 -59943,
 366416837,
 67268,
 -59942,
 366482087,
 67267,
 -59941,
 366547035,
 67266,
 -1,
 366612306,
 67265,
 366810597,
 366088018,
 -1,
 -59938,
 366745583,
 67258,
 -59937,
 366810942,
 67257,
 -59936,
 366876046,
 67256,
 -59935,
 366941337,
 67255,
 -59934,
 367006661,
 67254,
 -59933,
 367071911,
 67253,
 -59932,
 367137154,
 67252,
 -1,
 367202395,
 67251,
 367400429,
 366744517,
 -1,
 -59929,
 367335407,
 67289,
 -59928,
 367400766,
 67288,
 -59927,
 367466078,
 67287,
 -59926,
 367531161,
 67286,
 -59925,
 367595906,
 67285,
 -59924,
 367661147,
 67284,
 -1,
 367726418,
 67283,
 367924724,
 367335407,
 -1,
 -59921,
 367859518,
 67330,
 -59920,
 367924622,
 67329,
 -59919,
 367989913,
 67328,
 -59918,
 368055237,
 67327,
 -59917,
 368120194,
 67326,
 -1,
 368185435,
 67325,
 368383483,
 367859086,
 -1,
 -59914,
 368318447,
 67304,
 -59913,
 368383806,
 67303,
 -59912,
 368448910,
 67302,
 -59911,
 368514201,
 67301,
 -59910,
 368579525,
 67300,
 -1,
 368644775,
 67299,
 368902143,
 368316507,
 -1,
 -59907,
 368776590,
 67264,
 -59906,
 368841881,
 67263,
 -59905,
 368906919,
 67262,
 -59904,
 368972162,
 67261,
 -59903,
 369037403,
 67260,
 -1,
 369102674,
 67259,
 369301080,
 363270823,
 -1,
 369366545,
 369234011,
 -1,
 369432072,
 369300135,
 -1,
 -59898,
 369371801,
 67173,
 -59897,
 369435940,
 67172,
 -1,
 369498278,
 67171,
 -59895,
 369367023,
 67179,
 -59894,
 369628990,
 67178,
 -59893,
 369694302,
 67177,
 -59892,
 369759630,
 67176,
 -59891,
 369824921,
 67175,
 -59890,
 369890245,
 67174,
 -59889,
 369955202,
 67170,
 -59888,
 370020443,
 67169,
 -1,
 370085714,
 67168,
 370284062,
 369299282,
 -1,
 370349590,
 370218991,
 -1,
 -59884,
 370289305,
 67167,
 -59883,
 370353444,
 67166,
 -1,
 370415782,
 67165,
 -59881,
 370284350,
 67164,
 -59880,
 370546270,
 67163,
 -59879,
 370611598,
 67162,
 -59878,
 370676889,
 67161,
 -59877,
 370742213,
 67160,
 -59876,
 370807463,
 67159,
 -59875,
 370872706,
 67158,
 -1,
 370937947,
 67157,
 371136041,
 370218382,
 -1,
 -59872,
 371070959,
 67229,
 -59871,
 371136318,
 67228,
 -59870,
 371201630,
 67227,
 -59869,
 371266958,
 67226,
 -59868,
 371332249,
 67225,
 -59867,
 371397573,
 67224,
 -59866,
 371462823,
 67223,
 -59865,
 371528066,
 67222,
 -59864,
 371593307,
 67221,
 -1,
 371658578,
 67220,
 371856948,
 371070105,
 -1,
 -59861,
 371791855,
 67219,
 -59860,
 371857214,
 67218,
 -59859,
 371922526,
 67217,
 -59858,
 371987854,
 67216,
 -59857,
 372053145,
 67215,
 -59856,
 372118469,
 67214,
 -59855,
 372183719,
 67213,
 -59854,
 372248962,
 67212,
 -59853,
 372314203,
 67211,
 -1,
 372379474,
 67210,
 372577855,
 371790789,
 -1,
 -59850,
 372512751,
 67209,
 -59849,
 372578110,
 67208,
 -59848,
 372643422,
 67207,
 -59847,
 372708750,
 67206,
 -59846,
 372774041,
 67205,
 -59845,
 372839365,
 67204,
 -59844,
 372904615,
 67203,
 -59843,
 372969858,
 67202,
 -59842,
 373035099,
 67201,
 -1,
 373100370,
 67200,
 373298762,
 372511399,
 -1,
 -59839,
 373233647,
 67199,
 -59838,
 373299006,
 67198,
 -59837,
 373364318,
 67197,
 -59836,
 373429646,
 67196,
 -59835,
 373494937,
 67195,
 -59834,
 373560261,
 67194,
 -59833,
 373625511,
 67193,
 -59832,
 373690754,
 67192,
 -59831,
 373755995,
 67191,
 -1,
 373821266,
 67190,
 374019669,
 373232002,
 -1,
 -59828,
 373954543,
 67189,
 -59827,
 374019902,
 67188,
 -59826,
 374085214,
 67187,
 -59825,
 374150542,
 67186,
 -59824,
 374215833,
 67185,
 -59823,
 374281157,
 67184,
 -59822,
 374346407,
 67183,
 -59821,
 374411650,
 67182,
 -59820,
 374476891,
 67181,
 -1,
 374542162,
 67180,
 374800383,
 373954142,
 -1,
 -59817,
 374673499,
 67231,
 -1,
 374738770,
 67230,
 374937236,
 369235342,
 -1,
 375002724,
 374870107,
 -1,
 -59813,
 374937583,
 67348,
 -59812,
 375002942,
 67347,
 -59811,
 375068254,
 67346,
 -59810,
 375133582,
 67345,
 -59809,
 375198873,
 67344,
 -59808,
 375264197,
 67343,
 -59807,
 375329447,
 67342,
 -59806,
 375394690,
 67341,
 -59805,
 375459931,
 67340,
 -1,
 375525202,
 67339,
 375723630,
 374936729,
 -1,
 -59802,
 375658479,
 67377,
 -59801,
 375723838,
 67376,
 -59800,
 375789150,
 67375,
 -59799,
 375854478,
 67374,
 -59798,
 375919769,
 67373,
 -59797,
 375985093,
 67372,
 -59796,
 376050343,
 67371,
 -59795,
 376115586,
 67370,
 -1,
 376180827,
 67369,
 376379000,
 375656834,
 -1,
 -59792,
 376313839,
 67357,
 -59791,
 376379198,
 67356,
 -59790,
 376444510,
 67355,
 -59789,
 376509838,
 67354,
 -59788,
 376574917,
 67353,
 -59787,
 376640167,
 67352,
 -59786,
 376705410,
 67351,
 -59785,
 376770651,
 67350,
 -1,
 376835922,
 67349,
 377034369,
 376312773,
 -1,
 -59782,
 376969199,
 67368,
 -59781,
 377034558,
 67367,
 -59780,
 377099662,
 67366,
 -59779,
 377164953,
 67365,
 -59778,
 377230277,
 67364,
 -59777,
 377295527,
 67363,
 -59776,
 377360770,
 67362,
 -1,
 377425746,
 67361,
 377624202,
 376966994,
 -1,
 -59773,
 377559023,
 67338,
 -59772,
 377624382,
 67337,
 -59771,
 377689486,
 67336,
 -59770,
 377754565,
 67335,
 -59769,
 377819815,
 67334,
 -59768,
 377885058,
 67333,
 -59767,
 377950299,
 67332,
 -1,
 378015570,
 67331,
 378214032,
 377558414,
 -1,
 -59764,
 378147781,
 67382,
 -59763,
 378213031,
 67381,
 -59762,
 378278274,
 67380,
 -59761,
 378343515,
 67379,
 -1,
 378408786,
 67378,
 378667007,
 378147495,
 -1,
 -59758,
 378541886,
 67360,
 -59757,
 378607198,
 67359,
 -1,
 378672069,
 67358,
 378869423,
 374871646,
 -1,
 378934949,
 378802002,
 -1,
 379000477,
 378869743,
 -1,
 379066012,
 378932715,
 -1,
 -59751,
 379000273,
 67404,
 -59750,
 379065349,
 67403,
 -59749,
 379130633,
 67402,
 -1,
 379195851,
 67401,
 -1,
 378995682,
 67400,
 -59746,
 378935165,
 67399,
 -59745,
 379393682,
 67398,
 -59744,
 379458983,
 67397,
 -59743,
 379524296,
 67396,
 -59742,
 379589604,
 67395,
 -59741,
 379654853,
 67394,
 -59740,
 379720068,
 67393,
 -1,
 379785309,
 67392,
 379983533,
 378867803,
 -1,
 -59737,
 379917930,
 67411,
 -59736,
 379983028,
 67410,
 -59735,
 380048331,
 67409,
 -59734,
 380113736,
 67408,
 -59733,
 380179044,
 67407,
 -59732,
 380244287,
 67406,
 -1,
 380309512,
 67405,
 -59730,
 379917232,
 67413,
 -1,
 380441237,
 67412,
 380638917,
 378803141,
 -1,
 380704443,
 380571474,
 -1,
 -59726,
 380639364,
 67241,
 -59725,
 380704732,
 67240,
 -59724,
 380770067,
 67239,
 -59723,
 380835402,
 67238,
 -59722,
 380900711,
 67237,
 -59721,
 380966014,
 67236,
 -59720,
 381031324,
 67235,
 -59719,
 381096561,
 67234,
 -59718,
 381161819,
 67233,
 -1,
 381227065,
 67232,
 381485055,
 380637275,
 -1,
 -59715,
 381360092,
 67250,
 -59714,
 381425427,
 67249,
 -59713,
 381490762,
 67248,
 -59712,
 381556071,
 67247,
 -59711,
 381621374,
 67246,
 -59710,
 381686684,
 67245,
 -59709,
 381751921,
 67244,
 -59708,
 381817179,
 67243,
 -1,
 381882425,
 67242,
 382080718,
 380573666,
 -1,
 -59705,
 382015070,
 67431,
 -59704,
 382080398,
 67430,
 -59703,
 382145689,
 67429,
 -59702,
 382211013,
 67428,
 -59701,
 382276263,
 67427,
 -59700,
 382341506,
 67426,
 -59699,
 382406747,
 67425,
 -1,
 382472018,
 67424,
 382670546,
 382013531,
 -1,
 -59696,
 382604204,
 67151,
 -59695,
 382669434,
 67146,
 -1,
 382734399,
 67143,
 -1,
 382603334,
 67099,
 383057919,
 356918566,
 -1,
 383063908,
 382950415,
 -1,
 383129410,
 383001892,
 -1,
 383194916,
 383062107,
 -1,
 383260395,
 383127378,
 -1,
 383325916,
 383194265,
 -1,
 -59686,
 383285059,
 65669,
 -59685,
 383338463,
 65668,
 -1,
 383386331,
 65667,
 383588063,
 383260655,
 -1,
 -59682,
 383547160,
 65677,
 -1,
 383600595,
 65676,
 383784674,
 383522622,
 -1,
 -59679,
 383743761,
 65675,
 -1,
 383797241,
 65674,
 383981285,
 383719006,
 -1,
 -59676,
 383940390,
 65673,
 -1,
 383993838,
 65672,
 384177896,
 383915406,
 -1,
 -59673,
 384137021,
 65671,
 -1,
 384190425,
 65670,
 -59671,
 384111576,
 65666,
 -59670,
 384307804,
 65665,
 -1,
 384372672,
 65664,
 384571126,
 383194510,
 -1,
 -59667,
 384505839,
 65713,
 -59666,
 384571198,
 65712,
 -59665,
 384636510,
 65711,
 -59664,
 384701838,
 65710,
 -59663,
 384767129,
 65709,
 -59662,
 384832453,
 65708,
 -59661,
 384897718,
 65707,
 -59660,
 384962973,
 65706,
 -59659,
 385028187,
 65705,
 -1,
 385093458,
 65704,
 385292032,
 384505438,
 -1,
 -59656,
 385226735,
 65722,
 -59655,
 385292094,
 65721,
 -59654,
 385357406,
 65720,
 -59653,
 385422900,
 65719,
 -59652,
 385487813,
 65718,
 -59651,
 385553198,
 65717,
 -59650,
 385618306,
 65716,
 -59649,
 385683547,
 65715,
 -1,
 385748818,
 65714,
 385947401,
 385225881,
 -1,
 -59646,
 385882097,
 65703,
 -59645,
 385947454,
 65702,
 -59644,
 386012766,
 65701,
 -59643,
 386077637,
 65699,
 -59642,
 386142887,
 65698,
 -59641,
 386208130,
 65697,
 -59640,
 386273469,
 65696,
 -1,
 386338642,
 65695,
 386537233,
 385881918,
 -1,
 -59637,
 386471919,
 65729,
 -59636,
 386536601,
 65728,
 -59635,
 386601925,
 65727,
 -59634,
 386667175,
 65726,
 -59633,
 386732418,
 65725,
 -59632,
 386797659,
 65724,
 -1,
 386862930,
 65723,
 387061527,
 386470853,
 -1,
 -59629,
 386995598,
 65694,
 -59628,
 387061084,
 65693,
 -59627,
 387125634,
 65692,
 -59626,
 387190952,
 65691,
 -1,
 387256159,
 65690,
 387454749,
 386994562,
 -1,
 -59623,
 387388601,
 65682,
 -59622,
 387453802,
 65681,
 -59621,
 387518988,
 65680,
 -59620,
 387584110,
 65679,
 -1,
 387649548,
 65678,
 387847969,
 387388071,
 -1,
 -59617,
 387780994,
 65687,
 -59616,
 387846450,
 65686,
 -1,
 387911655,
 65685,
 388169727,
 387782639,
 -1,
 -59613,
 388042932,
 65731,
 -1,
 388108114,
 65730,
 388366335,
 383127938,
 -1,
 388372271,
 388240537,
 -1,
 -59609,
 388306927,
 65757,
 -59608,
 388372286,
 65756,
 -59607,
 388437598,
 65755,
 -59606,
 388502926,
 65754,
 -59605,
 388568217,
 65753,
 -59604,
 388633553,
 65752,
 -59603,
 388698791,
 65751,
 -59602,
 388764034,
 65750,
 -1,
 388829275,
 65749,
 389027640,
 388305861,
 -1,
 -59599,
 388962287,
 65748,
 -59598,
 389027646,
 65747,
 -59597,
 389092750,
 65745,
 -59596,
 389158041,
 65744,
 -59595,
 389223307,
 65743,
 -59594,
 389288333,
 65742,
 -59593,
 389353591,
 65741,
 -1,
 389419028,
 65740,
 389617471,
 388960935,
 -1,
 -59590,
 389551502,
 65739,
 -59589,
 389616581,
 65738,
 -59588,
 389682034,
 65737,
 -59587,
 389747074,
 65736,
 -59586,
 389812321,
 65735,
 -1,
 389877756,
 65734,
 390135807,
 389550466,
 -1,
 -59583,
 390010026,
 65733,
 -1,
 390074232,
 65732,
 390332415,
 383109411,
 -1,
 390338402,
 390205826,
 -1,
 390403919,
 390271067,
 -1,
 -59578,
 390338543,
 65778,
 -59577,
 390403902,
 65777,
 -59576,
 390469214,
 65776,
 -59575,
 390534542,
 65775,
 -59574,
 390599833,
 65774,
 -59573,
 390665157,
 65773,
 -59572,
 390730407,
 65772,
 -59571,
 390795650,
 65771,
 -59570,
 390860891,
 65770,
 -1,
 390926162,
 65769,
 391124826,
 390336338,
 -1,
 -59567,
 391059439,
 65768,
 -59566,
 391124798,
 65767,
 -59565,
 391190110,
 65766,
 -59564,
 391255438,
 65765,
 -59563,
 391320729,
 65764,
 -59562,
 391386053,
 65763,
 -59561,
 391451303,
 65762,
 -59560,
 391516546,
 65761,
 -59559,
 391581787,
 65760,
 -1,
 391647058,
 65759,
 391845729,
 391057794,
 -1,
 -59556,
 391780335,
 65784,
 -59555,
 391845694,
 65783,
 -59554,
 391911006,
 65782,
 -59553,
 391976334,
 65781,
 -59552,
 392040834,
 65780,
 -1,
 392106075,
 65779,
 -1,
 391779693,
 65785,
 -59549,
 390271909,
 65786,
 -1,
 392302952,
 65758,
 392501197,
 383038481,
 -1,
 392566714,
 392459282,
 -1,
 392632176,
 392500830,
 -1,
 -59544,
 392566727,
 65572,
 -59543,
 392631969,
 65551,
 -59542,
 392697362,
 65608,
 -59541,
 392762706,
 65592,
 -59540,
 392828021,
 65597,
 -59539,
 392893225,
 65558,
 -59538,
 392958484,
 65567,
 -59537,
 393023632,
 65603,
 -1,
 393088940,
 65554,
 393287546,
 392565913,
 -1,
 -59534,
 393222243,
 65586,
 -59533,
 393287634,
 65585,
 -59532,
 393352854,
 65546,
 -59531,
 393418027,
 65565,
 -59530,
 393483359,
 65591,
 -59529,
 393548645,
 65578,
 -59528,
 393613831,
 65564,
 -59527,
 393678987,
 65545,
 -1,
 393744365,
 65570,
 393942916,
 393220482,
 -1,
 -59524,
 393877582,
 65606,
 -59523,
 393942900,
 65538,
 -59522,
 394008313,
 65577,
 -59521,
 394073624,
 65580,
 -59520,
 394138779,
 65600,
 -59519,
 394204207,
 65562,
 -59518,
 394269494,
 65560,
 -59517,
 394334472,
 65573,
 -1,
 394399792,
 65599,
 394598286,
 393875282,
 -1,
 -59514,
 394532948,
 65582,
 -59513,
 394598208,
 65536,
 -59512,
 394663535,
 65543,
 -59511,
 394728948,
 65561,
 -59510,
 394794298,
 65589,
 -59509,
 394859593,
 65587,
 -59508,
 394924880,
 65566,
 -59507,
 394990141,
 65579,
 -1,
 395055233,
 65541,
 395253655,
 394532238,
 -1,
 -59504,
 395188333,
 65590,
 -59503,
 395253708,
 65610,
 -59502,
 395318957,
 65553,
 -59501,
 395384366,
 65611,
 -59500,
 395449568,
 65550,
 -59499,
 395514418,
 65607,
 -59498,
 395579621,
 65539,
 -1,
 395644914,
 65576,
 395843488,
 395187141,
 -1,
 -59495,
 395777966,
 65605,
 -59494,
 395843009,
 65547,
 -59493,
 395908291,
 65542,
 -59492,
 395973619,
 65552,
 -59491,
 396038825,
 65601,
 -59490,
 396104279,
 65594,
 -59489,
 396169495,
 65583,
 -1,
 396234790,
 65593,
 396433321,
 395776679,
 -1,
 -59486,
 396367945,
 65568,
 -59485,
 396433230,
 65537,
 -59484,
 396498686,
 65588,
 -59483,
 396563910,
 65549,
 -59482,
 396628831,
 65609,
 -59481,
 396694072,
 65574,
 -59480,
 396759314,
 65581,
 -1,
 396824532,
 65563,
 397023154,
 396365915,
 -1,
 -59477,
 396957454,
 65596,
 -59476,
 397022733,
 65571,
 -59475,
 397088024,
 65559,
 -59474,
 397153247,
 65544,
 -59473,
 397218596,
 65557,
 -59472,
 397283912,
 65584,
 -59471,
 397349123,
 65569,
 -1,
 397414404,
 65540,
 397612983,
 396957502,
 -1,
 -59468,
 397547267,
 65612,
 -59467,
 397612197,
 65602,
 -59466,
 397676750,
 65555,
 -1,
 397742011,
 65556,
 398000127,
 397547503,
 -1,
 -59463,
 397873447,
 65613,
 -1,
 397938542,
 65604,
 398196735,
 392526315,
 -1,
 398202816,
 398071614,
 -1,
 -59459,
 398137327,
 65629,
 -59458,
 398202254,
 65628,
 -59457,
 398267047,
 65627,
 -1,
 398332290,
 65626,
 398530499,
 398136718,
 -1,
 -59454,
 398463941,
 65624,
 -1,
 398529191,
 65623,
 398727110,
 398463941,
 -1,
 -59451,
 398661615,
 65621,
 -1,
 398726750,
 65620,
 398923721,
 398659675,
 -1,
 -59448,
 398858223,
 65617,
 -1,
 398923582,
 65616,
 -59446,
 398858022,
 65625,
 -59445,
 399054206,
 65622,
 -59444,
 399119289,
 65619,
 -1,
 399184513,
 65618,
 399441919,
 392461749,
 -1,
 399448022,
 399315035,
 -1,
 399513554,
 399381159,
 -1,
 -59439,
 399447313,
 65689,
 -1,
 399512238,
 65688,
 399710165,
 399446402,
 -1,
 -59436,
 399644545,
 65684,
 -1,
 399709862,
 65683,
 -1,
 399644033,
 65700,
 -1,
 399381127,
 65746,
 400097279,
 356843520,
 -1,
 400103386,
 400012605,
 983068,
 -1,
 400033982,
 983142,
 -1,
 400050346,
 983062,
 400359423,
 356804637,
 -1,
 -59427,
 400244470,
 128391,
 -1,
 400296253,
 128279,
 400496699,
 356742924,
 -1,
 400562234,
 400435741,
 -1,
 400627721,
 400519550,
 -1,
 400693221,
 400602245,
 -1,
 -59421,
 400661699,
 6430,
 -59420,
 400708110,
 6412,
 -1,
 400758950,
 6411,
 400955369,
 400664741,
 -1,
 -59417,
 400927024,
 6426,
 -59416,
 400970254,
 6425,
 -1,
 401021094,
 6427,
 401217517,
 400903444,
 -1,
 -59413,
 401199910,
 6429,
 -59412,
 401232398,
 6404,
 -1,
 401283238,
 6403,
 401479663,
 401199835,
 6421,
 -1,
 401440570,
 6410,
 401610738,
 401445670,
 -1,
 -59407,
 401560078,
 6417,
 -1,
 401610918,
 6416,
 401807349,
 401571642,
 -1,
 -59404,
 401755491,
 6405,
 -1,
 401807526,
 6415,
 402003960,
 401762333,
 -1,
 -59401,
 401953294,
 6402,
 -1,
 402004134,
 6401,
 402200571,
 401958646,
 -1,
 -59398,
 402149902,
 6409,
 -1,
 402200742,
 6408,
 402397182,
 402142392,
 -1,
 -59395,
 402346510,
 6414,
 -1,
 402397350,
 6413,
 402593793,
 402336409,
 -1,
 -59392,
 402543118,
 6407,
 -1,
 402593958,
 6406,
 402790404,
 402531620,
 -1,
 -59389,
 402739726,
 6419,
 -1,
 402790566,
 6418,
 -59387,
 402770766,
 6424,
 -59386,
 402955459,
 6422,
 -59385,
 403011426,
 6420,
 -59384,
 403074013,
 6423,
 -1,
 403132942,
 6428,
 403314718,
 400599205,
 -1,
 403380245,
 403273855,
 -1,
 403445774,
 403341114,
 -1,
 -59379,
 403393891,
 6449,
 -1,
 403445926,
 6452,
 -59377,
 403420423,
 6451,
 -59376,
 403610819,
 6455,
 -59375,
 403673980,
 6453,
 -59374,
 403732322,
 6454,
 -59373,
 403794909,
 6456,
 -59372,
 403859567,
 6448,
 -1,
 403906610,
 6450,
 404101146,
 403332545,
 -1,
 -59369,
 404072763,
 6459,
 -59368,
 404127359,
 6457,
 -59367,
 404190470,
 6464,
 -1,
 404253096,
 6458,
 404488191,
 404078620,
 -1,
 -59364,
 404411099,
 6441,
 -59363,
 404474702,
 6443,
 -1,
 404528323,
 6442,
 404690986,
 403294819,
 -1,
 404756521,
 404621526,
 -1,
 404822051,
 404691110,
 6432,
 -59358,
 404799259,
 6438,
 -1,
 404838979,
 6436,
 405018661,
 404784574,
 6440,
 -1,
 404981182,
 6437,
 405149735,
 404962478,
 6439,
 -1,
 405093550,
 6435,
 -59352,
 405126939,
 6434,
 -1,
 405232195,
 6433,
 -1,
 404688387,
 6400,
 405477432,
 404633498,
 -1,
 405542958,
 405451909,
 -1,
 -59347,
 405524427,
 6472,
 -1,
 405559515,
 6473,
 405739569,
 405514405,
 -1,
 -59344,
 405694071,
 6476,
 -1,
 405751278,
 6477,
 405936180,
 405686222,
 -1,
 -59341,
 405901160,
 6474,
 -1,
 405956051,
 6475,
 -59339,
 405919102,
 6470,
 -59338,
 406096312,
 6471,
 -59337,
 406159963,
 6479,
 -1,
 406208622,
 6478,
 -59335,
 405445629,
 6469,
 -1,
 406341329,
 6468,
 -1,
 400516479,
 13007,
 406591611,
 400470890,
 -1,
 406657144,
 406548862,
 -1,
 406722635,
 406631557,
 -1,
 406788166,
 406686140,
 -1,
 406853701,
 406748973,
 -1,
 -59327,
 406829307,
 42232,
 -59326,
 406880144,
 42236,
 -59325,
 406939527,
 42237,
 -59324,
 406992047,
 42234,
 -1,
 407054534,
 42235,
 -1,
 406814620,
 42233,
 407312457,
 406759589,
 -1,
 -59320,
 407261710,
 42206,
 -1,
 407312550,
 42205,
 -59318,
 407261710,
 42197,
 -1,
 407443622,
 42196,
 407640142,
 406699803,
 42228,
 -59315,
 407589368,
 42230,
 -1,
 407649454,
 42229,
 407836753,
 407622853,
 -1,
 -59312,
 407785998,
 42211,
 -1,
 407836838,
 42212,
 408033364,
 407808165,
 -1,
 -59309,
 407982606,
 42219,
 -1,
 408033446,
 42210,
 408229975,
 407999270,
 -1,
 -59306,
 408179214,
 42194,
 -1,
 408230054,
 42193,
 408426585,
 408192446,
 42227,
 -1,
 408370350,
 42231,
 408557660,
 408387386,
 -1,
 -59301,
 408505699,
 42213,
 -1,
 408557734,
 42208,
 408754271,
 408512541,
 -1,
 -59298,
 408703502,
 42200,
 -1,
 408754342,
 42199,
 408950882,
 408703480,
 -1,
 -59295,
 408900110,
 42216,
 -1,
 408950950,
 42214,
 409147493,
 408898836,
 -1,
 -59292,
 409096718,
 42221,
 -1,
 409147558,
 42198,
 409344103,
 409091246,
 42224,
 -1,
 409321243,
 42225,
 409475178,
 409285816,
 -1,
 -59287,
 409457877,
 42204,
 -1,
 409475238,
 42195,
 409671789,
 409414297,
 -1,
 -59284,
 409621006,
 42203,
 -1,
 409671846,
 42202,
 409868399,
 409606310,
 42222,
 -1,
 409812142,
 42223,
 -59280,
 409850587,
 42220,
 -59279,
 409981370,
 42215,
 -59278,
 410045262,
 42218,
 -59277,
 410089314,
 42207,
 -59276,
 410151901,
 42209,
 -59275,
 410216212,
 42201,
 -59274,
 410278467,
 42226,
 -59273,
 410339363,
 42217,
 -1,
 410395993,
 42192,
 410648575,
 406624796,
 -1,
 -59270,
 410537219,
 42239,
 -1,
 410595518,
 42238,
 410785939,
 406539540,
 -1,
 410851474,
 410737049,
 -1,
 410917008,
 410779648,
 -1,
 410982533,
 410863566,
 -1,
 411048066,
 410947541,
 -1,
 -59263,
 411021764,
 128964,
 -1,
 411055248,
 11212,
 411303935,
 411002327,
 -1,
 -59260,
 411218122,
 128943,
 -1,
 411277268,
 128969,
 411441288,
 410956933,
 -1,
 -59257,
 411421808,
 128978,
 -1,
 411457896,
 128960,
 411637899,
 411412645,
 -1,
 -59254,
 411592334,
 128949,
 -1,
 411639385,
 128937,
 -59252,
 411618746,
 128910,
 -59251,
 411802922,
 128648,
 -59250,
 411849022,
 128930,
 -59249,
 411910289,
 128955,
 -1,
 411970902,
 128504,
 412221439,
 410878607,
 128498,
 -1,
 412090780,
 128497,
 -1,
 410788897,
 128626,
 412358805,
 410753478,
 128482,
 -1,
 412334366,
 128132,
 -59242,
 412338909,
 8374,
 -1,
 412453181,
 129409,
 412621591,
 356653222,
 -1,
 412687098,
 412596735,
 -1,
 412752400,
 412657829,
 -1,
 412817917,
 412710960,
 -1,
 412883450,
 412774782,
 -1,
 412948672,
 412857477,
 -1,
 413014196,
 412925723,
 -1,
 413079731,
 412984881,
 -1,
 413145255,
 413042110,
 -1,
 413210788,
 413088942,
 7444,
 413335551,
 413141768,
 -1,
 -59229,
 413250278,
 43841,
 -1,
 413292573,
 43842,
 413472934,
 413140280,
 43843,
 -1,
 413404564,
 43844,
 -1,
 413439308,
 7432,
 413669546,
 413124264,
 -1,
 -59223,
 413618431,
 983615,
 -1,
 413670069,
 983616,
 413866156,
 413620803,
 7433,
 -1,
 413828174,
 42879,
 413997230,
 413815290,
 686,
 -1,
 413925567,
 687,
 -59217,
 413974945,
 43857,
 -59216,
 414096524,
 11385,
 -59215,
 414149551,
 42881,
 -59214,
 414207252,
 7543,
 -1,
 414260014,
 7426,
 -1,
 413038348,
 42871,
 414521528,
 412963320,
 -1,
 414587063,
 414485881,
 42853,
 -1,
 414517652,
 42855,
 -1,
 414518656,
 7546,
 414783676,
 414452488,
 -1,
 -59206,
 414743609,
 7541,
 -59205,
 414791516,
 11366,
 -1,
 414856249,
 566,
 -59203,
 414766277,
 42793,
 -59202,
 415015183,
 42795,
 -59201,
 415075203,
 7446,
 -1,
 415112321,
 11383,
 415307995,
 412919973,
 -1,
 415373512,
 415259686,
 -1,
 415439045,
 415335870,
 7441,
 -59196,
 415405419,
 7442,
 -1,
 415436180,
 7443,
 -59194,
 415416091,
 7453,
 -59193,
 415612415,
 7455,
 -1,
 415643436,
 7454,
 415832273,
 415312537,
 -1,
 415897805,
 415802740,
 -1,
 415963340,
 415865935,
 43851,
 -1,
 415894864,
 43852,
 -1,
 415911216,
 43830,
 416219135,
 415848990,
 -1,
 -59185,
 416129311,
 7573,
 -59184,
 416174335,
 983617,
 -1,
 416225973,
 983618,
 416422103,
 415763208,
 -1,
 -59181,
 416401542,
 983575,
 -59180,
 416461814,
 575,
 -59179,
 416519133,
 7562,
 -59178,
 416581151,
 42921,
 -1,
 416644153,
 7540,
 416815322,
 416356518,
 -1,
 -59175,
 416773774,
 42892,
 -1,
 416836073,
 43872,
 -1,
 416791104,
 43845,
 417077495,
 415251630,
 -1,
 417143022,
 417008392,
 -1,
 417208545,
 417122438,
 983555,
 417333247,
 417136711,
 -1,
 -59168,
 417222911,
 983557,
 -1,
 417274549,
 983559,
 417470692,
 417171269,
 -1,
 -59165,
 417446238,
 983585,
 -1,
 417471157,
 983583,
 417667303,
 417413297,
 -1,
 -59162,
 417642846,
 983589,
 -1,
 417667765,
 983587,
 417863914,
 417607431,
 -1,
 -59159,
 417822603,
 983561,
 -1,
 417868746,
 983563,
 -59157,
 417837798,
 583,
 -59156,
 418029855,
 7570,
 -59155,
 418087832,
 11384,
 -1,
 418138796,
 43828,
 418322673,
 417114935,
 -1,
 -59152,
 418291999,
 7576,
 -1,
 418354141,
 7563,
 418519284,
 418271721,
 -1,
 -59149,
 418475769,
 42787,
 -1,
 418537160,
 42789,
 -59147,
 418502078,
 7578,
 -59146,
 418690181,
 42859,
 -1,
 418742721,
 43836,
 418912529,
 417028675,
 -1,
 418978051,
 418873146,
 -1,
 419043584,
 418952116,
 -1,
 -59141,
 419017861,
 42887,
 -59140,
 419080357,
 42885,
 -59139,
 419142735,
 42883,
 -59138,
 419187988,
 7545,
 -59137,
 419252174,
 42876,
 -1,
 419312824,
 42874,
 419561471,
 419022913,
 -1,
 -59134,
 419464924,
 43840,
 -1,
 419503657,
 43876,
 419698957,
 418908936,
 -1,
 419764488,
 419641521,
 -1,
 -59130,
 419739998,
 983591,
 -59129,
 419778815,
 983590,
 -1,
 419830453,
 983566,
 420026635,
 419727185,
 -1,
 -59126,
 420002142,
 983595,
 -1,
 420027061,
 983593,
 -59124,
 419995935,
 7574,
 -1,
 420181918,
 983565,
 420354320,
 419663370,
 -1,
 -59121,
 420306059,
 43873,
 -1,
 420354340,
 7548,
 -1,
 420325541,
 42861,
 420616484,
 418889499,
 -1,
 420682015,
 420544512,
 -1,
 420747550,
 420662881,
 -1,
 420813080,
 420706194,
 -1,
 -59114,
 420788574,
 983611,
 -59113,
 420827391,
 983577,
 -1,
 420879029,
 983609,
 421075227,
 420775749,
 -1,
 -59110,
 421050718,
 983607,
 -1,
 421075637,
 983605,
 -59108,
 421047485,
 43854,
 -59107,
 421241119,
 7577,
 -1,
 421293958,
 43858,
 -1,
 420685307,
 43855,
 -59104,
 420649424,
 7551,
 -59103,
 421496254,
 43875,
 -59102,
 421558028,
 42872,
 -59101,
 421616195,
 43856,
 -1,
 421674158,
 7531,
 421861687,
 420584527,
 -1,
 421927217,
 421789696,
 -1,
 421992752,
 421908060,
 -1,
 422058287,
 421920768,
 -1,
 -59095,
 422033758,
 983603,
 -59094,
 422097638,
 589,
 -59093,
 422155229,
 7561,
 -59092,
 422217247,
 42919,
 -59091,
 422280249,
 7538,
 -59090,
 422332864,
 7539,
 -1,
 422392555,
 43849,
 -1,
 422023229,
 43847,
 -1,
 421963574,
 42843,
 422713653,
 421873251,
 -1,
 422779188,
 422652569,
 8580,
 -1,
 422710221,
 42815,
 -1,
 422743007,
 7572,
 423034879,
 422691362,
 42869,
 -1,
 422905989,
 42845,
 423106892,
 421823934,
 -1,
 423172417,
 423073095,
 -1,
 423237952,
 423134654,
 -1,
 423303487,
 423168776,
 -1,
 -59076,
 423277286,
 43839,
 -59075,
 423338271,
 7575,
 -59074,
 423383295,
 983613,
 -1,
 423434933,
 983614,
 -1,
 423247022,
 43874,
 -1,
 423181688,
 7571,
 423762250,
 423103240,
 -1,
 423827782,
 423741574,
 983569,
 423952383,
 423755847,
 -1,
 -59067,
 423842047,
 983571,
 -1,
 423893685,
 983573,
 424148991,
 423785620,
 -1,
 -59064,
 424069937,
 11386,
 -59063,
 424119168,
 42829,
 -1,
 424182191,
 42827,
 -59061,
 423724478,
 42831,
 -1,
 424311517,
 42935,
 424483166,
 423041190,
 -1,
 424548694,
 424411136,
 -1,
 424614229,
 424529505,
 -1,
 424679762,
 424576837,
 -1,
 -59055,
 424655198,
 983581,
 -1,
 424680117,
 983579,
 -59053,
 424653542,
 11365,
 -59052,
 424845599,
 7567,
 -1,
 424900510,
 983553,
 -1,
 424583545,
 43825,
 425138520,
 424527517,
 42809,
 -1,
 425069679,
 42811,
 -59047,
 425120386,
 42813,
 -59046,
 425246491,
 42807,
 -59045,
 425297342,
 42805,
 -59044,
 425358912,
 7568,
 -59043,
 425409880,
 983612,
 -1,
 425466022,
 42803,
 425662831,
 424438703,
 -1,
 425728362,
 425593608,
 -1,
 425793891,
 425671087,
 -1,
 -59038,
 425753657,
 43832,
 -1,
 425797074,
 11361,
 -59036,
 425769310,
 983599,
 -59035,
 425959726,
 42894,
 -59034,
 426021853,
 7557,
 -59033,
 426081255,
 43833,
 -59032,
 426140417,
 43831,
 -59031,
 426202646,
 42825,
 -1,
 426259513,
 564,
 426449261,
 425691785,
 -1,
 -59028,
 426399254,
 7837,
 -1,
 426456924,
 7836,
 -59026,
 426426914,
 42866,
 -1,
 426590826,
 43829,
 426776960,
 425600292,
 -1,
 426842484,
 426732604,
 -1,
 426908019,
 426804670,
 43837,
 -1,
 426839444,
 43838,
 -1,
 426851502,
 43826,
 427104633,
 426776742,
 -1,
 427170168,
 427075428,
 -1,
 -59017,
 427113646,
 43827,
 -1,
 427171369,
 43824,
 -1,
 427141772,
 43853,
 427432317,
 427035400,
 -1,
 -59013,
 427398109,
 7552,
 -59012,
 427457593,
 7532,
 -1,
 427510444,
 42903,
 -59010,
 427402872,
 42823,
 -59009,
 427658925,
 7447,
 -1,
 427705595,
 42933,
 427891085,
 426755741,
 -1,
 427956614,
 427821832,
 -1,
 -59005,
 427926238,
 11377,
 -59004,
 427987933,
 7564,
 -59003,
 428029788,
 42847,
 -1,
 428094521,
 11380,
 428284298,
 427919397,
 -1,
 -59000,
 428261718,
 42911,
 -58999,
 428312284,
 42909,
 -1,
 428350254,
 42907,
 -58997,
 428266114,
 42849,
 -58996,
 428500150,
 42851,
 -1,
 428556827,
 42857,
 428743066,
 427832504,
 -1,
 428808595,
 428673800,
 -1,
 -58992,
 428774365,
 7553,
 -58991,
 428833849,
 7533,
 -58990,
 428890001,
 7569,
 -1,
 428946489,
 545,
 429136279,
 428770750,
 -1,
 429201814,
 429113472,
 43848,
 -1,
 429132658,
 43850,
 -1,
 429177455,
 567,
 -58984,
 429113890,
 42865,
 -58983,
 429343035,
 7839,
 -1,
 429401385,
 568,
 429595046,
 428681881,
 -1,
 429660575,
 429544838,
 43859,
 429785087,
 429591776,
 -1,
 -58978,
 429695782,
 43860,
 -1,
 429748164,
 43861,
 429922723,
 429591304,
 -1,
 -58975,
 429896422,
 572,
 -58974,
 429954013,
 42900,
 -1,
 429991378,
 42899,
 430184869,
 429899769,
 42797,
 -1,
 430115686,
 42799,
 -1,
 430147894,
 42863,
 430381489,
 429555514,
 -1,
 430447023,
 430312200,
 -1,
 430512555,
 430385817,
 -1,
 -58966,
 430491022,
 565,
 -1,
 430548736,
 43835,
 -58964,
 430478301,
 7559,
 -58963,
 430671391,
 42917,
 -58962,
 430734393,
 7536,
 -1,
 430782107,
 42897,
 -58960,
 430424610,
 42868,
 -1,
 430918980,
 983567,
 431102395,
 430339852,
 -1,
 431167927,
 431033096,
 -1,
 -58956,
 431143262,
 983601,
 -58955,
 431199197,
 7558,
 -58954,
 431258681,
 7535,
 -1,
 431305451,
 43834,
 431495610,
 431119358,
 -1,
 -58951,
 431474333,
 7933,
 -1,
 431518701,
 7931,
 -1,
 431473186,
 42867,
 431757763,
 431068017,
 -1,
 431823296,
 431728805,
 -1,
 431888831,
 431799540,
 7549,
 -1,
 431819156,
 42833,
 -1,
 431856706,
 42837,
 -58943,
 431789021,
 7560,
 -58942,
 432045113,
 7537,
 -1,
 432097964,
 42835,
 432282059,
 431712329,
 -1,
 432347590,
 432255718,
 42817,
 -1,
 432275560,
 42821,
 432478665,
 432288952,
 -1,
 -58936,
 432429777,
 42819,
 -1,
 432489616,
 11370,
 -58934,
 432444381,
 7556,
 -1,
 432637471,
 42915,
 432806356,
 432230904,
 -1,
 432871887,
 432769830,
 -1,
 -58930,
 432820479,
 983619,
 -1,
 432872117,
 983620,
 433068498,
 432802568,
 -1,
 -58927,
 433034205,
 42901,
 -1,
 433075867,
 11368,
 -58925,
 433013339,
 42791,
 -1,
 433200591,
 11382,
 433396188,
 432787886,
 -1,
 433461723,
 433353876,
 -1,
 433527258,
 433422755,
 43863,
 433651711,
 433455104,
 -1,
 -58919,
 433573624,
 43865,
 -1,
 433594079,
 43864,
 -1,
 433507108,
 43862,
 -1,
 433427421,
 7565,
 433920481,
 433378503,
 -1,
 -58914,
 433894390,
 576,
 -58913,
 433951709,
 7566,
 -58912,
 434011193,
 7542,
 -1,
 434058907,
 11372,
 434248167,
 433887912,
 -1,
 434313702,
 434178824,
 -1,
 -58908,
 434287391,
 42839,
 -58907,
 434329503,
 587,
 -1,
 434386780,
 42841,
 -1,
 434279211,
 569,
 434641389,
 434195732,
 -1,
 434706923,
 434572040,
 -1,
 -58902,
 434672605,
 7555,
 -1,
 434734623,
 42913,
 -58900,
 434664791,
 578,
 -1,
 434852366,
 983199,
 435034610,
 434623183,
 -1,
 435100145,
 435005605,
 -1,
 -58896,
 435076340,
 591,
 -1,
 435116129,
 43866,
 -1,
 435057946,
 7935,
 435362294,
 434980863,
 -1,
 -58892,
 435335910,
 42905,
 -58891,
 435393501,
 7554,
 -1,
 435452985,
 7534,
 435624441,
 435316472,
 -1,
 -58888,
 435598054,
 585,
 -1,
 435632320,
 983597,
 -1,
 435604287,
 11379,
 435945471,
 412822425,
 -1,
 -58884,
 435863412,
 7550,
 -1,
 435903143,
 7547,
 436142079,
 412795082,
 -1,
 436148736,
 436054181,
 8347,
 -1,
 436088351,
 8340,
 -58879,
 436130206,
 8339,
 -58878,
 436258461,
 7525,
 -58877,
 436322075,
 7524,
 -58876,
 436384901,
 8348,
 -58875,
 436444239,
 7523,
 -58874,
 436507430,
 8346,
 -58873,
 436569534,
 8338,
 -58872,
 436633402,
 8345,
 -58871,
 436696844,
 8344,
 -58870,
 436759471,
 8343,
 -58869,
 436824093,
 8342,
 -58868,
 436889334,
 11388,
 -58867,
 436951619,
 7522,
 -58866,
 437015032,
 8341,
 -58865,
 437075118,
 8337,
 -1,
 437131430,
 8336,
 437328586,
 412691353,
 -1,
 437393952,
 437302405,
 -1,
 437459483,
 437372317,
 -1,
 437525013,
 437393574,
 11375,
 -1,
 437483067,
 11376,
 -58858,
 437503645,
 581,
 -58857,
 437630085,
 42929,
 -58856,
 437676975,
 42880,
 -58855,
 437741597,
 42928,
 -58854,
 437805635,
 42878,
 -1,
 437867000,
 42893,
 438049309,
 437409858,
 42852,
 -1,
 437979540,
 42854,
 -58850,
 438031557,
 42792,
 -58849,
 438149391,
 42794,
 -1,
 438176695,
 574,
 438377012,
 437337262,
 -1,
 438442544,
 438307592,
 -1,
 438508070,
 438421638,
 983554,
 438632447,
 438435911,
 -1,
 -58843,
 438522111,
 983556,
 -1,
 438573749,
 983558,
 438770217,
 438470469,
 -1,
 -58840,
 438745438,
 983584,
 -1,
 438770357,
 983582,
 438966828,
 438712497,
 -1,
 -58837,
 438942046,
 983588,
 -1,
 438966965,
 983586,
 439163439,
 438906631,
 -1,
 -58834,
 439121803,
 983560,
 -1,
 439167946,
 983562,
 -1,
 439136998,
 582,
 439425587,
 438391273,
 -1,
 -58830,
 439381753,
 42786,
 -1,
 439443144,
 42788,
 -1,
 439399557,
 42858,
 439687746,
 438311078,
 -1,
 439753275,
 439618312,
 -1,
 439818809,
 439715653,
 -1,
 -58824,
 439794014,
 983580,
 -1,
 439818933,
 983578,
 -58822,
 439792358,
 570,
 -1,
 439973790,
 983552,
 440146493,
 439731869,
 42808,
 -1,
 440077423,
 42810,
 -58818,
 440128130,
 42812,
 -58817,
 440254235,
 42806,
 -58816,
 440305086,
 42804,
 -58815,
 440366651,
 11373,
 -1,
 440408230,
 42802,
 440605264,
 439638595,
 -1,
 440670794,
 440566854,
 -1,
 -58811,
 440644741,
 42886,
 -58810,
 440707237,
 42884,
 -58809,
 440769615,
 42882,
 -58808,
 440814868,
 42877,
 -58807,
 440879054,
 42875,
 -1,
 440939704,
 42873,
 441129551,
 440601352,
 -1,
 441195086,
 441091909,
 -1,
 -58803,
 441170270,
 983594,
 -1,
 441195189,
 983592,
 -1,
 441153438,
 983564,
 -1,
 441100453,
 42860,
 441522781,
 440573007,
 -1,
 441588313,
 441450496,
 -1,
 441653848,
 441568865,
 -1,
 441719382,
 441627781,
 -1,
 -58795,
 441671195,
 983602,
 -1,
 441719923,
 11364,
 -58793,
 441692902,
 588,
 -1,
 441878047,
 42918,
 -1,
 441624374,
 42842,
 442112604,
 441534051,
 -1,
 -58789,
 442076120,
 42923,
 -1,
 442116790,
 42814,
 -1,
 442090029,
 42844,
 442374758,
 441501341,
 -1,
 442440290,
 442337317,
 -1,
 -58784,
 442417494,
 42910,
 -58783,
 442468060,
 42908,
 -1,
 442506030,
 42906,
 -58781,
 442421890,
 42848,
 -58780,
 442655926,
 42850,
 -58779,
 442712603,
 42856,
 -1,
 442764215,
 42846,
 442964591,
 442345637,
 -1,
 443030123,
 442895112,
 -1,
 -58775,
 443009158,
 983574,
 -58774,
 443069430,
 11390,
 -1,
 443123231,
 42920,
 -58772,
 442988684,
 586,
 -58771,
 443241467,
 7838,
 -58770,
 443298468,
 42924,
 -1,
 443358801,
 42891,
 443554426,
 442926526,
 -1,
 443619960,
 443484936,
 -1,
 443685493,
 443598982,
 983568,
 443809791,
 443613255,
 -1,
 -58764,
 443699455,
 983570,
 -1,
 443751093,
 983572,
 444006399,
 443643028,
 -1,
 -58761,
 443911040,
 42828,
 -1,
 443974063,
 42826,
 -58759,
 443581886,
 42830,
 -1,
 444103389,
 42934,
 444275332,
 443531037,
 -1,
 444340867,
 444255841,
 -1,
 444406400,
 444299154,
 -1,
 -58754,
 444381534,
 983610,
 -58753,
 444420351,
 983576,
 -1,
 444471989,
 983608,
 444727295,
 444368709,
 -1,
 -58750,
 444643678,
 983606,
 -1,
 444668597,
 983604,
 -1,
 444278226,
 580,
 444930700,
 444230589,
 -1,
 444996232,
 444867876,
 -1,
 -58745,
 444940599,
 42925,
 -1,
 444997802,
 573,
 -58743,
 444971358,
 983598,
 -58742,
 445152313,
 11362,
 -58741,
 445208086,
 42824,
 -1,
 445266375,
 11360,
 445454996,
 444869273,
 -1,
 445520527,
 445431801,
 42796,
 -1,
 445451110,
 42798,
 445651602,
 445451016,
 -1,
 -58735,
 445625062,
 571,
 -1,
 445654482,
 42898,
 -58733,
 445614390,
 42862,
 -1,
 445797766,
 42931,
 445979291,
 445409353,
 -1,
 446044823,
 445952742,
 42816,
 -1,
 445972584,
 42820,
 446175898,
 445985976,
 -1,
 -58727,
 446126801,
 42818,
 -1,
 446186640,
 11369,
 -1,
 446137887,
 42914,
 446438049,
 445944689,
 -1,
 446503584,
 446408869,
 -1,
 446569119,
 446479604,
 11363,
 -1,
 446499220,
 42832,
 -1,
 446536770,
 42836,
 -1,
 446450348,
 42834,
 446831272,
 446396172,
 -1,
 446896805,
 446782462,
 -1,
 -58716,
 446875293,
 7932,
 -1,
 446919661,
 7930,
 447152127,
 446827272,
 -1,
 -58713,
 447068510,
 983600,
 -1,
 447109004,
 11374,
 447290030,
 446779896,
 -1,
 447355564,
 447220488,
 -1,
 -58709,
 447305612,
 42922,
 -1,
 447362715,
 11367,
 -58707,
 447300187,
 42790,
 -1,
 447487439,
 11381,
 447683252,
 447227172,
 -1,
 447748786,
 447613704,
 -1,
 -58703,
 447722214,
 579,
 -1,
 447761068,
 42902,
 -58701,
 447719032,
 42822,
 -1,
 447890683,
 42932,
 448076472,
 447637240,
 -1,
 -58698,
 448051550,
 983596,
 -58697,
 448115430,
 584,
 -1,
 448148203,
 42930,
 448338620,
 448023828,
 -1,
 -58694,
 448296279,
 577,
 -58693,
 448352782,
 983198,
 -1,
 448400619,
 42912,
 448600767,
 448320711,
 -1,
 -58690,
 448574454,
 11391,
 -1,
 448607899,
 11371,
 448797378,
 448582351,
 -1,
 -58687,
 448770790,
 590,
 -1,
 448820506,
 7934,
 448993989,
 448764586,
 -1,
 -58684,
 448967455,
 42838,
 -1,
 449001308,
 42840,
 449190600,
 448954217,
 -1,
 -58681,
 449152543,
 42916,
 -1,
 449197723,
 42896,
 -58679,
 449170239,
 11378,
 -1,
 449333255,
 42904,
 449518321,
 437285246,
 -1,
 449583855,
 449489061,
 -1,
 449649390,
 449542250,
 -1,
 449714898,
 449623173,
 7451,
 449839103,
 449693085,
 -1,
 -58672,
 449748047,
 7450,
 -58671,
 449804044,
 43002,
 -1,
 449854638,
 11387,
 450042584,
 449682511,
 -1,
 450108118,
 449988195,
 -1,
 -58667,
 450075727,
 7449,
 -1,
 450133818,
 7438,
 -58665,
 450085410,
 42870,
 -1,
 450235712,
 43846,
 450435803,
 450004414,
 7439,
 -58662,
 450412315,
 7445,
 -1,
 450467179,
 7440,
 450632414,
 450378926,
 7431,
 -58659,
 450614715,
 7459,
 -1,
 450672467,
 7430,
 450829024,
 450566310,
 7424,
 -1,
 450772142,
 7425,
 -58655,
 450811077,
 7458,
 -58654,
 450939662,
 7457,
 -58653,
 451004061,
 7456,
 -58652,
 451067675,
 7452,
 -58651,
 451127461,
 42801,
 -58650,
 451187494,
 7448,
 -58649,
 451245836,
 7437,
 -58648,
 451308485,
 7436,
 -58647,
 451373085,
 7435,
 -58646,
 451438326,
 7434,
 -58645,
 451495886,
 42800,
 -58644,
 451556536,
 7429,
 -58643,
 451619481,
 7428,
 -1,
 451683871,
 7427,
 -1,
 449602008,
 42895,
 -58640,
 449563139,
 7460,
 -1,
 451878036,
 7461,
 452132863,
 449463120,
 -1,
 452139765,
 452043103,
 -1,
 -58636,
 452104998,
 43004,
 -1,
 452151246,
 43003,
 452336376,
 452090435,
 -1,
 -58633,
 452298076,
 43005,
 -1,
 452330567,
 43006,
 -58631,
 452308298,
 42999,
 -1,
 452468952,
 43007,
 452664073,
 412654671,
 -1,
 452729608,
 452611717,
 -1,
 452795137,
 452691390,
 -1,
 452860672,
 452755611,
 -1,
 -58625,
 452830438,
 68415,
 -1,
 452868349,
 68413,
 -1,
 452828688,
 128310,
 453122820,
 452771425,
 -1,
 -58621,
 453092625,
 68414,
 -1,
 453130543,
 68412,
 453319431,
 453060787,
 -1,
 -58618,
 453261164,
 128311,
 -1,
 453324373,
 128309,
 -1,
 453287914,
 128308,
 -1,
 452680302,
 8382,
 453647122,
 452625872,
 -1,
 453712653,
 453601851,
 -1,
 -58612,
 453674420,
 3807,
 -1,
 453726314,
 3806,
 453909264,
 453659352,
 -1,
 -58609,
 453871926,
 983204,
 -1,
 453911781,
 983205,
 -58607,
 453879351,
 983206,
 -1,
 454063252,
 983207,
 454236949,
 453620119,
 -1,
 -58604,
 454217335,
 127772,
 -1,
 454276162,
 127767,
 -58602,
 454179991,
 128030,
 -1,
 454371038,
 127991,
 454564860,
 412564654,
 -1,
 454630290,
 454511797,
 -1,
 454695787,
 454609827,
 -1,
 454761278,
 454669445,
 -1,
 454826800,
 454730236,
 -1,
 454892335,
 454757968,
 -1,
 454957869,
 454828516,
 11104,
 455081983,
 454885376,
 -1,
 455088939,
 455003745,
 -1,
 455154467,
 455046396,
 -1,
 -58590,
 455132357,
 11172,
 -1,
 455162715,
 11174,
 455351078,
 455096751,
 -1,
 -58587,
 455329962,
 983233,
 -1,
 455366685,
 11130,
 -58585,
 455330029,
 129072,
 -58584,
 455507928,
 129056,
 -58583,
 455572104,
 129060,
 -58582,
 455627947,
 129068,
 -1,
 455682319,
 129064,
 -58580,
 455064198,
 11120,
 -1,
 455840195,
 11136,
 -58578,
 454923206,
 11140,
 -1,
 455947732,
 11114,
 -1,
 454820141,
 129168,
 456203069,
 454807699,
 -1,
 456268604,
 456139242,
 -1,
 456334139,
 456248929,
 -1,
 456399673,
 456307845,
 -1,
 456465208,
 456334451,
 11067,
 456589311,
 456395528,
 -1,
 -58569,
 456509610,
 11068,
 -1,
 456538783,
 11069,
 -1,
 456434180,
 11244,
 -58566,
 456378538,
 11060,
 -1,
 456735391,
 11061,
 -1,
 456281185,
 11062,
 -1,
 456244450,
 11063,
 -1,
 456166296,
 129186,
 457120597,
 454697450,
 -1,
 457186127,
 457100897,
 -1,
 457251655,
 457159813,
 -1,
 457317188,
 457204602,
 -1,
 -58557,
 457295045,
 11025,
 -1,
 457325403,
 11024,
 457572351,
 457251959,
 -1,
 -58554,
 457492650,
 11065,
 -1,
 457521823,
 11066,
 457710410,
 457223863,
 -1,
 -58551,
 457686027,
 129024,
 -1,
 457720697,
 129040,
 -58549,
 457671582,
 129176,
 -58548,
 457865891,
 129028,
 -58547,
 457927971,
 129032,
 -58546,
 457982841,
 129044,
 -1,
 458045825,
 11064,
 458234708,
 457120235,
 -1,
 458300243,
 458203462,
 -1,
 -58542,
 458275172,
 11083,
 -1,
 458300931,
 11074,
 -1,
 458235395,
 11082,
 -1,
 458209455,
 11070,
 458627931,
 457057572,
 -1,
 458693465,
 458583048,
 -1,
 -58536,
 458632899,
 11144,
 -1,
 458695140,
 11013,
 -58534,
 458657491,
 129184,
 -1,
 458824285,
 129192,
 459021150,
 458598565,
 -1,
 -58531,
 458988403,
 129080,
 -1,
 459022319,
 129104,
 459217761,
 458988623,
 -1,
 -58528,
 459179633,
 128620,
 -1,
 459234666,
 129190,
 459414372,
 459166867,
 -1,
 -58525,
 459354365,
 129088,
 -1,
 459416036,
 129092,
 459610983,
 459360206,
 -1,
 -58522,
 459581117,
 129194,
 -1,
 459628861,
 129076,
 -58520,
 459590949,
 129172,
 -58519,
 459774746,
 11077,
 -58518,
 459829275,
 129188,
 -1,
 459878653,
 129084,
 460069770,
 454623232,
 -1,
 460135283,
 460037199,
 -1,
 460200818,
 460086573,
 -1,
 -58513,
 460180748,
 11012,
 -58512,
 460242001,
 11108,
 -58511,
 460302790,
 129112,
 -1,
 460335157,
 11020,
 -1,
 460135629,
 11788,
 460594040,
 460105893,
 -1,
 -58507,
 460570849,
 11778,
 -58506,
 460625196,
 128488,
 -58505,
 460676153,
 11814,
 -1,
 460721888,
 10181,
 460921725,
 460527782,
 -1,
 460987260,
 460892053,
 -1,
 -58501,
 460959501,
 11056,
 -1,
 460992152,
 11058,
 -1,
 460947957,
 128494,
 461249408,
 460895365,
 -1,
 -58497,
 461217330,
 11785,
 -1,
 461265033,
 128492,
 461446019,
 461204399,
 -1,
 -58494,
 461422976,
 128709,
 -1,
 461476451,
 11804,
 461642630,
 461387885,
 -1,
 -58491,
 461619311,
 11816,
 -1,
 461684029,
 11780,
 -58489,
 461623664,
 128398,
 -58488,
 461817951,
 11808,
 -58487,
 461853497,
 128379,
 -1,
 461909961,
 9948,
 462159871,
 460000747,
 -1,
 462166927,
 462047286,
 -1,
 462232462,
 462140394,
 4054,
 -1,
 462162920,
 4056,
 -1,
 462168469,
 1422,
 -58480,
 462142109,
 8294,
 -58479,
 462395446,
 128269,
 -1,
 462443378,
 9958,
 462625783,
 454595837,
 -1,
 462691273,
 462582142,
 -1,
 462756765,
 462664837,
 -1,
 462822296,
 462730373,
 -1,
 -58473,
 462770702,
 7246,
 -1,
 462821542,
 7245,
 463018907,
 462792869,
 -1,
 -58470,
 462967310,
 7192,
 -1,
 463018150,
 7191,
 -58468,
 462967310,
 7179,
 -1,
 463149222,
 7178,
 463346593,
 462721830,
 -1,
 -58465,
 463301597,
 7183,
 -58464,
 463360526,
 7184,
 -1,
 463411366,
 7182,
 463608741,
 463306554,
 -1,
 -58461,
 463590107,
 7177,
 -58460,
 463621475,
 7173,
 -1,
 463673510,
 7181,
 463870889,
 463562781,
 -1,
 -58457,
 463825885,
 7169,
 -58456,
 463884814,
 7170,
 -1,
 463935654,
 7168,
 464133037,
 463811768,
 -1,
 -58453,
 464114901,
 7193,
 -58452,
 464139590,
 7247,
 -1,
 464197798,
 7180,
 464395184,
 464103589,
 -1,
 -58449,
 464343566,
 7201,
 -1,
 464394406,
 7200,
 464591795,
 464353036,
 -1,
 -58446,
 464546781,
 7190,
 -1,
 464591014,
 7189,
 464788406,
 464540152,
 -1,
 -58443,
 464743389,
 7198,
 -1,
 464787622,
 7197,
 464985017,
 464735508,
 -1,
 -58440,
 464939997,
 7172,
 -1,
 464984230,
 7171,
 465181628,
 464930766,
 -1,
 -58437,
 465136605,
 7186,
 -1,
 465180838,
 7185,
 465378239,
 465119897,
 -1,
 -58434,
 465326606,
 7175,
 -1,
 465377446,
 7174,
 465574850,
 465315108,
 -1,
 -58431,
 465529821,
 7188,
 -1,
 465574054,
 7187,
 -58429,
 465556187,
 7194,
 -58428,
 465750862,
 7202,
 -58427,
 465815219,
 7199,
 -58426,
 465870019,
 7195,
 -58425,
 465923037,
 7196,
 -58424,
 465987348,
 7176,
 -1,
 466032806,
 7203,
 466230231,
 462632858,
 -1,
 466295757,
 466203781,
 -1,
 -58420,
 466276299,
 7234,
 -1,
 466311387,
 7235,
 466492368,
 466266277,
 -1,
 -58417,
 466445943,
 7238,
 -1,
 466503150,
 7239,
 466688979,
 466438094,
 -1,
 -58414,
 466653032,
 7236,
 -1,
 466707923,
 7237,
 -58412,
 466670974,
 7232,
 -58411,
 466848184,
 7233,
 -58410,
 466911835,
 7241,
 -1,
 466960494,
 7240,
 467147745,
 466170162,
 -1,
 467213274,
 467107642,
 7216,
 -1,
 467194838,
 7220,
 467344348,
 467167261,
 7213,
 -1,
 467279725,
 7221,
 -58403,
 467317893,
 7219,
 -58402,
 467442767,
 7218,
 -58401,
 467505958,
 7217,
 -58400,
 467564300,
 7214,
 -1,
 467626927,
 7215,
 467803113,
 467126938,
 -1,
 467868644,
 467779355,
 7210,
 -1,
 467844891,
 7211,
 467999718,
 467830206,
 7208,
 -1,
 467961278,
 7209,
 -58393,
 467950147,
 7207,
 -58392,
 468073646,
 7212,
 -1,
 468130132,
 7206,
 468327408,
 467769884,
 -1,
 468392942,
 468300933,
 -1,
 468458477,
 468364425,
 7231,
 -1,
 468386275,
 7230,
 -1,
 468392253,
 7227,
 -58385,
 468354450,
 7228,
 -1,
 468593883,
 7229,
 468844543,
 468297893,
 -1,
 468851700,
 468762652,
 -1,
 -58381,
 468832987,
 7204,
 -1,
 468884675,
 7205,
 469106687,
 468803009,
 -1,
 -58378,
 469016058,
 7222,
 -1,
 469075183,
 7223,
 -58376,
 462604228,
 127898,
 -58375,
 469207982,
 128006,
 -58374,
 469269915,
 127819,
 -58373,
 469317353,
 128210,
 -1,
 469375914,
 127811,
 469572664,
 454546050,
 -1,
 469638171,
 469511716,
 -1,
 469703681,
 469611653,
 66199,
 -58368,
 469677189,
 66200,
 -1,
 469717496,
 66185,
 469900291,
 469663546,
 66191,
 -1,
 469860154,
 66193,
 470031365,
 469858060,
 66190,
 -1,
 469989132,
 66192,
 470162439,
 469985309,
 66187,
 -1,
 470116381,
 66196,
 470293513,
 470105262,
 66177,
 -1,
 470253370,
 66202,
 470424587,
 470230308,
 66178,
 -1,
 470372856,
 66179,
 470555661,
 470358182,
 66176,
 -1,
 470515514,
 66201,
 -58354,
 470537413,
 66184,
 -58353,
 470667678,
 66204,
 -58352,
 470731534,
 66183,
 -58351,
 470794011,
 66194,
 -58350,
 470853797,
 66198,
 -58349,
 470916175,
 66197,
 -58348,
 470981288,
 66188,
 -58347,
 471044902,
 66195,
 -58346,
 471100335,
 66189,
 -58345,
 471164662,
 66186,
 -58344,
 471226947,
 66182,
 -58343,
 471290360,
 66203,
 -58342,
 471354644,
 66180,
 -1,
 471413944,
 66181,
 471662591,
 469579645,
 -1,
 471669815,
 471560574,
 -1,
 471735327,
 471643269,
 67887,
 -1,
 471708805,
 67892,
 471866401,
 471705765,
 67891,
 -1,
 471836837,
 67886,
 471997475,
 471826234,
 67883,
 -1,
 471957306,
 67896,
 472128549,
 471952303,
 67881,
 -1,
 472109698,
 67895,
 472259623,
 472071342,
 67876,
 -1,
 472219450,
 67894,
 472390697,
 472193190,
 67872,
 -1,
 472350522,
 67893,
 -58326,
 472371842,
 67879,
 -58325,
 472499869,
 67877,
 -58324,
 472563483,
 67888,
 -58323,
 472620111,
 67885,
 -58322,
 472685224,
 67890,
 -58321,
 472745406,
 67884,
 -58320,
 472807180,
 67882,
 -58319,
 472868893,
 67880,
 -58318,
 472930883,
 67878,
 -58317,
 472993044,
 67874,
 -58316,
 473057230,
 67889,
 -58315,
 473117880,
 67875,
 -58314,
 473180825,
 67897,
 -1,
 473244964,
 67873,
 -1,
 471645321,
 67903,
 473504849,
 469534142,
 -1,
 473570372,
 473484046,
 -1,
 473635907,
 473514898,
 -1,
 473701442,
 473591593,
 -1,
 473766975,
 473666342,
 -1,
 -58306,
 473711111,
 128393,
 -1,
 473767064,
 128396,
 -58304,
 473713495,
 128395,
 -58303,
 473903699,
 128397,
 -1,
 473965991,
 128394,
 -1,
 473670482,
 128318,
 -1,
 473563529,
 128261,
 474291273,
 473509703,
 128274,
 474356808,
 474243360,
 -1,
 -58297,
 474338686,
 983079,
 -1,
 474384824,
 983076,
 -1,
 474287273,
 128271,
 474618956,
 474269569,
 -1,
 -58293,
 474575223,
 128140,
 -1,
 474634367,
 127977,
 474815567,
 474579350,
 -1,
 -58290,
 474771719,
 11059,
 -1,
 474822692,
 10188,
 -58288,
 474792261,
 128557,
 -1,
 474969180,
 127853,
 475143254,
 473472079,
 -1,
 -58285,
 475104702,
 983221,
 -58284,
 475166476,
 983216,
 -58283,
 475224643,
 983226,
 -1,
 475282606,
 983218,
 -1,
 475088846,
 983065,
 475537994,
 356596910,
 -1,
 475603198,
 475484629,
 -1,
 475667673,
 475535526,
 -1,
 475733170,
 475598674,
 -1,
 475798634,
 475665349,
 -1,
 475864158,
 475731097,
 77877,
 -1,
 475797670,
 77878,
 475995232,
 475796135,
 77874,
 -1,
 475928742,
 77875,
 476126306,
 475926914,
 77872,
 -1,
 476059814,
 77873,
 476257380,
 476057426,
 77869,
 -1,
 476190886,
 77870,
 -58267,
 476190703,
 77882,
 -58266,
 476321598,
 77881,
 -58265,
 476386910,
 77880,
 -58264,
 476452238,
 77879,
 -58263,
 476517317,
 77876,
 -1,
 476581979,
 77871,
 476781687,
 475730011,
 -1,
 476847213,
 476714590,
 77844,
 -1,
 476780710,
 77845,
 476978287,
 476779461,
 77840,
 -1,
 476911782,
 77841,
 -58256,
 476911599,
 77847,
 -58255,
 477042494,
 77846,
 -58254,
 477107598,
 77843,
 -58253,
 477172889,
 77842,
 -58252,
 477237927,
 77839,
 -58251,
 477303170,
 77838,
 -58250,
 477368411,
 77837,
 -1,
 477433682,
 77836,
 477633668,
 476712786,
 -1,
 477699195,
 477566350,
 77830,
 -58246,
 477635876,
 77832,
 -1,
 477698214,
 77831,
 477895805,
 477631641,
 77828,
 -1,
 477829286,
 77829,
 -58242,
 477829103,
 77835,
 -58241,
 477959998,
 77834,
 -58240,
 478025310,
 77833,
 -58239,
 478090181,
 77827,
 -58238,
 478155431,
 77826,
 -58237,
 478220674,
 77825,
 -1,
 478285915,
 77824,
 478485648,
 477565607,
 -1,
 478551175,
 478417282,
 77860,
 -1,
 478484646,
 77861,
 -58232,
 478484463,
 77868,
 -58231,
 478615358,
 77867,
 -58230,
 478680670,
 77866,
 -58229,
 478745998,
 77865,
 -58228,
 478811289,
 77864,
 -58227,
 478876613,
 77863,
 -58226,
 478941863,
 77862,
 -58225,
 479006811,
 77859,
 -1,
 479072082,
 77858,
 479272091,
 478418318,
 -1,
 -58222,
 479205359,
 77902,
 -58221,
 479270718,
 77901,
 -58220,
 479336030,
 77900,
 -58219,
 479401358,
 77899,
 -58218,
 479466649,
 77898,
 -58217,
 479531973,
 77897,
 -58216,
 479597223,
 77896,
 -58215,
 479662466,
 77895,
 -58214,
 479727707,
 77894,
 -1,
 479792978,
 77893,
 479992998,
 479204505,
 -1,
 -58211,
 479926255,
 77892,
 -58210,
 479991614,
 77891,
 -58209,
 480056926,
 77890,
 -58208,
 480122254,
 77889,
 -58207,
 480187545,
 77888,
 -58206,
 480252869,
 77887,
 -58205,
 480318119,
 77886,
 -58204,
 480383362,
 77885,
 -58203,
 480448603,
 77884,
 -1,
 480513874,
 77883,
 480713905,
 479924610,
 -1,
 -58200,
 480647151,
 77857,
 -58199,
 480712510,
 77856,
 -58198,
 480777822,
 77855,
 -58197,
 480843150,
 77854,
 -58196,
 480908441,
 77853,
 -58195,
 480973765,
 77852,
 -58194,
 481039015,
 77851,
 -58193,
 481104258,
 77850,
 -58192,
 481169499,
 77849,
 -1,
 481234770,
 77848,
 -1,
 480646937,
 77903,
 481558527,
 475666759,
 -1,
 481565887,
 481431378,
 -1,
 481631415,
 481498718,
 78867,
 -58186,
 481568036,
 78869,
 -1,
 481630374,
 78868,
 -58184,
 481564655,
 78871,
 -58183,
 481761086,
 78870,
 -58182,
 481826190,
 78866,
 -58181,
 481891481,
 78865,
 -58180,
 481956805,
 78864,
 -58179,
 482022055,
 78863,
 -58178,
 482087298,
 78862,
 -1,
 482152539,
 78861,
 482352330,
 481497474,
 -1,
 -58175,
 482285551,
 78891,
 -58174,
 482350910,
 78890,
 -58173,
 482416222,
 78889,
 -58172,
 482481550,
 78888,
 -58171,
 482546841,
 78887,
 -58170,
 482612165,
 78886,
 -58169,
 482677415,
 78885,
 -58168,
 482742658,
 78884,
 -58167,
 482807899,
 78883,
 -1,
 482873170,
 78882,
 483073237,
 482283611,
 -1,
 -58164,
 483006447,
 78881,
 -58163,
 483071806,
 78880,
 -58162,
 483137118,
 78879,
 -58161,
 483202446,
 78878,
 -58160,
 483267737,
 78877,
 -58159,
 483333061,
 78876,
 -58158,
 483398311,
 78875,
 -58157,
 483463554,
 78874,
 -58156,
 483528795,
 78873,
 -1,
 483594066,
 78872,
 483852287,
 483005095,
 -1,
 -58153,
 483725698,
 78894,
 -58152,
 483790939,
 78893,
 -1,
 483856210,
 78892,
 484056392,
 475627322,
 -1,
 484121873,
 483987282,
 -1,
 484187370,
 484053671,
 -1,
 484252894,
 484120158,
 78361,
 -1,
 484186278,
 78362,
 484383968,
 484185241,
 78358,
 -1,
 484317350,
 78359,
 484515042,
 484316101,
 78356,
 -1,
 484448422,
 78357,
 484646116,
 484446887,
 78354,
 -1,
 484579494,
 78355,
 -58139,
 484579311,
 78364,
 -58138,
 484710206,
 78363,
 -58137,
 484775310,
 78360,
 -58136,
 484839810,
 78353,
 -58135,
 484905051,
 78352,
 -1,
 484970322,
 78351,
 485170423,
 484118619,
 -1,
 485235950,
 485103422,
 78336,
 -58131,
 485172516,
 78338,
 -1,
 485234854,
 78337,
 -58129,
 485169135,
 78339,
 -58128,
 485365342,
 78335,
 -58127,
 485430670,
 78334,
 -58126,
 485495961,
 78333,
 -58125,
 485561285,
 78332,
 -58124,
 485626535,
 78331,
 -58123,
 485691778,
 78330,
 -58122,
 485757019,
 78329,
 -1,
 485822290,
 78328,
 486022403,
 485101954,
 -1,
 486087930,
 485954713,
 78345,
 -1,
 486021286,
 78346,
 -58117,
 486021103,
 78350,
 -58116,
 486151998,
 78349,
 -58115,
 486217310,
 78348,
 -58114,
 486282638,
 78347,
 -58113,
 486347717,
 78344,
 -58112,
 486412967,
 78343,
 -58111,
 486478210,
 78342,
 -58110,
 486543451,
 78341,
 -1,
 486608722,
 78340,
 486808845,
 485953362,
 -1,
 -58107,
 486741999,
 78327,
 -58106,
 486807358,
 78326,
 -58105,
 486872670,
 78325,
 -58104,
 486937998,
 78324,
 -58103,
 487003289,
 78323,
 -58102,
 487068613,
 78322,
 -58101,
 487133863,
 78321,
 -58100,
 487199106,
 78320,
 -1,
 487264347,
 78319,
 487522303,
 486740933,
 -1,
 -58097,
 487395714,
 78367,
 -58096,
 487460955,
 78366,
 -1,
 487526226,
 78365,
 487726383,
 484097952,
 -1,
 487791904,
 487657563,
 -1,
 487857429,
 487724862,
 78409,
 -1,
 487790758,
 78410,
 487988503,
 487788635,
 78401,
 -1,
 487921830,
 78402,
 488119577,
 487919442,
 78399,
 -1,
 488052902,
 78400,
 -58086,
 488052719,
 78411,
 -58085,
 488183390,
 78408,
 -58084,
 488248718,
 78407,
 -58083,
 488314009,
 78406,
 -58082,
 488379333,
 78405,
 -58081,
 488444583,
 78404,
 -1,
 488509826,
 78403,
 488709418,
 487722834,
 -1,
 -58078,
 488642543,
 78398,
 -58077,
 488707902,
 78397,
 -58076,
 488773214,
 78396,
 -58075,
 488838542,
 78395,
 -58074,
 488903833,
 78394,
 -58073,
 488969157,
 78393,
 -58072,
 489034407,
 78392,
 -58071,
 489099650,
 78391,
 -1,
 489164891,
 78390,
 489422847,
 488640898,
 -1,
 489430317,
 489296258,
 78414,
 -1,
 489363622,
 78415,
 -58066,
 489361499,
 78413,
 -1,
 489492306,
 78412,
 489750527,
 487680979,
 -1,
 489758012,
 489623643,
 -1,
 489823539,
 489690718,
 78385,
 -1,
 489756838,
 78386,
 -58060,
 489756655,
 78388,
 -58059,
 489887550,
 78387,
 -58058,
 489952654,
 78384,
 -58057,
 490017945,
 78383,
 -58056,
 490083269,
 78382,
 -58055,
 490148519,
 78381,
 -58054,
 490213762,
 78380,
 -58053,
 490279003,
 78379,
 -1,
 490344274,
 78378,
 490544455,
 489688914,
 -1,
 490609983,
 490476697,
 78372,
 -1,
 490543270,
 78373,
 -58048,
 490543087,
 78377,
 -58047,
 490673982,
 78376,
 -58046,
 490739294,
 78375,
 -58045,
 490804622,
 78374,
 -58044,
 490869701,
 78371,
 -58043,
 490934951,
 78370,
 -58042,
 491000194,
 78369,
 -1,
 491065435,
 78368,
 -1,
 490476151,
 78389,
 491330988,
 483996987,
 -1,
 491396447,
 491263129,
 -1,
 491461972,
 491327314,
 77997,
 -58036,
 491412035,
 78006,
 -58035,
 491475448,
 78005,
 -58034,
 491539732,
 78004,
 -58033,
 491603918,
 78003,
 -58032,
 491666606,
 78002,
 -58031,
 491730104,
 78001,
 -58030,
 491793049,
 78000,
 -58029,
 491857188,
 77999,
 -1,
 491919526,
 77998,
 492117334,
 491393989,
 78011,
 -1,
 492050598,
 78012,
 492248408,
 492048770,
 78008,
 -1,
 492181670,
 78009,
 -58023,
 492181487,
 78017,
 -58022,
 492312382,
 78016,
 -58021,
 492377694,
 78015,
 -58020,
 492443022,
 78014,
 -58019,
 492508313,
 78013,
 -58018,
 492573351,
 78010,
 -1,
 492638299,
 78007,
 492838256,
 491328910,
 -1,
 492903785,
 492770910,
 78025,
 -58014,
 492851704,
 78033,
 -58013,
 492915988,
 78032,
 -58012,
 492980174,
 78031,
 -58011,
 493042862,
 78030,
 -58010,
 493106360,
 78029,
 -58009,
 493169305,
 78028,
 -58008,
 493233444,
 78027,
 -1,
 493295782,
 78026,
 -58006,
 492836238,
 78024,
 -58005,
 493425817,
 78023,
 -58004,
 493491141,
 78022,
 -58003,
 493556391,
 78021,
 -58002,
 493621634,
 78020,
 -58001,
 493686875,
 78019,
 -1,
 493752146,
 78018,
 493952381,
 492770245,
 -1,
 494017907,
 493885246,
 77994,
 -1,
 493951142,
 77995,
 494148981,
 493950350,
 77991,
 -1,
 494082214,
 77992,
 -57994,
 494082031,
 77996,
 -57993,
 494212702,
 77993,
 -57992,
 494277785,
 77990,
 -57991,
 494343109,
 77989,
 -57990,
 494408359,
 77988,
 -57989,
 494473602,
 77987,
 -57988,
 494538843,
 77986,
 -1,
 494604114,
 77985,
 494804362,
 493884071,
 -1,
 494869888,
 494736325,
 77978,
 -1,
 494803110,
 77979,
 495000962,
 494800987,
 77974,
 -1,
 494934182,
 77975,
 -57981,
 494933999,
 77984,
 -57980,
 495064894,
 77983,
 -57979,
 495130206,
 77982,
 -57978,
 495195534,
 77981,
 -57977,
 495260825,
 77980,
 -57976,
 495325863,
 77977,
 -57975,
 495391106,
 77976,
 -1,
 495456082,
 77973,
 495656342,
 494735746,
 -1,
 495721869,
 495588958,
 77969,
 -1,
 495655078,
 77970,
 -57970,
 495654895,
 77972,
 -57969,
 495785790,
 77971,
 -57968,
 495850894,
 77968,
 -57967,
 495916185,
 77967,
 -57966,
 495981509,
 77966,
 -57965,
 496046759,
 77965,
 -57964,
 496112002,
 77964,
 -57963,
 496177243,
 77963,
 -1,
 496242514,
 77962,
 496442785,
 495587419,
 -1,
 -57960,
 496375791,
 77961,
 -57959,
 496441150,
 77960,
 -57958,
 496506462,
 77959,
 -57957,
 496571790,
 77958,
 -57956,
 496637081,
 77957,
 -57955,
 496702405,
 77956,
 -57954,
 496767655,
 77955,
 -57953,
 496832898,
 77954,
 -57952,
 496898139,
 77953,
 -1,
 496963410,
 77952,
 497221631,
 496373586,
 -1,
 497229220,
 497096510,
 77949,
 -1,
 497162406,
 77950,
 -57947,
 497162223,
 77951,
 -57946,
 497292894,
 77948,
 -57945,
 497358222,
 77947,
 -57944,
 497423513,
 77946,
 -57943,
 497488837,
 77945,
 -57942,
 497554087,
 77944,
 -57941,
 497619330,
 77943,
 -1,
 497684571,
 77942,
 497884670,
 491308720,
 -1,
 497950151,
 497815938,
 -1,
 498015675,
 497880914,
 78726,
 -57936,
 497970095,
 78738,
 -57935,
 498034717,
 78737,
 -57934,
 498099958,
 78736,
 -57933,
 498162243,
 78735,
 -57932,
 498225656,
 78734,
 -57931,
 498289940,
 78733,
 -57930,
 498354126,
 78732,
 -57929,
 498416814,
 78731,
 -57928,
 498480312,
 78730,
 -57927,
 498543257,
 78729,
 -57926,
 498607396,
 78728,
 -1,
 498669734,
 78727,
 498867645,
 497948655,
 78749,
 -1,
 498800806,
 78750,
 498998719,
 498800446,
 78747,
 -1,
 498931878,
 78748,
 499129793,
 498930343,
 78741,
 -1,
 499062950,
 78742,
 -57918,
 499062366,
 78746,
 -57917,
 499193230,
 78745,
 -57916,
 499258521,
 78744,
 -57915,
 499323845,
 78743,
 -57914,
 499388802,
 78740,
 -1,
 499454043,
 78739,
 499654109,
 497880914,
 -1,
 499719634,
 499585115,
 78690,
 -57910,
 499669571,
 78699,
 -57909,
 499732984,
 78698,
 -57908,
 499797268,
 78697,
 -57907,
 499861454,
 78696,
 -57906,
 499924142,
 78695,
 -57905,
 499987640,
 78694,
 -57904,
 500050585,
 78693,
 -57903,
 500114724,
 78692,
 -1,
 500177062,
 78691,
 500374997,
 499652190,
 78706,
 -57900,
 500311332,
 78708,
 -1,
 500373670,
 78707,
 500571607,
 500306306,
 78700,
 -1,
 500504742,
 78701,
 -57896,
 500504559,
 78710,
 -57895,
 500635454,
 78709,
 -57894,
 500700558,
 78705,
 -57893,
 500765849,
 78704,
 -57892,
 500831173,
 78703,
 -1,
 500896423,
 78702,
 501095917,
 499585115,
 -1,
 501161442,
 501026907,
 78712,
 -57888,
 501099161,
 78715,
 -57887,
 501163300,
 78714,
 -1,
 501225638,
 78713,
 501423589,
 501092738,
 78716,
 -57884,
 501359908,
 78718,
 -1,
 501422246,
 78717,
 -57882,
 501356527,
 78725,
 -57881,
 501552958,
 78724,
 -57880,
 501618270,
 78723,
 -57879,
 501683598,
 78722,
 -57878,
 501748889,
 78721,
 -57877,
 501814213,
 78720,
 -57876,
 501879463,
 78719,
 -1,
 501944146,
 78711,
 502144508,
 501027495,
 -1,
 502210032,
 502077022,
 78761,
 -1,
 502143142,
 78762,
 502341106,
 502141607,
 78756,
 -1,
 502274214,
 78757,
 502472180,
 502272091,
 78753,
 -1,
 502405286,
 78754,
 502603254,
 502402898,
 78751,
 -1,
 502536358,
 78752,
 -57865,
 502536175,
 78764,
 -57864,
 502667070,
 78763,
 -57863,
 502732174,
 78760,
 -57862,
 502797465,
 78759,
 -57861,
 502862789,
 78758,
 -1,
 502927746,
 78755,
 503185407,
 502076548,
 78765,
 -1,
 503060646,
 78766,
 503258704,
 497845744,
 -1,
 503324177,
 503189330,
 -1,
 503389703,
 503256462,
 78423,
 -57854,
 503334862,
 78429,
 -57853,
 503397550,
 78428,
 -57852,
 503461048,
 78427,
 -57851,
 503523993,
 78426,
 -57850,
 503588132,
 78425,
 -1,
 503650470,
 78424,
 503848457,
 503321753,
 78421,
 -1,
 503781542,
 78422,
 503979531,
 503779419,
 78416,
 -1,
 503912614,
 78417,
 -57844,
 503912431,
 78432,
 -57843,
 504043326,
 78431,
 -57842,
 504108638,
 78430,
 -57841,
 504173509,
 78420,
 -57840,
 504238759,
 78419,
 -1,
 504304002,
 78418,
 504503842,
 503255719,
 -1,
 504569367,
 504436110,
 78469,
 -57836,
 504509624,
 78473,
 -57835,
 504572569,
 78472,
 -57834,
 504636708,
 78471,
 -1,
 504699046,
 78470,
 504897049,
 504500903,
 78465,
 -1,
 504830118,
 78466,
 505028123,
 504827730,
 78461,
 -1,
 504961190,
 78462,
 -57828,
 504961007,
 78476,
 -57827,
 505091902,
 78475,
 -57826,
 505157214,
 78474,
 -57825,
 505222297,
 78468,
 -57824,
 505287621,
 78467,
 -57823,
 505352578,
 78464,
 -1,
 505417819,
 78463,
 505617969,
 504435074,
 -1,
 505683493,
 505550831,
 78459,
 -1,
 505616550,
 78460,
 505814567,
 505615513,
 78454,
 -1,
 505747622,
 78455,
 505945641,
 505746373,
 78452,
 -1,
 505878694,
 78453,
 506076715,
 505876306,
 78447,
 -1,
 506009766,
 78448,
 -57812,
 506009406,
 78458,
 -57811,
 506140254,
 78457,
 -57810,
 506205582,
 78456,
 -57809,
 506270375,
 78451,
 -57808,
 506335618,
 78450,
 -1,
 506400859,
 78449,
 506601024,
 505548891,
 -1,
 506666550,
 506531666,
 78433,
 -57804,
 506604185,
 78436,
 -57803,
 506668324,
 78435,
 -1,
 506730662,
 78434,
 506928696,
 506599407,
 78445,
 -1,
 506861734,
 78446,
 -57799,
 506861374,
 78444,
 -57798,
 506992222,
 78443,
 -57797,
 507057550,
 78442,
 -57796,
 507122841,
 78441,
 -57795,
 507188165,
 78440,
 -57794,
 507253415,
 78439,
 -57793,
 507318658,
 78438,
 -1,
 507383899,
 78437,
 507584075,
 506532805,
 -1,
 -57790,
 507516911,
 78486,
 -57789,
 507582270,
 78485,
 -57788,
 507647582,
 78484,
 -57787,
 507712910,
 78483,
 -57786,
 507778201,
 78482,
 -57785,
 507843525,
 78481,
 -57784,
 507908775,
 78480,
 -57783,
 507974018,
 78479,
 -57782,
 508039259,
 78478,
 -1,
 508104530,
 78477,
 508362751,
 507516057,
 -1,
 508370511,
 508235602,
 78487,
 -57778,
 508306724,
 78489,
 -1,
 508369062,
 78488,
 -1,
 508301403,
 78490,
 508632728,
 503215967,
 -1,
 508698216,
 508563547,
 -1,
 508763739,
 508629378,
 78268,
 -57772,
 508711416,
 78276,
 -57771,
 508775700,
 78275,
 -57770,
 508839886,
 78274,
 -57769,
 508902574,
 78273,
 -57768,
 508966072,
 78272,
 -57767,
 509029017,
 78271,
 -57766,
 509093156,
 78270,
 -1,
 509155494,
 78269,
 509353565,
 508696158,
 78283,
 -1,
 509286566,
 78284,
 509484639,
 509285774,
 78281,
 -1,
 509417638,
 78282,
 509615713,
 509416601,
 78279,
 -1,
 509548710,
 78280,
 509746787,
 509546322,
 78265,
 -1,
 509679782,
 78266,
 -57756,
 509679599,
 78286,
 -57755,
 509810494,
 78285,
 -57754,
 509875141,
 78278,
 -57753,
 509940391,
 78277,
 -1,
 510005339,
 78267,
 510205558,
 508629671,
 -1,
 510271084,
 510136999,
 78304,
 -57749,
 510207268,
 78306,
 -1,
 510269606,
 78305,
 510467694,
 510201947,
 78301,
 -1,
 510400678,
 78302,
 -57745,
 510400495,
 78312,
 -57744,
 510531390,
 78311,
 -57743,
 510596702,
 78310,
 -57742,
 510662030,
 78309,
 -57741,
 510727321,
 78308,
 -57740,
 510792645,
 78307,
 -57739,
 510857602,
 78303,
 -1,
 510922578,
 78300,
 511123076,
 510136706,
 -1,
 511188601,
 511055678,
 78297,
 -1,
 511121574,
 78298,
 511319675,
 511120325,
 78292,
 -1,
 511252646,
 78293,
 511450749,
 511250818,
 78289,
 -1,
 511383718,
 78290,
 -57730,
 511383535,
 78299,
 -57729,
 511514206,
 78296,
 -57728,
 511579534,
 78295,
 -57727,
 511644825,
 78294,
 -57726,
 511709863,
 78291,
 -57725,
 511774811,
 78288,
 -1,
 511840082,
 78287,
 512040593,
 511053650,
 -1,
 512106120,
 511971419,
 78253,
 -57721,
 512042276,
 78255,
 -1,
 512104614,
 78254,
 512302730,
 512037543,
 78257,
 -1,
 512235686,
 78258,
 -57717,
 512235503,
 78264,
 -57716,
 512366398,
 78263,
 -57715,
 512431710,
 78262,
 -57714,
 512497038,
 78261,
 -57713,
 512562329,
 78260,
 -57712,
 512627653,
 78259,
 -1,
 512692610,
 78256,
 512950271,
 511972293,
 -1,
 512958100,
 512823122,
 78313,
 -1,
 512891046,
 78314,
 -57707,
 512889797,
 78318,
 -57706,
 513020583,
 78317,
 -57705,
 513085826,
 78316,
 -1,
 513151067,
 78315,
 513351392,
 508577813,
 -1,
 513416871,
 513283013,
 -1,
 513482396,
 513349214,
 78132,
 -1,
 513415334,
 78133,
 513613470,
 513414542,
 78130,
 -1,
 513546406,
 78131,
 513744544,
 513545369,
 78128,
 -1,
 513677478,
 78129,
 -57695,
 513677295,
 78135,
 -57694,
 513808190,
 78134,
 -57693,
 513872837,
 78127,
 -57692,
 513938087,
 78126,
 -57691,
 514003330,
 78125,
 -57690,
 514068571,
 78124,
 -1,
 514133842,
 78123,
 514334389,
 513348263,
 -1,
 514399914,
 514266942,
 78120,
 -1,
 514332838,
 78121,
 514530988,
 514332254,
 78118,
 -1,
 514463910,
 78119,
 514662062,
 514461787,
 78111,
 -1,
 514594982,
 78112,
 -57681,
 514594799,
 78122,
 -57680,
 514725262,
 78117,
 -57679,
 514790553,
 78116,
 -57678,
 514855877,
 78115,
 -57677,
 514921127,
 78114,
 -57676,
 514986370,
 78113,
 -1,
 515051346,
 78110,
 515251905,
 514265474,
 -1,
 515317432,
 515182683,
 78100,
 -1,
 515250342,
 78101,
 -57671,
 515250159,
 78109,
 -57670,
 515381054,
 78108,
 -57669,
 515446366,
 78107,
 -57668,
 515511694,
 78106,
 -57667,
 515576985,
 78105,
 -57666,
 515642309,
 78104,
 -57665,
 515707559,
 78103,
 -57664,
 515772802,
 78102,
 -1,
 515837778,
 78099,
 516038349,
 515182683,
 -1,
 516103876,
 515969703,
 78091,
 -1,
 516036774,
 78092,
 -57659,
 516036591,
 78098,
 -57658,
 516167486,
 78097,
 -57657,
 516232798,
 78096,
 -57656,
 516298126,
 78095,
 -57655,
 516363417,
 78094,
 -57654,
 516428741,
 78093,
 -57653,
 516493698,
 78090,
 -57652,
 516558939,
 78089,
 -1,
 516624210,
 78088,
 516824792,
 515968850,
 -1,
 516890320,
 516755547,
 78078,
 -1,
 516823206,
 78079,
 -57647,
 516823023,
 78087,
 -57646,
 516953918,
 78086,
 -57645,
 517019230,
 78085,
 -57644,
 517084558,
 78084,
 -57643,
 517149849,
 78083,
 -57642,
 517215173,
 78082,
 -57641,
 517280423,
 78081,
 -1,
 517345666,
 78080,
 517603327,
 516756633,
 -1,
 517611229,
 517476443,
 78137,
 -57637,
 517548697,
 78140,
 -57636,
 517612836,
 78139,
 -1,
 517675174,
 78138,
 -57634,
 517542567,
 78142,
 -57633,
 517804418,
 78141,
 -1,
 517869394,
 78136,
 518070055,
 513297751,
 -1,
 518135534,
 518001605,
 -1,
 518201060,
 518067353,
 78196,
 -1,
 518133926,
 78197,
 518332134,
 518132391,
 78193,
 -1,
 518264998,
 78194,
 -57625,
 518264815,
 78201,
 -57624,
 518395710,
 78200,
 -57623,
 518461022,
 78199,
 -57622,
 518526350,
 78198,
 -57621,
 518591429,
 78195,
 -57620,
 518656386,
 78192,
 -57619,
 518721627,
 78191,
 -1,
 518786898,
 78190,
 518987515,
 518066855,
 -1,
 519053041,
 518919774,
 78186,
 -1,
 518985894,
 78187,
 519184115,
 518985102,
 78184,
 -1,
 519116966,
 78185,
 -57612,
 519116783,
 78189,
 -57611,
 519247678,
 78188,
 -57610,
 519312537,
 78183,
 -57609,
 519377861,
 78182,
 -57608,
 519443111,
 78181,
 -57607,
 519508354,
 78180,
 -57606,
 519573595,
 78179,
 -1,
 519638866,
 78178,
 519839496,
 518918530,
 -1,
 519905022,
 519771534,
 78173,
 -1,
 519837862,
 78174,
 520036096,
 519835474,
 78166,
 -1,
 519968934,
 78167,
 -57599,
 519968751,
 78177,
 -57598,
 520099646,
 78176,
 -57597,
 520164958,
 78175,
 -57596,
 520230041,
 78172,
 -57595,
 520295365,
 78171,
 -57594,
 520360615,
 78170,
 -57593,
 520425858,
 78169,
 -1,
 520491099,
 78168,
 520691477,
 519769938,
 -1,
 520757004,
 520623710,
 78150,
 -57589,
 520693028,
 78152,
 -1,
 520755366,
 78151,
 520953614,
 520689038,
 78148,
 -1,
 520886438,
 78149,
 -57585,
 520886255,
 78154,
 -57584,
 521017150,
 78153,
 -57583,
 521082009,
 78147,
 -57582,
 521147333,
 78146,
 -57581,
 521212583,
 78145,
 -57580,
 521277826,
 78144,
 -1,
 521343067,
 78143,
 521543457,
 520622171,
 -1,
 521608984,
 521474139,
 78156,
 -1,
 521541798,
 78157,
 -57575,
 521541615,
 78165,
 -57574,
 521672510,
 78164,
 -57573,
 521737822,
 78163,
 -57572,
 521803150,
 78162,
 -57571,
 521868441,
 78161,
 -57570,
 521933765,
 78160,
 -57569,
 521999015,
 78159,
 -57568,
 522064258,
 78158,
 -1,
 522129234,
 78155,
 522387455,
 521475225,
 -1,
 -57565,
 522261445,
 78206,
 -57564,
 522326695,
 78205,
 -57563,
 522391938,
 78204,
 -57562,
 522457179,
 78203,
 -1,
 522522450,
 78202,
 522723171,
 518039853,
 -1,
 522788662,
 522653787,
 -1,
 522854188,
 522720197,
 78560,
 -57557,
 522790180,
 78562,
 -1,
 522852518,
 78561,
 523050798,
 522786398,
 78565,
 -1,
 522983590,
 78566,
 -57553,
 522983407,
 78568,
 -57552,
 523114302,
 78567,
 -57551,
 523179406,
 78564,
 -57550,
 523244697,
 78563,
 -57549,
 523309735,
 78559,
 -57548,
 523374978,
 78558,
 -57547,
 523440219,
 78557,
 -1,
 523505490,
 78556,
 523706179,
 522719618,
 -1,
 523771706,
 523638158,
 78575,
 -57543,
 523707684,
 78577,
 -1,
 523770022,
 78576,
 -57541,
 523704303,
 78580,
 -57540,
 523900734,
 78579,
 -57539,
 523966046,
 78578,
 -57538,
 524031129,
 78574,
 -57537,
 524096453,
 78573,
 -57536,
 524161703,
 78572,
 -57535,
 524226946,
 78571,
 -57534,
 524292187,
 78570,
 -1,
 524357458,
 78569,
 524558159,
 523637415,
 -1,
 524623686,
 524489881,
 78586,
 -1,
 524556454,
 78587,
 -57529,
 524556271,
 78591,
 -57528,
 524687166,
 78590,
 -57527,
 524752478,
 78589,
 -57526,
 524817806,
 78588,
 -57525,
 524882885,
 78585,
 -57524,
 524948135,
 78584,
 -57523,
 525013378,
 78583,
 -57522,
 525078619,
 78582,
 -1,
 525143890,
 78581,
 525344603,
 524488530,
 -1,
 525410130,
 525276558,
 78551,
 -1,
 525342886,
 78552,
 525541204,
 525341058,
 78546,
 -1,
 525473958,
 78547,
 -57515,
 525473775,
 78555,
 -57514,
 525604670,
 78554,
 -57513,
 525669982,
 78553,
 -57512,
 525735065,
 78550,
 -57511,
 525800389,
 78549,
 -57510,
 525865639,
 78548,
 -1,
 525930587,
 78545,
 526188543,
 525276101,
 -1,
 -57507,
 526062990,
 78598,
 -57506,
 526128281,
 78597,
 -57505,
 526193605,
 78596,
 -57504,
 526258855,
 78595,
 -57503,
 526324098,
 78594,
 -57502,
 526389339,
 78593,
 -1,
 526454610,
 78592,
 526655384,
 522698656,
 -1,
 526720881,
 526586242,
 -1,
 526786407,
 526653423,
 78674,
 -1,
 526719142,
 78675,
 526917481,
 526717607,
 78667,
 -1,
 526850214,
 78668,
 -57494,
 526849854,
 78673,
 -57493,
 526980702,
 78672,
 -57492,
 527046030,
 78671,
 -57491,
 527111321,
 78670,
 -57490,
 527176645,
 78669,
 -57489,
 527241602,
 78666,
 -57488,
 527306843,
 78665,
 -1,
 527372114,
 78664,
 527572861,
 526652071,
 -1,
 527638388,
 527503746,
 78678,
 -1,
 527571110,
 78679,
 -57483,
 527570927,
 78686,
 -57482,
 527701822,
 78685,
 -57481,
 527767134,
 78684,
 -57480,
 527832462,
 78683,
 -57479,
 527897753,
 78682,
 -57478,
 527963077,
 78681,
 -57477,
 528028327,
 78680,
 -57476,
 528093275,
 78677,
 -1,
 528158546,
 78676,
 528359305,
 527503186,
 -1,
 528424833,
 528291214,
 78648,
 -57472,
 528360740,
 78650,
 -1,
 528423078,
 78649,
 -57470,
 528357359,
 78653,
 -57469,
 528553790,
 78652,
 -57468,
 528619102,
 78651,
 -57467,
 528684185,
 78647,
 -57466,
 528749509,
 78646,
 -57465,
 528814759,
 78645,
 -57464,
 528880002,
 78644,
 -1,
 528945243,
 78643,
 529145748,
 528289883,
 -1,
 -57461,
 529078255,
 78663,
 -57460,
 529143614,
 78662,
 -57459,
 529208926,
 78661,
 -57458,
 529274254,
 78660,
 -57457,
 529339545,
 78659,
 -57456,
 529404869,
 78658,
 -57455,
 529470119,
 78657,
 -57454,
 529535362,
 78656,
 -57453,
 529600603,
 78655,
 -1,
 529665874,
 78654,
 529924095,
 529077189,
 -1,
 -57450,
 529797506,
 78689,
 -57449,
 529862747,
 78688,
 -1,
 529928018,
 78687,
 530128841,
 526628100,
 -1,
 530194343,
 530059090,
 -1,
 530259868,
 530126831,
 78610,
 -1,
 530192550,
 78611,
 530390942,
 530192190,
 78608,
 -1,
 530323622,
 78609,
 530522016,
 530323038,
 78606,
 -1,
 530454694,
 78607,
 530653090,
 530453159,
 78601,
 -1,
 530585766,
 78602,
 -57437,
 530584974,
 78605,
 -57436,
 530715801,
 78604,
 -57435,
 530781125,
 78603,
 -57434,
 530846082,
 78600,
 -1,
 530911323,
 78599,
 531111860,
 530124891,
 -1,
 531177386,
 531043726,
 78619,
 -1,
 531110054,
 78620,
 531308460,
 531107931,
 78613,
 -1,
 531241126,
 78614,
 -57427,
 531240943,
 78623,
 -57426,
 531371838,
 78622,
 -57425,
 531437150,
 78621,
 -57424,
 531502233,
 78618,
 -57423,
 531567557,
 78617,
 -57422,
 531632807,
 78616,
 -57421,
 531698050,
 78615,
 -1,
 531763026,
 78612,
 531963839,
 531042690,
 -1,
 -57418,
 531896303,
 78633,
 -57417,
 531961662,
 78632,
 -57416,
 532026974,
 78631,
 -57415,
 532092302,
 78630,
 -57414,
 532157593,
 78629,
 -57413,
 532222917,
 78628,
 -57412,
 532288167,
 78627,
 -57411,
 532353410,
 78626,
 -57410,
 532418651,
 78625,
 -1,
 532483922,
 78624,
 532742143,
 531894951,
 -1,
 532750274,
 532615847,
 78638,
 -1,
 532682918,
 78639,
 532881348,
 532681090,
 78636,
 -1,
 532813990,
 78637,
 -57403,
 532813198,
 78642,
 -57402,
 532944025,
 78641,
 -57401,
 533009349,
 78640,
 -57400,
 533074011,
 78635,
 -1,
 533139282,
 78634,
 533340154,
 530070938,
 -1,
 533405655,
 533270914,
 -1,
 533471181,
 533337918,
 78066,
 -1,
 533403814,
 78067,
 533602255,
 533401426,
 78057,
 -1,
 533534886,
 78058,
 -57392,
 533534703,
 78068,
 -57391,
 533665374,
 78065,
 -57390,
 533730702,
 78064,
 -57389,
 533795993,
 78063,
 -57388,
 533861317,
 78062,
 -57387,
 533926567,
 78061,
 -57386,
 533991810,
 78060,
 -1,
 534057051,
 78059,
 534257636,
 533336155,
 -1,
 534323162,
 534189662,
 78053,
 -1,
 534255782,
 78054,
 534454236,
 534254990,
 78051,
 -1,
 534386854,
 78052,
 -57379,
 534386671,
 78056,
 -57378,
 534517566,
 78055,
 -57377,
 534582425,
 78050,
 -57376,
 534647749,
 78049,
 -57375,
 534712999,
 78048,
 -57374,
 534778242,
 78047,
 -57373,
 534843483,
 78046,
 -1,
 534908754,
 78045,
 535109616,
 534187858,
 -1,
 535175143,
 535042031,
 78043,
 -1,
 535107750,
 78044,
 535306217,
 535107390,
 78041,
 -1,
 535238822,
 78042,
 -57366,
 535238238,
 78040,
 -57365,
 535369102,
 78039,
 -57364,
 535434393,
 78038,
 -57363,
 535499717,
 78037,
 -57362,
 535564967,
 78036,
 -57361,
 535630210,
 78035,
 -1,
 535695451,
 78034,
 535953407,
 535040679,
 -1,
 535961587,
 535827397,
 78073,
 -1,
 535894182,
 78074,
 -57356,
 535893822,
 78077,
 -57355,
 536024670,
 78076,
 -57354,
 536089998,
 78075,
 -57353,
 536154791,
 78072,
 -57352,
 536220034,
 78071,
 -57351,
 536285275,
 78070,
 -1,
 536350546,
 78069,
 536551462,
 533320911,
 -1,
 536616980,
 536481883,
 -1,
 536682502,
 536548505,
 78842,
 -57346,
 536631875,
 78851,
 -57345,
 536695288,
 78850,
 -57344,
 536759572,
 78849,
 -57343,
 536823758,
 78848,
 -57342,
 536886446,
 78847,
 -57341,
 536949944,
 78846,
 -57340,
 537012889,
 78845,
 -57339,
 537077028,
 78844,
 -1,
 537139366,
 78843,
 537337871,
 536614286,
 78852,
 -57336,
 537285112,
 78860,
 -57335,
 537349396,
 78859,
 -57334,
 537413582,
 78858,
 -57333,
 537476270,
 78857,
 -57332,
 537539768,
 78856,
 -57331,
 537602713,
 78855,
 -57330,
 537666852,
 78854,
 -1,
 537729190,
 78853,
 -57328,
 537269189,
 78841,
 -57327,
 537858727,
 78840,
 -57326,
 537923970,
 78839,
 -57325,
 537989211,
 78838,
 -1,
 538054482,
 78837,
 538312703,
 536547154,
 -1,
 538320922,
 538186114,
 78821,
 -57321,
 538260664,
 78825,
 -57320,
 538323609,
 78824,
 -57319,
 538387748,
 78823,
 -1,
 538450086,
 78822,
 538648605,
 538251943,
 78826,
 -57316,
 538584356,
 78828,
 -1,
 538646694,
 78827,
 538845215,
 538580121,
 78831,
 -1,
 538777766,
 78832,
 538976289,
 538776517,
 78829,
 -1,
 538908838,
 78830,
 -57310,
 538908655,
 78836,
 -57309,
 539039550,
 78835,
 -57308,
 539104862,
 78834,
 -57307,
 539170190,
 78833,
 -1,
 539234395,
 78820,
 539435084,
 536517799,
 -1,
 539500596,
 539365467,
 -1,
 539566122,
 539432334,
 78530,
 -1,
 539498662,
 78531,
 539697196,
 539496274,
 78523,
 -1,
 539629734,
 78524,
 -57299,
 539629551,
 78534,
 -57298,
 539760446,
 78533,
 -57297,
 539825758,
 78532,
 -57296,
 539890841,
 78529,
 -57295,
 539956165,
 78528,
 -57294,
 540021415,
 78527,
 -57293,
 540086658,
 78526,
 -1,
 540151899,
 78525,
 540352577,
 539430738,
 -1,
 540418104,
 540283559,
 78514,
 -57289,
 540353828,
 78516,
 -1,
 540416166,
 78515,
 540614714,
 540348802,
 78512,
 -1,
 540547238,
 78513,
 -57285,
 540547055,
 78522,
 -57284,
 540677950,
 78521,
 -57283,
 540743262,
 78520,
 -57282,
 540808590,
 78519,
 -57281,
 540873881,
 78518,
 -57280,
 540939205,
 78517,
 -1,
 541003867,
 78511,
 541261823,
 540283266,
 -1,
 -57277,
 541136879,
 78544,
 -57276,
 541202238,
 78543,
 -57275,
 541267550,
 78542,
 -57274,
 541332878,
 78541,
 -57273,
 541398169,
 78540,
 -57272,
 541463493,
 78539,
 -57271,
 541528743,
 78538,
 -57270,
 541593986,
 78537,
 -57269,
 541659227,
 78536,
 -1,
 541724498,
 78535,
 541925488,
 539413323,
 -1,
 541991004,
 541855835,
 -1,
 542056528,
 541923134,
 78789,
 -1,
 541989030,
 78790,
 542187602,
 541988446,
 78787,
 -1,
 542120102,
 78788,
 542318676,
 542118853,
 78783,
 -1,
 542251174,
 78784,
 542449750,
 542248786,
 78778,
 -1,
 542382246,
 78779,
 -57257,
 542382063,
 78791,
 -57256,
 542512526,
 78786,
 -57255,
 542577817,
 78785,
 -57254,
 542642855,
 78782,
 -57253,
 542708098,
 78781,
 -1,
 542773339,
 78780,
 542974056,
 541921106,
 -1,
 543039583,
 542906351,
 78776,
 -1,
 542972070,
 78777,
 543170657,
 542970535,
 78769,
 -1,
 543103142,
 78770,
 -57246,
 543102782,
 78775,
 -57245,
 543233630,
 78774,
 -57244,
 543298958,
 78773,
 -57243,
 543364249,
 78772,
 -57242,
 543429573,
 78771,
 -57241,
 543494530,
 78768,
 -1,
 543559771,
 78767,
 543817727,
 542904706,
 -1,
 543826027,
 543691717,
 78796,
 -1,
 543758502,
 78797,
 -57236,
 543757465,
 78798,
 -57235,
 543888039,
 78795,
 -57234,
 543953282,
 78794,
 -57233,
 544018523,
 78793,
 -1,
 544083794,
 78792,
 544284816,
 541862596,
 -1,
 544350334,
 544214866,
 -1,
 544415862,
 544280962,
 77915,
 -57228,
 544352921,
 77918,
 -57227,
 544417060,
 77917,
 -1,
 544479398,
 77916,
 -57225,
 544348143,
 77925,
 -57224,
 544610110,
 77924,
 -57223,
 544675422,
 77923,
 -57222,
 544740750,
 77922,
 -57221,
 544806041,
 77921,
 -57220,
 544871365,
 77920,
 -57219,
 544936615,
 77919,
 -1,
 545001563,
 77914,
 545202314,
 544280667,
 -1,
 545267841,
 545132370,
 77926,
 -1,
 545200294,
 77927,
 -57214,
 545200111,
 77936,
 -57213,
 545331006,
 77935,
 -57212,
 545396318,
 77934,
 -57211,
 545461646,
 77933,
 -57210,
 545526937,
 77932,
 -57209,
 545592261,
 77931,
 -57208,
 545657511,
 77930,
 -57207,
 545722754,
 77929,
 -1,
 545787995,
 77928,
 546045951,
 545132930,
 -1,
 -57204,
 545919941,
 77941,
 -57203,
 545985191,
 77940,
 -57202,
 546050434,
 77939,
 -57201,
 546115675,
 77938,
 -1,
 546180946,
 77937,
 546381990,
 544234172,
 -1,
 546447517,
 546312018,
 -1,
 546513044,
 546379759,
 78225,
 -1,
 546445478,
 78226,
 546644118,
 546444441,
 78220,
 -1,
 546576550,
 78221,
 -57193,
 546576190,
 78224,
 -57192,
 546707038,
 78223,
 -57191,
 546772366,
 78222,
 -57190,
 546837445,
 78219,
 -57189,
 546902695,
 78218,
 -57188,
 546967938,
 78217,
 -1,
 547033179,
 78216,
 547291135,
 546377819,
 -1,
 547299488,
 547164251,
 78229,
 -1,
 547231910,
 78230,
 547430562,
 547229522,
 78227,
 -1,
 547362982,
 78228,
 -57181,
 547361945,
 78234,
 -57180,
 547492805,
 78233,
 -57179,
 547558055,
 78232,
 -1,
 547623298,
 78231,
 547823798,
 546345849,
 -1,
 547889331,
 547753810,
 -1,
 547954858,
 547820199,
 78494,
 -1,
 547887270,
 78495,
 548085932,
 547885147,
 78491,
 -1,
 548018342,
 78492,
 -57171,
 548018159,
 78501,
 -57170,
 548149054,
 78500,
 -57169,
 548214366,
 78499,
 -57168,
 548279694,
 78498,
 -57167,
 548344985,
 78497,
 -57166,
 548410309,
 78496,
 -1,
 548475266,
 78493,
 548732927,
 547819611,
 -1,
 -57163,
 548606043,
 78503,
 -1,
 548671314,
 78502,
 548872387,
 547803574,
 -1,
 548937914,
 548803525,
 78802,
 -57159,
 548873508,
 78804,
 -1,
 548935846,
 78803,
 549134524,
 548869950,
 78809,
 -1,
 549066918,
 78810,
 549265598,
 549066126,
 78806,
 -1,
 549197990,
 78807,
 -57153,
 549197406,
 78808,
 -57152,
 549328025,
 78805,
 -57151,
 549393063,
 78801,
 -57150,
 549458306,
 78800,
 -1,
 549523547,
 78799,
 549724366,
 548826070,
 -1,
 549789894,
 549655950,
 78249,
 -1,
 549722278,
 78250,
 549920968,
 549720450,
 78244,
 -1,
 549853350,
 78245,
 -57143,
 549852990,
 78252,
 -57142,
 549983838,
 78251,
 -57141,
 550048921,
 78248,
 -57140,
 550114245,
 78247,
 -57139,
 550179495,
 78246,
 -1,
 550244443,
 78243,
 550445273,
 549659958,
 -1,
 550510801,
 550376601,
 77908,
 -1,
 550443174,
 77909,
 -57134,
 550442991,
 77913,
 -57133,
 550573886,
 77912,
 -57132,
 550639198,
 77911,
 -57131,
 550704526,
 77910,
 -57130,
 550769605,
 77907,
 -57129,
 550834855,
 77906,
 -57128,
 550900098,
 77905,
 -1,
 550965339,
 77904,
 551166179,
 550425303,
 -1,
 551231708,
 551096411,
 78811,
 -1,
 551164070,
 78812,
 -57123,
 551163710,
 78819,
 -57122,
 551294558,
 78818,
 -57121,
 551359886,
 78817,
 -57120,
 551425177,
 78816,
 -57119,
 551490501,
 78815,
 -57118,
 551555751,
 78814,
 -1,
 551620994,
 78813,
 551821549,
 551113226,
 -1,
 551887078,
 551753102,
 78212,
 -1,
 551819430,
 78213,
 -57113,
 551819070,
 78215,
 -57112,
 551949918,
 78214,
 -57111,
 552015001,
 78211,
 -57110,
 552080325,
 78210,
 -57109,
 552145575,
 78209,
 -57108,
 552210818,
 78208,
 -1,
 552276059,
 78207,
 552476918,
 551774298,
 -1,
 -57105,
 552408894,
 78242,
 -57104,
 552474206,
 78241,
 -57103,
 552539534,
 78240,
 -57102,
 552604825,
 78239,
 -57101,
 552670149,
 78238,
 -57100,
 552735399,
 78237,
 -57099,
 552800642,
 78236,
 -1,
 552865883,
 78235,
 553123839,
 552442546,
 -1,
 -57096,
 552998494,
 78510,
 -57095,
 553063822,
 78509,
 -57094,
 553129113,
 78508,
 -57093,
 553194437,
 78507,
 -57092,
 553259687,
 78506,
 -57091,
 553324930,
 78505,
 -1,
 553390171,
 78504,
 553591232,
 475575429,
 -1,
 553656766,
 553539224,
 -1,
 553722284,
 553625765,
 -1,
 553787819,
 553702417,
 -1,
 553853213,
 553724569,
 -1,
 553918747,
 553790105,
 -1,
 553984276,
 553865720,
 -1,
 554049805,
 553931256,
 -1,
 554115336,
 553991342,
 43813,
 -1,
 554056878,
 43812,
 554246410,
 554047654,
 43808,
 -1,
 554178726,
 43811,
 -57077,
 554221339,
 43809,
 -57076,
 554337726,
 43814,
 -1,
 554392131,
 43810,
 554574095,
 553991342,
 11709,
 -1,
 554515630,
 11708,
 554705169,
 554506406,
 11704,
 -1,
 554637478,
 11707,
 -57070,
 554680091,
 11705,
 -57069,
 554796478,
 11710,
 -1,
 554850883,
 11706,
 555032854,
 553925806,
 11693,
 -1,
 554974382,
 11692,
 555163928,
 554965158,
 11688,
 -1,
 555096230,
 11691,
 -57063,
 555138843,
 11689,
 -57062,
 555255230,
 11694,
 -1,
 555309635,
 11690,
 -57060,
 553879027,
 11655,
 -1,
 555439928,
 11664,
 555622702,
 553798932,
 -1,
 555688230,
 555602562,
 -1,
 555753761,
 555629742,
 11741,
 -1,
 555695278,
 11740,
 555884835,
 555686054,
 11736,
 -1,
 555817126,
 11739,
 -57052,
 555859739,
 11737,
 -57051,
 555976126,
 11742,
 -1,
 556030531,
 11738,
 556212524,
 555635151,
 -1,
 556278057,
 556154030,
 11670,
 -1,
 556219566,
 11669,
 556409131,
 556210342,
 11667,
 -1,
 556341414,
 4895,
 -1,
 556358211,
 11668,
 -57043,
 556172787,
 4879,
 -1,
 556561741,
 11658,
 556736832,
 555562168,
 -1,
 556802360,
 556676280,
 -1,
 556867895,
 556749304,
 -1,
 556933427,
 556809390,
 43789,
 -1,
 556874926,
 43788,
 -57036,
 556908315,
 43785,
 -57035,
 557024702,
 43790,
 -57034,
 557079107,
 43786,
 -1,
 557128020,
 43787,
 -1,
 556828147,
 11661,
 557392191,
 556782789,
 -1,
 557457723,
 557333678,
 43797,
 -1,
 557399214,
 43796,
 -57028,
 557432603,
 43793,
 -57027,
 557548990,
 43798,
 -57026,
 557603395,
 43794,
 -1,
 557652308,
 43795,
 -1,
 557352435,
 11660,
 557916496,
 556705957,
 -1,
 557982025,
 557885605,
 -1,
 558047556,
 557923502,
 11685,
 -1,
 557989038,
 11684,
 558178630,
 557979814,
 11680,
 -1,
 558110886,
 11683,
 -57017,
 558153499,
 11681,
 -57016,
 558269886,
 11686,
 -1,
 558324291,
 11682,
 558506318,
 557923990,
 -1,
 -57013,
 558471837,
 5004,
 -57012,
 558530330,
 4992,
 -57011,
 558583056,
 5000,
 -1,
 558639745,
 4996,
 -57009,
 558466547,
 11651,
 -1,
 558782264,
 11652,
 558965086,
 557851940,
 -1,
 559030617,
 558900516,
 -1,
 559096148,
 558972078,
 43821,
 -1,
 559037614,
 43820,
 559227222,
 559028390,
 43816,
 -1,
 559159462,
 43819,
 -57001,
 559202075,
 43817,
 -57000,
 559318462,
 43822,
 -1,
 559372867,
 43818,
 559554909,
 559008526,
 -1,
 559620444,
 559496366,
 4999,
 -1,
 559561902,
 4998,
 -1,
 559569475,
 4997,
 -1,
 559515123,
 11653,
 559882601,
 558937221,
 -1,
 559948134,
 559855443,
 -1,
 560013666,
 559889582,
 43781,
 -1,
 559955118,
 43780,
 -56989,
 559988507,
 43777,
 -56988,
 560104894,
 43782,
 -56987,
 560159299,
 43778,
 -1,
 560208212,
 43779,
 -56985,
 559928851,
 4935,
 -56984,
 560367091,
 11654,
 -1,
 560420664,
 11663,
 560603507,
 559862981,
 -1,
 560669042,
 560583877,
 -1,
 560734573,
 560610478,
 11701,
 -1,
 560676014,
 11700,
 560865647,
 560666790,
 11696,
 -1,
 560797862,
 11699,
 -56976,
 560840475,
 11697,
 -56975,
 560956862,
 11702,
 -1,
 561011267,
 11698,
 -1,
 560629235,
 11659,
 561258877,
 560583070,
 -1,
 561324412,
 561238658,
 -1,
 561389943,
 561265838,
 11733,
 -1,
 561331374,
 11732,
 561521017,
 561322150,
 11728,
 -1,
 561453222,
 11731,
 -56966,
 561495835,
 11729,
 -56965,
 561612222,
 11734,
 -1,
 561666627,
 11730,
 -1,
 561284595,
 4743,
 561914247,
 561224360,
 -1,
 561979782,
 561894018,
 -1,
 562045313,
 561921198,
 11717,
 -1,
 561986734,
 11716,
 562176387,
 561977510,
 11712,
 -1,
 562108582,
 11715,
 -56956,
 562151195,
 11713,
 -56955,
 562267582,
 11718,
 -1,
 562321987,
 11714,
 -1,
 561939955,
 4679,
 562569617,
 561866781,
 -1,
 562635152,
 562549378,
 -1,
 562700683,
 562576558,
 11725,
 -1,
 562642094,
 11724,
 562831757,
 562632870,
 11720,
 -1,
 562763942,
 11723,
 -56946,
 562806555,
 11721,
 -56945,
 562922942,
 11726,
 -1,
 562977347,
 11722,
 -1,
 562595315,
 4783,
 563224984,
 562533158,
 -1,
 563290518,
 563202830,
 -1,
 563356053,
 563231918,
 5007,
 -1,
 563297454,
 5006,
 -1,
 563305027,
 5005,
 -56937,
 563250675,
 11666,
 -1,
 563500856,
 11665,
 563683742,
 563181324,
 -1,
 563749277,
 563661582,
 -1,
 563814812,
 563690670,
 4995,
 -1,
 563756206,
 4994,
 -1,
 563763779,
 4993,
 -1,
 563709427,
 11649,
 564076962,
 563629325,
 -1,
 564142497,
 564018350,
 5003,
 -1,
 564083886,
 5002,
 -1,
 564091459,
 5001,
 564339109,
 564035386,
 -1,
 -56924,
 564319315,
 11657,
 -1,
 564364787,
 11656,
 -56922,
 564319315,
 4847,
 -56921,
 564515039,
 4815,
 -56920,
 564569662,
 11650,
 -56919,
 564622487,
 11648,
 -56918,
 564684740,
 11662,
 -1,
 564746040,
 4615,
 -1,
 553729728,
 4960,
 564994489,
 553695922,
 -1,
 565060017,
 564933816,
 -1,
 565125552,
 565003255,
 5009,
 -1,
 565055065,
 5016,
 -1,
 565075071,
 5012,
 565322164,
 565012509,
 -1,
 -56909,
 565298623,
 5017,
 -1,
 565330418,
 5013,
 -56907,
 565302283,
 5008,
 -56906,
 565488845,
 5011,
 -56905,
 565552243,
 5010,
 -56904,
 565597597,
 5015,
 -1,
 565652945,
 5014,
 565903359,
 564932733,
 -1,
 565911997,
 565792441,
 -1,
 -56900,
 565868823,
 4959,
 -1,
 565911307,
 4957,
 -1,
 565889656,
 4958,
 -56897,
 553636254,
 983047,
 -1,
 566109476,
 983096,
 566305277,
 553544623,
 -1,
 566370805,
 566240850,
 -1,
 566436295,
 566329146,
 -1,
 -56892,
 566388546,
 66837,
 -56891,
 566443182,
 66835,
 -56890,
 566507016,
 66821,
 -1,
 566565030,
 66836,
 566763981,
 566381844,
 -1,
 566829515,
 566710776,
 -1,
 -56886,
 566770862,
 66853,
 -1,
 566828684,
 66854,
 -56884,
 566781762,
 66827,
 -1,
 566967470,
 66826,
 567157200,
 566744261,
 -1,
 -56881,
 567104574,
 66852,
 -1,
 567164078,
 66851,
 567353811,
 567129221,
 -1,
 -56878,
 567301182,
 66846,
 -1,
 567360686,
 66845,
 567550422,
 567322789,
 -1,
 -56875,
 567497790,
 66844,
 -1,
 567557294,
 66843,
 567747033,
 567516239,
 -1,
 -56872,
 567713580,
 66842,
 -1,
 567753902,
 66841,
 567943644,
 567700399,
 -1,
 -56869,
 567897698,
 66833,
 -1,
 567950510,
 66832,
 568140255,
 567896093,
 -1,
 -56866,
 568087614,
 66855,
 -1,
 568147118,
 66831,
 568336865,
 568081582,
 66824,
 -1,
 568285763,
 66823,
 568467940,
 568276152,
 -1,
 -56861,
 568415294,
 66822,
 -1,
 568474798,
 66820,
 568664551,
 568404633,
 -1,
 -56858,
 568611902,
 66819,
 -1,
 568671406,
 66818,
 -56856,
 568644226,
 66850,
 -56855,
 568840696,
 66849,
 -56854,
 568903550,
 66848,
 -56853,
 568966939,
 66847,
 -56852,
 569023206,
 66840,
 -56851,
 569087235,
 66839,
 -56850,
 569148862,
 66838,
 -56849,
 569211417,
 66834,
 -56848,
 569272130,
 66830,
 -56847,
 569334339,
 66829,
 -56846,
 569398334,
 66828,
 -56845,
 569460873,
 66825,
 -56844,
 569517731,
 66817,
 -1,
 569579686,
 66816,
 569835519,
 566312110,
 -1,
 569844220,
 569717729,
 -1,
 569909755,
 569769984,
 -1,
 -56839,
 569883430,
 128294,
 -56838,
 569939785,
 128268,
 -1,
 569995958,
 128161,
 -1,
 569843038,
 9191,
 -1,
 569808448,
 128024,
 570302991,
 566263610,
 -1,
 570368522,
 570242234,
 -1,
 570434057,
 570328809,
 -1,
 570499588,
 570406021,
 -1,
 570565123,
 570465830,
 983048,
 -1,
 570491260,
 983095,
 -1,
 570509059,
 983046,
 -56827,
 570468990,
 983134,
 -56826,
 570726839,
 983178,
 -56825,
 570784344,
 983099,
 -56824,
 570848052,
 983064,
 -1,
 570904940,
 983177,
 -1,
 570412719,
 128282,
 571154957,
 570345423,
 -1,
 -56820,
 571110162,
 128388,
 -1,
 571161528,
 128233,
 571408383,
 571120296,
 983051,
 -1,
 571326884,
 983050,
 571482654,
 570259212,
 -1,
 571548184,
 571447791,
 -1,
 571613717,
 571507627,
 128453,
 571736063,
 571541189,
 -1,
 -56812,
 571625090,
 128454,
 -1,
 571684024,
 128455,
 571875863,
 571577277,
 128460,
 -1,
 571844773,
 128461,
 -1,
 571816048,
 128459,
 572129279,
 571508647,
 -1,
 -56806,
 572003726,
 127999,
 -56805,
 572069017,
 127998,
 -56804,
 572134341,
 127997,
 -56803,
 572199591,
 127996,
 -1,
 572264791,
 127995,
 572465707,
 571462046,
 -1,
 572531242,
 572439422,
 -1,
 572596777,
 572473686,
 -1,
 572662308,
 572574981,
 -1,
 -56797,
 572633306,
 128915,
 -1,
 572665429,
 128905,
 572858919,
 572631205,
 -1,
 -56794,
 572810894,
 128954,
 -1,
 572857945,
 128942,
 -56792,
 572805438,
 128935,
 -1,
 573000208,
 128948,
 -1,
 572531526,
 128125,
 -1,
 572496245,
 128529,
 573317686,
 572399786,
 128066,
 573383219,
 573290326,
 -1,
 573448754,
 573338785,
 -1,
 573514289,
 573380774,
 -1,
 -56784,
 573484292,
 127759,
 -1,
 573537098,
 127758,
 -1,
 573457869,
 127757,
 -1,
 573417278,
 9178,
 573898751,
 573310193,
 -1,
 -56779,
 573809200,
 127806,
 -1,
 573863914,
 127805,
 574038585,
 573297488,
 128065,
 -56776,
 574007461,
 128064,
 -1,
 574050382,
 128083,
 574235197,
 574007461,
 -1,
 574300732,
 574171801,
 983104,
 -1,
 574234699,
 983103,
 -1,
 574232742,
 983135,
 574497345,
 574195134,
 -1,
 -56769,
 574469253,
 983049,
 -56768,
 574519052,
 983100,
 -1,
 574581679,
 983067,
 574759492,
 574473654,
 -1,
 -56765,
 574724284,
 127972,
 -1,
 574761954,
 127984,
 -56763,
 574736404,
 127794,
 -56762,
 574921534,
 11072,
 -56761,
 574985084,
 983179,
 -56760,
 575039301,
 9167,
 -56759,
 575092744,
 11790,
 -1,
 575147653,
 128231,
 575351078,
 475494156,
 -1,
 575415419,
 575290542,
 -1,
 575480645,
 575373114,
 -1,
 575546179,
 575419915,
 -1,
 575611690,
 575517726,
 -1,
 575677117,
 575541074,
 -1,
 575742555,
 575608815,
 -1,
 -56750,
 575674436,
 125069,
 -56749,
 575739835,
 125123,
 -56748,
 575805024,
 124959,
 -56747,
 575870379,
 125036,
 -56746,
 575935717,
 124932,
 -56745,
 576001052,
 124952,
 -56744,
 576066268,
 125097,
 -56743,
 576131512,
 125088,
 -56742,
 576196897,
 124999,
 -1,
 576262086,
 125047,
 576463462,
 575674174,
 -1,
 -56739,
 576395257,
 124993,
 -56738,
 576460637,
 125024,
 -56737,
 576525964,
 125043,
 -56736,
 576591323,
 125056,
 -56735,
 576656712,
 125117,
 -56734,
 576721930,
 124985,
 -56733,
 576787171,
 125039,
 -56732,
 576852468,
 125049,
 -56731,
 576917757,
 125071,
 -1,
 576983083,
 125015,
 577184369,
 576394846,
 -1,
 -56728,
 577116254,
 124980,
 -56727,
 577181527,
 125021,
 -56726,
 577246985,
 125119,
 -56725,
 577312203,
 124933,
 -56724,
 577377489,
 125022,
 -56723,
 577442815,
 125089,
 -56722,
 577508110,
 124986,
 -56721,
 577573345,
 125080,
 -56720,
 577638561,
 125099,
 -1,
 577703812,
 125100,
 577905276,
 577115534,
 -1,
 -56717,
 577837160,
 125002,
 -56716,
 577902530,
 125068,
 -56715,
 577967819,
 125107,
 -56714,
 578033160,
 125074,
 -56713,
 578098410,
 124931,
 -56712,
 578163753,
 125108,
 -56711,
 578228991,
 125009,
 -56710,
 578294235,
 125076,
 -56709,
 578359609,
 124945,
 -1,
 578424793,
 125124,
 578626183,
 577836185,
 -1,
 -56706,
 578557962,
 124951,
 -56705,
 578623412,
 125121,
 -56704,
 578688736,
 125066,
 -56703,
 578753946,
 125095,
 -56702,
 578819381,
 125000,
 -56701,
 578884624,
 124987,
 -56700,
 578949866,
 125041,
 -56699,
 579015079,
 125044,
 -56698,
 579080440,
 125072,
 -1,
 579145709,
 125070,
 579347090,
 578556869,
 -1,
 -56695,
 579278962,
 124946,
 -56694,
 579344266,
 124934,
 -56693,
 579409591,
 125078,
 -56692,
 579474874,
 125046,
 -56691,
 579540311,
 124942,
 -56690,
 579605496,
 125090,
 -56689,
 579670849,
 125048,
 -56688,
 579735981,
 125037,
 -56687,
 579801263,
 125033,
 -1,
 579866518,
 125035,
 580067997,
 579277479,
 -1,
 -56684,
 579999806,
 125029,
 -56683,
 580065192,
 125028,
 -56682,
 580130543,
 125027,
 -56681,
 580195733,
 125020,
 -56680,
 580261068,
 125019,
 -56679,
 580326376,
 125018,
 -56678,
 580391827,
 125013,
 -56677,
 580457064,
 125012,
 -56676,
 580522307,
 125011,
 -1,
 580587431,
 125005,
 580788904,
 579998082,
 -1,
 -56673,
 580720639,
 125004,
 -56672,
 580786040,
 125003,
 -56671,
 580851378,
 124984,
 -56670,
 580916694,
 124983,
 -56669,
 580982000,
 124982,
 -56668,
 581047380,
 124998,
 -56667,
 581112698,
 124997,
 -56666,
 581177933,
 124996,
 -56665,
 581243164,
 124976,
 -1,
 581308407,
 124975,
 581509811,
 580718683,
 -1,
 -56662,
 581441625,
 124974,
 -56661,
 581506889,
 124992,
 -56660,
 581572197,
 124991,
 -56659,
 581637520,
 124990,
 -56658,
 581702975,
 124964,
 -56657,
 581768135,
 124963,
 -56656,
 581833462,
 124962,
 -56655,
 581898632,
 124957,
 -56654,
 581963881,
 124956,
 -1,
 582029146,
 124955,
 582287359,
 581439314,
 -1,
 -56651,
 582162455,
 124950,
 -56650,
 582227867,
 124949,
 -56649,
 582293189,
 124948,
 -56648,
 582358593,
 124938,
 -56647,
 582423885,
 124937,
 -56646,
 582489188,
 124936,
 -56645,
 582554372,
 124930,
 -56644,
 582619571,
 124929,
 -1,
 582684873,
 124928,
 582942719,
 575606875,
 -1,
 582951625,
 582817598,
 -1,
 -56640,
 582883344,
 124954,
 -56639,
 582948769,
 125079,
 -56638,
 583014078,
 125083,
 -56637,
 583079349,
 125034,
 -56636,
 583144771,
 125114,
 -56635,
 583210036,
 125065,
 -56634,
 583275288,
 125058,
 -56633,
 583340626,
 125113,
 -56632,
 583405702,
 124995,
 -1,
 583470952,
 124994,
 583672532,
 582882910,
 -1,
 -56629,
 583604228,
 124935,
 -56628,
 583669586,
 124973,
 -56627,
 583735015,
 125067,
 -56626,
 583800240,
 125032,
 -56625,
 583865589,
 125010,
 -56624,
 583930902,
 125082,
 -56623,
 583996287,
 125116,
 -56622,
 584061415,
 125081,
 -56621,
 584126733,
 125101,
 -1,
 584191968,
 125122,
 584393439,
 583603598,
 -1,
 -56618,
 584325176,
 125031,
 -56617,
 584390504,
 125061,
 -56616,
 584455813,
 125064,
 -56615,
 584521120,
 125063,
 -56614,
 584586544,
 124967,
 -56613,
 584651842,
 125120,
 -56612,
 584717001,
 124965,
 -56611,
 584782402,
 124977,
 -56610,
 584847571,
 125084,
 -1,
 584912801,
 125008,
 585114346,
 584324249,
 -1,
 -56607,
 585046057,
 125054,
 -56606,
 585111445,
 125093,
 -56605,
 585176731,
 125006,
 -56604,
 585242112,
 125052,
 -56603,
 585307350,
 125059,
 -56602,
 585372706,
 124953,
 -56601,
 585437971,
 124988,
 -56600,
 585503227,
 125109,
 -56599,
 585568557,
 125115,
 -1,
 585633620,
 124958,
 585835253,
 585044933,
 -1,
 -56596,
 585766961,
 125111,
 -56595,
 585832290,
 125096,
 -56594,
 585897717,
 124968,
 -56593,
 585963001,
 125051,
 -56592,
 586028299,
 125075,
 -56591,
 586093657,
 125118,
 -56590,
 586158981,
 124944,
 -56589,
 586224080,
 125086,
 -56588,
 586289485,
 125016,
 -1,
 586354588,
 125038,
 586556160,
 585765543,
 -1,
 -56585,
 586487928,
 124947,
 -56584,
 586553156,
 124961,
 -56583,
 586618484,
 124969,
 -56582,
 586683944,
 124979,
 -56581,
 586749147,
 124971,
 -56580,
 586814523,
 125112,
 -56579,
 586879702,
 125023,
 -56578,
 586944958,
 125087,
 -56577,
 587010244,
 124970,
 -1,
 587075472,
 125042,
 587277067,
 586486146,
 -1,
 -56574,
 587208733,
 125103,
 -56573,
 587274093,
 125040,
 -56572,
 587339480,
 125055,
 -56571,
 587404859,
 124939,
 -56570,
 587470109,
 125104,
 -56569,
 587535341,
 125094,
 -56568,
 587600699,
 125102,
 -56567,
 587665902,
 125077,
 -56566,
 587731272,
 125017,
 -1,
 587796429,
 125053,
 587997974,
 587206747,
 -1,
 -56563,
 587929635,
 125106,
 -56562,
 587995095,
 124940,
 -56561,
 588060370,
 125030,
 -56560,
 588125725,
 124978,
 -56559,
 588191011,
 125050,
 -56558,
 588256361,
 124941,
 -56557,
 588321530,
 125007,
 -56556,
 588386756,
 125092,
 -56555,
 588451996,
 125060,
 -1,
 588517297,
 124989,
 588718881,
 587927378,
 -1,
 -56552,
 588650622,
 125014,
 -56551,
 588715919,
 125091,
 -56550,
 588781183,
 125098,
 -56549,
 588846567,
 125057,
 -56548,
 588911871,
 125085,
 -56547,
 588977230,
 125001,
 -56546,
 589042367,
 124960,
 -56545,
 589107756,
 125073,
 -56544,
 589172886,
 125026,
 -1,
 589238132,
 124966,
 589496319,
 588650479,
 -1,
 -56541,
 589371001,
 125025,
 -56540,
 589436450,
 124981,
 -56539,
 589501600,
 124972,
 -56538,
 589567087,
 124943,
 -56537,
 589632240,
 125045,
 -56536,
 589697537,
 125110,
 -56535,
 589762782,
 125105,
 -1,
 589827978,
 125062,
 590029623,
 575551386,
 -1,
 590095150,
 590001285,
 -1,
 -56531,
 590073803,
 125128,
 -1,
 590108891,
 125129,
 590291761,
 590063781,
 -1,
 -56528,
 590243447,
 125132,
 -1,
 590300654,
 125133,
 590488372,
 590235598,
 -1,
 -56525,
 590450536,
 125130,
 -1,
 590505427,
 125131,
 -56523,
 590449080,
 125127,
 -56522,
 590643803,
 125135,
 -1,
 590692462,
 125134,
 590938111,
 589967524,
 -1,
 590947135,
 590853253,
 -1,
 591012670,
 590888110,
 -1,
 591078205,
 590970682,
 -1,
 -56516,
 591046821,
 125137,
 -1,
 591071625,
 125140,
 -1,
 591020678,
 125136,
 -1,
 590960846,
 125139,
 591405890,
 590895580,
 -1,
 -56511,
 591374501,
 125138,
 -1,
 591399305,
 125141,
 -1,
 591363228,
 125142,
 -56508,
 575514916,
 128697,
 -1,
 591629526,
 128334,
 591799269,
 575448688,
 -1,
 591864767,
 591737959,
 -1,
 591930252,
 591824121,
 -1,
 591995739,
 591901829,
 -1,
 592061265,
 591973134,
 -1,
 592126799,
 592020926,
 68033,
 592248831,
 592052224,
 -1,
 592257870,
 592140764,
 68051,
 -1,
 592185727,
 68078,
 -1,
 592230411,
 68060,
 592510975,
 592069364,
 68042,
 -1,
 592382335,
 68069,
 592585561,
 592007672,
 -1,
 592651095,
 592551983,
 68034,
 592773119,
 592576512,
 -1,
 592782166,
 592665052,
 68052,
 -1,
 592710015,
 68079,
 -1,
 592754699,
 68061,
 593035263,
 592602221,
 68043,
 -1,
 592906623,
 68070,
 593166335,
 592527754,
 68041,
 -1,
 593037695,
 68068,
 593240938,
 591964325,
 -1,
 593306467,
 593192567,
 68037,
 593372001,
 593231872,
 -1,
 593437536,
 593320412,
 68055,
 -1,
 593365375,
 68082,
 -1,
 593410059,
 68064,
 593690623,
 593346308,
 68046,
 -1,
 593561983,
 68073,
 593821695,
 593249774,
 68038,
 593830760,
 593690624,
 -1,
 593896295,
 593779164,
 68056,
 -1,
 593824127,
 68083,
 -1,
 593868811,
 68065,
 594149375,
 593805060,
 68047,
 -1,
 594020735,
 68074,
 594223995,
 593184718,
 -1,
 594289523,
 594183614,
 -1,
 594355057,
 594265376,
 68035,
 594477055,
 594280448,
 -1,
 594486128,
 594368988,
 68053,
 -1,
 594413951,
 68080,
 -1,
 594458635,
 68062,
 594739199,
 594323469,
 68044,
 -1,
 594610559,
 68071,
 594870271,
 594238019,
 -1,
 594879353,
 594790270,
 68036,
 595001343,
 594804736,
 -1,
 595010424,
 594893276,
 68054,
 -1,
 594938239,
 68081,
 -1,
 594982923,
 68063,
 595263487,
 594824443,
 68045,
 -1,
 595134847,
 68072,
 595338113,
 594182747,
 68040,
 595403648,
 595263488,
 -1,
 595469183,
 595352028,
 68058,
 -1,
 595396991,
 68085,
 -1,
 595441675,
 68067,
 -1,
 595377927,
 68076,
 595731335,
 595279982,
 68039,
 595796870,
 595656704,
 -1,
 595862405,
 595745244,
 68057,
 -1,
 595790207,
 68084,
 -1,
 595834891,
 68066,
 -1,
 595776196,
 68075,
 596180991,
 595691960,
 68032,
 596246527,
 596049920,
 -1,
 596255627,
 596138460,
 68050,
 -1,
 596183423,
 68077,
 -1,
 596228107,
 68059,
 596452269,
 591883183,
 -1,
 596517802,
 596395311,
 -1,
 596583314,
 596489349,
 -1,
 -56432,
 596542910,
 68022,
 -56431,
 596589742,
 68021,
 -1,
 596646054,
 68020,
 596845461,
 596551845,
 -1,
 -56428,
 596786350,
 68017,
 -1,
 596842662,
 68015,
 597042072,
 596803386,
 -1,
 -56425,
 596982958,
 68010,
 -1,
 597039270,
 68009,
 597238683,
 596994077,
 -1,
 -56422,
 597185038,
 68013,
 -1,
 597235878,
 68018,
 597435293,
 597170342,
 68000,
 -1,
 597401306,
 68016,
 -56418,
 597414619,
 68004,
 -56417,
 597543758,
 68005,
 -56416,
 597597379,
 68011,
 -56415,
 597662390,
 68019,
 -56414,
 597726076,
 68007,
 -56413,
 597788094,
 68003,
 -56412,
 597849954,
 68008,
 -56411,
 597912541,
 68012,
 -56410,
 597973571,
 68002,
 -56409,
 598037890,
 68014,
 -56408,
 598097070,
 68001,
 -56407,
 598160710,
 68023,
 -1,
 598222169,
 68006,
 598474751,
 596477740,
 -1,
 -56404,
 598386208,
 68030,
 -1,
 598433464,
 68031,
 598671359,
 596397105,
 -1,
 598680498,
 598586501,
 -1,
 -56400,
 598659185,
 68087,
 -56399,
 598694272,
 68088,
 -1,
 598753753,
 68095,
 598942645,
 598648997,
 -1,
 -56396,
 598894241,
 68091,
 -1,
 598951457,
 68092,
 599139256,
 598903228,
 -1,
 -56393,
 599113285,
 68086,
 -1,
 599151245,
 68029,
 599335867,
 599082958,
 -1,
 -56390,
 599298041,
 68089,
 -1,
 599352906,
 68090,
 599532478,
 599276718,
 -1,
 -56387,
 599486960,
 68028,
 -1,
 599547212,
 68093,
 -1,
 599491188,
 68094,
 599851007,
 591812003,
 -1,
 599860195,
 599748990,
 -1,
 599925703,
 599831685,
 -1,
 599991236,
 599866542,
 67994,
 -1,
 599920112,
 67995,
 600122310,
 599922854,
 67992,
 -1,
 600051184,
 67993,
 -1,
 600081854,
 67996,
 600318924,
 599883578,
 -1,
 600384458,
 600259758,
 67980,
 -1,
 600313328,
 67981,
 600571903,
 600316070,
 67978,
 -1,
 600444400,
 67979,
 600646608,
 600287397,
 -1,
 600712143,
 600578214,
 67987,
 -1,
 600641008,
 67988,
 -1,
 600652974,
 67989,
 600908754,
 600612035,
 67982,
 -1,
 600837616,
 67983,
 601039829,
 600860701,
 -1,
 -56364,
 600986126,
 67985,
 -1,
 601036966,
 67990,
 601236439,
 600974681,
 67974,
 -1,
 601165296,
 67975,
 -56360,
 601215707,
 67972,
 -56359,
 601344846,
 67973,
 -56358,
 601397942,
 67991,
 -56357,
 601461628,
 67976,
 -56356,
 601523646,
 67971,
 -56355,
 601585506,
 67977,
 -56354,
 601648093,
 67984,
 -56353,
 601709123,
 67970,
 -56352,
 601773442,
 67986,
 -56351,
 601832622,
 67969,
 -56350,
 601896262,
 67997,
 -1,
 601954470,
 67968,
 602210303,
 599831653,
 67998,
 -1,
 602082800,
 67999,
 602285135,
 591742211,
 -1,
 602350627,
 602237871,
 -1,
 602416162,
 602293551,
 -1,
 602481647,
 602373946,
 -1,
 602547179,
 602427565,
 43977,
 -1,
 602473550,
 44001,
 602678253,
 602478758,
 43973,
 -1,
 602604622,
 43999,
 -56338,
 602657499,
 43747,
 -1,
 602767248,
 43752,
 602940406,
 602453125,
 -1,
 603005939,
 602911877,
 -1,
 -56334,
 602952206,
 43749,
 -1,
 603003046,
 43748,
 603202549,
 602955263,
 43975,
 -1,
 603128910,
 44000,
 -1,
 603150469,
 43978,
 603399164,
 602879160,
 -1,
 603464698,
 603337912,
 -1,
 -56327,
 603410958,
 43751,
 -1,
 603461798,
 43750,
 -56325,
 603414015,
 43991,
 -1,
 603609221,
 43993,
 603792384,
 603367589,
 -1,
 -56322,
 603760944,
 43754,
 -56321,
 603804174,
 43753,
 -1,
 603856480,
 43969,
 604054532,
 603755302,
 -1,
 604120067,
 603986086,
 43972,
 -1,
 604046414,
 43998,
 -1,
 604066525,
 43984,
 604316680,
 604006429,
 -1,
 604382215,
 604276684,
 43968,
 -1,
 604308558,
 43995,
 -1,
 604330117,
 43976,
 604578826,
 604273929,
 43971,
 -1,
 604505166,
 43997,
 604709900,
 604531855,
 43970,
 -1,
 604636238,
 43996,
 604840975,
 604661494,
 -1,
 -56306,
 604790271,
 43990,
 -1,
 604852957,
 43987,
 605037585,
 604789315,
 43983,
 -1,
 604963918,
 44002,
 605168660,
 604982548,
 -1,
 -56301,
 605128652,
 43986,
 -1,
 605182085,
 43992,
 605365271,
 605105404,
 -1,
 -56298,
 605314559,
 43974,
 -1,
 605362342,
 43746,
 605561882,
 605300004,
 -1,
 -56295,
 605508317,
 43994,
 -1,
 605558950,
 43989,
 -56293,
 605541162,
 43980,
 -56292,
 605735780,
 43979,
 -56291,
 605799019,
 43982,
 -56290,
 605855014,
 43988,
 -56289,
 605914558,
 43745,
 -56288,
 605968845,
 43981,
 -56287,
 606026926,
 43744,
 -1,
 606086113,
 43985,
 -1,
 602391077,
 44012,
 606348344,
 602326685,
 -1,
 606413879,
 606311078,
 -1,
 606479403,
 606345382,
 -1,
 606544937,
 606410918,
 -1,
 -56280,
 606519067,
 43759,
 -1,
 606558787,
 43757,
 -56278,
 606519067,
 43758,
 -1,
 606699472,
 44005,
 606872622,
 606453531,
 -1,
 -56275,
 606846747,
 43756,
 -1,
 606896080,
 44008,
 607069233,
 606820931,
 -1,
 -56272,
 607027152,
 44004,
 -1,
 607083075,
 43755,
 -56270,
 607048596,
 44006,
 -56269,
 607242641,
 43765,
 -56268,
 607301695,
 44007,
 -56267,
 607357363,
 44003,
 -56266,
 607421753,
 44010,
 -1,
 607464828,
 44009,
 -1,
 606364633,
 43766,
 607724614,
 606287770,
 -1,
 607790140,
 607696005,
 -1,
 -56261,
 607768523,
 44018,
 -1,
 607803611,
 44019,
 607986751,
 607758501,
 -1,
 -56258,
 607938167,
 44022,
 -1,
 607995374,
 44023,
 608183362,
 607930318,
 -1,
 -56255,
 608145256,
 44020,
 -1,
 608200147,
 44021,
 -56253,
 608163198,
 44016,
 -56252,
 608340408,
 44017,
 -56251,
 608404059,
 44025,
 -1,
 608452718,
 44024,
 608642122,
 607656102,
 -1,
 -56248,
 608606727,
 44013,
 -56247,
 608666341,
 43762,
 -1,
 608719769,
 43761,
 608904269,
 608578933,
 -1,
 -56244,
 608845923,
 44011,
 -1,
 608902825,
 43760,
 -56242,
 608882958,
 43764,
 -1,
 609072169,
 43763,
 609231976,
 602224670,
 -1,
 609297494,
 609200293,
 -1,
 609363028,
 609248890,
 -1,
 -56237,
 609333450,
 128950,
 -1,
 609392596,
 128971,
 -56235,
 609319087,
 9900,
 -1,
 609492569,
 128938,
 609690715,
 609241038,
 -1,
 609756250,
 609652680,
 -1,
 -56231,
 609719994,
 128967,
 -1,
 609757273,
 128965,
 -1,
 609707574,
 128944,
 610018398,
 609668357,
 -1,
 -56227,
 609988826,
 128911,
 -1,
 610020949,
 9898,
 610215009,
 609990762,
 -1,
 -56224,
 610178746,
 128963,
 -1,
 610216025,
 128961,
 610411620,
 610156660,
 -1,
 -56221,
 610382026,
 128956,
 -1,
 610441172,
 128974,
 610608231,
 610346276,
 -1,
 -56218,
 610568299,
 128901,
 -1,
 610626574,
 9899,
 -1,
 610554174,
 128931,
 610870391,
 609205118,
 -1,
 610935926,
 610818943,
 -1,
 611001456,
 610907269,
 -1,
 611066990,
 610979942,
 -1,
 -56211,
 611029391,
 9173,
 -1,
 611084232,
 9174,
 -56209,
 611034502,
 9175,
 -1,
 611206425,
 9176,
 611394675,
 610956529,
 -1,
 -56206,
 611368686,
 9172,
 -1,
 611429519,
 9170,
 -56204,
 611364013,
 9171,
 -56203,
 611554727,
 9177,
 -1,
 611592625,
 9169,
 -1,
 610895294,
 128647,
 -56200,
 610840881,
 983172,
 -56199,
 611810632,
 128221,
 -56198,
 611873983,
 127816,
 -1,
 611918610,
 127830,
 612115936,
 575374782,
 -1,
 612181432,
 612054791,
 -1,
 612246861,
 612124964,
 -1,
 612312396,
 612200830,
 -1,
 612377820,
 612280485,
 -1,
 612443350,
 612333616,
 -1,
 612508815,
 612414597,
 7511,
 612574348,
 612484509,
 -1,
 612639878,
 612505766,
 7492,
 -56187,
 612595259,
 7579,
 -1,
 612646062,
 7494,
 612836488,
 612595468,
 7514,
 -1,
 612764881,
 7597,
 -56183,
 612812445,
 7610,
 -56182,
 612928472,
 7500,
 -56181,
 612981315,
 7502,
 -1,
 613044728,
 7587,
 -56179,
 612535171,
 7508,
 -56178,
 613176633,
 7615,
 -1,
 613223691,
 7605,
 613426328,
 612444825,
 7580,
 613491862,
 613359707,
 -1,
 613557395,
 613440067,
 7590,
 -1,
 613485972,
 7591,
 -56172,
 613531419,
 7608,
 -56171,
 613646138,
 7600,
 -1,
 613706671,
 7595,
 -56169,
 613438854,
 7521,
 -1,
 613813125,
 7581,
 614016159,
 613378991,
 -1,
 614081694,
 613944072,
 -1,
 -56165,
 614048031,
 7593,
 -56164,
 614110173,
 7594,
 -56163,
 614169657,
 43870,
 -1,
 614228737,
 43869,
 -1,
 614030572,
 43001,
 614474916,
 613956782,
 7497,
 -56159,
 614454715,
 7614,
 -56158,
 614512467,
 7582,
 -56157,
 614574870,
 7604,
 -1,
 614629779,
 7505,
 614802601,
 614448923,
 7512,
 614868136,
 614727680,
 -1,
 -56153,
 614846112,
 43871,
 -1,
 614868434,
 7606,
 -1,
 614832585,
 7607,
 615130287,
 614770853,
 -1,
 615195821,
 615066265,
 -1,
 -56148,
 615163258,
 7586,
 -1,
 615209498,
 7498,
 -56146,
 615144495,
 7513,
 -1,
 615320676,
 7603,
 615523507,
 615064868,
 7495,
 -56143,
 615485101,
 7509,
 -56142,
 615531771,
 7517,
 -1,
 615588286,
 7601,
 615785655,
 615503045,
 7611,
 615907327,
 615713544,
 -1,
 -56138,
 615817503,
 7612,
 -1,
 615855161,
 7613,
 616047803,
 615744958,
 7506,
 616169471,
 616011079,
 -1,
 -56134,
 616072638,
 7507,
 -1,
 616119470,
 7499,
 616309951,
 615992596,
 7501,
 616431615,
 616276074,
 -1,
 -56130,
 616339014,
 7520,
 -1,
 616386012,
 7518,
 616572098,
 616248504,
 7496,
 -56127,
 616533643,
 7585,
 -1,
 616579387,
 7519,
 616768709,
 616503462,
 7491,
 -56124,
 616724027,
 7493,
 -1,
 616783560,
 7516,
 616965319,
 616744605,
 7515,
 -1,
 616893540,
 7609,
 617096393,
 616928038,
 7510,
 -1,
 617043334,
 7602,
 617227468,
 617054057,
 -1,
 -56117,
 617193759,
 7599,
 -1,
 617246598,
 7598,
 617424078,
 617182988,
 7504,
 -1,
 617352292,
 7596,
 617555153,
 617372227,
 -1,
 -56112,
 617516600,
 7589,
 -1,
 617549204,
 7588,
 -56110,
 617521513,
 7583,
 -56109,
 617703453,
 7503,
 -56108,
 617768704,
 7592,
 -56107,
 617829641,
 43868,
 -1,
 617891790,
 7584,
 618079449,
 612416486,
 -1,
 -56104,
 618034635,
 42785,
 -1,
 618092066,
 42784,
 618332159,
 618025464,
 -1,
 -56101,
 618237347,
 42890,
 -1,
 618283279,
 765,
 618472712,
 612313753,
 -1,
 618538232,
 618405979,
 -1,
 618603746,
 618503247,
 7487,
 618725375,
 618546787,
 -1,
 -56095,
 618626874,
 7483,
 -1,
 618675374,
 7474,
 618865892,
 618563006,
 7484,
 -1,
 618839835,
 7485,
 618996966,
 618811896,
 7476,
 -1,
 618925460,
 43000,
 619128040,
 618931492,
 7470,
 -1,
 619061686,
 7471,
 619259114,
 619059366,
 7468,
 -1,
 619199662,
 7469,
 -56085,
 619236110,
 7490,
 -56084,
 619366045,
 11389,
 -56083,
 619429659,
 7489,
 -56082,
 619492485,
 7488,
 -56081,
 619549478,
 7486,
 -56080,
 619609914,
 7482,
 -56079,
 619673356,
 7481,
 -56078,
 619735983,
 7480,
 -56077,
 619800605,
 7479,
 -56076,
 619865846,
 7478,
 -56075,
 619928131,
 7477,
 -56074,
 619990292,
 7475,
 -56073,
 620051630,
 7473,
 -1,
 620115128,
 7472,
 620307715,
 618485366,
 -1,
 620373246,
 620256971,
 -1,
 -56069,
 620342198,
 42754,
 -56068,
 620406801,
 42758,
 -56067,
 620469001,
 42756,
 -1,
 620533429,
 42752,
 620756991,
 620306289,
 -1,
 -56064,
 620669878,
 42755,
 -56063,
 620734481,
 42759,
 -56062,
 620796681,
 42757,
 -1,
 620861109,
 42753,
 621028615,
 620287148,
 -1,
 -56059,
 620998647,
 42653,
 -56058,
 621040625,
 42652,
 -1,
 621101450,
 7544,
 -1,
 620988583,
 42889,
 621356315,
 618427752,
 -1,
 621421850,
 621281280,
 -1,
 621487374,
 621375268,
 -1,
 621552909,
 621412596,
 767,
 -1,
 621499465,
 753,
 -1,
 621481757,
 42773,
 621749523,
 621426797,
 -1,
 621815058,
 621722935,
 -1,
 -56047,
 621787849,
 42763,
 -1,
 621834291,
 42768,
 -1,
 621793153,
 751,
 622077206,
 621715935,
 -1,
 -56043,
 622035347,
 755,
 -1,
 622088078,
 754,
 -56041,
 622052194,
 752,
 -56040,
 622246238,
 759,
 -56039,
 622289639,
 42783,
 -1,
 622341877,
 42888,
 -1,
 621364144,
 42778,
 622601516,
 621296814,
 -1,
 622667049,
 622580334,
 -1,
 622732579,
 622622060,
 -1,
 622798113,
 622672205,
 -1,
 -56032,
 622770889,
 42764,
 -1,
 622817331,
 42769,
 -56030,
 622751795,
 42774,
 -1,
 622938000,
 983981,
 623181823,
 622679530,
 -1,
 623191335,
 623065421,
 -1,
 -56026,
 623164105,
 42760,
 -1,
 623210547,
 42765,
 -56024,
 623145011,
 42770,
 -1,
 623331244,
 983980,
 623575039,
 622624803,
 -1,
 -56021,
 623474123,
 764,
 -1,
 623531554,
 762,
 623715639,
 622558111,
 -1,
 623781170,
 623654961,
 -1,
 623846705,
 623720879,
 -1,
 -56016,
 623792389,
 757,
 -1,
 623844027,
 758,
 -1,
 623792389,
 756,
 624164863,
 623706112,
 -1,
 624174390,
 624048461,
 -1,
 -56011,
 624147145,
 42762,
 -1,
 624193587,
 42767,
 -1,
 624128051,
 42772,
 624436541,
 623680828,
 -1,
 -56007,
 624411481,
 42779,
 -56006,
 624452327,
 42782,
 -56005,
 624510673,
 42781,
 -56004,
 624573121,
 42780,
 -1,
 624635998,
 760,
 624829762,
 624383466,
 -1,
 624895297,
 624769357,
 -1,
 -56000,
 624868041,
 42761,
 -1,
 624914483,
 42766,
 -1,
 624848947,
 42771,
 625157446,
 624769186,
 -1,
 -55996,
 625133650,
 42775,
 -55995,
 625192619,
 42776,
 -1,
 625235944,
 42777,
 625419593,
 625092284,
 -1,
 -55992,
 625374667,
 763,
 -1,
 625432098,
 761,
 -55990,
 625395167,
 42864,
 -55989,
 625576988,
 766,
 -1,
 625626853,
 4348,
 -1,
 612247991,
 43867,
 625934335,
 612171776,
 -1,
 625943950,
 625832318,
 -1,
 626009430,
 625919645,
 -1,
 626074965,
 625968702,
 -1,
 626140499,
 626039887,
 71174,
 -1,
 626105423,
 71175,
 626327551,
 626092975,
 71176,
 -1,
 626224047,
 71177,
 -1,
 626006182,
 71210,
 626468188,
 625980549,
 -1,
 626533722,
 626439301,
 -1,
 -55975,
 626479630,
 71193,
 -1,
 626530470,
 71192,
 -55973,
 626479630,
 71198,
 -1,
 626661542,
 71197,
 626861409,
 626425658,
 -1,
 -55970,
 626840283,
 71191,
 -55969,
 626884496,
 71196,
 -55968,
 626937187,
 71186,
 -1,
 626989222,
 71201,
 627189095,
 626799800,
 -1,
 627254629,
 627127480,
 -1,
 -55964,
 627200526,
 71195,
 -1,
 627251366,
 71194,
 -55962,
 627200526,
 71200,
 -1,
 627382438,
 71199,
 627582315,
 627120294,
 71168,
 -55959,
 627556123,
 71181,
 -55958,
 627595843,
 71179,
 -1,
 627644582,
 71169,
 627844463,
 627550373,
 -1,
 -55955,
 627812656,
 71212,
 -55954,
 627855886,
 71211,
 -1,
 627906726,
 71213,
 628106609,
 627818267,
 71172,
 -1,
 628080411,
 71173,
 628237684,
 628069158,
 -1,
 -55949,
 628183566,
 71203,
 -1,
 628234406,
 71202,
 628434295,
 628190127,
 -1,
 -55946,
 628386781,
 71215,
 -1,
 628431014,
 71209,
 628630906,
 628385821,
 -1,
 -55943,
 628576782,
 71183,
 -1,
 628627622,
 71182,
 628827517,
 628582134,
 -1,
 -55940,
 628773390,
 71190,
 -1,
 628824230,
 71189,
 629024127,
 628775491,
 71170,
 -1,
 628972099,
 71171,
 629155202,
 628968724,
 -1,
 -55935,
 629101070,
 71185,
 -1,
 629151910,
 71184,
 629351813,
 629090969,
 -1,
 -55932,
 629297678,
 71188,
 -1,
 629348518,
 71187,
 629548424,
 629286180,
 -1,
 -55929,
 629494286,
 71205,
 -1,
 629545126,
 71204,
 -55927,
 629527259,
 71207,
 -55926,
 629710019,
 71208,
 -55925,
 629769662,
 71180,
 -55924,
 629831522,
 71206,
 -55923,
 629887502,
 71214,
 -1,
 629947566,
 71178,
 630138270,
 625920666,
 -1,
 630203796,
 630114766,
 -1,
 630269330,
 630168655,
 71221,
 -1,
 630234191,
 71222,
 630456319,
 630221743,
 71223,
 -1,
 630352815,
 71224,
 630531480,
 630134950,
 -1,
 -55914,
 630505243,
 71228,
 -55913,
 630544963,
 71226,
 -1,
 630593702,
 71216,
 630793626,
 630505243,
 71219,
 -1,
 630767387,
 71220,
 630924700,
 630741571,
 71217,
 -1,
 630872643,
 71218,
 -55907,
 630883774,
 71227,
 -1,
 630996142,
 71225,
 631186863,
 630076600,
 -1,
 631252397,
 631135658,
 -1,
 631317923,
 631223429,
 -1,
 -55902,
 631295947,
 71250,
 -1,
 631331035,
 71251,
 631514534,
 631285925,
 -1,
 -55899,
 631465591,
 71254,
 -1,
 631522798,
 71255,
 631711145,
 631457742,
 -1,
 -55896,
 631672680,
 71252,
 -1,
 631727571,
 71253,
 -55894,
 631690622,
 71248,
 -55893,
 631867832,
 71249,
 -55892,
 631931483,
 71257,
 -1,
 631980142,
 71256,
 -55890,
 631213819,
 71234,
 -1,
 632102713,
 71233,
 632300983,
 631156086,
 -1,
 632366515,
 632277329,
 -1,
 -55886,
 632334811,
 71230,
 -1,
 632397301,
 71231,
 632563126,
 632297638,
 -1,
 -55883,
 632528661,
 71232,
 -1,
 632587582,
 71229,
 -1,
 632510991,
 71236,
 -1,
 632232380,
 71235,
 632890824,
 612138810,
 -1,
 632956352,
 632849854,
 -1,
 633021887,
 632901820,
 -1,
 633087422,
 633000578,
 -1,
 -55875,
 633036488,
 9867,
 -1,
 633085805,
 9866,
 -1,
 633028092,
 119552,
 -1,
 632986922,
 128669,
 633415109,
 632899527,
 -1,
 633480644,
 633339904,
 -1,
 -55869,
 633458515,
 128184,
 -1,
 633480579,
 128176,
 -1,
 633409180,
 129297,
 633742791,
 633367004,
 128018,
 -1,
 633668322,
 128053,
 -1,
 633688186,
 6314,
 633939411,
 632864539,
 -1,
 634004944,
 633898071,
 -1,
 634070479,
 633937044,
 9968,
 634191871,
 633995264,
 -1,
 -55859,
 634101039,
 128670,
 -55858,
 634137321,
 128672,
 -1,
 634202035,
 128693,
 -1,
 633996041,
 128507,
 634463698,
 633973300,
 128001,
 -1,
 634389218,
 128045,
 -1,
 634435411,
 128068,
 634660311,
 633874394,
 128241,
 634781695,
 634585088,
 -1,
 -55850,
 634703578,
 128242,
 -1,
 634750725,
 128244,
 634922458,
 634632994,
 -1,
 -55847,
 634899525,
 128739,
 -1,
 634913155,
 128741,
 635119069,
 634881470,
 -1,
 -55844,
 635076438,
 127889,
 -1,
 635122885,
 128496,
 -55842,
 635097838,
 128511,
 -55841,
 635292006,
 127909,
 -1,
 635351315,
 128332,
 635512588,
 612047014,
 -1,
 635577938,
 635469626,
 128104,
 635643432,
 635526044,
 -1,
 635708948,
 635597182,
 -1,
 635774442,
 635676837,
 -1,
 635839976,
 635705510,
 -1,
 -55833,
 635796194,
 68312,
 -1,
 635844355,
 68317,
 -55831,
 635808861,
 68323,
 -1,
 635983474,
 68322,
 636167662,
 635745413,
 -1,
 -55828,
 636113654,
 68309,
 -55827,
 636175631,
 68302,
 -1,
 636232910,
 68324,
 636429810,
 636098726,
 -1,
 -55824,
 636408786,
 68313,
 -55823,
 636449115,
 68288,
 -1,
 636495127,
 68314,
 636691957,
 636409029,
 -1,
 -55820,
 636638259,
 68298,
 -1,
 636691735,
 68297,
 636888568,
 636670366,
 -1,
 -55817,
 636849232,
 68319,
 -1,
 636887127,
 68305,
 637085179,
 636852904,
 -1,
 -55814,
 637045840,
 68318,
 -1,
 637097927,
 68320,
 637281790,
 637036573,
 -1,
 -55811,
 637227968,
 68306,
 -1,
 637280343,
 68304,
 637478401,
 637232886,
 -1,
 -55808,
 637424691,
 68300,
 -1,
 637478167,
 68299,
 637675011,
 637424702,
 68294,
 -1,
 637646675,
 68301,
 637806086,
 637619476,
 -1,
 -55803,
 637755004,
 68291,
 -1,
 637818476,
 68292,
 638002697,
 637744312,
 -1,
 -55800,
 637948662,
 68308,
 -1,
 638000567,
 68293,
 638199308,
 637936932,
 -1,
 -55797,
 638145854,
 68290,
 -1,
 638207247,
 68289,
 -55795,
 638178395,
 68303,
 -55794,
 638372905,
 68295,
 -55793,
 638427402,
 68321,
 -55792,
 638489859,
 68315,
 -55791,
 638551349,
 68311,
 -55790,
 638614267,
 68310,
 -55789,
 638676142,
 68307,
 -1,
 638732425,
 68316,
 638920221,
 635673116,
 -1,
 638985753,
 638859373,
 -1,
 639051288,
 638956677,
 68340,
 -1,
 638979519,
 68339,
 -1,
 639025243,
 68338,
 -55782,
 638959206,
 68341,
 -55781,
 639218116,
 68336,
 -55780,
 639267662,
 68342,
 -1,
 639322702,
 68337,
 639510052,
 638878969,
 -1,
 639575585,
 639480965,
 -1,
 -55776,
 639552649,
 68334,
 -1,
 639582602,
 68333,
 639772195,
 639535544,
 68331,
 -1,
 639697761,
 68335,
 -1,
 639715812,
 68332,
 639968807,
 639441321,
 -1,
 -55770,
 639903458,
 68326,
 -1,
 639965669,
 68325,
 -1,
 639937957,
 68296,
 640230985,
 635581818,
 -1,
 640296517,
 640184702,
 -1,
 640362046,
 640227494,
 -1,
 640427566,
 640329893,
 2126,
 -55763,
 640406725,
 2129,
 -1,
 640438776,
 2132,
 640624176,
 640398469,
 2133,
 -1,
 640595077,
 2120,
 640755250,
 640575517,
 2122,
 -1,
 640723248,
 2121,
 -55757,
 640734405,
 2118,
 -55756,
 640851023,
 2131,
 -55755,
 640916136,
 2130,
 -55754,
 640979750,
 2128,
 -55753,
 641040186,
 2125,
 -55752,
 641103628,
 2124,
 -55751,
 641166255,
 2123,
 -55750,
 641228488,
 2136,
 -55749,
 641290744,
 2116,
 -55748,
 641355028,
 2114,
 -55747,
 641414328,
 2115,
 -1,
 641475876,
 2113,
 641672769,
 640309827,
 -1,
 -55744,
 641643653,
 2119,
 -1,
 641695546,
 2127,
 -55742,
 641648136,
 2117,
 -55741,
 641820838,
 2135,
 -55740,
 641880791,
 2112,
 -1,
 641940597,
 2134,
 -55738,
 640272875,
 2138,
 -55737,
 642095632,
 2142,
 -55736,
 642141893,
 2139,
 -1,
 642194390,
 2137,
 642393679,
 640155648,
 -1,
 642459213,
 642371169,
 -1,
 -55732,
 642432435,
 128115,
 -1,
 642470241,
 128114,
 -55730,
 642408143,
 128372,
 -1,
 642588449,
 128107,
 -55728,
 642365087,
 128368,
 -55727,
 642754845,
 128094,
 -1,
 642786077,
 8380,
 642983633,
 635523576,
 -1,
 643049114,
 642934753,
 -1,
 643114594,
 643016869,
 -1,
 643180122,
 643065479,
 -1,
 643245657,
 643115673,
 -1,
 -55720,
 643195927,
 127006,
 -1,
 643257319,
 126988,
 -1,
 643179957,
 126997,
 643507807,
 643122692,
 -1,
 643573342,
 643443353,
 -1,
 -55715,
 643523607,
 127007,
 -1,
 643584999,
 126989,
 -1,
 643507637,
 126998,
 -55712,
 643482203,
 127015,
 -55711,
 643799431,
 127014,
 -1,
 643862649,
 126977,
 644032109,
 643085445,
 -1,
 644097640,
 644010079,
 -1,
 644163175,
 644033177,
 -1,
 -55706,
 644113431,
 127002,
 -1,
 644174823,
 126984,
 -1,
 644097461,
 126993,
 644481023,
 644045151,
 -1,
 644490860,
 644360857,
 -1,
 -55701,
 644441111,
 127003,
 -1,
 644502503,
 126985,
 -1,
 644425141,
 126994,
 644753016,
 643975118,
 -1,
 644818547,
 644714432,
 -1,
 644884082,
 644754073,
 -1,
 -55695,
 644834327,
 127004,
 -1,
 644895719,
 126986,
 -1,
 644818357,
 126995,
 645201919,
 644769312,
 -1,
 645211767,
 645081753,
 -1,
 -55690,
 645162007,
 127005,
 -1,
 645223399,
 126987,
 -1,
 645146037,
 126996,
 645473919,
 644711870,
 -1,
 645539454,
 645431463,
 -1,
 645604989,
 645474969,
 -1,
 -55684,
 645555223,
 127001,
 -1,
 645616615,
 126983,
 -1,
 645539253,
 126992,
 -1,
 645504740,
 127011,
 645932678,
 645431098,
 -1,
 645998213,
 645881877,
 -1,
 646063748,
 645933721,
 -1,
 -55677,
 646013975,
 127009,
 -1,
 646075367,
 126991,
 -1,
 645998005,
 127000,
 -1,
 645959091,
 126979,
 646391437,
 645872814,
 -1,
 646456972,
 646339907,
 -1,
 646522507,
 646392473,
 -1,
 -55670,
 646472727,
 127008,
 -1,
 646534119,
 126990,
 -1,
 646456757,
 126999,
 -1,
 646390506,
 126976,
 646850193,
 646368014,
 -1,
 -55665,
 646799949,
 127017,
 -55664,
 646862548,
 126982,
 -1,
 646923486,
 126978,
 647112340,
 646784345,
 -1,
 -55661,
 647068157,
 127012,
 -1,
 647114567,
 127019,
 -55659,
 647077877,
 126980,
 -55658,
 647272270,
 127010,
 -55657,
 647325654,
 127018,
 -55656,
 647385418,
 126981,
 -55655,
 647441926,
 127013,
 -1,
 647505030,
 127016,
 647757823,
 642981126,
 -1,
 647767757,
 647654319,
 -1,
 647833292,
 647709999,
 -1,
 647898787,
 647804037,
 -1,
 647964321,
 647869573,
 -1,
 -55648,
 647909902,
 69983,
 -1,
 647960742,
 69982,
 -55646,
 647909902,
 69988,
 -1,
 648091814,
 69987,
 648292009,
 647836856,
 -1,
 648357543,
 648230072,
 -1,
 -55642,
 648303118,
 69985,
 -1,
 648353958,
 69984,
 -55640,
 648303118,
 69990,
 -1,
 648485030,
 69989,
 648685229,
 648249146,
 -1,
 -55637,
 648663771,
 69981,
 -55636,
 648707984,
 69986,
 -1,
 648747174,
 69991,
 648947376,
 648649807,
 -1,
 -55633,
 648912067,
 70002,
 -1,
 648943782,
 69997,
 649143987,
 648909606,
 -1,
 -55630,
 649089550,
 69993,
 -1,
 649140390,
 69992,
 649340598,
 649095197,
 -1,
 -55627,
 649286158,
 69974,
 -1,
 649336998,
 69973,
 649537209,
 649291510,
 -1,
 -55624,
 649482766,
 69980,
 -1,
 649533606,
 69979,
 649733820,
 649481492,
 -1,
 -55621,
 649679374,
 69976,
 -1,
 649730214,
 69975,
 649930431,
 649669273,
 -1,
 -55618,
 649875982,
 69978,
 -1,
 649926822,
 69977,
 650127042,
 649864484,
 -1,
 -55615,
 650072590,
 69995,
 -1,
 650123430,
 69994,
 -55613,
 650102451,
 69999,
 -55612,
 650297115,
 69970,
 -55611,
 650357040,
 70000,
 -55610,
 650413502,
 69972,
 -55609,
 650475362,
 69996,
 -55608,
 650537949,
 69998,
 -55607,
 650598979,
 69969,
 -55606,
 650662414,
 70001,
 -55605,
 650722478,
 69971,
 -1,
 650778790,
 69968,
 -1,
 647781648,
 70006,
 651044560,
 647735461,
 -1,
 -55601,
 650993107,
 70003,
 -1,
 651050688,
 70005,
 -1,
 650975676,
 70004,
 651306742,
 642935727,
 -1,
 651372273,
 651240697,
 -1,
 651437791,
 651325822,
 -1,
 651503323,
 651374007,
 -1,
 651568855,
 651460410,
 3451,
 -1,
 651525946,
 3450,
 651699929,
 651520943,
 3453,
 -1,
 651652015,
 3454,
 -55590,
 651667293,
 3452,
 -1,
 651782173,
 3455,
 -55588,
 651476329,
 3386,
 -55587,
 651920156,
 3369,
 -55586,
 651966747,
 3406,
 -1,
 652026061,
 3423,
 652224227,
 651414196,
 -1,
 652289762,
 652176303,
 3426,
 -1,
 652241839,
 3427,
 -1,
 652257117,
 3396,
 652486376,
 652182777,
 -1,
 652551911,
 652446140,
 -1,
 -55578,
 652523531,
 3442,
 -1,
 652564956,
 3441,
 -1,
 652523193,
 3440,
 652814061,
 652430385,
 -1,
 652879596,
 652773820,
 -1,
 -55573,
 652843904,
 3443,
 -1,
 652890765,
 3444,
 -1,
 652851321,
 3445,
 653141744,
 652782966,
 -1,
 -55569,
 653077338,
 3329,
 -1,
 653141136,
 3389,
 -1,
 653080033,
 3449,
 653459455,
 651312304,
 -1,
 653469429,
 653381396,
 -1,
 -55564,
 653438321,
 9894,
 -1,
 653467378,
 9895,
 -1,
 653401807,
 9893,
 653731591,
 651278239,
 -1,
 653797116,
 653697503,
 -1,
 653862651,
 653741961,
 -1,
 -55558,
 653839815,
 10221,
 -1,
 653871672,
 10223,
 -1,
 653831624,
 10187,
 654124799,
 653750057,
 -1,
 -55554,
 654101959,
 10220,
 -1,
 654133816,
 10222,
 654321410,
 654075219,
 -1,
 -55551,
 654272246,
 120485,
 -1,
 654334531,
 120484,
 654518021,
 654256376,
 -1,
 -55548,
 654487322,
 120779,
 -1,
 654519177,
 120778,
 -55546,
 654486029,
 120001,
 -1,
 654657617,
 10189,
 654845706,
 653693734,
 -1,
 -55543,
 654798441,
 127809,
 -1,
 654838085,
 9967,
 -55541,
 654823986,
 128470,
 -1,
 655009642,
 9901,
 655173598,
 635491119,
 -1,
 655239027,
 655125423,
 -1,
 655304559,
 655181103,
 -1,
 655370030,
 655272101,
 -1,
 655435565,
 655315448,
 -1,
 655501098,
 655367852,
 -1,
 655566614,
 655458106,
 -1,
 -55532,
 655545051,
 4218,
 -55531,
 655589264,
 43491,
 -1,
 655628454,
 4220,
 655828761,
 655517725,
 -1,
 -55528,
 655774222,
 4214,
 -1,
 655825062,
 4213,
 656025372,
 655772948,
 -1,
 -55525,
 655970830,
 43488,
 -1,
 656021670,
 4215,
 656221983,
 655960729,
 -1,
 -55522,
 656167438,
 43489,
 -1,
 656218278,
 4216,
 656418594,
 656155940,
 -1,
 -55519,
 656364046,
 43492,
 -1,
 656414886,
 4223,
 -55517,
 656397525,
 4217,
 -55516,
 656586587,
 4224,
 -55515,
 656643639,
 4221,
 -55514,
 656697227,
 43490,
 -55513,
 656757262,
 4225,
 -55512,
 656820259,
 4222,
 -55511,
 656880966,
 4219,
 -1,
 656939174,
 4130,
 657195007,
 655477860,
 -1,
 -55508,
 657107793,
 43647,
 -1,
 657141031,
 43646,
 -1,
 655380016,
 4193,
 657401673,
 655321590,
 -1,
 657467188,
 657339576,
 -1,
 657532723,
 657405112,
 -1,
 -55502,
 657478158,
 43625,
 -1,
 657528998,
 43624,
 -1,
 657478158,
 43626,
 657794871,
 657440048,
 -1,
 -55498,
 657740302,
 43623,
 -1,
 657791142,
 43622,
 657991482,
 657751866,
 -1,
 -55495,
 657969883,
 43621,
 -1,
 657987750,
 43627,
 658188093,
 657942262,
 -1,
 -55492,
 658133518,
 43620,
 -1,
 658184358,
 43619,
 658384704,
 658133496,
 -1,
 -55489,
 658330126,
 43630,
 -1,
 658380966,
 43629,
 658581315,
 658320025,
 -1,
 -55486,
 658526734,
 43618,
 -1,
 658577574,
 43617,
 -55484,
 658560213,
 43634,
 -55483,
 658756026,
 43633,
 -55482,
 658811184,
 43628,
 -55481,
 658873539,
 43635,
 -55480,
 658918755,
 43616,
 -1,
 658982947,
 43631,
 659171166,
 657372529,
 -1,
 659236688,
 659109048,
 -1,
 659302222,
 659174584,
 -1,
 -55475,
 659247630,
 43502,
 -1,
 659298470,
 43501,
 -55473,
 659247630,
 43516,
 -1,
 659429542,
 43515,
 659629907,
 659193658,
 -1,
 -55470,
 659608283,
 43495,
 -1,
 659652496,
 43503,
 659826518,
 659580662,
 -1,
 -55467,
 659771918,
 43500,
 -1,
 659822758,
 43499,
 660023129,
 659770644,
 -1,
 -55464,
 659968526,
 43498,
 -1,
 660019366,
 43497,
 660219740,
 659957028,
 -1,
 -55461,
 660165134,
 43518,
 -1,
 660215974,
 43517,
 -55459,
 660173830,
 43514,
 -1,
 660359203,
 43496,
 660547429,
 659127711,
 -1,
 660612962,
 660481665,
 -1,
 -55455,
 660552878,
 4189,
 -1,
 660609190,
 4188,
 -55453,
 660570582,
 4186,
 -55452,
 660760459,
 4187,
 -1,
 660815022,
 4136,
 661006185,
 660487745,
 -1,
 -55449,
 660985025,
 4207,
 -55448,
 661029638,
 4206,
 -1,
 661082067,
 4208,
 661268332,
 660982993,
 -1,
 -55445,
 661239643,
 4197,
 -1,
 661297821,
 4198,
 -55443,
 661235765,
 4238,
 -55442,
 661410078,
 4159,
 -1,
 661462266,
 43642,
 661716991,
 655263541,
 -1,
 -55439,
 661625592,
 43637,
 -55438,
 661685759,
 43636,
 -1,
 661739290,
 43638,
 661923750,
 655206565,
 -1,
 661989264,
 661872065,
 -1,
 662054785,
 661957518,
 -1,
 662120315,
 662026972,
 -1,
 -55432,
 662050190,
 4234,
 -55431,
 662115481,
 4233,
 -55430,
 662180519,
 4232,
 -1,
 662245762,
 4231,
 662448000,
 662057520,
 -1,
 662513535,
 662420188,
 -1,
 -55426,
 662442663,
 4236,
 -1,
 662507906,
 4235,
 -1,
 662454652,
 4237,
 -1,
 662415851,
 43493,
 662841223,
 662031588,
 -1,
 -55421,
 662770841,
 4205,
 -55420,
 662836165,
 4204,
 -55419,
 662901415,
 4203,
 -55418,
 662966658,
 4202,
 -1,
 663031899,
 4201,
 663234442,
 662812028,
 -1,
 -55415,
 663164057,
 43645,
 -1,
 663228802,
 43644,
 663431053,
 663185939,
 -1,
 -55412,
 663360167,
 4251,
 -1,
 663425115,
 4250,
 -55410,
 663398470,
 4239,
 -55409,
 663589923,
 43643,
 -1,
 663626372,
 4154,
 663824286,
 661934866,
 -1,
 663889812,
 663794821,
 -1,
 -55405,
 663867339,
 4242,
 -1,
 663902427,
 4243,
 664086423,
 663857317,
 -1,
 -55402,
 664036983,
 4246,
 -1,
 664094190,
 4247,
 664283034,
 664029134,
 -1,
 -55399,
 664244072,
 4244,
 -1,
 664298963,
 4245,
 -55397,
 664262014,
 4240,
 -55396,
 664439224,
 4241,
 -55395,
 664502875,
 4249,
 -1,
 664551534,
 4248,
 664797183,
 663802906,
 -1,
 664807331,
 664673515,
 -1,
 -55391,
 664780381,
 43641,
 -55390,
 664832440,
 43640,
 -1,
 664880837,
 43639,
 665124863,
 664775566,
 -1,
 -55387,
 665029048,
 4254,
 -1,
 665077445,
 4255,
 665266109,
 661899930,
 -1,
 665331630,
 665233573,
 -1,
 665397165,
 665277197,
 -1,
 665462699,
 665337006,
 4228,
 -1,
 665387013,
 4229,
 -55380,
 665405810,
 4230,
 -1,
 665524564,
 4227,
 -1,
 665341475,
 4194,
 665790386,
 665282910,
 -1,
 -55376,
 665763611,
 4211,
 -55375,
 665814748,
 4210,
 -1,
 665861962,
 4212,
 666052533,
 665767121,
 -1,
 -55372,
 666026326,
 4200,
 -1,
 666060117,
 4199,
 666249144,
 666008991,
 -1,
 -55369,
 666207678,
 4148,
 -1,
 666263018,
 4147,
 666445754,
 666180850,
 4252,
 -1,
 666393155,
 4253,
 -55365,
 666416605,
 4139,
 -55364,
 666521251,
 4209,
 -1,
 666582195,
 4149,
 666773455,
 665236613,
 -1,
 666838988,
 666704995,
 -1,
 666904514,
 666809477,
 -1,
 -55359,
 666881995,
 43506,
 -1,
 666917083,
 43507,
 667101125,
 666871973,
 -1,
 -55356,
 667051639,
 43510,
 -1,
 667108846,
 43511,
 667297736,
 667043790,
 -1,
 -55353,
 667258728,
 43508,
 -1,
 667313619,
 43509,
 -55351,
 667276670,
 43504,
 -55350,
 667453880,
 43505,
 -55349,
 667517531,
 43513,
 -1,
 667566190,
 43512,
 667811839,
 666798590,
 -1,
 -55346,
 667707781,
 4196,
 -1,
 667767833,
 4195,
 667953115,
 666710322,
 -1,
 668018650,
 667907852,
 -1,
 668084182,
 667959088,
 -1,
 -55341,
 668062427,
 4155,
 -55340,
 668126030,
 4157,
 -55339,
 668179651,
 4156,
 -1,
 668226062,
 4158,
 668467199,
 668043599,
 -1,
 -55336,
 668368784,
 4190,
 -55335,
 668432226,
 4191,
 -1,
 668494813,
 4192,
 -1,
 667986836,
 4226,
 668794879,
 667909465,
 -1,
 -55331,
 668707747,
 43494,
 -1,
 668756478,
 43632,
 668936345,
 655120963,
 -1,
 669001867,
 668868667,
 -1,
 669067349,
 668955006,
 -1,
 669132787,
 669037701,
 -1,
 669198314,
 669092432,
 -1,
 -55324,
 669128510,
 94105,
 -55323,
 669193822,
 94104,
 -55322,
 669259150,
 94103,
 -55321,
 669324441,
 94102,
 -55320,
 669389765,
 94101,
 -55319,
 669455015,
 94100,
 -1,
 669520258,
 94099,
 669722606,
 669165733,
 -1,
 -55316,
 669690160,
 93994,
 -55315,
 669733390,
 93998,
 -1,
 669784230,
 94007,
 669984753,
 669676068,
 -1,
 -55312,
 669962971,
 93980,
 -1,
 669980838,
 93978,
 -55310,
 669955335,
 93966,
 -1,
 670111910,
 93962,
 670312448,
 669089594,
 -1,
 670377975,
 670290562,
 -1,
 -55306,
 670323214,
 93997,
 -1,
 670374054,
 93996,
 670574586,
 670334778,
 -1,
 -55303,
 670519822,
 93973,
 -1,
 670570662,
 93972,
 670771197,
 670518548,
 -1,
 -55300,
 670716430,
 93988,
 -1,
 670767270,
 93987,
 670967807,
 670701734,
 93968,
 -1,
 670935401,
 94032,
 -1,
 670913038,
 93969,
 671164428,
 670291141,
 -1,
 671229959,
 671143109,
 -1,
 671295493,
 671197349,
 -1,
 -55292,
 671273691,
 94017,
 -1,
 671291558,
 94014,
 -55290,
 671273691,
 94016,
 -1,
 671422630,
 94013,
 671623178,
 671197349,
 -1,
 -55287,
 671568398,
 94006,
 -1,
 671619238,
 94012,
 -55285,
 671568398,
 94005,
 -1,
 671750310,
 94011,
 671950871,
 671142862,
 -1,
 672016403,
 671921285,
 -1,
 672081937,
 671983781,
 -1,
 -55280,
 672027150,
 94000,
 -1,
 672077990,
 94009,
 -55278,
 672052487,
 93964,
 -1,
 672209062,
 93965,
 -55276,
 671978364,
 93954,
 -55275,
 672367366,
 93970,
 -55274,
 672426095,
 93984,
 -1,
 672480425,
 94001,
 672671776,
 671916154,
 -1,
 672737311,
 672631376,
 -1,
 -55270,
 672667454,
 94111,
 -55269,
 672732558,
 94110,
 -55268,
 672797849,
 94109,
 -55267,
 672863173,
 94108,
 -55266,
 672928130,
 94107,
 -1,
 672993371,
 94106,
 -1,
 672705361,
 94002,
 673261610,
 672609464,
 -1,
 673327141,
 673240261,
 -1,
 -55261,
 673305813,
 93995,
 -55260,
 673337870,
 93999,
 -1,
 673388710,
 94008,
 673589288,
 673280548,
 -1,
 -55257,
 673567451,
 93981,
 -1,
 673585318,
 93979,
 -55255,
 673527110,
 93967,
 -1,
 673716390,
 93963,
 673916978,
 673192102,
 -1,
 673982513,
 673881801,
 -1,
 674048047,
 673939258,
 -1,
 -55250,
 673992035,
 93989,
 -1,
 674044070,
 93971,
 -55248,
 674027067,
 94015,
 -1,
 674199394,
 93958,
 -1,
 673927672,
 94019,
 674441272,
 673868719,
 -1,
 674506806,
 674386424,
 -1,
 -55243,
 674484955,
 93977,
 -1,
 674502822,
 93976,
 -55241,
 674484955,
 93975,
 -1,
 674633894,
 93974,
 674834492,
 674408613,
 -1,
 -55238,
 674801968,
 94004,
 -55237,
 674845198,
 94003,
 -1,
 674896038,
 94010,
 675096641,
 674778388,
 -1,
 675162176,
 675041784,
 -1,
 -55233,
 675107342,
 93993,
 -1,
 675158182,
 93992,
 -1,
 675092646,
 93983,
 675424324,
 675071645,
 -1,
 -55229,
 675366947,
 93961,
 -1,
 675420326,
 93960,
 675620935,
 675388072,
 -1,
 -55226,
 675564899,
 93986,
 -1,
 675616934,
 93985,
 675817546,
 675582758,
 -1,
 -55223,
 675769309,
 93955,
 -1,
 675813542,
 93952,
 676014157,
 675772172,
 -1,
 -55220,
 675959310,
 93957,
 -1,
 676010150,
 93956,
 676210768,
 675959288,
 -1,
 -55217,
 676155918,
 94020,
 -1,
 676206758,
 93990,
 -55215,
 676188602,
 93991,
 -55214,
 676383566,
 94018,
 -55213,
 676423791,
 93982,
 -55212,
 676481059,
 93959,
 -1,
 676537689,
 93953,
 676735105,
 669043354,
 -1,
 676800607,
 676682307,
 94049,
 676866138,
 676731046,
 94050,
 676986879,
 676822842,
 94051,
 -1,
 676875540,
 94052,
 -55205,
 676839195,
 94056,
 -55204,
 677021118,
 94053,
 -55203,
 677085587,
 94057,
 -55202,
 677141059,
 94055,
 -1,
 677199022,
 94054,
 677390440,
 676731046,
 94036,
 677455970,
 677347130,
 94039,
 -1,
 677399828,
 94040,
 677587044,
 677395630,
 94067,
 -1,
 677526702,
 94068,
 -55195,
 677560091,
 94075,
 -55194,
 677665347,
 94073,
 -55193,
 677729663,
 94038,
 -1,
 677779622,
 94037,
 677980271,
 677363483,
 94058,
 678045804,
 677910694,
 94059,
 678166527,
 678002490,
 94060,
 -1,
 678055188,
 94061,
 -55187,
 678018843,
 94062,
 -55186,
 678199699,
 94064,
 -1,
 678248547,
 94063,
 678439029,
 677919918,
 94045,
 678504562,
 678403151,
 94071,
 -1,
 678468687,
 94069,
 678635636,
 678461242,
 94046,
 -1,
 678579476,
 94047,
 -1,
 678582851,
 94074,
 678832249,
 678397374,
 94041,
 -55177,
 678805275,
 94076,
 -55176,
 678856126,
 94042,
 -1,
 678905799,
 94048,
 679094395,
 678810242,
 94065,
 -1,
 679041603,
 94066,
 679225469,
 679070478,
 94044,
 -1,
 679183806,
 94043,
 679356543,
 679192388,
 94072,
 -1,
 679320655,
 94070,
 679542783,
 679313210,
 94077,
 -1,
 679431444,
 94078,
 679618694,
 676707011,
 -1,
 -55165,
 679590648,
 94096,
 -55164,
 679649925,
 94095,
 -55163,
 679683810,
 94098,
 -1,
 679746021,
 94097,
 680001535,
 679587190,
 -1,
 680011914,
 679911536,
 -1,
 -55159,
 679987740,
 94034,
 -1,
 680010456,
 94035,
 -1,
 679944920,
 94033,
 680274066,
 668938824,
 -1,
 680339599,
 680232382,
 -1,
 -55154,
 680307207,
 128300,
 -1,
 680367698,
 127908,
 680591359,
 680263680,
 -1,
 -55151,
 680495476,
 983231,
 -1,
 680539592,
 983232,
 680732822,
 680231450,
 -1,
 -55148,
 680688909,
 128469,
 -55147,
 680736757,
 128189,
 -1,
 680798807,
 128656,
 681050111,
 680684463,
 -1,
 -55144,
 680946572,
 127756,
 -1,
 681010542,
 127894,
 681191658,
 668909339,
 -1,
 681257168,
 681145951,
 -1,
 681322703,
 681189331,
 -1,
 681388238,
 681275774,
 -1,
 681453732,
 681325752,
 -1,
 681519266,
 681391288,
 -1,
 -55136,
 681464334,
 70292,
 -55135,
 681522502,
 70291,
 -1,
 681580710,
 70290,
 -55133,
 681464334,
 70297,
 -1,
 681711782,
 70296,
 681912490,
 681424005,
 -1,
 681978024,
 681882757,
 -1,
 -55129,
 681923086,
 70289,
 -1,
 681973926,
 70288,
 -55127,
 681923086,
 70295,
 -1,
 682104998,
 70294,
 682305710,
 681876559,
 -1,
 -55124,
 682269891,
 70311,
 -55123,
 682316302,
 70312,
 -1,
 682367142,
 70306,
 682567858,
 682262330,
 -1,
 -55120,
 682545883,
 70287,
 -55119,
 682590096,
 70293,
 -1,
 682629286,
 70298,
 682830005,
 682529574,
 -1,
 -55116,
 682775054,
 70300,
 -1,
 682825894,
 70299,
 683026616,
 682780701,
 -1,
 -55113,
 682971662,
 70277,
 -1,
 683022502,
 70276,
 683223227,
 682977014,
 -1,
 -55110,
 683173652,
 70285,
 -1,
 683219110,
 70284,
 683419838,
 683166996,
 -1,
 -55107,
 683364878,
 70280,
 -1,
 683415718,
 70278,
 683616449,
 683354777,
 -1,
 -55104,
 683561486,
 70283,
 -1,
 683612326,
 70282,
 683813060,
 683549988,
 -1,
 -55101,
 683758094,
 70303,
 -1,
 683808934,
 70301,
 -55099,
 683791067,
 70305,
 -55098,
 683984563,
 70308,
 -55097,
 684048155,
 70274,
 -55096,
 684108080,
 70309,
 -55095,
 684160866,
 70304,
 -55094,
 684223453,
 70307,
 -55093,
 684284483,
 70273,
 -55092,
 684347918,
 70310,
 -55091,
 684407982,
 70275,
 -1,
 684464294,
 70272,
 -1,
 681355866,
 70313,
 -1,
 681272190,
 127926,
 684851199,
 681224357,
 -1,
 684861673,
 684743551,
 -1,
 684927206,
 684828837,
 -1,
 684992741,
 684905498,
 -1,
 685058276,
 684943945,
 -1,
 685123802,
 684997806,
 -1,
 685189337,
 685071756,
 -1,
 -55080,
 685163346,
 119271,
 -1,
 685193910,
 119270,
 -1,
 685146151,
 119263,
 685451485,
 685087647,
 -1,
 -55076,
 685425490,
 119269,
 -1,
 685456054,
 119268,
 685648096,
 685393870,
 -1,
 -55073,
 685600120,
 119272,
 -1,
 685661974,
 119264,
 -55071,
 685624804,
 119266,
 -55070,
 685809607,
 119265,
 -55069,
 685855411,
 119267,
 -1,
 685910696,
 119262,
 -1,
 685014688,
 119081,
 -1,
 684929527,
 127932,
 686237928,
 684878304,
 127929,
 -1,
 686165175,
 127896,
 -1,
 686195627,
 127925,
 -1,
 684808590,
 127812,
 686500131,
 681158202,
 -1,
 686565650,
 686453118,
 -1,
 686631152,
 686535813,
 -1,
 -55058,
 686576709,
 92757,
 -55057,
 686637264,
 92766,
 -1,
 686692518,
 92736,
 686893299,
 686589374,
 92754,
 -55054,
 686851518,
 92753,
 -1,
 686910383,
 92749,
 687089911,
 686843933,
 -1,
 -55051,
 687048126,
 92761,
 -55050,
 687100496,
 92744,
 -1,
 687160755,
 92748,
 687352058,
 687053903,
 -1,
 -55047,
 687310270,
 92755,
 -1,
 687364675,
 92765,
 687548669,
 687313702,
 -1,
 -55044,
 687494534,
 92743,
 -1,
 687544486,
 92752,
 687745280,
 687505210,
 -1,
 -55041,
 687693512,
 92751,
 -1,
 687755224,
 92737,
 687941891,
 687699724,
 -1,
 -55038,
 687890018,
 92739,
 -1,
 687938365,
 92750,
 688138501,
 687893469,
 92763,
 -1,
 688095034,
 92762,
 688269576,
 688083470,
 -1,
 -55033,
 688227774,
 92745,
 -1,
 688282179,
 92764,
 688466186,
 688209070,
 92760,
 -1,
 688396454,
 92758,
 688597260,
 688403782,
 92741,
 -1,
 688544323,
 92746,
 -55027,
 688575568,
 92738,
 -55026,
 688704334,
 92759,
 -55025,
 688761931,
 92756,
 -55024,
 688795156,
 92747,
 -55023,
 688858457,
 92740,
 -1,
 688920742,
 92742,
 689176575,
 686503096,
 -1,
 689187105,
 689069482,
 -1,
 689252631,
 689157253,
 -1,
 -55018,
 689229771,
 92770,
 -1,
 689264859,
 92771,
 689449242,
 689219749,
 -1,
 -55015,
 689399415,
 92774,
 -1,
 689456622,
 92775,
 689645853,
 689391566,
 -1,
 -55012,
 689606504,
 92772,
 -1,
 689661395,
 92773,
 -55010,
 689624446,
 92768,
 -55009,
 689801656,
 92769,
 -55008,
 689865307,
 92777,
 -1,
 689913966,
 92776,
 -55006,
 689147643,
 92783,
 -1,
 690036537,
 92782,
 -55004,
 686476046,
 983173,
 -55003,
 690211573,
 983212,
 -1,
 690257507,
 983224,
 690433839,
 575281318,
 -1,
 690498493,
 690388794,
 -1,
 690564014,
 690430951,
 -1,
 690629032,
 690491483,
 -1,
 690694464,
 690556754,
 -1,
 690759983,
 690624094,
 83070,
 -54995,
 690694809,
 83073,
 -54994,
 690758948,
 83072,
 -1,
 690821286,
 83071,
 691022131,
 690688965,
 83062,
 -54991,
 690956953,
 83065,
 -54990,
 691021092,
 83064,
 -1,
 691083430,
 83063,
 691284278,
 690951321,
 83066,
 -54987,
 691217700,
 83068,
 -1,
 691280038,
 83067,
 691480888,
 691212674,
 83059,
 -1,
 691411110,
 83060,
 691611962,
 691408987,
 83057,
 -1,
 691542182,
 83058,
 691743036,
 691539794,
 83055,
 -1,
 691673254,
 83056,
 -54979,
 691673071,
 83075,
 -54978,
 691803966,
 83074,
 -54977,
 691869070,
 83069,
 -1,
 691933863,
 83061,
 692136270,
 690622555,
 -1,
 692201796,
 692064082,
 83076,
 -54973,
 692135204,
 83078,
 -1,
 692197542,
 83077,
 692398406,
 692130969,
 83083,
 -1,
 692328614,
 83084,
 -54969,
 692328431,
 83088,
 -54968,
 692459326,
 83087,
 -54967,
 692524638,
 83086,
 -54966,
 692589966,
 83085,
 -54965,
 692655045,
 83082,
 -54964,
 692720295,
 83081,
 -54963,
 692785538,
 83080,
 -1,
 692850779,
 83079,
 693053786,
 692064935,
 -1,
 693119313,
 692982937,
 83105,
 -1,
 693049510,
 83106,
 -54958,
 693049327,
 83110,
 -54957,
 693180222,
 83109,
 -54956,
 693245534,
 83108,
 -54955,
 693310862,
 83107,
 -54954,
 693375941,
 83104,
 -54953,
 693441191,
 83103,
 -54952,
 693506434,
 83102,
 -54951,
 693571675,
 83101,
 -1,
 693636946,
 83100,
 693840230,
 692982146,
 -1,
 693905757,
 693769369,
 83094,
 -1,
 693835942,
 83095,
 -54946,
 693835759,
 83099,
 -54945,
 693966654,
 83098,
 -54944,
 694031966,
 83097,
 -54943,
 694097294,
 83096,
 -54942,
 694162373,
 83093,
 -54941,
 694227623,
 83092,
 -54940,
 694292866,
 83091,
 -54939,
 694358107,
 83090,
 -1,
 694423378,
 83089,
 694626673,
 693770223,
 -1,
 -54936,
 694556655,
 83170,
 -54935,
 694622014,
 83169,
 -54934,
 694687326,
 83168,
 -54933,
 694752654,
 83167,
 -54932,
 694817945,
 83166,
 -54931,
 694883269,
 83165,
 -54930,
 694948519,
 83164,
 -54929,
 695013762,
 83163,
 -54928,
 695079003,
 83162,
 -1,
 695144274,
 83161,
 695347580,
 694556478,
 -1,
 -54925,
 695277551,
 83160,
 -54924,
 695342910,
 83159,
 -54923,
 695408222,
 83158,
 -54922,
 695473550,
 83157,
 -54921,
 695538841,
 83156,
 -54920,
 695604165,
 83155,
 -54919,
 695669415,
 83154,
 -54918,
 695734658,
 83153,
 -54917,
 695799899,
 83152,
 -1,
 695865170,
 83151,
 696068487,
 695277150,
 -1,
 -54914,
 695998447,
 83150,
 -54913,
 696063806,
 83149,
 -54912,
 696129118,
 83148,
 -54911,
 696194446,
 83147,
 -54910,
 696259737,
 83146,
 -54909,
 696325061,
 83145,
 -54908,
 696390311,
 83144,
 -54907,
 696455554,
 83143,
 -54906,
 696520795,
 83142,
 -1,
 696586066,
 83141,
 696789394,
 695997838,
 -1,
 -54903,
 696719343,
 83140,
 -54902,
 696784702,
 83139,
 -54901,
 696850014,
 83138,
 -54900,
 696915342,
 83137,
 -54899,
 696980633,
 83136,
 -54898,
 697045957,
 83135,
 -54897,
 697111207,
 83134,
 -54896,
 697176450,
 83133,
 -54895,
 697241691,
 83132,
 -1,
 697306962,
 83131,
 697510301,
 696718489,
 -1,
 -54892,
 697440239,
 83130,
 -54891,
 697505598,
 83129,
 -54890,
 697570910,
 83128,
 -54889,
 697636238,
 83127,
 -54888,
 697701529,
 83126,
 -54887,
 697766853,
 83125,
 -54886,
 697832103,
 83124,
 -54885,
 697897346,
 83123,
 -54884,
 697962587,
 83122,
 -1,
 698027858,
 83121,
 698286079,
 697439173,
 -1,
 -54881,
 698161135,
 83120,
 -54880,
 698226494,
 83119,
 -54879,
 698291806,
 83118,
 -54878,
 698357134,
 83117,
 -54877,
 698422425,
 83116,
 -54876,
 698487749,
 83115,
 -54875,
 698552999,
 83114,
 -54874,
 698618242,
 83113,
 -54873,
 698683483,
 83112,
 -1,
 698748754,
 83111,
 698952231,
 690557607,
 -1,
 699017658,
 698880679,
 -1,
 699083182,
 698946958,
 83322,
 -54868,
 699017881,
 83325,
 -54867,
 699082020,
 83324,
 -1,
 699144358,
 83323,
 699345330,
 699011458,
 -1,
 -54864,
 699280025,
 83318,
 -54863,
 699344164,
 83317,
 -1,
 699406502,
 83316,
 -54861,
 699275247,
 83328,
 -54860,
 699537214,
 83327,
 -54859,
 699602526,
 83326,
 -54858,
 699667609,
 83321,
 -54857,
 699732933,
 83320,
 -54856,
 699798183,
 83319,
 -54855,
 699863131,
 83315,
 -1,
 699928402,
 83314,
 700131785,
 698947390,
 -1,
 700197309,
 700061070,
 83381,
 -1,
 700127398,
 83382,
 700328384,
 700125863,
 -1,
 -54849,
 700258470,
 83378,
 -1,
 700319831,
 83377,
 700524994,
 700256347,
 83374,
 -1,
 700455078,
 83375,
 -54845,
 700454895,
 83385,
 -54844,
 700585790,
 83384,
 -54843,
 700651102,
 83383,
 -54842,
 700716185,
 83380,
 -54841,
 700781509,
 83379,
 -54840,
 700846466,
 83376,
 -1,
 700911442,
 83373,
 701114838,
 700061070,
 -1,
 701180364,
 701044542,
 83359,
 -1,
 701110438,
 83360,
 701311438,
 701109189,
 83354,
 -1,
 701241510,
 83355,
 -54833,
 701241327,
 83361,
 -54832,
 701371998,
 83358,
 -54831,
 701437326,
 83357,
 -54830,
 701502617,
 83356,
 -54829,
 701567655,
 83353,
 -54828,
 701632898,
 83352,
 -54827,
 701698139,
 83351,
 -1,
 701763410,
 83350,
 701966818,
 701044318,
 -1,
 702032345,
 701894747,
 83363,
 -1,
 701962406,
 83364,
 -54822,
 701962223,
 83372,
 -54821,
 702093118,
 83371,
 -54820,
 702158430,
 83370,
 -54819,
 702223758,
 83369,
 -54818,
 702289049,
 83368,
 -54817,
 702354373,
 83367,
 -54816,
 702419623,
 83366,
 -54815,
 702484866,
 83365,
 -1,
 702549842,
 83362,
 702753262,
 701895833,
 -1,
 702818789,
 702683119,
 83348,
 -1,
 702748838,
 83349,
 -54810,
 702748478,
 83347,
 -54809,
 702879326,
 83346,
 -54808,
 702944654,
 83345,
 -54807,
 703009945,
 83344,
 -54806,
 703075269,
 83343,
 -54805,
 703140519,
 83342,
 -54804,
 703205762,
 83341,
 -54803,
 703271003,
 83340,
 -1,
 703336274,
 83339,
 703539706,
 702681474,
 -1,
 703605233,
 703469551,
 83312,
 -1,
 703535270,
 83313,
 -54798,
 703534910,
 83311,
 -54797,
 703665758,
 83310,
 -54796,
 703731086,
 83309,
 -54795,
 703796377,
 83308,
 -54794,
 703861701,
 83307,
 -54793,
 703926951,
 83306,
 -54792,
 703992194,
 83305,
 -54791,
 704057435,
 83304,
 -1,
 704122706,
 83303,
 704326150,
 703467346,
 -1,
 704391677,
 704255983,
 83291,
 -1,
 704321702,
 83292,
 -54786,
 704321342,
 83290,
 -54785,
 704452190,
 83289,
 -54784,
 704517518,
 83288,
 -54783,
 704582809,
 83287,
 -54782,
 704648133,
 83286,
 -54781,
 704713383,
 83285,
 -54780,
 704778626,
 83284,
 -54779,
 704843867,
 83283,
 -1,
 704909138,
 83282,
 705112593,
 704255983,
 -1,
 -54776,
 705042415,
 83395,
 -54775,
 705107774,
 83394,
 -54774,
 705173086,
 83393,
 -54773,
 705238414,
 83392,
 -54772,
 705303705,
 83391,
 -54771,
 705369029,
 83390,
 -54770,
 705434318,
 83389,
 -54769,
 705499522,
 83388,
 -54768,
 705564763,
 83387,
 -1,
 705630034,
 83386,
 705833500,
 705041349,
 -1,
 -54765,
 705763311,
 83338,
 -54764,
 705828670,
 83337,
 -54763,
 705893982,
 83336,
 -54762,
 705959310,
 83335,
 -54761,
 706024601,
 83334,
 -54760,
 706089925,
 83333,
 -54759,
 706155175,
 83332,
 -54758,
 706220418,
 83331,
 -54757,
 706285659,
 83330,
 -1,
 706350930,
 83329,
 706609151,
 705761371,
 -1,
 -54754,
 706484207,
 83302,
 -54753,
 706549566,
 83301,
 -54752,
 706614878,
 83300,
 -54751,
 706680206,
 83299,
 -54750,
 706745497,
 83298,
 -54749,
 706810821,
 83297,
 -54748,
 706876071,
 83296,
 -54747,
 706941314,
 83295,
 -54746,
 707006555,
 83294,
 -1,
 707071826,
 83293,
 707275425,
 698880386,
 -1,
 707340855,
 707202898,
 -1,
 707406380,
 707268994,
 83173,
 -54741,
 707339556,
 83175,
 -1,
 707401894,
 83174,
 707602990,
 707336175,
 83183,
 -1,
 707532966,
 83184,
 707734064,
 707532382,
 83180,
 -1,
 707664038,
 83181,
 -54735,
 707663678,
 83182,
 -54734,
 707794318,
 83179,
 -54733,
 707859609,
 83178,
 -54732,
 707924933,
 83177,
 -54731,
 707990183,
 83176,
 -54730,
 708055131,
 83172,
 -1,
 708120402,
 83171,
 708323908,
 707270639,
 -1,
 708389434,
 708253679,
 83280,
 -1,
 708319398,
 83281,
 708520508,
 708318149,
 83274,
 -1,
 708450470,
 83275,
 -54723,
 708450110,
 83279,
 -54722,
 708580958,
 83278,
 -54721,
 708646286,
 83277,
 -54720,
 708711577,
 83276,
 -54719,
 708776615,
 83273,
 -54718,
 708841858,
 83272,
 -54717,
 708907099,
 83271,
 -1,
 708972370,
 83270,
 709175889,
 708251739,
 -1,
 709241415,
 709105038,
 83192,
 -1,
 709171366,
 83193,
 709372489,
 709170329,
 83190,
 -1,
 709302438,
 83191,
 -54710,
 709302255,
 83196,
 -54709,
 709433150,
 83195,
 -54708,
 709498462,
 83194,
 -54707,
 709563333,
 83189,
 -54706,
 709628583,
 83188,
 -54705,
 709693826,
 83187,
 -54704,
 709759067,
 83186,
 -1,
 709824338,
 83185,
 710027869,
 709105470,
 -1,
 710093396,
 709957615,
 83268,
 -1,
 710023334,
 83269,
 -54699,
 710022974,
 83267,
 -54698,
 710153822,
 83266,
 -54697,
 710219150,
 83265,
 -54696,
 710284441,
 83264,
 -54695,
 710349765,
 83263,
 -54694,
 710415015,
 83262,
 -54693,
 710480258,
 83261,
 -54692,
 710545499,
 83260,
 -1,
 710610770,
 83259,
 710814313,
 709957006,
 -1,
 710879840,
 710743646,
 83245,
 -1,
 710809766,
 83246,
 -54687,
 710809583,
 83248,
 -54686,
 710940478,
 83247,
 -54685,
 711005582,
 83244,
 -54684,
 711070873,
 83243,
 -54683,
 711136197,
 83242,
 -54682,
 711201447,
 83241,
 -54681,
 711266690,
 83240,
 -54680,
 711331931,
 83239,
 -1,
 711397202,
 83238,
 711600757,
 710742402,
 -1,
 711666284,
 711530078,
 83204,
 -1,
 711596198,
 83205,
 -54675,
 711596015,
 83207,
 -54674,
 711726910,
 83206,
 -54673,
 711792014,
 83203,
 -54672,
 711857305,
 83202,
 -54671,
 711922629,
 83201,
 -54670,
 711987879,
 83200,
 -54669,
 712053122,
 83199,
 -54668,
 712118363,
 83198,
 -1,
 712183634,
 83197,
 712387200,
 711530078,
 -1,
 -54665,
 712316911,
 83258,
 -54664,
 712382270,
 83257,
 -54663,
 712447582,
 83256,
 -54662,
 712512910,
 83255,
 -54661,
 712578201,
 83254,
 -54660,
 712643525,
 83253,
 -54659,
 712708775,
 83252,
 -54658,
 712774018,
 83251,
 -54657,
 712839259,
 83250,
 -1,
 712904530,
 83249,
 713108107,
 712316057,
 -1,
 -54654,
 713037807,
 83237,
 -54653,
 713103166,
 83236,
 -54652,
 713168478,
 83235,
 -54651,
 713233806,
 83234,
 -54650,
 713299097,
 83233,
 -54649,
 713364421,
 83232,
 -54648,
 713429671,
 83231,
 -54647,
 713494914,
 83230,
 -54646,
 713560155,
 83229,
 -1,
 713625426,
 83228,
 713829014,
 713036741,
 -1,
 -54643,
 713758703,
 83227,
 -54642,
 713824062,
 83226,
 -54641,
 713889374,
 83225,
 -54640,
 713954702,
 83224,
 -54639,
 714019993,
 83223,
 -54638,
 714085317,
 83222,
 -54637,
 714150567,
 83221,
 -54636,
 714215810,
 83220,
 -54635,
 714281051,
 83219,
 -1,
 714346322,
 83218,
 714604543,
 713757351,
 -1,
 -54632,
 714479599,
 83217,
 -54631,
 714544958,
 83216,
 -54630,
 714610270,
 83215,
 -54629,
 714675598,
 83214,
 -54628,
 714740889,
 83213,
 -54627,
 714806213,
 83212,
 -54626,
 714871463,
 83211,
 -54625,
 714936706,
 83210,
 -54624,
 715001947,
 83209,
 -1,
 715067218,
 83208,
 715270939,
 707202898,
 -1,
 715336369,
 715199429,
 -1,
 715401894,
 715265422,
 82994,
 -54619,
 715334948,
 82996,
 -1,
 715397286,
 82995,
 715598504,
 715330713,
 82992,
 -1,
 715528358,
 82993,
 715729578,
 715526235,
 82987,
 -1,
 715659430,
 82988,
 -54613,
 715659247,
 82999,
 -54612,
 715790142,
 82998,
 -54611,
 715855454,
 82997,
 -54610,
 715920325,
 82991,
 -54609,
 715985575,
 82990,
 -54608,
 716050818,
 82989,
 -1,
 716115794,
 82986,
 716319423,
 715265422,
 -1,
 716384950,
 716248462,
 83016,
 -54604,
 716319385,
 83019,
 -54603,
 716383524,
 83018,
 -1,
 716445862,
 83017,
 -54601,
 716314607,
 83022,
 -54600,
 716576574,
 83021,
 -54599,
 716641886,
 83020,
 -54598,
 716706969,
 83015,
 -54597,
 716772293,
 83014,
 -54596,
 716837543,
 83013,
 -54595,
 716902786,
 83012,
 -54594,
 716968027,
 83011,
 -1,
 717033298,
 83010,
 717236940,
 716249071,
 -1,
 717302466,
 717166398,
 83052,
 -1,
 717232294,
 83053,
 717433540,
 717231710,
 83050,
 -1,
 717363366,
 83051,
 -54587,
 717363183,
 83054,
 -54586,
 717493646,
 83049,
 -54585,
 717558937,
 83048,
 -54584,
 717624261,
 83047,
 -54583,
 717689511,
 83046,
 -54582,
 717754754,
 83045,
 -54581,
 717819995,
 83044,
 -1,
 717885266,
 83043,
 718088920,
 717165223,
 -1,
 718154447,
 718018543,
 82984,
 -1,
 718084262,
 82985,
 -54576,
 718083902,
 82983,
 -54575,
 718214750,
 82982,
 -54574,
 718280078,
 82981,
 -54573,
 718345369,
 82980,
 -54572,
 718410693,
 82979,
 -54571,
 718475943,
 82978,
 -54570,
 718541186,
 82977,
 -54569,
 718606427,
 82976,
 -1,
 718671698,
 82975,
 718875364,
 718016898,
 -1,
 718940891,
 718804366,
 82970,
 -1,
 718870694,
 82971,
 -54564,
 718870511,
 82974,
 -54563,
 719001406,
 82973,
 -54562,
 719066718,
 82972,
 -54561,
 719131801,
 82969,
 -54560,
 719197125,
 82968,
 -54559,
 719262375,
 82967,
 -54558,
 719327618,
 82966,
 -54557,
 719392859,
 82965,
 -1,
 719458130,
 82964,
 719661808,
 718803035,
 -1,
 719727335,
 719589202,
 82953,
 -1,
 719657126,
 82954,
 -54552,
 719656943,
 82963,
 -54551,
 719787838,
 82962,
 -54550,
 719853150,
 82961,
 -54549,
 719918478,
 82960,
 -54548,
 719983769,
 82959,
 -54547,
 720049093,
 82958,
 -54546,
 720114343,
 82957,
 -54545,
 720179586,
 82956,
 -1,
 720244827,
 82955,
 720448251,
 719591230,
 -1,
 -54542,
 720377839,
 83042,
 -54541,
 720443198,
 83041,
 -54540,
 720508510,
 83040,
 -54539,
 720573838,
 83039,
 -54538,
 720639129,
 83038,
 -54537,
 720704453,
 83037,
 -54536,
 720769703,
 83036,
 -54535,
 720834946,
 83035,
 -54534,
 720900187,
 83034,
 -1,
 720965458,
 83033,
 721169158,
 720377438,
 -1,
 -54531,
 721098735,
 83032,
 -54530,
 721164094,
 83031,
 -54529,
 721229406,
 83030,
 -54528,
 721294734,
 83029,
 -54527,
 721360025,
 83028,
 -54526,
 721425349,
 83027,
 -54525,
 721490599,
 83026,
 -54524,
 721555842,
 83025,
 -54523,
 721621083,
 83024,
 -1,
 721686354,
 83023,
 721890065,
 721097881,
 -1,
 -54520,
 721819631,
 83009,
 -54519,
 721884990,
 83008,
 -54518,
 721950302,
 83007,
 -54517,
 722015630,
 83006,
 -54516,
 722080921,
 83005,
 -54515,
 722146245,
 83004,
 -54514,
 722211495,
 83003,
 -54513,
 722276738,
 83002,
 -54512,
 722341979,
 83001,
 -1,
 722407250,
 83000,
 722665471,
 721817426,
 -1,
 -54509,
 722540527,
 82952,
 -54508,
 722605886,
 82951,
 -54507,
 722671198,
 82950,
 -54506,
 722736526,
 82949,
 -54505,
 722801817,
 82948,
 -54504,
 722867141,
 82947,
 -54503,
 722932391,
 82946,
 -54502,
 722997634,
 82945,
 -1,
 723062875,
 82944,
 723266444,
 715199429,
 -1,
 723331881,
 723195033,
 -1,
 723397407,
 723261022,
 83455,
 -1,
 723327142,
 83456,
 723528481,
 723324754,
 83447,
 -1,
 723458214,
 83448,
 -54494,
 723458031,
 83458,
 -54493,
 723588926,
 83457,
 -54492,
 723654030,
 83454,
 -54491,
 723719321,
 83453,
 -54490,
 723784645,
 83452,
 -54489,
 723849895,
 83451,
 -54488,
 723915138,
 83450,
 -1,
 723980379,
 83449,
 724183862,
 723259483,
 -1,
 724249389,
 724111186,
 -1,
 -54484,
 724179115,
 83407,
 -1,
 724238682,
 83406,
 -54482,
 724178927,
 83416,
 -54481,
 724375358,
 83415,
 -54480,
 724440670,
 83414,
 -54479,
 724505998,
 83413,
 -54478,
 724571289,
 83412,
 -54477,
 724636613,
 83411,
 -54476,
 724701863,
 83410,
 -54475,
 724767106,
 83409,
 -1,
 724832347,
 83408,
 725035841,
 724113214,
 -1,
 -54472,
 724965359,
 83488,
 -54471,
 725030718,
 83487,
 -54470,
 725096030,
 83486,
 -54469,
 725161358,
 83485,
 -54468,
 725226649,
 83484,
 -54467,
 725291973,
 83483,
 -54466,
 725357223,
 83482,
 -54465,
 725422466,
 83481,
 -54464,
 725487707,
 83480,
 -1,
 725552978,
 83479,
 725756748,
 724964958,
 -1,
 -54461,
 725686255,
 83478,
 -54460,
 725751614,
 83477,
 -54459,
 725816926,
 83476,
 -54458,
 725882254,
 83475,
 -54457,
 725947545,
 83474,
 -54456,
 726012869,
 83473,
 -54455,
 726078119,
 83472,
 -54454,
 726143362,
 83471,
 -54453,
 726208603,
 83470,
 -1,
 726273874,
 83469,
 726477655,
 725685646,
 -1,
 -54450,
 726407151,
 83468,
 -54449,
 726472510,
 83467,
 -54448,
 726537822,
 83466,
 -54447,
 726603150,
 83465,
 -54446,
 726668441,
 83464,
 -54445,
 726733765,
 83463,
 -54444,
 726799015,
 83462,
 -54443,
 726864258,
 83461,
 -54442,
 726929499,
 83460,
 -1,
 726994770,
 83459,
 727198562,
 726406085,
 -1,
 -54439,
 727128047,
 83446,
 -54438,
 727193406,
 83445,
 -54437,
 727258718,
 83444,
 -54436,
 727324046,
 83443,
 -54435,
 727389337,
 83442,
 -54434,
 727454661,
 83441,
 -54433,
 727519911,
 83440,
 -54432,
 727585154,
 83439,
 -54431,
 727650395,
 83438,
 -1,
 727715666,
 83437,
 727919469,
 727126695,
 -1,
 -54428,
 727848943,
 83436,
 -54427,
 727914302,
 83435,
 -54426,
 727979614,
 83434,
 -54425,
 728044942,
 83433,
 -54424,
 728110233,
 83432,
 -54423,
 728175557,
 83431,
 -54422,
 728240807,
 83430,
 -54421,
 728306050,
 83429,
 -54420,
 728371291,
 83428,
 -1,
 728436562,
 83427,
 728640376,
 727847298,
 -1,
 -54417,
 728569839,
 83426,
 -54416,
 728635198,
 83425,
 -54415,
 728700510,
 83424,
 -54414,
 728765838,
 83423,
 -54413,
 728831129,
 83422,
 -54412,
 728896453,
 83421,
 -54411,
 728961703,
 83420,
 -54410,
 729026946,
 83419,
 -54409,
 729092187,
 83418,
 -1,
 729157458,
 83417,
 729361283,
 728567634,
 -1,
 -54406,
 729290735,
 83405,
 -54405,
 729356094,
 83404,
 -54404,
 729421406,
 83403,
 -54403,
 729486734,
 83402,
 -54402,
 729552025,
 83401,
 -54401,
 729617349,
 83400,
 -54400,
 729682599,
 83399,
 -54399,
 729747842,
 83398,
 -54398,
 729813083,
 83397,
 -1,
 729878354,
 83396,
 730136575,
 729290735,
 -1,
 -54395,
 730011230,
 83496,
 -54394,
 730076558,
 83495,
 -54393,
 730141849,
 83494,
 -54392,
 730207173,
 83493,
 -54391,
 730272423,
 83492,
 -54390,
 730337666,
 83491,
 -54389,
 730402907,
 83490,
 -1,
 730468178,
 83489,
 730726399,
 723195033,
 -1,
 730737560,
 730599810,
 -1,
 -54385,
 730666991,
 83525,
 -54384,
 730732350,
 83524,
 -54383,
 730797662,
 83523,
 -54382,
 730862990,
 83522,
 -54381,
 730928281,
 83521,
 -54380,
 730993605,
 83520,
 -54379,
 731058855,
 83519,
 -54378,
 731124098,
 83518,
 -54377,
 731189339,
 83517,
 -1,
 731254610,
 83516,
 731458467,
 730665051,
 -1,
 -54374,
 731387887,
 83515,
 -54373,
 731453246,
 83514,
 -54372,
 731518558,
 83513,
 -54371,
 731583886,
 83512,
 -54370,
 731649177,
 83511,
 -54369,
 731714501,
 83510,
 -54368,
 731779751,
 83509,
 -54367,
 731844994,
 83508,
 -54366,
 731910235,
 83507,
 -1,
 731975506,
 83506,
 732179373,
 731385682,
 -1,
 -54363,
 732108783,
 83505,
 -54362,
 732174142,
 83504,
 -54361,
 732239454,
 83503,
 -54360,
 732304782,
 83502,
 -54359,
 732370073,
 83501,
 -54358,
 732435397,
 83500,
 -54357,
 732500647,
 83499,
 -54356,
 732565890,
 83498,
 -1,
 732631131,
 83497,
 -1,
 732107682,
 83526,
 732900280,
 690533509,
 128028,
 732965815,
 732847037,
 -1,
 733031350,
 732937280,
 -1,
 -54350,
 733002498,
 11151,
 -54349,
 733061998,
 11148,
 -54348,
 733121471,
 11119,
 -54347,
 733179855,
 11150,
 -1,
 733227352,
 11149,
 -1,
 732969855,
 128260,
 -1,
 732906103,
 128246,
 733555644,
 732843284,
 -1,
 -54342,
 733528489,
 128551,
 -54341,
 733587583,
 128544,
 -1,
 733627334,
 128162,
 -1,
 733490658,
 9875,
 733883777,
 690461775,
 -1,
 733949309,
 733813198,
 -1,
 734014839,
 733872128,
 -1,
 734080127,
 733968226,
 -1,
 734145660,
 734050207,
 -1,
 734211051,
 734082232,
 -1,
 734276584,
 734168510,
 -1,
 734342115,
 734249135,
 -1,
 734407627,
 734311557,
 -1,
 734473161,
 734351864,
 -1,
 -54328,
 734412857,
 126646,
 -1,
 734469447,
 126648,
 -54326,
 734412857,
 126645,
 -1,
 734600256,
 126632,
 734800847,
 734374053,
 -1,
 -54323,
 734745837,
 126644,
 -54322,
 734805907,
 126638,
 -1,
 734862036,
 126641,
 735062994,
 734778581,
 -1,
 -54319,
 735010504,
 126630,
 -1,
 735072760,
 126650,
 735259605,
 734999878,
 -1,
 -54316,
 735210415,
 126627,
 -1,
 735261880,
 126649,
 -54314,
 735236967,
 126633,
 -54313,
 735431721,
 126629,
 -54312,
 735486091,
 126643,
 -54311,
 735550142,
 126642,
 -54310,
 735609681,
 126637,
 -54309,
 735673021,
 126636,
 -54308,
 735734943,
 126635,
 -54307,
 735799793,
 126647,
 -54306,
 735864657,
 126626,
 -54305,
 735924799,
 126631,
 -54304,
 735989577,
 126651,
 -54303,
 736053428,
 126640,
 -54302,
 736110275,
 126625,
 -1,
 736173204,
 126639,
 736428031,
 734313064,
 -1,
 -54299,
 736336574,
 126495,
 -54298,
 736396113,
 126493,
 -54297,
 736446644,
 126494,
 -1,
 736503491,
 126492,
 736755711,
 734206118,
 -1,
 -54294,
 736652207,
 126467,
 -1,
 736703672,
 126489,
 736898064,
 734161839,
 -1,
 736963599,
 736856907,
 -1,
 737029107,
 736932997,
 -1,
 737094641,
 736973304,
 -1,
 -54288,
 737034297,
 126614,
 -1,
 737090887,
 126616,
 -54286,
 737034297,
 126613,
 -1,
 737221696,
 126600,
 737422327,
 736995493,
 -1,
 -54283,
 737367277,
 126612,
 -54282,
 737427347,
 126606,
 -1,
 737483476,
 126609,
 737684474,
 737400021,
 -1,
 -54279,
 737631944,
 126598,
 -1,
 737694200,
 126618,
 737881085,
 737628664,
 -1,
 -54276,
 737820729,
 126596,
 -1,
 737877056,
 126599,
 738077696,
 737817926,
 -1,
 -54273,
 738028463,
 126595,
 -1,
 738079928,
 126617,
 738274307,
 738007206,
 -1,
 -54270,
 738225913,
 126592,
 -1,
 738287304,
 126607,
 -54268,
 738251623,
 126601,
 -54267,
 738446377,
 126597,
 -54266,
 738500747,
 126611,
 -54265,
 738564798,
 126610,
 -54264,
 738624337,
 126605,
 -54263,
 738687677,
 126604,
 -54262,
 738749599,
 126603,
 -54261,
 738814449,
 126615,
 -54260,
 738879313,
 126594,
 -54259,
 738938697,
 126619,
 -54258,
 739002548,
 126608,
 -1,
 739059395,
 126593,
 -1,
 736894560,
 126475,
 739322930,
 736864421,
 -1,
 739388463,
 739294193,
 -1,
 739453974,
 739357829,
 -1,
 -54252,
 739398898,
 126582,
 -54251,
 739459129,
 126581,
 -1,
 739515456,
 126568,
 739716122,
 739420325,
 -1,
 -54248,
 739661037,
 126580,
 -54247,
 739721107,
 126574,
 -1,
 739777236,
 126577,
 739978271,
 739652792,
 -1,
 740043806,
 739937923,
 -1,
 -54243,
 739985588,
 126590,
 -1,
 740042435,
 126588,
 -1,
 739973844,
 126585,
 740305954,
 739928093,
 -1,
 -54239,
 740250175,
 126583,
 -1,
 740301735,
 126570,
 740502565,
 740250104,
 -1,
 -54236,
 740442169,
 126564,
 -1,
 740498496,
 126567,
 -54234,
 740480216,
 126586,
 -54233,
 740676455,
 126569,
 -54232,
 740727486,
 126578,
 -54231,
 740787025,
 126573,
 -54230,
 740850365,
 126572,
 -54229,
 740910929,
 126562,
 -54228,
 740970313,
 126587,
 -54227,
 741034164,
 126576,
 -54226,
 741091011,
 126561,
 -1,
 741153940,
 126575,
 -54224,
 739333357,
 126484,
 -54223,
 741293971,
 126478,
 -1,
 741350100,
 126481,
 741551179,
 739271057,
 -1,
 741616695,
 741517477,
 -1,
 -54219,
 741561581,
 126516,
 -54218,
 741621651,
 126510,
 -1,
 741677780,
 126513,
 741878842,
 741586053,
 -1,
 -54215,
 741823730,
 126518,
 -1,
 741883961,
 126517,
 742075453,
 741828637,
 -1,
 -54212,
 742019647,
 126519,
 -1,
 742071207,
 126506,
 742272064,
 742019576,
 -1,
 -54209,
 742211641,
 126500,
 -1,
 742267968,
 126503,
 -54207,
 742249319,
 126505,
 -54206,
 742431422,
 126514,
 -54205,
 742490961,
 126509,
 -54204,
 742554301,
 126508,
 -54203,
 742616223,
 126507,
 -54202,
 742680401,
 126498,
 -54201,
 742739785,
 126523,
 -54200,
 742803636,
 126512,
 -54199,
 742864235,
 126521,
 -54198,
 742926019,
 126497,
 -1,
 742988948,
 126511,
 743189605,
 741520517,
 -1,
 743255137,
 743119014,
 -1,
 743320672,
 743202373,
 -1,
 743386194,
 743286949,
 -1,
 -54192,
 743331053,
 126548,
 -54191,
 743391123,
 126542,
 -1,
 743447252,
 126545,
 743648343,
 743322808,
 -1,
 743713878,
 743607939,
 -1,
 -54187,
 743676606,
 126559,
 -1,
 743736145,
 126557,
 -1,
 743643860,
 126553,
 -54184,
 743625575,
 126537,
 -54183,
 743938750,
 126546,
 -54182,
 743998289,
 126541,
 -54181,
 744058015,
 126539,
 -54180,
 744122865,
 126551,
 -54179,
 744187729,
 126530,
 -54178,
 744247871,
 126535,
 -54177,
 744312649,
 126555,
 -1,
 744365204,
 126543,
 -1,
 743264760,
 126472,
 744631396,
 743199224,
 -1,
 -54173,
 744570937,
 126486,
 -1,
 744627527,
 126488,
 -1,
 744570937,
 126485,
 744893544,
 743167189,
 -1,
 -54169,
 744840904,
 126470,
 -1,
 744903160,
 126490,
 745090155,
 744852519,
 -1,
 -54166,
 745044674,
 126704,
 -1,
 745099843,
 126705,
 745286766,
 745039901,
 -1,
 -54163,
 745230911,
 126487,
 -1,
 745282471,
 126474,
 745483377,
 745216166,
 -1,
 -54160,
 745434873,
 126464,
 -1,
 745496264,
 126479,
 -54158,
 745460583,
 126473,
 -54157,
 745655337,
 126469,
 -54156,
 745709707,
 126483,
 -54155,
 745773758,
 126482,
 -54154,
 745833297,
 126477,
 -54153,
 745896637,
 126476,
 -54152,
 745957201,
 126466,
 -54151,
 746017343,
 126471,
 -54150,
 746082121,
 126491,
 -54149,
 746145972,
 126480,
 -1,
 746202819,
 126465,
 746455039,
 734111217,
 -1,
 -54146,
 746368341,
 2303,
 -1,
 746423126,
 1624,
 746597635,
 734030767,
 -1,
 746663170,
 746536110,
 -1,
 746728703,
 746634583,
 -1,
 746794130,
 746670030,
 -1,
 746859661,
 746725936,
 -1,
 746925193,
 746800903,
 -1,
 746990728,
 746894469,
 -1,
 -54137,
 746966994,
 1909,
 -1,
 747002086,
 1910,
 -1,
 746933097,
 1911,
 747252876,
 746894469,
 -1,
 -54133,
 747229165,
 1598,
 -1,
 747264263,
 1599,
 -1,
 747201361,
 1597,
 747569151,
 746799164,
 -1,
 747580561,
 747484293,
 -1,
 -54128,
 747556859,
 1888,
 -1,
 747591975,
 1889,
 -1,
 747518174,
 2212,
 747842718,
 746727111,
 -1,
 747908249,
 747811973,
 -1,
 747973784,
 747854076,
 -1,
 748039319,
 747935824,
 1874,
 -1,
 747962569,
 1875,
 -1,
 747984943,
 1872,
 -1,
 747950089,
 1876,
 748301467,
 747876231,
 1878,
 -1,
 748224879,
 2208,
 -54116,
 748249914,
 1877,
 -54115,
 748376829,
 2209,
 -1,
 748435678,
 1873,
 748629164,
 747792413,
 -1,
 748694695,
 748568664,
 -1,
 748760230,
 748663941,
 -1,
 748825765,
 748706044,
 -1,
 -54109,
 748787792,
 1892,
 -54108,
 748824290,
 1596,
 -1,
 748886501,
 1891,
 -1,
 748802029,
 1595,
 -1,
 748697767,
 1890,
 749273087,
 748624038,
 -1,
 749284523,
 749160447,
 -1,
 -54102,
 749256313,
 1919,
 -1,
 749287636,
 2228,
 -1,
 749251698,
 1568,
 749546677,
 748595365,
 -1,
 749612211,
 749485975,
 -1,
 -54097,
 749584057,
 1901,
 -54096,
 749645527,
 1904,
 -54095,
 749691729,
 1918,
 -54094,
 749751200,
 1884,
 -1,
 749815588,
 1917,
 -54092,
 749583252,
 2225,
 -1,
 749935327,
 2223,
 750136511,
 749509711,
 -1,
 750202046,
 750075964,
 -1,
 750267578,
 750168229,
 -1,
 -54087,
 750238964,
 1883,
 -1,
 750286909,
 1905,
 -54085,
 750239417,
 1899,
 -54084,
 750417178,
 2218,
 -54083,
 750478161,
 1775,
 -1,
 750539517,
 1900,
 -1,
 750159745,
 2220,
 750791883,
 750080504,
 -1,
 750857418,
 750722115,
 -1,
 750922950,
 750825150,
 -1,
 750988485,
 750852262,
 -1,
 -54076,
 750944307,
 1903,
 -1,
 750987638,
 1906,
 -1,
 750921442,
 1902,
 751250633,
 750892165,
 -1,
 -54072,
 751226861,
 1879,
 -1,
 751261991,
 1880,
 -1,
 751191883,
 1916,
 -1,
 750796869,
 1791,
 751578326,
 750721190,
 -1,
 751643859,
 751525634,
 -1,
 751709392,
 751620068,
 -1,
 -54065,
 751683782,
 1887,
 -1,
 751704549,
 1885,
 751960063,
 751655164,
 -1,
 -54062,
 751867933,
 1886,
 -1,
 751904482,
 2227,
 752156671,
 751595261,
 -1,
 -54059,
 752078802,
 1907,
 -1,
 752113894,
 1908,
 752299229,
 751555435,
 -1,
 752364762,
 752275233,
 -1,
 -54055,
 752308989,
 2216,
 -1,
 752367783,
 2217,
 752615423,
 752297512,
 -1,
 -54052,
 752537554,
 1914,
 -1,
 752572646,
 1915,
 752757988,
 752252684,
 -1,
 752823523,
 752697225,
 -1,
 752889058,
 752760994,
 -1,
 -54047,
 752821986,
 1894,
 -1,
 752884197,
 1893,
 -1,
 752859225,
 2215,
 -1,
 752754990,
 1564,
 753216747,
 752694656,
 -1,
 753282280,
 753185925,
 -1,
 -54041,
 753258533,
 1881,
 -1,
 753293591,
 2222,
 753532927,
 753230500,
 -1,
 -54038,
 753452701,
 1774,
 -1,
 753512349,
 1882,
 753675504,
 753191981,
 -1,
 753741039,
 753616754,
 -1,
 -54034,
 753717202,
 1912,
 -1,
 753752294,
 1913,
 -1,
 753678628,
 2219,
 754003189,
 753632098,
 -1,
 754068724,
 753970871,
 -1,
 -54029,
 754042525,
 1897,
 -1,
 754103637,
 1896,
 -1,
 754040456,
 1895,
 754330874,
 753953711,
 -1,
 754396409,
 754261603,
 -1,
 -54024,
 754334151,
 2214,
 -1,
 754394578,
 1898,
 -1,
 754356821,
 2221,
 -54021,
 754308325,
 2226,
 -54020,
 754627929,
 2211,
 -54019,
 754686658,
 2213,
 -54018,
 754739030,
 2210,
 -1,
 754797981,
 2224,
 755040255,
 746671292,
 -1,
 -54015,
 754919138,
 2297,
 -1,
 754981349,
 2295,
 -1,
 746609862,
 65021,
 755248448,
 746563749,
 -1,
 755313950,
 755225626,
 -1,
 755379474,
 755283077,
 -1,
 755445004,
 755355620,
 -1,
 755510538,
 755419322,
 -1,
 -54007,
 755443426,
 64446,
 -1,
 755505637,
 64445,
 -54005,
 755443426,
 64437,
 -1,
 755636709,
 64436,
 755892223,
 755390716,
 -1,
 755903760,
 755800073,
 -1,
 -54001,
 755836642,
 64441,
 -1,
 755898853,
 64440,
 -53999,
 755836642,
 64439,
 -1,
 756029925,
 64438,
 756231447,
 755316845,
 -1,
 756296982,
 756200583,
 -1,
 -53995,
 756229858,
 64435,
 -1,
 756292069,
 64434,
 -1,
 756269207,
 64444,
 756559130,
 756199279,
 -1,
 -53991,
 756492002,
 64449,
 -1,
 756554213,
 64448,
 756755741,
 756501397,
 -1,
 -53988,
 756688610,
 64443,
 -1,
 756750821,
 64442,
 -1,
 756720788,
 64447,
 757017898,
 755260865,
 -1,
 757083428,
 756984112,
 -1,
 -53983,
 757039026,
 1537,
 -53982,
 757104405,
 1540,
 -53981,
 757167132,
 1552,
 -1,
 757221661,
 1539,
 757411111,
 757046467,
 -1,
 -53978,
 757356317,
 1554,
 -1,
 757413642,
 1555,
 -53976,
 757380521,
 1556,
 -53975,
 757562627,
 1551,
 -1,
 757603708,
 1553,
 757804342,
 756958054,
 -1,
 757869877,
 757781360,
 -1,
 757935408,
 757799078,
 -1,
 758000943,
 757886713,
 983621,
 -1,
 757924980,
 983623,
 -1,
 757939374,
 983628,
 -53967,
 757912757,
 983626,
 -53966,
 758172713,
 983622,
 -53965,
 758234907,
 983625,
 -53964,
 758286044,
 983624,
 -1,
 758332590,
 983627,
 -1,
 757826413,
 983629,
 758590783,
 757758000,
 -1,
 758656316,
 758535658,
 -1,
 -53959,
 758633696,
 1559,
 -53958,
 758697001,
 2291,
 -53957,
 758756693,
 1557,
 -1,
 758805119,
 1558,
 -53955,
 758606099,
 1562,
 -53954,
 758925426,
 1560,
 -1,
 758986147,
 1561,
 -1,
 758563004,
 1622,
 759246157,
 755217541,
 -1,
 759311691,
 759204284,
 -1,
 759377221,
 759283311,
 -1,
 -53948,
 759310050,
 2286,
 -1,
 759372261,
 2283,
 759573832,
 759335371,
 -1,
 -53945,
 759506658,
 2285,
 -1,
 759568869,
 2282,
 759824383,
 759526687,
 -1,
 -53942,
 759703266,
 2287,
 -1,
 759765477,
 2284,
 -53940,
 759285156,
 2275,
 -1,
 759932227,
 1566,
 760098132,
 759182407,
 -1,
 760163664,
 760047891,
 2278,
 -1,
 760133100,
 2281,
 760294738,
 760105074,
 2276,
 -1,
 760264172,
 2279,
 760479743,
 760231331,
 2277,
 -1,
 760395244,
 2280,
 760556891,
 760061007,
 -1,
 760622425,
 760503603,
 -1,
 760687960,
 760551909,
 2296,
 -1,
 760613837,
 2301,
 -1,
 760620770,
 2298,
 -53926,
 760563308,
 1629,
 -1,
 760816869,
 1544,
 761015649,
 760498126,
 -1,
 761081184,
 760947553,
 -1,
 -53922,
 761052774,
 1630,
 -53921,
 761111700,
 2292,
 -1,
 761149607,
 2293,
 -1,
 761039725,
 1538,
 761408871,
 760951992,
 -1,
 761474404,
 761368327,
 2299,
 -1,
 761400269,
 2300,
 761659391,
 761403558,
 -1,
 -53914,
 761574969,
 1549,
 -1,
 761625882,
 2302,
 761802091,
 761383578,
 -1,
 -53911,
 761769871,
 1626,
 -53910,
 761815843,
 1627,
 -1,
 761870548,
 1628,
 762064239,
 761760697,
 -1,
 -53907,
 762013998,
 2290,
 -53906,
 762071160,
 2288,
 -1,
 762131881,
 2289,
 762326386,
 762021113,
 -1,
 -53903,
 762293617,
 1536,
 -1,
 762345762,
 1541,
 -53901,
 762304038,
 1625,
 -53900,
 762498072,
 1631,
 -53899,
 762550188,
 1550,
 -53898,
 762603801,
 2294,
 -1,
 762667736,
 1623,
 762904575,
 733941344,
 -1,
 762916219,
 762811842,
 -1,
 -53894,
 762885826,
 1546,
 -1,
 762936465,
 1545,
 -53892,
 762858533,
 1543,
 -1,
 763048946,
 1542,
 763243904,
 733919483,
 -1,
 -53889,
 763212172,
 127912,
 -1,
 763245578,
 128667,
 -1,
 763198234,
 1423,
 763506220,
 733834159,
 -1,
 763571749,
 763440516,
 -1,
 763637148,
 763537573,
 -1,
 763702670,
 763608859,
 -1,
 763768205,
 763635859,
 -1,
 763833740,
 763706617,
 -1,
 763899274,
 763799924,
 -1,
 -53879,
 763834837,
 128807,
 -1,
 763895840,
 128814,
 -53877,
 763834837,
 128802,
 -1,
 764026912,
 128812,
 -1,
 763781990,
 128862,
 -1,
 763720223,
 128781,
 764358036,
 763632967,
 -1,
 764423571,
 764327045,
 128788,
 764542975,
 764347633,
 -1,
 -53870,
 764424668,
 128806,
 -1,
 764485664,
 128813,
 -1,
 764349945,
 128825,
 764751256,
 764327045,
 -1,
 764816791,
 764714619,
 128860,
 -1,
 764743152,
 128861,
 -1,
 764748230,
 128850,
 -53863,
 764712648,
 128839,
 -53862,
 764970491,
 128852,
 -53861,
 765025884,
 128795,
 -1,
 765078728,
 128847,
 765275567,
 763566246,
 -1,
 765341092,
 765238028,
 -1,
 765406627,
 765263872,
 -1,
 765472161,
 765381033,
 128776,
 -1,
 765398512,
 128777,
 765657087,
 765436037,
 128774,
 -1,
 765529584,
 128775,
 -1,
 765348649,
 128773,
 765799849,
 765291439,
 -1,
 765865383,
 765749455,
 128822,
 -1,
 765791728,
 128823,
 -53848,
 765837858,
 128837,
 -1,
 765935952,
 128874,
 -53846,
 765773181,
 128829,
 -53845,
 766094363,
 128855,
 -53844,
 766158766,
 128826,
 -53843,
 766215335,
 128811,
 -53842,
 766277668,
 128859,
 -1,
 766337987,
 128769,
 766520771,
 765209241,
 -1,
 766586299,
 766483535,
 -1,
 766651831,
 766558476,
 128869,
 766771199,
 766578155,
 -1,
 -53836,
 766645401,
 128873,
 -53835,
 766710725,
 128872,
 -53834,
 766775975,
 128871,
 -1,
 766841218,
 128870,
 767098879,
 766609048,
 -1,
 767110586,
 766980565,
 128803,
 -1,
 767036912,
 128804,
 -1,
 767059026,
 128798,
 767307199,
 766515366,
 -1,
 -53827,
 767269505,
 128846,
 -53826,
 767325945,
 128844,
 -1,
 767376441,
 128848,
 767569346,
 767265882,
 -1,
 -53823,
 767528223,
 128800,
 -1,
 767565844,
 128805,
 -1,
 767517125,
 128787,
 767831507,
 766483535,
 -1,
 767897041,
 767769774,
 -1,
 767962574,
 767840647,
 128818,
 768028106,
 767888875,
 -1,
 -53816,
 767955909,
 128821,
 -53815,
 768021159,
 128820,
 -1,
 768086402,
 128819,
 768344063,
 767952113,
 -1,
 768355789,
 768221216,
 128816,
 -1,
 768282096,
 128817,
 -1,
 768304210,
 128799,
 768552400,
 767892961,
 128827,
 -1,
 768478704,
 128828,
 -1,
 768523066,
 128877,
 768802815,
 767854184,
 128792,
 -1,
 768675312,
 128793,
 768880094,
 767763748,
 -1,
 768945624,
 768838909,
 128834,
 769064959,
 768871915,
 -1,
 -53801,
 768938663,
 128836,
 -1,
 769003906,
 128835,
 769207771,
 768877401,
 -1,
 -53798,
 769181398,
 128876,
 -1,
 769227147,
 128875,
 -53796,
 769172027,
 128857,
 -53795,
 769354789,
 128783,
 -1,
 769418434,
 128830,
 769601000,
 768853661,
 -1,
 769666535,
 769546819,
 -1,
 769732069,
 769622195,
 128778,
 769797604,
 769658347,
 -1,
 -53789,
 769725095,
 128780,
 -1,
 769790338,
 128779,
 -1,
 769721590,
 128815,
 770113535,
 769703087,
 128790,
 -1,
 769986032,
 128791,
 -1,
 769606638,
 128808,
 770256370,
 769561382,
 -1,
 770321901,
 770213310,
 -1,
 770387436,
 770296924,
 128843,
 -1,
 770326227,
 128858,
 -1,
 770356373,
 128856,
 770584048,
 770293531,
 -1,
 -53777,
 770554843,
 128868,
 -1,
 770613888,
 128867,
 -53775,
 770547644,
 128863,
 -1,
 770725455,
 128782,
 770911738,
 770225285,
 -1,
 770977270,
 770858696,
 -1,
 -53771,
 770913255,
 128840,
 -1,
 770966862,
 128809,
 771173880,
 770908735,
 128831,
 -1,
 771100144,
 128832,
 -53767,
 771147400,
 128845,
 -1,
 771269184,
 128849,
 771436033,
 770864908,
 -1,
 771501567,
 771376093,
 128784,
 771620863,
 771427819,
 -1,
 -53762,
 771494567,
 128786,
 -1,
 771559810,
 128785,
 -53760,
 771459827,
 128881,
 -1,
 771694779,
 128824,
 771894792,
 771379704,
 -1,
 771960325,
 771851710,
 -1,
 -53756,
 771933472,
 128878,
 -1,
 771991461,
 128854,
 772210687,
 771890634,
 -1,
 -53753,
 772116310,
 128883,
 -1,
 772160499,
 128882,
 772353550,
 771830968,
 -1,
 772419085,
 772301938,
 -1,
 772484620,
 772386860,
 128865,
 -1,
 772410864,
 128866,
 -1,
 772454799,
 128864,
 -1,
 772351216,
 128880,
 772746770,
 772301906,
 -1,
 772812305,
 772670798,
 128796,
 -1,
 772738544,
 128797,
 -1,
 772738579,
 128801,
 773008917,
 772721486,
 -1,
 -53740,
 772985246,
 128842,
 -1,
 773043953,
 128772,
 773205528,
 772971558,
 -1,
 -53737,
 773162131,
 128768,
 -1,
 773205843,
 128833,
 773402139,
 773161498,
 -1,
 -53734,
 773372882,
 128789,
 -1,
 773410693,
 128879,
 773598750,
 773352367,
 -1,
 -53731,
 773555892,
 128851,
 -1,
 773602753,
 128810,
 773795361,
 773541140,
 -1,
 -53728,
 773767714,
 128841,
 -1,
 773818413,
 128794,
 -53726,
 773768567,
 128853,
 -53725,
 773949328,
 128838,
 -53724,
 773999013,
 128770,
 -1,
 774061564,
 128771,
 774254120,
 763509934,
 -1,
 -53721,
 774219713,
 983054,
 -1,
 774273478,
 9879,
 -53719,
 774223636,
 9941,
 -53718,
 774403852,
 983201,
 -53717,
 774462557,
 128126,
 -1,
 774513023,
 9200,
 774712958,
 763444398,
 -1,
 774778493,
 774655645,
 -1,
 774844012,
 774735097,
 -1,
 774909504,
 774812805,
 -1,
 774975031,
 774884110,
 -1,
 775040565,
 774931902,
 65800,
 775159807,
 774963200,
 -1,
 -53708,
 775075851,
 65827,
 -1,
 775117276,
 65818,
 775356415,
 774980340,
 65809,
 -1,
 775227775,
 65836,
 775433790,
 774918648,
 -1,
 775499324,
 775397423,
 65801,
 775618559,
 775421952,
 -1,
 -53701,
 775534603,
 65828,
 -1,
 775576028,
 65819,
 775815167,
 775447661,
 65810,
 -1,
 775686527,
 65837,
 775946239,
 775373194,
 65808,
 -1,
 775817599,
 65835,
 776023629,
 774875301,
 -1,
 776089159,
 775972471,
 65804,
 776154692,
 776060676,
 65813,
 -1,
 776079743,
 65840,
 776339455,
 776077312,
 -1,
 -53690,
 776255499,
 65831,
 -1,
 776296924,
 65822,
 776536063,
 776029678,
 65805,
 776547914,
 776453892,
 65814,
 -1,
 776472959,
 65841,
 776732671,
 776470528,
 -1,
 -53684,
 776648715,
 65832,
 -1,
 776690140,
 65823,
 776875612,
 775964622,
 -1,
 776941141,
 776832446,
 -1,
 777006675,
 776914208,
 65802,
 777125887,
 776929280,
 -1,
 -53678,
 777041931,
 65829,
 -1,
 777083356,
 65820,
 777322495,
 776972301,
 65811,
 -1,
 777193855,
 65838,
 777453567,
 776886851,
 -1,
 777465434,
 777373566,
 65803,
 777584639,
 777388032,
 -1,
 -53671,
 777500683,
 65830,
 -1,
 777542108,
 65821,
 777781247,
 777407739,
 65812,
 -1,
 777652607,
 65839,
 777858658,
 776831579,
 65807,
 777924191,
 777830148,
 65816,
 -1,
 777849215,
 65843,
 778108927,
 777846784,
 -1,
 -53663,
 778024971,
 65834,
 -1,
 778066396,
 65825,
 778251880,
 777797742,
 65806,
 778317413,
 778228354,
 65815,
 -1,
 778242431,
 65842,
 778502143,
 778240000,
 -1,
 -53657,
 778418187,
 65833,
 -1,
 778459612,
 65824,
 778698751,
 778209720,
 65799,
 778764287,
 778567680,
 -1,
 -53653,
 778680331,
 65826,
 -1,
 778721756,
 65817,
 778907255,
 774818574,
 -1,
 778972788,
 778846324,
 -1,
 779038321,
 778913742,
 -1,
 -53648,
 778997776,
 65851,
 -1,
 779052128,
 65848,
 -53646,
 779007973,
 65850,
 -53645,
 779201099,
 65849,
 -1,
 779232864,
 65847,
 779485183,
 778931472,
 -1,
 -53642,
 779383604,
 65792,
 -1,
 779434142,
 65793,
 779628154,
 778861104,
 -1,
 -53639,
 779597797,
 65855,
 -1,
 779659851,
 65854,
 -53637,
 779580300,
 65853,
 -53636,
 779762686,
 65852,
 -1,
 779824470,
 65794,
 -1,
 774742511,
 128673,
 780086989,
 774657923,
 -1,
 780152483,
 780038526,
 -1,
 780217988,
 780107578,
 -1,
 -53630,
 780194523,
 71440,
 -53629,
 780225891,
 71426,
 -1,
 780277926,
 71427,
 780480136,
 780146854,
 71442,
 780599295,
 780432994,
 -1,
 -53625,
 780514567,
 71429,
 -1,
 780553571,
 71446,
 780742283,
 780448901,
 -1,
 -53622,
 780685838,
 71436,
 -1,
 780736678,
 71428,
 780938894,
 780702502,
 -1,
 -53619,
 780882446,
 71431,
 -1,
 780933286,
 71430,
 781135505,
 780888093,
 -1,
 -53616,
 781079054,
 71425,
 -1,
 781129894,
 71424,
 781332116,
 781084406,
 -1,
 -53613,
 781275662,
 71449,
 -1,
 781326502,
 71434,
 781528727,
 781274388,
 -1,
 -53610,
 781472270,
 71447,
 -1,
 781523110,
 71445,
 781725338,
 781464760,
 -1,
 -53607,
 781668878,
 71444,
 -1,
 781719718,
 71443,
 781921949,
 781657380,
 -1,
 -53604,
 781865486,
 71448,
 -1,
 781916326,
 71432,
 -53602,
 781887792,
 71439,
 -53601,
 782081219,
 71437,
 -53600,
 782137186,
 71433,
 -53599,
 782199773,
 71438,
 -53598,
 782258702,
 71441,
 -1,
 782314791,
 71435,
 782511791,
 780126874,
 -1,
 782577321,
 782440614,
 71456,
 -53594,
 782551822,
 71463,
 -53593,
 782595852,
 71466,
 -53592,
 782654019,
 71465,
 -1,
 782702758,
 71457,
 782905003,
 782548763,
 71460,
 -1,
 782876443,
 71461,
 783036077,
 782850627,
 71458,
 -1,
 782981699,
 71459,
 -53586,
 782992830,
 71464,
 -1,
 783105198,
 71462,
 783298237,
 782448538,
 -1,
 783363763,
 783266949,
 -1,
 -53582,
 783339467,
 71474,
 -1,
 783374555,
 71475,
 783560374,
 783329445,
 -1,
 -53579,
 783509111,
 71478,
 -1,
 783566318,
 71479,
 783756985,
 783501262,
 -1,
 -53576,
 783716200,
 71476,
 -1,
 783771091,
 71477,
 -53574,
 783734142,
 71472,
 -53573,
 783911352,
 71473,
 -53572,
 783975003,
 71481,
 -1,
 784023662,
 71480,
 784215749,
 783263909,
 -1,
 784281284,
 784162241,
 -1,
 784346818,
 784246949,
 -1,
 -53567,
 784300194,
 71484,
 -1,
 784350905,
 71485,
 -53565,
 784312361,
 71486,
 -1,
 784493137,
 71467,
 -1,
 784258108,
 71487,
 784740042,
 784150893,
 -1,
 784805577,
 784690095,
 -1,
 -53560,
 784751803,
 71455,
 -1,
 784799910,
 71453,
 -1,
 784768195,
 71454,
 785121279,
 784696589,
 -1,
 -53556,
 785042569,
 71483,
 -1,
 785072522,
 71482,
 785264402,
 780060972,
 -1,
 785329937,
 785215870,
 -1,
 785395415,
 785258662,
 68352,
 785460947,
 785324198,
 68353,
 -53550,
 785417662,
 68355,
 -1,
 785481530,
 68357,
 785657557,
 785398958,
 68358,
 -1,
 785595566,
 68359,
 -53546,
 785614270,
 68354,
 -1,
 785743674,
 68356,
 785919711,
 785350458,
 -1,
 785985244,
 785861908,
 -1,
 -53542,
 785961808,
 68387,
 -53541,
 786024318,
 68388,
 -1,
 786054318,
 68386,
 -53539,
 785961808,
 68390,
 -53538,
 786202776,
 68391,
 -1,
 786250926,
 68389,
 786444005,
 785885349,
 -1,
 786509539,
 786387448,
 -1,
 -53534,
 786486096,
 68403,
 -1,
 786513070,
 68401,
 -53532,
 786476011,
 68404,
 -1,
 786644142,
 68399,
 786837225,
 786420126,
 -1,
 -53529,
 786813776,
 68370,
 -53528,
 786876286,
 68371,
 -1,
 786906286,
 68369,
 787099373,
 786805893,
 -1,
 -53525,
 787068456,
 68381,
 -53524,
 787108926,
 68378,
 -1,
 787168430,
 68377,
 787361521,
 787041556,
 -1,
 -53521,
 787305534,
 68374,
 -53520,
 787369602,
 68373,
 -1,
 787430574,
 68372,
 787623668,
 787338437,
 -1,
 -53517,
 787567678,
 68402,
 -1,
 787627182,
 68400,
 787820279,
 787600002,
 -1,
 -53514,
 787796816,
 68394,
 -1,
 787823790,
 68395,
 788016889,
 787791643,
 68366,
 -1,
 787988251,
 68367,
 788147963,
 787973566,
 68362,
 -1,
 788104638,
 68363,
 788279037,
 788093507,
 68364,
 -1,
 788224579,
 68365,
 788410112,
 788222456,
 -1,
 -53505,
 788363801,
 68393,
 -1,
 788413614,
 68405,
 788606722,
 788348078,
 68360,
 -1,
 788544686,
 68361,
 788737797,
 788542648,
 -1,
 -53500,
 788681790,
 68380,
 -1,
 788741294,
 68379,
 788934408,
 788669732,
 -1,
 -53497,
 788878398,
 68385,
 -1,
 788937902,
 68384,
 -53495,
 788907902,
 68396,
 -53494,
 789094188,
 68397,
 -53493,
 789157123,
 68382,
 -53492,
 789215769,
 68392,
 -53491,
 789278306,
 68398,
 -53490,
 789342576,
 68368,
 -53489,
 789407554,
 68376,
 -53488,
 789465225,
 68383,
 -1,
 789523552,
 68375,
 -1,
 785258903,
 68409,
 789786392,
 785235739,
 -1,
 789851926,
 789756590,
 -1,
 -53483,
 789808650,
 128663,
 -1,
 789848882,
 127975,
 -53481,
 789820096,
 8371,
 -1,
 789980963,
 127814,
 790179612,
 789739276,
 -1,
 -53478,
 790140511,
 127994,
 -53477,
 790184986,
 127944,
 -1,
 790243894,
 128657,
 790441760,
 790112921,
 -1,
 790507295,
 790390813,
 983053,
 -1,
 790463433,
 983052,
 -1,
 790430312,
 9190,
 790703907,
 790410373,
 -1,
 -53470,
 790661328,
 9883,
 -1,
 790714126,
 128095,
 790900518,
 790671749,
 -1,
 -53467,
 790865569,
 9954,
 -1,
 790923947,
 128562,
 791097129,
 790860582,
 -1,
 -53464,
 791058201,
 983194,
 -1,
 791095961,
 983195,
 791293740,
 791045207,
 -1,
 -53461,
 791230087,
 128747,
 -1,
 791290331,
 128748,
 -53459,
 791243586,
 8525,
 -53458,
 791431441,
 1547,
 -1,
 791492700,
 127903,
 791688636,
 690365732,
 -1,
 791753756,
 791615654,
 -1,
 791818967,
 791707318,
 -1,
 791884492,
 791769470,
 -1,
 791949934,
 791843622,
 -1,
 792015462,
 791893002,
 -1,
 792080404,
 791952560,
 -1,
 792145778,
 792035130,
 -1,
 792211281,
 792087828,
 -1,
 792276801,
 792160285,
 -1,
 792342332,
 792248091,
 -1,
 -53445,
 792302374,
 92598,
 -1,
 792360716,
 92619,
 792538943,
 792282453,
 -1,
 -53442,
 792514974,
 92543,
 -1,
 792533821,
 92553,
 792788991,
 792467622,
 92531,
 -1,
 792665731,
 92601,
 792866634,
 792218900,
 -1,
 792932166,
 792837915,
 -1,
 -53436,
 792894716,
 92550,
 -53435,
 792957734,
 92624,
 -1,
 792992641,
 92563,
 793247743,
 792870062,
 -1,
 793259849,
 793165751,
 92607,
 -1,
 793228421,
 92535,
 -1,
 793198413,
 92557,
 793456460,
 792838071,
 92640,
 -1,
 793425029,
 92657,
 793587535,
 793413054,
 -1,
 -53426,
 793549480,
 92544,
 -1,
 793613094,
 92541,
 -53424,
 793527735,
 92579,
 -1,
 793712806,
 92658,
 793915227,
 792147128,
 -1,
 793980759,
 793843878,
 -1,
 794046294,
 793909416,
 -1,
 -53419,
 794013697,
 92562,
 -1,
 794066724,
 92637,
 -1,
 794006310,
 92518,
 794308442,
 793926211,
 -1,
 -53415,
 794270376,
 92558,
 -1,
 794304679,
 92592,
 -1,
 794280555,
 92528,
 794570593,
 793863926,
 -1,
 794636128,
 794508462,
 -1,
 794701663,
 794573998,
 92628,
 -1,
 794624724,
 92648,
 -1,
 794674839,
 92547,
 -1,
 794565447,
 92554,
 794963814,
 794536726,
 -1,
 795029349,
 794935067,
 -1,
 -53404,
 794987392,
 92527,
 -1,
 795032750,
 92545,
 -1,
 794975321,
 92540,
 795291497,
 794940613,
 -1,
 -53400,
 795264275,
 92609,
 -1,
 795287719,
 92583,
 795488108,
 795268046,
 -1,
 -53397,
 795422636,
 92589,
 -1,
 795486016,
 92608,
 795684719,
 795456645,
 -1,
 -53394,
 795656738,
 92604,
 -1,
 795680831,
 92622,
 795881329,
 795613350,
 92662,
 -1,
 795819182,
 92613,
 -1,
 795831019,
 92584,
 796077962,
 792105766,
 -1,
 796143481,
 796049179,
 92576,
 796209015,
 796072102,
 -1,
 -53386,
 796170920,
 92618,
 -1,
 796212398,
 92529,
 -53384,
 796161804,
 92561,
 -1,
 796343470,
 92649,
 796536703,
 796072102,
 -1,
 796602236,
 796465318,
 92524,
 -1,
 796555020,
 92536,
 796786687,
 796526274,
 -1,
 -53378,
 796686061,
 92634,
 -1,
 796738327,
 92625,
 796929923,
 796482115,
 92663,
 797048831,
 796867758,
 -1,
 -53374,
 796963973,
 92621,
 -1,
 797000547,
 92593,
 797192072,
 796867758,
 -1,
 797257607,
 797163291,
 -1,
 -53370,
 797233566,
 92647,
 -1,
 797291653,
 92605,
 -1,
 797196613,
 92548,
 797573119,
 797148606,
 92568,
 -1,
 797477174,
 92610,
 797650845,
 796030732,
 -1,
 797716368,
 797579430,
 92667,
 797781902,
 797654190,
 92600,
 -1,
 797734668,
 92542,
 -53361,
 797743784,
 92668,
 -1,
 797872934,
 92555,
 798044050,
 797661763,
 92654,
 -1,
 797982538,
 92611,
 798175125,
 797986372,
 -1,
 -53356,
 798114186,
 92581,
 -1,
 798169254,
 92551,
 798371736,
 798107299,
 -1,
 -53353,
 798343714,
 92520,
 -1,
 798375086,
 92582,
 -53351,
 798345553,
 92617,
 -53350,
 798539703,
 92614,
 -53349,
 798591286,
 92671,
 -53348,
 798640332,
 92591,
 -1,
 798704010,
 92666,
 798896048,
 797619333,
 -1,
 798961572,
 798824614,
 -1,
 799027105,
 798890150,
 92635,
 -1,
 798988968,
 92577,
 -53342,
 798988968,
 92636,
 -53341,
 799110924,
 92530,
 -1,
 799162794,
 92559,
 799354792,
 798932763,
 -1,
 799420327,
 799307532,
 92586,
 -1,
 799349550,
 92569,
 -1,
 799349550,
 92566,
 799616940,
 799311294,
 -1,
 799682475,
 799573438,
 92537,
 -1,
 799637306,
 92519,
 -1,
 799644328,
 92630,
 799932415,
 799554734,
 -1,
 799944623,
 799850267,
 92669,
 -1,
 799873899,
 92572,
 -1,
 799899450,
 92672,
 800141250,
 798872194,
 -1,
 800206774,
 800112411,
 -1,
 -53325,
 800168616,
 92644,
 -53324,
 800227130,
 92645,
 -53323,
 800277347,
 92594,
 -1,
 800332628,
 92641,
 800534459,
 800146773,
 -1,
 800599993,
 800463662,
 92567,
 -1,
 800568453,
 92623,
 -53318,
 800575902,
 92639,
 -1,
 800683788,
 92606,
 800862142,
 800492732,
 -1,
 -53315,
 800830465,
 92642,
 -1,
 800862786,
 92643,
 801058753,
 800807491,
 -1,
 -53312,
 801027205,
 92590,
 -1,
 801062730,
 92564,
 -1,
 800989247,
 92588,
 801320910,
 800106661,
 -1,
 801386440,
 801264120,
 -1,
 801451974,
 801342910,
 92659,
 -1,
 801413800,
 92660,
 -53305,
 801399739,
 92638,
 -1,
 801523067,
 92580,
 801714123,
 801324206,
 -1,
 -53302,
 801682565,
 92560,
 -1,
 801717422,
 92534,
 -53300,
 801685440,
 92571,
 -53299,
 801867968,
 92525,
 -1,
 801904980,
 92549,
 802107355,
 801270703,
 -1,
 802172885,
 802063806,
 -1,
 802238419,
 802129342,
 -1,
 -53294,
 802206853,
 92556,
 -1,
 802258746,
 92523,
 -53292,
 802200232,
 92664,
 -1,
 802387724,
 92539,
 802566105,
 802101414,
 -1,
 -53289,
 802527912,
 92633,
 -53288,
 802591526,
 92521,
 -1,
 802627168,
 92575,
 -53286,
 802537243,
 92653,
 -1,
 802768232,
 92595,
 802959336,
 802056221,
 -1,
 803024864,
 802930459,
 -1,
 -53282,
 802993285,
 92620,
 -53281,
 803048320,
 92538,
 -1,
 803095783,
 92587,
 803287013,
 802962606,
 -1,
 803352548,
 803258139,
 -1,
 -53277,
 803328414,
 92646,
 -1,
 803347246,
 92570,
 -1,
 803320965,
 92599,
 -53274,
 803247663,
 92532,
 -53273,
 803571134,
 92665,
 -1,
 803625539,
 92670,
 803811316,
 802899918,
 -1,
 803876848,
 803782427,
 -1,
 803942382,
 803799040,
 -1,
 -53268,
 803905719,
 92661,
 -53267,
 803953219,
 92616,
 -1,
 804006670,
 92626,
 804257791,
 803880110,
 92596,
 -1,
 804172933,
 92612,
 804335602,
 803805350,
 92603,
 -1,
 804297384,
 92673,
 -53261,
 804292800,
 92627,
 -1,
 804405066,
 92651,
 804597761,
 803753236,
 -1,
 804663294,
 804540920,
 -1,
 804728828,
 804601006,
 -1,
 804794363,
 804699931,
 -1,
 -53255,
 804770206,
 92552,
 -53254,
 804814650,
 92565,
 -1,
 804854574,
 92615,
 -1,
 804762757,
 92602,
 -53251,
 804686016,
 92674,
 -1,
 805050719,
 92578,
 805306367,
 804595363,
 -1,
 -53248,
 805226135,
 92597,
 -1,
 805287045,
 92585,
 805449735,
 804559951,
 -1,
 805515269,
 805378214,
 -1,
 -53244,
 805477032,
 92526,
 -1,
 805518510,
 92656,
 -53242,
 805461656,
 92546,
 -1,
 805651935,
 92655,
 805842956,
 805423886,
 -1,
 805908491,
 805814043,
 -1,
 -53238,
 805864894,
 92533,
 -1,
 805911726,
 92650,
 -1,
 805848543,
 92574,
 806170641,
 805815965,
 -1,
 806236176,
 806108334,
 -1,
 -53233,
 806207415,
 92573,
 -1,
 806239406,
 92652,
 -1,
 806193344,
 92522,
 -53230,
 806127038,
 92631,
 -53229,
 806443587,
 92632,
 -1,
 806492326,
 92629,
 806695099,
 792016058,
 -1,
 806760521,
 806649658,
 -1,
 806826023,
 806702356,
 -1,
 806891551,
 806774813,
 -1,
 806957083,
 806831445,
 -1,
 -53222,
 806920671,
 92432,
 -1,
 806951787,
 92457,
 -53220,
 806933347,
 92435,
 -53219,
 807125611,
 92412,
 -53218,
 807165017,
 92476,
 -1,
 807215167,
 92414,
 807469055,
 806833428,
 -1,
 807481380,
 807344294,
 -1,
 807546915,
 807411296,
 92465,
 -1,
 807476014,
 92409,
 -1,
 807506726,
 92483,
 -53211,
 807455578,
 92467,
 -53210,
 807715649,
 92485,
 -1,
 807749087,
 92475,
 807940143,
 806774518,
 -1,
 808005674,
 807885379,
 92403,
 -1,
 807944010,
 92405,
 808136749,
 807945557,
 -1,
 -53204,
 808105093,
 92407,
 -1,
 808131389,
 92430,
 -53202,
 808108405,
 92487,
 -1,
 808263743,
 92418,
 808464439,
 807905445,
 -1,
 808529971,
 808410201,
 -1,
 -53198,
 808498309,
 92459,
 -1,
 808555302,
 92447,
 808726582,
 808473080,
 -1,
 -53195,
 808699458,
 92486,
 -1,
 808730442,
 92408,
 -1,
 808698402,
 92480,
 808988732,
 808440450,
 -1,
 -53191,
 808960342,
 92463,
 -53190,
 808999491,
 92493,
 -53189,
 809059559,
 92450,
 -1,
 809115232,
 92410,
 809316418,
 808924344,
 -1,
 809381952,
 809254062,
 -1,
 -53185,
 809354903,
 92425,
 -1,
 809385134,
 92437,
 -53183,
 809339190,
 92440,
 -1,
 809508448,
 92471,
 809709639,
 809284741,
 -1,
 809775174,
 809647278,
 -1,
 -53179,
 809746978,
 92472,
 -1,
 809778350,
 92505,
 -1,
 809748109,
 92514,
 -53176,
 809680667,
 92503,
 -1,
 809982531,
 92507,
 810168420,
 806713100,
 92497,
 810233937,
 810108878,
 -1,
 810299469,
 810190270,
 92445,
 -1,
 810254138,
 92404,
 810430544,
 810239317,
 -1,
 -53169,
 810398853,
 92424,
 -1,
 810425134,
 92458,
 -1,
 810376281,
 92466,
 810692693,
 810176068,
 -1,
 -53165,
 810649375,
 92438,
 -53164,
 810703961,
 92444,
 -1,
 810763670,
 92442,
 810954842,
 810630318,
 -1,
 811020377,
 810925851,
 -1,
 -53160,
 810988677,
 92427,
 -1,
 811040570,
 92478,
 -1,
 810958669,
 92496,
 811282526,
 810886436,
 -1,
 811348061,
 811211092,
 92448,
 -1,
 811272387,
 92515,
 -1,
 811320126,
 92401,
 811544673,
 811210918,
 -1,
 -53152,
 811495155,
 92426,
 -1,
 811549297,
 92482,
 -53150,
 811518537,
 92510,
 -53149,
 811712283,
 92499,
 -1,
 811764391,
 92441,
 811937911,
 810133669,
 -1,
 812003438,
 811880952,
 -1,
 812068971,
 811941038,
 -1,
 812134506,
 812039963,
 -1,
 -53143,
 812110238,
 92501,
 -1,
 812129070,
 92417,
 -1,
 812072110,
 92413,
 -53140,
 812039963,
 92504,
 -53139,
 812354745,
 92508,
 -1,
 812408298,
 92500,
 812593266,
 811974427,
 -1,
 -53136,
 812564251,
 92498,
 -53135,
 812596398,
 92419,
 -1,
 812653358,
 92473,
 812855413,
 812521638,
 -1,
 -53132,
 812817064,
 92516,
 -1,
 812880678,
 92423,
 -53130,
 812813834,
 92452,
 -1,
 812991867,
 92428,
 813183109,
 811886621,
 -1,
 813248639,
 813120686,
 -1,
 813314174,
 813219611,
 -1,
 -53125,
 813273894,
 92460,
 -53124,
 813338136,
 92431,
 -53123,
 813397772,
 92454,
 -1,
 813439885,
 92415,
 -1,
 813282437,
 92420,
 813707395,
 813219611,
 92489,
 -53119,
 813669032,
 92479,
 -53118,
 813729984,
 92422,
 -1,
 813793082,
 92474,
 -53116,
 813683555,
 92502,
 -1,
 813943647,
 92449,
 814100625,
 813151365,
 -1,
 814166156,
 814038190,
 -1,
 814231691,
 814137115,
 -1,
 -53111,
 814199941,
 92416,
 -53110,
 814251834,
 92481,
 -1,
 814291796,
 92451,
 -1,
 814169933,
 92456,
 814559374,
 814137115,
 92433,
 -1,
 814517770,
 92477,
 -53105,
 814517433,
 92492,
 -53104,
 814635587,
 92513,
 -1,
 814684974,
 92491,
 814887067,
 814050223,
 -1,
 814952600,
 814824622,
 -1,
 815018134,
 814923547,
 -1,
 -53099,
 814970636,
 92484,
 -1,
 815012705,
 92439,
 -53097,
 814986373,
 92464,
 -1,
 815152973,
 92495,
 -53095,
 814924322,
 92446,
 -53094,
 815303865,
 92511,
 -1,
 815357017,
 92406,
 815542436,
 814846758,
 -1,
 815607967,
 815513371,
 -1,
 -53090,
 815580738,
 92443,
 -1,
 815635112,
 92509,
 815804578,
 815545518,
 -1,
 -53087,
 815777349,
 92462,
 -1,
 815807662,
 92506,
 -53085,
 815752055,
 92461,
 -1,
 815931455,
 92469,
 816132268,
 815518338,
 -1,
 816197802,
 816103195,
 -1,
 816263337,
 816154046,
 -1,
 -53080,
 816223014,
 92470,
 -1,
 816281356,
 92468,
 -1,
 816238845,
 92453,
 -53077,
 816136586,
 92429,
 -1,
 816454477,
 92421,
 816656562,
 816094287,
 -1,
 816722096,
 816595341,
 -1,
 -53073,
 816678957,
 92490,
 -1,
 816742006,
 92512,
 -53071,
 816668138,
 92494,
 -1,
 816847677,
 92455,
 817049781,
 816630542,
 -1,
 -53068,
 817020864,
 92411,
 -1,
 817045567,
 92402,
 817246392,
 816992070,
 -1,
 -53065,
 817186147,
 92488,
 -1,
 817240404,
 92434,
 817496063,
 817186766,
 -1,
 -53062,
 817382785,
 92436,
 -1,
 817437012,
 92517,
 817639758,
 806627995,
 -1,
 817705200,
 817594170,
 -1,
 817770698,
 817646868,
 -1,
 817836229,
 817712404,
 -1,
 817901764,
 817807131,
 92362,
 -53055,
 817858870,
 92341,
 -53054,
 817919756,
 92347,
 -53053,
 817971133,
 92370,
 -1,
 818027352,
 92336,
 -1,
 817840522,
 92307,
 818294984,
 817784861,
 -1,
 -53049,
 818266461,
 92303,
 -1,
 818290855,
 92309,
 -53047,
 818251968,
 92368,
 -1,
 818421927,
 92395,
 818622674,
 817735845,
 -1,
 818688206,
 818593563,
 -1,
 -53043,
 818646561,
 92359,
 -1,
 818708282,
 92374,
 -53041,
 818645184,
 92371,
 -53040,
 818828229,
 92351,
 -53039,
 818890094,
 92325,
 -1,
 818944166,
 92350,
 819146971,
 818558136,
 -1,
 819212502,
 819086677,
 -1,
 -53035,
 819180677,
 92349,
 -1,
 819207023,
 92308,
 819409113,
 819140774,
 -1,
 -53032,
 819368742,
 92378,
 -1,
 819427084,
 92375,
 -53030,
 819366154,
 92317,
 -1,
 819551219,
 92331,
 819736803,
 819095286,
 -1,
 819802335,
 819674286,
 -1,
 -53026,
 819775127,
 92389,
 -1,
 819806029,
 92360,
 819998946,
 819730598,
 -1,
 -53023,
 819951372,
 92367,
 -1,
 820003141,
 92356,
 -1,
 819970421,
 92333,
 820261097,
 819704965,
 -1,
 820326631,
 820198574,
 -1,
 -53018,
 820298494,
 92345,
 -1,
 820346682,
 92372,
 -53016,
 820297515,
 92314,
 -1,
 820451668,
 92340,
 820654316,
 820237509,
 -1,
 -53013,
 820594066,
 92323,
 -1,
 820648102,
 92304,
 820850927,
 820582566,
 -1,
 -53010,
 820812456,
 92396,
 -1,
 820872207,
 92338,
 -1,
 820827126,
 92313,
 821113101,
 817657612,
 -1,
 821178627,
 821044516,
 -1,
 821244152,
 821116078,
 -1,
 821309686,
 821215003,
 -1,
 -53003,
 821285278,
 92385,
 -1,
 821327628,
 92315,
 -53001,
 821271804,
 92354,
 -1,
 821444819,
 92311,
 821637371,
 821189187,
 92381,
 -52998,
 821605509,
 92326,
 -1,
 821666385,
 92343,
 821833984,
 821565606,
 -1,
 821899519,
 821762216,
 -1,
 -52994,
 821859959,
 92387,
 -1,
 821897940,
 92318,
 -1,
 821855653,
 92383,
 822214655,
 821804827,
 -1,
 -52990,
 822099118,
 92324,
 -1,
 822156093,
 92364,
 822358282,
 821106854,
 -1,
 822423815,
 822295726,
 -1,
 -52986,
 822390017,
 92363,
 -1,
 822442417,
 92382,
 822673407,
 822345728,
 -1,
 -52983,
 822576167,
 92376,
 -1,
 822634959,
 92339,
 -52981,
 822329271,
 92391,
 -52980,
 822762585,
 92390,
 -1,
 822824540,
 92344,
 823013662,
 821061661,
 -1,
 823079193,
 822951086,
 -1,
 823144725,
 823050011,
 -1,
 823210259,
 823109797,
 -1,
 -52974,
 823153999,
 92319,
 -1,
 823215583,
 92384,
 -52972,
 823162636,
 92386,
 -1,
 823355637,
 92321,
 823537944,
 823099196,
 -1,
 -52969,
 823487966,
 92393,
 -1,
 823543937,
 92394,
 -1,
 823506053,
 92361,
 823800092,
 823050011,
 -1,
 -52965,
 823768197,
 92366,
 -1,
 823823245,
 92373,
 -52963,
 823759984,
 92328,
 -1,
 823925076,
 92329,
 824127781,
 822989442,
 -1,
 824193315,
 824098587,
 -1,
 -52959,
 824168701,
 92388,
 -52958,
 824211212,
 92305,
 -1,
 824247479,
 92322,
 -52956,
 824133037,
 92327,
 -1,
 824383828,
 92377,
 824586541,
 824095877,
 -1,
 824652073,
 824534291,
 -1,
 -52952,
 824623045,
 92358,
 -1,
 824645938,
 92334,
 824848684,
 824589486,
 -1,
 -52949,
 824821322,
 92346,
 -1,
 824882309,
 92400,
 -1,
 824777071,
 92332,
 825110837,
 824551589,
 -1,
 825176369,
 825053688,
 -1,
 -52944,
 825147765,
 92379,
 -1,
 825189307,
 92392,
 825372980,
 825113774,
 -1,
 -52941,
 825345687,
 92330,
 -1,
 825407310,
 92380,
 -1,
 825343953,
 92335,
 825635131,
 825060271,
 -1,
 825700665,
 825563302,
 -1,
 -52936,
 825660198,
 92342,
 -1,
 825718540,
 92357,
 -52934,
 825671451,
 92365,
 -1,
 825844667,
 92397,
 826028352,
 825594662,
 -1,
 826093887,
 825973315,
 -1,
 -52930,
 826057297,
 92316,
 -1,
 826113850,
 92398,
 -1,
 826032522,
 92399,
 826356037,
 825969940,
 -1,
 826421572,
 826298894,
 -1,
 -52925,
 826383612,
 92310,
 -1,
 826446630,
 92320,
 -1,
 826353276,
 92312,
 826683720,
 826329870,
 -1,
 -52921,
 826655570,
 92369,
 -1,
 826679201,
 92306,
 826880331,
 826657076,
 -1,
 -52918,
 826855838,
 92337,
 -1,
 826874725,
 92353,
 -52916,
 826845201,
 92355,
 -52915,
 827018495,
 92348,
 -1,
 827075143,
 92352,
 827273676,
 817567912,
 -1,
 827339122,
 827227962,
 -1,
 827404630,
 827307141,
 -1,
 827470165,
 827334719,
 92223,
 827588607,
 827392000,
 -1,
 -52908,
 827491439,
 92194,
 -1,
 827554677,
 92185,
 -1,
 827428045,
 92178,
 827797852,
 827346196,
 -1,
 827863386,
 827747163,
 -1,
 -52903,
 827819448,
 92182,
 -1,
 827851922,
 92160,
 -52901,
 827805397,
 92229,
 -1,
 827989966,
 92173,
 828191072,
 827773570,
 -1,
 828256607,
 828136003,
 92239,
 -1,
 828224706,
 92225,
 -1,
 828196071,
 92233,
 828453219,
 828167365,
 -1,
 -52894,
 828424814,
 92191,
 -1,
 828446918,
 92167,
 828649830,
 828418838,
 -1,
 -52891,
 828595289,
 92237,
 -1,
 828643494,
 92241,
 828846441,
 828598301,
 -1,
 -52888,
 828792814,
 92180,
 -1,
 828840297,
 92227,
 829043052,
 828781894,
 -1,
 -52885,
 828972944,
 92212,
 -1,
 829031451,
 92201,
 829239663,
 828971174,
 -1,
 -52882,
 829201064,
 92245,
 -1,
 829233350,
 92164,
 -52880,
 829187884,
 92231,
 -52879,
 829382129,
 92204,
 -1,
 829440394,
 92244,
 829632905,
 827291404,
 -1,
 829698430,
 829560998,
 -1,
 829763964,
 829635758,
 -1,
 829829497,
 829716236,
 92238,
 -52873,
 829802823,
 92174,
 -52872,
 829844268,
 92203,
 -1,
 829892496,
 92171,
 -52870,
 829795585,
 92230,
 -52869,
 830047653,
 92210,
 -1,
 830106071,
 92186,
 -52867,
 829723473,
 92221,
 -1,
 830243899,
 92175,
 830419331,
 829654462,
 -1,
 830484866,
 830376128,
 -1,
 -52863,
 830446188,
 92198,
 -1,
 830490075,
 92214,
 -1,
 830439231,
 92190,
 830747014,
 830350681,
 -1,
 -52859,
 830708392,
 92246,
 -1,
 830768549,
 92232,
 -52857,
 830720312,
 92176,
 -52856,
 830885462,
 92196,
 -1,
 830948762,
 92197,
 831140249,
 829597861,
 -1,
 831205778,
 831083000,
 -1,
 831271310,
 831176475,
 -1,
 -52851,
 831223564,
 92215,
 -1,
 831275669,
 92165,
 831467921,
 831216195,
 -1,
 -52848,
 831429884,
 92222,
 -1,
 831488076,
 92168,
 -1,
 831425728,
 92224,
 831730070,
 831161790,
 -1,
 -52844,
 831698053,
 92235,
 -52843,
 831756968,
 92220,
 -1,
 831816416,
 92208,
 -52841,
 831702669,
 92181,
 -52840,
 831939710,
 92195,
 -1,
 831997350,
 92177,
 832188842,
 831099686,
 -1,
 832254369,
 832116902,
 -1,
 832319902,
 832182438,
 -1,
 -52835,
 832281852,
 92226,
 -1,
 832337676,
 92236,
 -52833,
 832285564,
 92187,
 -52832,
 832470601,
 92189,
 -1,
 832504859,
 92200,
 832713128,
 832211257,
 -1,
 832778661,
 832672639,
 -1,
 -52828,
 832720492,
 92169,
 -1,
 832775513,
 92170,
 833028095,
 832732026,
 -1,
 -52825,
 832917100,
 92162,
 -1,
 832972121,
 92163,
 -52823,
 832684882,
 92205,
 -1,
 833111271,
 92202,
 833302963,
 832137245,
 -1,
 833368494,
 833240238,
 -1,
 -52819,
 833339838,
 92179,
 -1,
 833401989,
 92211,
 833565105,
 833296550,
 -1,
 -52816,
 833526440,
 92240,
 -1,
 833570851,
 92199,
 -52814,
 833536846,
 92213,
 -1,
 833722510,
 92219,
 833892795,
 833270917,
 -1,
 833958327,
 833863451,
 -1,
 -52810,
 833887073,
 92206,
 -1,
 833946721,
 92172,
 834154938,
 833897813,
 -1,
 -52807,
 834123586,
 92209,
 -1,
 834149204,
 92234,
 -1,
 834102569,
 92166,
 834417089,
 833842095,
 -1,
 834482622,
 834387739,
 92243,
 -1,
 834411361,
 92207,
 -52801,
 834439468,
 92216,
 -52800,
 834553070,
 92184,
 -1,
 834609222,
 92183,
 834810310,
 834358548,
 -1,
 834875845,
 834753865,
 -1,
 -52796,
 834837756,
 92188,
 -1,
 834883435,
 92193,
 -1,
 834807753,
 92161,
 835137993,
 834780955,
 -1,
 -52792,
 835093244,
 92228,
 -1,
 835128802,
 92192,
 -52790,
 835110848,
 92242,
 -52789,
 835298969,
 92218,
 -1,
 835340726,
 92217,
 835531293,
 827204902,
 -1,
 835596768,
 835483404,
 -1,
 835662293,
 835527972,
 -1,
 835727826,
 835590310,
 -1,
 -52783,
 835657910,
 92255,
 -1,
 835716185,
 92252,
 -52781,
 835699534,
 92292,
 -52780,
 835872026,
 92268,
 -1,
 835929534,
 92286,
 836121049,
 835590310,
 92300,
 836239359,
 836043977,
 -1,
 -52776,
 836158742,
 92296,
 -1,
 836191604,
 92295,
 836383196,
 836061134,
 -1,
 -52773,
 836340058,
 92267,
 -1,
 836396759,
 92284,
 836579807,
 836322645,
 -1,
 -52770,
 836547791,
 92290,
 -1,
 836606632,
 92281,
 -1,
 836537080,
 92287,
 836841969,
 835551034,
 -1,
 836907497,
 836783380,
 -1,
 836973031,
 836848916,
 -1,
 837038565,
 836944718,
 92282,
 -1,
 836961300,
 92283,
 -52762,
 836978008,
 92277,
 -1,
 837097819,
 92298,
 -52760,
 836929728,
 92302,
 -1,
 837249628,
 92276,
 837431788,
 836883074,
 -1,
 -52757,
 837376604,
 92269,
 -1,
 837425985,
 92288,
 837628399,
 837396645,
 -1,
 -52754,
 837573064,
 92247,
 -1,
 837632394,
 92299,
 -52752,
 837597475,
 92260,
 -1,
 837762081,
 92261,
 837956089,
 836806821,
 -1,
 838021621,
 837899326,
 -1,
 -52748,
 837992394,
 92266,
 -1,
 838055128,
 92265,
 -52746,
 837992790,
 92285,
 -52745,
 838163545,
 92249,
 -52744,
 838223093,
 92250,
 -1,
 838278459,
 92279,
 838480386,
 837904413,
 -1,
 838545918,
 838419797,
 -1,
 -52740,
 838521798,
 92272,
 -52739,
 838572652,
 92270,
 -1,
 838605629,
 92294,
 838808065,
 838490691,
 -1,
 -52736,
 838769320,
 92301,
 -1,
 838811520,
 92253,
 -1,
 838737504,
 92256,
 839070215,
 838439718,
 -1,
 -52732,
 839041783,
 92289,
 -52731,
 839083283,
 92263,
 -52730,
 839139255,
 92257,
 -1,
 839197253,
 92274,
 839397901,
 839019439,
 -1,
 839463435,
 839325862,
 -1,
 -52726,
 839415600,
 92259,
 -1,
 839458493,
 92273,
 -52724,
 839420103,
 92251,
 -1,
 839599335,
 92297,
 839791122,
 839365765,
 -1,
 839856657,
 839761693,
 -1,
 -52720,
 839812135,
 92264,
 -1,
 839874485,
 92248,
 -1,
 839784795,
 92280,
 840118805,
 839766658,
 -1,
 -52716,
 840058289,
 92254,
 -1,
 840113127,
 92258,
 840315416,
 840060786,
 -1,
 -52713,
 840286139,
 92262,
 -1,
 840335162,
 92271,
 840512027,
 840255625,
 -1,
 -52710,
 840484503,
 92291,
 -1,
 840514734,
 92293,
 -52708,
 840487312,
 92278,
 -1,
 840681794,
 92275,
 840892415,
 835471312,
 -1,
 840905260,
 840793914,
 -1,
 840970785,
 840875803,
 92697,
 -1,
 840899374,
 92696,
 841101860,
 840918774,
 -1,
 -52701,
 841072567,
 92698,
 -1,
 841095997,
 92688,
 841298471,
 841043220,
 -1,
 -52698,
 841247622,
 92711,
 -1,
 841305443,
 92712,
 -52696,
 841274315,
 92681,
 -52695,
 841463437,
 92704,
 -52694,
 841526097,
 92702,
 -52693,
 841570883,
 92708,
 -1,
 841626983,
 92687,
 841822773,
 840870053,
 -1,
 841888305,
 841765368,
 -1,
 -52689,
 841858843,
 92700,
 -52688,
 841909694,
 92713,
 -1,
 841965034,
 92691,
 -52686,
 841860749,
 92690,
 -52685,
 842095171,
 92692,
 -52684,
 842155487,
 92693,
 -1,
 842210924,
 92727,
 842412606,
 841771037,
 -1,
 842478137,
 842349742,
 -1,
 -52680,
 842445957,
 92695,
 -1,
 842497850,
 92710,
 -52678,
 842453859,
 92694,
 -52677,
 842645275,
 92677,
 -52676,
 842699644,
 92726,
 -52675,
 842761662,
 92719,
 -1,
 842799270,
 92675,
 843002439,
 842374223,
 -1,
 843067971,
 842939566,
 -1,
 -52671,
 843040407,
 92709,
 -52670,
 843087674,
 92721,
 -1,
 843136174,
 92679,
 843330118,
 843012675,
 -1,
 -52667,
 843274819,
 92683,
 -1,
 843333450,
 92684,
 -1,
 843300635,
 92707,
 843592270,
 842954508,
 92689,
 843657803,
 843523364,
 -1,
 -52662,
 843596170,
 92720,
 -1,
 843651412,
 92724,
 -52660,
 843613630,
 92723,
 -52659,
 843792209,
 92685,
 -1,
 843847846,
 92722,
 844051027,
 843560069,
 -1,
 844116562,
 843978918,
 -1,
 -52655,
 844053678,
 92680,
 -1,
 844109990,
 92686,
 -1,
 844055783,
 92725,
 844378712,
 844010278,
 -1,
 844444247,
 844315822,
 -1,
 -52650,
 844416663,
 92703,
 -1,
 844446894,
 92706,
 -1,
 844414903,
 92714,
 844706396,
 844327855,
 -1,
 -52646,
 844663993,
 92718,
 -52645,
 844716611,
 92717,
 -1,
 844765350,
 92682,
 844968543,
 844681858,
 -1,
 -52642,
 844926137,
 92699,
 -1,
 844961958,
 92701,
 845165154,
 844942094,
 -1,
 -52639,
 845136214,
 92705,
 -1,
 845158566,
 92716,
 -52637,
 845138683,
 92728,
 -52636,
 845332251,
 92676,
 -52635,
 845368049,
 92715,
 -1,
 845430602,
 92678,
 845623913,
 791985947,
 -1,
 -52632,
 845561006,
 42696,
 -1,
 845617966,
 42711,
 845820524,
 845561006,
 -1,
 -52629,
 845792919,
 42693,
 -1,
 845823150,
 42698,
 -52627,
 845765187,
 42717,
 -1,
 845944998,
 42667,
 846148225,
 791904058,
 -1,
 846213747,
 846096118,
 -1,
 -52623,
 846184375,
 42686,
 -52622,
 846217034,
 42694,
 -1,
 846273341,
 42674,
 846475895,
 846155028,
 -1,
 -52619,
 846424966,
 42707,
 -52618,
 846482787,
 42708,
 -1,
 846534822,
 42709,
 846738041,
 846446363,
 42685,
 -1,
 846666542,
 42684,
 846869116,
 846705797,
 -1,
 -52613,
 846841485,
 42731,
 -1,
 846872394,
 42695,
 -52611,
 846844875,
 42664,
 -52610,
 847031121,
 42691,
 -52609,
 847075907,
 42703,
 -52608,
 847132007,
 42673,
 -1,
 847190182,
 42715,
 847393422,
 846096413,
 -1,
 847458949,
 847349182,
 42719,
 -52604,
 847432448,
 42734,
 -1,
 847466368,
 42735,
 847655561,
 847396014,
 -1,
 -52601,
 847627927,
 42692,
 -52600,
 847688837,
 42683,
 -1,
 847740730,
 42706,
 -52598,
 847631203,
 42682,
 -52597,
 847888155,
 42659,
 -52596,
 847942524,
 42729,
 -52595,
 847993411,
 42725,
 -1,
 848042150,
 42657,
 848245401,
 847345420,
 42675,
 848310930,
 848182446,
 -1,
 -52591,
 848265018,
 42722,
 -1,
 848314189,
 42671,
 848507541,
 848241956,
 -1,
 -52588,
 848445834,
 42720,
 -1,
 848501076,
 42727,
 -52586,
 848477979,
 42677,
 -52585,
 848659902,
 42726,
 -52584,
 848714307,
 42702,
 -1,
 848763046,
 42723,
 848966307,
 848210085,
 -1,
 849031839,
 848908792,
 -1,
 -52580,
 849002267,
 42688,
 -52579,
 849053118,
 42710,
 -52578,
 849108458,
 42678,
 -1,
 849167839,
 42680,
 -52576,
 849004173,
 42676,
 -52575,
 849304131,
 42679,
 -52574,
 849364447,
 42681,
 -1,
 849419884,
 42732,
 849621677,
 848927823,
 -1,
 849687208,
 849558702,
 -1,
 -52570,
 849659543,
 42704,
 -52569,
 849706810,
 42721,
 -1,
 849755310,
 42661,
 849949355,
 849631811,
 -1,
 -52566,
 849893955,
 42668,
 -1,
 849952586,
 42669,
 -52564,
 849919771,
 42700,
 -1,
 850074414,
 42705,
 850277045,
 849589381,
 -1,
 850342577,
 850214062,
 -1,
 -52560,
 850310277,
 42728,
 -1,
 850362170,
 42730,
 850539188,
 850270374,
 -1,
 -52557,
 850476206,
 42662,
 -1,
 850532518,
 42672,
 -1,
 850483779,
 42724,
 850801339,
 850226095,
 -1,
 -52553,
 850771739,
 42701,
 -52552,
 850824377,
 42718,
 -52551,
 850876995,
 42716,
 -52550,
 850935633,
 42670,
 -1,
 850991270,
 42666,
 851194560,
 850741198,
 -1,
 -52547,
 851164955,
 42712,
 -52546,
 851216576,
 42713,
 -52545,
 851263306,
 42699,
 -1,
 851319135,
 42733,
 851522244,
 851169922,
 -1,
 -52542,
 851494163,
 42689,
 -52541,
 851545273,
 42687,
 -1,
 851581094,
 42690,
 851784391,
 851495694,
 -1,
 -52538,
 851755350,
 42697,
 -1,
 851777702,
 42714,
 -52536,
 851754779,
 42658,
 -52535,
 851936702,
 42663,
 -52534,
 851991107,
 42665,
 -52533,
 852049738,
 42660,
 -1,
 852105382,
 42656,
 852308691,
 791818304,
 -1,
 852374226,
 852260620,
 -1,
 852439761,
 852305914,
 -1,
 -52528,
 852409765,
 42737,
 -1,
 852454131,
 42736,
 -1,
 852391778,
 42741,
 -1,
 852325567,
 42740,
 -52524,
 852273815,
 42742,
 -52523,
 852728829,
 42743,
 -52522,
 852787928,
 42738,
 -1,
 852839683,
 42739,
 853029764,
 791767983,
 -1,
 853095286,
 852975667,
 -1,
 853160729,
 853045630,
 -1,
 853226209,
 853128325,
 -1,
 853291744,
 853153958,
 6946,
 853409791,
 853213184,
 -1,
 -52514,
 853325338,
 6947,
 -52513,
 853376749,
 6942,
 -1,
 853437825,
 6941,
 -1,
 853267969,
 6983,
 853684966,
 853180218,
 -1,
 853750500,
 853612710,
 6950,
 -1,
 853674081,
 6945,
 -52507,
 853725915,
 6940,
 -1,
 853822819,
 6935,
 854012651,
 853633053,
 -1,
 854078186,
 853940390,
 6931,
 -52503,
 854018022,
 6981,
 -1,
 854066281,
 6932,
 -1,
 854022261,
 6982,
 854340337,
 853947718,
 6948,
 854458367,
 854262870,
 -1,
 854471408,
 854377829,
 -1,
 -52497,
 854423487,
 6944,
 -1,
 854466079,
 6943,
 -1,
 854399786,
 6949,
 854733558,
 854268070,
 -1,
 854799092,
 854681849,
 6917,
 -1,
 854722923,
 6918,
 -52491,
 854766713,
 6987,
 -1,
 854875637,
 6928,
 855061242,
 854698288,
 6962,
 855179263,
 854984856,
 -1,
 -52487,
 855085948,
 6961,
 -1,
 855133539,
 6960,
 855323389,
 855022787,
 6957,
 855441407,
 855246962,
 6923,
 -1,
 855312747,
 6924,
 855520000,
 855272413,
 6958,
 855638015,
 855442476,
 6925,
 -1,
 855509355,
 6926,
 855716610,
 855491000,
 6921,
 -1,
 855640427,
 6922,
 855847684,
 855675772,
 6951,
 -1,
 855770035,
 6952,
 855978758,
 855803868,
 6929,
 -1,
 855902571,
 6930,
 856109832,
 855926548,
 6938,
 -1,
 856032162,
 6939,
 856240906,
 856055285,
 6919,
 -1,
 856164715,
 6920,
 856371980,
 856182115,
 6933,
 -1,
 856294200,
 6934,
 856503055,
 856308910,
 -1,
 -52466,
 856451321,
 6927,
 -1,
 856508390,
 6984,
 856699665,
 856435399,
 6936,
 -1,
 856622053,
 6937,
 856830739,
 856630617,
 6953,
 -1,
 856753108,
 6954,
 -52460,
 856806671,
 6986,
 -52459,
 856937179,
 6956,
 -52458,
 857000782,
 6959,
 -52457,
 857065380,
 6985,
 -52456,
 857110370,
 6955,
 -1,
 857166350,
 6963,
 857355074,
 853114626,
 -1,
 857420584,
 857289912,
 -1,
 857486114,
 857348262,
 -1,
 857551648,
 857440659,
 7012,
 857669631,
 857473024,
 -1,
 -52449,
 857584593,
 7013,
 -1,
 857624244,
 7018,
 -52447,
 857497658,
 7017,
 -1,
 857752155,
 7015,
 857944869,
 857423022,
 -1,
 -52444,
 857916138,
 7016,
 -1,
 857964947,
 7010,
 -52442,
 857916138,
 7011,
 -52441,
 858098261,
 7009,
 -1,
 858153018,
 7014,
 858338099,
 857354365,
 -1,
 858403630,
 858286499,
 -1,
 858469164,
 858374612,
 7021,
 -1,
 858393795,
 7024,
 858652671,
 858419773,
 7022,
 -1,
 858524867,
 7025,
 -52433,
 858371729,
 7019,
 -52432,
 858679151,
 7023,
 -52431,
 858738856,
 7027,
 -52430,
 858800708,
 7020,
 -1,
 858859240,
 7026,
 859059003,
 858288099,
 -1,
 859124536,
 859016213,
 -1,
 -52426,
 859095786,
 7033,
 -52425,
 859136058,
 7036,
 -1,
 859185005,
 7032,
 859439103,
 859058164,
 -1,
 -52422,
 859357621,
 7035,
 -1,
 859381015,
 7034,
 859635711,
 859022211,
 -1,
 859648831,
 859540433,
 -1,
 -52418,
 859619705,
 7028,
 -1,
 859642868,
 7029,
 859897855,
 859582462,
 -1,
 -52415,
 859816373,
 7030,
 -1,
 859839767,
 7031,
 860042068,
 857328282,
 -1,
 860107594,
 860009605,
 -1,
 860173129,
 860036583,
 6974,
 860291071,
 860094464,
 -1,
 860304200,
 860201161,
 6975,
 -1,
 860227947,
 6977,
 -1,
 860272262,
 6976,
 -1,
 860110660,
 6965,
 860566348,
 860078612,
 6966,
 -1,
 860489884,
 6967,
 860697422,
 860533679,
 6968,
 -1,
 860619632,
 6969,
 860828496,
 860658886,
 6970,
 -1,
 860752235,
 6971,
 860959570,
 860788145,
 6978,
 -1,
 860883307,
 6979,
 861143039,
 860908512,
 6972,
 -1,
 861014379,
 6973,
 861221730,
 859977626,
 -1,
 861287256,
 861189253,
 -1,
 -52393,
 861261771,
 6994,
 -1,
 861296859,
 6995,
 861483867,
 861251749,
 -1,
 -52390,
 861431415,
 6998,
 -1,
 861488622,
 6999,
 861680478,
 861423566,
 -1,
 -52387,
 861638504,
 6996,
 -1,
 861693395,
 6997,
 -52385,
 861656446,
 6992,
 -52384,
 861833656,
 6993,
 -52383,
 861897307,
 7001,
 -1,
 861945966,
 7000,
 862139242,
 861187446,
 -1,
 862204774,
 862110232,
 -1,
 -52379,
 862167605,
 6912,
 -1,
 862202676,
 6913,
 -52377,
 862172113,
 6915,
 -52376,
 862363884,
 6964,
 -52375,
 862399623,
 6914,
 -1,
 862464007,
 6916,
 862663535,
 862098300,
 -1,
 862729070,
 862615308,
 -1,
 -52371,
 862667338,
 7008,
 -1,
 862722812,
 7003,
 -1,
 862684323,
 7002,
 862991220,
 862596035,
 -1,
 863056755,
 862950268,
 -1,
 -52366,
 863019252,
 7007,
 -1,
 863076052,
 7005,
 -1,
 863022513,
 7006,
 -52363,
 862965284,
 7004,
 -1,
 863247119,
 6980,
 863502335,
 853046420,
 -1,
 863515523,
 863417479,
 -1,
 863581058,
 863447238,
 -1,
 863646593,
 863556014,
 -1,
 863712127,
 863577380,
 -1,
 863777662,
 863668273,
 -1,
 -52355,
 863742492,
 128503,
 -1,
 863776080,
 128505,
 -1,
 863706621,
 128499,
 -52352,
 863676956,
 128501,
 -1,
 863990523,
 11197,
 -1,
 863596083,
 128502,
 -1,
 863545884,
 128500,
 -1,
 863471926,
 127880,
 864367566,
 852997253,
 -1,
 864433099,
 864296218,
 -1,
 864498610,
 864383358,
 -1,
 864564117,
 864463013,
 -1,
 864629651,
 864509549,
 -1,
 -52342,
 864604891,
 7132,
 -52341,
 864668494,
 7116,
 -52340,
 864725296,
 7129,
 -52339,
 864787651,
 7123,
 -52338,
 864850812,
 7112,
 -52337,
 864909154,
 7125,
 -52336,
 864971741,
 7135,
 -52335,
 865030670,
 7107,
 -52334,
 865095011,
 7119,
 -1,
 865147046,
 7105,
 -52332,
 864587907,
 7126,
 -1,
 865278118,
 7128,
 865481627,
 864517946,
 -1,
 -52329,
 865456859,
 7136,
 -52328,
 865504701,
 7127,
 -52327,
 865553763,
 7133,
 -52326,
 865613126,
 7138,
 -1,
 865671334,
 7113,
 865874850,
 865433356,
 -1,
 865940385,
 865802406,
 7124,
 866058239,
 865894487,
 -1,
 -52321,
 865970480,
 7130,
 -52320,
 866025360,
 7114,
 -1,
 866079246,
 7108,
 -1,
 865871193,
 7139,
 866333604,
 865833852,
 7111,
 -1,
 866282276,
 7117,
 -52315,
 866308827,
 7131,
 -52314,
 866437966,
 7115,
 -52313,
 866500379,
 7141,
 -52312,
 866557123,
 7122,
 -52311,
 866610141,
 7134,
 -52310,
 866674948,
 7110,
 -52309,
 866739988,
 7120,
 -52308,
 866802243,
 7140,
 -52307,
 866865678,
 7106,
 -52306,
 866930019,
 7118,
 -52305,
 866989382,
 7121,
 -52304,
 867052231,
 7137,
 -52303,
 867116377,
 7109,
 -1,
 867178662,
 7104,
 867382205,
 864471706,
 -1,
 867447733,
 867352347,
 7150,
 -1,
 867369718,
 7151,
 867578808,
 867395838,
 -1,
 -52297,
 867534270,
 7149,
 -1,
 867588675,
 7147,
 867775418,
 867515566,
 7143,
 -1,
 867712174,
 7145,
 -52293,
 867734484,
 7144,
 -52292,
 867861950,
 7148,
 -1,
 867916355,
 7146,
 868103109,
 867346597,
 -1,
 868168644,
 868078625,
 -1,
 868234178,
 868127526,
 -1,
 -52287,
 868179744,
 7165,
 -1,
 868229062,
 7167,
 -52285,
 868188051,
 7164,
 -1,
 868378633,
 7166,
 -1,
 868113885,
 7142,
 868627400,
 868062213,
 -1,
 -52281,
 868584085,
 7155,
 -1,
 868634740,
 7154,
 868876287,
 868561202,
 -1,
 -52278,
 868778387,
 7152,
 -1,
 868831736,
 7153,
 869020621,
 864375288,
 128704,
 -1,
 868990321,
 128705,
 -1,
 868988733,
 128267,
 869217278,
 864331941,
 -1,
 869282812,
 869181747,
 -1,
 869348339,
 869233022,
 -1,
 869413844,
 869285038,
 92908,
 -52269,
 869368593,
 92880,
 -1,
 869416110,
 92907,
 869610455,
 869388930,
 -1,
 -52266,
 869555275,
 92885,
 -1,
 869613772,
 92900,
 869807065,
 869583694,
 92891,
 -1,
 869742073,
 92902,
 869938139,
 869777179,
 92906,
 -1,
 869912967,
 92896,
 870069213,
 869893566,
 92904,
 -1,
 870024638,
 92905,
 870200288,
 870017053,
 -1,
 -52257,
 870159298,
 92888,
 -1,
 870193318,
 92881,
 870396899,
 870141204,
 -1,
 -52254,
 870328858,
 92893,
 -1,
 870390848,
 92886,
 870593510,
 870331576,
 -1,
 -52251,
 870548926,
 92894,
 -1,
 870602305,
 92887,
 -52249,
 870569488,
 92892,
 -52248,
 870763256,
 92899,
 -52247,
 870824579,
 92897,
 -52246,
 870885940,
 92882,
 -52245,
 870945660,
 92901,
 -52244,
 871004597,
 92884,
 -52243,
 871065537,
 92889,
 -52242,
 871127619,
 92909,
 -52241,
 871193128,
 92890,
 -52240,
 871254051,
 92883,
 -52239,
 871312480,
 92895,
 -52238,
 871376217,
 92898,
 -1,
 871438502,
 92903,
 871642107,
 869281917,
 -1,
 871707639,
 871593320,
 -1,
 -52234,
 871632530,
 92915,
 -1,
 871697089,
 92913,
 871904250,
 871650789,
 -1,
 -52231,
 871829104,
 92916,
 -1,
 871893697,
 92912,
 -1,
 871857064,
 92914,
 -1,
 871582979,
 92917,
 -52227,
 869231038,
 127936,
 -1,
 872169104,
 9918,
 872363014,
 869171002,
 -1,
 872428549,
 872310813,
 127974,
 872546303,
 872383417,
 -1,
 -52222,
 872469387,
 128180,
 -52221,
 872519880,
 128183,
 -52220,
 872564163,
 128182,
 -1,
 872626312,
 128181,
 -1,
 872357561,
 127820,
 872887313,
 872295065,
 -1,
 872952848,
 872835101,
 -1,
 873018381,
 872917157,
 -1,
 873083916,
 872967378,
 -1,
 -52213,
 873047523,
 11101,
 -1,
 873105388,
 11099,
 -1,
 873042853,
 983056,
 873398271,
 872939520,
 -1,
 -52209,
 873320111,
 128281,
 -1,
 873367277,
 128386,
 -1,
 872922111,
 128043,
 873608215,
 872819337,
 128118,
 873725951,
 873529344,
 -1,
 -52204,
 873641026,
 128700,
 -52203,
 873672105,
 128036,
 -52202,
 873736511,
 127868,
 -1,
 873799562,
 128124,
 874001434,
 873569359,
 -1,
 -52199,
 873932552,
 128136,
 -1,
 873988598,
 128202,
 -52197,
 873942795,
 128708,
 -1,
 874133564,
 127992,
 874329275,
 791714895,
 -1,
 874394802,
 874257498,
 -1,
 874460258,
 874344830,
 -1,
 874525734,
 874432157,
 -1,
 874591269,
 874481214,
 -1,
 874656803,
 874552399,
 69643,
 -1,
 874617935,
 69644,
 874840063,
 874605487,
 69645,
 -1,
 874736559,
 69646,
 -1,
 874518694,
 69679,
 874984492,
 874493061,
 -1,
 875050026,
 874951813,
 -1,
 -52183,
 874992142,
 69662,
 -1,
 875042982,
 69661,
 -52181,
 874992142,
 69667,
 -1,
 875174054,
 69666,
 875377713,
 874939838,
 69649,
 875495423,
 875327039,
 -1,
 -52177,
 875407200,
 69686,
 -52176,
 875463452,
 69687,
 -1,
 875525234,
 69685,
 875705398,
 875331386,
 -1,
 -52173,
 875680475,
 69660,
 -52172,
 875724688,
 69665,
 -52171,
 875777379,
 69655,
 -1,
 875829414,
 69670,
 876033084,
 875639992,
 -1,
 876098618,
 875967672,
 -1,
 -52167,
 876040718,
 69664,
 -1,
 876091558,
 69663,
 -52165,
 876040718,
 69669,
 -1,
 876222630,
 69668,
 876426304,
 875960486,
 69637,
 -52162,
 876396315,
 69650,
 -52161,
 876436035,
 69648,
 -1,
 876484774,
 69638,
 876688452,
 876390565,
 -1,
 -52158,
 876652848,
 69681,
 -52157,
 876696078,
 69680,
 -1,
 876746918,
 69682,
 876950598,
 876658459,
 69641,
 -1,
 876920603,
 69642,
 877081673,
 876909350,
 -1,
 -52152,
 877023758,
 69672,
 -1,
 877074598,
 69671,
 877278284,
 877030319,
 -1,
 -52149,
 877226973,
 69684,
 -1,
 877271206,
 69678,
 877474895,
 877226013,
 -1,
 -52146,
 877416974,
 69652,
 -1,
 877467814,
 69651,
 877671506,
 877422326,
 -1,
 -52143,
 877613582,
 69659,
 -1,
 877664422,
 69658,
 877868116,
 877615683,
 69639,
 -1,
 877812291,
 69640,
 877999191,
 877808916,
 -1,
 -52138,
 877941262,
 69654,
 -1,
 877992102,
 69653,
 878195802,
 877931161,
 -1,
 -52135,
 878137870,
 69657,
 -1,
 878188710,
 69656,
 878392413,
 878126372,
 -1,
 -52132,
 878334478,
 69674,
 -1,
 878385318,
 69673,
 -52130,
 878367451,
 69676,
 -52129,
 878550211,
 69677,
 -52128,
 878606178,
 69675,
 -52127,
 878662158,
 69683,
 -1,
 878722222,
 69647,
 878916736,
 874415353,
 -1,
 878982251,
 878883973,
 -1,
 879047783,
 878955278,
 -1,
 -52122,
 879003070,
 69715,
 -1,
 879051508,
 69724,
 879244394,
 878989816,
 -1,
 -52119,
 879206447,
 69716,
 -1,
 879256685,
 69725,
 -1,
 879182218,
 69723,
 879506544,
 878946469,
 -1,
 879572078,
 879453815,
 69719,
 -1,
 879542020,
 69728,
 879755263,
 879511022,
 69720,
 -1,
 879673092,
 69729,
 879834231,
 879445966,
 -1,
 879899764,
 879789502,
 -1,
 -52109,
 879871264,
 69717,
 -1,
 879929357,
 69726,
 880148479,
 879843907,
 -1,
 -52106,
 880068478,
 69718,
 -1,
 880102651,
 69727,
 880292987,
 879790520,
 69714,
 880410623,
 880214016,
 -1,
 -52102,
 880326667,
 69733,
 -1,
 880368092,
 69732,
 880555133,
 880247387,
 69722,
 -1,
 880525060,
 69731,
 880686207,
 880492654,
 69721,
 -1,
 880661122,
 69730,
 -1,
 880633807,
 69759,
 880882835,
 878888605,
 -1,
 880948370,
 880841382,
 -1,
 881013895,
 880921038,
 -1,
 881079429,
 880974927,
 69694,
 -1,
 881040463,
 69695,
 881262591,
 881028015,
 69696,
 -1,
 881159087,
 69697,
 881341579,
 880941222,
 -1,
 -52087,
 881311515,
 69701,
 -52086,
 881351235,
 69699,
 -1,
 881399974,
 69688,
 881603725,
 881311515,
 69692,
 -1,
 881573659,
 69693,
 881734799,
 881547843,
 69690,
 -1,
 881678915,
 69691,
 -52080,
 881690046,
 69700,
 -52079,
 881802414,
 69698,
 -1,
 881862551,
 69689,
 -1,
 880894937,
 69702,
 882128036,
 880817336,
 -1,
 882193570,
 882073002,
 -1,
 882259096,
 882160773,
 -1,
 -52073,
 882233291,
 69736,
 -1,
 882268379,
 69737,
 882455707,
 882223269,
 -1,
 -52070,
 882402935,
 69740,
 -1,
 882460142,
 69741,
 882652318,
 882395086,
 -1,
 -52067,
 882610024,
 69738,
 -1,
 882664915,
 69739,
 -52065,
 882627966,
 69734,
 -52064,
 882805176,
 69735,
 -52063,
 882868827,
 69743,
 -1,
 882917486,
 69742,
 -52061,
 882151163,
 69704,
 -1,
 883040057,
 69703,
 883242154,
 882093430,
 -1,
 -52058,
 883214737,
 69634,
 -52057,
 883278905,
 69636,
 -52056,
 883320727,
 69635,
 -52055,
 883370842,
 69632,
 -1,
 883433522,
 69633,
 883687423,
 883202588,
 -1,
 883700910,
 883583919,
 -1,
 -52051,
 883658476,
 69709,
 -1,
 883712017,
 69707,
 883897521,
 883636333,
 -1,
 -52048,
 883867730,
 69706,
 -1,
 883930245,
 69705,
 -1,
 883831416,
 69708,
 884159671,
 874338883,
 -1,
 884225206,
 884094136,
 -1,
 -52043,
 884166281,
 127753,
 -1,
 884227470,
 128112,
 -1,
 884162497,
 128188,
 884487354,
 884096432,
 -1,
 -52039,
 884435000,
 983124,
 -1,
 884487352,
 127838,
 -1,
 884443132,
 128148,
 884749627,
 874277807,
 -1,
 884815157,
 884677208,
 -1,
 884880591,
 884766476,
 -1,
 884946126,
 884817725,
 -1,
 885011651,
 884894639,
 -1,
 885077186,
 884948984,
 9204,
 -1,
 884998618,
 11207,
 -1,
 885035769,
 11047,
 885273799,
 884946104,
 -1,
 885339334,
 885232328,
 9207,
 -1,
 885260762,
 11206,
 -1,
 885283572,
 11045,
 885535945,
 885244964,
 9206,
 -1,
 885457370,
 11205,
 885667020,
 885501623,
 -1,
 -52021,
 885618223,
 128927,
 -1,
 885667692,
 128921,
 885915647,
 885629927,
 9205,
 -1,
 885785050,
 11208,
 -1,
 884902720,
 9912,
 886060254,
 884844709,
 -1,
 886125780,
 886020965,
 -1,
 -52014,
 886065909,
 9209,
 -52013,
 886123697,
 11200,
 -1,
 886188653,
 128306,
 886387928,
 886077488,
 -1,
 -52010,
 886354372,
 11089,
 -52009,
 886404655,
 11050,
 -1,
 886454124,
 11049,
 886650075,
 886338307,
 -1,
 -52006,
 886616282,
 128909,
 -1,
 886648405,
 128900,
 -52004,
 886604754,
 9927,
 -52003,
 886795107,
 128369,
 -1,
 886840256,
 9984,
 887043310,
 885992089,
 -1,
 887108844,
 887014872,
 -1,
 887174371,
 887080150,
 -1,
 -51998,
 887137318,
 11179,
 -1,
 887189631,
 11178,
 887370982,
 887137302,
 -1,
 -51995,
 887342307,
 11181,
 -1,
 887372712,
 11183,
 887567593,
 887320688,
 -1,
 -51992,
 887538915,
 11180,
 -1,
 887569320,
 11182,
 887816191,
 887503728,
 -1,
 -51989,
 887727142,
 11177,
 -1,
 887779455,
 11176,
 -51987,
 887072488,
 9960,
 -1,
 887907301,
 9210,
 888091897,
 887004239,
 -1,
 888157432,
 888036648,
 -1,
 888222966,
 888082114,
 -1,
 888288499,
 888158863,
 9193,
 -1,
 888212908,
 9197,
 -51980,
 888257566,
 9199,
 -51979,
 888378772,
 11091,
 -1,
 888431821,
 128898,
 -51977,
 888196049,
 11166,
 -1,
 888539164,
 128413,
 -1,
 888114666,
 127990,
 888812806,
 888040367,
 -1,
 888878339,
 888750041,
 -1,
 888943871,
 888803010,
 -1,
 889009406,
 888879759,
 9194,
 -1,
 888933804,
 9198,
 -1,
 888956109,
 128896,
 889206018,
 888864768,
 -1,
 -51967,
 889165809,
 128412,
 -1,
 889220295,
 9944,
 -1,
 889179089,
 11164,
 889520127,
 888807720,
 -1,
 -51963,
 889434330,
 11035,
 -1,
 889466453,
 11044,
 889664787,
 888747192,
 -1,
 889730317,
 889623222,
 -1,
 889795851,
 889654978,
 -1,
 -51958,
 889742541,
 128899,
 -1,
 889797263,
 9196,
 -51956,
 889768913,
 11167,
 -1,
 889915420,
 128419,
 890123538,
 889691215,
 -1,
 890189073,
 890053714,
 -1,
 -51952,
 890140874,
 9922,
 -1,
 890202727,
 9923,
 -1,
 890145876,
 127778,
 -1,
 890067715,
 11201,
 890516763,
 889631877,
 -1,
 890582296,
 890463068,
 -1,
 -51946,
 890548442,
 128908,
 -51945,
 890598959,
 128925,
 -1,
 890648428,
 128919,
 -51943,
 890556615,
 9942,
 -51942,
 890808340,
 9951,
 -1,
 890867509,
 128383,
 891041057,
 890488829,
 -1,
 891106592,
 891015852,
 -1,
 -51938,
 891072730,
 11037,
 -51937,
 891123247,
 128926,
 -1,
 891172716,
 128920,
 -1,
 891074832,
 11054,
 891434279,
 891011922,
 -1,
 891499813,
 891358914,
 -1,
 -51932,
 891446477,
 128897,
 -1,
 891501199,
 9195,
 -51930,
 891472849,
 11165,
 -1,
 891619356,
 128418,
 891827500,
 891392806,
 -1,
 891893035,
 891765130,
 -1,
 -51926,
 891860296,
 11039,
 -1,
 891912139,
 127986,
 -1,
 891864606,
 128392,
 892155184,
 891769336,
 -1,
 -51922,
 892112200,
 11052,
 -51921,
 892159678,
 11042,
 -1,
 892215551,
 128426,
 892417331,
 892094414,
 -1,
 -51918,
 892373116,
 128447,
 -1,
 892431432,
 9873,
 -51916,
 892378123,
 10067,
 -1,
 892569219,
 11204,
 892745016,
 884785497,
 -1,
 -51913,
 892687476,
 128153,
 -1,
 892741921,
 128216,
 892993535,
 892700094,
 -1,
 -51910,
 892914940,
 128033,
 -1,
 892973440,
 127804,
 893138283,
 884719387,
 -1,
 893203810,
 893078804,
 128027,
 893321215,
 893149235,
 -1,
 893334874,
 893219198,
 -1,
 893400392,
 893288250,
 -1,
 893465923,
 893375106,
 -1,
 -51902,
 893397703,
 6671,
 -1,
 893458598,
 6670,
 893662534,
 893406484,
 -1,
 -51899,
 893610095,
 6659,
 -1,
 893655206,
 6658,
 -51897,
 893623491,
 6667,
 -1,
 893786278,
 6666,
 893990219,
 893351692,
 -1,
 -51894,
 893948796,
 6663,
 -1,
 893982886,
 6662,
 -51892,
 893965019,
 6672,
 -51891,
 894158515,
 6675,
 -51890,
 894219527,
 6664,
 -51889,
 894282032,
 6676,
 -51888,
 894344387,
 6673,
 -51887,
 894407548,
 6660,
 -51886,
 894462941,
 6674,
 -51885,
 894527599,
 6656,
 -51884,
 894592788,
 6669,
 -51883,
 894652942,
 6678,
 -51882,
 894717283,
 6657,
 -51881,
 894776646,
 6665,
 -51880,
 894839495,
 6668,
 -51879,
 894903641,
 6661,
 -1,
 894965926,
 6677,
 895169888,
 893307546,
 -1,
 -51876,
 895139611,
 6680,
 -51875,
 895190462,
 6682,
 -51874,
 895244867,
 6679,
 -51873,
 895302830,
 6681,
 -1,
 895359790,
 6683,
 -51871,
 895128554,
 6686,
 -1,
 895500836,
 6687,
 895694183,
 893167781,
 128652,
 895759718,
 895661189,
 -1,
 -51867,
 895723706,
 128101,
 -1,
 895746955,
 128100,
 -1,
 895682861,
 128655,
 896021865,
 895644749,
 128363,
 -1,
 895946094,
 128364,
 -51862,
 895985528,
 127791,
 -1,
 896097830,
 127959,
 896284052,
 893093310,
 -1,
 896349557,
 896253232,
 -1,
 896415092,
 896305347,
 -1,
 -51857,
 896383807,
 9185,
 -51856,
 896443083,
 11813,
 -51855,
 896504998,
 9181,
 -51854,
 896560996,
 11812,
 -51853,
 896619160,
 11211,
 -1,
 896676942,
 9183,
 -1,
 896364182,
 127870,
 896939391,
 896298501,
 -1,
 897004921,
 896912645,
 -1,
 -51848,
 896970970,
 128912,
 -1,
 897003093,
 128902,
 897201532,
 896968869,
 -1,
 -51845,
 897148558,
 128951,
 -1,
 897195609,
 128939,
 -51843,
 897143102,
 128932,
 -51842,
 897337872,
 128945,
 -1,
 897400977,
 128957,
 897594756,
 896899193,
 -1,
 -51839,
 897570360,
 12730,
 -51838,
 897610276,
 12729,
 -51837,
 897670631,
 12589,
 -1,
 897732422,
 12728,
 897922440,
 897550284,
 128366,
 897987975,
 897874199,
 128278,
 -1,
 897911132,
 128209,
 -1,
 897951909,
 128218,
 898184589,
 897895182,
 -1,
 898250124,
 898132911,
 -1,
 -51829,
 898195514,
 127923,
 -1,
 898237720,
 128335,
 -1,
 898170957,
 127993,
 898512271,
 898159234,
 128102,
 -1,
 898476324,
 128713,
 898643345,
 898483482,
 128144,
 -1,
 898565379,
 127893,
 898774419,
 898594572,
 983254,
 -1,
 898704676,
 128163,
 -1,
 898703530,
 128023,
 898971054,
 896220334,
 -1,
 899036577,
 898924346,
 -1,
 899102109,
 898977222,
 -1,
 899167642,
 899051910,
 -1,
 -51815,
 899113825,
 983630,
 -1,
 899161918,
 2510,
 -51813,
 899132796,
 2493,
 -51812,
 899304945,
 2555,
 -1,
 899358689,
 2432,
 899560864,
 899069061,
 -1,
 -51809,
 899515840,
 127857,
 -1,
 899547395,
 11102,
 -1,
 899536232,
 9187,
 899823016,
 898963622,
 -1,
 899888549,
 899775033,
 -1,
 -51804,
 899823269,
 127901,
 -1,
 899883657,
 127900,
 -51802,
 899856916,
 128147,
 -51801,
 900045926,
 128059,
 -1,
 900082966,
 127958,
 900281772,
 899771311,
 983055,
 900399103,
 900230063,
 128276,
 -51797,
 900290494,
 128718,
 -1,
 900336434,
 128277,
 -51795,
 900219817,
 127866,
 -1,
 900478136,
 128719,
 900674999,
 898914883,
 -1,
 900740530,
 900635727,
 -1,
 -51791,
 900708244,
 127874,
 -1,
 900740280,
 128038,
 900937141,
 900674739,
 -1,
 -51788,
 900883686,
 128692,
 -1,
 900938926,
 128690,
 -51786,
 900887636,
 127921,
 -1,
 901081718,
 128089,
 901264826,
 900649602,
 -1,
 -51783,
 901240089,
 983258,
 -1,
 901297707,
 983253,
 -51781,
 901228709,
 983057,
 -1,
 901420596,
 983125,
 901593776,
 791655557,
 -1,
 901658801,
 901519526,
 -1,
 901723935,
 901610606,
 -1,
 901789433,
 901690388,
 -1,
 901854721,
 901742394,
 -1,
 901920219,
 901807930,
 -1,
 901985743,
 901873466,
 -1,
 902051271,
 901912742,
 -1,
 -51771,
 902020891,
 983852,
 -51770,
 902060611,
 983849,
 -1,
 902109350,
 983842,
 902313417,
 902020891,
 983845,
 -1,
 902283035,
 983846,
 902444491,
 902268350,
 983850,
 -1,
 902399422,
 983851,
 902575565,
 902388291,
 983843,
 -1,
 902519363,
 983844,
 902758399,
 902511790,
 983847,
 -1,
 902642862,
 983848,
 902837715,
 901912742,
 -1,
 -51759,
 902807323,
 983720,
 -51758,
 902847043,
 983717,
 -1,
 902895782,
 983710,
 903099861,
 902807323,
 983713,
 -1,
 903069467,
 983714,
 903230935,
 903054782,
 983718,
 -1,
 903185854,
 983719,
 903362009,
 903174723,
 983711,
 -1,
 903305795,
 983712,
 903544831,
 903298222,
 983715,
 -1,
 903429294,
 983716,
 903624168,
 901894786,
 -1,
 903689696,
 903551142,
 -1,
 -51746,
 903659291,
 983698,
 -51745,
 903699011,
 983695,
 -1,
 903747750,
 983688,
 903951842,
 903659291,
 983691,
 -1,
 903921435,
 983692,
 904082916,
 903906750,
 983696,
 -1,
 904037822,
 983697,
 904213990,
 904026691,
 983689,
 -1,
 904157763,
 983690,
 904396799,
 904150190,
 983693,
 -1,
 904281262,
 983694,
 904476149,
 903564564,
 -1,
 904541677,
 904403110,
 -1,
 -51733,
 904511259,
 983676,
 -51732,
 904550979,
 983673,
 -1,
 904599718,
 983666,
 904803823,
 904511259,
 983669,
 -1,
 904773403,
 983670,
 904934897,
 904758718,
 983674,
 -1,
 904889790,
 983675,
 905065971,
 904878659,
 983667,
 -1,
 905009731,
 983668,
 905248767,
 905002158,
 983671,
 -1,
 905133230,
 983672,
 905328121,
 904403110,
 -1,
 -51721,
 905297691,
 983742,
 -51720,
 905337411,
 983739,
 -1,
 905386150,
 983732,
 905590267,
 905297691,
 983735,
 -1,
 905559835,
 983736,
 905721341,
 905545150,
 983740,
 -1,
 905676222,
 983741,
 905852415,
 905665091,
 983733,
 -1,
 905796163,
 983734,
 906035199,
 905788590,
 983737,
 -1,
 905919662,
 983738,
 906114601,
 901818533,
 -1,
 906180112,
 906056184,
 -1,
 906245639,
 906107046,
 -1,
 -51707,
 906215195,
 983874,
 -51706,
 906254915,
 983871,
 -1,
 906303654,
 983864,
 906507785,
 906215195,
 983867,
 -1,
 906477339,
 983868,
 906638859,
 906462654,
 983872,
 -1,
 906593726,
 983873,
 906769933,
 906582595,
 983865,
 -1,
 906713667,
 983866,
 906901007,
 906706094,
 983869,
 -1,
 906837166,
 983870,
 -1,
 906863727,
 983920,
 907097629,
 906143909,
 -1,
 907163157,
 907024550,
 -1,
 -51693,
 907132699,
 983885,
 -51692,
 907172419,
 983882,
 -1,
 907221158,
 983875,
 907425303,
 907132699,
 983878,
 -1,
 907394843,
 983879,
 907556377,
 907380158,
 983883,
 -1,
 907511230,
 983884,
 907687451,
 907500099,
 983876,
 -1,
 907631171,
 983877,
 907870207,
 907623598,
 983880,
 -1,
 907754670,
 983881,
 907949601,
 907024550,
 -1,
 -51681,
 907919131,
 983896,
 -51680,
 907958851,
 983893,
 -1,
 908007590,
 983886,
 908211747,
 907919131,
 983889,
 -1,
 908181275,
 983890,
 908342821,
 908166590,
 983894,
 -1,
 908297662,
 983895,
 908473895,
 908286531,
 983887,
 -1,
 908417603,
 983888,
 908656639,
 908410030,
 983891,
 -1,
 908541102,
 983892,
 908736080,
 906062767,
 -1,
 908801604,
 908684207,
 -1,
 908867128,
 908749743,
 -1,
 908932656,
 908794022,
 -1,
 -51666,
 908902171,
 983819,
 -51665,
 908941891,
 983816,
 -1,
 908990630,
 983809,
 909194802,
 908902171,
 983812,
 -1,
 909164315,
 983813,
 909325876,
 909149630,
 983817,
 -1,
 909280702,
 983818,
 909456950,
 909269571,
 983810,
 -1,
 909400643,
 983811,
 909639679,
 909393070,
 983814,
 -1,
 909524142,
 983815,
 909719100,
 908794022,
 -1,
 -51654,
 909688603,
 983830,
 -51653,
 909728323,
 983827,
 -1,
 909777062,
 983820,
 909981246,
 909688603,
 983823,
 -1,
 909950747,
 983824,
 910112320,
 909936062,
 983828,
 -1,
 910067134,
 983829,
 910243394,
 910056003,
 983821,
 -1,
 910187075,
 983822,
 910426111,
 910179502,
 983825,
 -1,
 910310574,
 983826,
 910505544,
 908728486,
 -1,
 -51642,
 910475035,
 983797,
 -51641,
 910514755,
 983794,
 -1,
 910563494,
 983787,
 910767690,
 910475035,
 983790,
 -1,
 910737179,
 983791,
 910898764,
 910722494,
 983795,
 -1,
 910853566,
 983796,
 911029838,
 910842435,
 983788,
 -1,
 910973507,
 983789,
 911212543,
 910965934,
 983792,
 -1,
 911097006,
 983793,
 911292010,
 908683293,
 -1,
 911357534,
 911257902,
 -1,
 911423062,
 911284390,
 983908,
 -51628,
 911392539,
 983919,
 -51627,
 911432259,
 983916,
 -1,
 911480998,
 983909,
 911685208,
 911392539,
 983912,
 -1,
 911654683,
 983913,
 911816282,
 911639998,
 983917,
 -1,
 911771070,
 983918,
 911947356,
 911759939,
 983910,
 -1,
 911891011,
 983911,
 912130047,
 911883438,
 983914,
 -1,
 912014510,
 983915,
 912209506,
 911284390,
 -1,
 -51616,
 912178971,
 983665,
 -51615,
 912218691,
 983662,
 -1,
 912267430,
 983655,
 912471652,
 912178971,
 983658,
 -1,
 912441115,
 983659,
 912602726,
 912426430,
 983663,
 -1,
 912557502,
 983664,
 912733800,
 912546371,
 983656,
 -1,
 912677443,
 983657,
 912916479,
 912669870,
 983660,
 -1,
 912800942,
 983661,
 912995972,
 911258757,
 -1,
 913061496,
 912962693,
 -1,
 913127024,
 912988326,
 -1,
 -51602,
 913096475,
 983709,
 -51601,
 913136195,
 983706,
 -1,
 913184934,
 983699,
 913389170,
 913096475,
 983702,
 -1,
 913358619,
 983703,
 913520244,
 913343934,
 983707,
 -1,
 913475006,
 983708,
 913651318,
 913463875,
 983700,
 -1,
 913594947,
 983701,
 913833983,
 913587374,
 983704,
 -1,
 913718446,
 983705,
 913913468,
 912988326,
 -1,
 -51590,
 913882907,
 983731,
 -51589,
 913922627,
 983728,
 -1,
 913971366,
 983721,
 914175614,
 913882907,
 983724,
 -1,
 914145051,
 983725,
 914306688,
 914130366,
 983729,
 -1,
 914261438,
 983730,
 914437762,
 914250307,
 983722,
 -1,
 914381379,
 983723,
 914620415,
 914373806,
 983726,
 -1,
 914504878,
 983727,
 914699934,
 912956495,
 -1,
 914765458,
 914660431,
 -1,
 914830986,
 914692262,
 -1,
 -51576,
 914800411,
 983841,
 -51575,
 914840131,
 983838,
 -1,
 914888870,
 983831,
 915093132,
 914800411,
 983834,
 -1,
 915062555,
 983835,
 915224206,
 915047870,
 983839,
 -1,
 915178942,
 983840,
 915355280,
 915167811,
 983832,
 -1,
 915298883,
 983833,
 915537919,
 915291310,
 983836,
 -1,
 915422382,
 983837,
 915617430,
 914692262,
 -1,
 -51564,
 915586843,
 983786,
 -51563,
 915626563,
 983783,
 -1,
 915675302,
 983776,
 915879576,
 915586843,
 983779,
 -1,
 915848987,
 983780,
 916010650,
 915834302,
 983784,
 -1,
 915965374,
 983785,
 916141724,
 915954243,
 983777,
 -1,
 916085315,
 983778,
 916324351,
 916077742,
 983781,
 -1,
 916208814,
 983782,
 916403883,
 914674306,
 -1,
 916469411,
 916330662,
 -1,
 -51551,
 916438811,
 983775,
 -51550,
 916478531,
 983772,
 -1,
 916527270,
 983765,
 916731557,
 916438811,
 983768,
 -1,
 916700955,
 983769,
 916862631,
 916686270,
 983773,
 -1,
 916817342,
 983774,
 916993705,
 916806211,
 983766,
 -1,
 916937283,
 983767,
 917176319,
 916929710,
 983770,
 -1,
 917060782,
 983771,
 917255864,
 916375197,
 -1,
 917321392,
 917182630,
 -1,
 -51538,
 917290779,
 983808,
 -51537,
 917330499,
 983805,
 -1,
 917379238,
 983798,
 917583538,
 917290779,
 983801,
 -1,
 917552923,
 983802,
 917714612,
 917538238,
 983806,
 -1,
 917669310,
 983807,
 917845686,
 917658179,
 983799,
 -1,
 917789251,
 983800,
 918028287,
 917781678,
 983803,
 -1,
 917912750,
 983804,
 918107845,
 917213990,
 -1,
 918173373,
 918034598,
 -1,
 -51525,
 918142747,
 983753,
 -51524,
 918182467,
 983750,
 -1,
 918231206,
 983743,
 918435519,
 918142747,
 983746,
 -1,
 918404891,
 983747,
 918566593,
 918390206,
 983751,
 -1,
 918521278,
 983752,
 918697667,
 918510147,
 983744,
 -1,
 918641219,
 983745,
 918880255,
 918633646,
 983748,
 -1,
 918764718,
 983749,
 918959826,
 918058764,
 -1,
 919025354,
 918886566,
 -1,
 -51512,
 918994715,
 983764,
 -51511,
 919034435,
 983761,
 -1,
 919083174,
 983754,
 919287500,
 918994715,
 983757,
 -1,
 919256859,
 983758,
 919418574,
 919242174,
 983762,
 -1,
 919373246,
 983763,
 919549648,
 919362115,
 983755,
 -1,
 919493187,
 983756,
 919732223,
 919485614,
 983759,
 -1,
 919616686,
 983760,
 919811807,
 918906614,
 -1,
 919877335,
 919738534,
 -1,
 -51499,
 919846683,
 983863,
 -51498,
 919886403,
 983860,
 -1,
 919935142,
 983853,
 920139481,
 919846683,
 983856,
 -1,
 920108827,
 983857,
 920270555,
 920094142,
 983861,
 -1,
 920225214,
 983862,
 920401629,
 920214083,
 983854,
 -1,
 920345155,
 983855,
 920584191,
 920337582,
 983858,
 -1,
 920468654,
 983859,
 920663788,
 919753208,
 -1,
 920729316,
 920590502,
 -1,
 -51486,
 920698651,
 983907,
 -51485,
 920738371,
 983904,
 -1,
 920787110,
 983897,
 920991462,
 920698651,
 983900,
 -1,
 920960795,
 983901,
 921122536,
 920946110,
 983905,
 -1,
 921077182,
 983906,
 921253610,
 921066051,
 983898,
 -1,
 921197123,
 983899,
 921436159,
 921189550,
 983902,
 -1,
 921320622,
 983903,
 921567231,
 920595097,
 -1,
 921581297,
 921442470,
 -1,
 -51473,
 921550619,
 983687,
 -51472,
 921590339,
 983684,
 -1,
 921639078,
 983677,
 921843443,
 921550619,
 983680,
 -1,
 921812763,
 983681,
 921974517,
 921798078,
 983685,
 -1,
 921929150,
 983686,
 922105591,
 921918019,
 983678,
 -1,
 922049091,
 983679,
 922288127,
 922041518,
 983682,
 -1,
 922172590,
 983683,
 922367764,
 901720729,
 -1,
 922433299,
 922323682,
 -1,
 922498816,
 922386234,
 983638,
 922564350,
 922451770,
 983636,
 -1,
 922517306,
 983648,
 -51457,
 922538626,
 983634,
 -1,
 922635540,
 983632,
 922826499,
 922462373,
 983652,
 -51454,
 922790053,
 983651,
 -1,
 922833400,
 983650,
 923023110,
 922774447,
 983643,
 923140095,
 922971055,
 983646,
 -1,
 923036591,
 983645,
 923219720,
 922989701,
 983637,
 -1,
 923186309,
 983635,
 923350794,
 923180111,
 983642,
 -1,
 923311183,
 983647,
 923481868,
 923297821,
 983631,
 -1,
 923447598,
 983654,
 -51443,
 923456130,
 983641,
 -51442,
 923584157,
 983644,
 -51441,
 923636518,
 983639,
 -51440,
 923694860,
 983640,
 -51439,
 923756278,
 983649,
 -51438,
 923816440,
 983653,
 -1,
 923871897,
 983633,
 -1,
 922394660,
 3063,
 924137240,
 922301624,
 -1,
 -51434,
 924081591,
 3046,
 -51433,
 924139168,
 3062,
 -1,
 924198120,
 3059,
 -51431,
 924111699,
 3061,
 -51430,
 924362865,
 3065,
 -51429,
 924420288,
 3024,
 -51428,
 924484865,
 3066,
 -51427,
 924548557,
 3060,
 -51426,
 924610997,
 2998,
 -1,
 924656232,
 3064,
 924858448,
 901667397,
 -1,
 924923848,
 924825454,
 -1,
 924989285,
 924873086,
 -1,
 925054778,
 924937135,
 -1,
 925120310,
 925012561,
 -1,
 925185832,
 925067293,
 -1,
 -51418,
 925159866,
 6692,
 -51417,
 925192718,
 6693,
 -1,
 925243558,
 6691,
 925447979,
 925152389,
 -1,
 -51414,
 925389326,
 6709,
 -1,
 925440166,
 6708,
 925644590,
 925405990,
 -1,
 -51411,
 925585934,
 6717,
 -1,
 925636774,
 6715,
 925841201,
 925575833,
 -1,
 -51408,
 925782542,
 6699,
 -1,
 925833382,
 6697,
 -51406,
 925815515,
 6719,
 -51405,
 926001456,
 6698,
 -51404,
 926064223,
 6704,
 -51403,
 926110222,
 6732,
 -1,
 926173219,
 6716,
 926365496,
 925046950,
 6723,
 -1,
 926301358,
 6739,
 -51399,
 926335318,
 6724,
 -1,
 926444509,
 6730,
 926627664,
 924997098,
 -1,
 926693183,
 926591141,
 -1,
 -51395,
 926656816,
 6727,
 -51394,
 926700046,
 6726,
 -1,
 926750886,
 6728,
 926955331,
 926640157,
 -1,
 -51391,
 926929338,
 6690,
 -51390,
 926962190,
 6689,
 -1,
 927013030,
 6688,
 927217478,
 926921861,
 -1,
 -51387,
 927158798,
 6707,
 -1,
 927209638,
 6706,
 927414089,
 927175462,
 -1,
 -51384,
 927355406,
 6713,
 -1,
 927406246,
 6712,
 927610700,
 927345305,
 -1,
 -51381,
 927552014,
 6696,
 -1,
 927602854,
 6695,
 -51379,
 927584987,
 6720,
 -51378,
 927768159,
 6702,
 -51377,
 927814158,
 6729,
 -1,
 927877155,
 6714,
 928069461,
 926587983,
 -1,
 928134996,
 927996070,
 6721,
 -51373,
 928101639,
 6701,
 -1,
 928153488,
 6705,
 -1,
 928104790,
 6722,
 928397145,
 928022330,
 -1,
 -51369,
 928371419,
 6700,
 -51368,
 928402787,
 6694,
 -1,
 928454822,
 6710,
 928659291,
 928366363,
 6735,
 -1,
 928628507,
 6736,
 928790365,
 928602691,
 6733,
 -1,
 928733763,
 6734,
 -51362,
 928762702,
 6725,
 -51361,
 928877312,
 6738,
 -51360,
 928937826,
 6718,
 -51359,
 928993566,
 6740,
 -51358,
 929054538,
 6737,
 -51357,
 929117510,
 6703,
 -51356,
 929178969,
 6711,
 -1,
 929241254,
 6731,
 929445767,
 924953974,
 -1,
 929511280,
 929392669,
 -1,
 929576813,
 929454531,
 -1,
 929642348,
 929499847,
 -1,
 -51350,
 929567897,
 6777,
 -51349,
 929633221,
 6776,
 -1,
 929698471,
 6775,
 -1,
 929566330,
 6780,
 929970031,
 929503589,
 6824,
 -1,
 929917826,
 6825,
 -1,
 929907485,
 6819,
 930166645,
 929474864,
 -1,
 930232179,
 930134622,
 6826,
 -1,
 930179970,
 6827,
 -51340,
 930204575,
 6818,
 -1,
 930310944,
 6752,
 930494330,
 930117577,
 -1,
 930559864,
 930441432,
 6772,
 -1,
 930481167,
 6744,
 -51335,
 930534176,
 6823,
 -1,
 930654613,
 6779,
 930822012,
 930467314,
 6816,
 -1,
 930794325,
 6817,
 930953087,
 930790108,
 -1,
 -51330,
 930877826,
 6774,
 -1,
 930943067,
 6773,
 931149698,
 930913359,
 -1,
 -51327,
 931087994,
 6822,
 -1,
 931141823,
 6778,
 931346309,
 931090936,
 -1,
 -51324,
 931304170,
 6820,
 -1,
 931340141,
 6828,
 -51322,
 931281025,
 6821,
 -1,
 931474126,
 6829,
 931674013,
 929417882,
 -1,
 931739534,
 931628478,
 6763,
 931805068,
 931666088,
 -1,
 -51317,
 931735266,
 6764,
 -1,
 931797477,
 6771,
 -51315,
 931779202,
 6765,
 -1,
 931956158,
 6768,
 932132754,
 931708699,
 6761,
 932198289,
 932101915,
 6762,
 -1,
 932134062,
 6760,
 -1,
 932134062,
 6759,
 932394902,
 932059302,
 6753,
 -51308,
 932338243,
 6769,
 -51307,
 932396206,
 6767,
 -1,
 932452518,
 6755,
 932657049,
 932361349,
 -1,
 -51304,
 932598497,
 6770,
 -1,
 932650486,
 6756,
 932853659,
 932600387,
 6757,
 -1,
 932796995,
 6758,
 -51300,
 932804564,
 6754,
 -1,
 932920494,
 6766,
 933115819,
 931641204,
 -1,
 933181345,
 933082245,
 -1,
 -51296,
 933154763,
 6802,
 -1,
 933189851,
 6803,
 933377956,
 933144741,
 -1,
 -51293,
 933324407,
 6806,
 -1,
 933381614,
 6807,
 933574567,
 933316558,
 -1,
 -51290,
 933531496,
 6804,
 -1,
 933586387,
 6805,
 -51288,
 933549438,
 6800,
 -51287,
 933726648,
 6801,
 -51286,
 933790299,
 6809,
 -1,
 933838958,
 6808,
 934033337,
 933058508,
 -1,
 934098863,
 933999749,
 -1,
 -51282,
 934072267,
 6786,
 -1,
 934107355,
 6787,
 934295474,
 934062245,
 -1,
 -51279,
 934241911,
 6790,
 -1,
 934299118,
 6791,
 934492085,
 934234062,
 -1,
 -51276,
 934449000,
 6788,
 -1,
 934503891,
 6789,
 -51274,
 934466942,
 6784,
 -51273,
 934644152,
 6785,
 -51272,
 934707803,
 6793,
 -1,
 934756462,
 6792,
 935002111,
 933965888,
 -1,
 935016391,
 934904877,
 -1,
 935081920,
 934967052,
 -1,
 935147455,
 935018288,
 -1,
 -51266,
 935107779,
 6741,
 -1,
 935160797,
 6742,
 -1,
 935073958,
 6748,
 935409603,
 935029679,
 -1,
 -51262,
 935367261,
 6746,
 -1,
 935401745,
 6743,
 -51260,
 935373104,
 6750,
 -51259,
 935548400,
 6747,
 -51258,
 935610709,
 6745,
 -1,
 935667033,
 6749,
 -1,
 934967755,
 6783,
 935933990,
 924895601,
 -1,
 935999496,
 935883134,
 -1,
 936065001,
 935949676,
 -1,
 936130511,
 936017722,
 -1,
 -51251,
 936105040,
 43664,
 -51250,
 936150462,
 43672,
 -1,
 936202346,
 43656,
 936392660,
 936077341,
 -1,
 936458195,
 936333816,
 -1,
 -51246,
 936412606,
 43650,
 -1,
 936466222,
 43652,
 -1,
 936412606,
 43648,
 936720343,
 936359045,
 -1,
 -51242,
 936674750,
 43668,
 -1,
 936728366,
 43670,
 936916954,
 936678182,
 -1,
 -51239,
 936871358,
 43676,
 -1,
 936924974,
 43678,
 937113565,
 936848025,
 -1,
 -51236,
 937067966,
 43658,
 -1,
 937121582,
 43660,
 -51234,
 937088080,
 43684,
 -51233,
 937281972,
 43690,
 -51232,
 937340916,
 43662,
 -51231,
 937403959,
 43686,
 -51230,
 937461182,
 43694,
 -51229,
 937524552,
 43682,
 -51228,
 937587860,
 43688,
 -51227,
 937645870,
 43692,
 -51226,
 937709674,
 43654,
 -51225,
 937773781,
 43680,
 -51224,
 937834605,
 43666,
 -1,
 937896134,
 43674,
 938147839,
 936007146,
 -1,
 938162158,
 938049338,
 -1,
 -51220,
 938136656,
 43665,
 -51219,
 938182078,
 43673,
 -1,
 938233962,
 43657,
 938424307,
 938108957,
 -1,
 938489842,
 938365432,
 -1,
 -51215,
 938444222,
 43651,
 -1,
 938497838,
 43653,
 -1,
 938444222,
 43649,
 938751990,
 938390661,
 -1,
 -51211,
 938706366,
 43669,
 -1,
 938759982,
 43671,
 938948601,
 938709798,
 -1,
 -51208,
 938902974,
 43677,
 -1,
 938956590,
 43679,
 939145212,
 938879641,
 -1,
 -51205,
 939099582,
 43659,
 -1,
 939153198,
 43661,
 -51203,
 939119696,
 43685,
 -51202,
 939313588,
 43691,
 -51201,
 939372532,
 43663,
 -51200,
 939435575,
 43687,
 -51199,
 939492798,
 43695,
 -51198,
 939556168,
 43683,
 -51197,
 939619476,
 43689,
 -51196,
 939677486,
 43693,
 -51195,
 939741290,
 43655,
 -51194,
 939805397,
 43681,
 -51193,
 939866221,
 43667,
 -1,
 939927750,
 43675,
 940128279,
 935971433,
 -1,
 940193807,
 940054694,
 -1,
 -51189,
 940167810,
 43708,
 -51188,
 940228950,
 43707,
 -51187,
 940277562,
 43709,
 -51186,
 940341004,
 43710,
 -1,
 940382374,
 43697,
 940587027,
 940162843,
 43700,
 940652562,
 940522670,
 43699,
 -1,
 940578982,
 43705,
 -1,
 940578982,
 43706,
 940849173,
 940530243,
 43698,
 -1,
 940775590,
 43704,
 -51178,
 940803518,
 43702,
 -1,
 940915886,
 43701,
 941111326,
 940094537,
 -1,
 941176859,
 941058773,
 -1,
 -51174,
 941129530,
 43739,
 -1,
 941185622,
 43743,
 -51172,
 941140373,
 43741,
 -51171,
 941327593,
 43740,
 -1,
 941381425,
 43742,
 941570083,
 941079250,
 -1,
 -51168,
 941537287,
 43713,
 -51167,
 941600822,
 43714,
 -51166,
 941655273,
 43712,
 -1,
 941703376,
 43711,
 941948927,
 941520846,
 -1,
 -51163,
 941840080,
 43703,
 -1,
 941891437,
 43696,
 942145535,
 935882353,
 -1,
 942159923,
 942060677,
 -1,
 942225454,
 942115408,
 -1,
 -51158,
 942151054,
 6516,
 -51157,
 942216345,
 6515,
 -51156,
 942281669,
 6514,
 -51155,
 942346919,
 6513,
 -1,
 942412162,
 6512,
 942618673,
 942188709,
 -1,
 -51152,
 942559758,
 6497,
 -1,
 942610598,
 6483,
 -51150,
 942559758,
 6487,
 -1,
 942741670,
 6486,
 942946358,
 942095534,
 6507,
 -51147,
 942887416,
 6502,
 -1,
 942947502,
 6501,
 943142969,
 942872742,
 6499,
 -51144,
 943112534,
 6508,
 -1,
 943151683,
 6509,
 943339579,
 943111963,
 6503,
 -1,
 943275182,
 6506,
 943470654,
 943297318,
 -1,
 -51139,
 943411726,
 6490,
 -1,
 943462566,
 6489,
 943667264,
 943424958,
 6505,
 -1,
 943621566,
 6504,
 943798339,
 943619898,
 -1,
 -51134,
 943738211,
 6482,
 -1,
 943790246,
 6498,
 943994950,
 943745053,
 -1,
 -51131,
 943936014,
 6496,
 -1,
 943986854,
 6480,
 -51129,
 943968987,
 6485,
 -51128,
 944165306,
 6481,
 -51127,
 944228019,
 6493,
 -51126,
 944286000,
 6484,
 -51125,
 944347830,
 6495,
 -51124,
 944404322,
 6491,
 -51123,
 944466909,
 6488,
 -51122,
 944527939,
 6500,
 -51121,
 944591374,
 6494,
 -1,
 944654371,
 6492,
 944847017,
 924805949,
 -1,
 944912522,
 944796030,
 -1,
 944978008,
 944878725,
 -1,
 945043542,
 944944261,
 -1,
 -51115,
 944984590,
 71317,
 -1,
 945035430,
 71316,
 -51113,
 944984590,
 71322,
 -1,
 945166502,
 71321,
 945371229,
 944930618,
 -1,
 -51110,
 945345243,
 71315,
 -51109,
 945389456,
 71320,
 -51108,
 945442147,
 71310,
 -1,
 945494182,
 71325,
 945698915,
 945304760,
 -1,
 945764449,
 945632440,
 -1,
 -51104,
 945705486,
 71319,
 -1,
 945756326,
 71318,
 -51102,
 945705486,
 71324,
 -1,
 945887398,
 71323,
 946092135,
 945625254,
 71296,
 -51099,
 946061083,
 71305,
 -51098,
 946100803,
 71303,
 -1,
 946149542,
 71297,
 946354281,
 946061083,
 71300,
 -1,
 946323227,
 71301,
 946485356,
 946317477,
 -1,
 -51093,
 946426382,
 71335,
 -1,
 946477222,
 71336,
 946681967,
 946445391,
 -1,
 -51090,
 946642115,
 71338,
 -1,
 946673830,
 71332,
 946878578,
 946639654,
 -1,
 -51087,
 946819598,
 71327,
 -1,
 946870438,
 71326,
 947075189,
 946825245,
 -1,
 -51084,
 947016206,
 71307,
 -1,
 947067046,
 71306,
 947271800,
 947021558,
 -1,
 -51081,
 947212814,
 71314,
 -1,
 947263654,
 71313,
 947468410,
 947214915,
 71298,
 -1,
 947411523,
 71299,
 947599485,
 947408148,
 -1,
 -51076,
 947540494,
 71309,
 -1,
 947591334,
 71308,
 947796096,
 947530393,
 -1,
 -51073,
 947737102,
 71312,
 -1,
 947787942,
 71311,
 947992707,
 947725604,
 -1,
 -51070,
 947933710,
 71329,
 -1,
 947984550,
 71328,
 -51068,
 947966683,
 71331,
 -51067,
 948160179,
 71334,
 -51066,
 948209086,
 71304,
 -51065,
 948270946,
 71330,
 -51064,
 948333533,
 71333,
 -51063,
 948392462,
 71337,
 -1,
 948452526,
 71302,
 948648088,
 944846746,
 -1,
 948713614,
 948614277,
 -1,
 -51059,
 948686795,
 71362,
 -1,
 948721883,
 71363,
 948910225,
 948676773,
 -1,
 -51056,
 948856439,
 71366,
 -1,
 948913646,
 71367,
 949106836,
 948848590,
 -1,
 -51053,
 949063528,
 71364,
 -1,
 949118419,
 71365,
 -51051,
 949081470,
 71360,
 -51050,
 949258680,
 71361,
 -51049,
 949322331,
 71369,
 -1,
 949370990,
 71368,
 949565603,
 948619930,
 -1,
 949631133,
 949491878,
 -1,
 -51045,
 949600027,
 71349,
 -51044,
 949639747,
 71347,
 -1,
 949688486,
 71341,
 949893279,
 949600027,
 71344,
 -1,
 949862171,
 71345,
 950024353,
 949836355,
 71342,
 -1,
 949967427,
 71343,
 -51038,
 949978558,
 71348,
 -1,
 950090926,
 71346,
 950337535,
 949529974,
 -1,
 950352039,
 950258001,
 -1,
 -51034,
 950315483,
 71340,
 -1,
 950377973,
 71350,
 -51032,
 950306031,
 71351,
 -1,
 950476850,
 71339,
 950679724,
 944799546,
 -1,
 -51029,
 950619894,
 127818,
 -1,
 950671756,
 127883,
 950876334,
 950609188,
 983061,
 -1,
 950824572,
 127955,
 -51025,
 950850095,
 128661,
 -51024,
 950965510,
 128429,
 -1,
 951005248,
 127790,
 951204231,
 901601859,
 -1,
 951269666,
 951163983,
 -1,
 951335201,
 951212553,
 -1,
 951400690,
 951284094,
 -1,
 951466172,
 951371421,
 -1,
 951531707,
 951420478,
 -1,
 951597241,
 951491663,
 70791,
 -1,
 951557199,
 70792,
 951779327,
 951544751,
 70793,
 -1,
 951675823,
 70794,
 -1,
 951457958,
 70827,
 951924930,
 951432325,
 -1,
 951990464,
 951891077,
 -1,
 -51009,
 951931406,
 70810,
 -1,
 951982246,
 70809,
 -51007,
 951931406,
 70815,
 -1,
 952113318,
 70814,
 952318151,
 951877434,
 -1,
 -51004,
 952292059,
 70808,
 -51003,
 952336272,
 70813,
 -51002,
 952388963,
 70803,
 -1,
 952440998,
 70818,
 952645837,
 952251576,
 -1,
 952711371,
 952579256,
 -1,
 -50998,
 952652302,
 70812,
 -1,
 952703142,
 70811,
 -50996,
 952652302,
 70817,
 -1,
 952834214,
 70816,
 953039057,
 952572070,
 70785,
 -50993,
 953007899,
 70798,
 -50992,
 953047619,
 70796,
 -1,
 953096358,
 70786,
 953301205,
 953002149,
 -1,
 -50989,
 953264432,
 70829,
 -50988,
 953307662,
 70828,
 -1,
 953358502,
 70830,
 953563351,
 953270043,
 70789,
 -1,
 953532187,
 70790,
 953694426,
 953520934,
 -1,
 -50983,
 953635342,
 70820,
 -1,
 953686182,
 70819,
 953891037,
 953640989,
 -1,
 -50980,
 953831950,
 70800,
 -1,
 953882790,
 70799,
 954087648,
 953837302,
 -1,
 -50977,
 954028558,
 70807,
 -1,
 954079398,
 70806,
 954284258,
 954030659,
 70787,
 -1,
 954227267,
 70788,
 954415333,
 954223892,
 -1,
 -50972,
 954356238,
 70802,
 -1,
 954407078,
 70801,
 954611944,
 954346137,
 -1,
 -50969,
 954552846,
 70805,
 -1,
 954603686,
 70804,
 954808555,
 954541348,
 -1,
 -50966,
 954749454,
 70822,
 -1,
 954800294,
 70821,
 -50964,
 954782427,
 70824,
 -50963,
 954965187,
 70825,
 -50962,
 955024830,
 70797,
 -50961,
 955086690,
 70823,
 -50960,
 955149277,
 70826,
 -50959,
 955208206,
 70831,
 -1,
 955268270,
 70795,
 955463941,
 951372442,
 -1,
 955529464,
 955435470,
 -1,
 955594998,
 955489359,
 70837,
 -1,
 955554895,
 70838,
 955777023,
 955542447,
 70839,
 -1,
 955673519,
 70840,
 955857148,
 955455654,
 -1,
 -50950,
 955825947,
 70846,
 -50949,
 955865667,
 70843,
 -1,
 955914406,
 70832,
 956119294,
 955825947,
 70835,
 -1,
 956088091,
 70836,
 956250369,
 956083349,
 -1,
 -50944,
 956204478,
 70845,
 -1,
 956251310,
 70842,
 956446979,
 956193347,
 70833,
 -1,
 956389955,
 70834,
 -50940,
 956401086,
 70844,
 -1,
 956513454,
 70841,
 956709139,
 955398042,
 -1,
 956774665,
 956675205,
 -1,
 -50936,
 956747723,
 70866,
 -1,
 956782811,
 70867,
 956971276,
 956737701,
 -1,
 -50933,
 956917367,
 70870,
 -1,
 956974574,
 70871,
 957167887,
 956909518,
 -1,
 -50930,
 957124456,
 70868,
 -1,
 957179347,
 70869,
 -50928,
 957142398,
 70864,
 -50927,
 957319608,
 70865,
 -50926,
 957383259,
 70873,
 -1,
 957431918,
 70872,
 957626652,
 956673398,
 -1,
 957692183,
 957598033,
 -1,
 -50922,
 957655515,
 70849,
 -1,
 957718005,
 70850,
 957888794,
 957618342,
 -1,
 -50919,
 957859510,
 70852,
 -1,
 957908286,
 70848,
 -50917,
 957842671,
 70851,
 -1,
 958016346,
 70847,
 958216479,
 957552806,
 -1,
 -50914,
 958169829,
 70784,
 -1,
 958211730,
 70854,
 -50912,
 958171328,
 70855,
 -1,
 958353829,
 70853,
 -1,
 951271132,
 128555,
 958609765,
 951208256,
 -1,
 958675298,
 958558590,
 -1,
 958740816,
 958648962,
 -1,
 958806347,
 958666918,
 11568,
 958871850,
 958739640,
 11575,
 958937385,
 958805176,
 11577,
 -1,
 958878200,
 11578,
 -1,
 958878200,
 11576,
 959133997,
 958846149,
 11619,
 -50900,
 959108293,
 11621,
 -1,
 959140344,
 11594,
 959330608,
 959100037,
 11612,
 -50897,
 959296645,
 11615,
 -1,
 959336952,
 11613,
 959527219,
 959293605,
 11609,
 -50894,
 959490213,
 11610,
 -1,
 959533560,
 11611,
 959723830,
 959473693,
 11581,
 959840255,
 959664632,
 11589,
 -1,
 959730168,
 11583,
 959920441,
 959663380,
 11571,
 960036863,
 959861240,
 11606,
 -1,
 959926776,
 11572,
 960117051,
 959880271,
 11604,
 -1,
 960076879,
 11605,
 960248125,
 960057848,
 11584,
 -1,
 960188920,
 11587,
 960379199,
 960177444,
 11569,
 -1,
 960319992,
 11570,
 -50880,
 960352898,
 11618,
 -50879,
 960482062,
 11617,
 -50878,
 960546461,
 11616,
 -50877,
 960600744,
 11591,
 -50876,
 960664358,
 11602,
 -50875,
 960724794,
 11599,
 -50874,
 960788236,
 11598,
 -50873,
 960850863,
 11597,
 -50872,
 960915190,
 11574,
 -50871,
 960972750,
 11580,
 -50870,
 961031420,
 11614,
 -1,
 961091750,
 11588,
 961296717,
 958741678,
 11622,
 -1,
 961270402,
 11579,
 -50866,
 961265435,
 11603,
 -50865,
 961381822,
 11623,
 -1,
 961436227,
 11593,
 961624412,
 958706821,
 -1,
 961689947,
 961593328,
 -1,
 961755476,
 961636381,
 11582,
 -1,
 961696248,
 11590,
 961886551,
 961694996,
 -1,
 -50858,
 961838906,
 11600,
 -1,
 961892856,
 11607,
 -50856,
 961861051,
 11596,
 -50855,
 962042536,
 11592,
 -50854,
 962101651,
 11601,
 -1,
 962155000,
 11586,
 -1,
 961619159,
 11620,
 962410847,
 961554193,
 -1,
 -50850,
 962356982,
 11573,
 -1,
 962417144,
 11585,
 962658303,
 962336934,
 -1,
 -50847,
 962581427,
 11608,
 -1,
 962613811,
 11595,
 -50845,
 958638774,
 11632,
 -50844,
 962755946,
 11631,
 -1,
 962801953,
 11647,
 963000699,
 958539572,
 -1,
 963066224,
 962951452,
 -1,
 963131754,
 962995492,
 -1,
 -50839,
 963096181,
 4048,
 -1,
 963143805,
 983208,
 -50837,
 963099552,
 4058,
 -50836,
 963282345,
 4050,
 -50835,
 963345713,
 4049,
 -50834,
 963407555,
 4057,
 -50833,
 963469722,
 4051,
 -1,
 963522574,
 4052,
 963721592,
 963029157,
 -1,
 963787125,
 963690541,
 -1,
 -50829,
 963738128,
 3982,
 -50828,
 963800569,
 3981,
 -1,
 963863313,
 3983,
 964100095,
 963730881,
 -1,
 -50825,
 964009730,
 4046,
 -1,
 964059921,
 3980,
 964296703,
 963670398,
 -1,
 -50822,
 964208480,
 3948,
 -1,
 964258496,
 3947,
 964442498,
 962948681,
 -1,
 964508033,
 964415073,
 -1,
 964573568,
 964442274,
 -1,
 -50817,
 964503266,
 11807,
 -1,
 964565477,
 11806,
 -1,
 964535455,
 11803,
 -1,
 964463665,
 11081,
 964901252,
 964382450,
 128005,
 -1,
 964821730,
 128047,
 -50811,
 964855145,
 68410,
 -50810,
 964983616,
 9202,
 -1,
 965029758,
 127915,
 965229093,
 951139502,
 -1,
 965294590,
 965196679,
 -1,
 965360027,
 965225113,
 -1,
 965425556,
 965313982,
 -1,
 965491089,
 965377850,
 -1,
 965556624,
 965457029,
 -1,
 -50802,
 965516871,
 119563,
 -50801,
 965559009,
 119582,
 -1,
 965614240,
 119573,
 -1,
 965521853,
 119608,
 965935103,
 965443135,
 -1,
 -50797,
 965827378,
 119634,
 -1,
 965887251,
 119630,
 966080921,
 965375269,
 -1,
 966146456,
 966016174,
 -1,
 -50793,
 966099263,
 119590,
 -1,
 966145276,
 119613,
 -1,
 966116715,
 119631,
 -50790,
 966022053,
 119585,
 -1,
 966345448,
 119558,
 966539689,
 965293240,
 -1,
 966605218,
 966482499,
 -1,
 966670752,
 966555404,
 -1,
 -50785,
 966622400,
 119625,
 -1,
 966680967,
 119612,
 -50783,
 966641675,
 119568,
 -1,
 966805735,
 119636,
 966998438,
 966540462,
 -1,
 -50780,
 966956262,
 119623,
 -50779,
 967002252,
 119567,
 -1,
 967061271,
 119586,
 -50777,
 966968940,
 119584,
 -50776,
 967216931,
 119619,
 -1,
 967254327,
 119624,
 967457202,
 966474926,
 -1,
 967522734,
 967409466,
 -1,
 -50772,
 967470409,
 119603,
 -50771,
 967521835,
 119583,
 -1,
 967586361,
 119600,
 -50769,
 967496218,
 119626,
 -50768,
 967751477,
 119610,
 -50767,
 967801273,
 119618,
 -1,
 967844513,
 119580,
 968047036,
 967416911,
 -1,
 968112571,
 967982254,
 -1,
 968178105,
 968075429,
 -1,
 968243640,
 968120899,
 -1,
 -50761,
 968208822,
 119579,
 -1,
 968242781,
 119596,
 -1,
 968202376,
 119598,
 -50758,
 968126184,
 119578,
 -1,
 968432208,
 119572,
 -1,
 968058314,
 119605,
 968702405,
 967985102,
 -1,
 968767936,
 968671742,
 -1,
 -50753,
 968720703,
 119595,
 -1,
 968753675,
 119559,
 968964547,
 968721854,
 -1,
 -50750,
 968929786,
 119638,
 -1,
 968979575,
 119576,
 -50748,
 968913567,
 119606,
 -1,
 969088141,
 119632,
 969292237,
 968665253,
 -1,
 969357771,
 969258117,
 -1,
 969423306,
 969311678,
 -1,
 -50743,
 969394046,
 119601,
 -1,
 969447651,
 119628,
 -1,
 969384130,
 119593,
 -50740,
 969302462,
 119621,
 -1,
 969623117,
 119627,
 969816531,
 969231636,
 -1,
 969882064,
 969745303,
 119592,
 -1,
 969802614,
 119615,
 -50735,
 969850853,
 119614,
 -50734,
 969973658,
 119602,
 -1,
 970033044,
 119599,
 970209753,
 969773862,
 -1,
 970275287,
 970135718,
 -1,
 -50730,
 970243421,
 119604,
 -1,
 970272659,
 119588,
 -50728,
 970245512,
 119594,
 -1,
 970408528,
 119571,
 970602974,
 970135718,
 -1,
 -50725,
 970566127,
 119564,
 -50724,
 970608443,
 119633,
 -50723,
 970669182,
 119577,
 -1,
 970730580,
 119617,
 970930658,
 970553100,
 -1,
 -50720,
 970875977,
 119560,
 -50719,
 970931806,
 119609,
 -1,
 970990307,
 119616,
 971192807,
 970877871,
 -1,
 971258342,
 971118758,
 -1,
 -50715,
 971229968,
 119597,
 -1,
 971254126,
 119637,
 -1,
 971194419,
 119589,
 971520491,
 971121956,
 -1,
 -50711,
 971480579,
 119566,
 -50710,
 971540572,
 119587,
 -1,
 971579860,
 119561,
 971782638,
 971492174,
 -1,
 -50707,
 971748900,
 119620,
 -1,
 971793817,
 119575,
 971979249,
 971736510,
 -1,
 -50704,
 971938075,
 119565,
 -1,
 971997002,
 119635,
 972175860,
 971925533,
 -1,
 -50701,
 972120555,
 119591,
 -1,
 972177322,
 119562,
 972372471,
 972119752,
 -1,
 -50698,
 972325156,
 119622,
 -1,
 972370545,
 119570,
 972569082,
 972313080,
 -1,
 -50695,
 972523650,
 119574,
 -1,
 972562709,
 119629,
 -50693,
 972543091,
 119569,
 -50692,
 972736355,
 119607,
 -50691,
 972800804,
 119611,
 -1,
 972842988,
 119581,
 973027870,
 965241775,
 -1,
 973093399,
 972996999,
 -1,
 973158924,
 973032507,
 -1,
 973224456,
 973124741,
 -1,
 973289989,
 973197399,
 -1,
 -50684,
 973244065,
 3194,
 -1,
 973293069,
 3197,
 973537279,
 973232469,
 -1,
 -50681,
 973440673,
 3195,
 -1,
 973489677,
 3198,
 973683211,
 973179348,
 -1,
 -50678,
 973637281,
 3193,
 -1,
 973686285,
 3196,
 -1,
 973657481,
 3192,
 973945361,
 973107582,
 -1,
 -50674,
 973913378,
 3160,
 -50673,
 973973408,
 3162,
 -50672,
 974025842,
 3124,
 -1,
 974077089,
 3161,
 974273045,
 973909366,
 -1,
 -50669,
 974241343,
 3199,
 -50668,
 974270600,
 3072,
 -1,
 974333072,
 3133,
 974585855,
 974244552,
 3170,
 -1,
 974482351,
 3171,
 974716927,
 973028526,
 -1,
 974731804,
 974624344,
 -1,
 974797339,
 974692259,
 128222,
 -1,
 974720256,
 128380,
 -1,
 974752100,
 128384,
 -50659,
 974703010,
 128250,
 -1,
 974957063,
 128301,
 975125026,
 972980026,
 -1,
 -50656,
 975090821,
 9978,
 -50655,
 975143607,
 127934,
 -1,
 975195797,
 8376,
 975437823,
 975050918,
 -1,
 -50652,
 975346840,
 128198,
 -1,
 975385631,
 127861,
 975583821,
 965169656,
 -1,
 975649345,
 975544367,
 -1,
 975714873,
 975568896,
 -1,
 975780397,
 975675052,
 -1,
 -50646,
 975741573,
 128487,
 -50645,
 975793956,
 128486,
 -50644,
 975840994,
 128485,
 -1,
 975903205,
 128484,
 976108082,
 975727535,
 -1,
 976173617,
 976052258,
 -1,
 -50640,
 976134789,
 9886,
 -1,
 976187172,
 9887,
 -1,
 976109603,
 11057,
 976435765,
 976041144,
 -1,
 -50636,
 976391721,
 8278,
 -1,
 976445057,
 10176,
 -50634,
 976400501,
 128491,
 -50633,
 976590804,
 128962,
 -50632,
 976650564,
 128423,
 -1,
 976693876,
 128433,
 976945151,
 975637995,
 -1,
 976960064,
 976827578,
 -1,
 977025598,
 976927509,
 -1,
 -50627,
 976987214,
 11162,
 -1,
 977039503,
 11160,
 -50625,
 976987023,
 11161,
 -1,
 977170414,
 11163,
 -1,
 976896328,
 11835,
 977418822,
 975617819,
 -1,
 977484357,
 977369611,
 -1,
 -50620,
 977454051,
 128077,
 -1,
 977484592,
 128078,
 -1,
 977436774,
 9928,
 977746507,
 977362632,
 -1,
 977812042,
 977666048,
 -1,
 -50615,
 977774989,
 128936,
 -1,
 977817918,
 128929,
 -1,
 977758828,
 129300,
 -50612,
 977702728,
 128173,
 -1,
 978011184,
 127777,
 978205294,
 975537598,
 -1,
 978270814,
 978167787,
 -1,
 978336349,
 978202416,
 -1,
 978401876,
 978261390,
 -1,
 -50606,
 978327330,
 127552,
 -50605,
 978392442,
 127560,
 -1,
 978457233,
 127557,
 978664023,
 978327134,
 -1,
 -50602,
 978589274,
 127558,
 -1,
 978653271,
 127556,
 978860634,
 978588825,
 -1,
 -50599,
 978789717,
 127555,
 -1,
 978850467,
 127559,
 979107839,
 978785430,
 -1,
 -50596,
 978982888,
 127554,
 -1,
 979046484,
 127553,
 -1,
 978283940,
 127274,
 979319402,
 978228008,
 -1,
 979384932,
 979259918,
 -1,
 979450467,
 979333642,
 -1,
 -50590,
 979413607,
 11833,
 -1,
 979445825,
 11210,
 -1,
 979416197,
 127913,
 -50587,
 979357498,
 128285,
 -50586,
 979680063,
 9184,
 -50585,
 979739339,
 11811,
 -50584,
 979801254,
 9180,
 -50583,
 979857252,
 11810,
 -1,
 979907662,
 9182,
 -50581,
 979272207,
 128069,
 -50580,
 980056477,
 127813,
 -50579,
 980118437,
 128508,
 -1,
 980180555,
 128701,
 980368010,
 978173723,
 -1,
 980433545,
 980327503,
 -1,
 980499077,
 980385966,
 -1,
 980564599,
 980461733,
 -1,
 980630133,
 980521075,
 -1,
 -50572,
 980602046,
 128597,
 -1,
 980631063,
 128599,
 -50570,
 980580472,
 8526,
 -1,
 980762979,
 11829,
 980957820,
 980497592,
 -1,
 981023355,
 980901296,
 -1,
 -50566,
 980996043,
 8586,
 -1,
 981031131,
 8587,
 -1,
 980950012,
 11832,
 981285503,
 980910973,
 -1,
 -50562,
 981257406,
 128596,
 -1,
 981286423,
 128598,
 981482114,
 981215278,
 -1,
 -50559,
 981445757,
 9930,
 -1,
 981505428,
 11202,
 -50557,
 981454248,
 9929,
 -50556,
 981632975,
 128399,
 -1,
 981676222,
 11826,
 981875336,
 980445213,
 -1,
 -50553,
 981820567,
 8378,
 -1,
 981878727,
 129411,
 -1,
 981842532,
 128034,
 -1,
 980382595,
 127799,
 982203042,
 980327503,
 -1,
 982268563,
 982145603,
 -1,
 982334097,
 982196077,
 -1,
 982399632,
 982303200,
 -1,
 -50545,
 982362159,
 128208,
 -1,
 982403621,
 128681,
 -1,
 982347435,
 128710,
 -50542,
 982267501,
 128305,
 -1,
 982593630,
 8285,
 982792858,
 982194342,
 -1,
 982858390,
 982742796,
 128650,
 -1,
 982778325,
 128651,
 982989465,
 982788761,
 -1,
 -50536,
 982956834,
 128668,
 -1,
 983001445,
 128434,
 -1,
 982933192,
 128646,
 983251617,
 982746558,
 -1,
 983317152,
 983208742,
 -1,
 983382687,
 983260031,
 -1,
 -50530,
 983321019,
 128032,
 -1,
 983383032,
 127865,
 -1,
 983325233,
 127942,
 -1,
 983266373,
 128654,
 -1,
 983220833,
 127930,
 983775919,
 982174478,
 -1,
 983841454,
 983729598,
 -1,
 983906989,
 983760896,
 -1,
 983972520,
 983840926,
 -1,
 -50521,
 983935197,
 11818,
 -1,
 983959618,
 8282,
 -50519,
 983945449,
 128109,
 -50518,
 984133749,
 128490,
 -50517,
 984185608,
 128108,
 -50516,
 984241292,
 128149,
 -1,
 984296052,
 128432,
 -1,
 983830065,
 11834,
 -1,
 983786730,
 128256,
 -1,
 983699222,
 128085,
 984694394,
 901564061,
 -1,
 984759566,
 984619174,
 -1,
 984824845,
 984701509,
 -1,
 984890364,
 984790033,
 -1,
 984955881,
 984839178,
 -1,
 985021160,
 984907578,
 -1,
 985086659,
 984960276,
 42507,
 985152192,
 985025812,
 -1,
 985217723,
 985087150,
 42500,
 -50502,
 985169722,
 42501,
 -1,
 985218222,
 42271,
 985414333,
 985171390,
 42460,
 -1,
 985367998,
 42384,
 -50498,
 985382683,
 42421,
 -50497,
 985487939,
 42308,
 -1,
 985536678,
 42348,
 -50495,
 985106742,
 42428,
 -50494,
 985678218,
 42467,
 -1,
 985734825,
 42315,
 985938641,
 985019576,
 -1,
 986004172,
 985892286,
 42450,
 986069707,
 985951845,
 -1,
 -50489,
 986034235,
 42514,
 -50488,
 986085218,
 42538,
 -50487,
 986146927,
 42513,
 -50486,
 986204195,
 42512,
 -1,
 986265709,
 42539,
 -1,
 986023358,
 42374,
 986528462,
 985939118,
 42490,
 -1,
 986463406,
 42261,
 -50481,
 986496795,
 42411,
 -50480,
 986602051,
 42298,
 -1,
 986650790,
 42337,
 986856153,
 985911938,
 -1,
 986921684,
 986809790,
 42464,
 -1,
 986875326,
 42388,
 987052758,
 986856622,
 42506,
 -1,
 986987694,
 42275,
 -50473,
 987021083,
 42425,
 -50472,
 987126339,
 42312,
 -1,
 987175078,
 42352,
 987380449,
 986801910,
 -1,
 987445980,
 987334078,
 42457,
 -1,
 987399614,
 42381,
 987577054,
 987380910,
 42497,
 -1,
 987511982,
 42268,
 -50465,
 987545371,
 42418,
 -50464,
 987650627,
 42305,
 -1,
 987699366,
 42344,
 987904739,
 987334078,
 42463,
 -1,
 987858366,
 42387,
 988035813,
 987839662,
 42505,
 -1,
 987970734,
 42274,
 -50458,
 988004123,
 42424,
 -50457,
 988109379,
 42311,
 -1,
 988158118,
 42351,
 988363520,
 984971020,
 -1,
 988429041,
 988302916,
 -1,
 988494572,
 988382654,
 42438,
 -1,
 988448190,
 42363,
 988625646,
 988429486,
 42478,
 -1,
 988560558,
 42250,
 -50449,
 988593947,
 42400,
 -50448,
 988699203,
 42287,
 -1,
 988747942,
 42326,
 988953337,
 988357924,
 -1,
 989018868,
 988906942,
 42436,
 -1,
 988972478,
 42361,
 989149942,
 988953774,
 42475,
 -1,
 989084846,
 42248,
 -50441,
 989118235,
 42398,
 -50440,
 989223491,
 42285,
 -1,
 989272230,
 42323,
 989477627,
 988906942,
 42462,
 -1,
 989431230,
 42386,
 989608701,
 989412526,
 42504,
 -1,
 989543598,
 42273,
 -50434,
 989576987,
 42423,
 -50433,
 989682243,
 42310,
 -1,
 989730982,
 42350,
 989936408,
 988296376,
 -1,
 990001937,
 989876728,
 -1,
 990067466,
 989942264,
 -1,
 990132997,
 990021054,
 42446,
 -1,
 990086590,
 42370,
 990264071,
 990067886,
 42486,
 -1,
 990198958,
 42257,
 -50424,
 990232347,
 42407,
 -50423,
 990337603,
 42294,
 -1,
 990386342,
 42333,
 990591756,
 990021054,
 42445,
 -1,
 990545342,
 42369,
 990722830,
 990526638,
 42485,
 -1,
 990657710,
 42256,
 -50417,
 990691099,
 42406,
 -50416,
 990796355,
 42293,
 -1,
 990845094,
 42332,
 991050515,
 989955518,
 42449,
 -1,
 991004094,
 42373,
 991181589,
 990985390,
 42489,
 -1,
 991116462,
 42260,
 -50410,
 991149851,
 42410,
 -50409,
 991255107,
 42297,
 -1,
 991303846,
 42336,
 991509291,
 989882397,
 -1,
 991574819,
 991466278,
 -1,
 991640349,
 991509678,
 42476,
 -50404,
 991592250,
 42477,
 -1,
 991640750,
 42249,
 991836959,
 991593918,
 42437,
 -1,
 991790526,
 42362,
 991968033,
 991762598,
 42324,
 -1,
 991919930,
 42325,
 -50398,
 991936283,
 42399,
 -1,
 992041539,
 42286,
 992230181,
 991528382,
 42459,
 -1,
 992183742,
 42383,
 992361255,
 992165038,
 42499,
 -1,
 992296110,
 42270,
 992492329,
 992286886,
 42346,
 -1,
 992444218,
 42347,
 -50390,
 992460571,
 42420,
 -1,
 992565827,
 42307,
 992754494,
 991448340,
 -1,
 992820022,
 992683300,
 -1,
 992885552,
 992773566,
 42439,
 -50385,
 992839102,
 42364,
 -1,
 992902970,
 42440,
 993082163,
 992820398,
 42479,
 -50382,
 993034042,
 42480,
 -1,
 993082542,
 42251,
 -50380,
 993050395,
 42401,
 -50379,
 993221187,
 42288,
 -1,
 993269926,
 42327,
 993475385,
 992754862,
 42502,
 -50376,
 993427258,
 42503,
 -1,
 993475758,
 42272,
 993671995,
 993428926,
 42461,
 -1,
 993625534,
 42385,
 -50372,
 993640219,
 42422,
 -50371,
 993745475,
 42309,
 -1,
 993794214,
 42349,
 993999694,
 992728261,
 -1,
 994065223,
 993939960,
 -1,
 994130754,
 994018750,
 42454,
 -1,
 994084286,
 42378,
 994261828,
 994065582,
 42494,
 -1,
 994196654,
 42265,
 -50363,
 994230043,
 42415,
 -50362,
 994335299,
 42302,
 -1,
 994384038,
 42341,
 994589513,
 994018750,
 42453,
 -1,
 994543038,
 42377,
 994720587,
 994524334,
 42493,
 -1,
 994655406,
 42264,
 -50356,
 994688795,
 42414,
 -50355,
 994794051,
 42301,
 -1,
 994842790,
 42340,
 995048285,
 993970958,
 -1,
 995113811,
 995001790,
 42431,
 995179346,
 995067326,
 42356,
 -1,
 995131194,
 42357,
 -1,
 995131194,
 42432,
 995375959,
 995048622,
 42470,
 995441494,
 995310766,
 42243,
 -1,
 995393338,
 42244,
 -1,
 995393338,
 42471,
 995638105,
 995344155,
 42393,
 -1,
 995589946,
 42394,
 995769179,
 995580483,
 42280,
 -1,
 995721018,
 42281,
 995950591,
 995694758,
 42318,
 -1,
 995852090,
 42319,
 996031341,
 995013765,
 -1,
 996096870,
 995971576,
 -1,
 996162401,
 996050366,
 42444,
 -1,
 996115902,
 42368,
 996293475,
 996097198,
 42484,
 -1,
 996228270,
 42255,
 -50332,
 996261659,
 42405,
 -50331,
 996366915,
 42292,
 -1,
 996415654,
 42331,
 996621160,
 996050366,
 42443,
 -1,
 996574654,
 42367,
 996752234,
 996555950,
 42483,
 -1,
 996687022,
 42254,
 -50325,
 996720411,
 42404,
 -50324,
 996825667,
 42291,
 -1,
 996874406,
 42330,
 997079933,
 995993765,
 -1,
 997145462,
 997020152,
 -1,
 997210993,
 997098942,
 42452,
 -1,
 997164478,
 42376,
 997342067,
 997145774,
 42492,
 -1,
 997276846,
 42263,
 -50316,
 997310235,
 42413,
 -50315,
 997415491,
 42300,
 -1,
 997464230,
 42339,
 997669752,
 997098942,
 42451,
 -1,
 997623230,
 42375,
 997800826,
 997604526,
 42491,
 -1,
 997735598,
 42262,
 -50309,
 997768987,
 42412,
 -50308,
 997874243,
 42299,
 -1,
 997922982,
 42338,
 998128525,
 997008676,
 -1,
 998194054,
 998068728,
 -1,
 998259585,
 998147518,
 42434,
 -1,
 998213054,
 42359,
 998390659,
 998194350,
 42473,
 -1,
 998325422,
 42246,
 -50300,
 998358811,
 42396,
 -50299,
 998464067,
 42283,
 -1,
 998512806,
 42321,
 998718344,
 998147518,
 42435,
 -1,
 998671806,
 42360,
 998849418,
 998653102,
 42474,
 -1,
 998784174,
 42247,
 -50293,
 998817563,
 42397,
 -50292,
 998922819,
 42284,
 -1,
 998971558,
 42322,
 999177114,
 998068728,
 -1,
 999242641,
 999130558,
 42429,
 -50288,
 999196094,
 42355,
 -1,
 999259962,
 42430,
 999439252,
 999177390,
 42468,
 -50285,
 999391034,
 42469,
 -1,
 999439534,
 42242,
 999635862,
 999407387,
 42391,
 -1,
 999587642,
 42392,
 999766936,
 999578179,
 42278,
 -1,
 999718714,
 42279,
 999948287,
 999692454,
 42316,
 -1,
 999849786,
 42317,
 1000029091,
 999123887,
 -1,
 1000094622,
 999963822,
 42487,
 -50275,
 1000047110,
 42508,
 -1,
 1000094894,
 42258,
 1000291232,
 1000048062,
 42447,
 -1,
 1000244670,
 42371,
 -50271,
 1000259355,
 42408,
 -50270,
 1000364611,
 42295,
 -1,
 1000413350,
 42334,
 1000618923,
 1000002178,
 -1,
 1000684454,
 1000572350,
 42458,
 -1,
 1000637886,
 42382,
 1000815528,
 1000619182,
 42498,
 -1,
 1000750254,
 42269,
 -50263,
 1000783643,
 42419,
 -50262,
 1000888899,
 42306,
 -1,
 1000937638,
 42345,
 1001143219,
 1000588957,
 -1,
 1001208750,
 1001096638,
 42442,
 -1,
 1001162174,
 42366,
 1001339824,
 1001143470,
 42482,
 -1,
 1001274542,
 42253,
 -50255,
 1001307931,
 42403,
 -50254,
 1001413187,
 42290,
 -1,
 1001461926,
 42329,
 1001667515,
 1001102415,
 -1,
 1001733046,
 1001620926,
 42448,
 -1,
 1001686462,
 42372,
 1001864120,
 1001667758,
 42488,
 -1,
 1001798830,
 42259,
 -50247,
 1001832219,
 42409,
 -50246,
 1001937475,
 42296,
 -1,
 1001986214,
 42335,
 1002191811,
 1001624358,
 -1,
 1002257342,
 1002145214,
 42433,
 -1,
 1002210750,
 42358,
 1002388416,
 1002192046,
 42472,
 -1,
 1002323118,
 42245,
 -50239,
 1002356507,
 42395,
 -50238,
 1002461763,
 42282,
 -1,
 1002510502,
 42320,
 1002716107,
 1002137334,
 -1,
 1002781638,
 1002669502,
 42456,
 -1,
 1002735038,
 42380,
 1002912712,
 1002716334,
 42496,
 -1,
 1002847406,
 42267,
 -50231,
 1002880795,
 42417,
 -50230,
 1002986051,
 42304,
 -1,
 1003034790,
 42343,
 1003240403,
 1002653646,
 -1,
 1003305934,
 1003193790,
 42441,
 -1,
 1003259326,
 42365,
 1003437008,
 1003240622,
 42481,
 -1,
 1003371694,
 42252,
 -50223,
 1003405083,
 42402,
 -50222,
 1003510339,
 42289,
 -1,
 1003559078,
 42328,
 1003764699,
 1003170457,
 -1,
 1003830230,
 1003718078,
 42455,
 -1,
 1003783614,
 42379,
 1003961304,
 1003764910,
 42495,
 -1,
 1003895982,
 42266,
 -50215,
 1003929371,
 42416,
 -50214,
 1004034627,
 42303,
 -1,
 1004083366,
 42342,
 1004288991,
 1003718078,
 42426,
 1004354526,
 1004242366,
 42353,
 -1,
 1004306234,
 42354,
 -1,
 1004306234,
 42427,
 1004551139,
 1004223662,
 42465,
 1004616674,
 1004485806,
 42240,
 -1,
 1004568378,
 42241,
 -1,
 1004568378,
 42466,
 1004813285,
 1004519195,
 42389,
 -1,
 1004764986,
 42390,
 1004944359,
 1004755523,
 42276,
 -1,
 1004896058,
 42277,
 1005125631,
 1004869798,
 42313,
 -1,
 1005027130,
 42314,
 1005256703,
 984906213,
 -1,
 1005272046,
 1005171845,
 -1,
 -50196,
 1005226581,
 42525,
 -50195,
 1005281338,
 42517,
 -1,
 1005328724,
 42521,
 1005534195,
 1005204664,
 -1,
 1005599730,
 1005487550,
 -1,
 -50191,
 1005554261,
 42523,
 -1,
 1005588152,
 42526,
 -1,
 1005526893,
 42522,
 1005861878,
 1005479965,
 -1,
 -50187,
 1005830890,
 42524,
 -1,
 1005862817,
 42516,
 1006058489,
 1005799374,
 -1,
 -50184,
 1005993889,
 42515,
 -1,
 1006049620,
 42520,
 -50182,
 1006010955,
 42518,
 -50181,
 1006200796,
 42527,
 -1,
 1006249409,
 42519,
 1006451722,
 984823706,
 -1,
 1006517248,
 1006417029,
 -1,
 -50177,
 1006489547,
 42530,
 -1,
 1006524635,
 42531,
 1006713859,
 1006479525,
 -1,
 -50174,
 1006659191,
 42534,
 -1,
 1006716398,
 42535,
 1006910470,
 1006651342,
 -1,
 -50171,
 1006866280,
 42532,
 -1,
 1006921171,
 42533,
 -50169,
 1006884222,
 42528,
 -50168,
 1007061432,
 42529,
 -50167,
 1007125083,
 42537,
 -1,
 1007173742,
 42536,
 -50165,
 1006410749,
 42511,
 -50164,
 1007308035,
 42510,
 -1,
 1007366334,
 42509,
 1007615999,
 984785431,
 -1,
 1007631485,
 1007489115,
 -1,
 1007696922,
 1007556591,
 917762,
 -50159,
 1007622127,
 917942,
 -50158,
 1007687486,
 917941,
 -50157,
 1007752798,
 917940,
 -50156,
 1007818126,
 917939,
 -50155,
 1007883417,
 917938,
 -50154,
 1007948741,
 917937,
 -50153,
 1008013991,
 917936,
 -50152,
 1008079234,
 917935,
 -50151,
 1008144475,
 917934,
 -1,
 1008209746,
 917933,
 1008417829,
 1007621950,
 917761,
 -50148,
 1008343023,
 917932,
 -50147,
 1008408382,
 917931,
 -50146,
 1008473694,
 917930,
 -50145,
 1008539022,
 917929,
 -50144,
 1008604313,
 917928,
 -50143,
 1008669637,
 917927,
 -50142,
 1008734887,
 917926,
 -50141,
 1008800130,
 917925,
 -50140,
 1008865371,
 917924,
 -1,
 1008930642,
 917923,
 1009138736,
 1008342622,
 917760,
 -50137,
 1009063919,
 917922,
 -50136,
 1009129278,
 917921,
 -50135,
 1009194590,
 917920,
 -50134,
 1009259918,
 917919,
 -50133,
 1009325209,
 917918,
 -50132,
 1009390533,
 917917,
 -50131,
 1009455783,
 917916,
 -50130,
 1009521026,
 917915,
 -50129,
 1009586267,
 917914,
 -1,
 1009651538,
 917913,
 1009859643,
 1009063310,
 -1,
 -50126,
 1009784815,
 917912,
 -50125,
 1009850174,
 917911,
 -50124,
 1009915486,
 917910,
 -50123,
 1009980814,
 917909,
 -50122,
 1010046105,
 917908,
 -50121,
 1010111429,
 917907,
 -50120,
 1010176679,
 917906,
 -50119,
 1010241922,
 917905,
 -50118,
 1010307163,
 917904,
 -1,
 1010372434,
 917903,
 1010580550,
 1009783961,
 -1,
 -50115,
 1010505711,
 917902,
 -50114,
 1010571070,
 917901,
 -50113,
 1010636382,
 917900,
 -50112,
 1010701710,
 917899,
 -50111,
 1010767001,
 917898,
 -50110,
 1010832325,
 917897,
 -50109,
 1010897575,
 917896,
 -50108,
 1010962818,
 917895,
 -50107,
 1011028059,
 917894,
 -1,
 1011093330,
 917893,
 1011301457,
 1010504645,
 -1,
 -50104,
 1011226607,
 917892,
 -50103,
 1011291966,
 917891,
 -50102,
 1011357278,
 917890,
 -50101,
 1011422606,
 917889,
 -50100,
 1011487897,
 917888,
 -50099,
 1011553221,
 917887,
 -50098,
 1011618471,
 917886,
 -50097,
 1011683714,
 917885,
 -50096,
 1011748955,
 917884,
 -1,
 1011814226,
 917883,
 1012022364,
 1011225255,
 -1,
 -50093,
 1011947503,
 917882,
 -50092,
 1012012862,
 917881,
 -50091,
 1012078174,
 917880,
 -50090,
 1012143502,
 917879,
 -50089,
 1012208793,
 917878,
 -50088,
 1012274117,
 917877,
 -50087,
 1012339367,
 917876,
 -50086,
 1012404610,
 917875,
 -50085,
 1012469851,
 917874,
 -1,
 1012535122,
 917873,
 1012743271,
 1011945858,
 -1,
 -50082,
 1012668399,
 917872,
 -50081,
 1012733758,
 917871,
 -50080,
 1012799070,
 917870,
 -50079,
 1012864398,
 917869,
 -50078,
 1012929689,
 917868,
 -50077,
 1012995013,
 917867,
 -50076,
 1013060263,
 917866,
 -50075,
 1013125506,
 917865,
 -50074,
 1013190747,
 917864,
 -1,
 1013256018,
 917863,
 1013464178,
 1012666459,
 -1,
 -50071,
 1013389295,
 917862,
 -50070,
 1013454654,
 917861,
 -50069,
 1013519966,
 917860,
 -50068,
 1013585294,
 917859,
 -50067,
 1013650585,
 917858,
 -50066,
 1013715909,
 917857,
 -50065,
 1013781159,
 917856,
 -50064,
 1013846402,
 917855,
 -50063,
 1013911643,
 917854,
 -1,
 1013976914,
 917853,
 1014235135,
 1013387090,
 -1,
 -50060,
 1014110191,
 917852,
 -50059,
 1014175550,
 917851,
 -50058,
 1014240862,
 917850,
 -50057,
 1014306190,
 917849,
 -50056,
 1014371481,
 917848,
 -50055,
 1014436805,
 917847,
 -50054,
 1014502055,
 917846,
 -50053,
 1014567298,
 917845,
 -50052,
 1014632539,
 917844,
 -1,
 1014697810,
 917843,
 1014906049,
 1007554946,
 -1,
 1014971529,
 1014830021,
 917767,
 -50048,
 1014896623,
 917992,
 -50047,
 1014961982,
 917991,
 -50046,
 1015027294,
 917990,
 -50045,
 1015092622,
 917989,
 -50044,
 1015157913,
 917988,
 -50043,
 1015223237,
 917987,
 -50042,
 1015288487,
 917986,
 -50041,
 1015353730,
 917985,
 -50040,
 1015418971,
 917984,
 -1,
 1015484242,
 917983,
 1015692436,
 1014895271,
 917766,
 -50037,
 1015617519,
 917982,
 -50036,
 1015682878,
 917981,
 -50035,
 1015748190,
 917980,
 -50034,
 1015813518,
 917979,
 -50033,
 1015878809,
 917978,
 -50032,
 1015944133,
 917977,
 -50031,
 1016009383,
 917976,
 -50030,
 1016074626,
 917975,
 -50029,
 1016139867,
 917974,
 -1,
 1016205138,
 917973,
 1016413343,
 1015615874,
 917765,
 -50026,
 1016338415,
 917972,
 -50025,
 1016403774,
 917971,
 -50024,
 1016469086,
 917970,
 -50023,
 1016534414,
 917969,
 -50022,
 1016599705,
 917968,
 -50021,
 1016665029,
 917967,
 -50020,
 1016730279,
 917966,
 -50019,
 1016795522,
 917965,
 -50018,
 1016860763,
 917964,
 -1,
 1016926034,
 917963,
 1017134250,
 1016336475,
 917764,
 -50015,
 1017059311,
 917962,
 -50014,
 1017124670,
 917961,
 -50013,
 1017189982,
 917960,
 -50012,
 1017255310,
 917959,
 -50011,
 1017320601,
 917958,
 -50010,
 1017385925,
 917957,
 -50009,
 1017451175,
 917956,
 -50008,
 1017516418,
 917955,
 -50007,
 1017581659,
 917954,
 -1,
 1017646930,
 917953,
 1017855157,
 1017057106,
 917763,
 -50004,
 1017780207,
 917952,
 -50003,
 1017845566,
 917951,
 -50002,
 1017910878,
 917950,
 -50001,
 1017976206,
 917949,
 -50000,
 1018041497,
 917948,
 -49999,
 1018106821,
 917947,
 -49998,
 1018172071,
 917946,
 -49997,
 1018237314,
 917945,
 -49996,
 1018302555,
 917944,
 -1,
 1018367826,
 917943,
 1018576061,
 1017779353,
 917768,
 -49993,
 1018500494,
 917999,
 -49992,
 1018565785,
 917998,
 -49991,
 1018631109,
 917997,
 -49990,
 1018696359,
 917996,
 -49989,
 1018761602,
 917995,
 -49988,
 1018826843,
 917994,
 -1,
 1018892114,
 917993,
 -49986,
 1018501103,
 917772,
 -49985,
 1019025214,
 917771,
 -49984,
 1019090526,
 917770,
 -1,
 1019155854,
 917769,
 1019362508,
 1014831087,
 -1,
 -49981,
 1019287535,
 917842,
 -49980,
 1019352894,
 917841,
 -49979,
 1019418206,
 917840,
 -49978,
 1019483534,
 917839,
 -49977,
 1019548825,
 917838,
 -49976,
 1019614149,
 917837,
 -49975,
 1019679399,
 917836,
 -49974,
 1019744642,
 917835,
 -49973,
 1019809883,
 917834,
 -1,
 1019875154,
 917833,
 1020083415,
 1019287358,
 -1,
 -49970,
 1020008431,
 917832,
 -49969,
 1020073790,
 917831,
 -49968,
 1020139102,
 917830,
 -49967,
 1020204430,
 917829,
 -49966,
 1020269721,
 917828,
 -49965,
 1020335045,
 917827,
 -49964,
 1020400295,
 917826,
 -49963,
 1020465538,
 917825,
 -49962,
 1020530779,
 917824,
 -1,
 1020596050,
 917823,
 1020804322,
 1020008030,
 -1,
 -49959,
 1020729327,
 917822,
 -49958,
 1020794686,
 917821,
 -49957,
 1020859998,
 917820,
 -49956,
 1020925326,
 917819,
 -49955,
 1020990617,
 917818,
 -49954,
 1021055941,
 917817,
 -49953,
 1021121191,
 917816,
 -49952,
 1021186434,
 917815,
 -49951,
 1021251675,
 917814,
 -1,
 1021316946,
 917813,
 1021525229,
 1020728718,
 -1,
 -49948,
 1021450223,
 917812,
 -49947,
 1021515582,
 917811,
 -49946,
 1021580894,
 917810,
 -49945,
 1021646222,
 917809,
 -49944,
 1021711513,
 917808,
 -49943,
 1021776837,
 917807,
 -49942,
 1021842087,
 917806,
 -49941,
 1021907330,
 917805,
 -49940,
 1021972571,
 917804,
 -1,
 1022037842,
 917803,
 1022246136,
 1021449369,
 -1,
 -49937,
 1022171119,
 917802,
 -49936,
 1022236478,
 917801,
 -49935,
 1022301790,
 917800,
 -49934,
 1022367118,
 917799,
 -49933,
 1022432409,
 917798,
 -49932,
 1022497733,
 917797,
 -49931,
 1022562983,
 917796,
 -49930,
 1022628226,
 917795,
 -49929,
 1022693467,
 917794,
 -1,
 1022758738,
 917793,
 1022967043,
 1022170053,
 -1,
 -49926,
 1022892015,
 917792,
 -49925,
 1022957374,
 917791,
 -49924,
 1023022686,
 917790,
 -49923,
 1023088014,
 917789,
 -49922,
 1023153305,
 917788,
 -49921,
 1023218629,
 917787,
 -49920,
 1023283879,
 917786,
 -49919,
 1023349122,
 917785,
 -49918,
 1023414363,
 917784,
 -1,
 1023479634,
 917783,
 1023737855,
 1022890663,
 -1,
 -49915,
 1023612911,
 917782,
 -49914,
 1023678270,
 917781,
 -49913,
 1023743582,
 917780,
 -49912,
 1023808910,
 917779,
 -49911,
 1023874201,
 917778,
 -49910,
 1023939525,
 917777,
 -49909,
 1024004775,
 917776,
 -49908,
 1024070018,
 917775,
 -49907,
 1024135259,
 917774,
 -1,
 1024200530,
 917773,
 1024409103,
 984721573,
 -1,
 1024474494,
 1024331867,
 983237,
 1024539931,
 1024399343,
 983261,
 -49902,
 1024464879,
 983441,
 -49901,
 1024530238,
 983440,
 -49900,
 1024595550,
 983439,
 -49899,
 1024660878,
 983438,
 -49898,
 1024726169,
 983437,
 -49897,
 1024791493,
 983436,
 -49896,
 1024856743,
 983435,
 -49895,
 1024921986,
 983434,
 -49894,
 1024987227,
 983433,
 -1,
 1025052498,
 983432,
 1025260838,
 1024464702,
 983260,
 -49891,
 1025185775,
 983431,
 -49890,
 1025251134,
 983430,
 -49889,
 1025316446,
 983429,
 -49888,
 1025381774,
 983428,
 -49887,
 1025447065,
 983427,
 -49886,
 1025512389,
 983426,
 -49885,
 1025577639,
 983425,
 -49884,
 1025642882,
 983424,
 -49883,
 1025708123,
 983423,
 -1,
 1025773394,
 983422,
 1025981745,
 1025185374,
 983259,
 -49880,
 1025906671,
 983421,
 -49879,
 1025972030,
 983420,
 -49878,
 1026037342,
 983419,
 -49877,
 1026102670,
 983418,
 -49876,
 1026167961,
 983417,
 -49875,
 1026233285,
 983416,
 -49874,
 1026298535,
 983415,
 -49873,
 1026363778,
 983414,
 -49872,
 1026429019,
 983413,
 -1,
 1026494290,
 983412,
 1026702652,
 1025906062,
 983252,
 -49869,
 1026627567,
 983411,
 -49868,
 1026692926,
 983410,
 -49867,
 1026758238,
 983409,
 -49866,
 1026823566,
 983408,
 -49865,
 1026888857,
 983407,
 -49864,
 1026954181,
 983406,
 -49863,
 1027019431,
 983405,
 -49862,
 1027084674,
 983404,
 -49861,
 1027149915,
 983403,
 -1,
 1027215186,
 983402,
 1027423559,
 1026626713,
 983251,
 -49858,
 1027348463,
 983401,
 -49857,
 1027413822,
 983400,
 -49856,
 1027479134,
 983399,
 -49855,
 1027544462,
 983398,
 -49854,
 1027609753,
 983397,
 -49853,
 1027675077,
 983396,
 -49852,
 1027740327,
 983395,
 -49851,
 1027805570,
 983394,
 -49850,
 1027870811,
 983393,
 -1,
 1027936082,
 983392,
 1028144466,
 1027347397,
 983250,
 -49847,
 1028069359,
 983391,
 -49846,
 1028134718,
 983390,
 -49845,
 1028200030,
 983389,
 -49844,
 1028265358,
 983388,
 -49843,
 1028330649,
 983387,
 -49842,
 1028395973,
 983386,
 -49841,
 1028461223,
 983385,
 -49840,
 1028526466,
 983384,
 -49839,
 1028591707,
 983383,
 -1,
 1028656978,
 983382,
 1028865373,
 1028068007,
 983249,
 -49836,
 1028790255,
 983381,
 -49835,
 1028855614,
 983380,
 -49834,
 1028920926,
 983379,
 -49833,
 1028986254,
 983378,
 -49832,
 1029051545,
 983377,
 -49831,
 1029116869,
 983376,
 -49830,
 1029182119,
 983375,
 -49829,
 1029247362,
 983374,
 -49828,
 1029312603,
 983373,
 -1,
 1029377874,
 983372,
 1029586280,
 1028788610,
 983248,
 -49825,
 1029511151,
 983371,
 -49824,
 1029576510,
 983370,
 -49823,
 1029641822,
 983369,
 -49822,
 1029707150,
 983368,
 -49821,
 1029772441,
 983367,
 -49820,
 1029837765,
 983366,
 -49819,
 1029903015,
 983365,
 -49818,
 1029968258,
 983364,
 -49817,
 1030033499,
 983363,
 -1,
 1030098770,
 983362,
 1030307187,
 1029509211,
 983247,
 -49814,
 1030232047,
 983361,
 -49813,
 1030297406,
 983360,
 -49812,
 1030362718,
 983359,
 -49811,
 1030428046,
 983358,
 -49810,
 1030493337,
 983357,
 -49809,
 1030558661,
 983356,
 -49808,
 1030623911,
 983355,
 -49807,
 1030689154,
 983354,
 -49806,
 1030754395,
 983353,
 -1,
 1030819666,
 983352,
 1031077887,
 1030229842,
 983246,
 -49803,
 1030952943,
 983351,
 -49802,
 1031018302,
 983350,
 -49801,
 1031083614,
 983349,
 -49800,
 1031148942,
 983348,
 -49799,
 1031214233,
 983347,
 -49798,
 1031279557,
 983346,
 -49797,
 1031344807,
 983345,
 -49796,
 1031410050,
 983344,
 -49795,
 1031475291,
 983343,
 -1,
 1031540562,
 983342,
 1031749058,
 1024397698,
 983238,
 1031814538,
 1031672773,
 983266,
 -49791,
 1031739375,
 983491,
 -49790,
 1031804734,
 983490,
 -49789,
 1031870046,
 983489,
 -49788,
 1031935374,
 983488,
 -49787,
 1032000665,
 983487,
 -49786,
 1032065989,
 983486,
 -49785,
 1032131239,
 983485,
 -49784,
 1032196482,
 983484,
 -49783,
 1032261723,
 983483,
 -1,
 1032326994,
 983482,
 1032535445,
 1031738023,
 983265,
 -49780,
 1032460271,
 983481,
 -49779,
 1032525630,
 983480,
 -49778,
 1032590942,
 983479,
 -49777,
 1032656270,
 983478,
 -49776,
 1032721561,
 983477,
 -49775,
 1032786885,
 983476,
 -49774,
 1032852135,
 983475,
 -49773,
 1032917378,
 983474,
 -49772,
 1032982619,
 983473,
 -1,
 1033047890,
 983472,
 1033256352,
 1032458626,
 983264,
 -49769,
 1033181167,
 983471,
 -49768,
 1033246526,
 983470,
 -49767,
 1033311838,
 983469,
 -49766,
 1033377166,
 983468,
 -49765,
 1033442457,
 983467,
 -49764,
 1033507781,
 983466,
 -49763,
 1033573031,
 983465,
 -49762,
 1033638274,
 983464,
 -49761,
 1033703515,
 983463,
 -1,
 1033768786,
 983462,
 1033977259,
 1033179227,
 983263,
 -49758,
 1033902063,
 983461,
 -49757,
 1033967422,
 983460,
 -49756,
 1034032734,
 983459,
 -49755,
 1034098062,
 983458,
 -49754,
 1034163353,
 983457,
 -49753,
 1034228677,
 983456,
 -49752,
 1034293927,
 983455,
 -49751,
 1034359170,
 983454,
 -49750,
 1034424411,
 983453,
 -1,
 1034489682,
 983452,
 1034698166,
 1033899858,
 983262,
 -49747,
 1034622959,
 983451,
 -49746,
 1034688318,
 983450,
 -49745,
 1034753630,
 983449,
 -49744,
 1034818958,
 983448,
 -49743,
 1034884249,
 983447,
 -49742,
 1034949573,
 983446,
 -49741,
 1035014823,
 983445,
 -49740,
 1035080066,
 983444,
 -49739,
 1035145307,
 983443,
 -1,
 1035210578,
 983442,
 1035419070,
 1034622105,
 983267,
 -49736,
 1035343246,
 983498,
 -49735,
 1035408537,
 983497,
 -49734,
 1035473861,
 983496,
 -49733,
 1035539111,
 983495,
 -49732,
 1035604354,
 983494,
 -49731,
 1035669595,
 983493,
 -1,
 1035734866,
 983492,
 -49729,
 1035343855,
 983271,
 -49728,
 1035867966,
 983270,
 -49727,
 1035933278,
 983269,
 -1,
 1035998606,
 983268,
 1036205517,
 1031673839,
 983245,
 -49724,
 1036130287,
 983341,
 -49723,
 1036195646,
 983340,
 -49722,
 1036260958,
 983339,
 -49721,
 1036326286,
 983338,
 -49720,
 1036391577,
 983337,
 -49719,
 1036456901,
 983336,
 -49718,
 1036522151,
 983335,
 -49717,
 1036587394,
 983334,
 -49716,
 1036652635,
 983333,
 -1,
 1036717906,
 983332,
 1036926424,
 1036130110,
 983244,
 -49713,
 1036851183,
 983331,
 -49712,
 1036916542,
 983330,
 -49711,
 1036981854,
 983329,
 -49710,
 1037047182,
 983328,
 -49709,
 1037112473,
 983327,
 -49708,
 1037177797,
 983326,
 -49707,
 1037243047,
 983325,
 -49706,
 1037308290,
 983324,
 -49705,
 1037373531,
 983323,
 -1,
 1037438802,
 983322,
 1037647331,
 1036850782,
 983243,
 -49702,
 1037572079,
 983321,
 -49701,
 1037637438,
 983320,
 -49700,
 1037702750,
 983319,
 -49699,
 1037768078,
 983318,
 -49698,
 1037833369,
 983317,
 -49697,
 1037898693,
 983316,
 -49696,
 1037963943,
 983315,
 -49695,
 1038029186,
 983314,
 -49694,
 1038094427,
 983313,
 -1,
 1038159698,
 983312,
 1038368238,
 1037571470,
 983242,
 -49691,
 1038292975,
 983311,
 -49690,
 1038358334,
 983310,
 -49689,
 1038423646,
 983309,
 -49688,
 1038488974,
 983308,
 -49687,
 1038554265,
 983307,
 -49686,
 1038619589,
 983306,
 -49685,
 1038684839,
 983305,
 -49684,
 1038750082,
 983304,
 -49683,
 1038815323,
 983303,
 -1,
 1038880594,
 983302,
 1039089145,
 1038292121,
 983241,
 -49680,
 1039013871,
 983301,
 -49679,
 1039079230,
 983300,
 -49678,
 1039144542,
 983299,
 -49677,
 1039209870,
 983298,
 -49676,
 1039275161,
 983297,
 -49675,
 1039340485,
 983296,
 -49674,
 1039405735,
 983295,
 -49673,
 1039470978,
 983294,
 -49672,
 1039536219,
 983293,
 -1,
 1039601490,
 983292,
 1039810052,
 1039012805,
 983240,
 -49669,
 1039734767,
 983291,
 -49668,
 1039800126,
 983290,
 -49667,
 1039865438,
 983289,
 -49666,
 1039930766,
 983288,
 -49665,
 1039996057,
 983287,
 -49664,
 1040061381,
 983286,
 -49663,
 1040126631,
 983285,
 -49662,
 1040191874,
 983284,
 -49661,
 1040257115,
 983283,
 -1,
 1040322386,
 983282,
 1040580607,
 1039733415,
 983239,
 -49658,
 1040455663,
 983281,
 -49657,
 1040521022,
 983280,
 -49656,
 1040586334,
 983279,
 -49655,
 1040651662,
 983278,
 -49654,
 1040716953,
 983277,
 -49653,
 1040782277,
 983276,
 -49652,
 1040847527,
 983275,
 -49651,
 1040912770,
 983274,
 -49650,
 1040978011,
 983273,
 -1,
 1041043282,
 983272,
 1041251943,
 1024343214,
 -1,
 1041317448,
 1041184647,
 -1,
 1041382957,
 1041280374,
 -1,
 1041448474,
 1041307814,
 -1,
 1041514009,
 1041401158,
 -1,
 1041579542,
 1041483458,
 7403,
 -1,
 1041501601,
 7404,
 -49641,
 1041547277,
 7409,
 -49640,
 1041638795,
 7402,
 -1,
 1041702919,
 7401,
 -1,
 1041473312,
 7410,
 1041972768,
 1041418649,
 -1,
 1042038301,
 1041940773,
 7395,
 -1,
 1041960353,
 7399,
 1042169375,
 1041965097,
 7397,
 -1,
 1042091425,
 7400,
 -1,
 1042133986,
 7394,
 1042365990,
 1041931343,
 -1,
 1042431524,
 1042302607,
 -1,
 -49629,
 1042399525,
 7396,
 -1,
 1042423849,
 7398,
 -49627,
 1042397056,
 7408,
 -1,
 1042583108,
 7411,
 -49625,
 1042338558,
 7380,
 -49624,
 1042727993,
 7414,
 -49623,
 1042790999,
 7405,
 -49622,
 1042842177,
 7379,
 -49621,
 1042904280,
 7407,
 -49620,
 1042966423,
 7413,
 -1,
 1043027294,
 7406,
 1043267583,
 1041349315,
 -1,
 1043283507,
 1043190514,
 -1,
 1043349041,
 1043228983,
 7383,
 -1,
 1043269803,
 7385,
 -49614,
 1043291946,
 7382,
 -1,
 1043405826,
 7381,
 1043611191,
 1043248261,
 -1,
 -49611,
 1043582971,
 7390,
 -49610,
 1043637598,
 7387,
 -1,
 1043683607,
 7391,
 1043873340,
 1043544173,
 -1,
 1043938875,
 1043841089,
 -1,
 -49606,
 1043903458,
 7386,
 -1,
 1043965087,
 7417,
 -1,
 1043903645,
 7389,
 1044201023,
 1043833311,
 -1,
 -49602,
 1044152730,
 7416,
 -1,
 1044205995,
 7392,
 1044397634,
 1044146287,
 -1,
 -49599,
 1044363103,
 7388,
 -1,
 1044424629,
 7376,
 1044594245,
 1044327227,
 -1,
 -49596,
 1044522722,
 7384,
 -1,
 1044584933,
 7412,
 -49594,
 1044556767,
 7377,
 -49593,
 1044748630,
 7378,
 -1,
 1044783990,
 7393,
 1044987494,
 1041275983,
 -1,
 1045053017,
 1044959876,
 -1,
 1045118552,
 1044993171,
 -1,
 1045184079,
 1045080229,
 -1,
 -49587,
 1045137550,
 128636,
 -49586,
 1045194382,
 128953,
 -1,
 1045241433,
 128941,
 1045446226,
 1045155077,
 -1,
 -49583,
 1045410010,
 128914,
 -1,
 1045442133,
 128904,
 1045642837,
 1045381236,
 -1,
 -49580,
 1045606602,
 128959,
 -1,
 1045665748,
 128976,
 -49578,
 1045602639,
 128637,
 -49577,
 1045778750,
 128934,
 -1,
 1045842448,
 128947,
 -1,
 1045047550,
 128933,
 1046151167,
 1045018878,
 -1,
 1046167137,
 1046066309,
 -1,
 1046232671,
 1046092150,
 -1,
 1046298206,
 1046200806,
 983069,
 -1,
 1046218942,
 983143,
 -1,
 1046217693,
 11135,
 -49568,
 1046191366,
 128678,
 -1,
 1046437403,
 11823,
 -49566,
 1046130243,
 11837,
 -49565,
 1046575118,
 9896,
 -49564,
 1046639423,
 9168,
 -49563,
 1046694795,
 8286,
 -1,
 1046750688,
 10186,
 -1,
 1044951464,
 9910,
 1047019119,
 1041193539,
 -1,
 1047084653,
 1046951545,
 -1,
 1047150188,
 1047003136,
 -1,
 -49557,
 1047088594,
 127918,
 -1,
 1047145241,
 128249,
 -1,
 1047079897,
 128252,
 -49554,
 1047038101,
 127931,
 -1,
 1047341476,
 128243,
 1047543413,
 1046987246,
 -1,
 1047608948,
 1047497148,
 -1,
 -49550,
 1047574246,
 8530,
 -49549,
 1047636750,
 8528,
 -1,
 1047691953,
 8529,
 -1,
 1047582127,
 8585,
 1047936631,
 1047508101,
 983070,
 -1,
 1047898277,
 983144,
 1048117247,
 1047889954,
 -1,
 -49543,
 1048015359,
 127952,
 -1,
 1048062835,
 127755,
 1048265118,
 984650534,
 -1,
 1048330217,
 1048189094,
 -1,
 1048395573,
 1048269863,
 -1,
 1048460978,
 1048324761,
 -1,
 1048526487,
 1048414946,
 -1,
 1048592007,
 1048477498,
 -1,
 1048657539,
 1048556677,
 -1,
 -49534,
 1048619495,
 92957,
 -1,
 1048663071,
 92971,
 -49532,
 1048604122,
 92960,
 -49531,
 1048799571,
 92962,
 -49530,
 1048849735,
 92968,
 -1,
 1048912952,
 92972,
 1049116299,
 1048531448,
 -1,
 -49527,
 1049067517,
 92969,
 -49526,
 1049128410,
 92965,
 -1,
 1049175096,
 92959,
 1049378446,
 1049045657,
 -1,
 -49523,
 1049318431,
 92967,
 -1,
 1049371704,
 92975,
 -49521,
 1049350979,
 92964,
 -49520,
 1049547219,
 92974,
 -49519,
 1049610103,
 92956,
 -49518,
 1049665167,
 92961,
 -49517,
 1049729769,
 92963,
 -49516,
 1049794323,
 92970,
 -49515,
 1049852322,
 92966,
 -49514,
 1049914842,
 92958,
 -1,
 1049961528,
 92973,
 1050214399,
 1048472765,
 -1,
 1050230430,
 1050129541,
 -1,
 1050295965,
 1050192037,
 -1,
 -49509,
 1050266697,
 93069,
 -49508,
 1050301643,
 93053,
 -1,
 1050351990,
 93062,
 -1,
 1050236758,
 93061,
 1050623650,
 1050175517,
 -1,
 -49504,
 1050595195,
 93070,
 -49503,
 1050643200,
 93058,
 -1,
 1050694191,
 93064,
 1050885797,
 1050595970,
 -1,
 -49500,
 1050820438,
 93054,
 -1,
 1050877187,
 93068,
 1051082408,
 1050855069,
 -1,
 -49497,
 1051053944,
 93071,
 -1,
 1051073795,
 93066,
 1051279019,
 1051028399,
 -1,
 -49494,
 1051223154,
 93055,
 -1,
 1051272282,
 93056,
 1051475630,
 1051218446,
 -1,
 -49491,
 1051447160,
 93059,
 -1,
 1051490060,
 93065,
 -49489,
 1051447932,
 93057,
 -49488,
 1051629115,
 93063,
 -49487,
 1051688554,
 93060,
 -1,
 1051740237,
 93067,
 1051934437,
 1048423798,
 -1,
 1051999934,
 1051864650,
 -1,
 1052065464,
 1051964549,
 -1,
 1052130999,
 1052037752,
 93044,
 -1,
 1052049925,
 93045,
 -1,
 1052094556,
 92997,
 1052327611,
 1051994777,
 -1,
 -49478,
 1052295130,
 93043,
 -1,
 1052333288,
 92985,
 -49476,
 1052285431,
 93046,
 -49475,
 1052476377,
 93047,
 -1,
 1052529241,
 93042,
 1052720840,
 1051971998,
 -1,
 1052786374,
 1052693122,
 -1,
 1052851909,
 1052721028,
 -1,
 -49470,
 1052818289,
 92990,
 -49469,
 1052877252,
 92989,
 -49468,
 1052935380,
 92988,
 -1,
 1052985416,
 92991,
 -1,
 1052805888,
 93028,
 -49465,
 1052727999,
 93034,
 -1,
 1053172855,
 92996,
 1053376210,
 1052691034,
 -1,
 1053441742,
 1053340805,
 -1,
 1053507277,
 1053381112,
 -1,
 -49460,
 1053460672,
 92983,
 -1,
 1053514431,
 92986,
 -1,
 1053469542,
 92984,
 -49457,
 1053403769,
 92992,
 -49456,
 1053721570,
 92994,
 -49455,
 1053783748,
 93027,
 -1,
 1053837487,
 92987,
 1054031574,
 1053340805,
 -1,
 -49452,
 1054003748,
 93037,
 -49451,
 1054037669,
 93030,
 -1,
 1054090296,
 93039,
 1054293723,
 1053980428,
 -1,
 1054359258,
 1054228314,
 -1,
 -49447,
 1054326058,
 93038,
 -1,
 1054389102,
 92993,
 -1,
 1054328287,
 93041,
 1054621406,
 1054244666,
 -1,
 -49443,
 1054588316,
 93035,
 -1,
 1054644974,
 93033,
 1054818017,
 1054560760,
 -1,
 -49440,
 1054770397,
 93032,
 -1,
 1054831165,
 93029,
 -49438,
 1054791215,
 93031,
 -49437,
 1054962981,
 93040,
 -49436,
 1055021930,
 92995,
 -1,
 1055073421,
 93036,
 1055276816,
 1051904624,
 -1,
 1055342325,
 1055201446,
 -1,
 1055407850,
 1055312654,
 -1,
 -49431,
 1055377053,
 92943,
 -1,
 1055401252,
 92942,
 1055604461,
 1055375131,
 -1,
 -49428,
 1055573661,
 92933,
 -1,
 1055597860,
 92932,
 1055801072,
 1055545923,
 -1,
 -49425,
 1055770269,
 92939,
 -1,
 1055794468,
 92938,
 1055997683,
 1055725734,
 -1,
 -49422,
 1055966877,
 92955,
 -1,
 1055991076,
 92954,
 -49420,
 1055966877,
 92951,
 -1,
 1056122148,
 92950,
 1056325371,
 1055309595,
 -1,
 1056390905,
 1056250022,
 -1,
 -49416,
 1056360093,
 92945,
 -1,
 1056384292,
 92944,
 -49414,
 1056360093,
 92935,
 -1,
 1056515364,
 92934,
 1056718593,
 1056277950,
 -1,
 1056784127,
 1056671166,
 -1,
 -49410,
 1056753309,
 92941,
 -1,
 1056777508,
 92940,
 -49408,
 1056753309,
 92947,
 -1,
 1056908580,
 92946,
 1057111815,
 1056660035,
 -1,
 1057177349,
 1057036454,
 -1,
 -49404,
 1057146525,
 92949,
 -1,
 1057170724,
 92948,
 -49402,
 1057146525,
 92931,
 -1,
 1057301796,
 92930,
 1057505037,
 1057045678,
 -1,
 1057570571,
 1057438894,
 -1,
 -49398,
 1057539741,
 92929,
 -1,
 1057563940,
 92928,
 -49396,
 1057539741,
 92937,
 -1,
 1057695012,
 92936,
 1057947647,
 1057475342,
 -1,
 -49393,
 1057867421,
 92953,
 -1,
 1057891620,
 92952,
 1058094878,
 1055209370,
 -1,
 1058160404,
 1058059397,
 -1,
 -49389,
 1058131915,
 93010,
 -1,
 1058167003,
 93011,
 1058357015,
 1058121893,
 -1,
 -49386,
 1058301559,
 93014,
 -1,
 1058358766,
 93015,
 1058553626,
 1058293710,
 -1,
 -49383,
 1058508648,
 93012,
 -1,
 1058563539,
 93013,
 -49381,
 1058526590,
 93008,
 -49380,
 1058703800,
 93009,
 -49379,
 1058767451,
 93017,
 -1,
 1058816110,
 93016,
 1059012394,
 1058047225,
 -1,
 1059077926,
 1058976901,
 -1,
 1059143461,
 1059013002,
 -1,
 1059208996,
 1059061760,
 -1,
 -49373,
 1059174430,
 93021,
 -1,
 1059203045,
 93024,
 -1,
 1059170469,
 93019,
 -1,
 1059103874,
 93025,
 1059536681,
 1059019228,
 -1,
 -49368,
 1059498149,
 93020,
 -1,
 1059521688,
 93023,
 -1,
 1059486876,
 93022,
 1059848191,
 1058961709,
 -1,
 1059864366,
 1059763333,
 -1,
 -49363,
 1059831810,
 92976,
 -1,
 1059857515,
 92982,
 1060060977,
 1059825829,
 -1,
 -49360,
 1060028374,
 92980,
 -1,
 1060079038,
 92977,
 1060257588,
 1060005917,
 -1,
 -49357,
 1060197411,
 92979,
 -1,
 1060258949,
 92978,
 -1,
 1060198271,
 92981,
 1060519806,
 1048362784,
 -1,
 1060585321,
 1060465583,
 -1,
 1060650852,
 1060521263,
 -1,
 1060716356,
 1060587470,
 -1,
 1060781891,
 1060658960,
 -1,
 1060847420,
 1060732730,
 72416,
 -1,
 1060785428,
 72419,
 -49347,
 1060819586,
 72420,
 -49346,
 1060948750,
 72418,
 -49345,
 1061008517,
 72414,
 -49344,
 1061065510,
 72412,
 -49343,
 1061123852,
 72415,
 -49342,
 1061186479,
 72417,
 -1,
 1061251101,
 72413,
 -1,
 1060706470,
 72403,
 1061502790,
 1060683547,
 72409,
 -1,
 1061427366,
 72410,
 1061633865,
 1061467269,
 -1,
 -49336,
 1061573134,
 72399,
 -1,
 1061623974,
 72398,
 1061830476,
 1061589798,
 -1,
 -49333,
 1061769742,
 72401,
 -1,
 1061820582,
 72384,
 1062027087,
 1061781306,
 -1,
 -49330,
 1061965155,
 72391,
 -1,
 1062017190,
 72400,
 1062223698,
 1061971997,
 -1,
 -49327,
 1062162958,
 72394,
 -1,
 1062213798,
 72385,
 1062420308,
 1062165059,
 72407,
 -1,
 1062344870,
 72411,
 1062551383,
 1062349465,
 -1,
 -49322,
 1062490638,
 72404,
 -1,
 1062541478,
 72397,
 -49320,
 1062524117,
 72389,
 -49319,
 1062717107,
 72390,
 -49318,
 1062775088,
 72395,
 -49317,
 1062837443,
 72402,
 -49316,
 1062897086,
 72408,
 -49315,
 1062958946,
 72387,
 -49314,
 1063021533,
 72386,
 -49313,
 1063080462,
 72392,
 -49312,
 1063144803,
 72393,
 -49311,
 1063206062,
 72406,
 -49310,
 1063269702,
 72388,
 -49309,
 1063331161,
 72396,
 -1,
 1063393446,
 72405,
 1063649279,
 1060606604,
 72436,
 1063714815,
 1063518208,
 -1,
 1063731048,
 1063613645,
 72435,
 -1,
 1063650031,
 72438,
 -1,
 1063668040,
 72439,
 1063927665,
 1060546993,
 -1,
 1063993199,
 1063893694,
 72428,
 1064108031,
 1063911424,
 -1,
 1064124270,
 1064006861,
 72427,
 -1,
 1064043247,
 72429,
 -1,
 1064061256,
 72430,
 1064370175,
 1063931994,
 72423,
 -1,
 1064239855,
 72426,
 1064451958,
 1063888274,
 72422,
 1064566783,
 1064370176,
 -1,
 1064583029,
 1064465613,
 72421,
 -1,
 1064501999,
 72424,
 -1,
 1064520008,
 72425,
 1064779642,
 1064401841,
 72431,
 1064894463,
 1064697856,
 -1,
 -49287,
 1064793318,
 72433,
 -1,
 1064847688,
 72434,
 1065091071,
 1064718426,
 72437,
 1065156607,
 1064960000,
 -1,
 -49283,
 1065076446,
 72432,
 -1,
 1065109832,
 72440,
 1065303975,
 1060478031,
 -1,
 1065369502,
 1065239242,
 -1,
 1065435035,
 1065315726,
 -1,
 -49278,
 1065407685,
 127273,
 -49277,
 1065472642,
 127272,
 -49276,
 1065537950,
 127271,
 -49275,
 1065601806,
 127270,
 -49274,
 1065666205,
 127269,
 -49273,
 1065729819,
 127268,
 -49272,
 1065792645,
 127267,
 -49271,
 1065855141,
 127266,
 -49270,
 1065917519,
 127265,
 -49269,
 1065982632,
 127264,
 -49268,
 1066046246,
 127263,
 -49267,
 1066108350,
 127262,
 -49266,
 1066172218,
 127261,
 -49265,
 1066235660,
 127260,
 -49264,
 1066298287,
 127259,
 -49263,
 1066362909,
 127258,
 -49262,
 1066428150,
 127257,
 -49261,
 1066490435,
 127256,
 -49260,
 1066553848,
 127255,
 -49259,
 1066618132,
 127254,
 -49258,
 1066682318,
 127253,
 -49257,
 1066745006,
 127252,
 -49256,
 1066808504,
 127251,
 -49255,
 1066871449,
 127250,
 -49254,
 1066935588,
 127249,
 -1,
 1066997926,
 127248,
 1067253759,
 1065380621,
 -1,
 -49251,
 1067149175,
 12829,
 -1,
 1067189085,
 12830,
 1067401126,
 1065333893,
 -1,
 1067466660,
 1067342560,
 -1,
 -49247,
 1067434834,
 983149,
 -49246,
 1067469616,
 983145,
 -49245,
 1067530934,
 983146,
 -1,
 1067591030,
 983148,
 -49243,
 1067438755,
 127881,
 -1,
 1067745586,
 12880,
 -1,
 1067326519,
 11791,
 1067991000,
 1065249711,
 -1,
 1068056535,
 1067939596,
 -1,
 1068122068,
 1068029093,
 -1,
 1068187592,
 1068068450,
 -1,
 1068253127,
 1068154199,
 -1,
 1068318641,
 1068214437,
 -1,
 1068384176,
 1068243110,
 -1,
 -49233,
 1068333794,
 67695,
 -1,
 1068381955,
 67698,
 -1,
 1068324466,
 67701,
 1068646324,
 1068283013,
 -1,
 -49229,
 1068582159,
 67688,
 -1,
 1068639438,
 67702,
 1068842934,
 1068586046,
 67684,
 -1,
 1068808019,
 67687,
 1068974009,
 1068767398,
 -1,
 -49224,
 1068946386,
 67696,
 -1,
 1068986715,
 67680,
 -49222,
 1068946769,
 67686,
 -49221,
 1069143131,
 67689,
 -49220,
 1069206569,
 67685,
 -49219,
 1069261066,
 67700,
 -49218,
 1069325060,
 67699,
 -49217,
 1069389059,
 67697,
 -49216,
 1069450549,
 67694,
 -49215,
 1069513467,
 67692,
 -49214,
 1069575342,
 67691,
 -49213,
 1069639906,
 67690,
 -49212,
 1069699068,
 67682,
 -49211,
 1069762911,
 67693,
 -49210,
 1069823376,
 67683,
 -1,
 1069885243,
 67681,
 -1,
 1068190935,
 67703,
 1070153683,
 1068139769,
 -1,
 1070219215,
 1070118021,
 -1,
 1070284749,
 1070189326,
 -1,
 -49204,
 1070237118,
 67706,
 -1,
 1070285556,
 67711,
 -49202,
 1070225627,
 67707,
 -1,
 1070416266,
 67710,
 1070612434,
 1070155726,
 -1,
 -49199,
 1070567272,
 67708,
 -1,
 1070622163,
 67709,
 -1,
 1070565816,
 67705,
 -1,
 1070113744,
 67704,
 1070989311,
 1068040192,
 -1,
 -49194,
 1070906326,
 127796,
 -1,
 1070934429,
 11801,
 -1,
 1068002643,
 9908,
 1071202272,
 1067929218,
 128463,
 1071267806,
 1071120384,
 -1,
 1071333341,
 1071238759,
 -1,
 -49188,
 1071302030,
 128195,
 -1,
 1071342603,
 128479,
 -1,
 1071269950,
 128196,
 -49185,
 1071229093,
 128464,
 -1,
 1071553615,
 128223,
 1071726563,
 1071165742,
 -1,
 -49182,
 1071683730,
 128706,
 -1,
 1071727199,
 128755,
 1071923173,
 1071658168,
 983121,
 -1,
 1071855554,
 983120,
 -49178,
 1071893275,
 128062,
 -49177,
 1072010727,
 128206,
 -49176,
 1072070723,
 128060,
 -1,
 1072115560,
 128230,
 1072316570,
 1048269304,
 -1,
 1072382069,
 1072240806,
 -1,
 1072447541,
 1072320855,
 -1,
 1072513065,
 1072394622,
 -1,
 1072578550,
 1072477317,
 -1,
 1072644081,
 1072542853,
 -1,
 -49168,
 1072583182,
 43114,
 -1,
 1072634022,
 43113,
 1072840692,
 1072605349,
 -1,
 -49165,
 1072779790,
 43089,
 -1,
 1072830630,
 43088,
 -49163,
 1072779790,
 43081,
 -1,
 1072961702,
 43080,
 1073168379,
 1072529210,
 -1,
 -49160,
 1073140443,
 43079,
 -49159,
 1073184656,
 43116,
 -49158,
 1073237347,
 43075,
 -1,
 1073289382,
 43083,
 1073496063,
 1073129637,
 -1,
 -49155,
 1073444918,
 43094,
 -49154,
 1073500686,
 43098,
 -1,
 1073551526,
 43099,
 1073758211,
 1073427640,
 -1,
 -49151,
 1073730773,
 43090,
 -49150,
 1073755462,
 43115,
 -1,
 1073813670,
 43082,
 1074020359,
 1073687193,
 -1,
 1074085894,
 1073944742,
 43076,
 -1,
 1074036858,
 43123,
 -1,
 1074024974,
 43077,
 1074282506,
 1073944742,
 43101,
 -49143,
 1074245798,
 43120,
 -1,
 1074296439,
 43117,
 1074479117,
 1074255045,
 -1,
 -49140,
 1074418190,
 43092,
 -1,
 1074469030,
 43093,
 1074675728,
 1074448893,
 -1,
 -49137,
 1074622816,
 43118,
 -1,
 1074672875,
 43119,
 1074872339,
 1074631462,
 -1,
 -49134,
 1074811406,
 43085,
 -1,
 1074862246,
 43084,
 1075068950,
 1074817053,
 -1,
 -49131,
 1075008014,
 43073,
 -1,
 1075058854,
 43072,
 1075265561,
 1075006740,
 -1,
 -49128,
 1075203427,
 43109,
 -1,
 1075255462,
 43074,
 1075462171,
 1075199150,
 43104,
 -1,
 1075395758,
 43110,
 -49124,
 1075434203,
 43095,
 -49123,
 1075564986,
 43107,
 -49122,
 1075628878,
 43091,
 -49121,
 1075691291,
 43103,
 -49120,
 1075748035,
 43096,
 -49119,
 1075813046,
 43106,
 -49118,
 1075873214,
 43105,
 -49117,
 1075935074,
 43087,
 -49116,
 1075997661,
 43097,
 -49115,
 1076061972,
 43078,
 -49114,
 1076124227,
 43102,
 -49113,
 1076187662,
 43100,
 -49112,
 1076250659,
 43108,
 -1,
 1076307289,
 43086,
 1076510769,
 1072474277,
 -1,
 1076576304,
 1076477723,
 -1,
 1076641839,
 1076504606,
 -1,
 -49107,
 1076613851,
 43112,
 -49106,
 1076677454,
 43111,
 -1,
 1076731075,
 43121,
 -1,
 1076598255,
 43122,
 -1,
 1076519253,
 43124,
 1077035060,
 1076459804,
 -1,
 -49101,
 1076996976,
 43126,
 -1,
 1077033603,
 43127,
 -1,
 1076967987,
 43125,
 1077346303,
 1072391426,
 -1,
 1077362753,
 1077226137,
 -1,
 1077428283,
 1077315006,
 -1,
 1077493818,
 1077377450,
 66020,
 -1,
 1077436786,
 66045,
 -1,
 1077442260,
 66022,
 1077690431,
 1077352614,
 -1,
 -49091,
 1077654661,
 66028,
 -49090,
 1077716815,
 66018,
 -1,
 1077778921,
 66003,
 -49088,
 1077638852,
 66012,
 -1,
 1077892682,
 66004,
 1078083657,
 1077323941,
 -1,
 1078149189,
 1078023558,
 -1,
 -49084,
 1078104870,
 66024,
 -1,
 1078149348,
 66011,
 -49082,
 1078115253,
 66042,
 -49081,
 1078294625,
 66043,
 -49080,
 1078358891,
 66021,
 -1,
 1078404302,
 66015,
 1078607952,
 1078011172,
 -1,
 1078673485,
 1078560190,
 -1,
 -49076,
 1078643470,
 66010,
 -1,
 1078692117,
 66017,
 1078870095,
 1078607690,
 66033,
 -1,
 1078810353,
 66023,
 -1,
 1078837771,
 66027,
 1079066710,
 1078563622,
 -1,
 1079132244,
 1079012271,
 -1,
 -49069,
 1079099985,
 66001,
 -1,
 1079123812,
 66034,
 -49067,
 1079066395,
 66000,
 -1,
 1079255200,
 66036,
 1079459930,
 1079030917,
 -1,
 -49064,
 1079427893,
 66032,
 -49063,
 1079466847,
 66008,
 -1,
 1079518221,
 66002,
 1079722078,
 1079398904,
 -1,
 -49060,
 1079676277,
 66025,
 -49059,
 1079729163,
 66026,
 -1,
 1079787821,
 66006,
 1079984225,
 1079692046,
 -1,
 -49056,
 1079937242,
 66005,
 -1,
 1079977142,
 66044,
 1080180836,
 1079942223,
 -1,
 -49053,
 1080135146,
 66037,
 -1,
 1080172128,
 66029,
 1080377447,
 1080129378,
 -1,
 -49050,
 1080343907,
 66014,
 -1,
 1080393643,
 66013,
 1080574058,
 1080324669,
 -1,
 -49047,
 1080522492,
 66038,
 -1,
 1080571064,
 66016,
 1080770669,
 1080511764,
 -1,
 -49044,
 1080729177,
 66041,
 -1,
 1080763503,
 66007,
 1080967280,
 1080703085,
 -1,
 -49041,
 1080936318,
 66031,
 -1,
 1080980446,
 66019,
 -49039,
 1080936827,
 66035,
 -49038,
 1081119458,
 66039,
 -49037,
 1081166532,
 66040,
 -49036,
 1081228745,
 66030,
 -1,
 1081287140,
 66009,
 1081540607,
 1072334559,
 -1,
 1081557136,
 1081438590,
 -1,
 1081622651,
 1081518245,
 -1,
 -49031,
 1081562738,
 67860,
 -49030,
 1081622892,
 67854,
 -1,
 1081678603,
 67857,
 1081884798,
 1081586821,
 -1,
 -49027,
 1081820391,
 67848,
 -1,
 1081877560,
 67861,
 1082081408,
 1081824318,
 67844,
 -1,
 1082045573,
 67847,
 1082212483,
 1082005670,
 -1,
 -49022,
 1082159623,
 67840,
 -1,
 1082220232,
 67855,
 -49020,
 1082184924,
 67846,
 -49019,
 1082381399,
 67849,
 -49018,
 1082444815,
 67845,
 -49017,
 1082500830,
 67859,
 -49016,
 1082563323,
 67858,
 -49015,
 1082627331,
 67856,
 -49014,
 1082688821,
 67853,
 -49013,
 1082751739,
 67852,
 -49012,
 1082813603,
 67851,
 -49011,
 1082878127,
 67850,
 -49010,
 1082936791,
 67842,
 -49009,
 1082996308,
 67843,
 -1,
 1083057963,
 67841,
 1083261081,
 1081509113,
 -1,
 1083326615,
 1083225221,
 -1,
 1083392149,
 1083296526,
 -1,
 -49004,
 1083344318,
 67866,
 -1,
 1083392756,
 67864,
 -49002,
 1083332827,
 67867,
 -1,
 1083523466,
 67863,
 1083768831,
 1083279800,
 67862,
 -1,
 1083638625,
 67865,
 -1,
 1083232547,
 67871,
 1083916551,
 1072262063,
 -1,
 1083982085,
 1083840678,
 -1,
 1084047620,
 1083954141,
 -1,
 1084113091,
 1084011653,
 -1,
 1084178612,
 1084074075,
 -1,
 1084244138,
 1084100699,
 127201,
 -48991,
 1084168175,
 127219,
 -48990,
 1084233534,
 127218,
 -48989,
 1084298846,
 127217,
 -48988,
 1084364174,
 127216,
 -48987,
 1084429465,
 127215,
 -48986,
 1084494789,
 127214,
 -48985,
 1084560039,
 127213,
 -48984,
 1084625282,
 127212,
 -48983,
 1084690523,
 127211,
 -1,
 1084755794,
 127210,
 1084965037,
 1084166530,
 127202,
 -48980,
 1084887131,
 127221,
 -1,
 1084952402,
 127220,
 -48978,
 1084889071,
 127209,
 -48977,
 1085085502,
 127208,
 -48976,
 1085150814,
 127207,
 -48975,
 1085216142,
 127206,
 -48974,
 1085281433,
 127205,
 -48973,
 1085346757,
 127204,
 -1,
 1085412007,
 127203,
 1085620409,
 1084149855,
 -1,
 -48970,
 1085583463,
 127138,
 -48969,
 1085625484,
 127154,
 -48968,
 1085683572,
 127170,
 -1,
 1085747258,
 127186,
 1085948094,
 1085561183,
 -1,
 -48965,
 1085911143,
 127139,
 -48964,
 1085953164,
 127155,
 -48963,
 1086011252,
 127171,
 -1,
 1086074938,
 127187,
 1086324735,
 1085882803,
 -1,
 -48960,
 1086238823,
 127146,
 -48959,
 1086280844,
 127162,
 -48958,
 1086338932,
 127178,
 -1,
 1086402618,
 127194,
 1086603472,
 1084049358,
 -1,
 1086669003,
 1086555582,
 -1,
 1086734538,
 1086637358,
 -1,
 -48953,
 1086697575,
 127140,
 -48952,
 1086739596,
 127156,
 -48951,
 1086797684,
 127172,
 -1,
 1086861370,
 127188,
 -1,
 1086687266,
 127200,
 1087176703,
 1086613024,
 -1,
 -48947,
 1087090791,
 127141,
 -48946,
 1087132812,
 127157,
 -48945,
 1087190900,
 127173,
 -1,
 1087254586,
 127189,
 1087455451,
 1086564517,
 -1,
 1087520982,
 1087399559,
 -1,
 -48941,
 1087484007,
 127142,
 -48940,
 1087526028,
 127158,
 -48939,
 1087584116,
 127174,
 -1,
 1087647802,
 127190,
 1087897599,
 1087456772,
 -1,
 -48936,
 1087811687,
 127143,
 -48935,
 1087853708,
 127159,
 -48934,
 1087911796,
 127175,
 -1,
 1087975482,
 127191,
 1088176358,
 1087399965,
 -1,
 1088241889,
 1088127543,
 -1,
 -48930,
 1088204903,
 127148,
 -48929,
 1088246924,
 127164,
 -48928,
 1088305012,
 127180,
 -1,
 1088368698,
 127196,
 1088618495,
 1088184539,
 -1,
 -48925,
 1088532583,
 127150,
 -48924,
 1088574604,
 127166,
 -48923,
 1088632692,
 127182,
 -1,
 1088696378,
 127198,
 1088897259,
 1088134102,
 -1,
 -48920,
 1088860263,
 127149,
 -48919,
 1088902284,
 127165,
 -48918,
 1088960372,
 127181,
 -1,
 1089024058,
 127197,
 1089224944,
 1088848491,
 -1,
 -48915,
 1089187943,
 127145,
 -48914,
 1089229964,
 127161,
 -48913,
 1089288052,
 127177,
 -1,
 1089351738,
 127193,
 1089552629,
 1089169175,
 -1,
 -48910,
 1089515623,
 127147,
 -48909,
 1089557644,
 127163,
 -48908,
 1089615732,
 127179,
 -1,
 1089679418,
 127195,
 1089880314,
 1089486983,
 -1,
 -48905,
 1089843303,
 127144,
 -48904,
 1089885324,
 127160,
 -48903,
 1089943412,
 127176,
 -1,
 1090007098,
 127192,
 1090207999,
 1089804872,
 -1,
 -48900,
 1090170983,
 127137,
 -48899,
 1090213004,
 127153,
 -48898,
 1090271092,
 127169,
 -1,
 1090334778,
 127185,
 1090535682,
 1090135332,
 -1,
 -48895,
 1090481178,
 127183,
 -1,
 1090525780,
 127136,
 -48893,
 1090506094,
 127199,
 -1,
 1090691072,
 127167,
 -1,
 1083976819,
 128720,
 -48890,
 1083948827,
 983150,
 -1,
 1090860216,
 983147,
 1091060012,
 1083877757,
 -1,
 1091125533,
 1091006846,
 -1,
 1091191054,
 1091086501,
 -1,
 1091256589,
 1091115174,
 -1,
 -48884,
 1091205858,
 68493,
 -1,
 1091254019,
 68495,
 -1,
 1091196530,
 68496,
 1091518736,
 1091130430,
 68484,
 -1,
 1091483475,
 68487,
 -48879,
 1091491153,
 68486,
 -48878,
 1091621979,
 68488,
 -48877,
 1091685431,
 68485,
 -48876,
 1091745302,
 68497,
 -48875,
 1091802371,
 68494,
 -48874,
 1091863861,
 68492,
 -48873,
 1091926783,
 68491,
 -48872,
 1091988654,
 68490,
 -48871,
 1092053218,
 68489,
 -48870,
 1092112380,
 68482,
 -48869,
 1092171152,
 68483,
 -48868,
 1092233019,
 68481,
 -1,
 1092296108,
 68480,
 1092501799,
 1091077369,
 -1,
 1092567332,
 1092465797,
 -1,
 1092632866,
 1092537102,
 -1,
 -48863,
 1092584894,
 68522,
 -1,
 1092633332,
 68526,
 -48861,
 1092573403,
 68523,
 -1,
 1092764042,
 68525,
 1092960550,
 1092520376,
 68521,
 -1,
 1092879201,
 68527,
 -1,
 1092897636,
 68524,
 1093157162,
 1092438960,
 -1,
 -48855,
 1093089438,
 68508,
 -1,
 1093153490,
 68507,
 -48853,
 1093123612,
 68506,
 -1,
 1093315162,
 68505,
 1093484880,
 1091017807,
 -1,
 1093550400,
 1093420201,
 -1,
 1093615923,
 1093509771,
 -1,
 1093681458,
 1093586298,
 -1,
 -48847,
 1093626219,
 65048,
 -1,
 1093676926,
 983236,
 -1,
 1093644513,
 65096,
 1093943606,
 1093562153,
 -1,
 -48843,
 1093913999,
 65047,
 -1,
 1093972193,
 65095,
 1094140217,
 1093884953,
 -1,
 -48840,
 1094077699,
 65042,
 -1,
 1094135998,
 65041,
 1094336828,
 1094070336,
 -1,
 -48837,
 1094286614,
 65040,
 -1,
 1094350015,
 65043,
 -48835,
 1094298263,
 65044,
 -48834,
 1094491133,
 65046,
 -48833,
 1094539255,
 65049,
 -1,
 1094600401,
 65045,
 1094795598,
 1093491267,
 -1,
 1094861130,
 1094764211,
 -1,
 1094926665,
 1094825542,
 -1,
 1094992198,
 1094847979,
 -1,
 -48827,
 1094914434,
 983166,
 -1,
 1094979675,
 983163,
 1095237631,
 1094909952,
 -1,
 -48824,
 1095155293,
 983165,
 -1,
 1095207352,
 983162,
 -1,
 1094857892,
 983192,
 1095499775,
 1094811450,
 -1,
 1095516493,
 1095415537,
 128424,
 -1,
 1095435114,
 128438,
 -1,
 1095445751,
 128120,
 -48817,
 1094748019,
 128711,
 -1,
 1095640325,
 128255,
 1095844205,
 1093418158,
 -1,
 1095909732,
 1095801935,
 -1,
 1095975264,
 1095870629,
 -1,
 1096040799,
 1095928118,
 -1,
 1096106334,
 1095958528,
 -1,
 1096171867,
 1096076897,
 -1,
 1096237401,
 1096099108,
 -1,
 -48808,
 1096185027,
 128113,
 -1,
 1096228333,
 9977,
 -48806,
 1096194259,
 128590,
 -1,
 1096370909,
 128591,
 -48804,
 1096129971,
 128588,
 -48803,
 1096502424,
 128589,
 -1,
 1096558975,
 128583,
 -1,
 1096031562,
 128187,
 -1,
 1095976534,
 128547,
 -48799,
 1095931249,
 10178,
 -48798,
 1096841444,
 9854,
 -48797,
 1096895260,
 127917,
 -1,
 1096943824,
 8524,
 1097154921,
 1095860026,
 -1,
 -48794,
 1097119054,
 9956,
 -48793,
 1097182773,
 128532,
 -48792,
 1097224573,
 128039,
 -1,
 1097270898,
 128390,
 1097482604,
 1097078950,
 -1,
 -48789,
 1097440335,
 127824,
 -1,
 1097477372,
 127825,
 -1,
 1097414362,
 128694,
 1097744772,
 1095796158,
 -1,
 1097810292,
 1097711387,
 -1,
 1097875826,
 1097775630,
 -1,
 -48783,
 1097812006,
 128545,
 -1,
 1097870313,
 128574,
 -48781,
 1097823899,
 127831,
 -1,
 1098001660,
 128093,
 1098203512,
 1097757248,
 -1,
 1098269047,
 1098132409,
 128659,
 -1,
 1098230027,
 128680,
 -1,
 1098221321,
 128110,
 1098465659,
 1098167429,
 -1,
 -48774,
 1098389971,
 128688,
 -1,
 1098450191,
 127858,
 1098662270,
 1098428805,
 -1,
 -48771,
 1098590605,
 128238,
 -1,
 1098653014,
 128239,
 1098858881,
 1098617638,
 -1,
 -48768,
 1098789372,
 127871,
 -1,
 1098842749,
 8297,
 -48766,
 1098819531,
 128254,
 -48765,
 1099007703,
 128041,
 -1,
 1099050883,
 128425,
 1099252113,
 1097685571,
 -1,
 1099317641,
 1099189524,
 128022,
 1099431935,
 1099235328,
 -1,
 -48760,
 1099334547,
 128061,
 -1,
 1099384870,
 128055,
 1099579788,
 1099268248,
 -1,
 -48757,
 1099505792,
 127821,
 -1,
 1099563633,
 127885,
 1099776399,
 1099525039,
 -1,
 -48754,
 1099721647,
 128138,
 -1,
 1099775231,
 128169,
 -48752,
 1099739722,
 128299,
 -1,
 1099902791,
 9935,
 1100104090,
 1099218715,
 -1,
 1100169621,
 1100061775,
 -1,
 -48748,
 1100130868,
 128091,
 -1,
 1100191477,
 128156,
 -48746,
 1100133541,
 128686,
 -48745,
 1100328154,
 128204,
 -48744,
 1100359802,
 128226,
 -48743,
 1100419458,
 983167,
 -1,
 1100484699,
 983164,
 1100693917,
 1100035256,
 -1,
 -48740,
 1100634691,
 983229,
 -1,
 1100695502,
 983220,
 -1,
 1100642060,
 983193,
 1100956653,
 1048217022,
 -1,
 1101022077,
 1100901295,
 -1,
 1101087549,
 1100952760,
 -1,
 1101153082,
 1101004800,
 -1,
 1101218328,
 1101093370,
 -1,
 1101283801,
 1101180725,
 -1,
 1101349315,
 1101216942,
 68809,
 1101414826,
 1101299514,
 68825,
 1101480360,
 1101378693,
 68839,
 -1,
 1101401857,
 68849,
 -48727,
 1101451906,
 68826,
 -1,
 1101539993,
 68805,
 1101742509,
 1101343385,
 68804,
 -48724,
 1101703333,
 68806,
 -1,
 1101746680,
 68841,
 1101939119,
 1101714629,
 68847,
 -1,
 1101899941,
 68848,
 1102070193,
 1101902981,
 68838,
 -1,
 1102041730,
 68840,
 1102201267,
 1102031013,
 68836,
 -1,
 1102173381,
 68837,
 1102332341,
 1102149388,
 68824,
 -1,
 1102287654,
 68833,
 1102463415,
 1102277551,
 68822,
 -1,
 1102434946,
 68823,
 1102594489,
 1102400788,
 68813,
 -1,
 1102566018,
 68814,
 -48710,
 1102562973,
 68846,
 -48709,
 1102683215,
 68834,
 -48708,
 1102746406,
 68832,
 -48707,
 1102800925,
 68819,
 -48706,
 1102866166,
 68818,
 -48705,
 1102926328,
 68815,
 -48704,
 1102989262,
 68812,
 -48703,
 1103051950,
 68811,
 -48702,
 1103115448,
 68807,
 -1,
 1103176996,
 68802,
 1103380936,
 1101273254,
 68800,
 -48699,
 1103331360,
 68808,
 -48698,
 1103395242,
 68803,
 -48697,
 1103456285,
 68820,
 -1,
 1103501478,
 68801,
 1103708620,
 1103347483,
 68842,
 -48694,
 1103675163,
 68843,
 -48693,
 1103734949,
 68850,
 -1,
 1103790825,
 68821,
 1103970767,
 1103660478,
 68827,
 -48690,
 1103922622,
 68828,
 -1,
 1103970122,
 68831,
 1104167378,
 1103931422,
 -1,
 -48687,
 1104134486,
 68845,
 -1,
 1104185052,
 68830,
 1104363989,
 1104118351,
 -1,
 -48684,
 1104331094,
 68844,
 -1,
 1104381660,
 68829,
 1104560599,
 1104304707,
 68816,
 -1,
 1104501315,
 68817,
 -48680,
 1104522404,
 68835,
 -1,
 1104621498,
 68810,
 1104822799,
 1101212569,
 -1,
 1104888313,
 1104755886,
 68745,
 1104953824,
 1104838458,
 68761,
 1105019358,
 1104917637,
 68775,
 -1,
 1104940801,
 68785,
 -48673,
 1104990850,
 68762,
 -1,
 1105078937,
 68741,
 1105281507,
 1104882329,
 68740,
 -48670,
 1105242277,
 68742,
 -1,
 1105285624,
 68777,
 1105478117,
 1105253573,
 68783,
 -1,
 1105438885,
 68784,
 1105609191,
 1105441925,
 68774,
 -1,
 1105580674,
 68776,
 1105740265,
 1105569957,
 68772,
 -1,
 1105712325,
 68773,
 1105871339,
 1105688332,
 68760,
 -1,
 1105826598,
 68769,
 1106002413,
 1105816495,
 68758,
 -1,
 1105973890,
 68759,
 1106133487,
 1105939732,
 68749,
 -1,
 1106104962,
 68750,
 -48656,
 1106101917,
 68782,
 -48655,
 1106222159,
 68770,
 -48654,
 1106285350,
 68768,
 -48653,
 1106339869,
 68755,
 -48652,
 1106405110,
 68754,
 -48651,
 1106465272,
 68751,
 -48650,
 1106528206,
 68748,
 -48649,
 1106590894,
 68747,
 -48648,
 1106654392,
 68743,
 -1,
 1106715940,
 68738,
 1106919934,
 1104812198,
 68736,
 -48645,
 1106870304,
 68744,
 -48644,
 1106934186,
 68739,
 -48643,
 1106995229,
 68756,
 -1,
 1107040422,
 68737,
 1107247618,
 1106886427,
 68778,
 -48640,
 1107214107,
 68779,
 -48639,
 1107273893,
 68786,
 -1,
 1107329769,
 68757,
 1107509765,
 1107199422,
 68763,
 -48636,
 1107461566,
 68764,
 -1,
 1107509066,
 68767,
 1107706376,
 1107470366,
 -1,
 -48633,
 1107673430,
 68781,
 -1,
 1107723996,
 68766,
 1107902987,
 1107657295,
 -1,
 -48630,
 1107870038,
 68780,
 -1,
 1107920604,
 68765,
 1108099597,
 1107843651,
 68752,
 -1,
 1108040259,
 68753,
 -48626,
 1108061348,
 68771,
 -1,
 1108160442,
 68746,
 1108410367,
 1104774393,
 -1,
 1108427284,
 1108314552,
 68858,
 1108541439,
 1108344832,
 -1,
 -48621,
 1108457483,
 68863,
 -1,
 1108498908,
 68862,
 1108689431,
 1108363553,
 -1,
 -48618,
 1108658046,
 68859,
 -1,
 1108692219,
 68861,
 -1,
 1108653753,
 68860,
 1108951693,
 1101174206,
 -1,
 1109017182,
 1108912293,
 -1,
 1109082717,
 1108957970,
 -1,
 1109148244,
 1109044598,
 -1,
 1109213730,
 1109079224,
 -1,
 1109279264,
 1109137574,
 66477,
 1109393407,
 1109219892,
 66508,
 -1,
 1109265904,
 66509,
 -48607,
 1109245723,
 66479,
 -1,
 1109416515,
 66478,
 1109606950,
 1109137574,
 66464,
 1109721087,
 1109574975,
 66504,
 -48603,
 1109611022,
 66506,
 -1,
 1109659120,
 66505,
 1109869098,
 1109570693,
 -1,
 -48600,
 1109835547,
 66476,
 -48599,
 1109873166,
 66480,
 -1,
 1109924006,
 66475,
 1110131246,
 1109829797,
 -1,
 -48596,
 1110092080,
 66498,
 -48595,
 1110135310,
 66497,
 -1,
 1110186150,
 66495,
 1110393394,
 1110079244,
 -1,
 -48592,
 1110359835,
 66488,
 -48591,
 1110399555,
 66487,
 -1,
 1110448294,
 66486,
 1110655542,
 1110320420,
 -1,
 1110721077,
 1110579366,
 66482,
 -1,
 1110658403,
 66510,
 -1,
 1110689424,
 66511,
 1110917689,
 1110626718,
 -1,
 -48584,
 1110879066,
 66507,
 -1,
 1110907046,
 66471,
 1111114300,
 1110886045,
 -1,
 -48581,
 1111054915,
 66491,
 -1,
 1111103654,
 66490,
 1111310911,
 1111071823,
 -1,
 -48578,
 1111277339,
 66493,
 -1,
 1111300262,
 66492,
 1111507522,
 1111260986,
 -1,
 -48575,
 1111473947,
 66485,
 -1,
 1111496870,
 66484,
 1111704133,
 1111451677,
 -1,
 -48572,
 1111670555,
 66468,
 -1,
 1111693478,
 66467,
 1111900744,
 1111647990,
 -1,
 -48569,
 1111841347,
 66474,
 -1,
 1111890086,
 66473,
 1112097355,
 1111837972,
 -1,
 -48566,
 1112063771,
 66470,
 -1,
 1112086694,
 66469,
 -48564,
 1112069333,
 66496,
 -48563,
 1112265435,
 66489,
 -48562,
 1112325915,
 66466,
 -48561,
 1112380284,
 66481,
 -48560,
 1112435677,
 66494,
 -48559,
 1112496707,
 66465,
 -48558,
 1112560142,
 66499,
 -48557,
 1112623139,
 66483,
 -1,
 1112681159,
 66472,
 1112883804,
 1109099769,
 -1,
 1112949338,
 1112847493,
 -1,
 1113014873,
 1112918798,
 -1,
 -48552,
 1112966590,
 66514,
 -1,
 1113015028,
 66516,
 -1,
 1112949130,
 66515,
 -48549,
 1112902072,
 66513,
 -1,
 1113217500,
 66517,
 -1,
 1112854785,
 66512,
 -1,
 1109035429,
 128435,
 1113587711,
 1108966291,
 -1,
 1113604711,
 1113510530,
 -1,
 1113670243,
 1113539471,
 66415,
 -48542,
 1113636635,
 66408,
 -1,
 1113676355,
 66416,
 1113866853,
 1113594022,
 66420,
 -1,
 1113830533,
 66417,
 -48538,
 1113833243,
 66419,
 -1,
 1113958524,
 66407,
 1114129004,
 1113565349,
 -1,
 1114194539,
 1114067448,
 -1,
 -48534,
 1114147608,
 66405,
 -1,
 1114189276,
 66406,
 -1,
 1114136042,
 66401,
 1114456687,
 1114069571,
 66393,
 -48530,
 1114389678,
 66418,
 -1,
 1114445990,
 66421,
 1114653300,
 1114387640,
 -1,
 1114718835,
 1114625221,
 -1,
 -48526,
 1114662181,
 66392,
 -1,
 1114724178,
 66390,
 -1,
 1114670989,
 66387,
 1114980983,
 1114625221,
 -1,
 -48522,
 1114920786,
 66389,
 -1,
 1114972965,
 66391,
 1115177594,
 1114949277,
 -1,
 -48519,
 1115130648,
 66398,
 -1,
 1115177871,
 66414,
 1115374205,
 1115141253,
 -1,
 -48516,
 1115336241,
 66413,
 -1,
 1115364448,
 66402,
 1115570815,
 1115325886,
 66409,
 -1,
 1115522494,
 66410,
 1115701889,
 1115503790,
 66388,
 -1,
 1115637710,
 66411,
 -48510,
 1115668251,
 66403,
 -48509,
 1115791503,
 66400,
 -48508,
 1115854137,
 66399,
 -48507,
 1115914518,
 66397,
 -48506,
 1115978539,
 66396,
 -48505,
 1116041504,
 66395,
 -48504,
 1116105441,
 66394,
 -48503,
 1116164622,
 66412,
 -48502,
 1116229054,
 66386,
 -48501,
 1116286361,
 66404,
 -48500,
 1116351052,
 66385,
 -1,
 1116413609,
 66384,
 1116619486,
 1108917690,
 -1,
 1116684988,
 1116573037,
 -1,
 1116750502,
 1116608678,
 68608,
 1116816027,
 1116683438,
 -1,
 -48494,
 1116787330,
 68632,
 -48493,
 1116845189,
 68677,
 -48492,
 1116907685,
 68670,
 -48491,
 1116970063,
 68668,
 -48490,
 1117028154,
 68644,
 -48489,
 1117088687,
 68640,
 -48488,
 1117153309,
 68634,
 -48487,
 1117211924,
 68623,
 -48486,
 1117271224,
 68627,
 -1,
 1117332772,
 68619,
 1117536925,
 1116776613,
 68669,
 -1,
 1117475320,
 68671,
 -48482,
 1117508226,
 68630,
 -48481,
 1117631621,
 68675,
 -48480,
 1117690959,
 68666,
 -48479,
 1117756072,
 68660,
 -48478,
 1117814586,
 68643,
 -48477,
 1117875119,
 68638,
 -48476,
 1117932820,
 68621,
 -48475,
 1117992120,
 68625,
 -1,
 1118053668,
 68617,
 1118257842,
 1116683438,
 -1,
 1118323372,
 1118207802,
 -1,
 -48471,
 1118294658,
 68650,
 -48470,
 1118352517,
 68646,
 -48469,
 1118391572,
 68653,
 -1,
 1118448281,
 68648,
 -48467,
 1118295237,
 68628,
 -48466,
 1118612246,
 68673,
 -48465,
 1118671654,
 68655,
 -48464,
 1118729996,
 68642,
 -48463,
 1118795359,
 68641,
 -1,
 1118841497,
 68658,
 1119044280,
 1118209470,
 68614,
 1119109813,
 1118977198,
 68615,
 -1,
 1119053853,
 68636,
 -48458,
 1119073413,
 68679,
 -48457,
 1119197864,
 68664,
 -1,
 1119261478,
 68656,
 1119437499,
 1118984771,
 68611,
 -48454,
 1119394472,
 68662,
 -1,
 1119431321,
 68657,
 -1,
 1119364714,
 68680,
 1119748095,
 1116656538,
 -1,
 1119765200,
 1119623334,
 68609,
 1119830726,
 1119698094,
 68610,
 1119896257,
 1119780666,
 68645,
 -1,
 1119833364,
 68654,
 -48446,
 1119867522,
 68633,
 -48445,
 1119990917,
 68678,
 -48444,
 1120036893,
 68635,
 -48443,
 1120095508,
 68624,
 -1,
 1120150820,
 68620,
 -48441,
 1119801986,
 68631,
 -48440,
 1120318597,
 68676,
 -48439,
 1120381718,
 68672,
 -48438,
 1120443471,
 68667,
 -48437,
 1120508584,
 68661,
 -48436,
 1120567699,
 68652,
 -48435,
 1120627631,
 68639,
 -48434,
 1120685332,
 68622,
 -48433,
 1120744632,
 68626,
 -1,
 1120806180,
 68618,
 1121010392,
 1119698094,
 68613,
 1121075925,
 1120960314,
 -1,
 -48429,
 1121047170,
 68651,
 -48428,
 1121105029,
 68647,
 -1,
 1121135257,
 68649,
 -48426,
 1121047749,
 68629,
 -48425,
 1121299222,
 68674,
 -1,
 1121331865,
 68659,
 1121534684,
 1120961982,
 -1,
 1121600219,
 1121467566,
 68616,
 -1,
 1121544221,
 68637,
 -1,
 1121557160,
 68665,
 1121845247,
 1121475139,
 68612,
 -1,
 1121753768,
 68663,
 1121927947,
 1116581965,
 -1,
 1121993478,
 1121874302,
 -1,
 1122058982,
 1121956997,
 -1,
 1122124516,
 1121997304,
 -1,
 -48413,
 1122059535,
 68220,
 -1,
 1122116814,
 68219,
 -48411,
 1122059535,
 68215,
 -1,
 1122247886,
 68201,
 1122452204,
 1122019493,
 -1,
 1122517739,
 1122375846,
 -1,
 -48407,
 1122481285,
 68202,
 -48406,
 1122532066,
 68207,
 -1,
 1122580227,
 68206,
 -1,
 1122457202,
 68198,
 1122845425,
 1122383032,
 -1,
 1122910960,
 1122783758,
 -1,
 -48401,
 1122857330,
 68217,
 -1,
 1122907907,
 68211,
 -1,
 1122835895,
 68213,
 1123173108,
 1122789405,
 -1,
 -48397,
 1123112254,
 68205,
 -1,
 1123164247,
 68203,
 1123369718,
 1123111998,
 68192,
 -1,
 1123333971,
 68194,
 1123500793,
 1123306772,
 -1,
 -48392,
 1123442300,
 68212,
 -1,
 1123505209,
 68214,
 1123697404,
 1123424422,
 -1,
 -48389,
 1123669061,
 68210,
 -1,
 1123708665,
 68209,
 -48387,
 1123669335,
 68216,
 -48386,
 1123865691,
 68218,
 -48385,
 1123929129,
 68197,
 -48384,
 1123983626,
 68199,
 -48383,
 1124047620,
 68196,
 -48382,
 1124107573,
 68204,
 -48381,
 1124170491,
 68195,
 -48380,
 1124232366,
 68193,
 -48379,
 1124288649,
 68208,
 -1,
 1124345659,
 68200,
 1124597759,
 1121944821,
 -1,
 1124614922,
 1124476675,
 -1,
 -48375,
 1124567480,
 68221,
 -1,
 1124616490,
 68222,
 -1,
 1124549643,
 68223,
 1124877112,
 1121878916,
 -1,
 1124942643,
 1124823422,
 -1,
 1125008147,
 1124906117,
 -1,
 1125073681,
 1124946424,
 -1,
 -48368,
 1125007417,
 68251,
 -1,
 1125064007,
 68249,
 -48366,
 1125007417,
 68233,
 -1,
 1125194816,
 68247,
 1125401367,
 1124942984,
 -1,
 -48363,
 1125323431,
 68239,
 -48362,
 1125388674,
 68230,
 -1,
 1125453915,
 68234,
 1125663514,
 1125373141,
 -1,
 -48359,
 1125605064,
 68248,
 -1,
 1125667320,
 68252,
 1125860125,
 1125607453,
 -1,
 -48356,
 1125798463,
 68237,
 -1,
 1125850023,
 68235,
 1126056736,
 1125798392,
 -1,
 -48353,
 1125990457,
 68224,
 -1,
 1126046784,
 68226,
 1126253347,
 1125993748,
 -1,
 -48350,
 1126191700,
 68246,
 -1,
 1126252416,
 68244,
 1126449958,
 1126184262,
 -1,
 -48347,
 1126394799,
 68245,
 -1,
 1126446264,
 68243,
 1126646569,
 1126373542,
 -1,
 -48344,
 1126592249,
 68241,
 -1,
 1126653640,
 68242,
 -48342,
 1126617959,
 68250,
 -48341,
 1126812713,
 68229,
 -48340,
 1126869323,
 68238,
 -48339,
 1126932619,
 68231,
 -48338,
 1126996670,
 68228,
 -48337,
 1127056209,
 68236,
 -48336,
 1127119549,
 68227,
 -48335,
 1127181471,
 68225,
 -48334,
 1127237812,
 68240,
 -1,
 1127294659,
 68232,
 1127546879,
 1124893945,
 -1,
 1127564087,
 1127462021,
 -1,
 -48330,
 1127533705,
 68255,
 -1,
 1127563658,
 68254,
 -1,
 1127516600,
 68253,
 -48327,
 1124821468,
 128477,
 -1,
 1127769409,
 66335,
 1128005631,
 1101087634,
 -1,
 -48324,
 1127928035,
 128117,
 -1,
 1127971018,
 128116,
 1128202239,
 1101005309,
 -1,
 1128219492,
 1128100222,
 -1,
 1128285001,
 1128143014,
 -1,
 1128350533,
 1128208550,
 -1,
 -48318,
 1128319758,
 7267,
 -48317,
 1128363788,
 7266,
 -48316,
 1128425501,
 7264,
 -1,
 1128490742,
 7265,
 -48314,
 1128313989,
 7259,
 -48313,
 1128628627,
 7261,
 -48312,
 1128688559,
 7262,
 -1,
 1128746260,
 7260,
 1128940368,
 1128229807,
 -1,
 1129005900,
 1128863910,
 7258,
 -1,
 1128929446,
 7263,
 -48307,
 1128972059,
 7273,
 -48306,
 1129088446,
 7283,
 -48305,
 1129142851,
 7268,
 -1,
 1129200814,
 7278,
 1129399125,
 1128906523,
 -1,
 -48302,
 1129370242,
 7277,
 -48301,
 1129415427,
 7276,
 -48300,
 1129460920,
 7275,
 -1,
 1129523865,
 7274,
 1129726810,
 1129350590,
 -1,
 -48297,
 1129694877,
 7286,
 -48296,
 1129758000,
 7284,
 -48295,
 1129796088,
 7287,
 -1,
 1129850148,
 7285,
 1130054495,
 1129667139,
 -1,
 -48292,
 1130014885,
 7269,
 -48291,
 1130077263,
 7272,
 -48290,
 1130136934,
 7271,
 -1,
 1130189304,
 7270,
 1130430463,
 1129987246,
 -1,
 -48287,
 1130342237,
 7282,
 -48286,
 1130402598,
 7279,
 -48285,
 1130463034,
 7281,
 -1,
 1130509814,
 7280,
 1130709874,
 1128150938,
 -1,
 1130775400,
 1130673285,
 -1,
 -48281,
 1130745803,
 7250,
 -1,
 1130780891,
 7251,
 1130972011,
 1130735781,
 -1,
 -48278,
 1130915447,
 7254,
 -1,
 1130972654,
 7255,
 1131168622,
 1130907598,
 -1,
 -48275,
 1131122536,
 7252,
 -1,
 1131177427,
 7253,
 -48273,
 1131140478,
 7248,
 -48272,
 1131317688,
 7249,
 -48271,
 1131381339,
 7257,
 -1,
 1131429998,
 7256,
 1131627383,
 1130664742,
 -1,
 1131692918,
 1131594388,
 -1,
 -48267,
 1131642479,
 7294,
 -1,
 1131690601,
 7295,
 -1,
 1131631143,
 7292,
 1131955066,
 1131576935,
 -1,
 -48263,
 1131875902,
 7290,
 -1,
 1131940574,
 7288,
 -48261,
 1131913363,
 7291,
 -48260,
 1132088682,
 7289,
 -1,
 1132141644,
 7293,
 1132348336,
 1100982437,
 -1,
 1132413871,
 1132296447,
 -1,
 1132479393,
 1132360062,
 -1,
 1132544899,
 1132402854,
 66710,
 -48254,
 1132490489,
 66688,
 -1,
 1132533926,
 66715,
 1132741510,
 1132505253,
 -1,
 -48251,
 1132680773,
 66697,
 -1,
 1132730534,
 66696,
 1132938120,
 1132692926,
 66713,
 -1,
 1132889534,
 66717,
 1133069195,
 1132881949,
 -1,
 -48246,
 1133007374,
 66693,
 -1,
 1133058391,
 66703,
 1133265805,
 1133001902,
 66711,
 -1,
 1133198510,
 66716,
 1133396880,
 1133196472,
 -1,
 -48241,
 1133335054,
 66698,
 -1,
 1133395820,
 66694,
 -48239,
 1133368027,
 66709,
 -48238,
 1133564346,
 66692,
 -48237,
 1133628457,
 66707,
 -48236,
 1133690651,
 66714,
 -48235,
 1133753607,
 66690,
 -48234,
 1133812931,
 66695,
 -48233,
 1133877945,
 66702,
 -48232,
 1133938007,
 66706,
 -48231,
 1134001257,
 66705,
 -48230,
 1134062577,
 66704,
 -48229,
 1134126868,
 66691,
 -48228,
 1134189123,
 66712,
 -48227,
 1134252558,
 66708,
 -48226,
 1134316899,
 66700,
 -48225,
 1134381091,
 66701,
 -48224,
 1134439484,
 66699,
 -1,
 1134503257,
 66689,
 1134755839,
 1132410778,
 -1,
 1134773157,
 1134670981,
 -1,
 -48220,
 1134743499,
 66722,
 -1,
 1134778587,
 66723,
 1134969768,
 1134733477,
 -1,
 -48217,
 1134913143,
 66726,
 -1,
 1134970350,
 66727,
 1135166379,
 1134905294,
 -1,
 -48214,
 1135120232,
 66724,
 -1,
 1135175123,
 66725,
 -48212,
 1135138174,
 66720,
 -48211,
 1135315384,
 66721,
 -48210,
 1135379035,
 66729,
 -1,
 1135427694,
 66728,
 -1,
 1132341913,
 983191,
 1135690692,
 1132305487,
 -1,
 1135756226,
 1135634130,
 -1,
 1135821755,
 1135692849,
 -1,
 1135887288,
 1135774140,
 -1,
 -48203,
 1135849050,
 2933,
 -48202,
 1135909760,
 2930,
 -48201,
 1135956621,
 2931,
 -1,
 1136017575,
 2934,
 1136263167,
 1135851575,
 -1,
 -48198,
 1136176740,
 2935,
 -1,
 1136237503,
 2932,
 1136411583,
 1135790772,
 -1,
 1136477118,
 1136356271,
 2914,
 -1,
 1136421807,
 2915,
 -1,
 1136437085,
 2884,
 1136721919,
 1136357758,
 -1,
 -48191,
 1136642894,
 2929,
 -1,
 1136707251,
 2869,
 -48189,
 1135681408,
 128217,
 -1,
 1136790487,
 10183,
 1137001431,
 1135645478,
 -1,
 1137066964,
 1136934062,
 -1,
 1137132499,
 1137016636,
 -1,
 1137198026,
 1137095527,
 -1,
 -48183,
 1137153538,
 10180,
 -1,
 1137191430,
 10179,
 1137394637,
 1137145820,
 -1,
 -48180,
 1137352015,
 128236,
 -1,
 1137407522,
 128237,
 1137591248,
 1137330126,
 -1,
 -48177,
 1137543292,
 128449,
 -1,
 1137598010,
 128194,
 -48175,
 1137538215,
 128275,
 -48174,
 1137726350,
 128080,
 -1,
 1137781025,
 128214,
 -1,
 1137090149,
 983190,
 1138050006,
 1137031429,
 128191,
 -1,
 1137967978,
 128440,
 -1,
 1137989353,
 9934,
 1138246626,
 1136951098,
 -1,
 1138312158,
 1138176182,
 -1,
 -48166,
 1138275871,
 128662,
 -48165,
 1138333799,
 128660,
 -48164,
 1138379178,
 128753,
 -48163,
 1138436695,
 128653,
 -1,
 1138500731,
 128664,
 1138705377,
 1138244784,
 -1,
 -48160,
 1138637053,
 11819,
 -1,
 1138698868,
 128431,
 -1,
 1138625549,
 128283,
 1138967525,
 1138214466,
 -1,
 -48156,
 1138914138,
 9885,
 -1,
 1138960785,
 128228,
 -48154,
 1138938270,
 128002,
 -48153,
 1139132450,
 128471,
 -48152,
 1139177302,
 128329,
 -48151,
 1139238956,
 128076,
 -48150,
 1139301890,
 128738,
 -48149,
 1139362008,
 127970,
 -48148,
 1139422809,
 127842,
 -1,
 1139487706,
 128025,
 1139689005,
 1100893460,
 -1,
 1139754312,
 1139645519,
 -1,
 1139819738,
 1139687242,
 -1,
 1139885270,
 1139763231,
 -1,
 1139950661,
 1139808422,
 -1,
 1140016194,
 1139880647,
 -1,
 1140081688,
 1139942406,
 -1,
 1140147207,
 1140017441,
 -1,
 1140212736,
 1140115326,
 65859,
 1140326399,
 1140129792,
 -1,
 1140343803,
 1140241541,
 -1,
 1140409338,
 1140283552,
 65862,
 -1,
 1140328802,
 65870,
 -1,
 1140333989,
 65864,
 1140605951,
 1140283868,
 65861,
 1140719615,
 1140523008,
 -1,
 -48130,
 1140635065,
 65868,
 -1,
 1140699614,
 65875,
 -1,
 1140568542,
 65871,
 1140981759,
 1140149499,
 65860,
 1141047295,
 1140850688,
 -1,
 1141064710,
 1140962437,
 -1,
 1141130245,
 1141004448,
 65863,
 -1,
 1141049636,
 65878,
 -1,
 1141054885,
 65866,
 -1,
 1141027294,
 65873,
 1141392402,
 1140099516,
 -1,
 1141457933,
 1141330424,
 -1,
 1141523468,
 1141424866,
 -1,
 -48117,
 1141487033,
 65867,
 -1,
 1141551582,
 65874,
 -1,
 1141448134,
 65857,
 1141785616,
 1141422100,
 -1,
 -48113,
 1141749177,
 65869,
 -1,
 1141813726,
 65876,
 -48111,
 1141742464,
 65856,
 -1,
 1141914590,
 65858,
 1142161407,
 1141356221,
 -1,
 1142178838,
 1142076549,
 -1,
 -48107,
 1142118590,
 65877,
 -1,
 1142168997,
 65865,
 -48105,
 1142141406,
 65872,
 -1,
 1142324524,
 65879,
 1142506545,
 1140044933,
 -1,
 1142572073,
 1142445360,
 -1,
 1142637600,
 1142535301,
 -1,
 1142703134,
 1142575608,
 -1,
 -48099,
 1142661171,
 65899,
 -1,
 1142711405,
 65893,
 -48097,
 1142673355,
 65884,
 -1,
 1142833546,
 65892,
 1143030820,
 1142589880,
 65881,
 1143144447,
 1142947840,
 -1,
 -48093,
 1143060491,
 65905,
 -1,
 1143101916,
 65898,
 1143341055,
 1142966561,
 -1,
 1143358504,
 1143261057,
 -1,
 -48089,
 1143322635,
 65906,
 -1,
 1143364060,
 65902,
 -1,
 1143295227,
 65897,
 1143668735,
 1142531677,
 -1,
 1143686191,
 1143556385,
 -1,
 1143751725,
 1143654270,
 65887,
 -1,
 1143669601,
 65901,
 1143930879,
 1143688443,
 65894,
 -1,
 1143799846,
 65895,
 1144061951,
 1143649977,
 65888,
 -1,
 1143930918,
 65889,
 1144144951,
 1142445326,
 -1,
 1144210486,
 1144093936,
 -1,
 -48076,
 1144174265,
 65890,
 -48075,
 1144228280,
 65882,
 -1,
 1144277290,
 65896,
 -1,
 1144134549,
 65880,
 1144538171,
 1144079172,
 -1,
 1144603706,
 1144503901,
 65883,
 -1,
 1144521410,
 65886,
 -1,
 1144539651,
 65900,
 1144800318,
 1144466073,
 -1,
 -48067,
 1144771728,
 65885,
 -1,
 1144791631,
 65903,
 -48065,
 1144763083,
 65908,
 -48064,
 1144946689,
 65904,
 -48063,
 1145011026,
 65891,
 -1,
 1145058882,
 65907,
 1145307135,
 1139973199,
 -1,
 -48060,
 1145222451,
 65926,
 -1,
 1145278470,
 65927,
 1145455724,
 1139892763,
 -1,
 1145521230,
 1145377733,
 119327,
 -48056,
 1145444335,
 119356,
 -48055,
 1145509694,
 119355,
 -48054,
 1145575006,
 119354,
 -48053,
 1145640089,
 119353,
 -48052,
 1145705127,
 119352,
 -48051,
 1145770370,
 119351,
 -1,
 1145835346,
 119350,
 1146045526,
 1145442395,
 119325,
 -48048,
 1145968623,
 119337,
 -48047,
 1146033982,
 119336,
 -48046,
 1146099294,
 119335,
 -48045,
 1146164165,
 119334,
 -48044,
 1146229415,
 119333,
 -48043,
 1146294658,
 119332,
 -1,
 1146359899,
 119331,
 1146569821,
 1145966978,
 119326,
 -48040,
 1146492911,
 119343,
 -48039,
 1146558046,
 119342,
 -48038,
 1146623374,
 119341,
 -48037,
 1146688665,
 119340,
 -48036,
 1146753989,
 119339,
 -1,
 1146819239,
 119338,
 1147028579,
 1146492057,
 119328,
 -48033,
 1146950597,
 119361,
 -48032,
 1147015847,
 119360,
 -48031,
 1147081090,
 119359,
 -48030,
 1147146331,
 119358,
 -1,
 1147211602,
 119357,
 1147421802,
 1146950311,
 -1,
 -48027,
 1147344879,
 119349,
 -48026,
 1147410238,
 119348,
 -48025,
 1147475550,
 119347,
 -48024,
 1147540878,
 119346,
 -48023,
 1147605378,
 119345,
 -1,
 1147670354,
 119344,
 -48021,
 1147344702,
 119330,
 -1,
 1147803230,
 119329,
 1148011658,
 1145424311,
 -1,
 1148077176,
 1147932763,
 119296,
 -48017,
 1148000239,
 119314,
 -48016,
 1148065598,
 119313,
 -48015,
 1148130910,
 119312,
 -48014,
 1148196238,
 119311,
 -48013,
 1148261529,
 119310,
 -48012,
 1148326853,
 119309,
 -48011,
 1148392103,
 119308,
 -48010,
 1148457346,
 119307,
 -48009,
 1148522587,
 119306,
 -1,
 1148587858,
 119305,
 1148798078,
 1147999385,
 119300,
 -48006,
 1148720069,
 119324,
 -48005,
 1148785319,
 119323,
 -48004,
 1148850562,
 119322,
 -48003,
 1148915803,
 119321,
 -1,
 1148981074,
 119320,
 1149191300,
 1148719490,
 119297,
 -48000,
 1149113285,
 119319,
 -47999,
 1149178535,
 119318,
 -47998,
 1149243778,
 119317,
 -47997,
 1149309019,
 119316,
 -1,
 1149374290,
 119315,
 -47995,
 1149114351,
 119304,
 -47994,
 1149507390,
 119303,
 -47993,
 1149572702,
 119302,
 -47992,
 1149638030,
 119301,
 -47991,
 1149703109,
 119299,
 -1,
 1149768359,
 119298,
 1149977759,
 1147971749,
 -1,
 1150043287,
 1149925424,
 -1,
 1150108819,
 1149989246,
 -1,
 1150174352,
 1150068901,
 -1,
 -47985,
 1150113582,
 1016,
 -1,
 1150164649,
 1019,
 -47983,
 1150129138,
 887,
 -47982,
 1150309689,
 881,
 -1,
 1150361826,
 883,
 1150567574,
 1150067039,
 -1,
 -47979,
 1150514905,
 891,
 -1,
 1150564710,
 893,
 -1,
 1150499174,
 892,
 1150829725,
 1150009546,
 -1,
 -47975,
 1150788036,
 7528,
 -47974,
 1150850630,
 7529,
 -47973,
 1150897628,
 7527,
 -47972,
 1150954917,
 7530,
 -1,
 1151018799,
 7526,
 -47970,
 1150800942,
 65952,
 -1,
 1151165070,
 65932,
 1151354031,
 1149905792,
 -1,
 1151419562,
 1151298479,
 -1,
 1151485097,
 1151354159,
 -1,
 1151550629,
 1151445157,
 -1,
 -47964,
 1151489838,
 1015,
 -1,
 1151540905,
 1018,
 -47962,
 1151521888,
 895,
 -47961,
 1151702002,
 886,
 -47960,
 1151751481,
 880,
 -1,
 1151803618,
 882,
 -1,
 1151451766,
 1017,
 1152074925,
 1151377759,
 -1,
 -47956,
 1152022233,
 1021,
 -1,
 1152072038,
 1023,
 -47954,
 1152018615,
 975,
 -1,
 1152203110,
 1022,
 1152402617,
 1151298479,
 -1,
 1152468152,
 1152337206,
 -1,
 1152533684,
 1152422694,
 -1,
 -47949,
 1152494849,
 7466,
 -1,
 1152539203,
 7464,
 -47947,
 1152491972,
 7465,
 -47946,
 1152682255,
 43877,
 -47945,
 1152740520,
 7463,
 -1,
 1152798172,
 7462,
 -1,
 1152411059,
 65923,
 1153057986,
 1152365701,
 -1,
 1153123517,
 1153028046,
 -1,
 -47940,
 1153087483,
 65911,
 -1,
 1153140270,
 65917,
 1153320128,
 1153063136,
 -1,
 -47937,
 1153276872,
 65912,
 -1,
 1153336878,
 65918,
 -47935,
 1153280135,
 65929,
 -1,
 1153441178,
 65914,
 1153647817,
 1153009086,
 -1,
 1153713351,
 1153597595,
 -1,
 1153778886,
 1153651405,
 65909,
 -1,
 1153695782,
 65910,
 -1,
 1153735602,
 65931,
 -47928,
 1153680170,
 65924,
 -1,
 1153902831,
 65916,
 1154106572,
 1153595148,
 -1,
 -47925,
 1154074149,
 119365,
 -1,
 1154106658,
 65921,
 1154303183,
 1154041806,
 -1,
 -47922,
 1154256817,
 65919,
 -1,
 1154311697,
 65920,
 -47920,
 1154274725,
 65930,
 -47919,
 1154470739,
 65913,
 -47918,
 1154535942,
 65925,
 -47917,
 1154589128,
 1020,
 -47916,
 1154640787,
 65922,
 -47915,
 1154699462,
 65928,
 -1,
 1154759654,
 65915,
 1155006463,
 1139834684,
 -1,
 -47912,
 1154897012,
 128154,
 -47911,
 1154951457,
 128215,
 -1,
 1155014784,
 127823,
 1155220799,
 1139742886,
 -1,
 1155286333,
 1155171485,
 -1,
 1155351839,
 1155232126,
 -1,
 1155417319,
 1155319453,
 -1,
 1155482851,
 1155368510,
 -1,
 1155548385,
 1155439695,
 70411,
 -1,
 1155505231,
 70496,
 1155727359,
 1155492783,
 70412,
 -1,
 1155623855,
 70497,
 1155810534,
 1155415863,
 -1,
 -47899,
 1155742135,
 70495,
 -1,
 1155801138,
 70494,
 -1,
 1155733670,
 70453,
 1156072685,
 1155380357,
 -1,
 1156138219,
 1156035717,
 -1,
 -47894,
 1156076046,
 70432,
 -1,
 1156126886,
 70431,
 -47892,
 1156076046,
 70437,
 -1,
 1156257958,
 70436,
 1156465906,
 1156022074,
 -1,
 -47889,
 1156436699,
 70430,
 -47888,
 1156480912,
 70435,
 -47887,
 1156533603,
 70425,
 -1,
 1156585638,
 70440,
 1156793592,
 1156396216,
 -1,
 1156859126,
 1156723896,
 -1,
 -47883,
 1156796942,
 70434,
 -1,
 1156847782,
 70433,
 -47881,
 1156796942,
 70439,
 -1,
 1156978854,
 70438,
 1157186812,
 1156716710,
 70405,
 -47878,
 1157152539,
 70420,
 -47877,
 1157192259,
 70416,
 -1,
 1157240998,
 70406,
 1157448960,
 1157146789,
 -1,
 -47874,
 1157409072,
 70455,
 -47873,
 1157452302,
 70454,
 -1,
 1157503142,
 70456,
 1157711106,
 1157414683,
 70409,
 -1,
 1157676827,
 70410,
 1157842181,
 1157665574,
 -1,
 -47868,
 1157779982,
 70443,
 -1,
 1157830822,
 70442,
 1158038792,
 1157786543,
 -1,
 -47865,
 1157983197,
 70451,
 -1,
 1158027430,
 70450,
 1158235403,
 1157982237,
 -1,
 -47862,
 1158173198,
 70422,
 -1,
 1158224038,
 70421,
 1158432014,
 1158178550,
 -1,
 -47859,
 1158369806,
 70429,
 -1,
 1158420646,
 70428,
 1158628624,
 1158371907,
 70407,
 -1,
 1158568515,
 70408,
 1158759699,
 1158565140,
 -1,
 -47854,
 1158697486,
 70424,
 -1,
 1158748326,
 70423,
 1158956310,
 1158687385,
 -1,
 -47851,
 1158894094,
 70427,
 -1,
 1158944934,
 70426,
 1159152921,
 1158882596,
 -1,
 -47848,
 1159090702,
 70445,
 -1,
 1159141542,
 70444,
 -47846,
 1159123675,
 70447,
 -47845,
 1159306435,
 70448,
 -47844,
 1159367424,
 70419,
 -47843,
 1159427938,
 70446,
 -47842,
 1159483918,
 70457,
 -1,
 1159544650,
 70415,
 1159742767,
 1155320474,
 -1,
 1159808293,
 1159711182,
 -1,
 1159873827,
 1159765071,
 70467,
 -1,
 1159830607,
 70468,
 1160052735,
 1159818159,
 70498,
 -1,
 1159949231,
 70499,
 1160135977,
 1159731366,
 -1,
 -47833,
 1160101659,
 70476,
 -47832,
 1160141379,
 70472,
 -1,
 1160190118,
 70462,
 1160398123,
 1160101659,
 70465,
 -1,
 1160363803,
 70466,
 1160529197,
 1160337987,
 70463,
 -1,
 1160469059,
 70464,
 -47826,
 1160481536,
 70475,
 -1,
 1160593226,
 70471,
 1160791355,
 1159703926,
 -1,
 1160856883,
 1160759633,
 -1,
 -47822,
 1160817115,
 70403,
 -1,
 1160879605,
 70477,
 1161053494,
 1160784537,
 -1,
 -47819,
 1161005298,
 70400,
 -1,
 1161043801,
 70401,
 1161250105,
 1160976550,
 -1,
 -47816,
 1161217718,
 70461,
 -1,
 1161266494,
 70402,
 -47814,
 1161205664,
 70493,
 -1,
 1161397487,
 70460,
 -47812,
 1160743104,
 70480,
 -1,
 1161503803,
 70487,
 -47810,
 1155241515,
 127815,
 -1,
 1161641001,
 127891,
 1161839941,
 1155160643,
 -1,
 1161905476,
 1161790229,
 -1,
 1161971011,
 1161840678,
 128512,
 -1,
 1161891163,
 128513,
 -1,
 1161899035,
 128568,
 -1,
 1161852799,
 128556,
 1162280959,
 1161790910,
 -1,
 -47801,
 1162202666,
 128151,
 -1,
 1162265558,
 983109,
 1162429899,
 1139698607,
 -1,
 1162495432,
 1162353704,
 -1,
 1162560905,
 1162456885,
 -1,
 1162626388,
 1162520741,
 -1,
 1162691920,
 1162564088,
 -1,
 1162757455,
 1162654983,
 11339,
 -1,
 1162712686,
 11356,
 -1,
 1162680486,
 11342,
 1162954066,
 1162639553,
 11348,
 -1,
 1162874273,
 11349,
 -47789,
 1162909318,
 11346,
 -1,
 1163031907,
 11332,
 1163216221,
 1162596994,
 -1,
 1163281754,
 1163148462,
 -1,
 1163347289,
 1163238479,
 -1,
 -47784,
 1163312923,
 11343,
 -1,
 1163352643,
 11344,
 -1,
 1163309906,
 11317,
 -47781,
 1163247387,
 11347,
 -47780,
 1163560382,
 11350,
 -1,
 1163600818,
 11345,
 1163806053,
 1163156035,
 11323,
 1163871585,
 1163777467,
 -1,
 -47776,
 1163814333,
 11355,
 -1,
 1163869358,
 11321,
 1164068196,
 1163824700,
 -1,
 -47773,
 1164029867,
 11351,
 -1,
 1164060626,
 11353,
 -1,
 1164018380,
 11322,
 1164330345,
 1163768965,
 -1,
 -47769,
 1164298991,
 11333,
 -47768,
 1164356865,
 11340,
 -1,
 1164420736,
 11357,
 1164592493,
 1164260536,
 -1,
 -47765,
 1164563807,
 11319,
 -47764,
 1164609081,
 11316,
 -1,
 1164666753,
 11324,
 1164854640,
 1164563653,
 -1,
 -47761,
 1164793590,
 11318,
 -1,
 1164853616,
 11320,
 1165051251,
 1164808998,
 -1,
 -47758,
 1165002772,
 11330,
 -1,
 1165049006,
 11338,
 1165247862,
 1165002174,
 -1,
 -47755,
 1165213038,
 11337,
 -1,
 1165264090,
 11329,
 1165444473,
 1165192111,
 -1,
 -47752,
 1165387778,
 11326,
 -1,
 1165435857,
 11358,
 1165641084,
 1165379534,
 -1,
 -47749,
 1165600222,
 11335,
 -1,
 1165649189,
 11354,
 1165837695,
 1165567268,
 -1,
 -47746,
 1165803984,
 11313,
 -1,
 1165843632,
 11352,
 -47744,
 1165805499,
 11314,
 -47743,
 1166000583,
 11334,
 -47742,
 1166058968,
 11331,
 -47741,
 1166114807,
 11328,
 -47740,
 1166180146,
 11327,
 -47739,
 1166239942,
 11325,
 -47738,
 1166300452,
 11336,
 -47737,
 1166364742,
 11315,
 -47736,
 1166421489,
 11341,
 -1,
 1166484768,
 11312,
 1166737407,
 1162488729,
 -1,
 1166755219,
 1166649509,
 -1,
 1166820751,
 1166692856,
 -1,
 1166886286,
 1166783751,
 11291,
 -1,
 1166841454,
 11308,
 -1,
 1166809254,
 11294,
 1167082897,
 1166768321,
 11300,
 -1,
 1167003041,
 11301,
 -47726,
 1167038086,
 11298,
 -1,
 1167160675,
 11284,
 1167345052,
 1166725762,
 -1,
 1167410585,
 1167277230,
 -1,
 1167476120,
 1167367247,
 -1,
 -47721,
 1167441691,
 11295,
 -1,
 1167481411,
 11296,
 -1,
 1167438674,
 11269,
 -47718,
 1167376155,
 11299,
 -47717,
 1167689150,
 11302,
 -1,
 1167729586,
 11297,
 1167934884,
 1167284803,
 11275,
 1168000416,
 1167906235,
 -1,
 -47713,
 1167943101,
 11307,
 -1,
 1167998126,
 11273,
 1168197027,
 1167953468,
 -1,
 -47710,
 1168158635,
 11303,
 -1,
 1168189394,
 11305,
 -1,
 1168147148,
 11274,
 1168459176,
 1167897733,
 -1,
 -47706,
 1168427759,
 11285,
 -47705,
 1168485633,
 11292,
 -1,
 1168549504,
 11309,
 1168721324,
 1168389304,
 -1,
 -47702,
 1168692575,
 11271,
 -47701,
 1168737849,
 11268,
 -1,
 1168795521,
 11276,
 1168983471,
 1168692421,
 -1,
 -47698,
 1168922358,
 11270,
 -1,
 1168982384,
 11272,
 1169180082,
 1168937766,
 -1,
 -47695,
 1169131540,
 11282,
 -1,
 1169177774,
 11290,
 1169376693,
 1169130942,
 -1,
 -47692,
 1169341806,
 11289,
 -1,
 1169392858,
 11281,
 1169573304,
 1169320879,
 -1,
 -47689,
 1169516546,
 11278,
 -1,
 1169564625,
 11310,
 1169769915,
 1169508302,
 -1,
 -47686,
 1169728990,
 11287,
 -1,
 1169777957,
 11306,
 1169966526,
 1169696036,
 -1,
 -47683,
 1169932752,
 11265,
 -1,
 1169972400,
 11304,
 -47681,
 1169934267,
 11266,
 -47680,
 1170129351,
 11286,
 -47679,
 1170187736,
 11283,
 -47678,
 1170243575,
 11280,
 -47677,
 1170308914,
 11279,
 -47676,
 1170368710,
 11277,
 -47675,
 1170429220,
 11288,
 -47674,
 1170493510,
 11267,
 -47673,
 1170550257,
 11293,
 -1,
 1170613536,
 11264,
 1170866175,
 1162446270,
 -1,
 -47670,
 1170787893,
 127775,
 -1,
 1170810534,
 127760,
 1171015186,
 1162362030,
 -1,
 1171080717,
 1170967852,
 -1,
 1171146242,
 1171042101,
 -1,
 1171211733,
 1171083768,
 -1,
 1171277266,
 1171134630,
 -1,
 -47663,
 1171233871,
 11556,
 -1,
 1171274926,
 11552,
 -47661,
 1171228380,
 11557,
 -47660,
 1171414091,
 11554,
 -1,
 1171471534,
 11553,
 1171670491,
 1171139225,
 -1,
 1171736025,
 1171608056,
 -1,
 -47656,
 1171676872,
 11545,
 -1,
 1171726506,
 11549,
 -47654,
 1171676671,
 11548,
 -1,
 1171857065,
 11546,
 1172063710,
 1171641541,
 -1,
 -47651,
 1172001737,
 11535,
 -1,
 1172062602,
 11526,
 1172260321,
 1172026631,
 -1,
 -47648,
 1172216911,
 11538,
 -1,
 1172275002,
 11527,
 1172456932,
 1172220069,
 -1,
 -47645,
 1172395634,
 11544,
 -1,
 1172446889,
 11537,
 1172653543,
 1172411174,
 -1,
 -47642,
 1172591561,
 11540,
 -1,
 1172644010,
 11534,
 1172850154,
 1172596765,
 -1,
 -47639,
 1172788169,
 11541,
 -1,
 1172840105,
 11529,
 1173046765,
 1172793078,
 -1,
 -47636,
 1172987391,
 11547,
 -1,
 1173050121,
 11551,
 1173243376,
 1172983060,
 -1,
 -47633,
 1173181193,
 11542,
 -1,
 1173233321,
 11522,
 1173439987,
 1173166246,
 -1,
 -47630,
 1173389114,
 11520,
 -1,
 1173438858,
 11565,
 -47628,
 1173410885,
 11559,
 -47627,
 1173606863,
 11550,
 -47626,
 1173671009,
 11555,
 -47625,
 1173735799,
 11525,
 -47624,
 1173799531,
 11539,
 -47623,
 1173855484,
 11536,
 -47622,
 1173920482,
 11543,
 -47621,
 1173981494,
 11533,
 -47620,
 1174044628,
 11532,
 -47619,
 1174108362,
 11531,
 -47618,
 1174170963,
 11530,
 -47617,
 1174232776,
 11528,
 -47616,
 1174290826,
 11524,
 -47615,
 1174354074,
 11523,
 -1,
 1174414781,
 11521,
 1174619658,
 1171091838,
 -1,
 1174685190,
 1174542502,
 -1,
 -47611,
 1174625992,
 4346,
 -1,
 1174684042,
 4349,
 -47609,
 1174650757,
 983924,
 -47608,
 1174846964,
 4345,
 -47607,
 1174891516,
 4351,
 -1,
 1174950897,
 4350,
 1175191551,
 1174547353,
 -1,
 -47604,
 1175114821,
 4295,
 -1,
 1175133012,
 4301,
 1175340561,
 1171005610,
 9881,
 1175453695,
 1175259906,
 -1,
 -47600,
 1175359560,
 9965,
 -1,
 1175388996,
 9966,
 -1,
 1175287630,
 128142,
 1175668261,
 1170980635,
 -1,
 1175733788,
 1175611190,
 -1,
 1175799320,
 1175679358,
 -1,
 1175864855,
 1175767511,
 2700,
 -1,
 1175808943,
 2785,
 -1,
 1175836117,
 2809,
 1176061466,
 1175767752,
 2786,
 -1,
 1176005551,
 2787,
 -47589,
 1176021105,
 2801,
 -1,
 1176115644,
 2800,
 1176323617,
 1175692836,
 -1,
 -47586,
 1176294169,
 2677,
 -47585,
 1176357265,
 2563,
 -47584,
 1176420639,
 2641,
 -1,
 1176443648,
 2561,
 1176651300,
 1176248490,
 -1,
 -47581,
 1176583192,
 128130,
 -1,
 1176641496,
 8370,
 -1,
 1176593769,
 127928,
 1176913448,
 1175619006,
 -1,
 -47577,
 1176859162,
 127948,
 -1,
 1176904463,
 128016,
 1177110058,
 1176855630,
 128103,
 -1,
 1177069860,
 128714,
 -47573,
 1177069733,
 983110,
 -47572,
 1177180272,
 128123,
 -1,
 1177230961,
 127922,
 1177438334,
 1139632157,
 -1,
 1177503677,
 1177375224,
 -1,
 1177568948,
 1177451323,
 -1,
 1177634426,
 1177528485,
 -1,
 1177699961,
 1177605146,
 -1,
 1177765449,
 1177654054,
 -1,
 1177830981,
 1177722339,
 -1,
 1177896514,
 1177751019,
 -1,
 1177962044,
 1177822500,
 -1,
 1178027577,
 1177928521,
 -1,
 -47560,
 1177986642,
 6649,
 -1,
 1178036956,
 6633,
 1178271743,
 1177960550,
 -1,
 -47557,
 1178183250,
 6648,
 -1,
 1178233564,
 6632,
 1178420799,
 1177917100,
 -1,
 -47554,
 1178379858,
 6647,
 -1,
 1178430172,
 6631,
 1178664959,
 1178369761,
 -1,
 -47551,
 1178576466,
 6646,
 -1,
 1178626780,
 6630,
 1178861567,
 1177812992,
 -1,
 -47548,
 1178773074,
 6645,
 -1,
 1178823388,
 6629,
 1179010632,
 1177771501,
 -1,
 -47545,
 1178969682,
 6642,
 -1,
 1179019996,
 6626,
 -1,
 1178936172,
 6624,
 1179272799,
 1177695680,
 -1,
 1179338332,
 1179192811,
 -1,
 1179403858,
 1179292454,
 -1,
 1179469391,
 1179360743,
 -1,
 -47538,
 1179428434,
 6655,
 -1,
 1179478748,
 6639,
 1179713535,
 1179409901,
 -1,
 -47535,
 1179625042,
 6652,
 -1,
 1179675356,
 6636,
 1179862617,
 1179329828,
 -1,
 1179928150,
 1179829065,
 -1,
 -47531,
 1179887186,
 6654,
 -1,
 1179937500,
 6638,
 1180172287,
 1179861094,
 -1,
 -47528,
 1180083794,
 6653,
 -1,
 1180134108,
 6637,
 1180368895,
 1179811553,
 -1,
 -47525,
 1180280402,
 6651,
 -1,
 1180330716,
 6635,
 1180565503,
 1179254784,
 -1,
 -47522,
 1180477010,
 6650,
 -1,
 1180527324,
 6634,
 1180714606,
 1179218212,
 -1,
 1180780137,
 1180668710,
 -1,
 1180845672,
 1180736995,
 6133,
 1180958719,
 1180765675,
 -1,
 1180976742,
 1180837156,
 -1,
 -47515,
 1180943173,
 6137,
 -1,
 1180975203,
 6136,
 -47513,
 1180931752,
 6135,
 -1,
 1181122268,
 6134,
 -1,
 1180786154,
 6130,
 1181369964,
 1180706084,
 -1,
 -47509,
 1181336389,
 6132,
 -1,
 1181368419,
 6131,
 -47507,
 1181331506,
 6128,
 -1,
 1181515484,
 6129,
 1181697653,
 1180640548,
 -1,
 1181763186,
 1181664073,
 -1,
 -47503,
 1181722194,
 6644,
 -1,
 1181772508,
 6628,
 1182007295,
 1181696102,
 -1,
 -47500,
 1181918802,
 6643,
 -1,
 1181969116,
 6627,
 1182156408,
 1181646561,
 -1,
 -47497,
 1182115410,
 6641,
 -1,
 1182165724,
 6625,
 -1,
 1182121525,
 6640,
 -1,
 1177640390,
 6109,
 1182484138,
 1177563458,
 -1,
 1182549636,
 1182446725,
 -1,
 1182615167,
 1182512979,
 -1,
 -47490,
 1182565822,
 983938,
 -1,
 1182603430,
 983936,
 1182811778,
 1182552568,
 -1,
 -47487,
 1182762430,
 983943,
 -1,
 1182800038,
 983941,
 -47485,
 1182762430,
 983942,
 -1,
 1182931110,
 983940,
 1183139465,
 1182498618,
 -1,
 -47482,
 1183110224,
 983934,
 -47481,
 1183155646,
 983944,
 -47480,
 1183207530,
 983929,
 -1,
 1183258790,
 983939,
 1183467151,
 1183082525,
 -1,
 1183532685,
 1183404536,
 -1,
 -47476,
 1183483326,
 983928,
 -1,
 1183520934,
 983926,
 -47474,
 1183483326,
 983927,
 -1,
 1183652006,
 983925,
 1183860373,
 1183394457,
 -1,
 1183925907,
 1183797752,
 -1,
 -47470,
 1183876542,
 983933,
 -1,
 1183914150,
 983931,
 -47468,
 1183876542,
 983932,
 -1,
 1184045222,
 983930,
 1184253593,
 1183819941,
 -1,
 -47465,
 1184213296,
 983955,
 -47464,
 1184256526,
 983954,
 -1,
 1184307366,
 983956,
 1184515742,
 1184207654,
 -1,
 1184581277,
 1184453112,
 -1,
 -47460,
 1184531902,
 983948,
 -1,
 1184569510,
 983946,
 -1,
 1184531902,
 983947,
 1184843425,
 1184459695,
 -1,
 -47456,
 1184794046,
 983952,
 -1,
 1184831654,
 983958,
 1185040036,
 1184773304,
 -1,
 -47453,
 1184990654,
 983937,
 -1,
 1185028262,
 983935,
 -47451,
 1185010768,
 983950,
 -47450,
 1185204660,
 983953,
 -47449,
 1185261111,
 983951,
 -47448,
 1185316168,
 983949,
 -47447,
 1185370638,
 983957,
 -1,
 1185424729,
 983945,
 1185629872,
 1182424894,
 -1,
 1185695405,
 1185589372,
 983961,
 -1,
 1185665666,
 983962,
 1185873919,
 1185651368,
 -1,
 -47441,
 1185791771,
 983960,
 -1,
 1185823918,
 983963,
 1186070527,
 1185598106,
 -1,
 -47438,
 1185974464,
 983964,
 -47437,
 1186017354,
 983959,
 -1,
 1186077019,
 983965,
 1186285327,
 1177534764,
 -1,
 1186350834,
 1186230654,
 -1,
 1186416317,
 1186280632,
 -1,
 1186481851,
 1186346168,
 -1,
 -47431,
 1186419214,
 70347,
 -47430,
 1186477382,
 70345,
 -1,
 1186535590,
 70344,
 -47428,
 1186419214,
 70352,
 -1,
 1186666662,
 70351,
 1186875075,
 1186378885,
 -1,
 1186940609,
 1186837637,
 -1,
 -47424,
 1186877966,
 70343,
 -1,
 1186928806,
 70342,
 -47422,
 1186877966,
 70350,
 -1,
 1187059878,
 70349,
 1187268296,
 1186823994,
 -1,
 -47419,
 1187238619,
 70341,
 -47418,
 1187282832,
 70348,
 -47417,
 1187335523,
 70335,
 -1,
 1187387558,
 70353,
 1187595980,
 1187190950,
 70320,
 -47414,
 1187561243,
 70329,
 -47413,
 1187600963,
 70327,
 -1,
 1187649702,
 70321,
 1187858128,
 1187538678,
 -1,
 -47410,
 1187800852,
 70339,
 -47409,
 1187861006,
 70340,
 -1,
 1187911846,
 70338,
 1188120276,
 1187794196,
 -1,
 -47406,
 1188057614,
 70334,
 -47405,
 1188121955,
 70333,
 -1,
 1188173990,
 70332,
 1188382424,
 1188046116,
 -1,
 -47402,
 1188319758,
 70358,
 -47401,
 1188373849,
 70357,
 -1,
 1188436134,
 70356,
 1188644570,
 1188347675,
 70324,
 -1,
 1188609819,
 70325,
 1188775645,
 1188604069,
 -1,
 -47396,
 1188712974,
 70364,
 -1,
 1188763814,
 70365,
 1188972256,
 1188731983,
 -1,
 -47393,
 1188928707,
 70346,
 -1,
 1188960422,
 70361,
 1189168867,
 1188926246,
 -1,
 -47390,
 1189106190,
 70355,
 -1,
 1189157030,
 70354,
 1189365478,
 1189111837,
 -1,
 -47387,
 1189302798,
 70331,
 -1,
 1189353638,
 70330,
 1189562088,
 1189304899,
 70322,
 -1,
 1189501507,
 70323,
 1189693163,
 1189489305,
 -1,
 -47382,
 1189630478,
 70337,
 -1,
 1189681318,
 70336,
 -47380,
 1189663451,
 70360,
 -47379,
 1189856947,
 70363,
 -47378,
 1189905854,
 70328,
 -47377,
 1189967714,
 70359,
 -47376,
 1190030301,
 70362,
 -47375,
 1190089230,
 70366,
 -1,
 1190149294,
 70326,
 1190348544,
 1186281370,
 -1,
 1190414070,
 1190311045,
 -1,
 -47371,
 1190383563,
 70386,
 -1,
 1190418651,
 70387,
 1190610681,
 1190373541,
 -1,
 -47368,
 1190553207,
 70390,
 -1,
 1190610414,
 70391,
 1190807292,
 1190545358,
 -1,
 -47365,
 1190760296,
 70388,
 -1,
 1190815187,
 70389,
 -47363,
 1190778238,
 70384,
 -47362,
 1190955448,
 70385,
 -47361,
 1191019099,
 70393,
 -1,
 1191067758,
 70392,
 1191266059,
 1190316698,
 -1,
 1191331589,
 1191188646,
 -1,
 -47357,
 1191296795,
 70376,
 -47356,
 1191336515,
 70374,
 -1,
 1191385254,
 70368,
 1191593735,
 1191296795,
 70371,
 -1,
 1191558939,
 70372,
 1191724809,
 1191533123,
 70369,
 -1,
 1191664195,
 70370,
 -47350,
 1191675326,
 70375,
 -1,
 1191787694,
 70373,
 1192034303,
 1191226742,
 -1,
 -47347,
 1191954826,
 70378,
 -47346,
 1192002799,
 70377,
 -1,
 1192042546,
 70367,
 1192249196,
 1186210220,
 -1,
 1192314687,
 1192194430,
 -1,
 1192380184,
 1192277125,
 -1,
 1192445718,
 1192342661,
 -1,
 -47340,
 1192408923,
 68147,
 -47339,
 1192448526,
 68123,
 -1,
 1192499366,
 68122,
 -47337,
 1192382990,
 68128,
 -1,
 1192630438,
 68127,
 1192838942,
 1192309944,
 -1,
 1192904476,
 1192768696,
 -1,
 -47333,
 1192841742,
 68125,
 -1,
 1192892582,
 68124,
 -47331,
 1192841742,
 68130,
 -1,
 1193023654,
 68129,
 1193232162,
 1192798373,
 -1,
 -47328,
 1193191728,
 68142,
 -47327,
 1193234958,
 68141,
 -1,
 1193285798,
 68143,
 1193494310,
 1193180986,
 -1,
 -47324,
 1193464539,
 68121,
 -47323,
 1193508752,
 68126,
 -1,
 1193547942,
 68131,
 1193756458,
 1193437213,
 -1,
 -47320,
 1193699439,
 68146,
 -47319,
 1193759246,
 68113,
 -1,
 1193810086,
 68112,
 1194018605,
 1193710374,
 -1,
 -47316,
 1193955854,
 68133,
 -1,
 1194006694,
 68132,
 1194215216,
 1193954580,
 -1,
 -47313,
 1194152462,
 68115,
 -1,
 1194203302,
 68114,
 1194411827,
 1194142361,
 -1,
 -47310,
 1194349070,
 68118,
 -1,
 1194399910,
 68117,
 1194608438,
 1194337572,
 -1,
 -47307,
 1194545678,
 68135,
 -1,
 1194596518,
 68134,
 -47305,
 1194579157,
 68144,
 -47304,
 1194775259,
 68137,
 -47303,
 1194837683,
 68140,
 -47302,
 1194892483,
 68138,
 -47301,
 1194948450,
 68136,
 -47300,
 1195011037,
 68139,
 -47299,
 1195075348,
 68119,
 -47298,
 1195135502,
 68145,
 -1,
 1195186342,
 68096,
 1195394893,
 1192270364,
 -1,
 1195460421,
 1195324600,
 -1,
 1195525956,
 1195410878,
 -1,
 -47293,
 1195491399,
 68183,
 -1,
 1195553925,
 68176,
 -1,
 1195450169,
 68182,
 1195788104,
 1195404207,
 -1,
 -47289,
 1195740908,
 68181,
 -1,
 1195794461,
 68184,
 1195984715,
 1195715225,
 -1,
 -47286,
 1195942142,
 68179,
 -1,
 1195992031,
 68178,
 -47284,
 1195945741,
 68177,
 -1,
 1196128502,
 68180,
 1196312407,
 1195361949,
 -1,
 1196377942,
 1196266144,
 -1,
 1196443477,
 1196338550,
 -1,
 -47279,
 1196411361,
 68099,
 -47278,
 1196474139,
 68098,
 -47277,
 1196524990,
 68102,
 -47276,
 1196579395,
 68097,
 -1,
 1196637358,
 68101,
 -1,
 1196388673,
 68108,
 -1,
 1196319705,
 68159,
 1196967775,
 1196273014,
 -1,
 1197033307,
 1196898413,
 -1,
 -47270,
 1196998791,
 68109,
 -1,
 1197061277,
 68154,
 -47268,
 1197001105,
 68111,
 -47267,
 1197157430,
 68153,
 -47266,
 1197221334,
 68152,
 -1,
 1197285426,
 68110,
 1197492070,
 1196918009,
 -1,
 1197557603,
 1197454469,
 -1,
 -47262,
 1197526153,
 68165,
 -1,
 1197556106,
 68164,
 1197801471,
 1197509052,
 -1,
 -47259,
 1197717515,
 68167,
 -1,
 1197758940,
 68166,
 1197998079,
 1197422490,
 -1,
 1198016362,
 1197913221,
 -1,
 -47255,
 1197985739,
 68161,
 -1,
 1198020827,
 68162,
 -47253,
 1197967800,
 68160,
 -1,
 1198148452,
 68163,
 1198391295,
 1192200134,
 -1,
 1198409637,
 1198289278,
 -1,
 1198475125,
 1198339256,
 -1,
 1198540659,
 1198404792,
 -1,
 -47247,
 1198477838,
 70167,
 -47246,
 1198536006,
 70172,
 -1,
 1198594214,
 70166,
 -47244,
 1198477838,
 70173,
 -1,
 1198725286,
 70171,
 1198933883,
 1198437509,
 -1,
 1198999417,
 1198896261,
 -1,
 -47240,
 1198936590,
 70165,
 -1,
 1198987430,
 70164,
 -47238,
 1198936590,
 70170,
 -1,
 1199118502,
 70169,
 1199327104,
 1198882618,
 -1,
 -47235,
 1199297243,
 70163,
 -47234,
 1199341456,
 70168,
 -47233,
 1199394147,
 70157,
 -1,
 1199446182,
 70174,
 1199654788,
 1199249574,
 70144,
 -47230,
 1199619867,
 70151,
 -47229,
 1199659587,
 70149,
 -1,
 1199708326,
 70145,
 1199916936,
 1199590676,
 -1,
 -47226,
 1199854094,
 70156,
 -47225,
 1199918435,
 70155,
 -1,
 1199970470,
 70154,
 1200179084,
 1199842596,
 -1,
 -47222,
 1200116238,
 70179,
 -47221,
 1200170329,
 70178,
 -1,
 1200232614,
 70177,
 1200441231,
 1200132902,
 -1,
 -47218,
 1200378382,
 70176,
 -1,
 1200429222,
 70175,
 1200637842,
 1200384943,
 -1,
 -47215,
 1200581597,
 70187,
 -1,
 1200625830,
 70183,
 1200834453,
 1200580637,
 -1,
 -47212,
 1200771598,
 70153,
 -1,
 1200822438,
 70152,
 1201031064,
 1200776950,
 -1,
 -47209,
 1200973588,
 70161,
 -1,
 1201019046,
 70160,
 1201227675,
 1200958105,
 -1,
 -47206,
 1201164814,
 70159,
 -1,
 1201215654,
 70158,
 -47204,
 1201197787,
 70181,
 -47203,
 1201391283,
 70184,
 -47202,
 1201454875,
 70147,
 -47201,
 1201514800,
 70185,
 -47200,
 1201577155,
 70182,
 -47199,
 1201636798,
 70150,
 -47198,
 1201698658,
 70180,
 -47197,
 1201756739,
 70146,
 -47196,
 1201820174,
 70186,
 -1,
 1201880238,
 70148,
 1202079663,
 1198377626,
 -1,
 1202145194,
 1202002086,
 -1,
 -47192,
 1202110235,
 70195,
 -47191,
 1202149955,
 70193,
 -1,
 1202198694,
 70188,
 1202407340,
 1202084419,
 70189,
 -1,
 1202346563,
 70190,
 -47187,
 1202372379,
 70191,
 -47186,
 1202488766,
 70194,
 -1,
 1202535598,
 70192,
 1202735030,
 1202038949,
 -1,
 1202800565,
 1202675137,
 -1,
 -47182,
 1202768266,
 70197,
 -47181,
 1202826101,
 70199,
 -47180,
 1202881775,
 70198,
 -1,
 1202921522,
 70196,
 -1,
 1202732736,
 70203,
 1203193787,
 1202664632,
 -1,
 1203259322,
 1203146484,
 -1,
 -47175,
 1203219034,
 70204,
 -1,
 1203254706,
 70201,
 -1,
 1203183417,
 70200,
 -47172,
 1203163427,
 70202,
 -1,
 1203444156,
 70205,
 1203652720,
 1177426086,
 -1,
 1203718166,
 1203594643,
 -1,
 1203783674,
 1203663230,
 -1,
 1203849159,
 1203713208,
 -1,
 1203914693,
 1203778744,
 -1,
 -47165,
 1203851790,
 69787,
 -47164,
 1203910385,
 69786,
 -1,
 1203968166,
 69785,
 -47162,
 1203851790,
 69793,
 -1,
 1204099238,
 69792,
 1204307917,
 1203811461,
 -1,
 1204373451,
 1204270213,
 -1,
 -47158,
 1204310542,
 69784,
 -1,
 1204361382,
 69783,
 -47156,
 1204310542,
 69791,
 -1,
 1204492454,
 69790,
 1204701138,
 1204256570,
 -1,
 -47153,
 1204671195,
 69782,
 -47152,
 1204715408,
 69789,
 -47151,
 1204768099,
 69777,
 -1,
 1204820134,
 69794,
 1205028822,
 1204623526,
 69763,
 -47148,
 1204993819,
 69772,
 -47147,
 1205033539,
 69770,
 -1,
 1205082278,
 69764,
 1205290970,
 1204988069,
 -1,
 -47144,
 1205250352,
 69805,
 -47143,
 1205293582,
 69804,
 -1,
 1205344422,
 69806,
 1205553116,
 1205255963,
 69767,
 -1,
 1205518107,
 69768,
 1205684191,
 1205509199,
 -1,
 -47138,
 1205621262,
 69788,
 -1,
 1205672102,
 69801,
 1205880802,
 1205637926,
 -1,
 -47135,
 1205817870,
 69796,
 -1,
 1205868710,
 69795,
 1206077413,
 1205823517,
 -1,
 -47132,
 1206014478,
 69774,
 -1,
 1206065318,
 69773,
 1206274024,
 1206019830,
 -1,
 -47129,
 1206211086,
 69781,
 -1,
 1206261926,
 69780,
 1206470634,
 1206213187,
 69765,
 -1,
 1206409795,
 69766,
 1206601709,
 1206406420,
 -1,
 -47124,
 1206538766,
 69776,
 -1,
 1206589606,
 69775,
 1206798320,
 1206528665,
 -1,
 -47121,
 1206735374,
 69779,
 -1,
 1206786214,
 69778,
 1206994931,
 1206723876,
 -1,
 -47118,
 1206931982,
 69798,
 -1,
 1206982822,
 69797,
 -47116,
 1206964955,
 69800,
 -47115,
 1207158451,
 69803,
 -47114,
 1207207358,
 69771,
 -47113,
 1207269218,
 69799,
 -47112,
 1207331805,
 69802,
 -47111,
 1207390734,
 69807,
 -1,
 1207450798,
 69769,
 1207650309,
 1203751578,
 -1,
 1207715839,
 1207572646,
 -1,
 -47107,
 1207680795,
 69816,
 -47106,
 1207720515,
 69814,
 -1,
 1207769254,
 69808,
 1207977985,
 1207680795,
 69811,
 -1,
 1207942939,
 69812,
 1208109059,
 1207917123,
 69809,
 -1,
 1208048195,
 69810,
 -47100,
 1208059326,
 69815,
 -1,
 1208171694,
 69813,
 1208371214,
 1207609509,
 -1,
 1208436749,
 1208311233,
 -1,
 1208502282,
 1208404305,
 -1,
 -47095,
 1208461787,
 69762,
 -1,
 1208524277,
 69817,
 -47093,
 1208452335,
 69818,
 -47092,
 1208626010,
 69760,
 -1,
 1208688690,
 69761,
 -1,
 1208368832,
 69822,
 1208961043,
 1208300728,
 -1,
 1209026578,
 1208913652,
 -1,
 -47087,
 1208986202,
 69823,
 -1,
 1209021874,
 69825,
 -1,
 1208950585,
 69824,
 -47084,
 1208911105,
 69821,
 -47083,
 1209221885,
 69820,
 -1,
 1209276860,
 69819,
 1209485398,
 1203688166,
 -1,
 1209550907,
 1209430398,
 -1,
 1209616412,
 1209499450,
 -1,
 -47078,
 1209586395,
 43281,
 -47077,
 1209617763,
 43277,
 -1,
 1209669798,
 43284,
 1209878559,
 1209578629,
 -1,
 -47074,
 1209815566,
 43294,
 -1,
 1209866406,
 43282,
 1210075170,
 1209837733,
 -1,
 -47071,
 1210012174,
 43279,
 -1,
 1210063014,
 43278,
 1210271781,
 1210028838,
 -1,
 -47068,
 1210208782,
 43286,
 -1,
 1210259622,
 43285,
 1210468392,
 1210222014,
 -1,
 -47065,
 1210418622,
 43301,
 -1,
 1210465454,
 43299,
 1210665003,
 1210411037,
 -1,
 -47062,
 1210601998,
 43275,
 -1,
 1210652838,
 43274,
 1210861614,
 1210601976,
 -1,
 -47059,
 1210823943,
 43283,
 -1,
 1210849446,
 43295,
 -47057,
 1210832085,
 43280,
 -47056,
 1211028187,
 43291,
 -47055,
 1211091790,
 43293,
 -47054,
 1211156147,
 43296,
 -47053,
 1211210947,
 43290,
 -47052,
 1211266914,
 43287,
 -47051,
 1211329501,
 43292,
 -47050,
 1211390531,
 43300,
 -47049,
 1211452771,
 43276,
 -47048,
 1211512134,
 43288,
 -47047,
 1211574983,
 43297,
 -47046,
 1211639129,
 43289,
 -1,
 1211701414,
 43298,
 1211910217,
 1209481114,
 -1,
 1211975743,
 1211872389,
 -1,
 -47042,
 1211944907,
 43266,
 -1,
 1211979995,
 43267,
 1212172354,
 1211934885,
 -1,
 -47039,
 1212114551,
 43270,
 -1,
 1212171758,
 43271,
 1212368965,
 1212106702,
 -1,
 -47036,
 1212321640,
 43268,
 -1,
 1212376531,
 43269,
 -47034,
 1212339582,
 43264,
 -47033,
 1212516792,
 43265,
 -47032,
 1212580443,
 43273,
 -1,
 1212629102,
 43272,
 1212827727,
 1211877993,
 -1,
 1212893260,
 1212792603,
 43304,
 -1,
 1212824750,
 43302,
 1213024334,
 1212824750,
 43303,
 -1,
 1212955822,
 43305,
 -1,
 1212974526,
 43306,
 1213220947,
 1212791491,
 -1,
 1213286482,
 1213147923,
 43308,
 -1,
 1213204169,
 43309,
 -1,
 1213241154,
 43307,
 1213530111,
 1213181302,
 -1,
 -47019,
 1213443324,
 43311,
 -1,
 1213478048,
 43310,
 1213679717,
 1209447834,
 -1,
 1213745245,
 1213605821,
 -1,
 -47015,
 1213710107,
 983973,
 -47014,
 1213760958,
 983975,
 -47013,
 1213815363,
 983972,
 -47012,
 1213873326,
 983974,
 -1,
 1213929638,
 983971,
 1214185471,
 1213667494,
 -1,
 1214204004,
 1214079625,
 -1,
 1214269538,
 1214166149,
 -1,
 -47007,
 1214234395,
 983977,
 -1,
 1214285246,
 983978,
 -47005,
 1214223142,
 983979,
 -1,
 1214393440,
 983976,
 -1,
 1214160593,
 110592,
 1214662767,
 1213629194,
 -1,
 1214728300,
 1214623094,
 -1,
 -47000,
 1214694457,
 3314,
 -46999,
 1214743791,
 3260,
 -46998,
 1214801815,
 3313,
 -46997,
 1214851930,
 3201,
 -1,
 1214915728,
 3261,
 1215121518,
 1214696136,
 3298,
 -1,
 1215065007,
 3299,
 -1,
 1215066512,
 983203,
 -1,
 1214585224,
 128331,
 1215383674,
 1203591747,
 -1,
 1215449209,
 1215344942,
 128143,
 1215514744,
 1215389758,
 -1,
 1215580279,
 1215449126,
 128535,
 1215692799,
 1215499016,
 -1,
 -46986,
 1215606715,
 128537,
 -1,
 1215639510,
 128538,
 -1,
 1215507457,
 128573,
 -1,
 1215431805,
 128139,
 -1,
 1215397284,
 128088,
 1216039037,
 1215317959,
 128273,
 -46980,
 1215966072,
 128287,
 -1,
 1216030921,
 128422,
 -1,
 1215989238,
 128040,
 1216301714,
 1177367736,
 -1,
 1216366919,
 1216251326,
 -1,
 1216432375,
 1216314586,
 -1,
 1216497852,
 1216399433,
 -1,
 1216563387,
 1216417261,
 -1,
 1216628875,
 1216484934,
 -1,
 -46971,
 1216550286,
 127123,
 -46970,
 1216615577,
 127122,
 -46969,
 1216680901,
 127121,
 -46968,
 1216746151,
 127120,
 -46967,
 1216811394,
 127119,
 -46966,
 1216876635,
 127118,
 -1,
 1216941906,
 127117,
 1217153171,
 1216550243,
 -1,
 -46963,
 1217074574,
 127116,
 -46962,
 1217139865,
 127115,
 -46961,
 1217205189,
 127114,
 -46960,
 1217270439,
 127113,
 -46959,
 1217335682,
 127112,
 -46958,
 1217400923,
 127111,
 -1,
 1217466194,
 127110,
 1217677467,
 1217074298,
 -1,
 -46955,
 1217598862,
 127109,
 -46954,
 1217664153,
 127108,
 -46953,
 1217729477,
 127107,
 -46952,
 1217794727,
 127106,
 -46951,
 1217859970,
 127105,
 -46950,
 1217925211,
 127104,
 -1,
 1217990482,
 127103,
 1218201763,
 1217598360,
 -1,
 -46947,
 1218123150,
 127102,
 -46946,
 1218188441,
 127101,
 -46945,
 1218253765,
 127100,
 -46944,
 1218319015,
 127099,
 -46943,
 1218384258,
 127098,
 -46942,
 1218449499,
 127097,
 -1,
 1218514770,
 127096,
 1218726059,
 1218122349,
 -1,
 -46939,
 1218647438,
 127095,
 -46938,
 1218712729,
 127094,
 -46937,
 1218778053,
 127093,
 -46936,
 1218843303,
 127092,
 -46935,
 1218908546,
 127091,
 -46934,
 1218973787,
 127090,
 -1,
 1219039058,
 127089,
 1219250355,
 1218646355,
 -1,
 -46931,
 1219171726,
 127088,
 -46930,
 1219237017,
 127087,
 -46929,
 1219302341,
 127086,
 -46928,
 1219367591,
 127085,
 -46927,
 1219432834,
 127084,
 -46926,
 1219498075,
 127083,
 -1,
 1219563346,
 127082,
 1219821567,
 1219170357,
 -1,
 -46923,
 1219696014,
 127081,
 -46922,
 1219761305,
 127080,
 -46921,
 1219826629,
 127079,
 -46920,
 1219891879,
 127078,
 -46919,
 1219957122,
 127077,
 -46918,
 1220022363,
 127076,
 -1,
 1220087634,
 127075,
 -1,
 1216479572,
 127074,
 1220411391,
 1216436189,
 -1,
 1220430070,
 1220283885,
 -1,
 1220495558,
 1220351558,
 -1,
 -46912,
 1220416910,
 127073,
 -46911,
 1220482201,
 127072,
 -46910,
 1220547525,
 127071,
 -46909,
 1220612775,
 127070,
 -46908,
 1220678018,
 127069,
 -46907,
 1220743259,
 127068,
 -1,
 1220808530,
 127067,
 1221019854,
 1220416867,
 -1,
 -46904,
 1220941198,
 127066,
 -46903,
 1221006489,
 127065,
 -46902,
 1221071813,
 127064,
 -46901,
 1221137063,
 127063,
 -46900,
 1221202306,
 127062,
 -46899,
 1221267547,
 127061,
 -1,
 1221332818,
 127060,
 1221544150,
 1220940922,
 -1,
 -46896,
 1221465486,
 127059,
 -46895,
 1221530777,
 127058,
 -46894,
 1221596101,
 127057,
 -46893,
 1221661351,
 127056,
 -46892,
 1221726594,
 127055,
 -46891,
 1221791835,
 127054,
 -1,
 1221857106,
 127053,
 1222068446,
 1221464984,
 -1,
 -46888,
 1221989774,
 127052,
 -46887,
 1222055065,
 127051,
 -46886,
 1222120389,
 127050,
 -46885,
 1222185639,
 127049,
 -46884,
 1222250882,
 127048,
 -46883,
 1222316123,
 127047,
 -1,
 1222381394,
 127046,
 1222592742,
 1221988973,
 -1,
 -46880,
 1222514062,
 127045,
 -46879,
 1222579353,
 127044,
 -46878,
 1222644677,
 127043,
 -46877,
 1222709927,
 127042,
 -46876,
 1222775170,
 127041,
 -46875,
 1222840411,
 127040,
 -1,
 1222905682,
 127039,
 1223117038,
 1222512979,
 -1,
 -46872,
 1223038350,
 127038,
 -46871,
 1223103641,
 127037,
 -46870,
 1223168965,
 127036,
 -46869,
 1223234215,
 127035,
 -46868,
 1223299458,
 127034,
 -46867,
 1223364699,
 127033,
 -1,
 1223429970,
 127032,
 1223688191,
 1223036981,
 -1,
 -46864,
 1223562638,
 127031,
 -46863,
 1223627929,
 127030,
 -46862,
 1223693253,
 127029,
 -46861,
 1223758503,
 127028,
 -46860,
 1223823746,
 127027,
 -46859,
 1223888987,
 127026,
 -1,
 1223954258,
 127025,
 -1,
 1220346196,
 127024,
 1224231209,
 1216401278,
 -1,
 1224296742,
 1224199075,
 -1,
 1224362255,
 1224258693,
 -1,
 1224427790,
 1224319484,
 -1,
 1224493325,
 1224347216,
 -1,
 1224558858,
 1224417764,
 11107,
 1224671231,
 1224474624,
 -1,
 1224689928,
 1224592993,
 -1,
 1224755458,
 1224635644,
 -1,
 -46847,
 1224713215,
 11169,
 -1,
 1224765531,
 11168,
 -46845,
 1224722669,
 129075,
 -46844,
 1224900568,
 129059,
 -46843,
 1224964744,
 129063,
 -46842,
 1225020587,
 129071,
 -46841,
 1225079364,
 11133,
 -1,
 1225140495,
 129067,
 -46839,
 1224653446,
 11123,
 -1,
 1225289948,
 11139,
 -46837,
 1224529396,
 11085,
 -46836,
 1225429958,
 11143,
 -1,
 1225471444,
 11117,
 -1,
 1224409389,
 129171,
 -1,
 1224396958,
 11247,
 1225804057,
 1224284326,
 -1,
 1225869592,
 1225762709,
 -1,
 1225935124,
 1225830071,
 -1,
 -46829,
 1225899019,
 129027,
 -1,
 1225933689,
 129043,
 -46827,
 1225884574,
 129179,
 -46826,
 1226078883,
 129031,
 -46825,
 1226140963,
 129035,
 -1,
 1226195833,
 129047,
 -1,
 1225818138,
 11796,
 1226459420,
 1225762981,
 -1,
 -46821,
 1226414963,
 129083,
 -1,
 1226448879,
 129107,
 1226656031,
 1226396819,
 -1,
 -46818,
 1226584317,
 129091,
 -1,
 1226645988,
 129095,
 1226852642,
 1226582062,
 -1,
 -46815,
 1226780355,
 11147,
 -1,
 1226842596,
 11015,
 -46813,
 1226820901,
 129175,
 -46812,
 1227007574,
 128623,
 -46811,
 1227049347,
 129079,
 -1,
 1227108605,
 129087,
 1227358207,
 1224216258,
 -1,
 -46808,
 1227272017,
 128317,
 -1,
 1227333655,
 128315,
 1227508022,
 1224195867,
 -1,
 1227573557,
 1227434084,
 -1,
 1227639089,
 1227489280,
 -1,
 -46803,
 1227606098,
 9208,
 -46802,
 1227654672,
 11799,
 -46801,
 1227716052,
 11842,
 -46800,
 1227774524,
 11840,
 -1,
 1227830364,
 10175,
 1228032308,
 1227568314,
 -1,
 -46797,
 1227978756,
 9891,
 -1,
 1228032184,
 9890,
 -1,
 1227951916,
 8508,
 -1,
 1227509626,
 127849,
 1228359996,
 1227472183,
 -1,
 -46792,
 1228323773,
 11784,
 -46791,
 1228386522,
 11034,
 -46790,
 1228448699,
 11798,
 -46789,
 1228506627,
 11795,
 -1,
 1228550866,
 8284,
 1228753217,
 1228289048,
 128462,
 1228865535,
 1228671752,
 -1,
 1228884288,
 1228781385,
 128441,
 -1,
 1228800164,
 128442,
 -1,
 1228838526,
 128443,
 1229080899,
 1228688660,
 128021,
 -1,
 1228997346,
 128054,
 -46780,
 1229047704,
 128330,
 -46779,
 1229163731,
 128682,
 -46778,
 1229223513,
 128044,
 -1,
 1229259981,
 128687,
 1229474287,
 1216332869,
 -1,
 1229539777,
 1229418878,
 -1,
 1229605221,
 1229498533,
 113692,
 1229670744,
 1229520896,
 -1,
 1229736269,
 1229639278,
 113701,
 -1,
 1229652335,
 113702,
 1229867343,
 1229698181,
 113714,
 -1,
 1229785167,
 113715,
 1229998417,
 1229820710,
 113716,
 -1,
 1229916239,
 113717,
 1230129491,
 1229940765,
 113727,
 -1,
 1230047311,
 113728,
 1230260565,
 1230071542,
 113696,
 -1,
 1230178453,
 113710,
 -46762,
 1230219429,
 113706,
 -46761,
 1230339898,
 113723,
 -1,
 1230403340,
 113724,
 1230588260,
 1229616283,
 -1,
 1230653789,
 1230519470,
 -1,
 -46757,
 1230602042,
 113767,
 -46756,
 1230655992,
 113740,
 -1,
 1230716078,
 113742,
 1230915936,
 1230603710,
 -1,
 -46753,
 1230883598,
 113730,
 -1,
 1230929722,
 113769,
 -46751,
 1230880539,
 113752,
 -46750,
 1231054582,
 113685,
 -46749,
 1231107822,
 113682,
 -1,
 1231167145,
 113768,
 -1,
 1230526554,
 113737,
 1231440240,
 1229553466,
 113690,
 1231505771,
 1231364734,
 -1,
 -46744,
 1231470363,
 113761,
 -46743,
 1231521214,
 113762,
 -46742,
 1231575619,
 113763,
 -1,
 1231624358,
 113764,
 1231880191,
 1231421440,
 -1,
 1231898990,
 1231779596,
 113694,
 -1,
 1231816853,
 113708,
 -46737,
 1231867502,
 113698,
 -1,
 1231988901,
 113704,
 1232161146,
 1231382262,
 113691,
 1232273407,
 1232076800,
 -1,
 1232292212,
 1232195182,
 113699,
 -1,
 1232251082,
 113700,
 1232423286,
 1232251045,
 113705,
 -1,
 1232341965,
 113711,
 1232554360,
 1232371514,
 113712,
 -1,
 1232472213,
 113713,
 1232732159,
 1232500492,
 113695,
 -1,
 1232603285,
 113709,
 1232816514,
 1232128782,
 113720,
 1232882045,
 1232766398,
 113757,
 -1,
 1232849678,
 113760,
 -46722,
 1232820803,
 113758,
 -46721,
 1232949752,
 113721,
 -46720,
 1233010787,
 113759,
 -46719,
 1233066150,
 113756,
 -1,
 1233127503,
 113722,
 1233340808,
 1232772175,
 113675,
 1233406342,
 1233291487,
 -1,
 -46715,
 1233370907,
 113750,
 -1,
 1233410627,
 113741,
 -46713,
 1233342968,
 113688,
 -1,
 1233520789,
 113680,
 1233734029,
 1233290686,
 113732,
 -46710,
 1233701646,
 113754,
 -46709,
 1233764123,
 113755,
 -46708,
 1233815408,
 113753,
 -1,
 1233852582,
 113731,
 1234061715,
 1233680140,
 113689,
 1234173951,
 1233977344,
 -1,
 1234192785,
 1234075450,
 113693,
 -1,
 1234110613,
 113707,
 -46702,
 1234161262,
 113697,
 -1,
 1234282661,
 113703,
 1234454935,
 1234026267,
 113745,
 -46699,
 1234393667,
 113738,
 -46698,
 1234457080,
 113751,
 -1,
 1234502854,
 113748,
 1234717084,
 1234416773,
 113667,
 1234782619,
 1234632704,
 -1,
 -46694,
 1234741413,
 113718,
 -1,
 1234803848,
 113719,
 -1,
 1234719224,
 113681,
 1235044769,
 1234670374,
 113666,
 1235110304,
 1234977856,
 -1,
 -46689,
 1235058490,
 113765,
 -1,
 1235121932,
 113766,
 -1,
 1235027142,
 113676,
 1235372454,
 1234987951,
 113670,
 1235437989,
 1235323481,
 -1,
 -46684,
 1235402523,
 113749,
 -1,
 1235442243,
 113743,
 -1,
 1235374584,
 113687,
 1235700139,
 1235314717,
 113669,
 1235765674,
 1235615744,
 -1,
 -46679,
 1235721352,
 113725,
 -1,
 1235777292,
 113679,
 -1,
 1235707933,
 113684,
 1236027822,
 1235631278,
 113735,
 -46675,
 1235992347,
 113746,
 -1,
 1236024494,
 113739,
 1236224433,
 1235956920,
 113672,
 -46672,
 1236161016,
 113683,
 -1,
 1236207765,
 113677,
 1236421043,
 1236193694,
 113665,
 -1,
 1236388622,
 113747,
 1236552117,
 1236387485,
 113673,
 -1,
 1236502086,
 113770,
 1236683191,
 1236490819,
 113734,
 -1,
 1236614318,
 113736,
 1236814265,
 1236619768,
 113664,
 -1,
 1236757423,
 113686,
 1236945339,
 1236749588,
 113674,
 -1,
 1236863058,
 113726,
 1237076413,
 1236879310,
 113668,
 -1,
 1236993222,
 113678,
 1237207487,
 1236998310,
 113729,
 -1,
 1237159665,
 113733,
 -46656,
 1237177168,
 113744,
 -1,
 1237263652,
 113671,
 1237469675,
 1229462479,
 -1,
 1237535186,
 1237412783,
 -1,
 1237600721,
 1237488209,
 -1,
 1237666246,
 1237567561,
 113816,
 -1,
 1237584054,
 113779,
 1237797321,
 1237609391,
 -1,
 -46648,
 1237748345,
 113811,
 -1,
 1237803025,
 113814,
 1237993932,
 1237719206,
 -1,
 -46645,
 1237952382,
 113817,
 -1,
 1237988501,
 113808,
 -46643,
 1237961747,
 113815,
 -46642,
 1238153519,
 113809,
 -46641,
 1238192383,
 113810,
 -46640,
 1238251678,
 113812,
 -1,
 1238314581,
 113813,
 -1,
 1237532642,
 113776,
 1238583774,
 1237472746,
 -1,
 1238649301,
 1238550601,
 113800,
 -1,
 1238567094,
 113781,
 1238780376,
 1238592431,
 -1,
 -46633,
 1238731385,
 113795,
 -1,
 1238786065,
 113798,
 -46631,
 1238748179,
 113799,
 -46630,
 1238939951,
 113793,
 -46629,
 1238978815,
 113794,
 -46628,
 1239038110,
 113796,
 -46627,
 1239101013,
 113797,
 -1,
 1239161525,
 113792,
 1239370215,
 1238508540,
 -1,
 1239435747,
 1239332103,
 -1,
 1239501282,
 1239384554,
 113784,
 -1,
 1239417687,
 113788,
 -1,
 1239440895,
 113785,
 -46620,
 1239394884,
 113782,
 -46619,
 1239642182,
 113783,
 -46618,
 1239702095,
 113787,
 -1,
 1239760114,
 113786,
 1239960042,
 1239317411,
 -1,
 -46615,
 1239926938,
 113780,
 -1,
 1239963659,
 113777,
 -1,
 1239917289,
 113778,
 -46612,
 1237432250,
 113821,
 -46611,
 1240182163,
 113820,
 -46610,
 1240242748,
 113823,
 -1,
 1240283741,
 113822,
 1240484416,
 1229405358,
 -1,
 1240549928,
 1240450717,
 -1,
 1240615457,
 1240473282,
 -1,
 1240680965,
 1240559998,
 -1,
 1240746486,
 1240645403,
 -1,
 -46603,
 1240711510,
 2423,
 -1,
 1240743086,
 2422,
 1240943097,
 1240696254,
 -1,
 -46600,
 1240893148,
 2420,
 -1,
 1240939694,
 2419,
 1241139708,
 1240878356,
 -1,
 -46597,
 1241085271,
 2429,
 -1,
 1241140579,
 2427,
 -46595,
 1241109973,
 2425,
 -46594,
 1241296028,
 2308,
 -46593,
 1241348479,
 2424,
 -46592,
 1241409443,
 2428,
 -46591,
 1241470135,
 2426,
 -46590,
 1241527805,
 2430,
 -46589,
 1241590595,
 2418,
 -46588,
 1241654916,
 2431,
 -1,
 1241720014,
 2421,
 1241926163,
 1240640886,
 -1,
 1241991692,
 1241852774,
 -1,
 1242057226,
 1241953413,
 -1,
 -46583,
 1242025931,
 43253,
 -1,
 1242061019,
 43254,
 -46581,
 1242024330,
 43251,
 -1,
 1242178704,
 43255,
 1242384911,
 1241950373,
 -1,
 -46578,
 1242338218,
 43250,
 -1,
 1242389495,
 43260,
 -46576,
 1242339952,
 43256,
 -46575,
 1242522307,
 2304,
 -46574,
 1242584581,
 2417,
 -1,
 1242642898,
 43252,
 1242843677,
 1241893530,
 -1,
 1242909207,
 1242808091,
 -1,
 -46570,
 1242874198,
 2391,
 -1,
 1242905774,
 2390,
 1243105818,
 1242858942,
 -1,
 -46567,
 1243055836,
 2363,
 -1,
 1243102382,
 2362,
 -46565,
 1243060637,
 2382,
 -46564,
 1243229004,
 2389,
 -1,
 1243292878,
 2383,
 -46562,
 1242785572,
 43261,
 -46561,
 1243436137,
 43259,
 -46560,
 1243500035,
 43257,
 -1,
 1243556797,
 43258,
 1243807743,
 1240554373,
 -1,
 1243826725,
 1243722885,
 -1,
 -46556,
 1243795403,
 983085,
 -1,
 1243830491,
 983087,
 -46554,
 1243787999,
 983160,
 -46553,
 1243974072,
 983083,
 -1,
 1244023652,
 983089,
 1244219958,
 1240508581,
 -1,
 1244285491,
 1244152719,
 -1,
 1244351025,
 1244218602,
 -1,
 1244416558,
 1244311349,
 -1,
 -46547,
 1244366733,
 66638,
 -1,
 1244415665,
 66639,
 1244659711,
 1244343193,
 -1,
 -46544,
 1244563341,
 66598,
 -1,
 1244612273,
 66599,
 1244856319,
 1244312709,
 127964,
 -1,
 1244726170,
 127965,
 1244987391,
 1244228430,
 -1,
 -46539,
 1244909085,
 128468,
 -1,
 1244934414,
 128421,
 1245137465,
 1244162991,
 983119,
 -46536,
 1245079127,
 128666,
 -1,
 1245136127,
 983118,
 1245334078,
 1245063833,
 -1,
 1245399613,
 1245272643,
 -1,
 -46532,
 1245345776,
 9192,
 -1,
 1245396074,
 127795,
 -1,
 1245355869,
 128475,
 -46529,
 1245290657,
 127962,
 -1,
 1245615319,
 127980,
 1245792886,
 1240422979,
 -1,
 1245858400,
 1245728020,
 -1,
 1245923922,
 1245799702,
 -1,
 1245989446,
 1245894019,
 -1,
 -46523,
 1245924611,
 127232,
 -1,
 1245982910,
 127233,
 1246186057,
 1245951109,
 -1,
 -46520,
 1246154715,
 127235,
 -1,
 1246189809,
 127236,
 1246382668,
 1246144677,
 -1,
 -46517,
 1246324350,
 127239,
 -1,
 1246381561,
 127240,
 1246579279,
 1246316494,
 -1,
 -46514,
 1246531441,
 127237,
 -1,
 1246586332,
 127238,
 -46512,
 1246529985,
 127234,
 -46511,
 1246724704,
 127242,
 -1,
 1246773371,
 127241,
 1247019007,
 1245879788,
 -1,
 1247038039,
 1246903804,
 119557,
 1247150079,
 1246983935,
 -1,
 -46506,
 1247068728,
 119556,
 -1,
 1247100528,
 119555,
 1247300186,
 1246982505,
 -1,
 -46503,
 1247239880,
 9869,
 -1,
 1247289197,
 9870,
 1247496797,
 1247236600,
 -1,
 -46500,
 1247461949,
 119554,
 -1,
 1247493750,
 119553,
 1247739903,
 1247432999,
 -1,
 -46497,
 1247633096,
 9871,
 -1,
 1247682413,
 9868,
 1247890024,
 1245781649,
 -1,
 1247955558,
 1247858273,
 -1,
 -46493,
 1247918825,
 11032,
 -46492,
 1247978170,
 11031,
 -46491,
 1248030548,
 11030,
 -1,
 1248078150,
 11033,
 -46489,
 1247917562,
 128924,
 -1,
 1248242620,
 128160,
 1248414317,
 1247848752,
 -1,
 1248479852,
 1248368899,
 -1,
 -46485,
 1248413734,
 128542,
 -1,
 1248471643,
 128549,
 -1,
 1248405617,
 9933,
 1248742000,
 1248384575,
 -1,
 -46481,
 1248703554,
 128171,
 -1,
 1248741414,
 128565,
 1248938611,
 1248690655,
 -1,
 -46478,
 1248886969,
 127244,
 -1,
 1248931493,
 127243,
 -46476,
 1248905805,
 9902,
 -46475,
 1249091543,
 127919,
 -1,
 1249133721,
 128754,
 1249331842,
 1245714598,
 -1,
 1249397372,
 1249267479,
 -1,
 1249462907,
 1249365601,
 -1,
 -46470,
 1249419922,
 11831,
 -1,
 1249472303,
 11830,
 -1,
 1249405641,
 128481,
 1249725055,
 1249345338,
 -1,
 -46466,
 1249661034,
 127841,
 -1,
 1249717463,
 128131,
 -46464,
 1249686794,
 983081,
 -46463,
 1249880877,
 128168,
 -1,
 1249945077,
 128374,
 1250118282,
 1249287247,
 -1,
 1250183814,
 1250067902,
 -1,
 -46459,
 1250137870,
 128167,
 -1,
 1250196030,
 128042,
 1250380424,
 1250106418,
 128009,
 -1,
 1250296546,
 128050,
 -46455,
 1250321960,
 9946,
 -1,
 1250444502,
 128087,
 1250642576,
 1250044569,
 -1,
 -46452,
 1250601125,
 983161,
 -46451,
 1250628549,
 983090,
 -46450,
 1250693799,
 983088,
 -46449,
 1250759042,
 983086,
 -1,
 1250824283,
 983084,
 -46447,
 1250609019,
 128192,
 -1,
 1250979426,
 983082,
 1251167355,
 1216238072,
 -1,
 1251232618,
 1251088550,
 -1,
 1251298108,
 1251180346,
 -1,
 1251363643,
 1251234178,
 -1,
 1251429133,
 1251305206,
 -1,
 1251494628,
 1251379869,
 -1,
 1251560109,
 1251453093,
 -1,
 1251625636,
 1251518905,
 -1,
 1251691164,
 1251588431,
 55245,
 -1,
 1251610299,
 55246,
 1251822239,
 1251651079,
 -1,
 -46434,
 1251785039,
 55277,
 -1,
 1251830430,
 55276,
 -46432,
 1251779172,
 55255,
 -46431,
 1251972752,
 55270,
 -46430,
 1252033062,
 4607,
 -46429,
 1252097104,
 55264,
 -1,
 1252142641,
 55289,
 1252392959,
 1251566446,
 -1,
 1252412072,
 1252272793,
 -1,
 -46425,
 1252351085,
 55279,
 -1,
 1252414897,
 55280,
 -46423,
 1252374480,
 55281,
 -46422,
 1252561937,
 55278,
 -46421,
 1252621392,
 55274,
 -46420,
 1252681959,
 55275,
 -1,
 1252742584,
 55282,
 1252936380,
 1251513126,
 -1,
 1253001910,
 1252875385,
 -1,
 1253067442,
 1252928153,
 -1,
 -46415,
 1253006445,
 55272,
 -1,
 1253070257,
 55273,
 -46413,
 1253030223,
 55267,
 -46412,
 1253223973,
 55271,
 -46411,
 1253286514,
 55268,
 -1,
 1253342288,
 55269,
 1253526201,
 1252939216,
 -1,
 -46408,
 1253488592,
 55291,
 -1,
 1253551618,
 55290,
 1253769215,
 1253449727,
 -1,
 -46405,
 1253676688,
 55283,
 -1,
 1253730535,
 55284,
 1253919430,
 1252893277,
 -1,
 1253984960,
 1253888848,
 -1,
 -46401,
 1253944682,
 55259,
 -1,
 1254001976,
 55260,
 1254181571,
 1253938838,
 -1,
 -46398,
 1254144335,
 55257,
 -1,
 1254200906,
 55258,
 -46396,
 1254142277,
 55253,
 -46395,
 1254325341,
 55256,
 -1,
 1254386341,
 55254,
 1254574798,
 1253882198,
 -1,
 1254640329,
 1254534658,
 55248,
 -1,
 1254559336,
 55249,
 1254771404,
 1254566553,
 -1,
 -46389,
 1254710381,
 55250,
 -1,
 1254774193,
 55251,
 -46387,
 1254733776,
 55252,
 -1,
 1254921872,
 55247,
 1255099094,
 1254516765,
 -1,
 1255164629,
 1255040738,
 -1,
 -46383,
 1255118480,
 4603,
 -46382,
 1255178790,
 4602,
 -46381,
 1255238182,
 4605,
 -46380,
 1255298488,
 4606,
 -1,
 1255353775,
 4604,
 -1,
 1255088275,
 55261,
 1255623387,
 1255046230,
 -1,
 -46376,
 1255584081,
 55263,
 -46375,
 1255642781,
 55265,
 -46374,
 1255703078,
 55262,
 -1,
 1255747121,
 55266,
 1255951070,
 1255592892,
 -1,
 -46371,
 1255898192,
 55285,
 -1,
 1255953848,
 55286,
 1256147681,
 1255899692,
 -1,
 -46368,
 1256104535,
 55243,
 -1,
 1256140207,
 55244,
 1256390655,
 1256074807,
 -1,
 -46365,
 1256304988,
 55288,
 -1,
 1256363664,
 55287,
 1256587263,
 1251459854,
 -1,
 1256606448,
 1256479413,
 -1,
 1256671982,
 1256575618,
 -1,
 1256737513,
 1256602798,
 55232,
 -1,
 1256687038,
 55231,
 1256868588,
 1256659110,
 -1,
 -46357,
 1256799406,
 55230,
 -1,
 1256853176,
 55229,
 -46355,
 1256832795,
 55235,
 -1,
 1257014718,
 55234,
 -46353,
 1256621548,
 55233,
 -1,
 1257134659,
 55236,
 1257327354,
 1256575618,
 -1,
 1257392885,
 1257276905,
 -1,
 1257458420,
 1257314470,
 55218,
 -1,
 1257389230,
 55219,
 -1,
 1257390862,
 55220,
 1257655032,
 1257357186,
 -1,
 -46345,
 1257604542,
 55224,
 -1,
 1257642798,
 55223,
 -46343,
 1257587473,
 4517,
 -1,
 1257773379,
 4516,
 1257982720,
 1257276905,
 -1,
 1258048255,
 1257951874,
 -1,
 1258113790,
 1257969830,
 4518,
 -1,
 1258044590,
 4519,
 -1,
 1258046222,
 55216,
 -1,
 1257997804,
 55217,
 1258375941,
 1257915743,
 -1,
 1258441475,
 1258306734,
 55227,
 -1,
 1258390974,
 55226,
 -46332,
 1258390974,
 55228,
 -1,
 1258494118,
 55225,
 1258703626,
 1258297510,
 -1,
 1258769161,
 1258659072,
 -1,
 -46328,
 1258699950,
 55238,
 -1,
 1258756262,
 55237,
 -1,
 1258688058,
 4515,
 1259077631,
 1258667906,
 -1,
 -46324,
 1259000739,
 55221,
 -1,
 1259035320,
 55222,
 1259274239,
 1251356135,
 -1,
 1259293469,
 1259184733,
 -1,
 1259358997,
 1259251877,
 -1,
 1259424532,
 1259317689,
 -1,
 -46318,
 1259387215,
 43367,
 -46317,
 1259443856,
 43370,
 -1,
 1259498142,
 43365,
 -1,
 1259365226,
 43372,
 1259752217,
 1259300893,
 -1,
 -46313,
 1259693788,
 43364,
 -46312,
 1259754953,
 43374,
 -1,
 1259806854,
 43371,
 -46310,
 1259714895,
 43366,
 -46309,
 1259968144,
 43369,
 -46308,
 1260026960,
 43368,
 -1,
 1260072497,
 43373,
 1260276515,
 1259256150,
 -1,
 -46305,
 1260236290,
 43362,
 -46304,
 1260298839,
 4446,
 -46303,
 1260361360,
 43361,
 -46302,
 1260420176,
 43360,
 -1,
 1260465713,
 43363,
 1260669736,
 1260237119,
 -1,
 -46299,
 1260639143,
 43388,
 -46298,
 1260697552,
 43385,
 -46297,
 1260760589,
 43381,
 -1,
 1260793406,
 43384,
 1260997422,
 1260622630,
 -1,
 1261062957,
 1260936313,
 -1,
 -46293,
 1261022744,
 43378,
 -46292,
 1261070886,
 43379,
 -1,
 1261131192,
 43380,
 -1,
 1261000152,
 43386,
 1261390642,
 1260945964,
 -1,
 -46288,
 1261350402,
 4443,
 -46287,
 1261393336,
 4445,
 -1,
 1261448753,
 4444,
 1261652790,
 1261337686,
 -1,
 -46284,
 1261615439,
 43376,
 -46283,
 1261678082,
 43377,
 -1,
 1261726366,
 43375,
 1261914937,
 1261591666,
 -1,
 -46280,
 1261871703,
 43382,
 -1,
 1261917624,
 43383,
 -46278,
 1261857458,
 4442,
 -1,
 1262048702,
 43387,
 -1,
 1251292651,
 128092,
 1262308192,
 1251259525,
 -1,
 1262373727,
 1262263806,
 -1,
 1262439256,
 1262317950,
 -1,
 1262504772,
 1262397605,
 -1,
 1262570307,
 1262426278,
 -1,
 -46270,
 1262516962,
 67822,
 -1,
 1262565123,
 67825,
 -1,
 1262507634,
 67828,
 1262832455,
 1262466181,
 -1,
 -46266,
 1262765327,
 67816,
 -1,
 1262822606,
 67829,
 1263029065,
 1262769214,
 67812,
 -1,
 1262991187,
 67815,
 1263160140,
 1262950566,
 -1,
 -46261,
 1263129669,
 67823,
 -1,
 1263169883,
 67808,
 -46259,
 1263129943,
 67814,
 -46258,
 1263326299,
 67817,
 -46257,
 1263389737,
 67813,
 -46256,
 1263442692,
 67826,
 -46255,
 1263506691,
 67824,
 -46254,
 1263568181,
 67821,
 -46253,
 1263631099,
 67820,
 -46252,
 1263692974,
 67819,
 -46251,
 1263757538,
 67818,
 -46250,
 1263816700,
 67810,
 -46249,
 1263875479,
 67811,
 -1,
 1263937339,
 67809,
 1264189439,
 1262388473,
 -1,
 1264208732,
 1264104581,
 -1,
 -46245,
 1264176265,
 67838,
 -1,
 1264206218,
 67837,
 1264405342,
 1264159160,
 67835,
 -1,
 1264321377,
 67839,
 -1,
 1264339428,
 67836,
 -1,
 1262300613,
 128035,
 1264667495,
 1262253836,
 -1,
 1264733029,
 1264614199,
 128296,
 1264844799,
 1264648263,
 -1,
 -46236,
 1264767298,
 128736,
 -1,
 1264817778,
 9874,
 -46234,
 1264693744,
 128057,
 -1,
 1264921168,
 127828,
 -46232,
 1264623338,
 128436,
 -46231,
 1265080634,
 128587,
 -1,
 1265132611,
 128135,
 1265323059,
 1251163310,
 -1,
 1265388490,
 1265291715,
 -1,
 1265453953,
 1265349765,
 -1,
 1265519488,
 1265390657,
 -1,
 1265585010,
 1265445529,
 -1,
 -46224,
 1265541003,
 19904,
 -46223,
 1265595254,
 19933,
 -1,
 1265640547,
 19953,
 1265847159,
 1265506470,
 -1,
 1265912694,
 1265802319,
 -1,
 -46219,
 1265864746,
 19954,
 -1,
 1265925921,
 19910,
 -1,
 1265838732,
 19932,
 1266174842,
 1265814286,
 -1,
 -46215,
 1266106643,
 19951,
 -1,
 1266163526,
 19959,
 -46213,
 1266130860,
 19905,
 -46212,
 1266317679,
 19957,
 -46211,
 1266379148,
 19955,
 -46210,
 1266444272,
 19961,
 -46209,
 1266503385,
 19960,
 -1,
 1266567270,
 19940,
 -1,
 1265475375,
 19913,
 1266830219,
 1265382584,
 -1,
 1266895750,
 1266760878,
 -1,
 -46204,
 1266862044,
 19956,
 -46203,
 1266906083,
 19943,
 -1,
 1266954865,
 19944,
 1267157897,
 1266833987,
 -1,
 -46200,
 1267118224,
 19962,
 -1,
 1267157234,
 19906,
 -46198,
 1267123539,
 19935,
 -1,
 1267278144,
 19939,
 1267485590,
 1266765076,
 -1,
 1267551125,
 1267440719,
 -1,
 1267616660,
 1267482213,
 -1,
 1267682195,
 1267569446,
 -1,
 1267747730,
 1267631550,
 -1,
 -46191,
 1267715237,
 19937,
 -1,
 1267773799,
 19917,
 -1,
 1267704031,
 19931,
 -1,
 1267643877,
 19929,
 -1,
 1267538471,
 19925,
 -1,
 1267475360,
 19948,
 1268206492,
 1267443877,
 -1,
 1268272026,
 1268152368,
 -1,
 -46183,
 1268233701,
 19912,
 -1,
 1268291934,
 19965,
 -46181,
 1268233712,
 19915,
 -1,
 1268422451,
 19926,
 1268599714,
 1268145864,
 -1,
 1268665248,
 1268547386,
 -1,
 -46177,
 1268614753,
 19928,
 -1,
 1268663248,
 19964,
 -46175,
 1268599484,
 19934,
 -1,
 1268789873,
 19945,
 1268992935,
 1268555564,
 -1,
 1269058470,
 1268954245,
 -1,
 -46171,
 1269024146,
 19927,
 -1,
 1269079924,
 19936,
 -1,
 1269025329,
 19952,
 1269320619,
 1268945702,
 -1,
 -46167,
 1269286416,
 19949,
 -46166,
 1269343848,
 19938,
 -1,
 1269382584,
 19914,
 1269582768,
 1269269950,
 -1,
 1269648303,
 1269536992,
 -1,
 -46162,
 1269604631,
 19950,
 -1,
 1269665265,
 19941,
 -1,
 1269574159,
 19942,
 1269910453,
 1269510208,
 -1,
 1269975988,
 1269858106,
 -1,
 -46157,
 1269937838,
 19923,
 -1,
 1269975656,
 19909,
 -1,
 1269923013,
 19947,
 1270238137,
 1269835044,
 -1,
 -46153,
 1270193985,
 19946,
 -46152,
 1270244767,
 19924,
 -1,
 1270300616,
 19967,
 1270500285,
 1270159526,
 -1,
 -46149,
 1270454565,
 19922,
 -46148,
 1270500587,
 19966,
 -1,
 1270557246,
 19958,
 1270762432,
 1270467342,
 -1,
 -46145,
 1270713690,
 19921,
 -1,
 1270750436,
 19908,
 1270959043,
 1270709576,
 -1,
 -46142,
 1270924885,
 19930,
 -1,
 1270953699,
 19918,
 1271155654,
 1270892494,
 -1,
 -46139,
 1271105694,
 19920,
 -1,
 1271152931,
 19916,
 -46137,
 1271125092,
 19907,
 -46136,
 1271296809,
 19963,
 -46135,
 1271355246,
 19911,
 -1,
 1271415510,
 19919,
 1271614503,
 1265309862,
 -1,
 1271680028,
 1271581444,
 -1,
 1271745499,
 1271638181,
 -1,
 1271811028,
 1271697523,
 -1,
 1271876561,
 1271778479,
 -1,
 -46128,
 1271843200,
 128605,
 -1,
 1271867937,
 128613,
 1272119295,
 1271807496,
 -1,
 -46125,
 1272039808,
 128607,
 -1,
 1272064545,
 128615,
 1272269783,
 1271752314,
 -1,
 -46122,
 1272230090,
 128952,
 -1,
 1272289236,
 128972,
 1272466394,
 1272191142,
 -1,
 -46119,
 1272415217,
 128635,
 -1,
 1272477333,
 128940,
 -1,
 1272394412,
 128625,
 1272728550,
 1271688111,
 -1,
 1272794079,
 1272681041,
 -1,
 -46114,
 1272753629,
 10079,
 -1,
 1272789484,
 10080,
 1272990690,
 1272725518,
 -1,
 -46111,
 1272933639,
 129052,
 -1,
 1272988537,
 129048,
 1273187301,
 1272912038,
 -1,
 -46108,
 1273149956,
 128327,
 -1,
 1273209232,
 11093,
 -1,
 1273126135,
 128627,
 1273449454,
 1272649894,
 -1,
 1273514989,
 1273407363,
 -1,
 1273580524,
 1273465272,
 129180,
 1273692159,
 1273495552,
 -1,
 -46101,
 1273608152,
 129183,
 -1,
 1273647757,
 129182,
 -1,
 1273544441,
 129181,
 -1,
 1273462317,
 128628,
 1273973749,
 1273398141,
 -1,
 1274039282,
 1273941167,
 -1,
 -46095,
 1274005888,
 128604,
 -1,
 1274030625,
 128612,
 1274281983,
 1273970184,
 -1,
 -46092,
 1274202496,
 128606,
 -1,
 1274227233,
 128614,
 1274432508,
 1273904302,
 -1,
 1274498043,
 1274371373,
 -1,
 1274563578,
 1274451915,
 -1,
 -46087,
 1274517178,
 128977,
 -1,
 1274554457,
 128975,
 -1,
 1274523850,
 128958,
 -1,
 1274466785,
 10071,
 1274891267,
 1274361016,
 -1,
 1274956802,
 1274840510,
 -1,
 1275022337,
 1274924983,
 -1,
 -46080,
 1274965255,
 129055,
 -1,
 1275020153,
 129051,
 -1,
 1274967095,
 128178,
 -1,
 1274898019,
 10135,
 1275350024,
 1274818133,
 11096,
 1275415559,
 1275267848,
 -1,
 -46074,
 1275376389,
 9955,
 -1,
 1275408001,
 11095,
 -1,
 1275344132,
 11097,
 1275677708,
 1275317509,
 -1,
 -46070,
 1275637978,
 128913,
 -46069,
 1275673412,
 9947,
 -1,
 1275735637,
 128903,
 1275939855,
 1275643121,
 -1,
 -46066,
 1275882759,
 129053,
 -1,
 1275937657,
 129049,
 1276136466,
 1275903565,
 -1,
 -46063,
 1276090042,
 128980,
 -1,
 1276127321,
 128979,
 1276333077,
 1276093495,
 -1,
 -46060,
 1276275975,
 129054,
 -1,
 1276330873,
 129050,
 1276529688,
 1276266985,
 -1,
 -46057,
 1276489930,
 128946,
 -1,
 1276549076,
 128970,
 -46055,
 1276483478,
 10133,
 -46054,
 1276678291,
 11094,
 -46053,
 1276738789,
 10134,
 -1,
 1276797556,
 128633,
 1276988452,
 1271635023,
 -1,
 1277053987,
 1276949639,
 -1,
 1277119522,
 1277021793,
 -1,
 -46048,
 1277082160,
 127892,
 -46047,
 1277141545,
 128157,
 -1,
 1277174244,
 128152,
 -1,
 1277048371,
 128159,
 -1,
 1276972712,
 128585,
 1277558783,
 1276916920,
 -1,
 -46042,
 1277473359,
 9980,
 -1,
 1277531730,
 127911,
 1277709359,
 1271540190,
 -1,
 1277774893,
 1277661990,
 -1,
 1277840428,
 1277724577,
 -1,
 -46037,
 1277795029,
 1479,
 -1,
 1277843290,
 1466,
 -1,
 1277805232,
 1478,
 -46034,
 1277720887,
 1477,
 -1,
 1278024197,
 1442,
 1278233650,
 1277651887,
 -1,
 -46031,
 1278180192,
 9937,
 -1,
 1278237646,
 128641,
 -1,
 1278189251,
 127807,
 1278495836,
 1265272254,
 -1,
 1278561350,
 1278450767,
 -1,
 1278626882,
 1278502637,
 -1,
 1278692414,
 1278588037,
 -1,
 1278757949,
 1278613878,
 -1,
 1278823484,
 1278722534,
 983059,
 1278935039,
 1278738432,
 -1,
 -46021,
 1278856845,
 983140,
 -1,
 1278913271,
 983137,
 -1,
 1278739421,
 11134,
 -1,
 1278713094,
 128677,
 1279216705,
 1278617646,
 -1,
 -46016,
 1279166083,
 11203,
 -1,
 1279219030,
 11043,
 -1,
 1279162382,
 9897,
 1279524863,
 1278585396,
 128014,
 1279590399,
 1279393792,
 -1,
 -46011,
 1279499486,
 127943,
 -1,
 1279543334,
 128052,
 1279741004,
 1278525211,
 -1,
 1279806539,
 1279699511,
 -1,
 1279872074,
 1279732269,
 127968,
 -1,
 1279830181,
 127960,
 -1,
 1279839873,
 127969,
 -1,
 1279762854,
 9203,
 1280134226,
 1279702149,
 -1,
 1280199761,
 1280049152,
 -1,
 -46001,
 1280153015,
 127798,
 -46000,
 1280194681,
 127789,
 -1,
 1280255879,
 9749,
 -1,
 1280131289,
 127976,
 1280527446,
 1280076719,
 -1,
 1280592981,
 1280472497,
 128616,
 -1,
 1280508794,
 128617,
 -1,
 1280523438,
 128371,
 1280789593,
 1280475509,
 -1,
 -45992,
 1280714424,
 128029,
 -1,
 1280772157,
 127855,
 -45990,
 1280749756,
 127973,
 -45989,
 1280938790,
 983123,
 -1,
 1280978392,
 128298,
 1281182832,
 1278433859,
 -1,
 1281248357,
 1281137939,
 -1,
 1281313892,
 1281173437,
 -1,
 -45984,
 1281277723,
 983968,
 -45983,
 1281328574,
 983970,
 -45982,
 1281382979,
 983967,
 -45981,
 1281440942,
 983969,
 -1,
 1281497254,
 983966,
 -1,
 1281237232,
 110593,
 1281772654,
 1281183558,
 -1,
 1281838186,
 1281691115,
 -1,
 1281903721,
 1281798276,
 128644,
 -1,
 1281821455,
 128645,
 -1,
 1281840348,
 128096,
 1282146303,
 1281753088,
 -1,
 -45972,
 1282066980,
 9889,
 -45971,
 1282115211,
 983122,
 -1,
 1282157028,
 128262,
 -45969,
 1281733222,
 9964,
 -1,
 1282287629,
 127802,
 1282493556,
 1281146651,
 -1,
 -45966,
 1282452468,
 128559,
 -45965,
 1282506884,
 128175,
 -1,
 1282559773,
 129303,
 1282755703,
 1282454661,
 983060,
 -45962,
 1282713765,
 983138,
 -1,
 1282762486,
 983141,
 1282952314,
 1282724992,
 -1,
 -45959,
 1282901693,
 11794,
 -1,
 1282954486,
 11802,
 -1,
 1282910361,
 8372,
 1283214857,
 1251114810,
 -1,
 1283280188,
 1283144878,
 -1,
 1283345652,
 1283246862,
 -1,
 1283411184,
 1283260416,
 -1,
 1283476716,
 1283372428,
 -1,
 1283542211,
 1283420542,
 -1,
 1283607710,
 1283487084,
 -1,
 1283673222,
 1283568773,
 -1,
 -45948,
 1283631408,
 6539,
 -45947,
 1283674638,
 6546,
 -1,
 1283725478,
 6545,
 1283935369,
 1283641758,
 -1,
 -45944,
 1283901107,
 6569,
 -1,
 1283922086,
 6534,
 1284131980,
 1283893413,
 -1,
 -45941,
 1284095924,
 6571,
 -1,
 1284118694,
 6540,
 1284328591,
 1284084518,
 -1,
 -45938,
 1284264462,
 6552,
 -1,
 1284315302,
 6551,
 1284525202,
 1284276026,
 -1,
 -45935,
 1284459875,
 6535,
 -1,
 1284511910,
 6547,
 1284721813,
 1284466717,
 -1,
 -45932,
 1284687539,
 6568,
 -1,
 1284708518,
 6533,
 -45930,
 1284690651,
 6541,
 -45929,
 1284884147,
 6558,
 -45928,
 1284938422,
 6529,
 -45927,
 1284994914,
 6553,
 -45926,
 1285057501,
 6559,
 -45925,
 1285116430,
 6563,
 -45924,
 1285179427,
 6557,
 -45923,
 1285240134,
 6564,
 -1,
 1285301593,
 6565,
 1285508283,
 1283544554,
 -1,
 1285573795,
 1285469317,
 -1,
 -45919,
 1285531952,
 6536,
 -45918,
 1285575182,
 6543,
 -1,
 1285626022,
 6542,
 1285835942,
 1285542302,
 -1,
 -45915,
 1285801651,
 6567,
 -1,
 1285822630,
 6531,
 1286032553,
 1285793957,
 -1,
 -45912,
 1285996468,
 6570,
 -1,
 1286019238,
 6537,
 1286229164,
 1285985062,
 -1,
 -45909,
 1286165006,
 6549,
 -1,
 1286215846,
 6548,
 1286425775,
 1286176570,
 -1,
 -45906,
 1286360419,
 6532,
 -1,
 1286412454,
 6544,
 1286622386,
 1286367261,
 -1,
 -45903,
 1286588083,
 6566,
 -1,
 1286609062,
 6530,
 -45901,
 1286591195,
 6538,
 -45900,
 1286784691,
 6555,
 -45899,
 1286838966,
 6528,
 -45898,
 1286895458,
 6550,
 -45897,
 1286958045,
 6556,
 -45896,
 1287016974,
 6560,
 -45895,
 1287079971,
 6554,
 -45894,
 1287140678,
 6561,
 -1,
 1287202137,
 6562,
 1287454719,
 1285441870,
 -1,
 1287474366,
 1287356218,
 6595,
 -1,
 1287408916,
 6594,
 -45889,
 1287440029,
 6593,
 -45888,
 1287550732,
 6596,
 -45887,
 1287612445,
 6597,
 -45886,
 1287664824,
 6598,
 -1,
 1287726372,
 6599,
 1287933143,
 1283508890,
 -1,
 1287998665,
 1287896859,
 6579,
 1288064199,
 1287929006,
 6585,
 -1,
 1288032898,
 6591,
 -45880,
 1288032898,
 6588,
 -1,
 1288159003,
 6580,
 1288326349,
 1287947710,
 6583,
 1288391884,
 1288247462,
 6584,
 -1,
 1288360578,
 6590,
 -1,
 1288360578,
 6589,
 1288588498,
 1288247462,
 -1,
 1288654032,
 1288509606,
 6577,
 -1,
 1288622722,
 6587,
 -45871,
 1288622722,
 6586,
 -1,
 1288715438,
 6582,
 1288916181,
 1288526403,
 -1,
 -45868,
 1288884866,
 6592,
 -1,
 1288919619,
 6578,
 -45866,
 1288882826,
 6576,
 -1,
 1289043118,
 6581,
 1289243877,
 1287862170,
 -1,
 1289309403,
 1289204869,
 -1,
 -45862,
 1289277387,
 6610,
 -1,
 1289312475,
 6611,
 1289506014,
 1289267365,
 -1,
 -45859,
 1289447031,
 6614,
 -1,
 1289504238,
 6615,
 1289702625,
 1289439182,
 -1,
 -45856,
 1289654120,
 6612,
 -1,
 1289709011,
 6613,
 -45854,
 1289672062,
 6608,
 -45853,
 1289849272,
 6609,
 -45852,
 1289912923,
 6617,
 -1,
 1289961582,
 6616,
 1290161386,
 1289204869,
 -1,
 1290226921,
 1290111507,
 -1,
 -45848,
 1290146178,
 6601,
 -1,
 1290211419,
 6600,
 -1,
 1290162920,
 6618,
 1290534911,
 1290120586,
 6622,
 -1,
 1290454685,
 6623,
 1290620143,
 1283423704,
 -1,
 -45842,
 1290587767,
 127770,
 -1,
 1290646594,
 127761,
 -1,
 1290564404,
 983063,
 1290882291,
 1283355449,
 -1,
 -45838,
 1290838661,
 11155,
 -1,
 1290891044,
 11154,
 -1,
 1290842222,
 128240,
 1291144501,
 1283280411,
 -1,
 1291210007,
 1291104504,
 -1,
 1291275537,
 1291152782,
 -1,
 -45832,
 1291244741,
 127369,
 -45831,
 1291309698,
 127368,
 -45830,
 1291375006,
 127367,
 -45829,
 1291438862,
 127366,
 -45828,
 1291503261,
 127365,
 -45827,
 1291566875,
 127364,
 -45826,
 1291629701,
 127363,
 -45825,
 1291692197,
 127362,
 -45824,
 1291754575,
 127361,
 -45823,
 1291819688,
 127360,
 -45822,
 1291883302,
 127359,
 -45821,
 1291945406,
 127358,
 -45820,
 1292009274,
 127357,
 -45819,
 1292072716,
 127356,
 -45818,
 1292135343,
 127355,
 -45817,
 1292199965,
 127354,
 -45816,
 1292265206,
 127353,
 -45815,
 1292327491,
 127352,
 -45814,
 1292390904,
 127351,
 -45813,
 1292455188,
 127350,
 -45812,
 1292519374,
 127349,
 -45811,
 1292582062,
 127348,
 -45810,
 1292645560,
 127347,
 -45809,
 1292708505,
 127346,
 -45808,
 1292772644,
 127345,
 -1,
 1292834982,
 127344,
 -45806,
 1291242585,
 127375,
 -45805,
 1293003056,
 127373,
 -45804,
 1293063036,
 127372,
 -45803,
 1293114225,
 127371,
 -45802,
 1293169368,
 10062,
 -1,
 1293228406,
 127374,
 1293438260,
 1291136655,
 -1,
 1293503795,
 1293381006,
 -1,
 -45798,
 1293472965,
 127337,
 -45797,
 1293537922,
 127336,
 -45796,
 1293603230,
 127335,
 -45795,
 1293667086,
 127334,
 -45794,
 1293731485,
 127333,
 -45793,
 1293795099,
 127332,
 -45792,
 1293857925,
 127331,
 -45791,
 1293920421,
 127330,
 -45790,
 1293982799,
 127329,
 -45789,
 1294047912,
 127328,
 -45788,
 1294111526,
 127327,
 -45787,
 1294173630,
 127326,
 -45786,
 1294237498,
 127325,
 -45785,
 1294300940,
 127324,
 -45784,
 1294363567,
 127323,
 -45783,
 1294428189,
 127322,
 -45782,
 1294493430,
 127321,
 -45781,
 1294555715,
 127320,
 -45780,
 1294619128,
 127319,
 -45779,
 1294683412,
 127318,
 -45778,
 1294747598,
 127317,
 -45777,
 1294810286,
 127316,
 -45776,
 1294873784,
 127315,
 -45775,
 1294936729,
 127314,
 -45774,
 1295000868,
 127313,
 -1,
 1295063206,
 127312,
 -1,
 1293432737,
 9471,
 -1,
 1293359741,
 983091,
 1295404344,
 1291109954,
 -1,
 -45769,
 1295359450,
 128528,
 -1,
 1295401871,
 9906,
 -45767,
 1295372874,
 983130,
 -45766,
 1295556338,
 129299,
 -45765,
 1295608751,
 983131,
 -1,
 1295658918,
 128084,
 1295863174,
 1283222232,
 -1,
 1295928677,
 1295805359,
 -1,
 1295994211,
 1295861039,
 -1,
 1296059716,
 1295941434,
 2002,
 1296125250,
 1296028379,
 2018,
 -1,
 1296043467,
 2023,
 1296302079,
 1296046246,
 2019,
 -1,
 1296174539,
 2016,
 1296387402,
 1296000758,
 -1,
 1296452937,
 1296337312,
 -1,
 -45753,
 1296407747,
 2026,
 -45752,
 1296459540,
 2024,
 -1,
 1296510247,
 2025,
 -1,
 1296373926,
 2006,
 1296780621,
 1296342095,
 -1,
 -45748,
 1296735427,
 2010,
 -1,
 1296767142,
 2009,
 1296977231,
 1296729534,
 2000,
 -1,
 1296926142,
 1999,
 1297108305,
 1296907438,
 1997,
 -1,
 1297038510,
 1995,
 1297239379,
 1297036614,
 2008,
 -1,
 1297174115,
 2001,
 -45740,
 1297208027,
 2022,
 -45739,
 1297337166,
 2021,
 -45738,
 1297399579,
 1998,
 -45737,
 1297462535,
 2005,
 -45736,
 1297525040,
 2011,
 -45735,
 1297585020,
 2004,
 -45734,
 1297643362,
 2017,
 -45733,
 1297705949,
 2015,
 -45732,
 1297770607,
 2014,
 -45731,
 1297832515,
 1996,
 -45730,
 1297895950,
 2020,
 -45729,
 1297960519,
 2012,
 -45728,
 1298024483,
 2013,
 -45727,
 1298083111,
 2007,
 -45726,
 1298146649,
 2003,
 -1,
 1298208934,
 1994,
 -45724,
 1295946361,
 2037,
 -1,
 1298341133,
 2042,
 1298550131,
 1295857562,
 -1,
 1298615657,
 1298510981,
 -1,
 -45720,
 1298583499,
 1986,
 -1,
 1298618587,
 1987,
 1298812268,
 1298573477,
 -1,
 -45717,
 1298753143,
 1990,
 -1,
 1298810350,
 1991,
 1299008879,
 1298745294,
 -1,
 -45714,
 1298960232,
 1988,
 -1,
 1299015123,
 1989,
 -45712,
 1298978174,
 1984,
 -45711,
 1299155384,
 1985,
 -45710,
 1299219035,
 1993,
 -1,
 1299267694,
 1992,
 1299467649,
 1298477156,
 -1,
 1299533184,
 1299392498,
 -1,
 1299598714,
 1299477714,
 -1,
 -45705,
 1299555730,
 2033,
 -45704,
 1299609035,
 2032,
 -45703,
 1299666466,
 2031,
 -1,
 1299723966,
 2030,
 1299926398,
 1299557525,
 -1,
 -45700,
 1299883410,
 2029,
 -45699,
 1299936715,
 2028,
 -1,
 1299994146,
 2027,
 -45697,
 1299873765,
 2034,
 -1,
 1300118050,
 2035,
 -1,
 1299478370,
 2040,
 1300385156,
 1299428425,
 -1,
 -45693,
 1300335363,
 2038,
 -1,
 1300385355,
 2039,
 -45691,
 1300321836,
 2036,
 -1,
 1300514513,
 2041,
 1300712903,
 1295812030,
 -1,
 1300778415,
 1300667471,
 -1,
 1300843950,
 1300739923,
 -1,
 1300909485,
 1300758528,
 -1,
 1300975001,
 1300848627,
 -1,
 1301040532,
 1300909105,
 -1,
 1301106065,
 1300990396,
 -1,
 -45682,
 1301065306,
 43059,
 -45681,
 1301126016,
 43056,
 -45680,
 1301172877,
 43057,
 -1,
 1301233831,
 43060,
 1301479423,
 1301067831,
 -1,
 -45677,
 1301392996,
 43061,
 -1,
 1301453759,
 43058,
 1301630359,
 1300994828,
 -1,
 -45674,
 1301587929,
 43062,
 -1,
 1301644478,
 43065,
 -45672,
 1301588070,
 43064,
 -1,
 1301780182,
 43063,
 1301958051,
 1300941993,
 -1,
 1302023582,
 1301911527,
 -1,
 -45668,
 1301989760,
 128600,
 -45667,
 1302032087,
 128592,
 -1,
 1302080033,
 128608,
 1302285728,
 1301986385,
 11110,
 -1,
 1302203065,
 11126,
 -45663,
 1302252812,
 11009,
 -45662,
 1302374854,
 129108,
 -1,
 1302407221,
 11017,
 1302659071,
 1301888514,
 -1,
 1302678952,
 1302566887,
 -1,
 -45658,
 1302645120,
 128602,
 -45657,
 1302687447,
 128594,
 -1,
 1302735393,
 128610,
 1302941098,
 1302641745,
 11111,
 -1,
 1302858425,
 11127,
 -45653,
 1302908172,
 11008,
 -45652,
 1303030214,
 129109,
 -1,
 1303062581,
 11016,
 -1,
 1300839978,
 128746,
 -1,
 1300772748,
 8379,
 1303399867,
 1300692992,
 -1,
 1303465395,
 1303352102,
 -1,
 -45646,
 1303405510,
 128370,
 -1,
 1303461669,
 128695,
 1303662005,
 1303397102,
 9940,
 -1,
 1303578832,
 128683,
 1303793080,
 1303586084,
 -1,
 -45641,
 1303748407,
 983126,
 -1,
 1303796712,
 128691,
 -45639,
 1303752672,
 128685,
 -45638,
 1303939638,
 128286,
 -1,
 1304001867,
 128245,
 1304186309,
 1303360645,
 -1,
 1304251842,
 1304116398,
 128456,
 1304317375,
 1304176929,
 128211,
 -1,
 1304234896,
 128212,
 1304494079,
 1304233669,
 -1,
 -45631,
 1304383106,
 128457,
 -1,
 1304442040,
 128458,
 1304690687,
 1304178031,
 -1,
 -45628,
 1304601393,
 128324,
 -1,
 1304653732,
 128323,
 -45626,
 1304144436,
 128067,
 -1,
 1304788849,
 128689,
 1304972799,
 1300633766,
 -1,
 1305038331,
 1304897135,
 -1,
 1305103854,
 1304981886,
 -1,
 1305169364,
 1305037134,
 -1,
 -45620,
 1305138267,
 67724,
 -45619,
 1305193565,
 67740,
 -45618,
 1305249077,
 67732,
 -45617,
 1305311995,
 67730,
 -45616,
 1305373870,
 67728,
 -45615,
 1305438434,
 67726,
 -45614,
 1305498686,
 67718,
 -45613,
 1305552699,
 67714,
 -1,
 1305615788,
 67712,
 1305824729,
 1305127077,
 -1,
 1305890264,
 1305745574,
 -1,
 -45609,
 1305836258,
 67734,
 -1,
 1305884419,
 67737,
 -1,
 1305826930,
 67741,
 1306152412,
 1305785477,
 -1,
 -45605,
 1306084623,
 67723,
 -1,
 1306141902,
 67742,
 1306349022,
 1306088510,
 67719,
 -1,
 1306310483,
 67722,
 1306480097,
 1306269862,
 -1,
 -45600,
 1306448850,
 67735,
 -1,
 1306489179,
 67713,
 -45598,
 1306449233,
 67721,
 -45597,
 1306645595,
 67725,
 -45596,
 1306709033,
 67720,
 -45595,
 1306763530,
 67739,
 -45594,
 1306827524,
 67738,
 -45593,
 1306891523,
 67736,
 -45592,
 1306953013,
 67733,
 -45591,
 1307015931,
 67731,
 -45590,
 1307077806,
 67729,
 -45589,
 1307142370,
 67727,
 -45588,
 1307201532,
 67716,
 -45587,
 1307260304,
 67717,
 -1,
 1307322171,
 67715,
 1307528698,
 1305052409,
 -1,
 1307594229,
 1307489413,
 -1,
 1307659763,
 1307560718,
 -1,
 -45582,
 1307608510,
 67752,
 -1,
 1307656948,
 67758,
 -45580,
 1307597019,
 67753,
 -1,
 1307787658,
 67757,
 1307987447,
 1307543992,
 67751,
 -1,
 1307902817,
 67759,
 1308164095,
 1307920334,
 -1,
 -45575,
 1308069736,
 67754,
 -1,
 1308124627,
 67756,
 -1,
 1307456428,
 67755,
 -45572,
 1305000479,
 127966,
 -45571,
 1308326428,
 128219,
 -45570,
 1308387357,
 983092,
 -1,
 1308450314,
 128133,
 1308642819,
 1304936219,
 -1,
 1308708354,
 1308584879,
 983041,
 -1,
 1308650415,
 983040,
 -1,
 1308669066,
 128297,
 1308904966,
 1308566820,
 -1,
 -45563,
 1308864612,
 983196,
 -1,
 1308905976,
 983127,
 -45561,
 1308852245,
 983223,
 -45560,
 1309043631,
 983066,
 -1,
 1309105498,
 127747,
 1309298563,
 1283169359,
 -1,
 1309363834,
 1309228206,
 -1,
 1309429306,
 1309304624,
 -1,
 1309494824,
 1309372798,
 -1,
 1309560342,
 1309441850,
 -1,
 1309625873,
 1309528706,
 -1,
 -45552,
 1309566740,
 43333,
 -1,
 1309612198,
 43323,
 1309822484,
 1309560084,
 -1,
 -45549,
 1309756771,
 43331,
 -1,
 1309808806,
 43314,
 -45547,
 1309750598,
 43332,
 -1,
 1309939878,
 43317,
 1310150169,
 1309505292,
 -1,
 -45544,
 1310074201,
 43330,
 -1,
 1310136486,
 43320,
 -45542,
 1310118619,
 43327,
 -45541,
 1310313294,
 43328,
 -45540,
 1310373127,
 43315,
 -45539,
 1310435632,
 43324,
 -45538,
 1310497987,
 43325,
 -45537,
 1310561148,
 43318,
 -45536,
 1310616541,
 43326,
 -45535,
 1310681199,
 43312,
 -45534,
 1310746388,
 43322,
 -45533,
 1310806542,
 43329,
 -45532,
 1310870883,
 43313,
 -45531,
 1310930246,
 43316,
 -45530,
 1310993095,
 43321,
 -45529,
 1311057241,
 43319,
 -1,
 1311119526,
 43334,
 1311329844,
 1309460125,
 -1,
 1311395379,
 1311281830,
 -1,
 1311460909,
 1311325358,
 43337,
 -45524,
 1311424283,
 43341,
 -1,
 1311447206,
 43342,
 1311657520,
 1311381670,
 -1,
 -45521,
 1311620891,
 43340,
 -1,
 1311660611,
 43338,
 -45519,
 1311620891,
 43336,
 -45518,
 1311802814,
 43339,
 -1,
 1311857219,
 43335,
 -1,
 1311335385,
 43347,
 1312116281,
 1311256882,
 -1,
 1312181815,
 1312063290,
 43344,
 -1,
 1312115988,
 43343,
 -45512,
 1312136271,
 43345,
 -1,
 1312248312,
 43346,
 -1,
 1312074330,
 43359,
 1312509525,
 1309364226,
 -1,
 -45508,
 1312478405,
 127487,
 -45507,
 1312543362,
 127486,
 -45506,
 1312608670,
 127485,
 -45505,
 1312672526,
 127484,
 -45504,
 1312736925,
 127483,
 -45503,
 1312800539,
 127482,
 -45502,
 1312863365,
 127481,
 -45501,
 1312925861,
 127480,
 -45500,
 1312988239,
 127479,
 -45499,
 1313053352,
 127478,
 -45498,
 1313116966,
 127477,
 -45497,
 1313179070,
 127476,
 -45496,
 1313242938,
 127475,
 -45495,
 1313306380,
 127474,
 -45494,
 1313369007,
 127473,
 -45493,
 1313433629,
 127472,
 -45492,
 1313498870,
 127471,
 -45491,
 1313561155,
 127470,
 -45490,
 1313624568,
 127469,
 -45489,
 1313688852,
 127468,
 -45488,
 1313753038,
 127467,
 -45487,
 1313815726,
 127466,
 -45486,
 1313879224,
 127465,
 -45485,
 1313942169,
 127464,
 -45484,
 1314006308,
 127463,
 -1,
 1314068646,
 127462,
 1314279020,
 1312474781,
 -1,
 1314344555,
 1314210888,
 -1,
 1314410081,
 1314272442,
 -1,
 1314475611,
 1314371823,
 -1,
 -45478,
 1314440163,
 128402,
 -1,
 1314470704,
 128403,
 -45476,
 1314441556,
 128404,
 -45475,
 1314626907,
 128401,
 -45474,
 1314692093,
 11822,
 -45473,
 1314739025,
 128405,
 -45472,
 1314802430,
 11793,
 -1,
 1314861246,
 11841,
 1315110911,
 1314324480,
 -1,
 1315130981,
 1315027315,
 -1,
 -45468,
 1315087398,
 11079,
 -1,
 1315139711,
 11073,
 1315327592,
 1315074621,
 -1,
 -45465,
 1315274911,
 983151,
 -1,
 1315327900,
 128968,
 -45463,
 1315287059,
 10184,
 -45462,
 1315463016,
 983152,
 -1,
 1315515745,
 128639,
 -1,
 1314293938,
 128158,
 1315786353,
 1314239090,
 -1,
 1315851888,
 1315724246,
 -1,
 -45457,
 1315770754,
 9953,
 -1,
 1315835995,
 9952,
 -1,
 1315801916,
 128699,
 1316114036,
 1315749321,
 -1,
 -45453,
 1316070021,
 11153,
 -1,
 1316122404,
 11152,
 1316310647,
 1316039321,
 -1,
 -45450,
 1316265849,
 128665,
 -1,
 1316326658,
 983112,
 -45448,
 1316256946,
 127895,
 -45447,
 1316450931,
 128524,
 -1,
 1316500669,
 127822,
 1316703987,
 1309301315,
 983153,
 1316769503,
 1316638597,
 -1,
 1316835005,
 1316735907,
 -1,
 1316900501,
 1316795525,
 -1,
 1316966035,
 1316856316,
 -1,
 1317031570,
 1316884048,
 -1,
 1317097104,
 1316954596,
 11106,
 1317208063,
 1317011456,
 -1,
 1317228174,
 1317129825,
 -1,
 1317293702,
 1317172476,
 -1,
 -45435,
 1317258437,
 11173,
 -1,
 1317288795,
 11175,
 1317490313,
 1317222831,
 -1,
 -45432,
 1317456042,
 983234,
 -1,
 1317492765,
 11132,
 -45430,
 1317456109,
 129074,
 -45429,
 1317634008,
 129058,
 -45428,
 1317698184,
 129062,
 -45427,
 1317754027,
 129070,
 -1,
 1317808399,
 129066,
 -45425,
 1317190278,
 11122,
 -1,
 1317966186,
 11138,
 -45423,
 1317049286,
 11142,
 -1,
 1318073812,
 11116,
 -1,
 1316946221,
 129170,
 -45420,
 1316933790,
 11246,
 -1,
 1318292376,
 129187,
 1318473383,
 1316823530,
 -1,
 1318538913,
 1318440545,
 -1,
 1318604442,
 1318500907,
 -1,
 -45415,
 1318569157,
 11023,
 -1,
 1318599515,
 11022,
 1318801053,
 1318563511,
 -1,
 -45412,
 1318763531,
 129026,
 -1,
 1318798201,
 129042,
 -45410,
 1318749086,
 129178,
 -45409,
 1318943395,
 129030,
 -45408,
 1319005475,
 129034,
 -1,
 1319060345,
 129046,
 1319259812,
 1318500518,
 -1,
 -45405,
 1319220155,
 11076,
 -1,
 1319260465,
 11075,
 1319501823,
 1319180786,
 -1,
 -45402,
 1319418212,
 11084,
 -1,
 1319443971,
 11080,
 1319653037,
 1318397220,
 -1,
 1319718571,
 1319595016,
 -1,
 -45398,
 1319644867,
 11146,
 -1,
 1319707108,
 11157,
 -45396,
 1319669434,
 129185,
 -1,
 1319836253,
 129193,
 1320046256,
 1319610533,
 -1,
 -45393,
 1320000371,
 129082,
 -1,
 1320034287,
 129106,
 1320242867,
 1320000591,
 -1,
 -45390,
 1320191601,
 128622,
 -1,
 1320246634,
 129189,
 1320439478,
 1320178835,
 -1,
 -45387,
 1320366333,
 129090,
 -1,
 1320428004,
 129094,
 1320636089,
 1320372174,
 -1,
 -45384,
 1320593085,
 129195,
 -1,
 1320640829,
 129078,
 -45382,
 1320602917,
 129174,
 -45381,
 1320786714,
 11078,
 -45380,
 1320841243,
 129191,
 -1,
 1320890621,
 129086,
 1321094871,
 1316749312,
 -1,
 1321160392,
 1321052325,
 -1,
 1321225925,
 1321112835,
 -1,
 1321291460,
 1321147702,
 128360,
 1321402367,
 1321208584,
 -1,
 -45373,
 1321318536,
 128362,
 -1,
 1321372189,
 128361,
 -1,
 1321221802,
 128489,
 -45370,
 1321189601,
 11779,
 -45369,
 1321557049,
 11815,
 -1,
 1321602784,
 10182,
 1321815757,
 1321082733,
 -1,
 1321881292,
 1321758309,
 -1,
 -45365,
 1321841551,
 11776,
 -1,
 1321875853,
 11777,
 -1,
 1321812895,
 128495,
 1322143440,
 1321776261,
 -1,
 -45361,
 1322098226,
 11786,
 -1,
 1322145929,
 128493,
 1322340051,
 1322072173,
 -1,
 -45358,
 1322303599,
 11817,
 -1,
 1322368317,
 11781,
 -45356,
 1322305631,
 11809,
 -45355,
 1322491291,
 11789,
 -45354,
 1322546586,
 11805,
 -1,
 1322603321,
 128381,
 1322844159,
 1321012715,
 -1,
 1322864348,
 1322731574,
 -1,
 1322929883,
 1322824682,
 4053,
 -1,
 1322847208,
 4055,
 -1,
 1322852757,
 1421,
 -45347,
 1322826381,
 8295,
 -45346,
 1323079734,
 128270,
 -1,
 1323127666,
 9957,
 1323323117,
 1316693645,
 127872,
 1323433983,
 1323237627,
 -1,
 1323454180,
 1323352917,
 -1,
 -45341,
 1323410053,
 11187,
 -1,
 1323462436,
 11186,
 1323650791,
 1323410059,
 -1,
 -45338,
 1323615058,
 11189,
 -1,
 1323645622,
 11191,
 1323847402,
 1323593513,
 -1,
 -45335,
 1323811666,
 11188,
 -1,
 1323842230,
 11190,
 1324089343,
 1323776699,
 -1,
 -45332,
 1323999877,
 11185,
 -1,
 1324052260,
 11184,
 1324240624,
 1323270547,
 128141,
 -45329,
 1324179523,
 128365,
 -1,
 1324222485,
 11824,
 1324482559,
 1324166243,
 -1,
 -45326,
 1324364363,
 127832,
 -1,
 1324426658,
 127833,
 1324633911,
 1316667163,
 -1,
 1324699430,
 1324579721,
 -1,
 1324764947,
 1324647673,
 -1,
 1324830462,
 1324725381,
 -1,
 1324895994,
 1324796686,
 -1,
 -45319,
 1324844486,
 69235,
 -1,
 1324892916,
 69226,
 1325092605,
 1324831224,
 -1,
 -45316,
 1325047859,
 69236,
 -1,
 1325098093,
 69227,
 -1,
 1325023626,
 69225,
 1325354757,
 1324787877,
 -1,
 1325420290,
 1325295223,
 -1,
 -45311,
 1325383428,
 69230,
 -1,
 1325400929,
 69239,
 1325662207,
 1325352430,
 -1,
 -45308,
 1325580036,
 69231,
 -1,
 1325597537,
 69240,
 1325813516,
 1325287374,
 -1,
 1325879049,
 1325761982,
 -1,
 -45304,
 1325843747,
 69237,
 -1,
 1325901837,
 69228,
 1326120959,
 1325816387,
 -1,
 -45301,
 1326040973,
 69238,
 -1,
 1326075131,
 69229,
 1326272271,
 1325761115,
 -1,
 -45298,
 1326235396,
 69233,
 -1,
 1326252897,
 69242,
 1326468882,
 1326202990,
 -1,
 -45295,
 1326436994,
 69232,
 -1,
 1326449505,
 69241,
 -1,
 1326418397,
 69234,
 1326731040,
 1324693402,
 -1,
 1326796567,
 1326691461,
 -1,
 -45290,
 1326763979,
 69217,
 -1,
 1326799067,
 69218,
 1326993178,
 1326753957,
 -1,
 -45287,
 1326933623,
 69221,
 -1,
 1326990830,
 69222,
 1327189789,
 1326925774,
 -1,
 -45284,
 1327140712,
 69219,
 -1,
 1327195603,
 69220,
 -45282,
 1327139256,
 69216,
 -45281,
 1327333979,
 69224,
 -1,
 1327382638,
 69223,
 1327628287,
 1326664753,
 -1,
 1327648549,
 1327532476,
 -1,
 -45277,
 1327609816,
 69245,
 -45276,
 1327668096,
 69244,
 -1,
 1327714957,
 69243,
 -1,
 1327611641,
 69246,
 1327976245,
 1324646202,
 -1,
 1328041778,
 1327913844,
 -1,
 1328107311,
 1327975506,
 -1,
 1328172844,
 1328027814,
 -1,
 -45269,
 1328104588,
 5880,
 -1,
 1328163481,
 5879,
 -45267,
 1328123362,
 5876,
 -45266,
 1328309362,
 5877,
 -1,
 1328365625,
 5878,
 -45264,
 1328065302,
 5874,
 -45263,
 1328515840,
 5875,
 -1,
 1328572445,
 5873,
 1328807935,
 1327988538,
 -1,
 -45260,
 1328701693,
 127933,
 -1,
 1328759695,
 127939,
 -45258,
 1327910514,
 127945,
 -1,
 1328883816,
 8381,
 1329090399,
 1324582334,
 -1,
 1329155919,
 1329035470,
 -1,
 1329221441,
 1329113253,
 -1,
 1329286976,
 1329151150,
 -1,
 1329352510,
 1329254983,
 -1,
 -45251,
 1329316311,
 65939,
 -1,
 1329340390,
 65936,
 -45249,
 1329312267,
 65944,
 -1,
 1329495752,
 65938,
 -1,
 1329225296,
 65941,
 1329745735,
 1329169694,
 -1,
 1329811269,
 1329678640,
 -1,
 -45244,
 1329772555,
 8583,
 -1,
 1329806804,
 8582,
 -45242,
 1329770060,
 8581,
 -1,
 1329957353,
 8584,
 1330138955,
 1329673400,
 -1,
 -45239,
 1330103374,
 65945,
 -45238,
 1330142878,
 65940,
 -1,
 1330201061,
 65942,
 -45236,
 1330102921,
 65937,
 -45235,
 1330355242,
 65943,
 -45234,
 1330392249,
 65947,
 -1,
 1330455158,
 65946,
 1330663250,
 1329119943,
 -1,
 -45231,
 1330623994,
 128907,
 -1,
 1330682489,
 128205,
 1330859861,
 1330624001,
 -1,
 -45228,
 1330826582,
 11215,
 -1,
 1330868957,
 11213,
 1331056471,
 1330817588,
 127801,
 -1,
 1331019059,
 127989,
 1331187546,
 1331000385,
 -1,
 -45223,
 1331141724,
 127906,
 -1,
 1331180844,
 128478,
 -45221,
 1331154003,
 128675,
 -45220,
 1331334660,
 128019,
 -45219,
 1331375998,
 128640,
 -45218,
 1331439916,
 129302,
 -1,
 1331503859,
 127840,
 1331711869,
 1329010854,
 -1,
 1331777396,
 1331649091,
 -1,
 1331842927,
 1331735156,
 -1,
 1331908454,
 1331778333,
 9995,
 1332019199,
 1331825416,
 -1,
 -45211,
 1331926194,
 128406,
 -1,
 1331972501,
 128400,
 1332170601,
 1331853068,
 -1,
 -45208,
 1332098341,
 127339,
 -1,
 1332161199,
 127338,
 1332367211,
 1332099230,
 11827,
 -1,
 1332328045,
 11783,
 -45204,
 1332326618,
 11787,
 -45203,
 1332437587,
 11782,
 -45202,
 1332496858,
 9994,
 -1,
 1332555966,
 11828,
 1332760433,
 1331789626,
 9926,
 -1,
 1332685179,
 127752,
 1332936703,
 1332705011,
 -1,
 -45197,
 1332853633,
 128740,
 -1,
 1332882361,
 128643,
 1333088118,
 1331705809,
 128251,
 -1,
 1333002660,
 128280,
 1333219193,
 1333014095,
 -1,
 -45192,
 1333165556,
 127949,
 -1,
 1333210041,
 127950,
 1333415803,
 1333143176,
 128007,
 -1,
 1333330658,
 128048,
 -45188,
 1333376133,
 128000,
 -1,
 1333491468,
 128015,
 1333677954,
 1331653551,
 -1,
 -45185,
 1333626302,
 983222,
 -45184,
 1333688076,
 983217,
 -45183,
 1333746243,
 983227,
 -1,
 1333804206,
 983219,
 -1,
 1333635237,
 983113,
 1334071466,
 1309264654,
 -1,
 1334136839,
 1333991590,
 -1,
 1334202356,
 1334090831,
 -1,
 1334267891,
 1334124406,
 -1,
 1334333359,
 1334226741,
 -1,
 1334398861,
 1334301314,
 -1,
 1334464395,
 1334361883,
 71875,
 -1,
 1334404854,
 71886,
 -45172,
 1334412734,
 71877,
 -1,
 1334515878,
 71876,
 1334726547,
 1334333944,
 -1,
 1334792081,
 1334674878,
 -1,
 -45168,
 1334749021,
 71899,
 -1,
 1334801556,
 71898,
 -45166,
 1334732521,
 71897,
 -1,
 1334911146,
 71900,
 1335119767,
 1334646950,
 71873,
 -45163,
 1335080069,
 71893,
 -45162,
 1335132563,
 71882,
 -1,
 1335195404,
 71894,
 1335381915,
 1335049390,
 71880,
 1335492607,
 1335328570,
 -1,
 -45158,
 1335415426,
 71885,
 -1,
 1335459642,
 71888,
 1335644062,
 1335344923,
 -1,
 -45155,
 1335607067,
 71879,
 -1,
 1335634585,
 71887,
 1335840673,
 1335601317,
 -1,
 -45152,
 1335800798,
 71901,
 -1,
 1335844330,
 71902,
 1336037283,
 1335788990,
 71881,
 -1,
 1335965174,
 71889,
 1336168358,
 1335983930,
 -1,
 -45147,
 1336132330,
 71891,
 -1,
 1336167782,
 71872,
 -45145,
 1336135151,
 71874,
 -45144,
 1336330671,
 71903,
 -45143,
 1336393011,
 71890,
 -45142,
 1336449524,
 71896,
 -45141,
 1336502997,
 71884,
 -45140,
 1336565226,
 71878,
 -45139,
 1336626531,
 71883,
 -45138,
 1336685894,
 71892,
 -1,
 1336748570,
 71895,
 1336954839,
 1334258585,
 -1,
 1337020341,
 1336922754,
 -1,
 1337085875,
 1336983323,
 71843,
 -1,
 1337026294,
 71854,
 -45132,
 1337034174,
 71845,
 -1,
 1337137318,
 71844,
 1337348027,
 1336955384,
 -1,
 1337413561,
 1337296318,
 -1,
 -45128,
 1337370461,
 71867,
 -1,
 1337422996,
 71866,
 -45126,
 1337353961,
 71865,
 -1,
 1337532586,
 71868,
 1337741247,
 1337268390,
 71841,
 -45123,
 1337701509,
 71861,
 -45122,
 1337754003,
 71850,
 -1,
 1337816844,
 71862,
 1338003395,
 1337670830,
 71848,
 1338114047,
 1337950010,
 -1,
 -45118,
 1338036866,
 71853,
 -1,
 1338081082,
 71856,
 1338265542,
 1337966363,
 -1,
 -45115,
 1338228507,
 71847,
 -1,
 1338256025,
 71855,
 1338462153,
 1338222757,
 -1,
 -45112,
 1338422238,
 71869,
 -1,
 1338465770,
 71870,
 1338658763,
 1338410430,
 71849,
 -1,
 1338586614,
 71857,
 1338789838,
 1338605370,
 -1,
 -45107,
 1338753770,
 71859,
 -1,
 1338789222,
 71840,
 -45105,
 1338756591,
 71842,
 -45104,
 1338952111,
 71871,
 -45103,
 1339014451,
 71858,
 -45102,
 1339070964,
 71864,
 -45101,
 1339124437,
 71852,
 -45100,
 1339186666,
 71846,
 -45099,
 1339247971,
 71851,
 -45098,
 1339307334,
 71860,
 -1,
 1339370010,
 71863,
 1339576293,
 1336883098,
 -1,
 1339641819,
 1339536517,
 -1,
 -45094,
 1339609035,
 71906,
 -1,
 1339644123,
 71907,
 1339838430,
 1339599013,
 -1,
 -45091,
 1339778679,
 71910,
 -1,
 1339835886,
 71911,
 1340035041,
 1339770830,
 -1,
 -45088,
 1339985768,
 71908,
 -1,
 1340040659,
 71909,
 -45086,
 1340003710,
 71904,
 -45085,
 1340180920,
 71905,
 -45084,
 1340244571,
 71913,
 -1,
 1340293230,
 71912,
 1340493810,
 1339524345,
 -1,
 1340559338,
 1340454021,
 -1,
 -45080,
 1340525705,
 71915,
 -45079,
 1340561076,
 71916,
 -1,
 1340621194,
 71914,
 1340821485,
 1340516517,
 -1,
 -45076,
 1340761784,
 71919,
 -1,
 1340818991,
 71920,
 1341018096,
 1340753870,
 -1,
 -45073,
 1340968392,
 71917,
 -1,
 1341021331,
 71918,
 -45071,
 1340965506,
 71922,
 -1,
 1341145262,
 71921,
 -1,
 1340442816,
 71935,
 -1,
 1334215335,
 9888,
 1341476858,
 1334167197,
 -1,
 1341542393,
 1341415486,
 -1,
 -45065,
 1341508939,
 127987,
 -45064,
 1341543215,
 128075,
 -1,
 1341597774,
 127988,
 -1,
 1341471931,
 11071,
 1341870080,
 1341437681,
 -1,
 1341935615,
 1341784064,
 -1,
 -45059,
 1341901843,
 127754,
 -45058,
 1341927431,
 128702,
 -1,
 1341991461,
 128003,
 -1,
 1341881077,
 127817,
 1342263299,
 1341837881,
 -1,
 -45054,
 1342197731,
 127764,
 -1,
 1342255749,
 127762,
 1342459910,
 1342210697,
 -1,
 -45051,
 1342394339,
 127766,
 -1,
 1342452357,
 127768,
 -1,
 1342419430,
 128465,
 1342722131,
 1334071800,
 -1,
 1342787665,
 1342662010,
 -1,
 1342853143,
 1342744741,
 -1,
 1342918671,
 1342816875,
 127779,
 1343029247,
 1342832640,
 -1,
 1343049742,
 1342908113,
 127781,
 -1,
 1342967082,
 127782,
 -1,
 1343016707,
 127780,
 1343246356,
 1342872421,
 -1,
 1343311891,
 1343173022,
 -1,
 -45038,
 1343277329,
 128916,
 -1,
 1343322773,
 128917,
 -1,
 1343236717,
 128307,
 1343619071,
 1343191088,
 -1,
 -45034,
 1343533508,
 11090,
 -1,
 1343583791,
 11051,
 1343770659,
 1342780600,
 -1,
 1343836189,
 1343707899,
 -1,
 1343901724,
 1343762846,
 -1,
 -45029,
 1343867134,
 128922,
 -1,
 1343912569,
 128923,
 -1,
 1343839992,
 9931,
 1344163872,
 1343790739,
 -1,
 -45025,
 1344108746,
 9920,
 -1,
 1344170599,
 9921,
 1344405503,
 1344115386,
 -1,
 -45022,
 1344302966,
 128407,
 -1,
 1344349543,
 128071,
 1344557099,
 1343712175,
 -1,
 1344622631,
 1344487389,
 -1,
 -45018,
 1344575473,
 128072,
 -1,
 1344629959,
 9945,
 1344819242,
 1344542886,
 -1,
 -45015,
 1344780804,
 128326,
 -1,
 1344840091,
 11036,
 -1,
 1344770816,
 128928,
 1345081393,
 1344517253,
 -1,
 1345146927,
 1345035343,
 -1,
 -45010,
 1345084216,
 10177,
 -1,
 1345134671,
 9186,
 -45008,
 1345114311,
 9943,
 -1,
 1345294133,
 128382,
 1345474615,
 1345016312,
 -1,
 1345540149,
 1345404078,
 -1,
 -45004,
 1345507773,
 11041,
 -1,
 1345529023,
 9989,
 -45002,
 1345490248,
 11053,
 -1,
 1345659135,
 128427,
 1345867837,
 1345406926,
 -1,
 1345933372,
 1345809327,
 -1,
 1345998907,
 1345854452,
 9872,
 -1,
 1345916036,
 9983,
 -1,
 1345950385,
 128174,
 -1,
 1345884136,
 11214,
 1346261057,
 1345813087,
 -1,
 -44993,
 1346220484,
 11088,
 -44992,
 1346270767,
 11048,
 -1,
 1346320236,
 11046,
 1346523204,
 1346226173,
 -1,
 -44989,
 1346491061,
 11038,
 -1,
 1346550032,
 11055,
 1346719815,
 1346478725,
 -1,
 -44986,
 1346637517,
 11092,
 -1,
 1346701340,
 128073,
 1346916426,
 1346671939,
 -1,
 -44983,
 1346876744,
 11040,
 -1,
 1346928587,
 127985,
 1347113037,
 1346839025,
 -1,
 -44980,
 1347075833,
 129197,
 -1,
 1347127736,
 129196,
 -44978,
 1347077033,
 128070,
 -44977,
 1347263499,
 10068,
 -44976,
 1347307234,
 10069,
 -1,
 1347366492,
 128906,
 -44974,
 1342717808,
 9855,
 -1,
 1347493265,
 128011,
 1347702927,
 1342659139,
 -1,
 1347768455,
 1347630615,
 -1,
 1347833954,
 1347727430,
 -1,
 1347899484,
 1347800233,
 -1,
 -44968,
 1347864791,
 129159,
 -44967,
 1347910247,
 129143,
 -44966,
 1347973797,
 129127,
 -44965,
 1348031642,
 129151,
 -1,
 1348085268,
 129135,
 1348337663,
 1347829250,
 -1,
 -44962,
 1348258007,
 129158,
 -44961,
 1348303463,
 129142,
 -44960,
 1348367013,
 129126,
 -44959,
 1348424858,
 129150,
 -1,
 1348478484,
 129134,
 1348685935,
 1347781501,
 -1,
 1348751465,
 1348652201,
 -1,
 -44955,
 1348716759,
 129156,
 -44954,
 1348762215,
 129140,
 -44953,
 1348825765,
 129124,
 -44952,
 1348883610,
 129148,
 -1,
 1348937236,
 129132,
 1349189631,
 1348681218,
 -1,
 -44949,
 1349109975,
 129157,
 -44948,
 1349155431,
 129141,
 -44947,
 1349218981,
 129125,
 -44946,
 1349276826,
 129149,
 -1,
 1349330452,
 129133,
 1349537909,
 1348650189,
 -1,
 -44943,
 1349503191,
 129153,
 -44942,
 1349548647,
 129137,
 -44941,
 1349612197,
 129121,
 -44940,
 1349670042,
 129145,
 -1,
 1349723668,
 129129,
 1349931131,
 1349493770,
 -1,
 -44937,
 1349896407,
 129154,
 -44936,
 1349941863,
 129138,
 -44935,
 1350005413,
 129122,
 -44934,
 1350063258,
 129146,
 -1,
 1350116884,
 129130,
 1350324353,
 1349873765,
 -1,
 -44931,
 1350289623,
 129152,
 -44930,
 1350335079,
 129136,
 -44929,
 1350398629,
 129120,
 -44928,
 1350456474,
 129144,
 -1,
 1350510100,
 129128,
 1350762495,
 1350253413,
 -1,
 -44925,
 1350682839,
 129155,
 -44924,
 1350728295,
 129139,
 -44923,
 1350791845,
 129123,
 -44922,
 1350849690,
 129147,
 -1,
 1350903316,
 129131,
 1351110797,
 1347714874,
 -1,
 1351176331,
 1351038138,
 -1,
 -44918,
 1351101887,
 127888,
 -1,
 1351166118,
 127788,
 -44916,
 1351117420,
 128521,
 -1,
 1351302378,
 127863,
 -44914,
 1351065610,
 128430,
 -1,
 1351438120,
 11838,
 1351635102,
 1347651006,
 -1,
 1351700633,
 1351579404,
 -1,
 1351766168,
 1351622313,
 128105,
 1351831703,
 1351723175,
 -1,
 -44908,
 1351788970,
 128097,
 -44907,
 1351832592,
 128082,
 -44906,
 1351888946,
 128090,
 -1,
 1351952678,
 128098,
 -1,
 1351748385,
 128111,
 -1,
 1351697034,
 128698,
 1352290461,
 1351654479,
 -1,
 -44901,
 1352245831,
 128543,
 -44900,
 1352298010,
 128506,
 -1,
 1352348942,
 11825,
 -1,
 1352233486,
 128058,
 1352618150,
 1351564462,
 -1,
 1352683682,
 1352555075,
 -1,
 -44895,
 1352617915,
 127947,
 -1,
 1352680525,
 983230,
 1352880293,
 1352606282,
 -1,
 -44892,
 1352812582,
 128553,
 -1,
 1352870889,
 128576,
 -1,
 1352807938,
 128146,
 1353142441,
 1352571983,
 -1,
 -44888,
 1353073143,
 128295,
 -1,
 1353130098,
 127873,
 -1,
 1353082614,
 983225,
 1353404741,
 1334008387,
 -1,
 1353470230,
 1353350970,
 -1,
 1353535737,
 1353427493,
 -1,
 1353601237,
 1353492451,
 -1,
 1353666761,
 1353544062,
 -1,
 1353732276,
 1353623717,
 -1,
 1353797811,
 1353652390,
 -1,
 -44878,
 1353743074,
 68430,
 -1,
 1353791235,
 68433,
 -1,
 1353733746,
 68436,
 1354059959,
 1353692293,
 -1,
 -44874,
 1353991439,
 68424,
 -1,
 1354048718,
 68437,
 1354256569,
 1353995326,
 68420,
 -1,
 1354217299,
 68423,
 1354387644,
 1354176678,
 -1,
 -44869,
 1354355666,
 68431,
 -1,
 1354395995,
 68416,
 -44867,
 1354356049,
 68422,
 -44866,
 1354552411,
 68425,
 -44865,
 1354615849,
 68421,
 -44864,
 1354670346,
 68435,
 -44863,
 1354734340,
 68434,
 -44862,
 1354798339,
 68432,
 -44861,
 1354859829,
 68429,
 -44860,
 1354922747,
 68428,
 -44859,
 1354984622,
 68427,
 -44858,
 1355049186,
 68426,
 -44857,
 1355108348,
 68418,
 -44856,
 1355167120,
 68419,
 -1,
 1355228987,
 68417,
 1355481087,
 1353614585,
 -1,
 1355501776,
 1355396229,
 -1,
 1355567310,
 1355467534,
 -1,
 -44851,
 1355515326,
 68441,
 -1,
 1355563764,
 68445,
 -44849,
 1355503835,
 68442,
 -1,
 1355694474,
 68444,
 1355894996,
 1355450808,
 68440,
 1356005375,
 1355808768,
 -1,
 -44845,
 1355921419,
 68447,
 -1,
 1355962844,
 68446,
 -1,
 1355828068,
 68443,
 1356267519,
 1353537287,
 -1,
 1356288237,
 1356165502,
 -1,
 1356353756,
 1356245157,
 -1,
 1356419291,
 1356273830,
 -1,
 -44838,
 1356364514,
 68462,
 -1,
 1356412675,
 68464,
 -1,
 1356355186,
 68465,
 1356681439,
 1356313733,
 -1,
 -44834,
 1356612879,
 68456,
 -1,
 1356670158,
 68466,
 1356878049,
 1356616766,
 68452,
 -1,
 1356838739,
 68455,
 -44830,
 1356846417,
 68454,
 -44829,
 1356977243,
 68457,
 -44828,
 1357040695,
 68453,
 -44827,
 1357092099,
 68463,
 -44826,
 1357153589,
 68461,
 -44825,
 1357216511,
 68460,
 -44824,
 1357278382,
 68459,
 -44823,
 1357342946,
 68458,
 -44822,
 1357402108,
 68450,
 -44821,
 1357460880,
 68451,
 -44820,
 1357522747,
 68449,
 -1,
 1357585836,
 68448,
 1357840383,
 1356236025,
 -1,
 1357861108,
 1357755525,
 -1,
 1357926642,
 1357826830,
 -1,
 -44815,
 1357874622,
 68473,
 -1,
 1357923060,
 68477,
 -44813,
 1357863131,
 68474,
 -1,
 1358053770,
 68476,
 1358254328,
 1357810104,
 68472,
 1358364671,
 1358168064,
 -1,
 -44809,
 1358280715,
 68479,
 -1,
 1358322140,
 68478,
 -1,
 1358187364,
 68475,
 1358582016,
 1353489037,
 -1,
 1358647550,
 1358523783,
 -1,
 -44804,
 1358606147,
 128289,
 -44803,
 1358655958,
 128292,
 -1,
 1358703529,
 128288,
 -44801,
 1358607473,
 128291,
 -1,
 1358857494,
 128290,
 1359040776,
 1358514961,
 -1,
 1359106311,
 1358998187,
 -1,
 1359171845,
 1359066245,
 -1,
 -44796,
 1359138763,
 983111,
 -1,
 1359173851,
 983108,
 -44794,
 1359120824,
 983114,
 -1,
 1359301476,
 983105,
 -1,
 1359034062,
 128129,
 1359565070,
 1359005341,
 -1,
 1359630605,
 1359496296,
 -1,
 -44789,
 1359594201,
 8276,
 -44788,
 1359648157,
 9959,
 -1,
 1359700584,
 11800,
 -1,
 1359570090,
 8292,
 1359958289,
 1359492280,
 983129,
 -44784,
 1359895331,
 8377,
 -1,
 1359955643,
 983128,
 1360154900,
 1359882905,
 -1,
 -44781,
 1360109405,
 128474,
 -1,
 1360169245,
 128232,
 -44779,
 1360115445,
 9892,
 -1,
 1360275857,
 128229,
 1360482624,
 1353416220,
 128127,
 1360592895,
 1360413692,
 -1,
 1360613683,
 1360490878,
 -1,
 1360679198,
 1360570533,
 -1,
 1360744733,
 1360599206,
 -1,
 -44772,
 1360689890,
 67662,
 -1,
 1360738051,
 67665,
 -1,
 1360680562,
 67668,
 1361006881,
 1360639109,
 -1,
 -44768,
 1360938255,
 67656,
 -1,
 1360995534,
 67669,
 1361203491,
 1360942142,
 67652,
 -1,
 1361164115,
 67655,
 1361334566,
 1361123494,
 -1,
 -44763,
 1361302482,
 67663,
 -1,
 1361342811,
 67648,
 -44761,
 1361302865,
 67654,
 -44760,
 1361499227,
 67657,
 -44759,
 1361562665,
 67653,
 -44758,
 1361617162,
 67667,
 -44757,
 1361681156,
 67666,
 -44756,
 1361745155,
 67664,
 -44755,
 1361806645,
 67661,
 -44754,
 1361869563,
 67660,
 -44753,
 1361931438,
 67659,
 -44752,
 1361996002,
 67658,
 -44751,
 1362055164,
 67650,
 -44750,
 1362113936,
 67651,
 -1,
 1362175803,
 67649,
 1362383167,
 1360561401,
 -1,
 1362448699,
 1362343045,
 -1,
 1362514232,
 1362414350,
 -1,
 -44745,
 1362462142,
 67673,
 -1,
 1362510580,
 67676,
 1362710842,
 1362444682,
 67675,
 -1,
 1362626943,
 67679,
 -1,
 1362647259,
 67674,
 1362952191,
 1362397624,
 67672,
 1363017727,
 1362821120,
 -1,
 -44738,
 1362933771,
 67678,
 -1,
 1362975196,
 67677,
 -1,
 1362340455,
 67671,
 1363235140,
 1360407651,
 -1,
 -44734,
 1363193489,
 9976,
 -44733,
 1363236668,
 127954,
 -1,
 1363292762,
 127848,
 -1,
 1363203328,
 127982,
 1363562951,
 1353344758,
 -1,
 1363628484,
 1363482790,
 -1,
 1363694011,
 1363592910,
 -1,
 1363759488,
 1363635810,
 -1,
 1363825023,
 1363721559,
 -1,
 1363890514,
 1363771194,
 -1,
 1363956046,
 1363823971,
 43412,
 1364066303,
 1363870757,
 43402,
 -1,
 1363937385,
 43403,
 1364152656,
 1363923675,
 43418,
 -1,
 1364067519,
 43416,
 1364328447,
 1364072614,
 43428,
 -1,
 1364198591,
 43423,
 1364414807,
 1363850373,
 -1,
 1364480341,
 1364374791,
 43419,
 -1,
 1364395113,
 43420,
 1364656127,
 1364400294,
 43424,
 -1,
 1364526271,
 43425,
 1364742492,
 1364341944,
 -1,
 1364808026,
 1364669766,
 43421,
 -1,
 1364722793,
 43422,
 1364983807,
 1364727974,
 43426,
 -1,
 1364853865,
 43427,
 1365070176,
 1364699440,
 43441,
 1365180415,
 1364984918,
 -1,
 -44705,
 1365099872,
 43439,
 -1,
 1365122129,
 43440,
 1365332324,
 1365021564,
 43429,
 1365442559,
 1365245952,
 -1,
 -44701,
 1365343975,
 43430,
 -1,
 1365388514,
 43401,
 1365594472,
 1365272687,
 43407,
 1365704703,
 1365508096,
 -1,
 -44697,
 1365617121,
 43408,
 -1,
 1365671655,
 43409,
 1365856619,
 1365531203,
 43398,
 -44694,
 1365793347,
 43399,
 -1,
 1365836750,
 43397,
 1366053229,
 1365810371,
 43435,
 -1,
 1365966879,
 43436,
 1366184303,
 1365993236,
 43415,
 -1,
 1366099049,
 43417,
 1366315377,
 1366117731,
 43410,
 -1,
 1366230207,
 43411,
 1366446451,
 1366239943,
 43413,
 -1,
 1366361279,
 43414,
 1366577525,
 1366369625,
 43431,
 -1,
 1366492351,
 43432,
 1366708599,
 1366497446,
 43396,
 -1,
 1366645315,
 43405,
 -44680,
 1366676187,
 43434,
 -44679,
 1366805326,
 43438,
 -44678,
 1366867739,
 43400,
 -44677,
 1366918590,
 43406,
 -44676,
 1366980450,
 43433,
 -44675,
 1367043037,
 43437,
 -44674,
 1367101966,
 43442,
 -1,
 1367162030,
 43404,
 -1,
 1363758282,
 43457,
 1367429525,
 1363710844,
 -1,
 1367495058,
 1367356745,
 -1,
 1367560583,
 1367436207,
 -1,
 1367626118,
 1367523099,
 -1,
 -44667,
 1367572993,
 43465,
 -1,
 1367628293,
 43461,
 -1,
 1367564645,
 43464,
 1367888267,
 1367480486,
 -1,
 1367953802,
 1367815742,
 43466,
 -1,
 1367867417,
 43467,
 -1,
 1367900257,
 43459,
 1368150414,
 1367839526,
 -1,
 -44659,
 1368089730,
 43468,
 -1,
 1368137626,
 43463,
 -44657,
 1368116772,
 43462,
 -44656,
 1368308297,
 43486,
 -44655,
 1368356783,
 43460,
 -1,
 1368417417,
 43487,
 1368653823,
 1367441811,
 -1,
 -44652,
 1368563230,
 43471,
 -1,
 1368615663,
 43456,
 1368805795,
 1367357338,
 -1,
 1368871321,
 1368765573,
 -1,
 -44648,
 1368838091,
 43474,
 -1,
 1368873179,
 43475,
 1369067932,
 1368828069,
 -1,
 -44645,
 1369007735,
 43478,
 -1,
 1369064942,
 43479,
 1369264543,
 1368999886,
 -1,
 -44642,
 1369214824,
 43476,
 -1,
 1369269715,
 43477,
 -44640,
 1369232766,
 43472,
 -44639,
 1369409976,
 43473,
 -44638,
 1369473627,
 43481,
 -1,
 1369522286,
 43480,
 1369723311,
 1368771226,
 -1,
 1369788841,
 1369683077,
 -1,
 1369854376,
 1369708710,
 -1,
 -44633,
 1369811041,
 43444,
 -1,
 1369863019,
 43450,
 -1,
 1369802924,
 43445,
 1370116523,
 1369756054,
 43446,
 -1,
 1370031235,
 43447,
 1370247597,
 1370076079,
 43448,
 -1,
 1370162314,
 43449,
 -44626,
 1370199473,
 43452,
 -1,
 1370306538,
 43451,
 1370509749,
 1369681270,
 -1,
 1370575282,
 1370434689,
 43393,
 -1,
 1370491251,
 43443,
 -44621,
 1370541589,
 43395,
 -44620,
 1370657817,
 43392,
 -1,
 1370713574,
 43394,
 1370902969,
 1370435890,
 -1,
 -44617,
 1370854780,
 43454,
 -44616,
 1370909106,
 43453,
 -1,
 1370958587,
 43455,
 -44614,
 1370865160,
 43469,
 -1,
 1371120406,
 43458,
 1371296195,
 1363645449,
 -1,
 -44611,
 1371255889,
 128304,
 -44610,
 1371314364,
 127971,
 -44609,
 1371375467,
 128121,
 -44608,
 1371426925,
 128122,
 -44607,
 1371486356,
 127886,
 -44606,
 1371548642,
 127983,
 -1,
 1371612614,
 9979,
 -1,
 1371221851,
 127875,
 -44603,
 1363591994,
 9909,
 -44602,
 1371837165,
 128377,
 -1,
 1371880911,
 128086,
 1372082764,
 1363494862,
 -1,
 1372148206,
 1372002470,
 -1,
 1372213734,
 1372072601,
 -1,
 1372279268,
 1372142768,
 -1,
 1372344799,
 1372245596,
 -1,
 1372410334,
 1372258304,
 -1,
 1372475857,
 1372369750,
 128539,
 1372585983,
 1372389447,
 -1,
 -44592,
 1372507716,
 128540,
 -1,
 1372567867,
 128541,
 1372738005,
 1372423614,
 -1,
 1372803540,
 1372689761,
 128558,
 -1,
 1372717144,
 128560,
 -1,
 1372743714,
 128582,
 1373000152,
 1372697733,
 -1,
 -44585,
 1372935449,
 129298,
 -1,
 1372995039,
 128514,
 -44583,
 1372956300,
 128580,
 -44582,
 1373143844,
 128581,
 -44581,
 1373207115,
 128567,
 -44580,
 1373271306,
 128548,
 -44579,
 1373328468,
 129301,
 -1,
 1373384787,
 128531,
 -1,
 1372360809,
 128566,
 1373655522,
 1372301477,
 -1,
 -44575,
 1373581920,
 128561,
 -1,
 1373643934,
 128523,
 -44573,
 1373616313,
 128536,
 -1,
 1373796757,
 128134,
 -44571,
 1372240726,
 127981,
 -1,
 1373941180,
 8507,
 1374114281,
 1372180896,
 -1,
 -44568,
 1374058359,
 128224,
 -1,
 1374116809,
 128439,
 1374310892,
 1374057453,
 -1,
 -44565,
 1374249045,
 9950,
 -1,
 1374306705,
 127810,
 -44563,
 1374271403,
 127877,
 -1,
 1374452901,
 128106,
 1374638603,
 1372084803,
 -1,
 1374704122,
 1374592079,
 -1,
 1374769653,
 1374633134,
 128293,
 1374835188,
 1374736690,
 -1,
 -44557,
 1374791845,
 127878,
 -1,
 1374816503,
 127879,
 -1,
 1374749388,
 128658,
 1375141887,
 1374728584,
 -1,
 1375162873,
 1375050641,
 -1,
 -44552,
 1375129207,
 127771,
 -1,
 1375188034,
 127763,
 -1,
 1375122232,
 8296,
 1375425026,
 1374645167,
 -1,
 1375490559,
 1375354032,
 -1,
 -44547,
 1375447713,
 983106,
 -44546,
 1375488746,
 128193,
 -1,
 1375546081,
 128452,
 1375797247,
 1375434510,
 -1,
 -44543,
 1375705517,
 128253,
 -1,
 1375751243,
 127902,
 1375949319,
 1375381669,
 -1,
 1376014854,
 1375883768,
 128031,
 -44539,
 1375953131,
 127907,
 -1,
 1375994284,
 127845,
 -1,
 1375975007,
 128074,
 1376277002,
 1375913861,
 -1,
 -44535,
 1376229904,
 8281,
 -1,
 1376286999,
 11821,
 -1,
 1376207080,
 127953,
 1376539167,
 1374586302,
 -1,
 1376604693,
 1376501531,
 -1,
 1376670228,
 1376558161,
 -1,
 1376735761,
 1376598178,
 -1,
 -44528,
 1376688656,
 8280,
 -1,
 1376745751,
 8283,
 -44526,
 1376688084,
 128966,
 -44525,
 1376874204,
 127808,
 -1,
 1376924171,
 11156,
 -1,
 1376617588,
 9970,
 1377194523,
 1376558159,
 -1,
 1377260058,
 1377134621,
 -1,
 1377325593,
 1377173629,
 127860,
 -1,
 1377242398,
 127869,
 -1,
 1377255172,
 11792,
 -1,
 1377203999,
 983071,
 1377587741,
 1377127700,
 127787,
 -1,
 1377522130,
 127745,
 -44514,
 1377537700,
 128099,
 -1,
 1377660494,
 128448,
 1377849902,
 1376480175,
 -1,
 1377915430,
 1377797566,
 -1,
 1377980965,
 1377881253,
 9880,
 1378091007,
 1377896130,
 -1,
 -44508,
 1378009760,
 8277,
 -1,
 1378053612,
 127924,
 -1,
 1377933617,
 128190,
 1378308649,
 1377844398,
 -1,
 -44504,
 1378275835,
 128170,
 -1,
 1378338101,
 9884,
 1378505260,
 1378228390,
 -1,
 -44501,
 1378466429,
 9189,
 -1,
 1378503965,
 9971,
 -44499,
 1378472936,
 128389,
 -1,
 1378665981,
 128563,
 1378832953,
 1377803343,
 -1,
 1378898483,
 1378780606,
 -1,
 -44495,
 1378865038,
 128550,
 -44494,
 1378911322,
 128037,
 -1,
 1378962710,
 128056,
 1379160631,
 1378819705,
 -1,
 -44491,
 1379121545,
 128445,
 -44490,
 1379178110,
 128444,
 -1,
 1379212976,
 128446,
 -44488,
 1379097678,
 127844,
 -1,
 1379353084,
 127839,
 1379553856,
 1378795291,
 -1,
 1379619389,
 1379496957,
 -1,
 -44484,
 1379585655,
 127773,
 -1,
 1379644482,
 127765,
 -44482,
 1379576372,
 9179,
 -44481,
 1379762472,
 9905,
 -1,
 1379811548,
 9981,
 1380012612,
 1379519221,
 -1,
 -44478,
 1379930791,
 983211,
 -44477,
 1379996034,
 983210,
 -1,
 1380061275,
 983209,
 1380274761,
 1379941550,
 -1,
 1380340296,
 1380231005,
 -1,
 -44473,
 1380307586,
 9972,
 -1,
 1380344949,
 127905,
 -1,
 1380262173,
 128552,
 1380602443,
 1380231333,
 983107,
 -1,
 1380538947,
 983228,
 -1,
 1380534222,
 983072,
 1380799168,
 1372045083,
 -1,
 1380864652,
 1380750118,
 -1,
 1380930173,
 1380830115,
 -1,
 1380995684,
 1380889733,
 -1,
 1381061219,
 1380950524,
 -1,
 1381126754,
 1380978256,
 -1,
 1381192288,
 1381048804,
 11105,
 1381302271,
 1381105664,
 -1,
 1381323358,
 1381224033,
 -1,
 1381388888,
 1381266684,
 -1,
 -44457,
 1381344255,
 11171,
 -1,
 1381396571,
 11170,
 -44455,
 1381353709,
 129073,
 -44454,
 1381531608,
 129057,
 -44453,
 1381595784,
 129061,
 -44452,
 1381651627,
 129069,
 -44451,
 1381710404,
 11131,
 -1,
 1381771535,
 129065,
 -44449,
 1381284486,
 11121,
 -1,
 1381920943,
 11137,
 -44447,
 1381143494,
 11141,
 -1,
 1382036948,
 11115,
 -1,
 1381040429,
 129169,
 -1,
 1381027998,
 11245,
 1382371950,
 1380915366,
 -1,
 1382437485,
 1382328213,
 -1,
 1382503017,
 1382395575,
 -1,
 -44440,
 1382464523,
 129025,
 -1,
 1382499193,
 129041,
 -44438,
 1382450078,
 129177,
 -44437,
 1382644387,
 129029,
 -44436,
 1382706467,
 129033,
 -1,
 1382761337,
 129045,
 -1,
 1382383642,
 11797,
 1383027313,
 1382337816,
 -1,
 -44432,
 1382993758,
 129173,
 -1,
 1383025770,
 11192,
 1383223924,
 1382983845,
 -1,
 -44429,
 1383177075,
 129081,
 -1,
 1383210991,
 129105,
 1383420535,
 1383158931,
 -1,
 -44426,
 1383346429,
 129089,
 -1,
 1383408100,
 129093,
 1383617146,
 1383344174,
 -1,
 -44423,
 1383542467,
 11145,
 -1,
 1383604708,
 11014,
 -44421,
 1383573078,
 128621,
 -44420,
 1383745923,
 129077,
 -1,
 1383805181,
 129085,
 1384010372,
 1380847298,
 -1,
 1384075905,
 1383968439,
 -1,
 -44416,
 1384030231,
 128316,
 -1,
 1384062119,
 128744,
 -44414,
 1384030231,
 128314,
 -44413,
 1384217727,
 128742,
 -1,
 1384258727,
 128743,
 1384469130,
 1383923712,
 -1,
 1384534665,
 1384397499,
 -1,
 -44409,
 1384496209,
 11109,
 -44408,
 1384556998,
 129113,
 -1,
 1384589365,
 11021,
 -1,
 1384456719,
 11193,
 -44405,
 1384426811,
 128579,
 -1,
 1384814023,
 128319,
 1384993461,
 1380797970,
 -1,
 1385058996,
 1384935806,
 -1,
 1385124500,
 1385015461,
 -1,
 1385190034,
 1385044134,
 -1,
 -44399,
 1385135378,
 66450,
 -1,
 1385182728,
 66453,
 -44397,
 1385149287,
 66461,
 -1,
 1385322098,
 66444,
 1385517720,
 1385084037,
 -1,
 -44394,
 1385465278,
 66458,
 -44393,
 1385518010,
 66456,
 -1,
 1385579751,
 66441,
 1385779867,
 1385485509,
 -1,
 -44390,
 1385742107,
 66449,
 -1,
 1385776379,
 66439,
 1385976478,
 1385719837,
 -1,
 -44387,
 1385910798,
 66435,
 -1,
 1385962407,
 66443,
 1386173088,
 1385912110,
 66437,
 -1,
 1386132743,
 66440,
 1386304163,
 1386106132,
 -1,
 -44382,
 1386238548,
 66457,
 -1,
 1386290823,
 66434,
 1386500774,
 1386230968,
 -1,
 -44379,
 1386435203,
 66447,
 -1,
 1386496315,
 66436,
 1386697385,
 1386420390,
 -1,
 -44376,
 1386640951,
 66432,
 -1,
 1386700488,
 66451,
 -44374,
 1386665047,
 66442,
 -44373,
 1386860491,
 66438,
 -44372,
 1386921755,
 66460,
 -44371,
 1386978895,
 66455,
 -44370,
 1387043583,
 66454,
 -44369,
 1387108852,
 66452,
 -44368,
 1387169077,
 66448,
 -44367,
 1387231995,
 66446,
 -44366,
 1387293864,
 66445,
 -44365,
 1387354691,
 66459,
 -1,
 1387407151,
 66433,
 -1,
 1385025793,
 66463,
 1387680444,
 1384939322,
 -1,
 1387745977,
 1387616835,
 -1,
 -44360,
 1387705567,
 983115,
 -1,
 1387737601,
 129412,
 -44358,
 1387690324,
 9903,
 -44357,
 1387867368,
 11217,
 -1,
 1387929245,
 128530,
 1388139199,
 1387624962,
 -1,
 -44354,
 1388105418,
 9748,
 -1,
 1388153157,
 9969,
 -1,
 1388095653,
 983116,
 1388401352,
 1380766917,
 -1,
 1388466887,
 1388366606,
 -1,
 1388532421,
 1388412730,
 -1,
 -44348,
 1388472054,
 983214,
 -1,
 1388521995,
 983255,
 -44346,
 1388490852,
 983213,
 -1,
 1388668662,
 983215,
 -1,
 1388405649,
 129296,
 1388925643,
 1388368514,
 -1,
 -44342,
 1388862069,
 983235,
 -1,
 1388921111,
 128155,
 -1,
 1388878905,
 9915]
_charnames_564 = [
6505,
6569,
6331,
6550,
6553,
6630,
6713,
6800,
6560,
6791,
6687,
6355,
6621,
6841,
6635,
6832,
6787,
6677,
6703,
6378,
6838,
6647,
6763,
6628,
6742,
6441,
6848,
6639,
]

_charnames_751 = [
9490,
9494,
9484,
9493,
9492,
9521,
9519,
9520,
9495,
9532,
9544,
9515,
9543,
9514,
9435,
9546,
9483,
]

_charnames_848 = [
1790,
1702,
1849,
1844,
1699,
1791,
1788,
1793,
1752,
1816,
1742,
1841,
1741,
1740,
1738,
1739,
]

_charnames_880 = [
17575,
17553,
17576,
17554,
-1,
-1,
17574,
17552,
-1,
-1,
-1,
17556,
17558,
17557,
-1,
17573,
]

_charnames_1015 = [
17571,
17550,
17577,
17572,
17551,
17618,
17579,
17582,
17580,
]

_charnames_1270 = [
2879,
2797,
-1,
-1,
2878,
2796,
2861,
2776,
2860,
2775,
]

_charnames_1296 = [
2835,
2750,
2843,
2758,
2884,
2801,
2839,
2754,
2857,
2772,
2881,
2799,
2880,
2798,
2885,
2802,
2842,
2757,
2846,
2761,
2882,
2790,
2832,
2747,
2847,
2762,
2807,
2722,
2816,
2731,
2844,
2759,
]

_charnames_1536 = [
11632,
11552,
11616,
11555,
11553,
11633,
11644,
11643,
11610,
11642,
11641,
12077,
-1,
11621,
11636,
11560,
11554,
11561,
11557,
11558,
11559,
11578,
11579,
11576,
11581,
11582,
11580,
-1,
11491,
-1,
11596,
-1,
11435,
]

_charnames_1622 = [
11583,
11638,
11390,
11634,
11624,
11625,
11626,
11609,
11613,
11635,
]

_charnames_1869 = [
5273,
5274,
5275,
11415,
11421,
11413,
11414,
11416,
11419,
11417,
11463,
11464,
11494,
11498,
11448,
11441,
11471,
11473,
11470,
11407,
11408,
11430,
11428,
11426,
11489,
11488,
11508,
11507,
11506,
11512,
11450,
11453,
11438,
11461,
11459,
11439,
11449,
11460,
11476,
11477,
11398,
11399,
11400,
11501,
11502,
11483,
11484,
11465,
11442,
11440,
11433,
]

_charnames_1984 = [
19823,
19824,
19815,
19816,
19821,
19822,
19818,
19819,
19826,
19825,
19810,
19792,
19804,
19791,
19797,
19790,
19789,
19794,
19775,
19809,
19800,
19798,
19785,
19808,
19793,
19788,
19787,
19799,
19806,
19807,
19803,
19802,
19779,
19801,
19776,
19778,
19805,
19796,
19795,
19777,
19783,
19784,
19782,
19837,
19836,
19835,
19833,
19832,
19831,
19830,
19838,
19839,
19844,
19811,
19842,
19843,
19840,
19845,
19812,
-1,
-1,
-1,
-1,
-1,
4813,
4800,
4810,
4812,
4793,
4801,
4802,
4794,
4790,
4803,
4809,
4808,
4807,
4806,
4797,
4795,
4811,
4789,
4805,
4804,
4798,
4791,
4853,
4854,
4855,
4858,
4862,
4857,
4820,
4831,
4823,
4817,
4828,
4822,
4816,
4827,
4860,
4826,
4818,
4829,
4861,
4819,
4830,
4821,
4825,
4856,
-1,
-1,
4848,
4839,
4836,
4850,
4837,
4845,
4863,
4849,
4841,
4847,
4842,
4846,
4838,
4844,
4835,
-1,
9795,
9789,
9787,
9788,
9786,
9793,
9778,
9791,
9775,
9777,
9776,
9784,
9783,
9782,
9771,
9792,
9781,
9772,
9780,
9779,
9773,
9774,
9796,
9794,
9785,
9800,
9797,
9799,
-1,
-1,
9798,
]

_charnames_2208 = [
11418,
11420,
11517,
11515,
11409,
11516,
11511,
11490,
11480,
11481,
11451,
11503,
11454,
11513,
11495,
11444,
11518,
11443,
11514,
11474,
11434,
]

_charnames_2275 = [
11595,
11600,
11602,
11598,
11601,
11603,
11599,
11591,
11588,
11594,
11590,
11587,
11593,
11629,
11630,
11628,
11577,
11614,
11615,
11637,
11521,
11606,
11520,
11608,
11618,
11619,
11607,
11622,
11389,
18960,
-1,
-1,
-1,
18941,
]

_charnames_2382 = [
18970,
18972,
-1,
-1,
-1,
-1,
-1,
18971,
18966,
18965,
]

_charnames_2417 = [
18961,
18946,
18936,
18935,
18948,
18933,
18932,
18942,
18940,
18944,
18939,
18943,
18938,
18945,
18947,
13724,
]

_charnames_2555 = [
13723,
-1,
-1,
-1,
-1,
-1,
17952,
-1,
17950,
]

_charnames_2929 = [
17344,
17333,
17334,
17338,
17332,
17335,
17337,
]

_charnames_3059 = [
14103,
14108,
14104,
14102,
14099,
14110,
14105,
14107,
-1,
-1,
-1,
-1,
-1,
14867,
]

_charnames_3192 = [
14859,
14857,
14851,
14854,
14858,
14852,
14855,
14866,
-1,
18538,
]

_charnames_3386 = [
9947,
-1,
-1,
9967,
-1,
-1,
-1,
-1,
-1,
-1,
9954,
]

_charnames_3440 = [
9959,
9958,
9957,
9962,
9963,
9964,
-1,
-1,
-1,
9968,
9942,
9941,
9945,
9943,
9944,
9946,
]

_charnames_3558 = [
4435,
4436,
4427,
4428,
4433,
4434,
4430,
4431,
4438,
4437,
]

_charnames_4046 = [
14710,
-1,
14696,
14700,
14699,
14702,
14703,
20185,
7052,
20186,
7053,
14701,
14698,
]

_charnames_4130 = [
10025,
-1,
-1,
-1,
-1,
-1,
10084,
-1,
-1,
10170,
]

_charnames_4147 = [
10167,
10166,
10172,
-1,
-1,
-1,
-1,
10127,
10194,
10196,
10195,
10197,
10093,
]

_charnames_4186 = [
10082,
10083,
10081,
10080,
10199,
10200,
10201,
10029,
10157,
10190,
10189,
10090,
10091,
10164,
10163,
10118,
10117,
10116,
10115,
10114,
10087,
10086,
10088,
10171,
10160,
10159,
10161,
10008,
10007,
10011,
10014,
10018,
10003,
10024,
10005,
10020,
10023,
10017,
10019,
10022,
10202,
10156,
10153,
10154,
10155,
10106,
10105,
10104,
10103,
10110,
10109,
10111,
10092,
10125,
10138,
10139,
10130,
10131,
10136,
10137,
10133,
10134,
10141,
10140,
10124,
10123,
10168,
10169,
10148,
10149,
]

_charnames_4295 = [
17931,
-1,
-1,
-1,
-1,
-1,
17932,
]

_charnames_4345 = [
17927,
17924,
-1,
9547,
17925,
17929,
17928,
]

_charnames_4992 = [
8523,
8604,
8603,
8602,
8525,
8540,
8539,
8538,
8524,
8609,
8608,
8607,
8522,
8597,
8596,
8595,
8628,
8622,
8630,
8629,
8624,
8627,
8632,
8631,
8623,
8626,
]

_charnames_5109 = [
2429,
-1,
-1,
2385,
2384,
2383,
2382,
2381,
2402,
-1,
-1,
2559,
]

_charnames_5751 = [
2475,
2471,
2472,
2469,
2470,
2473,
2474,
2476,
2544,
]

_charnames_5873 = [
20273,
20271,
20272,
20268,
20269,
20270,
20267,
20266,
]

_charnames_6128 = [
18028,
18029,
18024,
18027,
18026,
18017,
18023,
18022,
18021,
18020,
]

_charnames_6314 = [
9671,
-1,
-1,
-1,
-1,
-1,
2465,
2555,
2556,
2482,
2538,
2539,
2537,
2507,
2550,
2549,
2557,
2524,
2525,
2558,
2495,
2484,
2493,
2494,
2492,
2546,
2547,
2516,
2522,
2456,
2523,
2457,
2520,
2454,
2521,
2455,
2514,
2512,
2513,
2510,
2511,
2515,
2461,
2460,
2463,
2464,
2462,
2452,
2458,
2459,
2560,
2481,
2552,
2553,
2517,
2479,
2480,
2505,
2506,
2498,
2499,
2500,
2502,
2503,
2487,
2488,
2490,
2529,
2534,
2531,
2530,
2489,
2535,
2543,
2542,
2533,
]

_charnames_6400 = [
6185,
6135,
6134,
6124,
6123,
6131,
6144,
6143,
6138,
6137,
6126,
6116,
6115,
6141,
6140,
6132,
6129,
6128,
6147,
6146,
6150,
6125,
6149,
6151,
6148,
6119,
6118,
6120,
6152,
6122,
6114,
-1,
6176,
6184,
6183,
6182,
6178,
6180,
6177,
6181,
6179,
6171,
6173,
6172,
-1,
-1,
-1,
-1,
6163,
6156,
6164,
6158,
6157,
6160,
6161,
6159,
6162,
6167,
6169,
6166,
-1,
-1,
-1,
-1,
6168,
-1,
-1,
-1,
6201,
6200,
6196,
6197,
6188,
6189,
6194,
6195,
6191,
6192,
6199,
6198,
14405,
14407,
14401,
14384,
14409,
14406,
14386,
14385,
14412,
14397,
14396,
14411,
14415,
14408,
14414,
14410,
14404,
14383,
14402,
14390,
14413,
14389,
14388,
14393,
14399,
14398,
14394,
14387,
14391,
14392,
-1,
-1,
14381,
14380,
14379,
14378,
14377,
]

_charnames_6528 = [
19636,
19607,
19633,
19621,
19629,
19604,
19592,
19600,
19616,
19624,
19634,
19587,
19595,
19605,
19618,
19617,
19630,
19589,
19588,
19601,
19627,
19626,
19637,
19598,
19597,
19608,
19640,
19635,
19638,
19611,
19606,
19609,
19639,
19641,
19642,
19610,
19612,
19613,
19632,
19620,
19603,
19591,
19623,
19594,
-1,
-1,
-1,
-1,
19669,
19662,
19668,
19652,
19656,
19670,
19665,
19657,
19658,
19653,
19664,
19663,
19655,
19660,
19659,
19654,
19667,
19646,
19645,
19644,
19647,
19648,
19649,
19650,
19688,
19687,
-1,
-1,
-1,
-1,
-1,
-1,
19681,
19682,
19673,
19674,
19679,
19680,
19676,
19677,
19684,
19683,
19689,
-1,
-1,
-1,
19690,
19691,
17992,
18039,
17991,
18036,
18033,
17988,
17985,
17982,
17979,
17976,
18014,
18011,
18001,
18008,
18005,
17998,
18040,
18038,
17990,
18035,
18032,
17987,
17984,
17981,
17978,
17975,
18013,
18010,
18000,
18007,
18004,
17997,
13650,
13653,
13637,
13636,
13648,
13656,
13642,
13641,
13645,
13654,
13639,
13638,
13655,
13651,
13634,
13633,
13643,
13647,
13649,
13644,
13646,
13657,
13652,
13661,
13659,
13662,
13660,
13663,
-1,
-1,
13664,
13665,
14146,
14145,
14144,
14119,
14117,
14118,
14167,
14155,
14154,
14128,
14130,
14127,
14166,
14162,
14157,
14178,
14131,
14163,
14149,
14148,
14122,
14121,
14168,
14179,
14152,
14151,
14159,
14125,
14133,
14124,
14175,
14129,
14156,
14161,
14164,
14134,
14136,
14173,
14141,
14140,
14142,
14158,
14137,
14180,
14132,
14171,
14172,
14169,
14170,
14177,
14174,
14135,
14176,
14269,
14270,
14274,
14199,
14277,
14273,
14276,
14271,
14278,
14275,
-1,
14196,
14226,
14235,
14229,
14232,
14233,
14234,
14225,
14224,
14222,
14223,
14216,
14218,
14220,
14236,
14228,
14221,
14227,
14231,
14219,
14198,
14206,
14205,
14187,
14186,
14185,
14209,
14201,
14188,
-1,
-1,
14279,
14261,
14262,
14253,
14254,
14259,
14260,
14256,
14257,
14264,
14263,
-1,
-1,
-1,
-1,
-1,
-1,
14247,
14248,
14239,
14240,
14245,
14246,
14242,
14243,
14250,
14249,
-1,
-1,
-1,
-1,
-1,
-1,
14202,
14203,
14195,
14191,
14211,
14213,
14208,
14200,
14189,
14190,
14193,
14194,
14212,
14214,
-1,
-1,
1747,
1754,
1847,
1753,
1830,
1843,
1848,
1802,
1744,
1708,
1833,
1838,
1743,
1837,
1836,
]

_charnames_6912 = [
13156,
13157,
13160,
13158,
13161,
13042,
13043,
13064,
13065,
13056,
13057,
13051,
13052,
13054,
13055,
13069,
13045,
13060,
13061,
13031,
13033,
13066,
13067,
13029,
13071,
13072,
13062,
13063,
13028,
13023,
13022,
13039,
13038,
13027,
13019,
13021,
13035,
13040,
13026,
13058,
13059,
13073,
13074,
13079,
13076,
13050,
13053,
13077,
13049,
13048,
13046,
13080,
13159,
13129,
13130,
13131,
13132,
13133,
13134,
13135,
13138,
13139,
13124,
13126,
13128,
13127,
13136,
13137,
13173,
13032,
13034,
13024,
13070,
13078,
13075,
13044,
-1,
-1,
-1,
-1,
13150,
13151,
13142,
13143,
13148,
13149,
13145,
13146,
13153,
13152,
13166,
13165,
13172,
13170,
13171,
13169,
13164,
13094,
13092,
13093,
13084,
13086,
13095,
13089,
13091,
13088,
13087,
13102,
13105,
13098,
13100,
13103,
13099,
13101,
13106,
13104,
13117,
13118,
13120,
13121,
13111,
13109,
13114,
13113,
13110,
-1,
-1,
-1,
5107,
5106,
5105,
5050,
5064,
5057,
5051,
5061,
5045,
5046,
5044,
5059,
5066,
5026,
5068,
5063,
5052,
5025,
5058,
5067,
5027,
5060,
5032,
5056,
5049,
5062,
5053,
5038,
5041,
5055,
5035,
5054,
5065,
5117,
5116,
5115,
5097,
5095,
5099,
5096,
5100,
5098,
5108,
5109,
5113,
5112,
5043,
5034,
5079,
5080,
5071,
5072,
5077,
5078,
5074,
5075,
5082,
5081,
5118,
5037,
5040,
5048,
5031,
5030,
13233,
13202,
13228,
13200,
13216,
13232,
13225,
13218,
13197,
13210,
13215,
13221,
13194,
13219,
13229,
13201,
13226,
13230,
13223,
13196,
13212,
13198,
13203,
13207,
13204,
13195,
13214,
13220,
13193,
13208,
13224,
13199,
13206,
13231,
13209,
13217,
13227,
13222,
13252,
13240,
13242,
13241,
13244,
13239,
13243,
13238,
13235,
13236,
13257,
13258,
13255,
13254,
]

_charnames_7164 = [
13250,
13248,
13251,
13249,
7080,
7078,
7079,
7096,
7095,
7075,
7102,
7101,
7111,
7074,
7068,
7067,
7084,
7076,
7072,
7070,
7071,
7099,
7098,
7105,
7104,
7090,
7089,
7066,
7065,
7082,
7106,
7109,
7110,
7093,
7092,
7108,
7087,
7086,
7107,
7112,
7154,
7155,
7144,
7142,
7140,
7141,
7138,
7139,
7143,
7130,
7135,
7136,
7128,
7134,
7133,
7132,
7129,
7131,
7157,
7158,
-1,
-1,
-1,
7149,
7150,
7151,
7148,
7147,
7123,
7124,
7115,
7116,
7121,
7122,
7118,
7119,
7126,
7125,
-1,
-1,
-1,
7063,
7062,
7083,
17262,
17263,
17254,
17255,
17260,
17261,
17257,
17258,
17265,
17264,
17226,
17221,
17224,
17222,
17223,
17227,
17219,
17220,
17218,
17217,
17230,
17243,
17246,
17245,
17244,
17228,
17236,
17235,
17234,
17233,
17231,
17249,
17251,
17250,
17248,
17229,
17239,
17241,
17238,
17240,
17273,
17275,
17272,
17274,
17270,
17276,
17268,
17269,
]

_charnames_7360 = [
5087,
5086,
5085,
5091,
5088,
5089,
5090,
5092,
]

_charnames_7376 = [
15937,
15941,
15942,
15913,
15910,
15922,
15921,
15919,
15939,
15920,
15929,
15925,
15936,
15931,
15924,
15926,
15934,
15943,
15903,
15899,
15906,
15901,
15907,
15900,
15902,
15896,
15895,
15892,
15893,
15912,
15916,
15914,
15908,
15894,
15897,
15909,
15940,
15915,
15911,
-1,
15933,
15930,
-1,
-1,
-1,
-1,
-1,
-1,
6878,
6879,
6322,
6893,
6892,
6891,
6877,
6875,
6310,
6314,
6889,
6888,
6887,
6886,
6869,
6872,
6874,
6338,
6339,
6340,
6304,
6873,
6334,
6526,
6885,
6868,
6863,
6861,
6883,
6341,
6343,
6342,
6882,
6881,
6880,
6876,
6895,
6896,
17591,
17590,
17587,
17588,
17586,
2887,
9448,
9449,
9446,
9447,
9463,
9462,
9441,
9461,
9444,
9460,
9459,
9458,
9457,
9456,
9455,
9440,
9442,
9443,
9454,
9438,
9453,
9452,
9450,
9410,
9347,
9411,
9349,
9391,
9407,
9375,
9388,
9402,
9353,
9403,
9354,
9426,
9420,
9379,
9399,
9401,
9356,
9392,
9415,
9345,
9380,
9389,
9350,
9413,
9412,
9393,
9406,
9409,
9405,
9366,
6668,
6660,
6658,
6657,
17564,
17562,
17560,
17561,
17563,
6435,
6523,
6544,
6645,
6581,
6573,
6593,
6444,
6445,
6358,
6329,
6623,
6321,
9478,
6397,
6327,
6652,
6415,
6589,
6651,
6431,
6522,
6543,
6644,
6633,
6601,
6501,
6580,
6571,
6592,
6442,
6356,
6384,
6531,
6619,
6622,
6483,
6491,
6545,
6379,
6464,
6452,
6350,
6411,
6460,
6383,
6428,
6388,
9348,
9359,
9367,
9377,
9425,
9429,
9408,
9387,
9355,
9424,
9423,
9361,
9362,
9427,
9370,
9371,
9365,
9421,
9351,
9419,
9418,
9364,
9394,
9416,
9390,
9378,
9358,
9383,
9384,
9363,
9414,
9352,
9395,
9397,
9398,
9376,
9357,
1750,
1751,
1834,
1832,
1813,
1775,
1811,
1819,
1776,
1820,
1670,
1850,
1812,
1746,
1803,
1840,
1846,
1824,
1823,
1675,
1658,
1656,
1655,
1688,
1686,
1677,
1687,
1694,
1685,
1660,
1693,
1692,
1684,
1691,
1690,
1669,
1666,
1661,
1681,
1657,
1679,
1680,
1667,
1674,
1662,
1672,
1683,
1678,
1664,
1682,
1659,
1673,
1665,
1825,
-1,
-1,
-1,
-1,
-1,
-1,
1745,
1821,
1700,
1789,
]

_charnames_8275 = [
5428,
20746,
21027,
14899,
-1,
21007,
21000,
15015,
21008,
18747,
14994,
15972,
-1,
-1,
-1,
-1,
-1,
20749,
-1,
7055,
20188,
20985,
16768,
]

_charnames_8336 = [
6671,
6670,
6662,
6656,
6655,
6669,
6666,
6665,
6664,
6663,
6661,
6654,
6659,
]

_charnames_8370 = [
17955,
12054,
19578,
3264,
6293,
5337,
14881,
20751,
14982,
19886,
9809,
20278,
6920,
]

_charnames_8524 = [
16739,
12076,
14965,
5286,
15986,
15987,
15985,
]

_charnames_8580 = [
6450,
20293,
20292,
20291,
20294,
15988,
14969,
14970,
]

_charnames_9167 = [
8775,
15971,
9333,
9330,
9331,
9329,
9324,
9325,
9326,
9327,
9332,
8754,
21053,
14951,
13680,
14953,
13683,
14949,
13678,
20526,
13728,
5309,
21034,
12063,
8699,
19003,
13553,
13564,
13604,
13578,
13554,
13565,
13555,
11819,
5319,
14725,
19531,
13504,
13516,
13511,
13508,
18732,
13521,
13549,
]

_charnames_9866 = [
9661,
9660,
19039,
19032,
19033,
19038,
20537,
13618,
19300,
11196,
3241,
5303,
5409,
11815,
21025,
17933,
5302,
12065,
21032,
17379,
14895,
14896,
20467,
19563,
18739,
18738,
20756,
9973,
9971,
9972,
15970,
19521,
9309,
9318,
9300,
9995,
19059,
21177,
2114,
21054,
19767,
3262,
16343,
20932,
15974,
2440,
13518,
5414,
5417,
21195,
5416,
5207,
13309,
4980,
20510,
20511,
13583,
13584,
5421,
5123,
20335,
13531,
14917,
14978,
14976,
20508,
3248,
19052,
17366,
16784,
2626,
19504,
3223,
2326,
19891,
11816,
13592,
20527,
13569,
20518,
19080,
19466,
7049,
4974,
20970,
13593,
20079,
20078,
12068,
19461,
16741,
20190,
7057,
20747,
13548,
4673,
2444,
2712,
19566,
17935,
17936,
9993,
9674,
21182,
21012,
21035,
21062,
4875,
5018,
5437,
20801,
16728,
14879,
20930,
19493,
21055,
1579,
20538,
13533,
-1,
-1,
-1,
-1,
20532,
-1,
-1,
-1,
-1,
20333,
20322,
]

_charnames_10060 = [
3247,
-1,
19733,
-1,
-1,
-1,
-1,
13619,
20558,
20559,
-1,
19451,
]

_charnames_10175 = [
18736,
14900,
20525,
16736,
17353,
17352,
7031,
20167,
17347,
20072,
5132,
15973,
9979,
7246,
9990,
4969,
4968,
]

_charnames_11008 = [
19882,
19872,
5196,
5186,
7022,
7000,
21113,
18721,
19884,
19874,
5198,
5188,
7025,
21128,
20121,
20120,
6979,
6978,
4998,
5000,
4997,
4999,
19044,
19043,
19042,
19045,
18744,
13572,
20521,
13597,
20546,
13609,
20552,
20531,
13614,
19520,
13573,
13510,
20544,
13506,
20543,
13527,
13526,
20502,
13613,
20533,
13600,
20547,
7034,
14897,
7035,
7245,
6969,
6970,
6971,
6972,
6990,
6981,
6982,
6964,
6966,
6967,
6996,
20473,
8773,
20068,
6994,
20131,
20130,
7016,
20154,
20067,
20134,
14721,
6995,
6993,
20133,
18698,
4663,
4662,
20542,
13525,
20501,
13556,
20549,
19428,
19481,
19462,
19459,
19463,
5397,
13323,
5396,
13322,
13727,
4661,
6941,
21074,
20096,
18684,
7023,
21126,
19870,
19880,
5194,
5184,
6958,
21089,
20113,
18700,
3169,
11187,
6955,
21086,
20110,
18696,
-1,
-1,
19871,
19881,
5195,
5185,
6949,
21084,
20104,
18694,
19516,
15966,
6956,
21087,
20111,
18697,
6957,
21088,
20112,
18699,
6999,
21112,
20137,
18720,
11186,
11189,
11188,
11185,
20083,
20082,
19698,
19697,
21011,
20138,
-1,
-1,
14909,
14910,
14908,
14911,
13570,
13605,
13558,
13579,
18689,
18688,
21079,
21078,
6945,
20100,
6946,
20101,
13547,
13546,
13538,
13537,
13543,
13540,
13544,
13541,
20204,
20203,
20195,
20194,
20200,
20197,
20201,
20198,
21104,
21129,
-1,
-1,
-1,
13184,
3229,
3232,
13522,
13586,
14977,
19519,
13620,
13512,
13509,
13505,
13517,
-1,
14946,
13682,
6273,
20308,
20540,
20307,
5015,
21178,
]

_charnames_11264 = [
17863,
17852,
17854,
17861,
17834,
17816,
17837,
17833,
17838,
17823,
17827,
17820,
17835,
17859,
17846,
17858,
17857,
17844,
17840,
17856,
17810,
17829,
17855,
17849,
17860,
17843,
17841,
17804,
17830,
17862,
17806,
17814,
17815,
17819,
17809,
17817,
17807,
17808,
17818,
17825,
17853,
17826,
17850,
17822,
17805,
17831,
17847,
-1,
17800,
17789,
17791,
17798,
17771,
17753,
17774,
17770,
17775,
17760,
17764,
17757,
17772,
17796,
17783,
17795,
17794,
17781,
17777,
17793,
17747,
17766,
17792,
17786,
17797,
17780,
17778,
17741,
17767,
17799,
17743,
17751,
17752,
17756,
17746,
17754,
17744,
17745,
17755,
17762,
17790,
17763,
17787,
17759,
17742,
17768,
17784,
-1,
6795,
6498,
6793,
6813,
6741,
6482,
6330,
6827,
6609,
6809,
6600,
6846,
6624,
6720,
6823,
6675,
6676,
6530,
6856,
6649,
6533,
6829,
6611,
6335,
6380,
6319,
6471,
6865,
6667,
9451,
6761,
6845,
1991,
1910,
1994,
1913,
2001,
1920,
1965,
1884,
2003,
1922,
1974,
1893,
1993,
1912,
2000,
1919,
1982,
1901,
1999,
1918,
1980,
1899,
1988,
1907,
1998,
1917,
1997,
1916,
1978,
1897,
1936,
1855,
1986,
1905,
1996,
1915,
1975,
1894,
1983,
1902,
1995,
1914,
2002,
1921,
1979,
1898,
1985,
1904,
1958,
1877,
1964,
1883,
1951,
1870,
1971,
1890,
1962,
1881,
1961,
1880,
1969,
1888,
1947,
1866,
1976,
1895,
1972,
1891,
1946,
1865,
1949,
1868,
1992,
1911,
1963,
1882,
1942,
1861,
1940,
1859,
1989,
1908,
1943,
1862,
1941,
1860,
1948,
1867,
1950,
1869,
1945,
1864,
1957,
1876,
1955,
1874,
1954,
1873,
1956,
1875,
1930,
1933,
1932,
1926,
1931,
1929,
1927,
1968,
1887,
1970,
1889,
2009,
2008,
2007,
2004,
1923,
-1,
-1,
-1,
-1,
-1,
2058,
2059,
2057,
2056,
2062,
2061,
2063,
17905,
17921,
17903,
17920,
17919,
17910,
17885,
17888,
17918,
17897,
17917,
17916,
17915,
17914,
17894,
17884,
17912,
17891,
17887,
17911,
17893,
17896,
17902,
17913,
17890,
17879,
17882,
17899,
17881,
17880,
17908,
17900,
17873,
17876,
17875,
17909,
17872,
17874,
-1,
17907,
-1,
-1,
-1,
-1,
-1,
17906,
-1,
-1,
14629,
14653,
14654,
14646,
14648,
14685,
14663,
14630,
14633,
14631,
14632,
14668,
14664,
14643,
14674,
14645,
14651,
14686,
14682,
14652,
14666,
14644,
14675,
14658,
14680,
14671,
14636,
14689,
14679,
14662,
14661,
14660,
14677,
14681,
14659,
14669,
14649,
14650,
14647,
14678,
14688,
14640,
14641,
14642,
14637,
14639,
14665,
14638,
14657,
14656,
14655,
14634,
14683,
14635,
14667,
14670,
]

_charnames_11647 = [
14692,
8616,
8605,
8615,
8526,
8527,
8541,
8551,
8475,
8612,
8611,
8493,
8562,
8511,
8503,
8617,
8552,
8476,
8599,
8598,
8489,
8491,
8488,
8487,
]

_charnames_11680 = [
8516,
8518,
8520,
8517,
8515,
8514,
8519,
-1,
8470,
8472,
8474,
8471,
8469,
8468,
8473,
-1,
8557,
8559,
8561,
8558,
8556,
8555,
8560,
-1,
8463,
8465,
8467,
8464,
8462,
8461,
8466,
-1,
8577,
8579,
8581,
8578,
8576,
8575,
8580,
-1,
8587,
8589,
8591,
8588,
8586,
8585,
8590,
-1,
8567,
8569,
8571,
8568,
8566,
8565,
8570,
-1,
8481,
8483,
8485,
8482,
8480,
8479,
8484,
-1,
1627,
1628,
1633,
1624,
1611,
1612,
1632,
1592,
1591,
1590,
1618,
1629,
1589,
1587,
1617,
1620,
1616,
1635,
1608,
1607,
1634,
1588,
1636,
1599,
1623,
1630,
1604,
1601,
1598,
1631,
1626,
1597,
20170,
20171,
7028,
20165,
7045,
20178,
20332,
20330,
18743,
7038,
20174,
20331,
7026,
20180,
8776,
16294,
21017,
20063,
19576,
18746,
18712,
21101,
18745,
18733,
20748,
16342,
19577,
14720,
7042,
20181,
14719,
14718,
7047,
20179,
14952,
14950,
13681,
13679,
7030,
20166,
7044,
20177,
15014,
17375,
4986,
21001,
20061,
15968,
20207,
20636,
14980,
20329,
20334,
14966,
19066,
19065,
14971,
14945,
15021,
14912,
5317,
15969,
20622,
2713,
18735,
20064,
18734,
]

_charnames_12728 = [
13699,
13697,
13696,
-1,
-1,
-1,
-1,
-1,
3111,
3114,
3113,
3118,
3101,
3085,
3092,
3093,
3090,
3100,
3091,
3088,
3094,
3089,
3086,
3116,
3083,
3097,
3107,
3105,
3117,
3084,
3096,
3098,
3102,
3104,
3106,
3110,
3108,
3112,
3099,
3103,
3095,
3087,
3109,
3115,
]

_charnames_12868 = [
3204,
3199,
3203,
3198,
3213,
3211,
3212,
3218,
3219,
3215,
3216,
3220,
16293,
]

_charnames_19904 = [
19311,
19322,
19336,
19398,
19391,
19379,
19317,
19400,
19352,
19328,
19370,
19354,
19397,
19345,
19394,
19401,
19396,
19390,
19386,
19378,
19383,
19348,
19355,
19364,
19358,
19347,
19393,
19346,
19318,
19312,
19360,
19337,
19365,
19344,
19369,
19338,
19327,
19374,
19375,
19332,
19333,
19361,
19382,
19380,
19349,
19368,
19373,
19320,
19366,
19313,
19316,
19324,
19331,
19323,
19388,
19321,
19326,
19325,
19335,
19399,
19359,
19353,
19387,
19384,
]

_charnames_42192 = [
6263,
6230,
6229,
6249,
6218,
6217,
6244,
6238,
6237,
6260,
6252,
6251,
6248,
6216,
6215,
6258,
6235,
6259,
6227,
6223,
6224,
6234,
6241,
6256,
6240,
6262,
6257,
6226,
6255,
6243,
6253,
6254,
6245,
6246,
6261,
6231,
6219,
6221,
6220,
6232,
6208,
6213,
6211,
6212,
6209,
6210,
6266,
6265,
15328,
15329,
15251,
15188,
15189,
15295,
15234,
15241,
15093,
15132,
15085,
15154,
15311,
15279,
15209,
15202,
15117,
15110,
15261,
15287,
15124,
15053,
15225,
15218,
15178,
15171,
15319,
15303,
15069,
15271,
15142,
15034,
15160,
15100,
15076,
15061,
15333,
15334,
15254,
15255,
15193,
15194,
15297,
15236,
15243,
15095,
15138,
15087,
15156,
15313,
15281,
15211,
15204,
15119,
15112,
15265,
15289,
15126,
15055,
15227,
15220,
15180,
15173,
15321,
15305,
15071,
15273,
15146,
15038,
15164,
15102,
15078,
15063,
15335,
15336,
15042,
15256,
15257,
15195,
15196,
15298,
15237,
15244,
15096,
15135,
15136,
15088,
15157,
15314,
15282,
15212,
15205,
15120,
15113,
15266,
15290,
15127,
15056,
15228,
15221,
15181,
15174,
15322,
15306,
15072,
15274,
15143,
15144,
15039,
15165,
15103,
15079,
15064,
15324,
15325,
15247,
15184,
15185,
15293,
15232,
15239,
15091,
15134,
15083,
15150,
15309,
15277,
15207,
15200,
15115,
15108,
15263,
15285,
15122,
15051,
15223,
15216,
15176,
15169,
15317,
15301,
15067,
15269,
15140,
15036,
15162,
15098,
15074,
15059,
15331,
15332,
15252,
15253,
15191,
15192,
15296,
15235,
15242,
15094,
15137,
15086,
15155,
15312,
15280,
15210,
15203,
15118,
15111,
15264,
15288,
15125,
15054,
15226,
15219,
15179,
15172,
15320,
15304,
15070,
15272,
15145,
15037,
15163,
15101,
15077,
15062,
15323,
15326,
15040,
15246,
15248,
15183,
15186,
15292,
15231,
15238,
15090,
15133,
15082,
15149,
15151,
15308,
15276,
15206,
15199,
15114,
15107,
15262,
15284,
15121,
15044,
15222,
15215,
15175,
15168,
15316,
15300,
15066,
15268,
15139,
15035,
15161,
15097,
15073,
15058,
15327,
15330,
15041,
15249,
15250,
15187,
15190,
15294,
15233,
15240,
15092,
15130,
15131,
15084,
15152,
15153,
15310,
15278,
15208,
15201,
15116,
15109,
15259,
15286,
15123,
15052,
15224,
15217,
15177,
15170,
15318,
15302,
15068,
15270,
15141,
15032,
15033,
15158,
15159,
15099,
15075,
15060,
15030,
15260,
15372,
15371,
15370,
15049,
15048,
15046,
15351,
15349,
15340,
15353,
15355,
15352,
15341,
15346,
15344,
15348,
15339,
15345,
15354,
15366,
15367,
15358,
15359,
15364,
15365,
15361,
15362,
15369,
15368,
15047,
15050,
]

_charnames_42560 = [
2873,
2788,
2810,
2725,
2838,
2753,
2853,
2768,
2815,
2730,
2875,
2793,
2868,
2783,
2883,
2800,
2856,
2771,
2850,
2765,
2836,
2751,
2852,
2767,
2865,
2780,
2869,
2784,
2851,
2766,
2855,
2770,
2837,
2752,
2829,
2744,
2828,
2743,
2827,
2742,
2876,
2794,
2870,
2785,
2813,
2728,
2888,
1646,
1642,
1648,
1641,
5398,
1614,
1594,
1602,
1613,
1621,
1603,
1609,
1619,
1647,
1645,
2890,
2889,
2814,
2729,
2809,
2724,
2872,
2787,
2866,
2781,
2808,
2723,
2822,
2737,
2821,
2736,
2819,
2734,
2820,
2735,
2823,
2738,
2862,
2777,
2831,
2746,
2812,
2727,
2864,
2779,
9477,
9476,
1593,
1596,
13003,
12941,
12999,
12938,
13002,
12967,
12978,
13000,
12924,
13001,
12986,
12909,
12969,
12970,
12985,
12945,
12979,
12927,
12914,
12942,
12959,
12949,
12957,
12960,
12958,
12961,
12937,
12935,
12920,
12919,
12912,
12994,
12955,
12993,
12995,
12925,
12934,
12906,
12913,
12923,
12903,
12997,
12907,
12990,
12971,
12982,
12951,
12926,
12965,
12972,
12936,
12916,
12917,
12918,
12956,
12904,
12988,
12989,
12998,
12928,
12984,
12908,
12983,
12930,
12947,
12966,
12944,
12952,
12980,
12940,
12950,
12948,
12975,
12939,
12976,
12922,
12962,
12991,
12931,
12932,
13008,
13007,
13013,
13014,
13010,
13009,
13011,
13012,
]

_charnames_42752 = [
9469,
9474,
9466,
9471,
9468,
9473,
9467,
9472,
9509,
9535,
9524,
9488,
9503,
9510,
9536,
9525,
9489,
9504,
9511,
9537,
9526,
9485,
9505,
9539,
9540,
9541,
9498,
9528,
9531,
9530,
9529,
9496,
9432,
9431,
6705,
6386,
6706,
6387,
6828,
6610,
6685,
6332,
6686,
6333,
6797,
6563,
6798,
6564,
6890,
6884,
6721,
6493,
6719,
6490,
6718,
6489,
6715,
6486,
6716,
6487,
6717,
6488,
6747,
6451,
6805,
6596,
6808,
6599,
6806,
6597,
6834,
6525,
6794,
6504,
6775,
6473,
6774,
6472,
6776,
6474,
6814,
6590,
6816,
6594,
6815,
6591,
6851,
6627,
6852,
6629,
6744,
6448,
6748,
6454,
6757,
6532,
6754,
6538,
6755,
6539,
6683,
6325,
6684,
6326,
6756,
6540,
6707,
6389,
6735,
6416,
6802,
6565,
9545,
6551,
6509,
6586,
6575,
6453,
6870,
6323,
6433,
6729,
6399,
6728,
6398,
6727,
6681,
6315,
6679,
6320,
6726,
6396,
6725,
6395,
6724,
6394,
9497,
9479,
9434,
6766,
6360,
6682,
6500,
6894,
6855,
6574,
6801,
6562,
6561,
6608,
6833,
6524,
6857,
6643,
6753,
6537,
6752,
6536,
6751,
6535,
6843,
6634,
6810,
6602,
6854,
6572,
6743,
6443,
6762,
6357,
6826,
6746,
6765,
6790,
-1,
-1,
6680,
6678,
6839,
6803,
6835,
6527,
6777,
6475,
]

_charnames_42999 = [
6904,
9445,
9374,
6864,
6900,
6899,
6902,
6903,
6905,
5253,
5250,
5267,
5244,
5252,
5246,
5266,
5230,
5231,
5236,
5237,
5268,
5239,
5240,
5233,
5234,
5213,
5214,
5219,
5220,
5215,
5216,
5221,
5222,
5247,
5227,
5228,
5242,
5243,
5248,
5225,
5249,
5224,
5245,
5251,
5259,
5257,
5255,
5258,
5256,
5264,
5263,
5262,
5261,
-1,
-1,
-1,
-1,
19854,
19855,
19859,
19853,
19856,
19858,
19861,
19864,
19863,
19862,
-1,
-1,
-1,
-1,
-1,
-1,
16405,
16404,
16408,
16377,
16388,
16390,
16420,
16375,
16373,
16372,
16386,
16378,
16402,
16401,
16424,
16418,
16371,
16370,
16384,
16413,
16395,
16396,
16380,
16411,
16415,
16419,
16381,
16382,
16422,
16391,
16421,
16414,
16409,
16417,
16416,
16412,
16423,
16407,
16410,
16429,
16428,
16368,
16367,
16385,
16376,
16393,
16398,
16399,
16392,
16430,
16431,
16389,
16432,
16436,
16434,
16435,
]

_charnames_43136 = [
4784,
4782,
4704,
4707,
4728,
4729,
4712,
4713,
4682,
4683,
4684,
4685,
4733,
4734,
4706,
4717,
4718,
4705,
4724,
4723,
4732,
4731,
4696,
4737,
4736,
4727,
4726,
4694,
4690,
4689,
4701,
4700,
4695,
4692,
4691,
4703,
4702,
4697,
4716,
4715,
4740,
4739,
4743,
4741,
4742,
4721,
4686,
4710,
4709,
4711,
4744,
4720,
4785,
4754,
4759,
4760,
4755,
4756,
4747,
4748,
4749,
4750,
4761,
4762,
4753,
4757,
4758,
4752,
4783,
]

_charnames_43214 = [
4779,
4778,
4774,
4775,
4766,
4767,
4772,
4773,
4769,
4770,
4777,
4776,
-1,
-1,
-1,
-1,
-1,
-1,
1722,
1723,
1714,
1715,
1720,
1721,
1717,
1718,
1725,
1724,
1733,
1728,
1732,
1731,
1730,
1729,
1727,
1734,
18957,
18954,
18962,
18952,
18953,
18955,
18959,
18975,
18976,
18974,
18958,
18973,
-1,
-1,
18501,
18502,
18493,
18494,
18499,
18500,
18496,
18497,
18504,
18503,
18474,
18473,
18486,
18458,
18465,
18464,
18478,
18457,
18462,
18476,
18459,
18468,
18467,
18483,
18487,
18489,
18482,
18479,
18484,
18480,
18461,
18477,
18481,
18488,
18490,
18471,
18485,
18470,
18507,
18508,
18506,
18509,
18510,
18514,
18512,
18513,
18517,
18516,
20000,
20003,
19987,
19995,
20004,
19989,
19998,
20006,
19992,
20005,
20001,
19984,
19996,
19997,
19999,
19993,
19994,
20002,
19991,
19986,
19988,
19983,
20007,
20018,
20016,
20010,
20015,
20017,
20014,
20011,
20012,
20022,
20021,
20023,
20024,
20019,
]

_charnames_43359 = [
20025,
19233,
19232,
19230,
19234,
19222,
19219,
19225,
19217,
19227,
19226,
19218,
19224,
19220,
19228,
19223,
19253,
19251,
19252,
19242,
19243,
19244,
19238,
19255,
19256,
19239,
19237,
19245,
19258,
19236,
-1,
-1,
-1,
20915,
20912,
20916,
20914,
20853,
20842,
20840,
20841,
20857,
20835,
20812,
20813,
20862,
20854,
20858,
20836,
20838,
20839,
20847,
20848,
20811,
20849,
20850,
20845,
20815,
20846,
20814,
20819,
20820,
20824,
20825,
20817,
20821,
20822,
20826,
20827,
20816,
20832,
20834,
20851,
20852,
20859,
20855,
20843,
20844,
20860,
20856,
20830,
20831,
20828,
20861,
20913,
20902,
20904,
20905,
20906,
20907,
20908,
20903,
20910,
20909,
20919,
20918,
20920,
20884,
20863,
20922,
20874,
20880,
20869,
20878,
20877,
20870,
20868,
20872,
20873,
20876,
20921,
-1,
20883,
20895,
20896,
20887,
20888,
20893,
20894,
20890,
20891,
20898,
20897,
-1,
-1,
-1,
-1,
20879,
20881,
10010,
10013,
10021,
10004,
10016,
10112,
10204,
10065,
10077,
10072,
10071,
10069,
10068,
10061,
10060,
10066,
10184,
10185,
10176,
10177,
10182,
10183,
10179,
10180,
10187,
10186,
10076,
10063,
10062,
10075,
10074,
-1,
2175,
2183,
2179,
2185,
2176,
2181,
2165,
2164,
2171,
2170,
2138,
2139,
2174,
2173,
2168,
2167,
2134,
2136,
2135,
2156,
2155,
2149,
2147,
2140,
2141,
2148,
2145,
2143,
2144,
2153,
2151,
2161,
2162,
2152,
2177,
2180,
2182,
2178,
2158,
2159,
2184,
2190,
2195,
2196,
2197,
2191,
2194,
2193,
2189,
2188,
2192,
2217,
2219,
2220,
2218,
]

_charnames_43584 = [
2129,
2130,
2122,
2214,
2131,
2124,
2121,
2127,
2123,
2126,
2128,
2125,
2215,
2216,
-1,
-1,
2208,
2209,
2200,
2201,
2206,
2207,
2203,
2204,
2211,
2210,
-1,
-1,
2226,
2224,
2223,
2225,
10055,
10050,
10049,
10044,
10043,
10040,
10038,
10037,
10034,
10033,
10035,
10041,
10053,
10047,
10046,
10056,
10205,
10052,
10051,
10054,
10097,
10096,
10098,
10146,
10145,
10144,
10094,
10126,
10121,
10120,
10028,
10027,
14291,
14322,
14289,
14320,
14290,
14321,
14309,
14340,
14286,
14317,
14299,
14330,
14300,
14331,
14303,
14334,
14284,
14315,
14311,
14342,
14293,
14324,
14294,
14325,
14285,
14316,
14312,
14343,
14296,
14327,
14297,
14328,
14310,
14341,
14306,
14337,
14301,
14332,
14304,
14335,
14307,
14338,
14302,
14333,
14308,
14339,
14305,
14336,
14373,
14350,
14355,
14352,
14351,
14358,
14357,
14372,
14356,
14353,
14354,
14347,
14346,
14348,
14349,
14370,
14369,
14367,
14368,
]

_charnames_43739 = [
14361,
14364,
14363,
14365,
14362,
9248,
9246,
9238,
9197,
9202,
9201,
9209,
9208,
9198,
9214,
9213,
9264,
9260,
9256,
9257,
9255,
9292,
9289,
9288,
9294,
9293,
9266,
9271,
]

_charnames_43777 = [
8546,
8548,
8549,
8545,
8544,
8547,
-1,
-1,
8499,
8501,
8502,
8498,
8497,
8500,
-1,
-1,
8507,
8509,
8510,
8506,
8505,
8508,
]

_charnames_43808 = [
8456,
8458,
8460,
8457,
8455,
8454,
8459,
-1,
8532,
8534,
8536,
8533,
8531,
8530,
8535,
-1,
6519,
6485,
6515,
6518,
6381,
6510,
6348,
6503,
6497,
6502,
6582,
6570,
6390,
6513,
6514,
6459,
6401,
6306,
6307,
6308,
6309,
6362,
6871,
6447,
6548,
6446,
6549,
6346,
6347,
6520,
6427,
6430,
6434,
6318,
6429,
6555,
6557,
6558,
6618,
6614,
6617,
6616,
6640,
9548,
9428,
9373,
9372,
9382,
6361,
6414,
6463,
6432,
6402,
17589,
]

_charnames_43888 = [
2428,
2427,
2426,
2424,
2423,
2422,
2421,
2425,
2420,
2419,
2418,
2417,
2416,
2371,
2370,
2369,
2367,
2366,
2365,
2414,
2413,
2412,
2411,
2410,
2409,
2407,
2406,
2405,
2404,
2403,
2357,
2368,
2358,
2363,
2362,
2361,
2360,
2359,
2400,
2399,
2398,
2397,
2396,
2395,
2355,
2349,
2354,
2353,
2352,
2351,
2350,
2379,
2348,
2378,
2347,
2377,
2346,
2375,
2374,
2373,
2376,
2345,
2344,
2343,
2342,
2341,
2340,
2338,
2337,
2336,
2335,
2334,
2333,
2393,
2392,
2391,
2390,
2389,
2388,
2386,
9221,
9215,
9226,
9224,
9217,
9195,
9237,
9203,
9223,
9193,
9205,
9243,
9242,
9247,
9244,
9231,
9219,
9249,
9234,
9230,
9245,
9241,
9229,
9210,
9235,
9211,
9240,
9222,
9227,
9225,
9218,
9196,
9204,
9194,
9232,
9268,
9263,
9258,
9265,
9267,
9261,
9270,
9269,
9291,
9250,
9287,
-1,
-1,
9282,
9283,
9274,
9275,
9280,
9281,
9277,
9278,
9285,
9284,
]

_charnames_55216 = [
19198,
19199,
19186,
19187,
19188,
19211,
19212,
19191,
19190,
19204,
19202,
19201,
19203,
19179,
19178,
19176,
19175,
19182,
19181,
19180,
19183,
19208,
19207,
-1,
-1,
-1,
-1,
19167,
19168,
19098,
19099,
19149,
19143,
19144,
19146,
19147,
19148,
19139,
19141,
19103,
19140,
19137,
19138,
19134,
19135,
19157,
19161,
19159,
19106,
19160,
19162,
19122,
19124,
19125,
19104,
19123,
19120,
19121,
19114,
19115,
19102,
19101,
19113,
19110,
19111,
19112,
19116,
19130,
19131,
19164,
19165,
19171,
19170,
19107,
19128,
19127,
]

_charnames_64107 = [
3078,
3077,
3076,
-1,
-1,
3063,
3062,
3061,
3060,
3059,
3058,
3057,
3056,
3055,
3054,
3053,
3052,
3051,
3050,
3049,
3048,
3046,
3045,
3044,
3043,
3042,
3041,
3040,
3039,
3038,
3037,
3036,
3035,
3034,
3033,
3032,
3031,
3029,
3028,
3027,
3026,
3025,
3024,
3023,
3022,
3021,
3020,
3019,
3018,
3017,
3016,
3015,
3014,
3012,
3011,
3010,
3009,
3008,
3007,
3006,
3005,
3004,
3003,
3002,
3001,
3000,
2999,
2998,
2997,
2995,
2994,
2993,
2992,
2991,
2990,
2989,
2988,
2987,
2986,
2985,
2984,
2983,
2982,
2981,
2980,
2978,
2977,
2976,
2975,
2974,
2973,
2972,
2971,
2970,
2969,
2968,
2967,
2966,
2965,
2964,
2963,
3074,
3073,
3072,
3071,
3070,
3069,
3068,
3067,
3066,
3065,
]

_charnames_64434 = [
11541,
11540,
11531,
11530,
11537,
11536,
11535,
11534,
11548,
11547,
11542,
11529,
11528,
11549,
11545,
11544,
]

_charnames_65040 = [
16698,
16696,
16695,
16699,
16700,
16703,
16701,
16692,
16688,
16702,
]

_charnames_65060 = [
1808,
1806,
1649,
1707,
1706,
1829,
1828,
1809,
1807,
1650,
1640,
1639,
]

_charnames_65536 = [
6022,
6050,
6012,
6037,
6065,
6029,
6042,
6023,
6061,
6008,
6003,
6041,
-1,
6052,
6035,
5992,
6043,
6033,
5999,
6069,
6070,
6062,
5996,
6060,
6017,
6024,
6016,
6056,
6007,
6004,
6027,
5997,
6049,
6064,
6009,
6059,
5991,
6018,
6054,
-1,
6038,
6013,
6006,
6028,
6014,
6055,
6021,
6046,
6063,
6002,
6001,
6026,
6051,
6025,
6031,
6005,
5994,
6047,
6045,
-1,
6058,
5995,
-1,
6019,
6015,
6044,
6068,
5998,
6073,
6040,
6011,
6036,
5993,
6053,
6032,
6034,
6067,
6072,
-1,
-1,
6088,
6087,
6092,
6091,
6085,
6084,
6090,
6082,
6081,
6089,
6079,
6078,
6077,
6076,
]

_charnames_65664 = [
5866,
5865,
5864,
5851,
5850,
5849,
5863,
5862,
5860,
5859,
5857,
5856,
5854,
5853,
5916,
5915,
5914,
5913,
5912,
6100,
6099,
5920,
5919,
5918,
6097,
6096,
5910,
5909,
5908,
5907,
5906,
5896,
5895,
5894,
5893,
5892,
6101,
5891,
5890,
5889,
5877,
5876,
5875,
5874,
5873,
5872,
5871,
5870,
5869,
5868,
5887,
5886,
5885,
5884,
5883,
5882,
5881,
5880,
5879,
5904,
5903,
5902,
5901,
5900,
5899,
5898,
5923,
5922,
5953,
5952,
5950,
5949,
5948,
5947,
5946,
5945,
5943,
5942,
5941,
5940,
5939,
5938,
6102,
5937,
5936,
5934,
5933,
5932,
5931,
5930,
5929,
5928,
5927,
5926,
5987,
5977,
5976,
5975,
5974,
5973,
5972,
5971,
5970,
5969,
5968,
5966,
5965,
5964,
5963,
5962,
5961,
5960,
5959,
5958,
5957,
5984,
5983,
5982,
5981,
5980,
5979,
5985,
5986,
-1,
-1,
-1,
-1,
-1,
11893,
11894,
11900,
-1,
-1,
-1,
-1,
11880,
11825,
11832,
11855,
11862,
11841,
11847,
11874,
11868,
11838,
11829,
11836,
11859,
11866,
11842,
11848,
11875,
11869,
11883,
11828,
11835,
11858,
11865,
11846,
11852,
11879,
11873,
11882,
11827,
11834,
11857,
11864,
11845,
11851,
11878,
11872,
11839,
11830,
11837,
11860,
11867,
11843,
11849,
11876,
11870,
-1,
-1,
-1,
11891,
11888,
11890,
11889,
11887,
11899,
11898,
11897,
11896,
17424,
17420,
17425,
17397,
17408,
17403,
17400,
17411,
17402,
17429,
17413,
17418,
17405,
17422,
17401,
17407,
17430,
17414,
17419,
17406,
17423,
17428,
17412,
17431,
17462,
17440,
17460,
17464,
17438,
17468,
17465,
17451,
17455,
17456,
17459,
17472,
17439,
17437,
17453,
17454,
17461,
17448,
17443,
17436,
17466,
17452,
17447,
17469,
17471,
17442,
17446,
17473,
17470,
17604,
17605,
17595,
17598,
17616,
17601,
17621,
17608,
17596,
17599,
17613,
17614,
17611,
17619,
17592,
17607,
17617,
17475,
17476,
17620,
17600,
17615,
17606,
17566,
-1,
-1,
-1,
20285,
20299,
20287,
20284,
20297,
20288,
20298,
20300,
20286,
20296,
20302,
20301,
-1,
-1,
-1,
-1,
17565,
]

_charnames_66000 = [
16468,
16466,
16473,
16446,
16448,
16479,
16477,
16492,
16472,
16500,
16459,
16452,
16447,
16486,
16485,
16456,
16489,
16460,
16445,
16495,
16440,
16455,
16442,
16462,
16451,
16475,
16476,
16463,
16444,
16483,
16499,
16494,
16471,
16461,
16467,
16496,
16469,
16482,
16488,
16497,
16498,
16491,
16453,
16454,
16480,
16441,
]

_charnames_66176 = [
7179,
7175,
7177,
7178,
7193,
7194,
7191,
7183,
7181,
7168,
7190,
7173,
7187,
7189,
7171,
7169,
7172,
7170,
7184,
7188,
7174,
7186,
7185,
7166,
7167,
7180,
7176,
7192,
7182,
-1,
-1,
-1,
2613,
2599,
2608,
2593,
2571,
2596,
2594,
2614,
2616,
2618,
2581,
2617,
2609,
2590,
2578,
2579,
2575,
2612,
2569,
2587,
2615,
2586,
2592,
2598,
2580,
2602,
2606,
2572,
2600,
2601,
2589,
2570,
2604,
2605,
2576,
2577,
2588,
2603,
2611,
2591,
2574,
2597,
2582,
2585,
2584,
2583,
2595,
2607,
2573,
]

_charnames_66272 = [
2054,
2051,
2043,
2044,
2049,
2050,
2046,
2047,
2053,
2052,
2019,
2015,
2018,
2030,
2033,
2022,
2025,
2038,
2035,
2040,
2014,
2017,
2029,
2032,
2023,
2026,
2039,
2036,
]

_charnames_66384 = [
17036,
17035,
17033,
17011,
17023,
17013,
17010,
17014,
17009,
17004,
17031,
17030,
17029,
17028,
17016,
17027,
17026,
17003,
17020,
17025,
17034,
17001,
17002,
16998,
16993,
17021,
17022,
17024,
17032,
17019,
17017,
16992,
16994,
16996,
17005,
16997,
16995,
17006,
1801,
1800,
1797,
1799,
1798,
-1,
-1,
-1,
-1,
-1,
21159,
21171,
21154,
21148,
21157,
21150,
21162,
21146,
21151,
21143,
21161,
21149,
21139,
21169,
21168,
21156,
21167,
21145,
21136,
21160,
21166,
21137,
21165,
21164,
21142,
21153,
21141,
21170,
21163,
21138,
-1,
21172,
16930,
16976,
16973,
16964,
16963,
16970,
16969,
16952,
16979,
16967,
16966,
16937,
16935,
16925,
16929,
16928,
16936,
16974,
16947,
16978,
16961,
16960,
16945,
16944,
16943,
16972,
16955,
16954,
16958,
16957,
16975,
16941,
16971,
16940,
16939,
16977,
-1,
-1,
-1,
-1,
16931,
16933,
16932,
16951,
16926,
16927,
16948,
16949,
16988,
16986,
16983,
16985,
16984,
16987,
]

_charnames_66638 = [
18988,
18989,
4640,
4616,
4643,
4646,
4614,
4629,
4628,
4648,
4623,
4634,
4649,
4647,
4645,
4637,
4615,
4636,
4632,
4644,
4626,
4635,
4642,
4631,
4618,
4611,
4594,
4598,
4603,
4625,
4600,
4596,
4639,
4641,
4608,
4597,
4619,
4638,
4605,
4602,
4604,
4593,
4592,
4601,
4595,
4610,
4591,
4609,
4620,
4622,
17281,
17312,
17300,
17306,
17297,
17289,
17295,
17301,
17285,
17284,
17294,
17311,
17309,
17310,
17302,
17290,
17305,
17304,
17303,
17298,
17308,
17296,
17280,
17291,
17307,
17286,
17299,
17282,
17292,
17287,
-1,
-1,
17323,
17324,
17315,
17316,
17321,
17322,
17318,
17319,
17326,
17325,
]

_charnames_66816 = [
8692,
8691,
8678,
8677,
8675,
8645,
8674,
8672,
8671,
8690,
8652,
8651,
8689,
8688,
8687,
8670,
8667,
8666,
8686,
8644,
8646,
8643,
8685,
8684,
8683,
8664,
8663,
8661,
8660,
8658,
8657,
8682,
8681,
8680,
8679,
8655,
8654,
8649,
8650,
8669,
]

_charnames_66864 = [
2692,
2701,
2685,
2652,
2689,
2657,
2688,
2655,
2661,
2631,
2667,
2656,
2664,
2643,
2677,
2665,
2693,
2651,
2640,
2682,
2680,
2676,
2699,
2670,
2691,
2633,
2634,
2636,
2698,
2671,
2697,
2649,
2644,
2683,
2696,
2659,
2700,
2650,
2632,
2674,
2686,
2695,
2646,
2694,
2660,
2645,
2663,
2637,
2639,
2668,
2673,
2679,
]

_charnames_67072 = [
5483,
5482,
5481,
5480,
5479,
5478,
5477,
5476,
5475,
5527,
5526,
5525,
5524,
5523,
5463,
5453,
5455,
5454,
5450,
5452,
5451,
5456,
5457,
5462,
5461,
5460,
5459,
5842,
5458,
5521,
5520,
5519,
5518,
5517,
5516,
5492,
5491,
5490,
5489,
5488,
5487,
5486,
5485,
5473,
5472,
5471,
5470,
5469,
5468,
5467,
5466,
5465,
5514,
5513,
5512,
5511,
5510,
5509,
5500,
5499,
5498,
5497,
5496,
5495,
5494,
5507,
5506,
5505,
5504,
5503,
5502,
5841,
5542,
5532,
5840,
5531,
5530,
5538,
5537,
5839,
5541,
5540,
5535,
5534,
5539,
5661,
5660,
5659,
5658,
5657,
5656,
5655,
5654,
5653,
5652,
5651,
5648,
5647,
5646,
5639,
5638,
5637,
5645,
5644,
5643,
5642,
5641,
5640,
5716,
5715,
5714,
5713,
5712,
5711,
5710,
5709,
5708,
5707,
5705,
5704,
5703,
5702,
5701,
5700,
5699,
5698,
5697,
5696,
5694,
5693,
5692,
5691,
5690,
5689,
5688,
5687,
5686,
5685,
5683,
5682,
5681,
5680,
5679,
5678,
5677,
5676,
5675,
5674,
5672,
5671,
5670,
5669,
5668,
5667,
5666,
5665,
5664,
5663,
5719,
5718,
5818,
5817,
5816,
5815,
5814,
5813,
5812,
5811,
5810,
5809,
5828,
5827,
5826,
5825,
5824,
5823,
5822,
5821,
5820,
5604,
5603,
5602,
5601,
5600,
5599,
5598,
5597,
5633,
5632,
5631,
5630,
5629,
5628,
5595,
5594,
5593,
5592,
5591,
5590,
5589,
5588,
5587,
5585,
5584,
5583,
5582,
5581,
5580,
5579,
5578,
5577,
5612,
5611,
5610,
5609,
5608,
5607,
5606,
5575,
5574,
5573,
5572,
5571,
5570,
5569,
5568,
5567,
5626,
5625,
5624,
5623,
5622,
5621,
5565,
5564,
5563,
5562,
5561,
5560,
5559,
5558,
5557,
5556,
5554,
5553,
5552,
5551,
5550,
5549,
5548,
5547,
5546,
5545,
5619,
5618,
5617,
5616,
5615,
5614,
5769,
5768,
5767,
5766,
5765,
5764,
5763,
5762,
5731,
5730,
5729,
5728,
5727,
5726,
5725,
5724,
5723,
5722,
5751,
5750,
5749,
5748,
5747,
5746,
5745,
5744,
5743,
5779,
5778,
5777,
5760,
5759,
5758,
5757,
5756,
5755,
5754,
5753,
5741,
5740,
5739,
5738,
5737,
5736,
5735,
5734,
5733,
5775,
5774,
5773,
5772,
5771,
]

_charnames_67392 = [
5796,
5795,
5794,
5793,
5792,
5791,
5790,
5789,
5788,
5787,
5786,
5785,
5784,
5804,
5803,
5802,
5801,
5800,
5799,
5798,
5806,
5805,
]

_charnames_67424 = [
5837,
5836,
5835,
5834,
5833,
5832,
5831,
5830,
]

_charnames_67584 = [
2958,
2957,
2956,
2955,
2954,
2953,
-1,
-1,
2952,
-1,
2939,
2938,
2937,
2936,
2935,
2933,
2932,
2931,
2930,
2929,
2927,
2926,
2925,
2924,
2923,
2921,
2920,
2919,
2918,
2917,
2915,
2914,
2913,
2912,
2911,
2909,
2908,
2907,
2906,
2905,
2903,
2902,
2901,
2900,
2899,
2897,
2896,
2895,
2894,
2893,
2944,
2943,
2942,
2941,
-1,
2950,
2949,
-1,
-1,
-1,
2947,
-1,
-1,
2946,
20773,
20786,
20784,
20785,
20769,
20776,
20774,
20770,
20767,
20775,
20783,
20782,
20781,
20780,
20763,
20772,
20779,
20764,
20778,
20777,
20765,
20768,
-1,
20799,
20795,
20790,
20794,
20792,
20791,
20798,
20797,
20793,
16312,
16326,
16323,
16325,
16308,
16315,
16313,
16309,
16306,
16314,
16322,
16321,
16320,
16324,
16319,
16302,
16311,
16318,
16303,
16317,
16316,
16304,
16307,
16327,
16339,
16338,
16331,
16333,
16336,
16337,
16334,
16332,
19923,
19936,
19922,
19949,
19947,
19948,
19921,
19932,
19939,
19937,
19933,
19930,
19915,
19938,
19920,
19946,
19919,
19945,
19918,
19944,
19917,
19943,
19926,
19935,
19942,
19927,
19941,
19940,
19916,
19928,
19931,
]

_charnames_67751 = [
19957,
19953,
19955,
19960,
19962,
19961,
19956,
19954,
19958,
]

_charnames_67808 = [
19275,
19287,
19285,
19286,
19271,
19278,
19276,
19272,
19269,
19277,
19284,
19283,
19282,
19281,
19265,
19274,
19280,
19266,
19279,
-1,
19267,
19270,
-1,
-1,
-1,
-1,
-1,
19292,
19294,
19291,
19290,
19293,
16513,
16527,
16525,
16526,
16510,
16517,
16515,
16511,
16508,
16516,
16524,
16523,
16522,
16521,
16505,
16514,
16520,
16506,
16519,
16518,
16504,
16509,
16535,
16534,
16532,
16536,
16531,
16533,
-1,
-1,
-1,
16537,
7207,
7222,
7218,
7220,
7205,
7210,
7217,
7209,
7216,
7203,
7215,
7201,
7214,
7212,
7200,
7197,
7211,
7219,
7213,
7199,
7198,
7208,
7206,
7204,
7202,
7221,
-1,
-1,
-1,
-1,
-1,
7223,
]

_charnames_67968 = [
9186,
9184,
9182,
9179,
9175,
9176,
9173,
9174,
9178,
9180,
9162,
9163,
9160,
9161,
9168,
9169,
9181,
9171,
9183,
9165,
9166,
9167,
9172,
9177,
9156,
9157,
9154,
9155,
9158,
9185,
9187,
9188,
9115,
9127,
9125,
9122,
9117,
9118,
9129,
9121,
9123,
9111,
9110,
9119,
9124,
9113,
9126,
9108,
9116,
9107,
9114,
9120,
9105,
9104,
9103,
9128,
-1,
-1,
-1,
-1,
9148,
9143,
9131,
9132,
9095,
9034,
9042,
9068,
9076,
9052,
9059,
9089,
9083,
9049,
9039,
9047,
9073,
9081,
9057,
9064,
-1,
-1,
9097,
9036,
9044,
9070,
9078,
9054,
9061,
9091,
9085,
9099,
9038,
9046,
9072,
9080,
9056,
9063,
9093,
9087,
9050,
9040,
9048,
9074,
9082,
9058,
9065,
9094,
9088,
9098,
9037,
9045,
9071,
9079,
9055,
9062,
9092,
9086,
9142,
9135,
9136,
9145,
9146,
9139,
9140,
9149,
9150,
9137,
18238,
18259,
18257,
18256,
-1,
18260,
18258,
-1,
-1,
-1,
-1,
-1,
18261,
18265,
18270,
18267,
18217,
18216,
18223,
18222,
-1,
18226,
18225,
18236,
-1,
18211,
18197,
18196,
18203,
18202,
18212,
18199,
18198,
18205,
18204,
18213,
18220,
18219,
18229,
18228,
18234,
18231,
18233,
18235,
18232,
18208,
18207,
18209,
18230,
18237,
18215,
18195,
-1,
-1,
-1,
-1,
18269,
18268,
18266,
-1,
-1,
-1,
-1,
18262,
18282,
18280,
18281,
18283,
18274,
18273,
18277,
18276,
]

_charnames_68176 = [
18243,
18251,
18250,
18249,
18252,
18246,
18244,
18242,
18247,
]

_charnames_68192 = [
17140,
17155,
17141,
17154,
17152,
17150,
17131,
17151,
17157,
17125,
17128,
17139,
17153,
17138,
17130,
17129,
17156,
17147,
17146,
17135,
17143,
17136,
17144,
17124,
17148,
17134,
17149,
17123,
17122,
17160,
17161,
17162,
17182,
17200,
17183,
17199,
17197,
17194,
17173,
17196,
17202,
17169,
17174,
17180,
17198,
17179,
17195,
17172,
17201,
17191,
17192,
17189,
17186,
17188,
17185,
17170,
17176,
17168,
17193,
17167,
17177,
17207,
17206,
17205,
]

_charnames_68288 = [
9712,
9739,
9738,
9732,
9733,
9736,
9729,
9741,
9767,
9716,
9715,
9728,
9727,
9730,
9708,
9740,
9725,
9719,
9724,
9746,
9735,
9707,
9745,
9744,
9702,
9711,
9713,
9743,
9747,
9703,
9721,
9718,
9722,
9742,
9705,
9704,
9709,
9766,
9765,
-1,
-1,
-1,
-1,
9761,
9763,
9760,
9759,
9762,
9754,
9756,
9752,
9751,
9750,
9753,
9755,
]

_charnames_68352 = [
11983,
11984,
11989,
11985,
11990,
11986,
11987,
11988,
12032,
12033,
12025,
12026,
12027,
12028,
12023,
12024,
12045,
12008,
12006,
12007,
12016,
12015,
12014,
12048,
12046,
12012,
12011,
12036,
12035,
12010,
12042,
12047,
12039,
12038,
11995,
11993,
11994,
11998,
11996,
11997,
12043,
12030,
12021,
12022,
12040,
12041,
12044,
12004,
12019,
12002,
12018,
12001,
12003,
12031,
-1,
-1,
-1,
12049,
14724,
5375,
6915,
6911,
6914,
6910,
20667,
20680,
20678,
20679,
20663,
20670,
20668,
20664,
20661,
20669,
20677,
20676,
20675,
20674,
20657,
20666,
20673,
20658,
20672,
20671,
20659,
20662,
-1,
-1,
20688,
20684,
20686,
20692,
20687,
20685,
20691,
20690,
20716,
20715,
20713,
20714,
20703,
20707,
20705,
20704,
20701,
20706,
20712,
20711,
20710,
20709,
20697,
20708,
20698,
20699,
20702,
-1,
-1,
-1,
-1,
-1,
20724,
20720,
20722,
20728,
20723,
20721,
20727,
20726,
16668,
16667,
16665,
16666,
16654,
16658,
16656,
16655,
16657,
16664,
16663,
16662,
16661,
16651,
16660,
16652,
16653,
16659,
]

_charnames_68521 = [
16676,
16672,
16674,
16678,
16675,
16673,
16677,
]

_charnames_68608 = [
17039,
17085,
17086,
17080,
17116,
17104,
17074,
17075,
17113,
17061,
17103,
17050,
17093,
17059,
17101,
17048,
17092,
17060,
17102,
17049,
17068,
17109,
17053,
17094,
17041,
17089,
17047,
17091,
17076,
17114,
17058,
17100,
17046,
17072,
17071,
17057,
17045,
17087,
17065,
17107,
17067,
17108,
17064,
17106,
17099,
17066,
17088,
17070,
17079,
17082,
17073,
17111,
17056,
17098,
17081,
17117,
17078,
17115,
17055,
17097,
17044,
17051,
17043,
17052,
17096,
17069,
17110,
17054,
17095,
17042,
17090,
17077,
17083,
]

_charnames_68736 = [
16889,
16893,
16888,
16891,
16864,
16863,
16865,
16887,
16890,
16858,
16910,
16886,
16885,
16877,
16878,
16884,
16907,
16908,
16883,
16882,
16892,
16897,
16875,
16876,
16873,
16859,
16862,
16898,
16899,
16906,
16903,
16900,
16881,
16874,
16880,
16909,
16871,
16872,
16869,
16860,
16870,
16866,
16894,
16895,
16905,
16902,
16879,
16867,
16868,
16861,
16896,
]

_charnames_68800 = [
16835,
16839,
16834,
16837,
16810,
16809,
16811,
16833,
16836,
16804,
16856,
16832,
16831,
16823,
16824,
16830,
16853,
16854,
16829,
16828,
16838,
16843,
16821,
16822,
16819,
16805,
16808,
16844,
16845,
16852,
16849,
16846,
16827,
16820,
16826,
16855,
16817,
16818,
16815,
16806,
16816,
16812,
16840,
16841,
16851,
16848,
16825,
16813,
16814,
16807,
16842,
]

_charnames_69216 = [
20253,
20245,
20246,
20251,
20252,
20248,
20249,
20255,
20254,
20221,
20217,
20220,
20232,
20235,
20224,
20227,
20240,
20237,
20242,
20216,
20219,
20231,
20234,
20225,
20228,
20241,
20238,
20260,
20259,
20258,
20261,
]

_charnames_69632 = [
13480,
13481,
13477,
13479,
13478,
13372,
13375,
13394,
13395,
13380,
13381,
13345,
13346,
13347,
13348,
13409,
13374,
13356,
13373,
13390,
13389,
13398,
13397,
13364,
13401,
13400,
13393,
13392,
13362,
13353,
13352,
13369,
13368,
13363,
13355,
13354,
13371,
13370,
13365,
13384,
13383,
13404,
13403,
13407,
13405,
13406,
13387,
13349,
13378,
13377,
13379,
13408,
13386,
13360,
13358,
13359,
13450,
13457,
13453,
13454,
13451,
13452,
13443,
13444,
13445,
13446,
13456,
13449,
13455,
13448,
13458,
13475,
13474,
13488,
13487,
13485,
13489,
13484,
-1,
-1,
-1,
-1,
13431,
13413,
13416,
13426,
13429,
13420,
13422,
13437,
13435,
13418,
13414,
13417,
13427,
13430,
13421,
13423,
13438,
13436,
13434,
13433,
13470,
13471,
13462,
13463,
13468,
13469,
13465,
13466,
13473,
13472,
]

_charnames_69759 = [
13439,
18443,
18444,
18440,
18386,
18389,
18408,
18409,
18394,
18395,
18425,
18388,
18421,
18387,
18404,
18403,
18412,
18411,
18384,
18415,
18414,
18407,
18406,
18382,
18378,
18377,
18372,
18371,
18370,
18397,
18383,
18380,
18379,
18374,
18373,
18385,
18401,
18400,
18418,
18417,
18422,
18419,
18398,
18423,
18420,
18392,
18391,
18393,
18424,
18430,
18433,
18434,
18431,
18432,
18436,
18429,
18435,
18428,
18441,
18442,
18453,
18452,
18451,
18445,
18448,
18450,
18449,
]

_charnames_69840 = [
5150,
5149,
5162,
5161,
5160,
5159,
5141,
5138,
5154,
5139,
5147,
5152,
5146,
5151,
5158,
5155,
5156,
5137,
5163,
5145,
5157,
5148,
5153,
5144,
5142,
]

_charnames_69872 = [
5174,
5175,
5166,
5167,
5172,
5173,
5169,
5170,
5177,
5176,
-1,
-1,
-1,
-1,
-1,
-1,
2310,
2311,
2309,
2276,
2273,
2268,
2275,
2254,
2253,
2260,
2259,
2238,
2263,
2262,
2257,
2256,
2236,
2232,
2231,
2243,
2242,
2237,
2234,
2233,
2245,
2244,
2239,
2251,
2250,
2266,
2265,
2271,
2247,
2248,
2270,
2272,
2267,
2269,
2274,
2296,
2303,
2304,
2299,
2300,
2305,
2298,
2301,
2297,
2302,
2314,
2316,
2306,
2315,
-1,
2288,
2289,
2280,
2281,
2286,
2287,
2283,
2284,
2291,
2290,
2312,
2293,
2292,
2313,
]

_charnames_69968 = [
9931,
9928,
9923,
9930,
9925,
9909,
9908,
9915,
9914,
9918,
9917,
9912,
9911,
9898,
9888,
9887,
9894,
9893,
9899,
9890,
9889,
9896,
9895,
9900,
9906,
9905,
9921,
9920,
9926,
9903,
9927,
9922,
9924,
9929,
9902,
9934,
9936,
9935,
9932,
]

_charnames_70016 = [
4555,
4550,
4546,
4486,
4489,
4508,
4509,
4494,
4495,
4464,
4465,
4466,
4467,
4524,
4488,
4521,
4487,
4504,
4503,
4512,
4511,
4478,
4515,
4514,
4507,
4506,
4476,
4472,
4471,
4483,
4482,
4477,
4474,
4473,
4485,
4484,
4479,
4498,
4497,
4518,
4517,
4522,
4519,
4520,
4501,
4500,
4468,
4492,
4491,
4493,
4523,
4535,
4538,
4539,
4536,
4537,
4528,
4529,
4530,
4531,
4541,
4534,
4540,
4533,
4547,
4549,
4554,
4551,
4583,
4579,
4578,
4586,
4560,
4562,
4553,
4542,
4581,
4561,
-1,
-1,
4574,
4575,
4566,
4567,
4572,
4573,
4569,
4570,
4577,
4576,
4582,
4552,
4584,
4585,
4559,
4558,
-1,
4422,
4414,
4415,
4420,
4421,
4417,
4418,
4424,
4423,
4400,
4398,
4399,
4408,
4409,
4402,
4403,
4411,
4410,
4406,
4405,
]

_charnames_70144 = [
18304,
18307,
18338,
18333,
18340,
18306,
18336,
18305,
18324,
18323,
18311,
18310,
18309,
18302,
18330,
18329,
18327,
18326,
-1,
18300,
18296,
18295,
18290,
18288,
18301,
18298,
18297,
18292,
18289,
18291,
18303,
18318,
18317,
18315,
18314,
18313,
18337,
18331,
18335,
18321,
18332,
18334,
18339,
18320,
18345,
18346,
18347,
18348,
18350,
18344,
18349,
18343,
18356,
18353,
18355,
18354,
18362,
18361,
18363,
18357,
18360,
18364,
]

_charnames_70272 = [
10445,
10442,
10438,
10444,
10423,
10422,
10429,
-1,
10428,
-1,
10432,
10431,
10426,
10425,
-1,
10415,
10407,
10406,
10401,
10400,
10399,
10416,
10409,
10408,
10403,
10402,
10417,
10420,
10419,
10435,
-1,
10434,
10440,
10436,
10413,
10441,
10437,
10439,
10443,
10411,
10412,
10446,
-1,
-1,
-1,
-1,
-1,
-1,
18120,
18123,
18150,
18151,
18136,
18137,
18161,
18122,
18157,
18121,
18149,
18148,
18131,
18130,
18129,
18118,
18154,
18153,
18127,
18125,
18126,
18116,
18112,
18111,
18106,
18105,
18142,
18104,
18117,
18114,
18113,
18108,
18107,
18119,
18146,
18145,
18135,
18134,
18133,
18158,
18155,
18143,
18159,
18156,
18139,
18140,
18160,
18190,
18180,
18183,
18184,
18181,
18182,
18186,
18179,
18185,
18178,
18189,
18188,
-1,
-1,
-1,
-1,
-1,
18172,
18173,
18164,
18165,
18170,
18171,
18167,
18168,
18175,
18174,
-1,
-1,
-1,
-1,
-1,
-1,
17716,
17717,
17720,
17713,
-1,
17656,
17659,
17678,
17679,
17664,
17665,
17631,
17633,
-1,
-1,
17694,
17658,
-1,
-1,
17691,
17657,
17674,
17673,
17682,
17681,
17648,
17685,
17684,
17677,
17676,
17646,
17642,
17641,
17653,
17652,
17647,
17644,
17643,
17655,
17654,
17649,
-1,
17668,
17667,
17688,
17687,
17692,
17689,
17690,
-1,
17671,
17670,
-1,
17638,
17662,
17661,
17663,
17693,
-1,
-1,
17722,
17719,
17704,
17707,
17708,
17705,
17706,
17697,
17698,
-1,
-1,
17710,
17703,
-1,
-1,
17709,
17702,
17714,
-1,
-1,
17723,
-1,
-1,
-1,
-1,
-1,
-1,
17724,
-1,
-1,
-1,
-1,
-1,
17721,
17637,
17636,
17632,
17634,
17699,
17700,
-1,
-1,
1765,
1767,
1760,
1761,
1763,
1764,
1766,
-1,
-1,
-1,
1773,
1772,
1771,
1769,
1770,
]

_charnames_70784 = [
14621,
14541,
14544,
14560,
14561,
14549,
14550,
14519,
14520,
14521,
14522,
14577,
14543,
14573,
14542,
14556,
14555,
14564,
14563,
14533,
14567,
14566,
14559,
14558,
14531,
14527,
14526,
14538,
14537,
14532,
14529,
14528,
14540,
14539,
14534,
14553,
14552,
14570,
14569,
14574,
14571,
14572,
14575,
14523,
14547,
14546,
14548,
14576,
14587,
14593,
14594,
14588,
14589,
14580,
14581,
14582,
14583,
14596,
14592,
14586,
14595,
14591,
14585,
14619,
14617,
14613,
14614,
14618,
14616,
14624,
14622,
14623,
]

_charnames_70864 = [
14607,
14608,
14599,
14600,
14605,
14606,
14602,
14603,
14610,
14609,
]

_charnames_71040 = [
4277,
4281,
4308,
4309,
4297,
4298,
4272,
4273,
4274,
4275,
4325,
4280,
4321,
4278,
4304,
4303,
4312,
4311,
4285,
4315,
4314,
4307,
4306,
4283,
4265,
4264,
4290,
4289,
4284,
4269,
4268,
4292,
4291,
4286,
4301,
4300,
4318,
4317,
4322,
4319,
4320,
4323,
4276,
4295,
4294,
4296,
4324,
4365,
4370,
4371,
4368,
4369,
4366,
4367,
-1,
-1,
4373,
4364,
4372,
4363,
4357,
4358,
4353,
4354,
4356,
4355,
4380,
4379,
4349,
4350,
4377,
4376,
4375,
4381,
4332,
4333,
4338,
4337,
4336,
4346,
4347,
4345,
4334,
4344,
4343,
4341,
4340,
4342,
4267,
4261,
4262,
4279,
4361,
4362,
]

_charnames_71168 = [
9575,
9578,
9597,
9598,
9583,
9584,
9553,
9554,
9555,
9556,
9613,
9577,
9610,
9576,
9593,
9592,
9601,
9600,
9567,
9604,
9603,
9596,
9595,
9565,
9561,
9560,
9572,
9571,
9566,
9563,
9562,
9574,
9573,
9568,
9587,
9586,
9607,
9606,
9611,
9608,
9609,
9590,
9557,
9581,
9580,
9582,
9612,
9589,
9623,
9626,
9627,
9624,
9625,
9616,
9617,
9618,
9619,
9629,
9622,
9628,
9621,
9653,
9649,
9650,
9652,
9646,
9645,
9655,
9654,
]

_charnames_71248 = [
9641,
9642,
9633,
9634,
9639,
9640,
9636,
9637,
9644,
9643,
]

_charnames_71296 = [
14435,
14438,
14456,
14457,
14439,
14440,
14473,
14437,
14469,
14436,
14452,
14451,
14460,
14459,
14427,
14463,
14462,
14455,
14454,
14425,
14421,
14420,
14432,
14431,
14426,
14423,
14422,
14434,
14433,
14428,
14449,
14448,
14466,
14465,
14470,
14467,
14446,
14471,
14468,
14442,
14443,
14472,
14445,
14504,
14501,
14492,
14495,
14496,
14493,
14494,
14498,
14491,
14497,
14490,
14502,
14503,
]

_charnames_71360 = [
14484,
14485,
14476,
14477,
14482,
14483,
14479,
14480,
14487,
14486,
]

_charnames_71424 = [
11920,
11919,
11906,
11907,
11914,
11910,
11917,
11916,
11932,
11935,
11923,
11938,
11913,
11934,
11936,
11933,
11905,
11937,
11908,
11929,
11928,
11926,
11911,
11925,
11931,
11922,
-1,
-1,
-1,
11976,
11977,
11975,
11940,
11944,
11947,
11948,
11945,
11946,
11950,
11941,
11949,
11943,
11942,
11971,
-1,
-1,
-1,
-1,
11961,
11962,
11953,
11954,
11959,
11960,
11956,
11957,
11964,
11963,
11980,
11979,
11968,
11969,
11970,
11972,
]

_charnames_71840 = [
20429,
20411,
20430,
20401,
20404,
20403,
20435,
20420,
20415,
20425,
20413,
20436,
20434,
20417,
20402,
20421,
20418,
20426,
20432,
20428,
20437,
20412,
20414,
20438,
20433,
20409,
20408,
20407,
20410,
20423,
20424,
20431,
20389,
20371,
20390,
20361,
20364,
20363,
20395,
20380,
20375,
20385,
20373,
20396,
20394,
20377,
20362,
20381,
20378,
20386,
20392,
20388,
20397,
20372,
20374,
20398,
20393,
20369,
20368,
20367,
20370,
20383,
20384,
20391,
20449,
20450,
20441,
20442,
20447,
20448,
20444,
20445,
20452,
20451,
20457,
20455,
20456,
20462,
20463,
20459,
20460,
20465,
20464,
]

_charnames_72384 = [
16203,
16209,
16221,
16220,
16225,
16215,
16216,
16205,
16222,
16223,
16208,
16217,
16226,
16214,
16200,
16199,
16206,
16202,
16218,
16195,
16213,
16227,
16224,
16210,
16219,
16196,
16197,
16211,
16191,
16194,
16190,
16192,
16186,
16193,
16189,
16187,
16188,
16243,
16241,
16239,
16244,
16245,
16240,
16236,
16234,
16237,
16238,
16246,
16252,
16248,
16249,
16230,
16228,
16250,
16231,
16232,
16253,
]

_charnames_73728 = [
1019,
1081,
1080,
1079,
1078,
1077,
1076,
1075,
1074,
1105,
1020,
1038,
1037,
1033,
1032,
1036,
1030,
1029,
1035,
1025,
1034,
1039,
1040,
1046,
1045,
1044,
1043,
1042,
1102,
1098,
1101,
1100,
1048,
1058,
1057,
1056,
1055,
1052,
1051,
1054,
1053,
1060,
1059,
1094,
1096,
1082,
1088,
1087,
1086,
1085,
1089,
1104,
1091,
1092,
1093,
1072,
1062,
1068,
1069,
1067,
1065,
1066,
1071,
1070,
1264,
1275,
1277,
1265,
1270,
1272,
1271,
1273,
1274,
1289,
1293,
1292,
1291,
1278,
1283,
1281,
1284,
1287,
1288,
1285,
1286,
756,
757,
783,
782,
780,
779,
763,
764,
761,
762,
765,
789,
776,
777,
788,
770,
767,
769,
768,
787,
786,
785,
784,
774,
775,
796,
792,
795,
794,
798,
810,
799,
802,
804,
808,
809,
806,
698,
752,
753,
751,
745,
748,
749,
699,
739,
755,
740,
741,
742,
743,
744,
754,
1106,
1172,
1173,
1145,
1155,
1154,
1152,
1149,
1148,
1150,
1176,
1175,
1174,
1156,
1159,
1160,
1161,
1164,
1163,
1162,
1168,
1166,
1169,
1107,
1115,
1116,
1117,
1118,
1135,
1131,
1132,
1129,
1130,
1133,
1120,
1121,
1122,
1111,
1112,
1114,
1113,
1125,
1124,
251,
375,
252,
273,
272,
271,
276,
274,
267,
269,
334,
332,
335,
336,
298,
294,
296,
293,
327,
328,
325,
326,
261,
257,
262,
263,
264,
265,
313,
310,
311,
316,
315,
351,
350,
307,
306,
303,
304,
302,
338,
348,
347,
322,
323,
354,
286,
285,
282,
283,
281,
287,
353,
342,
343,
344,
355,
365,
368,
371,
372,
362,
364,
363,
374,
356,
357,
359,
360,
361,
369,
370,
373,
436,
439,
376,
405,
404,
406,
398,
400,
401,
408,
385,
386,
378,
384,
383,
382,
381,
380,
397,
388,
396,
394,
392,
395,
409,
434,
410,
413,
414,
416,
415,
418,
419,
423,
422,
425,
433,
431,
432,
426,
430,
429,
428,
1317,
1319,
1321,
1322,
1295,
1297,
1298,
1306,
1305,
1304,
1303,
1302,
1301,
1300,
1307,
1308,
1314,
1313,
1312,
1311,
1310,
1316,
1323,
1349,
1348,
1341,
1344,
1343,
1331,
1332,
1337,
1334,
1335,
1336,
1338,
1340,
1339,
1324,
1326,
1329,
1328,
1327,
1330,
1347,
1346,
1345,
442,
486,
490,
491,
489,
497,
496,
495,
499,
523,
522,
451,
455,
454,
452,
453,
445,
450,
448,
449,
456,
457,
520,
519,
504,
501,
502,
508,
506,
479,
483,
482,
481,
484,
485,
517,
516,
513,
525,
466,
467,
465,
464,
463,
461,
469,
468,
511,
470,
476,
475,
474,
473,
524,
546,
547,
549,
532,
531,
530,
528,
529,
544,
545,
537,
539,
540,
543,
542,
533,
536,
535,
575,
562,
571,
569,
570,
573,
572,
567,
566,
564,
565,
550,
561,
560,
555,
556,
559,
553,
554,
558,
551,
552,
557,
574,
5,
101,
104,
108,
107,
106,
111,
110,
109,
167,
166,
171,
170,
138,
139,
136,
137,
162,
163,
164,
151,
147,
150,
149,
133,
134,
132,
130,
131,
145,
144,
142,
143,
158,
159,
160,
169,
126,
125,
124,
121,
122,
127,
155,
154,
156,
112,
115,
114,
118,
117,
116,
172,
173,
175,
176,
177,
178,
184,
182,
183,
179,
180,
181,
246,
249,
248,
247,
185,
245,
186,
224,
223,
201,
203,
221,
217,
220,
194,
192,
193,
195,
215,
214,
219,
212,
211,
199,
198,
206,
225,
232,
230,
229,
227,
244,
233,
236,
237,
238,
243,
242,
239,
240,
241,
1248,
1252,
1253,
1256,
1255,
1254,
1249,
1250,
1260,
1261,
1257,
1258,
1222,
1247,
1243,
1244,
1246,
1245,
1223,
1233,
1232,
1231,
1225,
1229,
1234,
1235,
1238,
1239,
1241,
1242,
1001,
1012,
1002,
1006,
1004,
1005,
1007,
1010,
1008,
1009,
1013,
1017,
1016,
1018,
924,
967,
966,
961,
964,
963,
926,
947,
945,
946,
941,
952,
950,
949,
933,
937,
935,
936,
931,
929,
965,
968,
996,
969,
991,
990,
987,
988,
989,
994,
995,
992,
993,
970,
982,
981,
980,
979,
978,
977,
976,
975,
974,
973,
983,
984,
1374,
1377,
1376,
1375,
1378,
1351,
1361,
1362,
1360,
1359,
1363,
1356,
1357,
1354,
1355,
1364,
1366,
1371,
1370,
1369,
1372,
1405,
1406,
1408,
1407,
641,
674,
642,
670,
662,
663,
668,
661,
660,
666,
665,
664,
655,
653,
658,
650,
649,
648,
647,
646,
673,
671,
675,
676,
678,
677,
603,
604,
613,
612,
611,
610,
609,
608,
606,
607,
614,
617,
616,
618,
628,
627,
626,
633,
632,
629,
631,
630,
597,
600,
599,
579,
592,
585,
584,
591,
590,
581,
582,
589,
588,
587,
586,
602,
593,
595,
596,
601,
634,
640,
635,
639,
688,
694,
689,
690,
691,
696,
695,
679,
687,
684,
685,
686,
682,
683,
680,
681,
1178,
1193,
1191,
1190,
1192,
1194,
1197,
1196,
1179,
1187,
1186,
1183,
1182,
1185,
1184,
1198,
1200,
1219,
1220,
1210,
1218,
1216,
1211,
1215,
1213,
1214,
1201,
1209,
1208,
1202,
1206,
1207,
811,
913,
912,
910,
909,
908,
922,
921,
885,
894,
891,
890,
888,
889,
895,
892,
893,
896,
873,
879,
876,
878,
877,
884,
880,
883,
882,
918,
919,
812,
871,
870,
850,
862,
861,
863,
865,
864,
854,
857,
856,
872,
867,
868,
813,
840,
841,
847,
838,
816,
819,
818,
817,
820,
846,
833,
832,
831,
845,
827,
844,
843,
836,
835,
842,
824,
823,
822,
848,
849,
897,
902,
899,
900,
901,
903,
905,
904,
920,
915,
916,
917,
1396,
1398,
1399,
1401,
1400,
1403,
1389,
1395,
1394,
1390,
1391,
1393,
1392,
1381,
1382,
1385,
1387,
1386,
548,
1026,
1047,
1097,
773,
791,
807,
747,
1134,
1128,
275,
268,
440,
407,
1315,
492,
488,
446,
458,
526,
507,
514,
462,
510,
472,
140,
228,
204,
200,
1262,
1240,
1011,
925,
960,
959,
942,
999,
1379,
1373,
667,
1217,
875,
911,
]

_charnames_74752 = [
1483,
1467,
1429,
1447,
1502,
1498,
1557,
1544,
1469,
1431,
1449,
1507,
1497,
1556,
1543,
1421,
1442,
1500,
1493,
1552,
1539,
1521,
1479,
1466,
1428,
1446,
1506,
1496,
1555,
1542,
1520,
1478,
1465,
1427,
1445,
1476,
1455,
1456,
1425,
1436,
1505,
1495,
1554,
1541,
1528,
1475,
1453,
1454,
1424,
1435,
1510,
1509,
1526,
1481,
1458,
1459,
1420,
1441,
1463,
1462,
1412,
1416,
1415,
1414,
1504,
1492,
1491,
1490,
1550,
1551,
1535,
1537,
1536,
1538,
1484,
1468,
1430,
1448,
1503,
1527,
1482,
1460,
1418,
1419,
1439,
1440,
1546,
1547,
1523,
1485,
1515,
1473,
1437,
1514,
1472,
1524,
1518,
1531,
1532,
1517,
1529,
1563,
1562,
1560,
1561,
1422,
1443,
1501,
1494,
1553,
1540,
-1,
1570,
1569,
1568,
1566,
1567,
]

_charnames_74880 = [
1027,
1024,
1103,
1276,
1269,
1268,
1267,
1282,
797,
790,
803,
801,
805,
725,
723,
724,
734,
733,
738,
717,
714,
716,
715,
731,
730,
737,
712,
711,
709,
710,
705,
703,
704,
706,
721,
720,
719,
736,
735,
728,
727,
1153,
1151,
1167,
1170,
1144,
1143,
1142,
1139,
1140,
1137,
1138,
1141,
1127,
333,
297,
292,
291,
329,
256,
260,
259,
314,
301,
339,
340,
341,
346,
318,
321,
320,
280,
352,
367,
438,
393,
417,
424,
1320,
1299,
498,
503,
477,
471,
168,
71,
66,
65,
70,
63,
62,
69,
68,
60,
59,
67,
98,
97,
82,
81,
76,
75,
74,
83,
79,
78,
88,
87,
86,
91,
90,
92,
46,
38,
45,
44,
42,
41,
43,
54,
53,
56,
55,
51,
50,
49,
48,
99,
35,
8,
21,
20,
19,
18,
17,
16,
15,
13,
12,
11,
34,
22,
33,
32,
27,
28,
31,
30,
29,
26,
25,
95,
94,
231,
222,
218,
208,
209,
207,
1259,
1228,
1227,
958,
943,
940,
957,
956,
955,
953,
954,
928,
932,
930,
672,
669,
654,
657,
615,
624,
623,
622,
621,
638,
637,
693,
1199,
1205,
1204,
866,
858,
839,
829,
828,
1402,
1388,
1384,
]

_charnames_77824 = [
7299,
7298,
7297,
7296,
7291,
7292,
7288,
7290,
7289,
7295,
7294,
7293,
7286,
7285,
7284,
7283,
7277,
7278,
7282,
7281,
7275,
7276,
7280,
7279,
7344,
7343,
7342,
7341,
7340,
7339,
7338,
7337,
7336,
7335,
7311,
7310,
7301,
7302,
7309,
7308,
7307,
7306,
7305,
7304,
7303,
7266,
7267,
7273,
7264,
7265,
7262,
7263,
7272,
7260,
7261,
7271,
7270,
7269,
7268,
7333,
7332,
7331,
7330,
7329,
7328,
7327,
7326,
7325,
7324,
7322,
7321,
7320,
7319,
7318,
7317,
7316,
7315,
7314,
7313,
7345,
8408,
8407,
8406,
8405,
8399,
8400,
8404,
8403,
8402,
8401,
8317,
8306,
8309,
8308,
8307,
8316,
8315,
8314,
8313,
8312,
8311,
8310,
8319,
8320,
8329,
8328,
8327,
8326,
8325,
8324,
8323,
8322,
8321,
8335,
8334,
8333,
8332,
8331,
7595,
7594,
7593,
7592,
7591,
7590,
7589,
7586,
7587,
7588,
7584,
7583,
7582,
7581,
7580,
7579,
7578,
7577,
7576,
7575,
7573,
7572,
7571,
7570,
7569,
7568,
7567,
7563,
7564,
7566,
7565,
7561,
7552,
7553,
7560,
7559,
7550,
7551,
7558,
7557,
7556,
7555,
7554,
7548,
7547,
7546,
7545,
7544,
7543,
7539,
7540,
7542,
7537,
7538,
7541,
7498,
7507,
7506,
7505,
7504,
7503,
7502,
7501,
7500,
7499,
7518,
7510,
7511,
7517,
7508,
7509,
7516,
7515,
7514,
7513,
7512,
7535,
7534,
7533,
7532,
7531,
7530,
7529,
7520,
7528,
7527,
7526,
7525,
7524,
7523,
7522,
7521,
8175,
8174,
8173,
8172,
8171,
8170,
8169,
8167,
8168,
8165,
8166,
8163,
8162,
8161,
8160,
8159,
8158,
8154,
8155,
8152,
8153,
8157,
8156,
8141,
8142,
8150,
8149,
8148,
8147,
8146,
8145,
8144,
8139,
8140,
8143,
8185,
8184,
8183,
8182,
8177,
8178,
8181,
8180,
8179,
7886,
7887,
7895,
7894,
7893,
7892,
7891,
7890,
7889,
7888,
7884,
7883,
7882,
7874,
7875,
7881,
7880,
7879,
7878,
7877,
7876,
7872,
7862,
7863,
7871,
7870,
7869,
7868,
7867,
7866,
7865,
7864,
7860,
7852,
7853,
7859,
7858,
7857,
7856,
7855,
7850,
7851,
7848,
7849,
7854,
7846,
7845,
7844,
7843,
7842,
7838,
7839,
7836,
7837,
7834,
7835,
7841,
7840,
7903,
7897,
7900,
7899,
7898,
7902,
7901,
7956,
7955,
7954,
7953,
7952,
7948,
7949,
7945,
7947,
7946,
7951,
7950,
7968,
7958,
7959,
7967,
7966,
7965,
7964,
7963,
7962,
7961,
7960,
7934,
7935,
7943,
7942,
7941,
7940,
7939,
7932,
7933,
7938,
7937,
7936,
7930,
7929,
7928,
7927,
7926,
7925,
7921,
7922,
7919,
7920,
7924,
7923,
7917,
7916,
7915,
7908,
7909,
7914,
7906,
7907,
7913,
7912,
7911,
7910,
7974,
7973,
7972,
7971,
7970,
8428,
8427,
8426,
8425,
8424,
8420,
8421,
8423,
8422,
8348,
8347,
8346,
8345,
8340,
8341,
8344,
8343,
8342,
8338,
8339,
8352,
8353,
8350,
8351,
8357,
8356,
8355,
8354,
8437,
8436,
8435,
8434,
8433,
8432,
8431,
8430,
8397,
8390,
8391,
8396,
8395,
8394,
8388,
8389,
8393,
8392,
7813,
7815,
7814,
7824,
7816,
7817,
7823,
7822,
7821,
7820,
7819,
7818,
7777,
7778,
7783,
7762,
7770,
7769,
7768,
7767,
7766,
7765,
7764,
7763,
7782,
7781,
7775,
7776,
7773,
7774,
7771,
7772,
7780,
7779,
7811,
7810,
7803,
7804,
7809,
7801,
7802,
7808,
7807,
7806,
7799,
7800,
7805,
7797,
7788,
7789,
7796,
7785,
7787,
7786,
7795,
7794,
7793,
7792,
7791,
7790,
7826,
7827,
7831,
7830,
7829,
7828,
7436,
7435,
7434,
7433,
7432,
7431,
7430,
7429,
7428,
7414,
7413,
7412,
7411,
7410,
7409,
7408,
7407,
7403,
7405,
7404,
7406,
7426,
7425,
7424,
7423,
7422,
7416,
7417,
7421,
7420,
7419,
7418,
7401,
7400,
7399,
7394,
7395,
7392,
7393,
7390,
7391,
7398,
7388,
7389,
7397,
7396,
7440,
7439,
7438,
7494,
7493,
7492,
7491,
7485,
7486,
7490,
7489,
7488,
7487,
7483,
7482,
7481,
7480,
7479,
7478,
7477,
7473,
7474,
7476,
7475,
7495,
7465,
7464,
7463,
7462,
7461,
7460,
7459,
7458,
7457,
7447,
7448,
7445,
7446,
7455,
7454,
7453,
7452,
7451,
7450,
7443,
7444,
7449,
7470,
7469,
7467,
7468,
7689,
7690,
7696,
7695,
7694,
7687,
7688,
7680,
7686,
7685,
7684,
7683,
7682,
7681,
7693,
7692,
7691,
7730,
7733,
7732,
7731,
7743,
7742,
7741,
7740,
7739,
7738,
7737,
7736,
7734,
7735,
7721,
7722,
7728,
7727,
7726,
7719,
7720,
7717,
7718,
7725,
7724,
7723,
7715,
7716,
7705,
7706,
7713,
7712,
7703,
7704,
7711,
7710,
7698,
7702,
7701,
7700,
7699,
7709,
7708,
7707,
7754,
7753,
7752,
7751,
7750,
7749,
7748,
7747,
7746,
7745,
7756,
7758,
7757,
7759,
8362,
8363,
8370,
8360,
8361,
8369,
8368,
8367,
8366,
8365,
8364,
8373,
8372,
8445,
8444,
8443,
8442,
8441,
8440,
8439,
8256,
8248,
8249,
8245,
8247,
8246,
8255,
8254,
8253,
8252,
8251,
8250,
8234,
8235,
8243,
8242,
8241,
8240,
8239,
8232,
8233,
8238,
8237,
8236,
8267,
8266,
8265,
8264,
8263,
8262,
8261,
8260,
8259,
8258,
8026,
8018,
8019,
8025,
8024,
8023,
8016,
8017,
8022,
8021,
8020,
7989,
7988,
7987,
7986,
7977,
7979,
7978,
7985,
7984,
7980,
7981,
7983,
7982,
8002,
8001,
8000,
7999,
7998,
7997,
7991,
7993,
7992,
7996,
7995,
7994,
8014,
8013,
8012,
8011,
8010,
8004,
8005,
8009,
8008,
8007,
8006,
8034,
8033,
8032,
8031,
8030,
8029,
8028,
8102,
8101,
8096,
8097,
8100,
8099,
8098,
8094,
8095,
8092,
8093,
8090,
8091,
8115,
8106,
8107,
8114,
8113,
8112,
8111,
8104,
8105,
8110,
8109,
8108,
8126,
8125,
8124,
8123,
8122,
8121,
8120,
8119,
8118,
8117,
8136,
8135,
8130,
8131,
8128,
8129,
8134,
8133,
8132,
8072,
8071,
8070,
8069,
8068,
8062,
8064,
8063,
8067,
8066,
8065,
8083,
8082,
8081,
8080,
8079,
8078,
8077,
8076,
8075,
8074,
8048,
8047,
8046,
8039,
8040,
8045,
8044,
8043,
8042,
8041,
8037,
8038,
8060,
8059,
8050,
8051,
8058,
8057,
8056,
8055,
8054,
8053,
8052,
8087,
8086,
8085,
7624,
7633,
7632,
7631,
7630,
7629,
7628,
7627,
7626,
7625,
7637,
7638,
7644,
7643,
7642,
7641,
7634,
7636,
7635,
7640,
7639,
7660,
7646,
7649,
7648,
7647,
7650,
7652,
7651,
7659,
7658,
7657,
7656,
7655,
7654,
7653,
7598,
7610,
7609,
7608,
7607,
7606,
7605,
7604,
7603,
7602,
7601,
7600,
7599,
7622,
7621,
7615,
7616,
7620,
7619,
7618,
7617,
7613,
7614,
7611,
7612,
7668,
7669,
7666,
7667,
7675,
7664,
7665,
7674,
7673,
7672,
7662,
7663,
7671,
7670,
7676,
7677,
8295,
8294,
8287,
8288,
8293,
8292,
8291,
8290,
8289,
8285,
8286,
8276,
8277,
8283,
8282,
8281,
8274,
8275,
8280,
8279,
8272,
8273,
8270,
8271,
8278,
8303,
8302,
8301,
8300,
8297,
8298,
8299,
8386,
8385,
8384,
8375,
8377,
8376,
8383,
8380,
8381,
8382,
8378,
8379,
8410,
8411,
8418,
8417,
8416,
8415,
8414,
8413,
8412,
8229,
8213,
8217,
8216,
8215,
8214,
8218,
8220,
8219,
8223,
8224,
8221,
8222,
8228,
8227,
8226,
8225,
8211,
8210,
8209,
8208,
8207,
8188,
8197,
8196,
8195,
8194,
8193,
8192,
8191,
8190,
8189,
8198,
8206,
8205,
8204,
8203,
8202,
8201,
8200,
8199,
7358,
7357,
7356,
7355,
7354,
7353,
7348,
7350,
7349,
7352,
7351,
7380,
7379,
7378,
7377,
7376,
7375,
7374,
7373,
7372,
7371,
7369,
7368,
7367,
7366,
7365,
7364,
7363,
7362,
7361,
7360,
7384,
7383,
7382,
]

_charnames_82944 = [
11034,
11033,
11032,
11031,
11030,
11029,
11028,
11027,
11026,
10981,
10982,
10991,
10990,
10989,
10988,
10987,
10986,
10985,
10984,
10983,
10979,
10978,
10977,
10976,
10975,
10974,
10969,
10970,
10973,
10972,
10971,
10967,
10966,
10965,
10964,
10963,
10962,
10961,
10960,
10959,
10957,
10958,
10928,
10920,
10921,
10927,
10926,
10925,
10918,
10919,
10915,
10917,
10916,
10924,
10923,
10922,
11024,
11023,
11022,
11021,
11020,
11019,
11018,
11017,
11016,
11015,
10942,
10941,
10940,
10939,
10938,
10937,
10930,
10933,
10932,
10931,
10936,
10935,
10934,
11013,
11012,
11011,
11010,
11009,
11008,
11007,
11006,
11005,
11004,
11002,
11001,
11000,
10999,
10998,
10997,
10996,
10995,
10994,
10993,
10955,
10954,
10953,
10952,
10951,
10950,
10949,
10946,
10947,
10944,
10945,
10948,
10554,
10555,
10552,
10553,
10550,
10551,
10559,
10543,
10546,
10545,
10544,
10547,
10549,
10548,
10558,
10539,
10542,
10541,
10540,
10557,
10556,
10561,
10563,
10562,
10573,
10572,
10571,
10570,
10564,
10565,
10569,
10568,
10567,
10566,
10597,
10596,
10595,
10594,
10593,
10587,
10588,
10592,
10591,
10590,
10589,
10585,
10584,
10583,
10582,
10581,
10575,
10576,
10580,
10579,
10578,
10577,
10663,
10662,
10661,
10660,
10659,
10658,
10657,
10656,
10655,
10654,
10652,
10651,
10650,
10649,
10648,
10647,
10646,
10645,
10644,
10643,
10641,
10640,
10639,
10638,
10637,
10636,
10635,
10634,
10633,
10632,
10630,
10629,
10628,
10627,
10626,
10625,
10624,
10623,
10622,
10621,
10619,
10618,
10617,
10616,
10615,
10614,
10613,
10612,
10611,
10610,
10608,
10607,
10606,
10605,
10604,
10603,
10602,
10601,
10600,
10599,
10806,
10805,
10793,
10795,
10794,
10804,
10803,
10802,
10801,
10798,
10799,
10800,
10796,
10797,
10832,
10831,
10830,
10829,
10828,
10823,
10824,
10821,
10822,
10827,
10826,
10825,
10868,
10867,
10866,
10865,
10864,
10863,
10862,
10858,
10859,
10861,
10860,
10912,
10911,
10910,
10909,
10908,
10907,
10906,
10905,
10904,
10903,
10901,
10900,
10899,
10898,
10897,
10896,
10895,
10894,
10893,
10892,
10890,
10889,
10888,
10887,
10886,
10885,
10884,
10883,
10882,
10881,
10856,
10855,
10854,
10853,
10852,
10851,
10850,
10846,
10847,
10849,
10848,
10879,
10878,
10877,
10876,
10875,
10874,
10873,
10872,
10871,
10870,
10844,
10843,
10842,
10841,
10840,
10839,
10838,
10837,
10836,
10834,
10835,
10819,
10818,
10817,
10816,
10810,
10811,
10815,
10814,
10813,
10812,
10808,
10809,
10757,
10756,
10755,
10754,
10753,
10752,
10751,
10750,
10749,
10747,
10748,
10790,
10789,
10788,
10787,
10786,
10785,
10784,
10783,
10782,
10781,
10745,
10744,
10743,
10742,
10741,
10740,
10739,
10738,
10737,
10735,
10736,
10681,
10680,
10673,
10672,
10671,
10679,
10678,
10677,
10666,
10669,
10668,
10667,
10676,
10675,
10674,
10779,
10778,
10777,
10776,
10775,
10774,
10773,
10772,
10771,
10770,
10733,
10732,
10731,
10730,
10729,
10728,
10727,
10726,
10725,
10723,
10724,
10709,
10708,
10707,
10706,
10700,
10701,
10705,
10704,
10703,
10698,
10699,
10702,
10721,
10711,
10712,
10720,
10719,
10718,
10717,
10716,
10715,
10714,
10713,
10696,
10688,
10689,
10695,
10687,
10686,
10694,
10693,
10683,
10684,
10692,
10691,
10690,
10768,
10767,
10766,
10765,
10764,
10763,
10762,
10761,
10760,
10759,
11138,
11137,
11136,
11135,
11134,
11133,
11132,
11131,
11130,
11129,
11052,
11051,
11061,
11060,
11059,
11058,
11057,
11056,
11055,
11054,
11053,
11127,
11126,
11125,
11124,
11123,
11122,
11121,
11120,
11119,
11118,
11116,
11115,
11114,
11113,
11112,
11111,
11110,
11109,
11108,
11107,
11105,
11104,
11103,
11102,
11101,
11100,
11099,
11098,
11097,
11096,
11039,
11040,
11048,
11047,
11046,
11045,
11044,
11043,
11037,
11038,
11042,
11041,
11094,
11093,
11092,
11091,
11090,
11089,
11088,
11087,
11086,
11085,
11083,
11082,
11081,
11080,
11079,
11078,
11077,
11076,
11075,
11074,
11072,
11071,
11070,
11069,
11068,
11067,
11066,
11065,
11064,
11063,
11147,
11146,
11145,
11144,
11143,
11142,
11141,
11140,
11180,
11179,
11178,
11177,
11176,
11175,
11174,
11173,
11172,
11170,
11169,
11168,
11167,
11166,
11165,
11164,
11163,
11162,
11161,
11159,
11158,
11157,
11156,
11155,
11154,
11153,
11152,
11151,
11150,
11181,
]

_charnames_92160 = [
12633,
12741,
12710,
12711,
12654,
12685,
12730,
12642,
12688,
12707,
12708,
12664,
12726,
12635,
12662,
12669,
12678,
12696,
12629,
12716,
12647,
12694,
12632,
12736,
12735,
12628,
12667,
12702,
12739,
12703,
12674,
12641,
12744,
12740,
12627,
12695,
12679,
12680,
12672,
12720,
12704,
12651,
12713,
12663,
12656,
12712,
12725,
12733,
12693,
12728,
12666,
12717,
12650,
12721,
12673,
12684,
12734,
12747,
12746,
12722,
12692,
12668,
12687,
12625,
12689,
12638,
12700,
12648,
12743,
12634,
12665,
12655,
12677,
12639,
12729,
12691,
12701,
12644,
12661,
12637,
12719,
12645,
12745,
12732,
12657,
12653,
12676,
12781,
12816,
12790,
12791,
12811,
12753,
12800,
12819,
12752,
12801,
12805,
12820,
12809,
12783,
12784,
12822,
12804,
12815,
12788,
12787,
12762,
12755,
12778,
12796,
12823,
12795,
12810,
12806,
12828,
12776,
12773,
12827,
12792,
12817,
12766,
12771,
12772,
12763,
12789,
12756,
12767,
12779,
12803,
12765,
12825,
12754,
12826,
12797,
12760,
12759,
12812,
12774,
12782,
12757,
12799,
12775,
12486,
12523,
12577,
12615,
12484,
12501,
12487,
12610,
12535,
12612,
12527,
12519,
12533,
12605,
12505,
12542,
12561,
12611,
12564,
12578,
12522,
12545,
12496,
12537,
12579,
12572,
12573,
12594,
12506,
12588,
12514,
12584,
12596,
12483,
12617,
12526,
12553,
12520,
12480,
12599,
12538,
12556,
12517,
12586,
12481,
12620,
12500,
12497,
12495,
12621,
12618,
12534,
12619,
12513,
12600,
12583,
12492,
12510,
12568,
12479,
12549,
12546,
12601,
12570,
12512,
12488,
12614,
12482,
12494,
12518,
12571,
12493,
12504,
12552,
12580,
12503,
12591,
12595,
12536,
12550,
12543,
12562,
12532,
12563,
12541,
12576,
12509,
12555,
12554,
12592,
12566,
12567,
12489,
12525,
12602,
12606,
12607,
12587,
12381,
12468,
12328,
12364,
12329,
12442,
12331,
12341,
12322,
12347,
12467,
12316,
12394,
12318,
12413,
12424,
12393,
12334,
12400,
12414,
12459,
12417,
12404,
12366,
12350,
12383,
12375,
12406,
12458,
12332,
12411,
12313,
12428,
12471,
12315,
12473,
12351,
12370,
12437,
12352,
12387,
12372,
12445,
12371,
12363,
12440,
12338,
12379,
12420,
12346,
12426,
12405,
12457,
12412,
12465,
12427,
12314,
12367,
12337,
12410,
12450,
12448,
12344,
12438,
12321,
12368,
12324,
12456,
12451,
12455,
12353,
12356,
12401,
12418,
12326,
12317,
12429,
12376,
12416,
12342,
12425,
12384,
12323,
12436,
12325,
12340,
12333,
12470,
12415,
12462,
12432,
12430,
12345,
12464,
12439,
12377,
12361,
12399,
12386,
12397,
12392,
12419,
12359,
12395,
12357,
12449,
12360,
12396,
12446,
12385,
12441,
12463,
12431,
12358,
12380,
12403,
12474,
12118,
12202,
12182,
12247,
12304,
12242,
12154,
12236,
12291,
12131,
12122,
12150,
12194,
12095,
12261,
12297,
12234,
12104,
12155,
12201,
12254,
12244,
12133,
12110,
12173,
12093,
12109,
12132,
12293,
12127,
12167,
12237,
12099,
12180,
12280,
12094,
12128,
12175,
12241,
12105,
12120,
12195,
12233,
12151,
12116,
12101,
12224,
12281,
12199,
12215,
12168,
12198,
12259,
12235,
12206,
12302,
12299,
12248,
12147,
12192,
12285,
12111,
12231,
12179,
12183,
12136,
12145,
12288,
12197,
12255,
12225,
12138,
12223,
12187,
12121,
12162,
12212,
12250,
12270,
12287,
12090,
12260,
12172,
12096,
12283,
12272,
12141,
12166,
12218,
12103,
12139,
12135,
12169,
12177,
12271,
12144,
12185,
12282,
12268,
12184,
12149,
12091,
12253,
12161,
12142,
12216,
12100,
12158,
12269,
12274,
12125,
12307,
12203,
12305,
12306,
12246,
12157,
12191,
12193,
12117,
12230,
12217,
12106,
12213,
12220,
12221,
12210,
12211,
12258,
12165,
12126,
12152,
12298,
12275,
12303,
12249,
12176,
12294,
12292,
12107,
12112,
12228,
12229,
12267,
12143,
12159,
12243,
12262,
12188,
12171,
12174,
12205,
12263,
12186,
12207,
12273,
12284,
12861,
12899,
12858,
12901,
12866,
12880,
12839,
12891,
12868,
12869,
12876,
12881,
12843,
12835,
12871,
12849,
12848,
12850,
12851,
12857,
12855,
12832,
12831,
12834,
12893,
12846,
12894,
12841,
12885,
12840,
12896,
12886,
12870,
12842,
12864,
12856,
12837,
12838,
12847,
12887,
12900,
12897,
12890,
12889,
12860,
12873,
12865,
12877,
12875,
12874,
12882,
12859,
12852,
12898,
]

_charnames_92736 = [
10479,
10495,
10508,
10497,
10512,
10506,
10513,
10491,
10485,
10502,
10507,
10511,
10486,
10482,
10498,
10494,
10492,
10481,
10480,
10488,
10510,
10477,
10505,
10509,
10504,
10484,
10500,
10499,
10503,
10489,
10478,
-1,
10525,
10526,
10517,
10518,
10523,
10524,
10520,
10521,
10528,
10527,
-1,
-1,
-1,
-1,
10530,
10529,
]

_charnames_92880 = [
13266,
13279,
13289,
13295,
13291,
13269,
13282,
13285,
13278,
13292,
13294,
13271,
13286,
13281,
13284,
13296,
13274,
13288,
13297,
13287,
13270,
13290,
13272,
13298,
13275,
13276,
13273,
13267,
13265,
13293,
-1,
-1,
13305,
13302,
13306,
13301,
13304,
13307,
]

_charnames_92928 = [
16138,
16137,
16134,
16133,
16108,
16107,
16122,
16121,
16140,
16139,
16111,
16110,
16126,
16125,
16105,
16104,
16120,
16119,
16128,
16127,
16132,
16131,
16116,
16115,
16143,
16142,
16114,
16113,
16016,
16001,
16021,
16010,
16003,
16017,
16004,
16018,
16014,
16009,
16020,
16012,
16005,
16008,
16019,
16002,
16006,
16022,
16015,
16013,
16172,
16176,
16179,
16178,
16175,
16180,
16173,
16075,
16077,
16058,
16076,
16081,
16067,
16066,
16065,
16068,
16078,
16089,
16079,
16099,
16071,
16055,
]

_charnames_93008 = [
16154,
16155,
16146,
16147,
16152,
16153,
16149,
16150,
16157,
16156,
-1,
16164,
16167,
16162,
16169,
16168,
16163,
16165,
-1,
16080,
16069,
16096,
16084,
16097,
16095,
16093,
16070,
16092,
16100,
16083,
16088,
16085,
16098,
16090,
16061,
16057,
16053,
16054,
16059,
16060,
-1,
-1,
-1,
-1,
-1,
16027,
16035,
16041,
16042,
16046,
16032,
16044,
16048,
16029,
16028,
16047,
16033,
16045,
16039,
16049,
16036,
16026,
16031,
16038,
]

_charnames_93952 = [
10313,
10324,
10259,
10312,
10316,
10315,
10288,
10323,
10307,
10306,
10226,
10281,
10257,
10258,
10225,
10280,
10237,
10239,
10260,
10286,
10233,
10232,
10295,
10294,
10293,
10292,
10224,
10279,
10223,
10278,
10322,
10304,
10261,
10310,
10309,
10236,
10235,
10285,
10319,
10320,
10303,
10302,
10219,
10274,
10230,
10229,
10220,
10275,
10255,
10262,
10271,
10298,
10297,
10250,
10248,
10221,
10276,
10256,
10299,
10251,
10249,
10246,
10244,
10287,
10245,
10243,
10321,
10289,
10318,
]

_charnames_94032 = [
10238,
10378,
10376,
10377,
10335,
10343,
10342,
10336,
10337,
10357,
10359,
10364,
10363,
10351,
10354,
10355,
10360,
10326,
10327,
10328,
10329,
10331,
10334,
10333,
10330,
10332,
10344,
10345,
10346,
10347,
10348,
10350,
10349,
10361,
10362,
10338,
10339,
10353,
10366,
10352,
10365,
10341,
10356,
10340,
10358,
10367,
10368,
]

_charnames_94095 = [
10371,
10370,
10373,
10372,
10217,
10216,
10215,
10214,
10213,
10212,
10211,
10270,
10269,
10268,
10267,
10266,
10265,
]

_charnames_113664 = [
18871,
18865,
18844,
18839,
18875,
18854,
18849,
18880,
18862,
18867,
18873,
18818,
18848,
18864,
18876,
18857,
18823,
18843,
18786,
18863,
18858,
18785,
18872,
18853,
18822,
18829,
18789,
18800,
18761,
18831,
18796,
18808,
18771,
18833,
18798,
18802,
18803,
18763,
18764,
18834,
18799,
18804,
18773,
18832,
18797,
18809,
18772,
18805,
18806,
18807,
18765,
18766,
18767,
18768,
18841,
18842,
18810,
18814,
18817,
18774,
18775,
18856,
18874,
18769,
18770,
18877,
18782,
18828,
18824,
18878,
18869,
18859,
18870,
18788,
18836,
18861,
18779,
18821,
18780,
18852,
18879,
18835,
18860,
18866,
18838,
18851,
18820,
18837,
18784,
18827,
18825,
18826,
18816,
18811,
18813,
18815,
18812,
18791,
18792,
18793,
18794,
18846,
18847,
18778,
18787,
18783,
18868,
-1,
-1,
-1,
-1,
-1,
18897,
18921,
18922,
18885,
18920,
18900,
18915,
18916,
18912,
18914,
18918,
18917,
18913,
-1,
-1,
-1,
18909,
18905,
18906,
18902,
18907,
18908,
18903,
18904,
18899,
]

_charnames_113808 = [
18891,
18893,
18894,
18887,
18895,
18896,
18888,
18892,
18884,
18890,
-1,
-1,
18924,
18923,
18926,
18925,
4656,
4658,
4657,
4655,
]

_charnames_119262 = [
10467,
10457,
10463,
10465,
10464,
10466,
10460,
10459,
10456,
10455,
10462,
]

_charnames_119296 = [
17517,
17534,
17545,
17544,
17528,
17543,
17542,
17541,
17540,
17527,
17526,
17525,
17524,
17523,
17522,
17521,
17520,
17519,
17518,
17539,
17538,
17537,
17536,
17535,
17533,
17532,
17531,
17530,
17529,
17486,
17494,
17478,
17501,
17515,
17514,
17493,
17492,
17491,
17490,
17489,
17488,
17487,
17500,
17499,
17498,
17497,
17496,
17495,
17513,
17512,
17511,
17510,
17509,
17508,
17485,
17484,
17483,
17482,
17481,
17480,
17479,
17506,
17505,
17504,
17503,
17502,
1779,
1780,
1781,
17610,
]

_charnames_119552 = [
9662,
19036,
19035,
19030,
19029,
19027,
14746,
14783,
14815,
14826,
14835,
14733,
14810,
14831,
14824,
14756,
14752,
14842,
14838,
14808,
14778,
14735,
14840,
14829,
14786,
14812,
14777,
14774,
14769,
14845,
14734,
14764,
14758,
14745,
14757,
14825,
14806,
14822,
14742,
14834,
14798,
14794,
14807,
14782,
14775,
14820,
14776,
14802,
14765,
14792,
14801,
14763,
14805,
14779,
14787,
14843,
14736,
14816,
14767,
14844,
14751,
14743,
14800,
14799,
14817,
14813,
14768,
14759,
14828,
14795,
14837,
14755,
14760,
14750,
14766,
14796,
14793,
14841,
14739,
14744,
14788,
14811,
14738,
14832,
14753,
14821,
14785,
]

_charnames_119648 = [
2076,
2068,
2069,
2074,
2075,
2071,
2072,
2078,
2077,
2089,
2081,
2082,
2087,
2088,
2084,
2085,
2091,
2090,
]

_charnames_120832 = [
3278,
3510,
3491,
3630,
3544,
3599,
3369,
3522,
3379,
3368,
3371,
3357,
3361,
3521,
3280,
3512,
3321,
3318,
3319,
3362,
3359,
3283,
3296,
3295,
3293,
3291,
3298,
3515,
3416,
3370,
3301,
3517,
3324,
3322,
3312,
3320,
3364,
3365,
3360,
3323,
3304,
3306,
3308,
3309,
3383,
3286,
3288,
3289,
3408,
3349,
3292,
3299,
3290,
3294,
3401,
3344,
3399,
3400,
3355,
3356,
3346,
3305,
3311,
3310,
3404,
3405,
3406,
3350,
3457,
3462,
3461,
3459,
3460,
3540,
3444,
3579,
3448,
3471,
3455,
3473,
3456,
3474,
3454,
3499,
3500,
3580,
3631,
3450,
3452,
3453,
3445,
3480,
3469,
3477,
3475,
3479,
3478,
3468,
3464,
3465,
3466,
3467,
3531,
3534,
3538,
3535,
3596,
3583,
3485,
3483,
3488,
3497,
3490,
3501,
3489,
3498,
3505,
3503,
3508,
3622,
3625,
3628,
3626,
3559,
3563,
3542,
3581,
3562,
3571,
3564,
3582,
3572,
3573,
3597,
3314,
3518,
3554,
3608,
3565,
3317,
3316,
3555,
3418,
3421,
3422,
3423,
3429,
3378,
3528,
3629,
3614,
3430,
3431,
3425,
3426,
3569,
3428,
3568,
3613,
3612,
3427,
3529,
3567,
3611,
3325,
3519,
3556,
3574,
3609,
3300,
3516,
3442,
3575,
3621,
3437,
3439,
3440,
3530,
3627,
3620,
3433,
3436,
3435,
3441,
3438,
3595,
3367,
3520,
3507,
3593,
3594,
3592,
3495,
3557,
3606,
3605,
3415,
3576,
3409,
3526,
3413,
3410,
3590,
3407,
3414,
3412,
3524,
3506,
3502,
3577,
3617,
3618,
3615,
3525,
3536,
3537,
3588,
3589,
3586,
3558,
3327,
3550,
3330,
3331,
3332,
3335,
3336,
3334,
3352,
3353,
3347,
3343,
3342,
3539,
3341,
3345,
3493,
3494,
3551,
3552,
3546,
3549,
3603,
3604,
3601,
3372,
3393,
3387,
3388,
3389,
3394,
3382,
3385,
3384,
3376,
3391,
3377,
3380,
3392,
3276,
3443,
4001,
4002,
4003,
4250,
4251,
4252,
4186,
4187,
4188,
4236,
4237,
4238,
4071,
4072,
4073,
4195,
4196,
4182,
4178,
4183,
4179,
4180,
4154,
4150,
4155,
4151,
4152,
4184,
3918,
3917,
3919,
3921,
3916,
3915,
3920,
3767,
3887,
3710,
3711,
3708,
3709,
3712,
3747,
3746,
3744,
3745,
3683,
3742,
3741,
3739,
3740,
3728,
3729,
3730,
3675,
3677,
3678,
3676,
3680,
3681,
3682,
3724,
3725,
3726,
3756,
3757,
3758,
3760,
3761,
3762,
3965,
3966,
3967,
3969,
3970,
3971,
3976,
3974,
3975,
3973,
3909,
3910,
3907,
3908,
3904,
3905,
3902,
3903,
3899,
3900,
3897,
3898,
3894,
3895,
3892,
3893,
3844,
3845,
3842,
3843,
3846,
3868,
3867,
3865,
3866,
3788,
3863,
3862,
3861,
3860,
3874,
3785,
3786,
3787,
3789,
3871,
3872,
3873,
3876,
3877,
3878,
3880,
3881,
3882,
3984,
3985,
3986,
3980,
3981,
3982,
3987,
3664,
3665,
3662,
3663,
3656,
3657,
3654,
3655,
3668,
3669,
3735,
3736,
3737,
3715,
3720,
3721,
3716,
3692,
3693,
3694,
3688,
3689,
3690,
3670,
3672,
3673,
4027,
4031,
4039,
3713,
3659,
3733,
3718,
3700,
4029,
4033,
4037,
3660,
3734,
3719,
3701,
4030,
4034,
4038,
3696,
3697,
3698,
3777,
3778,
3834,
3837,
3833,
3836,
3817,
3820,
3818,
3821,
3797,
3798,
4044,
4048,
4052,
3774,
3775,
3829,
3830,
3827,
3828,
3810,
3813,
3811,
3814,
3794,
3795,
4043,
4047,
4051,
3781,
3782,
3779,
3780,
3783,
3838,
3822,
3800,
3801,
3802,
4041,
4045,
4049,
3847,
3750,
3753,
3751,
3754,
3850,
3853,
3856,
3851,
3854,
3857,
3703,
3704,
3804,
3805,
3765,
3766,
3885,
3886,
4205,
4206,
4210,
4203,
4207,
4208,
4201,
4202,
4211,
4209,
3633,
3645,
3639,
3638,
3642,
3640,
3643,
3644,
4172,
4170,
4171,
4106,
4107,
4108,
4215,
4217,
4216,
4214,
4167,
4168,
4166,
4099,
4098,
4100,
4111,
4112,
4096,
4094,
4097,
4093,
4113,
4102,
4104,
4103,
4078,
4080,
4081,
4086,
4088,
4089,
4083,
4090,
4084,
4229,
4230,
4228,
4022,
4020,
4021,
4115,
4223,
4224,
4221,
4222,
4247,
4244,
4248,
4245,
4240,
4241,
3937,
3938,
3939,
3945,
3947,
3948,
3953,
3955,
3956,
3934,
3933,
3932,
3928,
3931,
3930,
3924,
3927,
3926,
3949,
3952,
3951,
3941,
3944,
3943,
4132,
4131,
4130,
3940,
3958,
3959,
3996,
3998,
3992,
3991,
3999,
3997,
3994,
3995,
4010,
4017,
4013,
4014,
4015,
4016,
4018,
3768,
3888,
4225,
3632,
4114,
4191,
4192,
4253,
4156,
4193,
4006,
4007,
4008,
4254,
4127,
4126,
4125,
4124,
4123,
4122,
4121,
4120,
4164,
4143,
4144,
4136,
4138,
4141,
4137,
4139,
4140,
4232,
4173,
4197,
4233,
4255,
]

_charnames_121499 = [
4163,
4162,
4161,
4160,
4159,
-1,
4069,
4068,
4067,
4066,
4065,
4064,
4063,
4062,
4061,
4060,
4059,
4058,
4057,
4056,
4055,
]

_charnames_124928 = [
8892,
8891,
8890,
8822,
8789,
8810,
8841,
8906,
8889,
8888,
8887,
8964,
8973,
8977,
8844,
8997,
8945,
8826,
8840,
8950,
8886,
8885,
8884,
8829,
8790,
8933,
8895,
8882,
8881,
8880,
8937,
8787,
8989,
8951,
8879,
8878,
8877,
8923,
8992,
8921,
8941,
8952,
8958,
8954,
8996,
8907,
8873,
8871,
8870,
8924,
8975,
8953,
8807,
8995,
8866,
8865,
8864,
8801,
8813,
8834,
8934,
8981,
8876,
8875,
8874,
8796,
8904,
8903,
8869,
8868,
8867,
8793,
8833,
8988,
8818,
8863,
8862,
8860,
8930,
8978,
8926,
8824,
8910,
8859,
8858,
8857,
8983,
8805,
8947,
8969,
8856,
8855,
8854,
8808,
8811,
8956,
8797,
8994,
8991,
8853,
8852,
8851,
8974,
8917,
8909,
8848,
8898,
8849,
8788,
8847,
8948,
8802,
8962,
8835,
8959,
8798,
8836,
8998,
8843,
8794,
8846,
8803,
8976,
8942,
8931,
8970,
8928,
8963,
8799,
8986,
8901,
8932,
8980,
8918,
9001,
8920,
8919,
8900,
8831,
8908,
8819,
8785,
8838,
8804,
8837,
8990,
8821,
8943,
8825,
8968,
8842,
8896,
8814,
8913,
8911,
8897,
8925,
8987,
8946,
8957,
8792,
8812,
8845,
8984,
8979,
8929,
8966,
8832,
8940,
8791,
8985,
8815,
8816,
8914,
8967,
8961,
8965,
9000,
8972,
8820,
8823,
8935,
8999,
8939,
8955,
8902,
8899,
8936,
8912,
8800,
8944,
8809,
8922,
8830,
8915,
8786,
8827,
-1,
-1,
9012,
9004,
9005,
9010,
9011,
9007,
9008,
9014,
9013,
9021,
9019,
9024,
9022,
9020,
9025,
9026,
]

_charnames_126464 = [
11375,
11387,
11383,
11241,
-1,
11378,
11366,
11384,
11360,
11377,
11373,
11279,
11382,
11381,
11312,
11376,
11386,
11313,
11380,
11379,
11311,
11364,
11362,
11372,
11363,
11242,
11367,
11385,
11239,
11237,
11238,
11236,
-1,
11337,
11333,
-1,
11326,
-1,
-1,
11327,
-1,
11328,
11324,
11332,
11331,
11330,
11317,
11338,
11335,
11318,
11329,
-1,
11316,
11321,
11320,
11323,
-1,
11336,
-1,
11334,
-1,
-1,
-1,
-1,
-1,
-1,
11356,
-1,
-1,
-1,
-1,
11357,
-1,
11351,
-1,
11354,
-1,
11353,
11344,
11359,
-1,
11345,
11352,
-1,
11343,
-1,
-1,
11355,
-1,
11350,
-1,
11358,
-1,
11349,
-1,
11348,
-1,
11309,
11306,
-1,
11299,
-1,
-1,
11300,
11285,
11302,
11297,
-1,
11305,
11304,
11288,
11310,
11308,
11289,
11303,
-1,
11287,
11284,
11283,
11296,
-1,
11294,
11301,
11307,
11293,
-1,
11292,
-1,
11265,
11278,
11275,
11262,
11259,
11268,
11256,
11260,
11250,
11267,
-1,
11273,
11272,
11271,
11253,
11266,
11277,
11254,
11270,
11269,
11252,
11249,
11247,
11274,
11248,
11263,
11257,
11276,
-1,
-1,
-1,
-1,
-1,
11233,
11229,
11219,
-1,
11222,
11216,
11230,
11210,
11221,
-1,
11227,
11226,
11225,
11213,
11234,
11232,
11214,
11224,
11223,
11212,
11209,
11207,
11228,
11208,
11220,
11217,
11231,
]

_charnames_126976 = [
9868,
9825,
9872,
9861,
9876,
9879,
9871,
9852,
9830,
9835,
9841,
9846,
9816,
9821,
9866,
9859,
9853,
9831,
9836,
9842,
9847,
9817,
9822,
9867,
9860,
9851,
9829,
9834,
9840,
9845,
9815,
9820,
9865,
9858,
9877,
9854,
9874,
9880,
9824,
9823,
9881,
9870,
9878,
9875,
-1,
-1,
-1,
-1,
18678,
18677,
18676,
18675,
18674,
18673,
18672,
18671,
18669,
18668,
18667,
18666,
18665,
18664,
18663,
18661,
18660,
18659,
18658,
18657,
18656,
18655,
18653,
18652,
18651,
18650,
18649,
18648,
18647,
18645,
18644,
18643,
18642,
18641,
18640,
18639,
18637,
18636,
18635,
18634,
18633,
18632,
18631,
18629,
18628,
18627,
18626,
18625,
18624,
18623,
18619,
18618,
18617,
18616,
18615,
18614,
18613,
18612,
18610,
18609,
18608,
18607,
18606,
18605,
18604,
18602,
18601,
18600,
18599,
18598,
18597,
18596,
18594,
18593,
18592,
18591,
18590,
18589,
18588,
18586,
18585,
18584,
18583,
18582,
18581,
18580,
18578,
18577,
18576,
18575,
18574,
18573,
18572,
18570,
18569,
18568,
18567,
18566,
18565,
18564,
]

_charnames_127136 = [
16641,
16635,
16565,
16570,
16582,
16588,
16594,
16599,
16630,
16620,
16575,
16625,
16605,
16615,
16610,
-1,
-1,
16636,
16566,
16571,
16583,
16589,
16595,
16600,
16631,
16621,
16576,
16626,
16606,
16616,
16611,
16643,
-1,
16637,
16567,
16572,
16584,
16590,
16596,
16601,
16632,
16622,
16577,
16627,
16607,
16617,
16612,
16640,
-1,
16638,
16568,
16573,
16585,
16591,
16597,
16602,
16633,
16623,
16578,
16628,
16608,
16618,
16613,
16642,
16586,
16543,
16554,
16563,
16562,
16561,
16560,
16559,
16558,
16557,
16553,
16552,
16551,
16550,
16549,
16548,
16547,
16546,
16545,
16544,
16556,
16555,
]

_charnames_127232 = [
19012,
19013,
19023,
19015,
19016,
19021,
19022,
19018,
19019,
19025,
19024,
19058,
19057,
-1,
-1,
-1,
16282,
16281,
16280,
16279,
16278,
16277,
16276,
16275,
16274,
16273,
16272,
16271,
16270,
16269,
16268,
16267,
16266,
16265,
16264,
16263,
16262,
16261,
16260,
16259,
16258,
16257,
14941,
3207,
3206,
3225,
3230,
-1,
4966,
4965,
4964,
4963,
4962,
4961,
4960,
4959,
4958,
4957,
4956,
4955,
4954,
4953,
4952,
4951,
4950,
4949,
4948,
4947,
4946,
4945,
4944,
4943,
4942,
4941,
4994,
4992,
4973,
4971,
4990,
4987,
19762,
19761,
19760,
19759,
19758,
19757,
19756,
19755,
19754,
19753,
19752,
19751,
19750,
19749,
19748,
19747,
19746,
19745,
19744,
19743,
19742,
19741,
19740,
19739,
19738,
19737,
20328,
20327,
-1,
-1,
-1,
-1,
19728,
19727,
19726,
19725,
19724,
19723,
19722,
19721,
19720,
19719,
19718,
19717,
19716,
19715,
19714,
19713,
19712,
19711,
19710,
19709,
19708,
19707,
19706,
19705,
19704,
19703,
3242,
19732,
19731,
19730,
19734,
19729,
5006,
4938,
4937,
4985,
4993,
4983,
4982,
4991,
4972,
4989,
4988,
]

_charnames_127462 = [
20052,
20051,
20050,
20049,
20048,
20047,
20046,
20045,
20044,
20043,
20042,
20041,
20040,
20039,
20038,
20037,
20036,
20035,
20034,
20033,
20032,
20031,
20030,
20029,
20028,
20027,
5008,
4978,
4977,
]

_charnames_127504 = [
4904,
4896,
4893,
4979,
4930,
4887,
4935,
4886,
4929,
4916,
4924,
4910,
4883,
4894,
4899,
4909,
4884,
4921,
4920,
4934,
4897,
4889,
4914,
4902,
4912,
4928,
4927,
4936,
4895,
4931,
4892,
4913,
4933,
4903,
4923,
4922,
4890,
4915,
4906,
4907,
4919,
4882,
4898,
-1,
-1,
-1,
-1,
-1,
14929,
14940,
14939,
14936,
14934,
14931,
14933,
14937,
14930,
]

_charnames_127744 = [
2959,
21020,
3175,
19976,
5120,
5119,
3235,
5124,
20336,
13492,
20476,
15993,
10391,
8753,
8752,
8751,
17866,
19694,
20482,
20984,
20481,
21052,
20484,
6932,
20485,
3257,
19693,
20983,
6931,
21051,
5122,
17865,
4667,
14924,
13585,
20490,
20494,
20492,
20493,
3181,
3180,
3182,
3179,
21019,
20618,
19535,
14512,
13673,
2436,
5412,
8772,
19004,
16341,
2715,
19534,
14985,
2431,
20309,
19567,
5125,
13626,
8757,
8756,
19506,
21010,
9992,
20971,
7163,
10473,
14955,
12055,
17725,
9337,
20479,
14506,
7161,
13317,
16778,
20089,
17625,
16746,
16747,
2432,
5311,
19302,
5393,
9338,
16754,
20209,
20210,
2110,
1573,
5315,
5349,
13497,
21048,
20318,
19069,
17387,
5128,
21047,
20997,
5203,
4650,
20803,
18741,
2109,
2446,
2565,
7248,
1578,
19544,
4664,
13726,
16762,
2108,
21015,
14884,
4874,
20620,
2115,
15006,
13740,
3191,
13333,
21016,
13684,
16767,
20191,
20648,
13744,
20931,
2445,
20972,
20978,
20979,
13187,
16292,
2098,
14507,
3243,
16779,
20928,
2624,
20617,
9691,
5406,
17726,
19487,
13712,
10392,
20087,
10471,
5322,
7159,
2101,
13732,
13731,
20993,
12078,
2625,
21063,
20312,
20996,
10382,
9694,
3236,
19494,
11646,
14947,
3233,
14726,
3186,
16738,
15978,
19060,
5399,
13749,
17964,
13706,
21028,
10472,
10447,
4873,
17956,
10470,
15009,
15981,
10469,
20275,
14880,
5438,
13308,
2437,
5422,
20276,
5131,
5352,
15007,
19524,
12058,
20277,
5429,
20640,
17958,
20343,
20344,
3259,
15992,
21002,
20802,
14509,
5423,
2711,
13735,
13674,
19529,
3234,
19006,
3187,
18993,
18994,
19963,
5305,
19528,
19530,
17386,
20925,
8770,
19545,
13311,
12053,
19537,
7243,
2105,
5405,
19007,
20964,
20804,
20929,
8771,
20553,
13610,
20470,
20472,
20310,
13560,
6934,
13339,
13708,
12057,
8733,
8732,
8731,
8730,
8729,
20347,
9680,
17381,
20478,
2111,
14722,
7160,
20345,
2703,
19078,
3250,
20562,
5426,
5425,
19522,
20348,
17959,
4676,
9669,
20315,
2443,
18753,
16773,
13715,
8700,
17388,
5340,
13628,
11182,
19543,
6933,
20995,
15005,
13625,
14984,
19295,
13332,
21041,
13745,
16743,
18557,
16770,
19077,
13328,
18757,
9681,
2112,
14723,
20346,
2704,
19079,
5351,
19525,
9670,
18754,
16776,
21042,
19301,
20637,
13734,
16359,
16775,
16357,
2441,
8759,
8758,
8747,
19909,
9682,
14954,
20557,
20514,
20517,
20550,
20998,
20471,
17384,
14915,
14916,
3185,
17361,
3249,
20628,
8760,
19771,
15023,
20934,
19081,
18553,
13750,
20629,
16787,
19259,
16755,
9808,
12066,
19561,
20627,
20630,
21021,
13669,
13668,
13709,
17960,
9697,
20625,
20973,
9806,
15018,
15016,
16759,
20631,
13493,
16727,
9804,
9803,
17212,
17211,
13329,
2103,
16717,
20926,
20927,
17963,
13334,
8745,
11818,
20758,
5439,
20743,
17954,
19070,
6292,
19966,
20963,
19305,
13336,
5281,
16781,
18552,
7242,
20205,
17937,
18545,
13711,
2092,
20645,
13733,
13498,
15019,
5347,
17734,
19489,
13622,
17623,
21194,
16788,
19488,
20075,
19490,
19047,
8698,
11195,
13714,
5384,
2113,
5353,
19076,
19072,
16782,
21031,
19054,
5336,
14923,
20539,
19570,
9667,
1574,
19457,
3258,
13313,
13316,
13315,
13314,
9666,
2320,
5418,
16734,
13494,
10388,
21029,
17364,
19088,
20989,
17359,
16347,
16349,
2714,
14883,
2620,
2319,
2321,
13337,
3190,
16790,
20305,
16358,
5310,
14990,
13702,
7162,
19901,
19902,
3177,
17362,
17624,
13623,
17346,
13703,
19964,
5402,
9336,
14873,
16351,
20967,
4872,
16791,
2435,
17380,
20757,
16360,
8777,
20755,
8716,
3174,
3173,
17355,
17356,
16764,
16765,
19699,
9683,
9685,
15982,
9686,
19898,
11191,
2709,
2710,
15979,
14876,
20340,
15980,
20992,
16769,
16719,
15022,
3166,
3167,
3170,
11190,
7235,
19565,
5331,
5327,
5330,
5329,
13261,
8697,
7056,
20189,
7240,
3176,
18554,
7236,
17360,
13737,
13739,
13701,
6109,
20341,
13326,
8713,
17377,
5205,
14948,
19897,
18555,
20733,
20731,
20735,
20734,
20732,
20976,
8696,
20647,
19297,
19970,
19547,
16783,
10381,
14877,
3255,
4455,
20924,
14993,
13523,
20499,
6919,
6918,
6912,
6917,
5376,
5377,
21121,
18728,
21119,
18727,
7234,
21131,
3224,
3246,
3245,
19908,
19907,
5287,
20520,
19427,
3263,
17383,
18755,
18543,
9695,
5284,
9028,
13707,
3160,
3127,
3133,
3147,
3150,
3140,
3143,
3157,
3163,
3136,
3154,
3130,
3159,
3126,
3132,
3146,
3149,
3139,
3142,
3156,
3162,
3135,
3153,
3129,
20160,
20163,
20162,
13671,
13672,
20206,
13700,
2566,
9807,
13532,
19889,
19541,
9805,
5388,
19073,
5343,
5344,
20933,
-1,
7048,
14874,
20182,
20528,
13594,
14875,
3188,
13327,
5304,
8715,
21036,
16744,
6108,
13611,
7229,
7233,
7231,
7230,
7232,
7046,
14979,
20325,
20060,
20057,
20058,
20059,
20062,
20324,
20513,
4386,
4385,
4391,
4390,
13568,
13559,
4384,
4387,
4389,
4392,
13606,
13580,
-1,
18997,
18556,
14903,
16715,
16771,
13615,
20534,
5202,
14511,
20621,
17376,
15020,
14904,
15000,
16989,
19303,
5404,
16716,
20968,
17365,
18750,
18751,
18752,
21045,
21044,
21046,
13617,
21022,
17358,
2621,
2622,
20990,
8721,
8723,
8724,
19900,
19904,
19905,
8727,
8725,
8726,
18748,
16344,
16350,
20486,
5341,
5342,
18996,
10387,
9994,
17382,
3168,
2562,
20754,
19005,
1851,
17208,
20313,
16348,
5320,
19067,
6291,
5332,
14892,
14891,
14890,
14889,
7029,
20164,
15017,
14901,
7039,
20175,
7036,
20172,
9692,
6289,
6288,
13182,
13186,
13183,
13185,
13180,
6287,
13181,
20635,
9679,
14956,
5299,
4457,
9693,
17729,
17730,
20951,
5358,
5361,
5362,
5360,
5366,
5364,
20619,
5369,
20961,
20088,
5365,
5368,
5373,
19766,
8746,
21179,
20957,
16742,
2096,
2097,
18547,
20962,
18549,
18550,
20941,
20943,
20944,
19050,
20634,
11194,
16752,
3253,
16735,
20955,
19051,
21040,
11193,
21064,
20643,
5387,
14625,
17732,
7247,
20946,
19569,
20947,
20960,
12069,
21037,
5385,
19055,
20958,
20954,
17731,
2707,
5371,
5372,
2706,
18551,
16753,
3254,
20644,
5392,
5391,
21130,
20952,
20953,
20948,
16733,
5413,
19491,
5333,
19304,
16731,
16732,
16729,
16730,
19868,
5182,
19878,
5192,
14973,
14963,
14974,
14964,
19867,
5181,
19877,
5191,
19440,
19407,
19443,
19410,
19869,
5183,
19879,
5193,
19441,
19408,
19444,
19411,
19539,
19540,
5199,
5200,
7007,
21114,
20145,
18723,
5403,
19418,
6290,
19429,
19437,
5430,
4867,
4868,
4869,
19483,
4870,
19416,
15948,
15957,
2438,
20074,
20316,
19505,
5316,
20339,
19559,
19560,
15001,
9334,
6284,
5300,
14996,
14997,
13666,
17372,
15008,
13670,
10389,
12059,
20980,
16757,
17370,
14510,
17369,
12052,
17373,
20085,
18999,
11647,
14999,
9663,
9676,
5127,
9677,
11901,
4672,
20314,
5335,
19517,
15967,
2104,
16758,
14991,
18756,
19892,
5379,
19896,
16789,
18758,
16761,
19910,
13748,
19895,
13747,
9678,
16748,
19890,
2442,
9027,
20632,
20080,
13331,
14957,
20477,
4665,
13259,
13260,
16353,
1577,
13338,
7041,
14992,
16718,
3208,
13710,
17961,
2093,
5386,
4666,
13738,
13741,
16644,
]

_charnames_128736 = [
19299,
4674,
17385,
9688,
20338,
9689,
21122,
21123,
21120,
5378,
19885,
12074,
12075,
-1,
-1,
-1,
4871,
17371,
19061,
16354,
]

_charnames_128768 = [
11798,
11694,
11811,
11812,
11796,
11683,
11681,
11682,
11679,
11680,
11744,
11747,
11746,
11661,
11761,
11740,
11771,
11774,
11773,
11714,
11663,
11801,
11749,
11750,
11729,
11730,
11808,
11674,
11791,
11792,
11706,
11725,
11712,
11793,
11658,
11704,
11705,
11713,
11665,
11656,
11751,
11765,
11805,
11692,
11659,
11666,
11657,
11748,
11723,
11724,
11717,
11721,
11720,
11719,
11685,
11686,
11776,
11667,
11691,
11726,
11727,
11689,
11741,
11766,
11767,
11799,
11732,
11735,
11734,
11687,
11810,
11672,
11764,
11807,
11795,
11754,
11709,
11768,
11708,
11675,
11710,
11769,
11671,
11804,
11673,
11809,
11780,
11690,
11756,
11739,
11755,
11693,
11669,
11670,
11660,
11760,
11788,
11786,
11787,
11759,
11758,
11697,
11702,
11701,
11700,
11699,
11688,
11738,
11737,
11728,
11779,
11802,
11789,
11775,
11783,
11782,
]

_charnames_128896 = [
13566,
13603,
13557,
13577,
13530,
9317,
13688,
19467,
15953,
8739,
20560,
20304,
13589,
13529,
6283,
9308,
13687,
19465,
15952,
8738,
20497,
20498,
5014,
13591,
13599,
13515,
20506,
20507,
19046,
13590,
13598,
13514,
20522,
14921,
6285,
9319,
13692,
15960,
15958,
8743,
14920,
6282,
9301,
13691,
19417,
15950,
8742,
6275,
9306,
13693,
19478,
15959,
8744,
6281,
9298,
13690,
19413,
15949,
8741,
6286,
9314,
13694,
19450,
15955,
6279,
9312,
14902,
9311,
6272,
9305,
21009,
9304,
20071,
6276,
19479,
9299,
19414,
4456,
9315,
19449,
15956,
19448,
6278,
19473,
19472,
]

_charnames_129024 = [
6984,
21095,
20123,
18706,
6987,
21098,
20126,
18709,
6988,
21099,
20127,
18710,
-1,
-1,
-1,
-1,
6985,
21096,
20124,
18707,
6989,
21100,
20128,
18711,
19425,
19470,
19476,
19456,
19424,
19469,
19475,
19455,
6951,
21081,
20106,
18691,
6952,
21082,
20107,
18692,
6954,
21085,
20109,
18695,
6953,
21083,
20108,
18693,
6950,
21080,
20105,
18690,
7014,
21115,
20152,
18724,
7004,
21106,
20142,
18714,
7018,
21116,
20156,
18725,
7010,
21109,
20148,
18717,
7011,
21110,
20149,
18718,
]

_charnames_129104 = [
7005,
21107,
20143,
18715,
19873,
19883,
5197,
5187,
7024,
21127,
-1,
-1,
-1,
-1,
-1,
-1,
20606,
20594,
20600,
20612,
20582,
20588,
20575,
20569,
20608,
20596,
20602,
20614,
20584,
20590,
20577,
20571,
20605,
20593,
20599,
20611,
20581,
20587,
20574,
20568,
20607,
20595,
20601,
20613,
20583,
20589,
20576,
20570,
20604,
20592,
20598,
20610,
20580,
20586,
20573,
20567,
]

_charnames_129168 = [
6959,
21090,
20114,
18701,
7015,
21103,
20153,
18722,
6986,
21097,
20125,
18708,
19432,
19436,
19435,
19434,
7001,
20139,
6973,
20116,
7017,
20146,
7008,
20155,
7002,
20140,
7013,
20151,
20556,
20555,
]

_charnames_129296 = [
21191,
9668,
20950,
19769,
14922,
20956,
20317,
19571,
4256,
]

_charnames_917760 = [
15397,
15386,
15375,
15530,
15519,
15508,
15497,
15486,
15541,
15552,
15551,
15550,
15549,
15629,
15628,
15627,
15626,
15625,
15624,
15623,
15622,
15621,
15620,
15618,
15617,
15616,
15615,
15614,
15613,
15612,
15611,
15610,
15609,
15607,
15606,
15605,
15604,
15603,
15602,
15601,
15600,
15599,
15598,
15596,
15595,
15594,
15593,
15592,
15591,
15590,
15589,
15588,
15587,
15585,
15584,
15583,
15582,
15581,
15580,
15579,
15578,
15577,
15576,
15574,
15573,
15572,
15571,
15570,
15569,
15568,
15567,
15566,
15565,
15563,
15562,
15561,
15560,
15559,
15558,
15557,
15556,
15555,
15554,
15484,
15483,
15482,
15481,
15480,
15479,
15478,
15477,
15476,
15475,
15473,
15472,
15471,
15470,
15469,
15468,
15467,
15466,
15465,
15464,
15462,
15461,
15460,
15459,
15458,
15457,
15456,
15455,
15454,
15453,
15451,
15450,
15449,
15448,
15447,
15446,
15445,
15444,
15443,
15442,
15440,
15439,
15438,
15437,
15436,
15435,
15434,
15433,
15432,
15431,
15429,
15428,
15427,
15426,
15425,
15424,
15423,
15422,
15421,
15420,
15418,
15417,
15416,
15415,
15414,
15413,
15412,
15411,
15410,
15409,
15407,
15406,
15405,
15404,
15403,
15402,
15401,
15400,
15399,
15398,
15396,
15395,
15394,
15393,
15392,
15391,
15390,
15389,
15388,
15387,
15385,
15384,
15383,
15382,
15381,
15380,
15379,
15378,
15377,
15376,
15540,
15539,
15538,
15537,
15536,
15535,
15534,
15533,
15532,
15531,
15529,
15528,
15527,
15526,
15525,
15524,
15523,
15522,
15521,
15520,
15518,
15517,
15516,
15515,
15514,
15513,
15512,
15511,
15510,
15509,
15507,
15506,
15505,
15504,
15503,
15502,
15501,
15500,
15499,
15498,
15496,
15495,
15494,
15493,
15492,
15491,
15490,
15489,
15488,
15487,
15548,
15547,
15546,
15545,
15544,
15543,
15542,
]

_charnames_983040 = [
19969,
19968,
5296,
5206,
5294,
5321,
8707,
8638,
8705,
8766,
8718,
8717,
12062,
12061,
11814,
13736,
13324,
13754,
2322,
19512,
19572,
14508,
6106,
19695,
8711,
7254,
19975,
8768,
6104,
15964,
15989,
21018,
21067,
2623,
3237,
4670,
7239,
5133,
4671,
7238,
3269,
19071,
19089,
18982,
19087,
18979,
19086,
18980,
19085,
18983,
19084,
19764,
19965,
5283,
5282,
8706,
8639,
2561,
2448,
8710,
8767,
5130,
5129,
8763,
8762,
20742,
20988,
21065,
20740,
17735,
17962,
20739,
20086,
20354,
20741,
21175,
21183,
5324,
19000,
18998,
16356,
16355,
19564,
19546,
13496,
13755,
19894,
19973,
20752,
20750,
19768,
19770,
5293,
5432,
8708,
8764,
2325,
19515,
19573,
2324,
19514,
19574,
6105,
15965,
15990,
16289,
16290,
16646,
16291,
16288,
16645,
20070,
20073,
20090,
4447,
4453,
5434,
4448,
4452,
5433,
18981,
19083,
16712,
16709,
16793,
16711,
16708,
16792,
5415,
5323,
2563,
3267,
9335,
10531,
5297,
5295,
5345,
8712,
8709,
8774,
5292,
5204,
4449,
5440,
4450,
5408,
2100,
3265,
5312,
5288,
17363,
17327,
16713,
16797,
12071,
12072,
19972,
4675,
6842,
6636,
3266,
11817,
5280,
18542,
6926,
6927,
6928,
6929,
14697,
21059,
21058,
21057,
10532,
21189,
21187,
21190,
7251,
20351,
7253,
20353,
16796,
7250,
20350,
19974,
10533,
20649,
7252,
20352,
21066,
16795,
20641,
10384,
10385,
6948,
20103,
21193,
16689,
15631,
15742,
15876,
15865,
15854,
15843,
15832,
15821,
15810,
15731,
15720,
15709,
15698,
15687,
15676,
15665,
13753,
13713,
21188,
998,
1000,
13752,
15654,
15643,
15632,
15787,
15776,
15765,
15754,
15743,
15798,
15809,
15808,
15807,
15806,
15886,
15885,
15884,
15883,
15882,
15881,
15880,
15879,
15878,
15877,
15875,
15874,
15873,
15872,
15871,
15870,
15869,
15868,
15867,
15866,
15864,
15863,
15862,
15861,
15860,
15859,
15858,
15857,
15856,
15855,
15853,
15852,
15851,
15850,
15849,
15848,
15847,
15846,
15845,
15844,
15842,
15841,
15840,
15839,
15838,
15837,
15836,
15835,
15834,
15833,
15831,
15830,
15829,
15828,
15827,
15826,
15825,
15824,
15823,
15822,
15820,
15819,
15818,
15817,
15816,
15815,
15814,
15813,
15812,
15811,
15741,
15740,
15739,
15738,
15737,
15736,
15735,
15734,
15733,
15732,
15730,
15729,
15728,
15727,
15726,
15725,
15724,
15723,
15722,
15721,
15719,
15718,
15717,
15716,
15715,
15714,
15713,
15712,
15711,
15710,
15708,
15707,
15706,
15705,
15704,
15703,
15702,
15701,
15700,
15699,
15697,
15696,
15695,
15694,
15693,
15692,
15691,
15690,
15689,
15688,
15686,
15685,
15684,
15683,
15682,
15681,
15680,
15679,
15678,
15677,
15675,
15674,
15673,
15672,
15671,
15670,
15669,
15668,
15667,
15666,
15664,
15663,
15662,
15661,
15660,
15659,
15658,
15657,
15656,
15655,
15653,
15652,
15651,
15650,
15649,
15648,
15647,
15646,
15645,
15644,
15642,
15641,
15640,
15639,
15638,
15637,
15636,
15635,
15634,
15633,
15797,
15796,
15795,
15794,
15793,
15792,
15791,
15790,
15789,
15788,
15786,
15785,
15784,
15783,
15782,
15781,
15780,
15779,
15778,
15777,
15775,
15774,
15773,
15772,
15771,
15770,
15769,
15768,
15767,
15766,
15764,
15763,
15762,
15761,
15760,
15759,
15758,
15757,
15756,
15755,
15753,
15752,
15751,
15750,
15749,
15748,
15747,
15746,
15745,
15744,
15805,
15804,
15803,
15802,
15801,
15800,
15799,
]

_charnames_983552 = [
6714,
6484,
6690,
6365,
6692,
6367,
6693,
6368,
6701,
6376,
6702,
6377,
6734,
6412,
6407,
6576,
6769,
6466,
6771,
6468,
6772,
6469,
6760,
6354,
6782,
6422,
6712,
6481,
6711,
6480,
6696,
6371,
6695,
6370,
6699,
6374,
6698,
6373,
6406,
6405,
6733,
6410,
6732,
6409,
6837,
6648,
6792,
6499,
6822,
6579,
6740,
6440,
6786,
6426,
6785,
6425,
6783,
6423,
6781,
6421,
6492,
6461,
6462,
6312,
6313,
6351,
6352,
6605,
6606,
11565,
11569,
11566,
11571,
11570,
11568,
11572,
11567,
11573,
13720,
14090,
14079,
14098,
14078,
14087,
14076,
14086,
14075,
14094,
14095,
14092,
14088,
14083,
14093,
14085,
14084,
14089,
14077,
14096,
14082,
14081,
14080,
14097,
14091,
13921,
13926,
13927,
13922,
13923,
13928,
13929,
13920,
13924,
13925,
13919,
13804,
13809,
13810,
13805,
13806,
13811,
13812,
13803,
13807,
13808,
13802,
14064,
14069,
14070,
14065,
14066,
14071,
14072,
14063,
14067,
14068,
14062,
13791,
13796,
13797,
13792,
13793,
13798,
13799,
13790,
13794,
13795,
13789,
13935,
13940,
13941,
13936,
13937,
13942,
13943,
13934,
13938,
13939,
13933,
13778,
13783,
13784,
13779,
13780,
13785,
13786,
13777,
13781,
13782,
13776,
13947,
13952,
13953,
13948,
13949,
13954,
13955,
13946,
13950,
13951,
13945,
13816,
13821,
13822,
13817,
13818,
13823,
13824,
13815,
13819,
13820,
13814,
14012,
14017,
14018,
14013,
14014,
14019,
14020,
14011,
14015,
14016,
14010,
14025,
14030,
14031,
14026,
14027,
14032,
14033,
14024,
14028,
14029,
14023,
13986,
13991,
13992,
13987,
13988,
13993,
13994,
13985,
13989,
13990,
13984,
13973,
13978,
13979,
13974,
13975,
13980,
13981,
13972,
13976,
13977,
13971,
13895,
13900,
13901,
13896,
13897,
13902,
13903,
13894,
13898,
13899,
13893,
13999,
14004,
14005,
14000,
14001,
14006,
14007,
13998,
14002,
14003,
13997,
13871,
13876,
13877,
13872,
13873,
13878,
13879,
13870,
13874,
13875,
13869,
13883,
13888,
13889,
13884,
13885,
13890,
13891,
13882,
13886,
13887,
13881,
13961,
13966,
13967,
13962,
13963,
13968,
13969,
13960,
13964,
13965,
13959,
13766,
13771,
13772,
13767,
13768,
13773,
13774,
13765,
13769,
13770,
13764,
14038,
14043,
14044,
14039,
14040,
14045,
14046,
14037,
14041,
14042,
14036,
13830,
13835,
13836,
13831,
13832,
13837,
13838,
13829,
13833,
13834,
13828,
13844,
13849,
13850,
13845,
13846,
13851,
13852,
13843,
13847,
13848,
13842,
13856,
13861,
13862,
13857,
13858,
13863,
13864,
13855,
13859,
13860,
13854,
14051,
14056,
14057,
14052,
14053,
14058,
14059,
14050,
14054,
14055,
14049,
13906,
13909,
13914,
13915,
13910,
13911,
13916,
13917,
13908,
13912,
13913,
13907,
13839,
4443,
4442,
4441,
17926,
18062,
18060,
18061,
18059,
18055,
18068,
18066,
18067,
18065,
18053,
18083,
18046,
18082,
18045,
18056,
18051,
18049,
18050,
18048,
18054,
18089,
18076,
18077,
18075,
18087,
18084,
18086,
18079,
18085,
18071,
18070,
18072,
18088,
18080,
18098,
18094,
18091,
18092,
18095,
18097,
18099,
19555,
19553,
19551,
19554,
19552,
18524,
18522,
18520,
18523,
18521,
18531,
18528,
18529,
18530,
9512,
9506,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 6546
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 6316
    elif code == 687: res = 6317
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 895: res = _charnames_880[code-880]
    elif code == 975: res = 17581
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1644
    elif code == 1231: res = 2791
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1327: res = _charnames_1296[code-1296]
    elif code == 1421: res = 20187
    elif code == 1422: res = 7054
    elif code == 1423: res = 11648
    elif code == 1442: res = 19502
    elif code == 1466: res = 19499
    elif code == 1477: res = 19501
    elif code == 1478: res = 19500
    elif code == 1479: res = 19498
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 11429
    elif code == 1596: res = 11427
    elif code == 1597: res = 11404
    elif code == 1598: res = 11402
    elif code == 1599: res = 11403
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 11497
    elif code == 1775: res = 11452
    elif code == 1791: res = 11466
    elif code == 1837: res = 5279
    elif code == 1838: res = 5277
    elif code == 1839: res = 5278
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2142: res = _charnames_1984[code-1984]
    elif 2208 <= code <= 2228: res = _charnames_2208[code-2208]
    elif 2275 <= code <= 2308: res = _charnames_2275[code-2275]
    elif code == 2362: res = 18969
    elif code == 2363: res = 18968
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2432: res = _charnames_2417[code-2417]
    elif code == 2493: res = 13722
    elif code == 2510: res = 13721
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 17951
    elif code == 2677: res = 17949
    elif code == 2700: res = 17941
    elif code == 2785: res = 17942
    elif code == 2786: res = 17944
    elif code == 2787: res = 17945
    elif code == 2800: res = 17947
    elif code == 2801: res = 17946
    elif code == 2809: res = 17943
    elif code == 2869: res = 17345
    elif code == 2884: res = 17342
    elif code == 2914: res = 17340
    elif code == 2915: res = 17341
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 14109
    elif code == 3024: res = 14106
    elif code == 3046: res = 14101
    elif 3059 <= code <= 3072: res = _charnames_3059[code-3059]
    elif code == 3124: res = 14863
    elif code == 3133: res = 14868
    elif code == 3160: res = 14861
    elif code == 3161: res = 14864
    elif code == 3162: res = 14862
    elif code == 3170: res = 14869
    elif code == 3171: res = 14870
    elif 3192 <= code <= 3201: res = _charnames_3192[code-3192]
    elif code == 3260: res = 18536
    elif code == 3261: res = 18539
    elif code == 3298: res = 18540
    elif code == 3299: res = 18541
    elif code == 3313: res = 18537
    elif code == 3314: res = 18535
    elif code == 3329: res = 9966
    elif code == 3369: res = 9948
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif code == 3406: res = 9949
    elif code == 3423: res = 9950
    elif code == 3426: res = 9952
    elif code == 3427: res = 9953
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif code == 3806: res = 6924
    elif code == 3807: res = 6923
    elif code == 3947: res = 14714
    elif code == 3948: res = 14713
    elif code == 3980: res = 14711
    elif code == 3981: res = 14707
    elif code == 3982: res = 14706
    elif code == 3983: res = 14708
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif 4345 <= code <= 4351: res = _charnames_4345[code-4345]
    elif code == 4442: res = 19257
    elif code == 4443: res = 19247
    elif code == 4444: res = 19249
    elif code == 4445: res = 19248
    elif code == 4446: res = 19231
    elif code == 4515: res = 19209
    elif code == 4516: res = 19193
    elif code == 4517: res = 19192
    elif code == 4518: res = 19196
    elif code == 4519: res = 19197
    elif code == 4602: res = 19153
    elif code == 4603: res = 19152
    elif code == 4604: res = 19156
    elif code == 4605: res = 19154
    elif code == 4606: res = 19155
    elif code == 4607: res = 19105
    elif code == 4615: res = 8618
    elif code == 4679: res = 8582
    elif code == 4743: res = 8572
    elif code == 4783: res = 8592
    elif code == 4815: res = 8614
    elif code == 4847: res = 8613
    elif code == 4879: res = 8492
    elif code == 4895: res = 8490
    elif code == 4935: res = 8550
    elif code == 4957: res = 8636
    elif code == 4958: res = 8637
    elif code == 4959: res = 8635
    elif code == 4960: res = 8619
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif 5109 <= code <= 5120: res = _charnames_5109[code-5109]
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6109: res = 18041
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6846: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7295: res = _charnames_7164[code-7164]
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif 7376 <= code <= 7679: res = _charnames_7376[code-7376]
    elif code == 7836: res = 6508
    elif code == 7837: res = 6507
    elif code == 7838: res = 6764
    elif code == 7839: res = 6552
    elif code == 7930: res = 6820
    elif code == 7931: res = 6585
    elif code == 7932: res = 6819
    elif code == 7933: res = 6584
    elif code == 7934: res = 6849
    elif code == 7935: res = 6641
    elif 8275 <= code <= 8297: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8382: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1709
    elif code == 8428: res = 1794
    elif code == 8429: res = 1703
    elif code == 8430: res = 1701
    elif code == 8431: res = 1792
    elif code == 8432: res = 1817
    elif code == 8507: res = 20965
    elif code == 8508: res = 18740
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif 8580 <= code <= 8587: res = _charnames_8580[code-8580]
    elif 9167 <= code <= 9210: res = _charnames_9167[code-9167]
    elif code == 9471: res = 19763
    elif code == 9748: res = 21181
    elif code == 9749: res = 19536
    elif code == 9752: res = 4651
    elif code == 9854: res = 16737
    elif code == 9855: res = 20561
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 5348
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 19421
    elif code == 10080: res = 19422
    elif code == 10133: res = 19480
    elif code == 10134: res = 19482
    elif code == 10135: res = 19458
    elif code == 10160: res = 1575
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 9981
    elif code == 10221: res = 9977
    elif code == 10222: res = 9982
    elif code == 10223: res = 9978
    elif 11008 <= code <= 11217: res = _charnames_11008[code-11008]
    elif code == 11244: res = 6968
    elif code == 11245: res = 21091
    elif code == 11246: res = 20115
    elif code == 11247: res = 18702
    elif 11264 <= code <= 11623: res = _charnames_11264[code-11264]
    elif code == 11631: res = 14691
    elif code == 11632: res = 14690
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11842: res = _charnames_11680[code-11680]
    elif code == 12589: res = 13698
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 16284
    elif code == 12830: res = 16285
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 3228
    elif code == 12925: res = 3227
    elif code == 12926: res = 3231
    elif code == 13004: res = 5009
    elif code == 13005: res = 5012
    elif code == 13006: res = 5011
    elif code == 13007: res = 6202
    elif code == 13175: res = 5002
    elif code == 13176: res = 5004
    elif code == 13177: res = 5005
    elif code == 13178: res = 5016
    elif code == 13278: res = 5013
    elif code == 13279: res = 5019
    elif code == 13311: res = 5017
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42743: res = _charnames_42560[code-42560]
    elif 42752 <= code <= 42935: res = _charnames_42752[code-42752]
    elif 42999 <= code <= 43127: res = _charnames_42999[code-42999]
    elif 43136 <= code <= 43204: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43574: res = _charnames_43359[code-43359]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif 43739 <= code <= 43766: res = _charnames_43739[code-43739]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43877: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 44025: res = _charnames_43888[code-43888]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif code == 64046: res = 3081
    elif code == 64047: res = 3080
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 11522
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif 65060 <= code <= 65071: res = _charnames_65060[code-65060]
    elif code == 65095: res = 16693
    elif code == 65096: res = 16690
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65952: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 17209
    elif 66384 <= code <= 66517: res = _charnames_66384[code-66384]
    elif code == 66598: res = 18991
    elif code == 66599: res = 18992
    elif 66638 <= code <= 66729: res = _charnames_66638[code-66638]
    elif 66816 <= code <= 66855: res = _charnames_66816[code-66816]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 2702
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67584 <= code <= 67742: res = _charnames_67584[code-67584]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67903: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68167: res = _charnames_67968[code-67968]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68255: res = _charnames_68192[code-68192]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68352 <= code <= 68497: res = _charnames_68352[code-68352]
    elif code == 68505: res = 16683
    elif code == 68506: res = 16682
    elif code == 68507: res = 16681
    elif code == 68508: res = 16680
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif code == 68858: res = 16912
    elif code == 68859: res = 16917
    elif code == 68860: res = 16919
    elif code == 68861: res = 16918
    elif code == 68862: res = 16915
    elif code == 68863: res = 16914
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69759 <= code <= 69825: res = _charnames_69759[code-69759]
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70205: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71257: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 20466
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 73728 <= code <= 74649: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74868: res = _charnames_74752[code-74752]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 110592: res = 18532
    elif code == 110593: res = 19556
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif code == 119081: res = 10468
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119665: res = _charnames_119648[code-119648]
    elif code == 120001: res = 9989
    elif code == 120484: res = 9985
    elif code == 120485: res = 9984
    elif code == 120778: res = 9988
    elif code == 120779: res = 9987
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 11369
    elif code == 126705: res = 11370
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127386: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 3201
    elif code == 127569: res = 3202
    elif 127744 <= code <= 128720: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128755: res = _charnames_128736[code-128736]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 128896 <= code <= 128980: res = _charnames_128896[code-128896]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129296 <= code <= 129304: res = _charnames_129296[code-129296]
    elif code == 129408: res = 3260
    elif code == 129409: res = 6294
    elif code == 129410: res = 5407
    elif code == 129411: res = 14983
    elif code == 129412: res = 21176
    elif code == 129472: res = 2434
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983498: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983981: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklkmnopqrstukvkkkkk\x15\x15\x15wxykkkkkkkkkk\x15\x15\x15\x15zkkkkkkkkkkk'
'kkkk\x15\x15{kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x15\x15|}kkk~kkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x7fkkkkkkkkkkk\x80kkk'
'kkkkkkkkkkkkkkkk\x81\x82\x83\x84\x85\x86\x87\x88((\x89kkkkkkkkkkkkk\x8akkkkk\x8bk\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95kkkkkk'
'\x96\x975555555\x98\x99\x9a55555555555555555555555\x9b55555\x9c55555555555555555\x9d5555'
'5555555555555555555555555555555555\x9e55555555555555555555555555555'
'55555555555555555555555555555555555555\x9f5555555555555555\xa0\xa15555555'
'55555555555555\xa2\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\x9b5\xa4\xa3\xa3\xa3\xa3\xa5'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa5'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'\xa6\xa7kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xa8'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xa8'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd5\x90\x90\x85\xa2\x85\x90\x91\x9ao\x90\xaf~e\x7f~EEEEEEEEEE\x7f\x90\xbd\xbc\xbd\x90'
'\x9088888888888888888888888888\x9a\x90o\xa9b\xa9\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9a\xbco\xbc\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd2\x88\xa2\xa2\x9e\xa2\xcd\x88\xa6\xcc-x\xbc\x07\xc9\xa9\xc1\xb1RR\xa6\x1b\x88\x8a\xa6R-tYYY\x88'
'77777757777777775777777\xb45777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb4\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xa8\xa8\xa6\xa8)')''')'))\x1f$\xa8\xa8\xa8\xa8\xa8\xa8\xa6\xa6\xa6\xa6\xa8\xa6\xa8\xa6%%%%%\xa8\xa8\xa8\xa8\xa8\xa8\xa8)\xa8$\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xa87\x1b\x15\x15#\x1b\x1b\x1b\x8e7'
'\x15\x15\x15\x15\xa8\xa87\x8f777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xb97\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xc7@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x87\x87\x87\x87\x87\x87\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x87h\x15\x15\xcc\xcc\xa1\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@j@'
'\x94@@\x94@@\x94@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x15\x15333\x94\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xb9\xb9\xab\x84\x84\x9d}y\xcc\xcc@@@@@@@@@@@y\x05\x15yy,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@BBBBBBBBBB\x84zzy,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,y,@@@@@@@\x06\xcc@@@@@@\x1e\x1e@@\xcc@@@@,,DDDDDDDDDD,,,\xc0\xc0,'
'yyyyyyyyyyyyyy\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'GGGGGGGGGG333333333333333333333333333333333@@@@@@@@@**\xcc\x8e\x8e\x8e*\x15\x15\x15\x15\x15'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x15'
'3333333333333333333333333@@@\x15\x15\x94\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x87\x87FFFFFFFFFF\x87$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15FFFFFFFFFF00\xa1\xa1VVVVVV\xc7\xa1\x15\x15\x15\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF@@000@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15FFFFFFFFFF\x87\xa1\x15\x15\x15\x15\x15\x15\x150\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15FFFFFFFFFF\xc70VVVVVV\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFFVVV\xcc\xcc\xcc\xcc\xcc\xcc\xa1\xcc\x15\x15\x15\x15\x15'
'@:::\x1500000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15[[[[[[[\xc7'
'\x15@::\x1500000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15FFFFFFFFFF\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15000\x1500000000000000000000000000000000000000000\x15\x150::'
':@@@@\x15:::\x15:::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15000@@\x15\x15FFFFFFFFFFVVVVVV\x15\x15\x15\xc7000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15::\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa1'
'000000$@@@@@@@@\x87FFFFFFFFFF\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x15\x1500\x150\x15\x150\x15\x15\x15\x15\x15\x150000\x150000000\x15000\x150\x150\x15\x1500\x150000@0/@@@@@@\x15@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15FFFFFFFFFF\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xc7\xc7\xc7\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\xc7\x87\xc7\xc7\xc7@@\xc7\xc7\xc7\xc7\xc7\xc7FFFFFFFFFFVVVVVVVVVV\xc7@\xc7@\xc7@\x99n\x99n::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x87@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7@\xc7\xc7\xc7\xc7\xc7\xc7\x15\xc7\xc7\x87\x87\x87\x87\x87\xc7\xc7\xc7\xc7\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'FFFFFFFFFF\x87\x87\x87\x87\x87\x87000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:FFFFFFFFFF:::@\xc7\xc777777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x150000000000000000000000000000000000000000000\x87$000'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x87\x87\x87\x87\x87\x87\x87\x87\x87WWWWWWWWWVVVVVVVVVVV\x15\x15\x15'
'0000000000000000\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'h000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\x87\x8700000000000000000'
'\xd400000000000000000000000000\x99n\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x87\x87\x87JJJ00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x87\x87\x87$\x87\x87\x87\xa10@\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15[[[[[[[[[[\x15\x15\x15\x15\x15\x15'
'\x8e\x8e\x8e\x8e\x8e\x8eh\x8e\x8e\x8e\x8e@@@\x08\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$0000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcc\x15\x15\x15\x8e\x8eFFFFFFFFFF000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15FFFFFFFFFFW\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'00000000000000000000000@@::@\x15\x15\x87\x8700000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'FFFFFFFFFF\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x87\x87\x87\x87\x87\x87\x87$\x87\x87\x87\x87\x87\x87\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15FFFFFFFFFF\x87\x87\x87\x87\x87\x87\x87\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@@@@@@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00FFFFFFFFFF000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x87\x87\x87\x87'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x87\x87\x87\x87\x87'
'FFFFFFFFFF\x15\x15\x15000FFFFFFFFFF000000000000000000000000000000$$$$$$\x87\x87'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x87\x87\x87\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15@@@\x87@@@@@@@@@@@@@:@@@@@@@0000@0000::@00\x15@@\x15\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xa8\x1b\xa8'
'\xa8\xa8\x1b\x1b\x1b\x15\x1b\x1b77774\xa8\xa8\xa8\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xa8\xa8\xa8\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xa8\xa8\xa8\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xa8\xa8\x15'
'\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\x08\x08\x08\n\x11ghhggg\x88\x8evs\x98wur\x98w\x88\x88\x88\x8e\x89\x88\x88\x89\xd0\xd1\x0b\x12\x0f\r\x14\xd2\x82\x84\x82\x82\x84\x88\x8e\x8e\x8ext\x88\x8e\x8e\x88a'
'a\x8e\x8e\x8e\xac\x99n\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\xb9\x8ea\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\xd4\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08T%\x15\x15RTTTTT\xae\xae\xb9\x99n '
'TRRRRTTTTT\xae\xae\xb9\x99n\x15%%%%%%%%%%%%%\x15\x15\x15\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa0\xa1\xa1\x9e\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc7\xc9\xcc\xc9\xcc7\xcc\xc9\x1b777\x1b\x1b777\x19\xcc7\xc9\xcc\xbb77777\xcc\xcc\xcc\xc9\xc9\xcc7\xcc5\xcc7\xcc7577\xc3\x1b7777\x1b0000\x1b\xcc\xcc\x1b\x1b77'
'\xba\xb9\xb9\xb9\xb97\x1b\x1b\x1b\x1b\xcc\xb9\xcc\xcc\x1b\xc7[[[YY[[[[[[YYYY[HHHHHHHHHHHHKKKKIIIIIIIIIILLLLLL'
'JJJ7\x1bJJJJY\xcc\xcc\x15\x15\x15\x15\xb4\xb4\xb4\xb4\xb4\xc9\xc9\xc9\xc9\xc9\xb9\xb9\xcc\xcc\xcc\xcc\xb9\xcc\xcc\xb9\xcc\xcc\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xcc\xcc\xb4\xcc\xb4\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb4\xba\xb5\xb5\xba\xb9\xb9\xb4\xb5\xba\xba\xb5\xba\xba\xb9\xb4\xb9\xb5\xae\xb2\xb9\xb5\xba\xb9\xb9\xb9\xb5\xba\xba\xb5\xb4\xb5\xb5\xba\xba\xb4\xba\xb4\xba\xb4\xb4\xb4\xb4\xb5\xb5\xba\xb5\xba\xba\xba\xba\xba\xb4\xb4\xb4\xb4\xb9\xba\xb9\xba\xb5\xb5\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xb5\xba\xba\xba\xb5\xb9\xb9\xb9\xb9\xb9\xb5\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xb5\xb4\xba\xb9\xb5\xb5\xb5\xb5\xba\xba\xb5\xb5\xb9\xb9\xb5\xb5\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xb5\xb5\xba\xba\xb5\xb5\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xba\xba\xb9\xb9\xb4\xb9\xb9\xba\xb4\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb4\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xb5'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x99n\x99n\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xba\xba\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x9cq\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xcc\xb9\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc7\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15ZZZZZZZZZYYYYYYYYYYYZZZZZZZZZYYY'
'YYYYYYYYRRRRRRRRRQQQQQQQQQQQ\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\\YYYYYYYYYYZZZZZZZZZYZ'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xc9\xb4\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc'
'\xc9\xb4\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xcc\xcc\xc9\xcc\xcc\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xc9\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xc9\xc9\xc9\xcc\xc9\xc9\xc9\xc9\xcc\xc9\xc9\xcc\xb4\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc7\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9'
'\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x99n\x99n\x99n\x99n\x99n\x99n\x99nZZZZZZZZZY'
'\\\\\\\\\\\\\\\\\\[\\\\\\\\\\\\\\\\\\[\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xba\xb9\xb9\xba\xba\x99n\xb9\xba\xba\xb9\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xb9\xb9\xb9\xba\xba\xba\xba\x9ao\x9ao\x9ao\x9ao\x99n\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\x99n\x9ao\x99n\x99n\x99n\x99n\x99n\x99n\x99n\x99n\x99n\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xba\xba\xb9\xb9\x99n\x99n\xba\xb9\xb9\xb9\xb9\xba\xb9\xba\xba\xba\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xb9\xb9\x99n\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xba\xba\xba\xba\xb9\xb9\xba\xb9\xba\xb9\xb9\xba\xb9\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xb9\xba\xba\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xb9\xba\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xb9\xb9\xb9\xb9\xba\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xba\xb9\xb9'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777777777777777777777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x1b777\x1b\x1b7\x1b7\x1b7\x1b7777\x1b7\x1b\x1b7\x1b\x1b\x1b\x1b\x1b\x1b%%77'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\xcc\xcc\xcc\xcc\xcc\xcc7\x1b7\x1b@@@7\x1b\x15\x15\x15\x15\x15\x8e\x8e\x8e\x8e[\x8e\x8e'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x15\x15\x15\x15\x15\x1b\x15\x150000000000000000'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15$\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'00000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x150000000\x150000000\x15'
'0000000\x150000000\x150000000\x150000000\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'\x8e\x8extxt\x8e\x8e\x8ext\x8ext\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8eh\x8e\x8eh\x8ext\x8e\x8ext\x99n\x99n\x99n\x99n\x8e\x8e\x8e\x8e\x8e(\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8ehh\x8e\x8e\x8e\x8e'
'h\x8e\x98\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15'
'\xd3\x92\x92\x92\xce&1M\x9cq\x9cq\x9cq\x9cq\x9cq\xce\xce\x9cq\x9cq\x9cq\x9cqi\x9bpp\xceMMMMMMMMMAAAA;;i&&&&&\xce\xceMMM&1\x92\xce\xcc'
'\x15111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x15\x15AA\xaa\xaa&&1i1111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111111\x92&&&1'
'\x15\x15\x15\x15\x1511111111111111111111111111111111111111111\x15\x15\x15111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111\x15\xc8\xc8XXXX\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8111111111111111111111111111\x15\x15\x15\x15\x15'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\x15XXXXXXXXXX\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8UUUUUUUU\xce]]]]]]]]]]]]]]]\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xce\xc8'
'XXXXXXXXXX\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8]]]]]]]]]]]]]]]'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xce\xce\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xce\xce\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce'
'1111121111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'2112111212111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111121111111111111111111111111111111111'
'1111111111112111111121211111111111111111111111111111111111111112'
'2111111111111111111111111111111211111111211111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111211111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111121212111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1212221111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1222211111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111211111112111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111211111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111122'
'1111111111112221211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111112111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111211111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111121111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111211112111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111112111112111111111111111111111111111111111111111111121111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111112111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111&111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111\x15\x15\x15\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000000000000000000$$$$$$\x87\x87'
'000000000000$\x8e\x8e\x8e0000000000000000FFFFFFFFFF00\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b0@<<<\x8e@@@@@@@@@@\x8e)'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%%@@00000000000000000000000000000000'
'00000000000000000000000000000000000000JJJJJJJJJJ@@\x87\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8)))))))))\xa8\xa87\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b77\x1b'
'7\x1b7\x1b7\x1b7\x1b)\xa5\xa57\x1b7\x1b07\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7777\x15\x1577777\x1b7\x1b\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150%%\x1b00000'
'00@000@0000@00000000000000000000000::@@:\xcc\xcc\xcc\xcc\x15\x15\x15\x15VVVVVV\xc7\xc7\xa1\xc2\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000\x8e\x8e\x8e\x8e\x15\x15\x15\x15\x15\x15\x15\x15'
'::00000000000000000000000000000000000000000000000000::::::::::::'
'::::@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x87\x87FFFFFFFFFF\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@000000\x87\x87\x870\x870\x15\x15'
'FFFFFFFFFF0000000000000000000000000000@@@@@@@@\x87\x870000000000000000'
'0000000@@@@@@@@@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8711111111111111111111111111111\x15\x15\x15'
'@@@:00000000000000000000000000000000000000000000000@::@@@@::@:::'
':\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x15$FFFFFFFFFF\x15\x15\x15\x15\x87\x8700000@$000000000FFFFFFFFFF00000\x15'
'00000000000000000000000000000000000000000@@@@@@::@@::@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000@00000000@:\x15\x15FFFFFFFFFF\x15\x15\x87\x87\x87\x870000000000000000$000000\xc7\xc7\xc70:@:00'
'000000000000000000000000000000000000000000000000@0@@@00@@00000@@'
'0@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500$\x87\x8700000000000:@@::\x87\x870$$:@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000\x15\x15000000\x15\x15000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xa5%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'00000000000000000000000000000000000::@::@::\x87:@\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0000000\x15\x15\x15\x150000000000000000000000000000000000000000000000000\x15\x15\x15\x15'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111211111112111121111111'
'1111111111111111111111111111111111111111111111111121111111111111'
'1111111111111111121211111111111111111111111111111111111111111211'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x153@3333333333\xae3333333333333\x1533333\x153\x15'
'33\x1533\x153333333333,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4'
'\xa4\xa4\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,m\x98'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,++\x9d\xcc\x15\x15'
'>>>>>>>>>>>>>>>>\x92\x92\x92\x93\x92\x92\x92\x9bp\x92\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@\x92iicc\x9bp\x9bp\x9bp\x9bp\x9bp\x9b'
'p\x9bp\x9bp\x92\x92\x9bp\x92\x92\x92\x92ccc\x80\x92\x81\x15\x92\x81\x92\x92i\x9cq\x9cq\x9cq\x86\x92\x92\xb0f\xbf\xbf\xbe\x15\x92\xa3\x86\x92\x15\x15\x15\x15+,+,+\x15+,+,+,+,+,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15\x15\x08'
'\x15\x8b\x8b\x83\x9f\x83\x8b\x8c\x96k\x8b\xad{d|{CCCCCCCCCC|\x8b\xb7\xb6\xb7\x8b\x8b66666666666666666666666666\x96\x8bk\xa7`'
'\xa7\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x96\xb6k\xb6\x96k\x8d\x97l\x8d\x8d.........."...............'
'..............................!!...............................\x15'
'\x15\x15......\x15\x15......\x15\x15......\x15\x15...\x15\x15\x15\x9f\x9f\xb6\xa7\xca\x9f\x9f\x15\xcb\xb8\xb8\xb8\xb8\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x0e\x0e\x0e\xcc\xc9\x15\x15'
'000000000000\x1500000000000000000000000000\x150000000000000000000\x1500\x150'
'00000000000000\x15\x1500000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15'
'\x87\x8e\x87\x15\x15\x15\x15VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN[[[[\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc[[\xcc\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000\x15\x15\x1500000000000000000000000000000000'
'00000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@SSSSSSSSSSSSSSSSSSSSSSSSSSS\x15\x15\x15\x15'
'00000000000000000000000000000000VVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0J00000000J\x15\x15\x15\x15\x1500000000000000000000000000000000000000@@@@@\x15\x15\x15\x15\x15'
'000000000000000000000000000000\x15\x8700000000000000000000000000000000'
'0000\x15\x15\x15\x1500000000\x87JJJJJ\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7777777777777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b000000000000000000000000000000000000000000000000'
'000000000000000000000000000000\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333\x15\x153\x1533333333333333333333333333333333333333333333\x1533\x15\x15\x153\x15\x153'
'3333333333333333333333\x15\x94^^^^^^^^33333333333333333333333\xcf\xcf^^^^^^^'
'3333333333333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15^^^^^^^^^\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x153333333333333333333\x1533\x15\x15\x15\x15\x15^^^^^'
'3333333333333333333333^^^^^^\x15\x15\x15\x8e33333333333333333333333333\x15\x15\x15\x15\x15\x94'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333333333333333333333333333333\x15\x15\x15\x15^^33'
'^^^^^^^^^^^^^^^^\x15\x15^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^'
'3@@@\x15@@\x15\x15\x15\x15\x15@@@@3333\x15333\x15333333333333333333333333333\x15\x15\x15\x15@@@\x15\x15\x15\x15@'
'____^^^^\x15\x15\x15\x15\x15\x15\x15\x15\x94\x94\x94\x94\x94\x94\x94\x94\x94\x15\x15\x15\x15\x15\x15\x1533333333333333333333333333333^^\x94'
'33333333333333333333333333333^^^\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333\xcf3333333333333333333333333333@@\x15\x15\x15\x15^^^^^\x94\x94\x94\x94\x94\x94\x94\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333333333333333333333333333333333333333333333333333\x15\x15\x15\x8e\x8e\x8e\x8e\x8e\x8e\x8e'
'3333333333333333333333\x15\x15^^^^^^^^3333333333333333333\x15\x15\x15\x15\x15^^^^^^^^'
'333333333333333333\x15\x15\x15\x15\x15\x15\x15\x94\x94\x94\x94\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15^^^^^^^\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'999999999999999999999999999999999999999999999999999\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x15\x15\x15\x15\x15\x15\x15^^^^^^'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15PPPPPPPPPOOOOOOOOOOOOOOOOOOOOOO\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
':@:00000000000000000000000000000000000000000000000000000@@@@@@@@'
'@@@@@@@\x87\x87\x87\x87\x87\x87\x87\x15\x15\x15\x15\\\\\\\\\\\\\\\\\\[[[[[[[[[[[FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'@@:000000000000000000000000000000000000000000000:::@@@@::@@\x87\x87\n\x87\x87'
'\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15'
'@@@000000000000000000000000000000000000@@@@@:@@@@@@@@\x15FFFFFFFFFF'
'\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000000000000000000000000000000@\x87\x870\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@:000000000000000000000000000000000000000000000000:::@@@@@@@@@:'
':0000\x87\x87\x87\x87\x87@@@\x87\x15\x15FFFFFFFFFF0\x870\x87\x87\x87\x15VVVVVVVVVVVVVVVVVVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000\x150000000000000000000000000:::@@@::@:@@\x87\x87\x87\x87\x87\x87\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x150\x150000\x15000000000000000\x150000000000\x87\x15\x15\x15\x15\x15\x150000000000000000'
'0000000000000000000000000000000@:::@@@@@@@@\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
'@::::\x15\x15::\x15\x15:::\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x1500000::\x15\x15@@@@@@@\x15\x15\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@:@::::@'
'@:@@00\x870\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000:::@@@@\x15\x15::::@@:@'
'@\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x870000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@@@::@:@'
'@\x87\x87\x870\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000@:@::@@@@@@:@\x15\x15\x15\x15\x15\x15\x15\x15'
'FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000\x15\x15\x15@@@::@@@@:@@@@@\x15\x15\x15\x15FFFFFFFFFFVV\x87\x87\x87\xc7'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1bFFFFFFFFFFVVVVVVVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ'
'JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ\x15\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15FFFFFFFFFF\x15\x15\x15\x15\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000000000000000\x15\x15@@@@@\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000@@@@@@@\x87\x87\x87\x87\x87\xc7\xc7\xc7\xc7'
'$$$$\x87\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15VVVVVVV\x15000000000000000000000\x15\x15\x15\x15\x15000'
'0000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150::::::::::::::::::::::::::::::::::::::::::::::\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@$$$$$$$$$$$$$\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'11\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x15\x15\x15\x15\x150000000000000\x15\x15\x15'
'000000000\x15\x15\x15\x15\x15\x15\x150000000000\x15\x15\xc7@@\x87\x08\x08\x08\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7::@@@\xc7\xc7\xc7::::::\x08\x08\x08\x08\x08\x08\x08\x08@@@@@'
'@@@\xc7\xc7@@@@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc@@@\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15VVVVVVVVVVVVVVVVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777'
'77777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777777777777777'
'77\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1577\x15\x157\x15\x1577\x15\x157777\x1577777777\x1b\x1b\x1b\x1b\x15\x1b\x15\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b77\x157777\x15\x1577777777\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x157777\x15'
'77777\x157\x15\x15\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777'
'777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777'
'7777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777'
'7777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777777777777777777777'
'7\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7\x1b\x15\x15DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc7\xc7\xc7\xc7@@@@@'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7@\xc7\xc7\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@\x15@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'33333\x15\x15^^^^^^^^^@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
',,,,\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15,,\x15,\x15\x15,\x15,,,,,,,,,,\x15,,,,\x15,\x15,\x15\x15\x15\x15'
'\x15\x15,\x15\x15\x15\x15,\x15,\x15,\x15,,,\x15,,\x15,\x15\x15,\x15,\x15,\x15,\x15,\x15,,\x15,\x15\x15,,,,\x15,,,,,,,\x15,,,,\x15,,,,\x15,\x15'
',,,,,,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15,,,\x15,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xb9\xb9\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'RRRRRRRRRRR[[\x15\x15\x15\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc7\x15\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc4\xc4\xc4\xc4\xc4\xc4\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xcc\xcc\x15\x15\x15\x15\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xa8\xa8\xa8\xa8\xa8'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1211111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111112111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111211111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111112111111111111111211111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111211'
'1111111111111111111111111211111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111112111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111112111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'11111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111\x16\x1611111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x15\x15'
'\x15\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x15'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
}

_decimal_corrected = {
178: None,
179: None,
185: None,
4969: None,
4970: None,
4971: None,
4972: None,
4973: None,
4974: None,
4975: None,
4976: None,
4977: None,
8304: None,
8308: None,
8309: None,
8310: None,
8311: None,
8312: None,
8313: None,
8320: None,
8321: None,
8322: None,
8323: None,
8324: None,
8325: None,
8326: None,
8327: None,
8328: None,
8329: None,
}
_digit = {
1984: 0,
1985: 1,
1986: 2,
1987: 3,
1988: 4,
1989: 5,
1990: 6,
1991: 7,
1992: 8,
1993: 9,
3046: 0,
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
4240: 0,
4241: 1,
4242: 2,
4243: 3,
4244: 4,
4245: 5,
4246: 6,
4247: 7,
4248: 8,
4249: 9,
6470: 0,
6471: 1,
6472: 2,
6473: 3,
6474: 4,
6475: 5,
6476: 6,
6477: 7,
6478: 8,
6479: 9,
6608: 0,
6609: 1,
6610: 2,
6611: 3,
6612: 4,
6613: 5,
6614: 6,
6615: 7,
6616: 8,
6617: 9,
6618: 1,
6784: 0,
6785: 1,
6786: 2,
6787: 3,
6788: 4,
6789: 5,
6790: 6,
6791: 7,
6792: 8,
6793: 9,
6800: 0,
6801: 1,
6802: 2,
6803: 3,
6804: 4,
6805: 5,
6806: 6,
6807: 7,
6808: 8,
6809: 9,
6992: 0,
6993: 1,
6994: 2,
6995: 3,
6996: 4,
6997: 5,
6998: 6,
6999: 7,
7000: 8,
7001: 9,
7088: 0,
7089: 1,
7090: 2,
7091: 3,
7092: 4,
7093: 5,
7094: 6,
7095: 7,
7096: 8,
7097: 9,
7232: 0,
7233: 1,
7234: 2,
7235: 3,
7236: 4,
7237: 5,
7238: 6,
7239: 7,
7240: 8,
7241: 9,
7248: 0,
7249: 1,
7250: 2,
7251: 3,
7252: 4,
7253: 5,
7254: 6,
7255: 7,
7256: 8,
7257: 9,
9471: 0,
42528: 0,
42529: 1,
42530: 2,
42531: 3,
42532: 4,
42533: 5,
42534: 6,
42535: 7,
42536: 8,
42537: 9,
43216: 0,
43217: 1,
43218: 2,
43219: 3,
43220: 4,
43221: 5,
43222: 6,
43223: 7,
43224: 8,
43225: 9,
43264: 0,
43265: 1,
43266: 2,
43267: 3,
43268: 4,
43269: 5,
43270: 6,
43271: 7,
43272: 8,
43273: 9,
43472: 0,
43473: 1,
43474: 2,
43475: 3,
43476: 4,
43477: 5,
43478: 6,
43479: 7,
43480: 8,
43481: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
43600: 0,
43601: 1,
43602: 2,
43603: 3,
43604: 4,
43605: 5,
43606: 6,
43607: 7,
43608: 8,
43609: 9,
44016: 0,
44017: 1,
44018: 2,
44019: 3,
44020: 4,
44021: 5,
44022: 6,
44023: 7,
44024: 8,
44025: 9,
66720: 0,
66721: 1,
66722: 2,
66723: 3,
66724: 4,
66725: 5,
66726: 6,
66727: 7,
66728: 8,
66729: 9,
68160: 1,
68161: 2,
68162: 3,
68163: 4,
69216: 1,
69217: 2,
69218: 3,
69219: 4,
69220: 5,
69221: 6,
69222: 7,
69223: 8,
69224: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
127232: 0,
127233: 0,
127234: 1,
127235: 2,
127236: 3,
127237: 4,
127238: 5,
127239: 6,
127240: 7,
127241: 8,
127242: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
1984: 0.0,
1985: 1.0,
1986: 2.0,
1987: 3.0,
1988: 4.0,
1989: 5.0,
1990: 6.0,
1991: 7.0,
1992: 8.0,
1993: 9.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3046: 0.0,
3192: 0.0,
3193: 1.0,
3194: 2.0,
3195: 3.0,
3196: 1.0,
3197: 2.0,
3198: 3.0,
3440: 10.0,
3441: 100.0,
3442: 1000.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3558: 0.0,
3559: 1.0,
3560: 2.0,
3561: 3.0,
3562: 4.0,
3563: 5.0,
3564: 6.0,
3565: 7.0,
3566: 8.0,
3567: 9.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
4240: 0.0,
4241: 1.0,
4242: 2.0,
4243: 3.0,
4244: 4.0,
4245: 5.0,
4246: 6.0,
4247: 7.0,
4248: 8.0,
4249: 9.0,
6128: 0.0,
6129: 1.0,
6130: 2.0,
6131: 3.0,
6132: 4.0,
6133: 5.0,
6134: 6.0,
6135: 7.0,
6136: 8.0,
6137: 9.0,
6470: 0.0,
6471: 1.0,
6472: 2.0,
6473: 3.0,
6474: 4.0,
6475: 5.0,
6476: 6.0,
6477: 7.0,
6478: 8.0,
6479: 9.0,
6608: 0.0,
6609: 1.0,
6610: 2.0,
6611: 3.0,
6612: 4.0,
6613: 5.0,
6614: 6.0,
6615: 7.0,
6616: 8.0,
6617: 9.0,
6618: 1.0,
6784: 0.0,
6785: 1.0,
6786: 2.0,
6787: 3.0,
6788: 4.0,
6789: 5.0,
6790: 6.0,
6791: 7.0,
6792: 8.0,
6793: 9.0,
6800: 0.0,
6801: 1.0,
6802: 2.0,
6803: 3.0,
6804: 4.0,
6805: 5.0,
6806: 6.0,
6807: 7.0,
6808: 8.0,
6809: 9.0,
6992: 0.0,
6993: 1.0,
6994: 2.0,
6995: 3.0,
6996: 4.0,
6997: 5.0,
6998: 6.0,
6999: 7.0,
7000: 8.0,
7001: 9.0,
7088: 0.0,
7089: 1.0,
7090: 2.0,
7091: 3.0,
7092: 4.0,
7093: 5.0,
7094: 6.0,
7095: 7.0,
7096: 8.0,
7097: 9.0,
7232: 0.0,
7233: 1.0,
7234: 2.0,
7235: 3.0,
7236: 4.0,
7237: 5.0,
7238: 6.0,
7239: 7.0,
7240: 8.0,
7241: 9.0,
7248: 0.0,
7249: 1.0,
7250: 2.0,
7251: 3.0,
7252: 4.0,
7253: 5.0,
7254: 6.0,
7255: 7.0,
7256: 8.0,
7257: 9.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
8581: 6.0,
8582: 50.0,
8583: 50000.0,
8584: 100000.0,
8585: 0.0,
9471: 0.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
13317: 5.0,
13443: 2.0,
14378: 5.0,
15181: 7.0,
20118: 4.0,
20160: 10.0,
20200: 3.0,
21316: 20.0,
21324: 40.0,
21444: 3.0,
24186: 1.0,
24318: 9.0,
28422: 7.0,
36019: 2.0,
38433: 1000.0,
42528: 0.0,
42529: 1.0,
42530: 2.0,
42531: 3.0,
42532: 4.0,
42533: 5.0,
42534: 6.0,
42535: 7.0,
42536: 8.0,
42537: 9.0,
42726: 1.0,
42727: 2.0,
42728: 3.0,
42729: 4.0,
42730: 5.0,
42731: 6.0,
42732: 7.0,
42733: 8.0,
42734: 9.0,
42735: 0.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43216: 0.0,
43217: 1.0,
43218: 2.0,
43219: 3.0,
43220: 4.0,
43221: 5.0,
43222: 6.0,
43223: 7.0,
43224: 8.0,
43225: 9.0,
43264: 0.0,
43265: 1.0,
43266: 2.0,
43267: 3.0,
43268: 4.0,
43269: 5.0,
43270: 6.0,
43271: 7.0,
43272: 8.0,
43273: 9.0,
43472: 0.0,
43473: 1.0,
43474: 2.0,
43475: 3.0,
43476: 4.0,
43477: 5.0,
43478: 6.0,
43479: 7.0,
43480: 8.0,
43481: 9.0,
43504: 0.0,
43505: 1.0,
43506: 2.0,
43507: 3.0,
43508: 4.0,
43509: 5.0,
43510: 6.0,
43511: 7.0,
43512: 8.0,
43513: 9.0,
43600: 0.0,
43601: 1.0,
43602: 2.0,
43603: 3.0,
43604: 4.0,
43605: 5.0,
43606: 6.0,
43607: 7.0,
43608: 8.0,
43609: 9.0,
44016: 0.0,
44017: 1.0,
44018: 2.0,
44019: 3.0,
44020: 4.0,
44021: 5.0,
44022: 6.0,
44023: 7.0,
44024: 8.0,
44025: 9.0,
63851: 3.0,
63859: 10.0,
63864: 2.0,
63922: 0.0,
63953: 6.0,
63955: 6.0,
63997: 10.0,
65799: 1.0,
65800: 2.0,
65801: 3.0,
65802: 4.0,
65803: 5.0,
65804: 6.0,
65805: 7.0,
65806: 8.0,
65807: 9.0,
65808: 10.0,
65809: 20.0,
65810: 30.0,
65811: 40.0,
65812: 50.0,
65813: 60.0,
65814: 70.0,
65815: 80.0,
65816: 90.0,
65817: 100.0,
65818: 200.0,
65819: 300.0,
65820: 400.0,
65821: 500.0,
65822: 600.0,
65823: 700.0,
65824: 800.0,
65825: 900.0,
65826: 1000.0,
65827: 2000.0,
65828: 3000.0,
65829: 4000.0,
65830: 5000.0,
65831: 6000.0,
65832: 7000.0,
65833: 8000.0,
65834: 9000.0,
65835: 10000.0,
65836: 20000.0,
65837: 30000.0,
65838: 40000.0,
65839: 50000.0,
65840: 60000.0,
65841: 70000.0,
65842: 80000.0,
65843: 90000.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65858: 1.0,
65859: 5.0,
65860: 50.0,
65861: 500.0,
65862: 5000.0,
65863: 50000.0,
65864: 5.0,
65865: 10.0,
65866: 50.0,
65867: 100.0,
65868: 500.0,
65869: 1000.0,
65870: 5000.0,
65871: 5.0,
65872: 10.0,
65873: 50.0,
65874: 100.0,
65875: 500.0,
65876: 1000.0,
65877: 10000.0,
65878: 50000.0,
65879: 10.0,
65880: 1.0,
65881: 1.0,
65882: 1.0,
65883: 2.0,
65884: 2.0,
65885: 2.0,
65886: 2.0,
65887: 5.0,
65888: 10.0,
65889: 10.0,
65890: 10.0,
65891: 10.0,
65892: 10.0,
65893: 30.0,
65894: 50.0,
65895: 50.0,
65896: 50.0,
65897: 50.0,
65898: 100.0,
65899: 300.0,
65900: 500.0,
65901: 500.0,
65902: 500.0,
65903: 500.0,
65904: 500.0,
65905: 1000.0,
65906: 5000.0,
65907: 5.0,
65908: 50.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65930: 0.0,
65931: 1.0 / 4.0,
66273: 1.0,
66274: 2.0,
66275: 3.0,
66276: 4.0,
66277: 5.0,
66278: 6.0,
66279: 7.0,
66280: 8.0,
66281: 9.0,
66282: 10.0,
66283: 20.0,
66284: 30.0,
66285: 40.0,
66286: 50.0,
66287: 60.0,
66288: 70.0,
66289: 80.0,
66290: 90.0,
66291: 100.0,
66292: 200.0,
66293: 300.0,
66294: 400.0,
66295: 500.0,
66296: 600.0,
66297: 700.0,
66298: 800.0,
66299: 900.0,
66369: 90.0,
66378: 900.0,
66513: 1.0,
66514: 2.0,
66515: 10.0,
66516: 20.0,
66517: 100.0,
66720: 0.0,
66721: 1.0,
66722: 2.0,
66723: 3.0,
66724: 4.0,
66725: 5.0,
66726: 6.0,
66727: 7.0,
66728: 8.0,
66729: 9.0,
67672: 1.0,
67673: 2.0,
67674: 3.0,
67675: 10.0,
67676: 20.0,
67677: 100.0,
67678: 1000.0,
67679: 10000.0,
67705: 1.0,
67706: 2.0,
67707: 3.0,
67708: 4.0,
67709: 5.0,
67710: 10.0,
67711: 20.0,
67751: 1.0,
67752: 2.0,
67753: 3.0,
67754: 4.0,
67755: 4.0,
67756: 5.0,
67757: 10.0,
67758: 20.0,
67759: 100.0,
67835: 1.0,
67836: 5.0,
67837: 10.0,
67838: 20.0,
67839: 100.0,
67862: 1.0,
67863: 10.0,
67864: 20.0,
67865: 100.0,
67866: 2.0,
67867: 3.0,
68028: 11.0 / 12.0,
68029: 1.0 / 2.0,
68032: 1.0,
68033: 2.0,
68034: 3.0,
68035: 4.0,
68036: 5.0,
68037: 6.0,
68038: 7.0,
68039: 8.0,
68040: 9.0,
68041: 10.0,
68042: 20.0,
68043: 30.0,
68044: 40.0,
68045: 50.0,
68046: 60.0,
68047: 70.0,
68050: 100.0,
68051: 200.0,
68052: 300.0,
68053: 400.0,
68054: 500.0,
68055: 600.0,
68056: 700.0,
68057: 800.0,
68058: 900.0,
68059: 1000.0,
68060: 2000.0,
68061: 3000.0,
68062: 4000.0,
68063: 5000.0,
68064: 6000.0,
68065: 7000.0,
68066: 8000.0,
68067: 9000.0,
68068: 10000.0,
68069: 20000.0,
68070: 30000.0,
68071: 40000.0,
68072: 50000.0,
68073: 60000.0,
68074: 70000.0,
68075: 80000.0,
68076: 90000.0,
68077: 100000.0,
68078: 200000.0,
68079: 300000.0,
68080: 400000.0,
68081: 500000.0,
68082: 600000.0,
68083: 700000.0,
68084: 800000.0,
68085: 900000.0,
68086: 1.0 / 12.0,
68087: 2.0 / 12.0,
68088: 3.0 / 12.0,
68089: 4.0 / 12.0,
68090: 5.0 / 12.0,
68091: 6.0 / 12.0,
68092: 7.0 / 12.0,
68093: 8.0 / 12.0,
68094: 9.0 / 12.0,
68095: 10.0 / 12.0,
68160: 1.0,
68161: 2.0,
68162: 3.0,
68163: 4.0,
68164: 10.0,
68165: 20.0,
68166: 100.0,
68167: 1000.0,
68221: 1.0,
68222: 50.0,
68253: 1.0,
68254: 10.0,
68255: 20.0,
68331: 1.0,
68332: 5.0,
68333: 10.0,
68334: 20.0,
68335: 100.0,
68440: 1.0,
68441: 2.0,
68442: 3.0,
68443: 4.0,
68444: 10.0,
68445: 20.0,
68446: 100.0,
68447: 1000.0,
68472: 1.0,
68473: 2.0,
68474: 3.0,
68475: 4.0,
68476: 10.0,
68477: 20.0,
68478: 100.0,
68479: 1000.0,
68521: 1.0,
68522: 2.0,
68523: 3.0,
68524: 4.0,
68525: 10.0,
68526: 20.0,
68527: 100.0,
68858: 1.0,
68859: 5.0,
68860: 10.0,
68861: 50.0,
68862: 100.0,
68863: 1000.0,
69216: 1.0,
69217: 2.0,
69218: 3.0,
69219: 4.0,
69220: 5.0,
69221: 6.0,
69222: 7.0,
69223: 8.0,
69224: 9.0,
69225: 10.0,
69226: 20.0,
69227: 30.0,
69228: 40.0,
69229: 50.0,
69230: 60.0,
69231: 70.0,
69232: 80.0,
69233: 90.0,
69234: 100.0,
69235: 200.0,
69236: 300.0,
69237: 400.0,
69238: 500.0,
69239: 600.0,
69240: 700.0,
69241: 800.0,
69242: 900.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
70113: 1.0,
70114: 2.0,
70115: 3.0,
70116: 4.0,
70117: 5.0,
70118: 6.0,
70119: 7.0,
70120: 8.0,
70121: 9.0,
70122: 10.0,
70123: 20.0,
70124: 30.0,
70125: 40.0,
70126: 50.0,
70127: 60.0,
70128: 70.0,
70129: 80.0,
70130: 90.0,
70131: 100.0,
70132: 1000.0,
70384: 0.0,
70385: 1.0,
70386: 2.0,
70387: 3.0,
70388: 4.0,
70389: 5.0,
70390: 6.0,
70391: 7.0,
70392: 8.0,
70393: 9.0,
70864: 0.0,
70865: 1.0,
70866: 2.0,
70867: 3.0,
70868: 4.0,
70869: 5.0,
70870: 6.0,
70871: 7.0,
70872: 8.0,
70873: 9.0,
71248: 0.0,
71249: 1.0,
71250: 2.0,
71251: 3.0,
71252: 4.0,
71253: 5.0,
71254: 6.0,
71255: 7.0,
71256: 8.0,
71257: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
71472: 0.0,
71473: 1.0,
71474: 2.0,
71475: 3.0,
71476: 4.0,
71477: 5.0,
71478: 6.0,
71479: 7.0,
71480: 8.0,
71481: 9.0,
71482: 10.0,
71483: 20.0,
71904: 0.0,
71905: 1.0,
71906: 2.0,
71907: 3.0,
71908: 4.0,
71909: 5.0,
71910: 6.0,
71911: 7.0,
71912: 8.0,
71913: 9.0,
71914: 10.0,
71915: 20.0,
71916: 30.0,
71917: 40.0,
71918: 50.0,
71919: 60.0,
71920: 70.0,
71921: 80.0,
71922: 90.0,
74752: 2.0,
74753: 3.0,
74754: 4.0,
74755: 5.0,
74756: 6.0,
74757: 7.0,
74758: 8.0,
74759: 9.0,
74760: 3.0,
74761: 4.0,
74762: 5.0,
74763: 6.0,
74764: 7.0,
74765: 8.0,
74766: 9.0,
74767: 4.0,
74768: 5.0,
74769: 6.0,
74770: 7.0,
74771: 8.0,
74772: 9.0,
74773: 1.0,
74774: 2.0,
74775: 3.0,
74776: 4.0,
74777: 5.0,
74778: 6.0,
74779: 7.0,
74780: 8.0,
74781: 9.0,
74782: 1.0,
74783: 2.0,
74784: 3.0,
74785: 4.0,
74786: 5.0,
74787: 2.0,
74788: 3.0,
74789: 3.0,
74790: 4.0,
74791: 5.0,
74792: 6.0,
74793: 7.0,
74794: 8.0,
74795: 9.0,
74796: 1.0,
74797: 2.0,
74798: 3.0,
74799: 3.0,
74800: 4.0,
74801: 5.0,
74802: 216000.0,
74803: 432000.0,
74804: 1.0,
74805: 2.0,
74806: 3.0,
74807: 3.0,
74808: 4.0,
74809: 5.0,
74810: 3.0,
74811: 3.0,
74812: 4.0,
74813: 4.0,
74814: 4.0,
74815: 4.0,
74816: 6.0,
74817: 7.0,
74818: 7.0,
74819: 7.0,
74820: 8.0,
74821: 8.0,
74822: 9.0,
74823: 9.0,
74824: 9.0,
74825: 9.0,
74826: 2.0,
74827: 3.0,
74828: 4.0,
74829: 5.0,
74830: 6.0,
74831: 1.0,
74832: 2.0,
74833: 3.0,
74834: 4.0,
74835: 4.0,
74836: 5.0,
74837: 5.0,
74838: 2.0,
74839: 3.0,
74840: 1.0,
74841: 2.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
74851: 1.0 / 4.0,
74852: 1.0 / 2.0,
74853: 1.0 / 3.0,
74854: 2.0 / 3.0,
74855: 40.0,
74856: 50.0,
74857: 4.0,
74858: 5.0,
74859: 6.0,
74860: 7.0,
74861: 8.0,
74862: 9.0,
92768: 0.0,
92769: 1.0,
92770: 2.0,
92771: 3.0,
92772: 4.0,
92773: 5.0,
92774: 6.0,
92775: 7.0,
92776: 8.0,
92777: 9.0,
93008: 0.0,
93009: 1.0,
93010: 2.0,
93011: 3.0,
93012: 4.0,
93013: 5.0,
93014: 6.0,
93015: 7.0,
93016: 8.0,
93017: 9.0,
93019: 10.0,
93020: 100.0,
93021: 10000.0,
93022: 1000000.0,
93023: 100000000.0,
93024: 10000000000.0,
93025: 1000000000000.0,
119648: 1.0,
119649: 2.0,
119650: 3.0,
119651: 4.0,
119652: 5.0,
119653: 6.0,
119654: 7.0,
119655: 8.0,
119656: 9.0,
119657: 10.0,
119658: 20.0,
119659: 30.0,
119660: 40.0,
119661: 50.0,
119662: 60.0,
119663: 70.0,
119664: 80.0,
119665: 90.0,
125127: 1.0,
125128: 2.0,
125129: 3.0,
125130: 4.0,
125131: 5.0,
125132: 6.0,
125133: 7.0,
125134: 8.0,
125135: 9.0,
127232: 0.0,
127233: 0.0,
127234: 1.0,
127235: 2.0,
127236: 3.0,
127237: 4.0,
127238: 5.0,
127239: 6.0,
127240: 7.0,
127241: 8.0,
127242: 9.0,
127243: 0.0,
127244: 0.0,
131073: 7.0,
131172: 4.0,
131298: 4.0,
131361: 5.0,
133418: 1.0,
133507: 30.0,
133516: 40.0,
133532: 40.0,
133866: 6.0,
133885: 3.0,
133913: 3.0,
140176: 2.0,
141720: 3.0,
146203: 3.0,
156269: 4.0,
194704: 9.0,
}

_numeric_corrected = {
20140: None,
22419: None,
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
384: 579,
410: 573,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
604: 42923,
609: 42924,
613: 42893,
614: 42922,
619: 11362,
620: 42925,
625: 11374,
637: 11364,
647: 42929,
649: 580,
652: 581,
669: 42930,
670: 42928,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1011: 895,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11507: 11506,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
11559: 4295,
11565: 4301,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42649: 42648,
42651: 42650,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66638: 66598,
66639: 66599,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
}

_toupper_corrected = {
}
_tolower = {
570: 11365,
571: 572,
573: 410,
574: 11366,
577: 578,
579: 384,
580: 649,
581: 652,
582: 583,
584: 585,
586: 587,
588: 589,
590: 591,
880: 881,
882: 883,
886: 887,
895: 1011,
975: 983,
1015: 1016,
1017: 1010,
1018: 1019,
1021: 891,
1022: 892,
1023: 893,
1216: 1231,
1270: 1271,
1274: 1275,
1276: 1277,
1278: 1279,
1296: 1297,
1298: 1299,
1300: 1301,
1302: 1303,
1304: 1305,
1306: 1307,
1308: 1309,
1310: 1311,
1312: 1313,
1314: 1315,
1316: 1317,
1318: 1319,
1320: 1321,
1322: 1323,
1324: 1325,
1326: 1327,
4256: 11520,
4257: 11521,
4258: 11522,
4259: 11523,
4260: 11524,
4261: 11525,
4262: 11526,
4263: 11527,
4264: 11528,
4265: 11529,
4266: 11530,
4267: 11531,
4268: 11532,
4269: 11533,
4270: 11534,
4271: 11535,
4272: 11536,
4273: 11537,
4274: 11538,
4275: 11539,
4276: 11540,
4277: 11541,
4278: 11542,
4279: 11543,
4280: 11544,
4281: 11545,
4282: 11546,
4283: 11547,
4284: 11548,
4285: 11549,
4286: 11550,
4287: 11551,
4288: 11552,
4289: 11553,
4290: 11554,
4291: 11555,
4292: 11556,
4293: 11557,
4295: 11559,
4301: 11565,
5024: 43888,
5025: 43889,
5026: 43890,
5027: 43891,
5028: 43892,
5029: 43893,
5030: 43894,
5031: 43895,
5032: 43896,
5033: 43897,
5034: 43898,
5035: 43899,
5036: 43900,
5037: 43901,
5038: 43902,
5039: 43903,
5040: 43904,
5041: 43905,
5042: 43906,
5043: 43907,
5044: 43908,
5045: 43909,
5046: 43910,
5047: 43911,
5048: 43912,
5049: 43913,
5050: 43914,
5051: 43915,
5052: 43916,
5053: 43917,
5054: 43918,
5055: 43919,
5056: 43920,
5057: 43921,
5058: 43922,
5059: 43923,
5060: 43924,
5061: 43925,
5062: 43926,
5063: 43927,
5064: 43928,
5065: 43929,
5066: 43930,
5067: 43931,
5068: 43932,
5069: 43933,
5070: 43934,
5071: 43935,
5072: 43936,
5073: 43937,
5074: 43938,
5075: 43939,
5076: 43940,
5077: 43941,
5078: 43942,
5079: 43943,
5080: 43944,
5081: 43945,
5082: 43946,
5083: 43947,
5084: 43948,
5085: 43949,
5086: 43950,
5087: 43951,
5088: 43952,
5089: 43953,
5090: 43954,
5091: 43955,
5092: 43956,
5093: 43957,
5094: 43958,
5095: 43959,
5096: 43960,
5097: 43961,
5098: 43962,
5099: 43963,
5100: 43964,
5101: 43965,
5102: 43966,
5103: 43967,
5104: 5112,
5105: 5113,
5106: 5114,
5107: 5115,
5108: 5116,
5109: 5117,
7838: 223,
7930: 7931,
7932: 7933,
7934: 7935,
8498: 8526,
8579: 8580,
11264: 11312,
11265: 11313,
11266: 11314,
11267: 11315,
11268: 11316,
11269: 11317,
11270: 11318,
11271: 11319,
11272: 11320,
11273: 11321,
11274: 11322,
11275: 11323,
11276: 11324,
11277: 11325,
11278: 11326,
11279: 11327,
11280: 11328,
11281: 11329,
11282: 11330,
11283: 11331,
11284: 11332,
11285: 11333,
11286: 11334,
11287: 11335,
11288: 11336,
11289: 11337,
11290: 11338,
11291: 11339,
11292: 11340,
11293: 11341,
11294: 11342,
11295: 11343,
11296: 11344,
11297: 11345,
11298: 11346,
11299: 11347,
11300: 11348,
11301: 11349,
11302: 11350,
11303: 11351,
11304: 11352,
11305: 11353,
11306: 11354,
11307: 11355,
11308: 11356,
11309: 11357,
11310: 11358,
11360: 11361,
11362: 619,
11363: 7549,
11364: 637,
11367: 11368,
11369: 11370,
11371: 11372,
11373: 593,
11374: 625,
11375: 592,
11376: 594,
11378: 11379,
11381: 11382,
11390: 575,
11391: 576,
11392: 11393,
11394: 11395,
11396: 11397,
11398: 11399,
11400: 11401,
11402: 11403,
11404: 11405,
11406: 11407,
11408: 11409,
11410: 11411,
11412: 11413,
11414: 11415,
11416: 11417,
11418: 11419,
11420: 11421,
11422: 11423,
11424: 11425,
11426: 11427,
11428: 11429,
11430: 11431,
11432: 11433,
11434: 11435,
11436: 11437,
11438: 11439,
11440: 11441,
11442: 11443,
11444: 11445,
11446: 11447,
11448: 11449,
11450: 11451,
11452: 11453,
11454: 11455,
11456: 11457,
11458: 11459,
11460: 11461,
11462: 11463,
11464: 11465,
11466: 11467,
11468: 11469,
11470: 11471,
11472: 11473,
11474: 11475,
11476: 11477,
11478: 11479,
11480: 11481,
11482: 11483,
11484: 11485,
11486: 11487,
11488: 11489,
11490: 11491,
11499: 11500,
11501: 11502,
11506: 11507,
42560: 42561,
42562: 42563,
42564: 42565,
42566: 42567,
42568: 42569,
42570: 42571,
42572: 42573,
42574: 42575,
42576: 42577,
42578: 42579,
42580: 42581,
42582: 42583,
42584: 42585,
42586: 42587,
42588: 42589,
42590: 42591,
42592: 42593,
42594: 42595,
42596: 42597,
42598: 42599,
42600: 42601,
42602: 42603,
42604: 42605,
42624: 42625,
42626: 42627,
42628: 42629,
42630: 42631,
42632: 42633,
42634: 42635,
42636: 42637,
42638: 42639,
42640: 42641,
42642: 42643,
42644: 42645,
42646: 42647,
42648: 42649,
42650: 42651,
42786: 42787,
42788: 42789,
42790: 42791,
42792: 42793,
42794: 42795,
42796: 42797,
42798: 42799,
42802: 42803,
42804: 42805,
42806: 42807,
42808: 42809,
42810: 42811,
42812: 42813,
42814: 42815,
42816: 42817,
42818: 42819,
42820: 42821,
42822: 42823,
42824: 42825,
42826: 42827,
42828: 42829,
42830: 42831,
42832: 42833,
42834: 42835,
42836: 42837,
42838: 42839,
42840: 42841,
42842: 42843,
42844: 42845,
42846: 42847,
42848: 42849,
42850: 42851,
42852: 42853,
42854: 42855,
42856: 42857,
42858: 42859,
42860: 42861,
42862: 42863,
42873: 42874,
42875: 42876,
42877: 7545,
42878: 42879,
42880: 42881,
42882: 42883,
42884: 42885,
42886: 42887,
42891: 42892,
42893: 613,
42896: 42897,
42898: 42899,
42902: 42903,
42904: 42905,
42906: 42907,
42908: 42909,
42910: 42911,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
42923: 604,
42924: 609,
42925: 620,
42928: 670,
42929: 647,
42930: 669,
42931: 43859,
42932: 42933,
42934: 42935,
66598: 66638,
66599: 66639,
68736: 68800,
68737: 68801,
68738: 68802,
68739: 68803,
68740: 68804,
68741: 68805,
68742: 68806,
68743: 68807,
68744: 68808,
68745: 68809,
68746: 68810,
68747: 68811,
68748: 68812,
68749: 68813,
68750: 68814,
68751: 68815,
68752: 68816,
68753: 68817,
68754: 68818,
68755: 68819,
68756: 68820,
68757: 68821,
68758: 68822,
68759: 68823,
68760: 68824,
68761: 68825,
68762: 68826,
68763: 68827,
68764: 68828,
68765: 68829,
68766: 68830,
68767: 68831,
68768: 68832,
68769: 68833,
68770: 68834,
68771: 68835,
68772: 68836,
68773: 68837,
68774: 68838,
68775: 68839,
68776: 68840,
68777: 68841,
68778: 68842,
68779: 68843,
68780: 68844,
68781: 68845,
68782: 68846,
68783: 68847,
68784: 68848,
68785: 68849,
68786: 68850,
71840: 71872,
71841: 71873,
71842: 71874,
71843: 71875,
71844: 71876,
71845: 71877,
71846: 71878,
71847: 71879,
71848: 71880,
71849: 71881,
71850: 71882,
71851: 71883,
71852: 71884,
71853: 71885,
71854: 71886,
71855: 71887,
71856: 71888,
71857: 71889,
71858: 71890,
71859: 71891,
71860: 71892,
71861: 71893,
71862: 71894,
71863: 71895,
71864: 71896,
71865: 71897,
71866: 71898,
71867: 71899,
71868: 71900,
71869: 71901,
71870: 71902,
71871: 71903,
}

_tolower_corrected = {
}
_totitle = {
384: 579,
410: 573,
453: 453,
456: 456,
459: 459,
498: 498,
572: 571,
575: 11390,
576: 11391,
578: 577,
583: 582,
585: 584,
587: 586,
589: 588,
591: 590,
592: 11375,
593: 11373,
594: 11376,
604: 42923,
609: 42924,
613: 42893,
614: 42922,
619: 11362,
620: 42925,
625: 11374,
637: 11364,
647: 42929,
649: 580,
652: 581,
669: 42930,
670: 42928,
881: 880,
883: 882,
887: 886,
891: 1021,
892: 1022,
893: 1023,
983: 975,
1010: 1017,
1011: 895,
1016: 1015,
1019: 1018,
1231: 1216,
1271: 1270,
1275: 1274,
1277: 1276,
1279: 1278,
1297: 1296,
1299: 1298,
1301: 1300,
1303: 1302,
1305: 1304,
1307: 1306,
1309: 1308,
1311: 1310,
1313: 1312,
1315: 1314,
1317: 1316,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7545: 42877,
7549: 11363,
7931: 7930,
7933: 7932,
7935: 7934,
8526: 8498,
8580: 8579,
11312: 11264,
11313: 11265,
11314: 11266,
11315: 11267,
11316: 11268,
11317: 11269,
11318: 11270,
11319: 11271,
11320: 11272,
11321: 11273,
11322: 11274,
11323: 11275,
11324: 11276,
11325: 11277,
11326: 11278,
11327: 11279,
11328: 11280,
11329: 11281,
11330: 11282,
11331: 11283,
11332: 11284,
11333: 11285,
11334: 11286,
11335: 11287,
11336: 11288,
11337: 11289,
11338: 11290,
11339: 11291,
11340: 11292,
11341: 11293,
11342: 11294,
11343: 11295,
11344: 11296,
11345: 11297,
11346: 11298,
11347: 11299,
11348: 11300,
11349: 11301,
11350: 11302,
11351: 11303,
11352: 11304,
11353: 11305,
11354: 11306,
11355: 11307,
11356: 11308,
11357: 11309,
11358: 11310,
11361: 11360,
11365: 570,
11366: 574,
11368: 11367,
11370: 11369,
11372: 11371,
11379: 11378,
11382: 11381,
11393: 11392,
11395: 11394,
11397: 11396,
11399: 11398,
11401: 11400,
11403: 11402,
11405: 11404,
11407: 11406,
11409: 11408,
11411: 11410,
11413: 11412,
11415: 11414,
11417: 11416,
11419: 11418,
11421: 11420,
11423: 11422,
11425: 11424,
11427: 11426,
11429: 11428,
11431: 11430,
11433: 11432,
11435: 11434,
11437: 11436,
11439: 11438,
11441: 11440,
11443: 11442,
11445: 11444,
11447: 11446,
11449: 11448,
11451: 11450,
11453: 11452,
11455: 11454,
11457: 11456,
11459: 11458,
11461: 11460,
11463: 11462,
11465: 11464,
11467: 11466,
11469: 11468,
11471: 11470,
11473: 11472,
11475: 11474,
11477: 11476,
11479: 11478,
11481: 11480,
11483: 11482,
11485: 11484,
11487: 11486,
11489: 11488,
11491: 11490,
11500: 11499,
11502: 11501,
11507: 11506,
11520: 4256,
11521: 4257,
11522: 4258,
11523: 4259,
11524: 4260,
11525: 4261,
11526: 4262,
11527: 4263,
11528: 4264,
11529: 4265,
11530: 4266,
11531: 4267,
11532: 4268,
11533: 4269,
11534: 4270,
11535: 4271,
11536: 4272,
11537: 4273,
11538: 4274,
11539: 4275,
11540: 4276,
11541: 4277,
11542: 4278,
11543: 4279,
11544: 4280,
11545: 4281,
11546: 4282,
11547: 4283,
11548: 4284,
11549: 4285,
11550: 4286,
11551: 4287,
11552: 4288,
11553: 4289,
11554: 4290,
11555: 4291,
11556: 4292,
11557: 4293,
11559: 4295,
11565: 4301,
42561: 42560,
42563: 42562,
42565: 42564,
42567: 42566,
42569: 42568,
42571: 42570,
42573: 42572,
42575: 42574,
42577: 42576,
42579: 42578,
42581: 42580,
42583: 42582,
42585: 42584,
42587: 42586,
42589: 42588,
42591: 42590,
42593: 42592,
42595: 42594,
42597: 42596,
42599: 42598,
42601: 42600,
42603: 42602,
42605: 42604,
42625: 42624,
42627: 42626,
42629: 42628,
42631: 42630,
42633: 42632,
42635: 42634,
42637: 42636,
42639: 42638,
42641: 42640,
42643: 42642,
42645: 42644,
42647: 42646,
42649: 42648,
42651: 42650,
42787: 42786,
42789: 42788,
42791: 42790,
42793: 42792,
42795: 42794,
42797: 42796,
42799: 42798,
42803: 42802,
42805: 42804,
42807: 42806,
42809: 42808,
42811: 42810,
42813: 42812,
42815: 42814,
42817: 42816,
42819: 42818,
42821: 42820,
42823: 42822,
42825: 42824,
42827: 42826,
42829: 42828,
42831: 42830,
42833: 42832,
42835: 42834,
42837: 42836,
42839: 42838,
42841: 42840,
42843: 42842,
42845: 42844,
42847: 42846,
42849: 42848,
42851: 42850,
42853: 42852,
42855: 42854,
42857: 42856,
42859: 42858,
42861: 42860,
42863: 42862,
42874: 42873,
42876: 42875,
42879: 42878,
42881: 42880,
42883: 42882,
42885: 42884,
42887: 42886,
42892: 42891,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66638: 66598,
66639: 66599,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
}

_totitle_corrected = {
}
_special_casing = {
223: ([223], [83, 115], [83, 83]),
304: ([105, 775], [304], [304]),
329: ([329], [700, 78], [700, 78]),
496: ([496], [74, 780], [74, 780]),
912: ([912], [921, 776, 769], [921, 776, 769]),
944: ([944], [933, 776, 769], [933, 776, 769]),
1415: ([1415], [1333, 1410], [1333, 1362]),
7830: ([7830], [72, 817], [72, 817]),
7831: ([7831], [84, 776], [84, 776]),
7832: ([7832], [87, 778], [87, 778]),
7833: ([7833], [89, 778], [89, 778]),
7834: ([7834], [65, 702], [65, 702]),
8016: ([8016], [933, 787], [933, 787]),
8018: ([8018], [933, 787, 768], [933, 787, 768]),
8020: ([8020], [933, 787, 769], [933, 787, 769]),
8022: ([8022], [933, 787, 834], [933, 787, 834]),
8064: ([8064], [8072], [7944, 921]),
8065: ([8065], [8073], [7945, 921]),
8066: ([8066], [8074], [7946, 921]),
8067: ([8067], [8075], [7947, 921]),
8068: ([8068], [8076], [7948, 921]),
8069: ([8069], [8077], [7949, 921]),
8070: ([8070], [8078], [7950, 921]),
8071: ([8071], [8079], [7951, 921]),
8072: ([8064], [8072], [7944, 921]),
8073: ([8065], [8073], [7945, 921]),
8074: ([8066], [8074], [7946, 921]),
8075: ([8067], [8075], [7947, 921]),
8076: ([8068], [8076], [7948, 921]),
8077: ([8069], [8077], [7949, 921]),
8078: ([8070], [8078], [7950, 921]),
8079: ([8071], [8079], [7951, 921]),
8080: ([8080], [8088], [7976, 921]),
8081: ([8081], [8089], [7977, 921]),
8082: ([8082], [8090], [7978, 921]),
8083: ([8083], [8091], [7979, 921]),
8084: ([8084], [8092], [7980, 921]),
8085: ([8085], [8093], [7981, 921]),
8086: ([8086], [8094], [7982, 921]),
8087: ([8087], [8095], [7983, 921]),
8088: ([8080], [8088], [7976, 921]),
8089: ([8081], [8089], [7977, 921]),
8090: ([8082], [8090], [7978, 921]),
8091: ([8083], [8091], [7979, 921]),
8092: ([8084], [8092], [7980, 921]),
8093: ([8085], [8093], [7981, 921]),
8094: ([8086], [8094], [7982, 921]),
8095: ([8087], [8095], [7983, 921]),
8096: ([8096], [8104], [8040, 921]),
8097: ([8097], [8105], [8041, 921]),
8098: ([8098], [8106], [8042, 921]),
8099: ([8099], [8107], [8043, 921]),
8100: ([8100], [8108], [8044, 921]),
8101: ([8101], [8109], [8045, 921]),
8102: ([8102], [8110], [8046, 921]),
8103: ([8103], [8111], [8047, 921]),
8104: ([8096], [8104], [8040, 921]),
8105: ([8097], [8105], [8041, 921]),
8106: ([8098], [8106], [8042, 921]),
8107: ([8099], [8107], [8043, 921]),
8108: ([8100], [8108], [8044, 921]),
8109: ([8101], [8109], [8045, 921]),
8110: ([8102], [8110], [8046, 921]),
8111: ([8103], [8111], [8047, 921]),
8114: ([8114], [8122, 837], [8122, 921]),
8115: ([8115], [8124], [913, 921]),
8116: ([8116], [902, 837], [902, 921]),
8118: ([8118], [913, 834], [913, 834]),
8119: ([8119], [913, 834, 837], [913, 834, 921]),
8124: ([8115], [8124], [913, 921]),
8130: ([8130], [8138, 837], [8138, 921]),
8131: ([8131], [8140], [919, 921]),
8132: ([8132], [905, 837], [905, 921]),
8134: ([8134], [919, 834], [919, 834]),
8135: ([8135], [919, 834, 837], [919, 834, 921]),
8140: ([8131], [8140], [919, 921]),
8146: ([8146], [921, 776, 768], [921, 776, 768]),
8147: ([8147], [921, 776, 769], [921, 776, 769]),
8150: ([8150], [921, 834], [921, 834]),
8151: ([8151], [921, 776, 834], [921, 776, 834]),
8162: ([8162], [933, 776, 768], [933, 776, 768]),
8163: ([8163], [933, 776, 769], [933, 776, 769]),
8164: ([8164], [929, 787], [929, 787]),
8166: ([8166], [933, 834], [933, 834]),
8167: ([8167], [933, 776, 834], [933, 776, 834]),
8178: ([8178], [8186, 837], [8186, 921]),
8179: ([8179], [8188], [937, 921]),
8180: ([8180], [911, 837], [911, 921]),
8182: ([8182], [937, 834], [937, 834]),
8183: ([8183], [937, 834, 837], [937, 834, 921]),
8188: ([8179], [8188], [937, 921]),
64256: ([64256], [70, 102], [70, 70]),
64257: ([64257], [70, 105], [70, 73]),
64258: ([64258], [70, 108], [70, 76]),
64259: ([64259], [70, 102, 105], [70, 70, 73]),
64260: ([64260], [70, 102, 108], [70, 70, 76]),
64261: ([64261], [83, 116], [83, 84]),
64262: ([64262], [83, 116], [83, 84]),
64275: ([64275], [1348, 1398], [1348, 1350]),
64276: ([64276], [1348, 1381], [1348, 1333]),
64277: ([64277], [1348, 1387], [1348, 1339]),
64278: ([64278], [1358, 1398], [1358, 1350]),
64279: ([64279], [1348, 1389], [1348, 1341]),
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
1017: '<compat> 03A3',
4348: '<super> 10DC',
6918: '1B05 1B35',
6920: '1B07 1B35',
6922: '1B09 1B35',
6924: '1B0B 1B35',
6926: '1B0D 1B35',
6930: '1B11 1B35',
6971: '1B3A 1B35',
6973: '1B3C 1B35',
6976: '1B3E 1B35',
6977: '1B3F 1B35',
6979: '1B42 1B35',
7468: '<super> 0041',
7469: '<super> 00C6',
7470: '<super> 0042',
7472: '<super> 0044',
7473: '<super> 0045',
7474: '<super> 018E',
7475: '<super> 0047',
7476: '<super> 0048',
7477: '<super> 0049',
7478: '<super> 004A',
7479: '<super> 004B',
7480: '<super> 004C',
7481: '<super> 004D',
7482: '<super> 004E',
7484: '<super> 004F',
7485: '<super> 0222',
7486: '<super> 0050',
7487: '<super> 0052',
7488: '<super> 0054',
7489: '<super> 0055',
7490: '<super> 0057',
7491: '<super> 0061',
7492: '<super> 0250',
7493: '<super> 0251',
7494: '<super> 1D02',
7495: '<super> 0062',
7496: '<super> 0064',
7497: '<super> 0065',
7498: '<super> 0259',
7499: '<super> 025B',
7500: '<super> 025C',
7501: '<super> 0067',
7503: '<super> 006B',
7504: '<super> 006D',
7505: '<super> 014B',
7506: '<super> 006F',
7507: '<super> 0254',
7508: '<super> 1D16',
7509: '<super> 1D17',
7510: '<super> 0070',
7511: '<super> 0074',
7512: '<super> 0075',
7513: '<super> 1D1D',
7514: '<super> 026F',
7515: '<super> 0076',
7516: '<super> 1D25',
7517: '<super> 03B2',
7518: '<super> 03B3',
7519: '<super> 03B4',
7520: '<super> 03C6',
7521: '<super> 03C7',
7522: '<sub> 0069',
7523: '<sub> 0072',
7524: '<sub> 0075',
7525: '<sub> 0076',
7526: '<sub> 03B2',
7527: '<sub> 03B3',
7528: '<sub> 03C1',
7529: '<sub> 03C6',
7530: '<sub> 03C7',
7544: '<super> 043D',
7579: '<super> 0252',
7580: '<super> 0063',
7581: '<super> 0255',
7582: '<super> 00F0',
7583: '<super> 025C',
7584: '<super> 0066',
7585: '<super> 025F',
7586: '<super> 0261',
7587: '<super> 0265',
7588: '<super> 0268',
7589: '<super> 0269',
7590: '<super> 026A',
7591: '<super> 1D7B',
7592: '<super> 029D',
7593: '<super> 026D',
7594: '<super> 1D85',
7595: '<super> 029F',
7596: '<super> 0271',
7597: '<super> 0270',
7598: '<super> 0272',
7599: '<super> 0273',
7600: '<super> 0274',
7601: '<super> 0275',
7602: '<super> 0278',
7603: '<super> 0282',
7604: '<super> 0283',
7605: '<super> 01AB',
7606: '<super> 0289',
7607: '<super> 028A',
7608: '<super> 1D1C',
7609: '<super> 028B',
7610: '<super> 028C',
7611: '<super> 007A',
7612: '<super> 0290',
7613: '<super> 0291',
7614: '<super> 0292',
7615: '<super> 03B8',
8336: '<sub> 0061',
8337: '<sub> 0065',
8338: '<sub> 006F',
8339: '<sub> 0078',
8340: '<sub> 0259',
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
8507: '<compat> 0046 0041 0058',
8508: '<font> 03C0',
8528: '<fraction> 0031 2044 0037',
8529: '<fraction> 0031 2044 0039',
8530: '<fraction> 0031 2044 0031 0030',
8585: '<fraction> 0030 2044 0033',
11388: '<sub> 006A',
11389: '<super> 0056',
11631: '<super> 2D61',
12829: '<compat> 0028 110B 1169 110C 1165 11AB 0029',
12830: '<compat> 0028 110B 1169 1112 116E 0029',
12868: '<circle> 554F',
12869: '<circle> 5E7C',
12870: '<circle> 6587',
12871: '<circle> 7B8F',
12880: '<square> 0050 0054 0045',
12924: '<circle> 110E 1161 11B7 1100 1169',
12925: '<circle> 110C 116E 110B 1174',
12926: '<circle> 110B 116E',
13004: '<square> 0048 0067',
13005: '<square> 0065 0072 0067',
13006: '<square> 0065 0056',
13007: '<square> 004C 0054 0044',
13175: '<square> 0064 006D',
13176: '<square> 0064 006D 00B2',
13177: '<square> 0064 006D 00B3',
13178: '<square> 0049 0055',
13278: '<square> 0056 2215 006D',
13279: '<square> 0041 2215 006D',
13311: '<square> 0067 0061 006C',
42652: '<super> 044A',
42653: '<super> 044C',
42864: '<super> A76F',
43000: '<super> 0126',
43001: '<super> 0153',
43868: '<super> A727',
43869: '<super> AB37',
43870: '<super> 026B',
43871: '<super> AB52',
64046: '90DE',
64047: '96B7',
64107: '6075',
64108: '242EE',
64109: '8218',
64112: '4E26',
64113: '51B5',
64114: '5168',
64115: '4F80',
64116: '5145',
64117: '5180',
64118: '52C7',
64119: '52FA',
64120: '559D',
64121: '5555',
64122: '5599',
64123: '55E2',
64124: '585A',
64125: '58B3',
64126: '5944',
64127: '5954',
64128: '5A62',
64129: '5B28',
64130: '5ED2',
64131: '5ED9',
64132: '5F69',
64133: '5FAD',
64134: '60D8',
64135: '614E',
64136: '6108',
64137: '618E',
64138: '6160',
64139: '61F2',
64140: '6234',
64141: '63C4',
64142: '641C',
64143: '6452',
64144: '6556',
64145: '6674',
64146: '6717',
64147: '671B',
64148: '6756',
64149: '6B79',
64150: '6BBA',
64151: '6D41',
64152: '6EDB',
64153: '6ECB',
64154: '6F22',
64155: '701E',
64156: '716E',
64157: '77A7',
64158: '7235',
64159: '72AF',
64160: '732A',
64161: '7471',
64162: '7506',
64163: '753B',
64164: '761D',
64165: '761F',
64166: '76CA',
64167: '76DB',
64168: '76F4',
64169: '774A',
64170: '7740',
64171: '78CC',
64172: '7AB1',
64173: '7BC0',
64174: '7C7B',
64175: '7D5B',
64176: '7DF4',
64177: '7F3E',
64178: '8005',
64179: '8352',
64180: '83EF',
64181: '8779',
64182: '8941',
64183: '8986',
64184: '8996',
64185: '8ABF',
64186: '8AF8',
64187: '8ACB',
64188: '8B01',
64189: '8AFE',
64190: '8AED',
64191: '8B39',
64192: '8B8A',
64193: '8D08',
64194: '8F38',
64195: '9072',
64196: '9199',
64197: '9276',
64198: '967C',
64199: '96E3',
64200: '9756',
64201: '97DB',
64202: '97FF',
64203: '980B',
64204: '983B',
64205: '9B12',
64206: '9F9C',
64207: '2284A',
64208: '22844',
64209: '233D5',
64210: '3B9D',
64211: '4018',
64212: '4039',
64213: '25249',
64214: '25CD0',
64215: '27ED3',
64216: '9F43',
64217: '9F8E',
65040: '<vertical> 002C',
65041: '<vertical> 3001',
65042: '<vertical> 3002',
65043: '<vertical> 003A',
65044: '<vertical> 003B',
65045: '<vertical> 0021',
65046: '<vertical> 003F',
65047: '<vertical> 3016',
65048: '<vertical> 3017',
65049: '<vertical> 2026',
65095: '<vertical> 005B',
65096: '<vertical> 005D',
69786: '11099 110BA',
69788: '1109B 110BA',
69803: '110A5 110BA',
69934: '11131 11127',
69935: '11132 11127',
70475: '11347 1133E',
70476: '11347 11357',
70843: '114B9 114BA',
70844: '114B9 114B0',
70846: '114B9 114BD',
71098: '115B8 115AF',
71099: '115B9 115AF',
120001: '<font> 006C',
120484: '<font> 0131',
120485: '<font> 0237',
120778: '<font> 03DC',
120779: '<font> 03DD',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127232: '<compat> 0030 002E',
127233: '<compat> 0030 002C',
127234: '<compat> 0031 002C',
127235: '<compat> 0032 002C',
127236: '<compat> 0033 002C',
127237: '<compat> 0034 002C',
127238: '<compat> 0035 002C',
127239: '<compat> 0036 002C',
127240: '<compat> 0037 002C',
127241: '<compat> 0038 002C',
127242: '<compat> 0039 002C',
127248: '<compat> 0028 0041 0029',
127249: '<compat> 0028 0042 0029',
127250: '<compat> 0028 0043 0029',
127251: '<compat> 0028 0044 0029',
127252: '<compat> 0028 0045 0029',
127253: '<compat> 0028 0046 0029',
127254: '<compat> 0028 0047 0029',
127255: '<compat> 0028 0048 0029',
127256: '<compat> 0028 0049 0029',
127257: '<compat> 0028 004A 0029',
127258: '<compat> 0028 004B 0029',
127259: '<compat> 0028 004C 0029',
127260: '<compat> 0028 004D 0029',
127261: '<compat> 0028 004E 0029',
127262: '<compat> 0028 004F 0029',
127263: '<compat> 0028 0050 0029',
127264: '<compat> 0028 0051 0029',
127265: '<compat> 0028 0052 0029',
127266: '<compat> 0028 0053 0029',
127267: '<compat> 0028 0054 0029',
127268: '<compat> 0028 0055 0029',
127269: '<compat> 0028 0056 0029',
127270: '<compat> 0028 0057 0029',
127271: '<compat> 0028 0058 0029',
127272: '<compat> 0028 0059 0029',
127273: '<compat> 0028 005A 0029',
127274: '<compat> 3014 0053 3015',
127275: '<circle> 0043',
127276: '<circle> 0052',
127277: '<circle> 0043 0044',
127278: '<circle> 0057 005A',
127280: '<square> 0041',
127281: '<square> 0042',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127293: '<square> 004E',
127294: '<square> 004F',
127295: '<square> 0050',
127296: '<square> 0051',
127297: '<square> 0052',
127298: '<square> 0053',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127302: '<square> 0057',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127306: '<square> 0048 0056',
127307: '<square> 004D 0056',
127308: '<square> 0053 0044',
127309: '<square> 0053 0053',
127310: '<square> 0050 0050 0056',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127376: '<square> 0044 004A',
127488: '<square> 307B 304B',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127504: '<square> 624B',
127505: '<square> 5B57',
127506: '<square> 53CC',
127507: '<square> 30C7',
127508: '<square> 4E8C',
127509: '<square> 591A',
127510: '<square> 89E3',
127511: '<square> 5929',
127512: '<square> 4EA4',
127513: '<square> 6620',
127514: '<square> 7121',
127515: '<square> 6599',
127516: '<square> 524D',
127517: '<square> 5F8C',
127518: '<square> 518D',
127519: '<square> 65B0',
127520: '<square> 521D',
127521: '<square> 7D42',
127522: '<square> 751F',
127523: '<square> 8CA9',
127524: '<square> 58F0',
127525: '<square> 5439',
127526: '<square> 6F14',
127527: '<square> 6295',
127528: '<square> 6355',
127529: '<square> 4E00',
127530: '<square> 4E09',
127531: '<square> 904A',
127532: '<square> 5DE6',
127533: '<square> 4E2D',
127534: '<square> 53F3',
127535: '<square> 6307',
127536: '<square> 8D70',
127537: '<square> 6253',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127552: '<compat> 3014 672C 3015',
127553: '<compat> 3014 4E09 3015',
127554: '<compat> 3014 4E8C 3015',
127555: '<compat> 3014 5B89 3015',
127556: '<compat> 3014 70B9 3015',
127557: '<compat> 3014 6253 3015',
127558: '<compat> 3014 76D7 3015',
127559: '<compat> 3014 52DD 3015',
127560: '<compat> 3014 6557 3015',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
194664: '36FC',
194676: '5F53',
194847: '243AB',
194911: '7AEE',
195007: '45D7',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   